
clear
set mem 10m
set more off

log using Estimate_BaselineECM_psid, text replace

local path ../../../Data


********************************************************************************
* Parameters
********************************************************************************

* Say, years OBSERVED: 1987-2008
local year1 = 1987
local year2 = 1988
local yearT = 2008

local cohort1 = 1952   /* first cohort */
local cohortT = 2008   /* last cohort */


****************************************************************************************************************
****************************************************************************************************************
*************************************** Read Covariance Data ***************************************************
****************************************************************************************************************
****************************************************************************************************************

********** PSID data **********

 use  `path'/CovsData_PSID_labinc_CAL.dta, clear
*use  `path'/CovsData_PSID_faminc_CAL.dta, clear

summ
more

* Arrange data

drop if (covvar==.)
***drop if (wgtvar==0)
***drop if (wgtvar==.)

* Drop if too few observations were used to compute sample covariance

***drop if (jvar>10)
***drop if (wgtvar<100)
more

* Create dummy variable Dj0, which equals 1 if jvar==0 and equals 0 otherwise

gen Dj0=0
replace Dj0=1 if (jvar==0)

********************************************************************************
* Pick observations used for estimation
********************************************************************************

gen cohort = yrvar - hvar + 1

keep if (cohort>=`cohort1' & cohort<=`cohortT')

keep if (yrvar>=`year1' & yrvar<=`yearT')

* Make sure that "future" years used to compute autocovariances do not fall 
* outside of [year1,yearT] range:

gen yearpj = (cohort-1) + hvar + jvar  /* identical to setting yearpj = year + jvar */

keep if (yearpj>=`year1' & yearpj<=`yearT')

summ

********************************************************************************
* Restrictions for working with PSID data
********************************************************************************

tab yrvar

tab yearpj

* Drop if too few observations were used to compute sample covariance

drop if (wgtvar<10)

summ

********************************************************************************
* Call nls 
********************************************************************************

   nl _BaselineECM_poly4_psid @ covvar hvar jvar Dj0 yrvar [aweight=wgtvar], parameters(s2a psi s2n s2e theta1 theta2 pi88 pi89 pi90 pi91 pi92 pi93 pi94 pi95 pi96 pi98 pi00 pi02 pi04 pi06 pi08 b1_lam b2_lam b3_lam b4_lam) initial(s2a 0.1 psi 0.9 s2n .001 s2e .1 theta1 0.0 theta2 0.0 pi88 1.0 pi89 1.0 pi90 1.0 pi91 1.0 pi92 1.0 pi93 1.0 pi94 1.0 pi95 1.0 pi96 1.0 pi98 1.0 pi00 1.0 pi02 1.0 pi04 1.0 pi06 1.0 pi08 1.0 b1_lam 0.0 b2_lam 0.0 b3_lam 0.0 b4_lam 0.0) robust

log close















