* Variable WagesHD is 'wages and salaries' of Head.  In each year in the PSID extract, this variable is bottom-coded
* at zero.  No need to do anything here.  This variable is also top-coded in all years.  It hits the top code in 
* 1988 & 1989 ($999,999).
*
* In some of the latter years, the code 9,999,999 is assigned to "Immigrant sample families".  The PSID 
* documentation states that "values were not calculated for the Immigrant sample".  There are observations 
* with this value in 1994, 1995, 1997. Set those values to "missing" instead. (There are no years for 
* which this value is just the top code).
*

* First, form variable for 1993.  The variable in 1993 is different from other years. The other years
* appear to add wages & salaries from main job AND extra jobs.  In 1993, there is no such variable; just 
* the two pieces. So, we need to form the variable here.  The values for these pieces do not seem to have any 
* problems (e.g. top-coded values, other codes), so just add variables here, before the replacement done below.


clear all
use "G:\labinc\PSID_data_NEW\data_to_merge_1\RenamedData.dta"


* Form variable for 1993

gen WagesHD1993 = WagesHD_p1_1993 + WagesHD_p2_1993

drop WagesHD_p1_1993 WagesHD_p2_1993



* Set coded values from the Immigrant sample to missing

foreach yr of numlist 1985/1996 1997(2)2009 {

   replace WagesHD`yr' = . if (WagesHD`yr'==9999999)

}


* Rename WagesHD to Wages2HD, to distinguish from other wage measure in 'Master' dataset (to merge to).

foreach yr of numlist 1985/1996 1997(2)2009 {

   rename WagesHD`yr'  Wages2HD`yr'

}


