* Process data

clear all

use "G:\labinc\PSID_data_NEW\MergedData.dta"

***************************************************************************************************
* Variable FamInc was defined slightly differently starting in 1994.  Starting in 1994, FamInc
* includes Total Family Social security Income (whereas it did not before).  Here, I adjust for this
*, to make variable definition consistent throughout 1985-2009.
***************************************************************************************************

replace FamInc = FamInc - SocSecInc if (year>=1994 & year<=2009 & SocSecInc!=.)


***************************************************************************************************
* NOTE: Variables like marriedHD, NumberInFU, etc., refer to survey year, while all income variables
* refer to previous (reference) year. After 1997, however, PSID is biannual, so e.g. 2001 survey
* asks about 2001 marital status, # of persons in Family Unit, etc., but about 2000 income.
* However, since there was no survey in 2000, we don't have the information on these variables
* for 2000.  It seems like the ONLY way to deal with this is to pair the same-survey variables, 
* even if the years do not correspond.  But if this is done for the years after 1996, then it must
* also be done for the years before, because otherwise the treatment would be inconsistent over time.
* Therefore, we will just pair the survey-year variables with the previous-year income variables
* for all years.
* The only change, therefore, is to rename the years, so that they refer to the income year, 
* rather than to the survey year.
***************************************************************************************************

replace year = year - 1


***************************************************************************************************
* Adjust Age to correspond to the "new timing" of variables above (so that the Age variable 
* corresponds to the Age of the individual in the year that the income was received; rather than 
* to the year of the other demographic variables.
***************************************************************************************************

replace Age = Age - 1




