* This do file cleans up all other (i.e. non-income) variables in the PSID extract.
*

***************************************************
* AgeHD
***************************************************


***************************************************
* SexHD
***************************************************

***foreach yr of numlist 1985/1996 1997(2)2009 {
***   gen maleHD`yr' = 0
***   replace maleHD`yr' = 1 if (SexHD`yr'==1)
***   *drop if (SexHD`yr'==0)
***}
***drop SexHD*

***************************************************
* Self-employed (apply at sample selection stage)
***************************************************
* Codes: Working for:
* 1. Someone else only
* 2. Both someone else and self
* 3. Self-employed only
* Other codes: 0, 8, 9 are for Inap (did not work for $), DK, NA, etc.
* In sample selection, select only 1 and perhaps 2.


***************************************************
* Married
***************************************************
foreach yr of numlist 1985/1996 1997(2)2009 {

   gen marriedHD`yr' = 0
   replace marriedHD`yr' = 1 if (MarStatHD`yr'==1)

}

drop MarStatHD*



***************************************************
* Number in Family Unit
***************************************************

* This variable seems clean; no adjustments necessary.


***************************************************
* Reshape long
***************************************************

reshape long WagesHD NumberInFU AgeHD Age SelfEmpHD FamInc LabIncHD marriedHD RelToHD, i(pid) j(year)

tsset pid year

sort pid year

save "G:\labinc\PSID_data_NEW\CleanedData.dta", replace








