* NOTE: 
* For years 1994-2009, the variable from the PSID extract (LabIncHD) EXCLUDES (the labor portion of) farm and 
* unincorporated business income, and is therefore the variable that we want.  For the other years (1985-1993),
* the labor income variable (which I called LabIncTotHD) from the PSID extract INCLUDES (the labor portion of) farm 
* and unincorporated business income, so these two pieces have to be subtracted from this variable to arrive at
* the desired variable LabIncHD.
*
* For years 1994-2009, LabIncHD is top-coded at $9,999,999, but the variable never hits the top code, and so no 
* adjustment is necessary. LabIncHD is also bottom-coded at $0, but since we will impose a much larger minimum threshold
* at the sample selection stage, there are no adjustments needed here.
*
* LabFarmIncHD, the labor portion of farm income of the head, is top coded at $99,999, but for the years used here,
* 1985-1993, it never hits the tiop code, so no adjustment is necessary. In all those years, it's bottom-coded at
* zero; no adjustment necessary here, either. 
* LabBusIncHD, the labor portion of unincorporated business income of the head, is top-coded at $99,999 in most years;
* the variable hits its top code in each year of 1988-1992 (# of obs affected: 13, 6, 4, 24, 61). Then, in 1993, the 
* top-code value is raised and it's no longer hit. In this year, there are 4 observations of $175,000; all others are below the 
* previous-year top code of $99,999.  
* 
* Variable LabIncTotHD is formed as the sum of a bunch of variables, including LabFarmIncHD and LabBusIncHD. It would appear,
* from the documentation, that the top-coded variable LabBusIncHD is used in forming LabIncTotHD. Therefore, we don't try
* to impute values of top-coded observations of LabBusIncHD; we just subtract LabFarmIncHD and LabBusIncHD from LabIncTotHD.



* Construct LabIncHD for the missing years

forvalues yr = 1985/1993 {

   gen LabIncHD`yr' = LabIncTotHD`yr' - LabFarmIncHD`yr' - LabBusIncHD`yr'

}

* Drop unnecessary variables

drop LabIncTotHD* LabFarmIncHD* LabBusIncHD*



