* NOTE: 
* In some of the years (e.g. 1994 & 1995), the code 9,999,999 is assigned to "Latino sample families".  The PSID 
* documentation states that "values were not calculated for the Latino sample".  There are a bunch of observations 
* with this value in 1994 and 1995. Set those observations to 'missing'.
*
* FamInc is top-coded (in most years at either $9,999,998 or $9,999,999), but in the years included here, it never hits the 
* top-code value (the MAX is always below this value).  Therefore, there is no need to adjust for top-coding.
*
* In some of the years, FamInc is bottom-coded as well.  The bottom code is $1 in 1985-1993; and it is NOT bottom-coded 
* in years 1994-2009). Because in "Rising Inequality" paper we impose a minimum threshold that is much higher than 
* the $1 values, there is no need to adjust for bottom-coding here.  We wil discard all these observations when imposing 
* the sample selection criteria anyway. No need for any adjustments here.
*

* Set coded observations to 'missing' (Latino sample)

replace FamInc1994= . if (FamInc1994==9999999)      /* replaces 7270 obs */

replace FamInc1995= .  if (FamInc1995==9999999)      /* replaces 5955 obs */


