

program nl_Stationary_FE_AR1_MA2
    version 10
    syntax varlist(min=5 max=5) [aw fw iw] if, at(name)
    local ycov: word 1 of `varlist'
    local avar: word 2 of `varlist'
    local j:    word 3 of `varlist'
    local Dj0:  word 4 of `varlist'
    local year: word 5 of `varlist'
    // Retrieve parameters out of at matrix
    tempname s2a psi s2n s2e theta1 theta2
    scalar `s2a'   = `at'[1,1]
    scalar `psi'   = `at'[1,2]
    scalar `s2n'   = `at'[1,3]
    scalar `s2e'   = `at'[1,4]
    scalar `theta1'= `at'[1,5]
    scalar `theta2'= `at'[1,6]

    local pi1987 = 1.0
    local pi1988 = 1.0
    local pi1989 = 1.0
    local pi1990 = 1.0
    local pi1991 = 1.0
    local pi1992 = 1.0
    local pi1993 = 1.0
    local pi1994 = 1.0
    local pi1995 = 1.0
    local pi1996 = 1.0
    local pi1997 = 1.0
    local pi1998 = 1.0
    local pi1999 = 1.0
    local pi2000 = 1.0
    local pi2001 = 1.0
    local pi2002 = 1.0
    local pi2003 = 1.0
    local pi2004 = 1.0
    local pi2005 = 1.0
    local pi2006 = 1.0
    local pi2007 = 1.0
    local pi2008 = 1.0
    local pi2009 = 1.0

    local lam1987 = 1.0
    local lam1988 = 1.0
    local lam1989 = 1.0
    local lam1990 = 1.0
    local lam1991 = 1.0
    local lam1992 = 1.0
    local lam1993 = 1.0
    local lam1994 = 1.0
    local lam1995 = 1.0
    local lam1996 = 1.0
    local lam1997 = 1.0
    local lam1998 = 1.0
    local lam1999 = 1.0
    local lam2000 = 1.0
    local lam2001 = 1.0
    local lam2002 = 1.0
    local lam2003 = 1.0
    local lam2004 = 1.0
    local lam2005 = 1.0
    local lam2006 = 1.0
    local lam2007 = 1.0
    local lam2008 = 1.0
    local lam2009 = 1.0

    * NOTE: Create scalars such as pi1990 with the same value as local macro `pi1990'
    * to access below by references such as pi`h' (where `h' is a macro: an index from a loop).

    scalar pi1987 = `pi1987'
    scalar pi1988 = `pi1988'
    scalar pi1989 = `pi1989'
    scalar pi1990 = `pi1990'
    scalar pi1991 = `pi1991'
    scalar pi1992 = `pi1992'
    scalar pi1993 = `pi1993'
    scalar pi1994 = `pi1994'
    scalar pi1995 = `pi1995'
    scalar pi1996 = `pi1996'
    scalar pi1997 = `pi1997'
    scalar pi1998 = `pi1998'
    scalar pi1999 = `pi1999'
    scalar pi2000 = `pi2000'
    scalar pi2001 = `pi2001'
    scalar pi2002 = `pi2002'
    scalar pi2003 = `pi2003'
    scalar pi2004 = `pi2004'
    scalar pi2005 = `pi2005'
    scalar pi2006 = `pi2006'
    scalar pi2007 = `pi2007'
    scalar pi2008 = `pi2008'
    scalar pi2009 = `pi2009'

    scalar lam1987 = `lam1987'
    scalar lam1988 = `lam1988'
    scalar lam1989 = `lam1989'
    scalar lam1990 = `lam1990'
    scalar lam1991 = `lam1991'
    scalar lam1992 = `lam1992'
    scalar lam1993 = `lam1993'
    scalar lam1994 = `lam1994'
    scalar lam1995 = `lam1995'
    scalar lam1996 = `lam1996'
    scalar lam1997 = `lam1997'
    scalar lam1998 = `lam1998'
    scalar lam1999 = `lam1999'
    scalar lam2000 = `lam2000'
    scalar lam2001 = `lam2001'
    scalar lam2002 = `lam2002'
    scalar lam2003 = `lam2003'
    scalar lam2004 = `lam2004'
    scalar lam2005 = `lam2005'
    scalar lam2006 = `lam2006'
    scalar lam2007 = `lam2007'
    scalar lam2008 = `lam2008'
    scalar lam2009 = `lam2009'

    * Specify piXXXX for a few years before 1987.
    * Create the piXXXX both as local macro and as scalar.

    local pi1980 = 1.0
    local pi1981 = 1.0
    local pi1982 = 1.0
    local pi1983 = 1.0
    local pi1984 = 1.0
    local pi1985 = 1.0
    local pi1986 = 1.0

    scalar pi1980 = `pi1980'
    scalar pi1981 = `pi1981'
    scalar pi1982 = `pi1982'
    scalar pi1983 = `pi1983'
    scalar pi1984 = `pi1984'
    scalar pi1985 = `pi1985'
    scalar pi1986 = `pi1986'


*** Loop to assign values to scalar varp_`yr'_`age'

  forvalues cohort = 1952(1)2009 {

    forvalues age = 1(1)36 {

      local yr    = `cohort' + `age' - 1
      local yrm1  = `yr' - 1
      local yrm2  = `yr' - 2
      local agem1 = `age' - 1

      if `yr' <= 2009 {

        if `age' == 1 {
           scalar varp_`yr'_`age' = (`s2n')
        }

        if `age' == 2 {
           scalar varp_`yr'_`age' = ((`psi')^2)*varp_`yrm1'_`agem1' + (`s2n')
        }

        if `age' >= 3 {
           scalar varp_`yr'_`age' = ((`psi')^2)*varp_`yrm1'_`agem1' + (`s2n')
        }

      }

    }

  }


    * Now, assign values to dependent variable:

    forvalues t = 1987(1)2009 {
      local tm1 = `t'-1
      local tm2 = `t'-2
      local maxK = 2009-`t'
      forvalues h = 1(1)36 {
        forvalues k = 0(1)`maxK' {
          local tpk = `t'+`k'

          capture replace `ycov' = (lam`t')*(lam`tpk')*(`s2a' + ((`psi')^(`j'))*varp_`t'_`h' ) + (`j'==0)*(`s2e')*( ((pi`t')^2) + (`avar'>=2)*((pi`tm1')^2)*((`theta1')^2) + (`avar'>=3)*((pi`tm2')^2)*((`theta2')^2) )  + (`j'==1)*(`s2e')*( ((pi`t')^2)*(`theta1') + (`avar'>=2)*((pi`tm1')^2)*(`theta1')*(`theta2') ) + (`j'==2)*(`s2e')*( ((pi`t')^2)*(`theta2') )  if (`year'==`t' & `avar'==`h' & `j'==`k')

        }
      }
    }

end
















