* Set path to directory where covariance data is located.
* Then select the desired income measure and sample by commenting 
* out/uncommenting statement that reads the covariance data.
* (Make sure that corresponding .ado file has been saved in the 
* appropriate directory.)

clear
set mem 10m
set more off

log using Estimate_Stationary_FE_RW_MA2, text replace

local path /fa/home/m1ixv00/labinc/BPEA/covs_data

********************************************************************************
* Parameters
********************************************************************************

* Say, years OBSERVED: 1987-2009
local year1 = 1987
local year2 = 1988
local yearT = 2009

local cohort1 = 1952   /* first cohort */
local cohortT = 2009   /* last cohort */


****************************************************************************************************************
****************************************************************************************************************
*************************************** Read Covariance Data ***************************************************
****************************************************************************************************************
****************************************************************************************************************


* Labor Income
   use  yrvar hvar jvar covvar wgtvar  using `path'/CovsData_labinc_CAL.dta, clear

* Household Income (Before-Tax) on Male Earnings Sample
***use  yrvar hvar jvar covvar wgtvar  using `path'/CovsData_hhinc-labincsample_CAL.dta, clear

* Household Income (Before-Tax)
***use  yrvar hvar jvar covvar wgtvar  using `path'/CovsData_hhinc_CAL.dta, clear

* Household Income (After-Tax)
***use  yrvar hvar jvar covvar wgtvar  using `path'/CovsData_hhincat_CAL.dta, clear

*  Household Income (Before-Tax), Low Threshold (LT)
***use  yrvar hvar jvar covvar wgtvar  using `path'/CovsData_hhinc_LT_CAL.dta, clear

*  Household Income (Before-Tax), High Threshold (HT)
***use  yrvar hvar jvar covvar wgtvar  using `path'/CovsData_hhinc_HT2_CAL.dta, clear

*  Household Income (Before-Tax) on Male Earnings Sample, Low Threshold (LT)
***use  yrvar hvar jvar covvar wgtvar  using `path'/CovsData_hhinc-labincsample_LT_CAL.dta, clear

*  Household Income (Before-Tax) on Male Earnings Sample, High Threshold (HT)
***use  yrvar hvar jvar covvar wgtvar  using `path'/CovsData_hhinc-labincsample_HT2_CAL.dta, clear

* Household Income (Before-Tax), Continuously Married Sample
***use  yrvar hvar jvar covvar wgtvar  using `path'/CovsData_hhinc_mar_CAL.dta, clear

*** BUILD-UP TO BROADER INCOME MEASURES, ON LABINC SAMPLE

* Income1 on Male Earnings Sample
***use  yrvar hvar jvar covvar wgtvar  using `path'/CovsData_income1_labincsample_CAL.dta, clear

* Income2 on Male Earnings Sample
***use  yrvar hvar jvar covvar wgtvar  using `path'/CovsData_income2_labincsample_CAL.dta, clear

* Income3 on Male Earnings Sample
***use  yrvar hvar jvar covvar wgtvar  using `path'/CovsData_income3_labincsample_CAL.dta, clear



summ
more

* Arrange data

drop if (covvar==.)
***drop if (wgtvar==0)
***drop if (wgtvar==.)

* Drop if too few observations were used to compute sample covariance

***drop if (jvar>10)
***drop if (wgtvar<100)
more

* Create dummy variable Dj0, which equals 1 if jvar==0 and equals 0 otherwise

gen Dj0=0
replace Dj0=1 if (jvar==0)

********************************************************************************
* Pick observations used for estimation
********************************************************************************

gen cohort = yrvar - hvar + 1

keep if (cohort>=`cohort1' & cohort<=`cohortT')

keep if (yrvar>=`year1' & yrvar<=`yearT')

* Make sure that "future" years used to compute autocovariances do not fall 
* outside of [year1,yearT] range:

gen yearpj = (cohort-1) + hvar + jvar  /* identical to setting yearpj = year + jvar */

keep if (yearpj>=`year1' & yearpj<=`yearT')

summ

********************************************************************************
* Call nls 
********************************************************************************

   nl _Stationary_FE_RW_MA2 @ covvar hvar jvar Dj0 yrvar [aweight=wgtvar], parameters(s2a s2f s2z theta1 theta2) initial(s2a 0.1 s2f .001 s2z .1 theta1 0.0 theta2 0.0) robust


log close















