* Variance Decomposition for Baseline ECM with lambda series restricted
* to 4-degree polynomial.
* To compute the variance decomposition, uncomment the desired set of 
* parameter estimates (and make sure all other parameter estimates 
* are commented out), and select (by commenting out/uncommenting)
* the corresponding weights file (which does the appropriate 
* weighting by the empirical age distribution of the corresponding
* sample.

clear all

local path  ../../../../Data/weights             /* set path for weights data */

* Select dataset with age weights (by commenting out/uncommenting)

 local weights weights_labinc.dta                /* Male Earnings */
*local weights weights_hhinc-labincsample.dta    /* Pre-Tax Household Income on Male-Headed Households Sample */
*local weights weights_hhinc.dta                 /* Pre-Tax Household Income on All Households Sample */
*local weights weights_hhincat-labincsample.dta  /* After-Tax Household Income on Male-Headed Households Sample */
*local weights weights_hhincat.dta               /* After-Tax Household Income on All Households Sample */
*local weights weights_income1-labincsample.dta  /* ... Adding Spousal Labor Earnings to Male Earnings */
*local weights weights_income2-labincsample.dta  /* ... Adding Transfer Income ... */
*local weights weights_income3-labincsample.dta  /* ... Adding Investment Income ... */
*local weights weights_labinc_LT.dta             /* Male Earnings w/ Lower Minimum Threshold (LT)*/
*local weights weights_labinc_HT2.dta            /* Male Earnings w/ Higher Minimum Threshold (HT)*/
*local weights weights_hhinc_LT.dta              /* Pre-Tax Household Income w/ Lower Minimum Threshold (LT)*/
*local weights weights_hhinc_HT2.dta             /* Pre-Tax Household Income  w/ Higher Minimum Threshold (HT)*/
*local weights weights_hhinc_fixedfamilycomp.dta /* Pre-Tax Household Income with Fixed Family Composition */
*local weights weights_hhinc_mar.dta             /* Pre-Tax Household Income on Continuously Married Sample */


**********************************************************************
* Select parameter estimates for the desired sample
**********************************************************************


**********************************************************************
    /* Estimates for Male Earnings */

     local s2a = 0.17115430
     local psi = 0.96305660
     local s2n = 0.02421240
     local s2e = 0.18944300
     local theta1 = 0.23451600
     local theta2 = 0.12652940

     local pi1987 = 1.0
     local pi1988 = 1.05370800
     local pi1989 = 0.99266420
     local pi1990 = 0.97186740
     local pi1991 = 0.93936470
     local pi1992 = 0.97717970
     local pi1993 = 1.03641400
     local pi1994 = 0.99406090
     local pi1995 = 0.97868430
     local pi1996 = 0.97710640
     local pi1997 = 0.92979760
     local pi1998 = 0.94252750
     local pi1999 = 0.92513990
     local pi2000 = 0.95511410
     local pi2001 = 0.93420370
     local pi2002 = 0.99087730
     local pi2003 = 1.04029800
     local pi2004 = 1.01800700
     local pi2005 = 0.96561900
     local pi2006 = 0.97135380
     local pi2007 = 0.96096090
     local pi2008 = 1.04731100
     local pi2009 = 1.04731100   /* Set to pi2008 */

     local lam1987 = 1.0
     local lam1988 = 1.03151000
     local lam1989 = 1.05671000
     local lam1990 = 1.05109700
     local lam1991 = 1.06600300
     local lam1992 = 1.08656900
     local lam1993 = 1.06944200
     local lam1994 = 1.06006400
     local lam1995 = 1.07862200
     local lam1996 = 1.07558000
     local lam1997 = 1.08943300
     local lam1998 = 1.08880000
     local lam1999 = 1.09209900
     local lam2000 = 1.09093500
     local lam2001 = 1.09752100
     local lam2002 = 1.10514600
     local lam2003 = 1.08201800
     local lam2004 = 1.08050600
     local lam2005 = 1.09871900
     local lam2006 = 1.12422400
     local lam2007 = 1.11073700
     local lam2008 = 1.09277500
     local lam2009 = 1.10626000

**********************************************************************
    /* Estimates for Pre-Tax Household Income on Male-Headed Households Sample */

*     local s2a = 0.15149920
*     local psi = 0.97470740
*     local s2n = 0.01263360
*     local s2e = 0.14247680
*     local theta1 = 0.32198700
*     local theta2 = 0.22503460

*     local pi1987 = 1.0
*     local pi1988 = 1.01129500
*     local pi1989 = 1.01484000
*     local pi1990 = 0.95303870
*     local pi1991 = 0.91425000
*     local pi1992 = 0.97930480
*     local pi1993 = 1.02163300
*     local pi1994 = 0.97794130
*     local pi1995 = 0.96250530
*     local pi1996 = 0.93489160
*     local pi1997 = 0.91096760
*     local pi1998 = 0.93877820
*     local pi1999 = 0.91914330
*     local pi2000 = 0.97609950
*     local pi2001 = 0.99514900
*     local pi2002 = 1.02414200
*     local pi2003 = 1.04225600
*     local pi2004 = 1.07542400
*     local pi2005 = 1.06003500
*     local pi2006 = 1.05712600
*     local pi2007 = 1.02532800
*     local pi2008 = 1.09801200
*     local pi2009 = 1.09801200   /* Set to pi2008 */

*     local lam1987 = 1.0
*     local lam1988 = 1.05623700
*     local lam1989 = 1.07961900
*     local lam1990 = 1.07639700
*     local lam1991 = 1.11151000
*     local lam1992 = 1.11968800
*     local lam1993 = 1.10508300
*     local lam1994 = 1.10698700
*     local lam1995 = 1.12737900
*     local lam1996 = 1.14370800
*     local lam1997 = 1.17276300
*     local lam1998 = 1.18561600
*     local lam1999 = 1.19580500
*     local lam2000 = 1.17138700
*     local lam2001 = 1.15016500
*     local lam2002 = 1.15871700
*     local lam2003 = 1.12671600
*     local lam2004 = 1.13306000
*     local lam2005 = 1.15199000
*     local lam2006 = 1.19788200
*     local lam2007 = 1.21404400
*     local lam2008 = 1.13096000
*     local lam2009 = 1.13236100

**********************************************************************
    /* Estimates for Pre-Tax Household Income on All Households Sample */

*     local s2a = 0.16531840
*     local psi = 0.96844570
*     local s2n = 0.02052910
*     local s2e = 0.15714810
*     local theta1 = 0.28599380
*     local theta2 = 0.17108540

*     local pi1987 = 1.0
*     local pi1988 = 0.98982960
*     local pi1989 = 0.99846140
*     local pi1990 = 0.98518290
*     local pi1991 = 0.96646510
*     local pi1992 = 1.00598800
*     local pi1993 = 1.03049400
*     local pi1994 = 0.99413960
*     local pi1995 = 0.96388410
*     local pi1996 = 0.94590660
*     local pi1997 = 0.94543090
*     local pi1998 = 0.95789000
*     local pi1999 = 0.96317190
*     local pi2000 = 0.98935240
*     local pi2001 = 1.01643800
*     local pi2002 = 1.01963200
*     local pi2003 = 1.06097900
*     local pi2004 = 1.04867200
*     local pi2005 = 1.04388400
*     local pi2006 = 1.08405400
*     local pi2007 = 1.03458200
*     local pi2008 = 1.05943700
*     local pi2009 = 1.05943700   /* Set to pi2008 */

*     local lam1987 = 1.0
*     local lam1988 = 1.04442300
*     local lam1989 = 1.05236100
*     local lam1990 = 1.05230900
*     local lam1991 = 1.06581700
*     local lam1992 = 1.07522500
*     local lam1993 = 1.07569400
*     local lam1994 = 1.07592300
*     local lam1995 = 1.10848800
*     local lam1996 = 1.12397700
*     local lam1997 = 1.13345000
*     local lam1998 = 1.15161000
*     local lam1999 = 1.14422900
*     local lam2000 = 1.13925000
*     local lam2001 = 1.11565900
*     local lam2002 = 1.11157400
*     local lam2003 = 1.10022300
*     local lam2004 = 1.13131200
*     local lam2005 = 1.13671100
*     local lam2006 = 1.13843000
*     local lam2007 = 1.16305600
*     local lam2008 = 1.12036700
*     local lam2009 = 1.11373900

**********************************************************************
    /* Estimates for After-Tax Household Income on Male-Headed Households Sample */

*     local s2a = 0.12758350
*     local psi = 0.98272570
*     local s2n = 0.01004110
*     local s2e = 0.11992910
*     local theta1 = 0.31568110
*     local theta2 = 0.22565250

*     local pi1987 = 1.0
*     local pi1988 = 1.01101000
*     local pi1989 = 1.02170800
*     local pi1990 = 0.96835210
*     local pi1991 = 0.92365940
*     local pi1992 = 0.98345420
*     local pi1993 = 1.02930800
*     local pi1994 = 0.96578440
*     local pi1995 = 0.94652540
*     local pi1996 = 0.91538300
*     local pi1997 = 0.89775620
*     local pi1998 = 0.93113110
*     local pi1999 = 0.92055880
*     local pi2000 = 0.98661770
*     local pi2001 = 0.99913210
*     local pi2002 = 1.02984200
*     local pi2003 = 1.04652800
*     local pi2004 = 1.09305300
*     local pi2005 = 1.07893100
*     local pi2006 = 1.08205800
*     local pi2007 = 1.03935000
*     local pi2008 = 1.09672300
*     local pi2009 = 1.09672300   /* Set to pi2008 */

*     local lam1987 = 1.0
*     local lam1988 = 1.06105000
*     local lam1989 = 1.08107600
*     local lam1990 = 1.07735300
*     local lam1991 = 1.09820300
*     local lam1992 = 1.10772600
*     local lam1993 = 1.08882400
*     local lam1994 = 1.08774000
*     local lam1995 = 1.09609700
*     local lam1996 = 1.11276100
*     local lam1997 = 1.14827600
*     local lam1998 = 1.15706800
*     local lam1999 = 1.16695500
*     local lam2000 = 1.14333000
*     local lam2001 = 1.11391800
*     local lam2002 = 1.11551400
*     local lam2003 = 1.09376400
*     local lam2004 = 1.09643700
*     local lam2005 = 1.11632100
*     local lam2006 = 1.16685800
*     local lam2007 = 1.18461400
*     local lam2008 = 1.09776100
*     local lam2009 = 1.08721800

**********************************************************************
    /* Estimates for After-Tax Household Income on All Households Sample */

*     local s2a = 0.13933330
*     local psi = 0.97819870
*     local s2n = 0.01538090
*     local s2e = 0.13534350
*     local theta1 = 0.28229600
*     local theta2 = 0.17729220

*     local pi1987 = 1.0
*     local pi1988 = 0.98917350
*     local pi1989 = 1.00032800
*     local pi1990 = 0.99266880
*     local pi1991 = 0.97615130
*     local pi1992 = 1.00989100
*     local pi1993 = 1.04232000
*     local pi1994 = 0.98932160
*     local pi1995 = 0.95924740
*     local pi1996 = 0.93589210
*     local pi1997 = 0.93428250
*     local pi1998 = 0.95266140
*     local pi1999 = 0.95964260
*     local pi2000 = 0.98481960
*     local pi2001 = 1.01771700
*     local pi2002 = 1.02874800
*     local pi2003 = 1.07103500
*     local pi2004 = 1.06634100
*     local pi2005 = 1.06923900
*     local pi2006 = 1.12093600
*     local pi2007 = 1.06781000
*     local pi2008 = 1.07290800
*     local pi2009 = 1.07290800   /* Set to pi2008 */

*     local lam1987 = 1.0
*     local lam1988 = 1.04965700
*     local lam1989 = 1.05374400
*     local lam1990 = 1.05020200
*     local lam1991 = 1.05187100
*     local lam1992 = 1.06149700
*     local lam1993 = 1.05730600
*     local lam1994 = 1.04515800
*     local lam1995 = 1.07273200
*     local lam1996 = 1.08787300
*     local lam1997 = 1.10011100
*     local lam1998 = 1.11912500
*     local lam1999 = 1.10770100
*     local lam2000 = 1.10513900
*     local lam2001 = 1.07289800
*     local lam2002 = 1.06814400
*     local lam2003 = 1.06037400
*     local lam2004 = 1.09114500
*     local lam2005 = 1.09679300
*     local lam2006 = 1.10085600
*     local lam2007 = 1.12446000
*     local lam2008 = 1.07514200
*     local lam2009 = 1.05573400

**********************************************************************

    * NOTE: Create scalars such as pi1990 with the same value as local macro `pi1990'
    * to access below by references such as pi`h' (where `h' is a macro: an index from a loop).

    scalar pi1987 = `pi1987'
    scalar pi1988 = `pi1988'
    scalar pi1989 = `pi1989'
    scalar pi1990 = `pi1990'
    scalar pi1991 = `pi1991'
    scalar pi1992 = `pi1992'
    scalar pi1993 = `pi1993'
    scalar pi1994 = `pi1994'
    scalar pi1995 = `pi1995'
    scalar pi1996 = `pi1996'
    scalar pi1997 = `pi1997'
    scalar pi1998 = `pi1998'
    scalar pi1999 = `pi1999'
    scalar pi2000 = `pi2000'
    scalar pi2001 = `pi2001'
    scalar pi2002 = `pi2002'
    scalar pi2003 = `pi2003'
    scalar pi2004 = `pi2004'
    scalar pi2005 = `pi2005'
    scalar pi2006 = `pi2006'
    scalar pi2007 = `pi2007'
    scalar pi2008 = `pi2008'
    scalar pi2009 = `pi2009'

    scalar lam1987 = `lam1987'
    scalar lam1988 = `lam1988'
    scalar lam1989 = `lam1989'
    scalar lam1990 = `lam1990'
    scalar lam1991 = `lam1991'
    scalar lam1992 = `lam1992'
    scalar lam1993 = `lam1993'
    scalar lam1994 = `lam1994'
    scalar lam1995 = `lam1995'
    scalar lam1996 = `lam1996'
    scalar lam1997 = `lam1997'
    scalar lam1998 = `lam1998'
    scalar lam1999 = `lam1999'
    scalar lam2000 = `lam2000'
    scalar lam2001 = `lam2001'
    scalar lam2002 = `lam2002'
    scalar lam2003 = `lam2003'
    scalar lam2004 = `lam2004'
    scalar lam2005 = `lam2005'
    scalar lam2006 = `lam2006'
    scalar lam2007 = `lam2007'
    scalar lam2008 = `lam2008'
    scalar lam2009 = `lam2009'

    * Specify piXXXX for a few years before 1987.
    * Create the piXXXX both as local macro and as scalar.

    local pi1981 = 1.0
    local pi1982 = 1.0
    local pi1983 = 1.0
    local pi1984 = 1.0
    local pi1985 = 1.0
    local pi1986 = 1.0


    scalar pi1981 = `pi1981'
    scalar pi1982 = `pi1982'
    scalar pi1983 = `pi1983'
    scalar pi1984 = `pi1984'
    scalar pi1985 = `pi1985'
    scalar pi1986 = `pi1986'


*** Loop to assign values to scalar varp_`yr'_`age'

  forvalues cohort = 1952(1)2009 {

    forvalues age = 1(1)36 {

      local yr    = `cohort' + `age' - 1
      local yrm1  = `yr' - 1
      local yrm2  = `yr' - 2
      local agem1 = `age' - 1

      if `yr' <= 2009 {

        if `age' == 1 {
           scalar varp_`yr'_`age' = (`s2n')
        }

        if `age' >= 2 {
           scalar varp_`yr'_`age' = ((`psi')^2)*varp_`yrm1'_`agem1' + (`s2n')
        }

      }

    }

  }



***** Assign values to dependent variable:


    /* Initialize output variables */


    set obs 10000

    gen year = 0

    gen lead = 0

    gen PE = 0

    gen ycov = 0

    gen perm = 0

    gen tran = 0

    /* Initialize counter for output */

    local n = 1

***** Assign values to dependent variable:

    forvalues t = 1987(1)2009 {
      local tm1 = `t'-1
      local tm2 = `t'-2
      local maxK = 2009-`t'
      forvalues h = 1(1)36 {
        forvalues k = 0(1)`maxK' {
          local tpk = `t'+`k'

          /* Output result to observation n */

          qui replace ycov = (lam`t')*(lam`tpk')*(`s2a' + ((`psi')^(`k'))*varp_`t'_`h' ) + (`k'==0)*(`s2e')*( ((pi`t')^2) + (`h'>=2)*((pi`tm1')^2)*((`theta1')^2) + (`h'>=3)*((pi`tm2')^2)*((`theta2')^2) )  + (`k'==1)*(`s2e')*( ((pi`t')^2)*(`theta1') + (`h'>=2)*((pi`tm1')^2)*(`theta1')*(`theta2') ) + (`k'==2)*(`s2e')*( ((pi`t')^2)*(`theta2') )  if _n == `n'

          qui replace perm = (lam`t')*(lam`tpk')*(`s2a' + ((`psi')^(`k'))*varp_`t'_`h' )  if _n == `n'

          qui replace tran = (`k'==0)*(`s2e')*( ((pi`t')^2) + (`h'>=2)*((pi`tm1')^2)*((`theta1')^2) + (`h'>=3)*((pi`tm2')^2)*((`theta2')^2) )  + (`k'==1)*(`s2e')*( ((pi`t')^2)*(`theta1') + (`h'>=2)*((pi`tm1')^2)*(`theta1')*(`theta2') ) + (`k'==2)*(`s2e')*( ((pi`t')^2)*(`theta2') )  if _n == `n'

          qui replace year = `t' if _n == `n'
          qui replace lead = `k' if _n == `n'
          qui replace PE   = `h' if _n == `n'

          /* Increment counter for output */
          local n = `n' + 1

        }
      }
    }


    *foreach h of numlist 1 5 15 20 25 35 {
    *    list PE year ycov perm tran  if (lead==0 & PE==`h'), clean noobs
    *}

    *******************************************************************
    * Compute permanent-transitory variance decomposition for
    * all values of age (PE), weighting by the relative age weights for
    * each calendar year.  Make sure to read the appropriate weights
    * file (see below, merge statement).
    *******************************************************************

    keep if year!=0

    keep if lead==0

    * merge age dist'n weights

    sort year PE

    merge year PE using  `path'/`weights'

    keep if _merge==3
    drop _merge

    gen ycov_w = ycov*weight   /* multiply by weights to compute weighted means */
    gen perm_w = perm*weight   /* note: weights add to 1 across PE for each year */
    gen tran_w = tran*weight

    collapse (sum) ycov_w perm_w tran_w, by(year)   /* computes weighted average */

    disp "Persistent-Transitory Variance Decomposition: Total, Persistent, Transitory "
    list, clean noobs



