* Variance Decomposition for Baseline ECM with lambda series restricted
* to 4-degree polynomial.
* To compute the variance decomposition, uncomment the desired set of 
* parameter estimates (and make sure all other parameter estimates 
* are commented out), and select (by commenting out/uncommenting)
* the corersponding weights file (which does the appropriate 
* weighting by the empirical age distribution of the corresponding
* sample.

clear all

local path  ../../../../Data/weights             /* set path for weights data */


* Select dataset with age weights (by commenting out/uncommenting)

 local weights weights_labinc.dta                /* Male Earnings */
*local weights weights_hhinc-labincsample.dta    /* Pre-Tax Household Income on Male-Headed Households Sample */
*local weights weights_hhinc.dta                 /* Pre-Tax Household Income on All Households Sample */
*local weights weights_hhincat-labincsample.dta  /* After-Tax Household Income on Male-Headed Households Sample */
*local weights weights_hhincat.dta               /* After-Tax Household Income on All Households Sample */
*local weights weights_income1-labincsample.dta  /* ... Adding Spousal Labor Earnings to Male Earnings */
*local weights weights_income2-labincsample.dta  /* ... Adding Transfer Income ... */
*local weights weights_income3-labincsample.dta  /* ... Adding Investment Income ... */
*local weights weights_labinc_LT.dta             /* Male Earnings w/ Lower Minimum Threshold (LT)*/
*local weights weights_labinc_HT2.dta            /* Male Earnings w/ Higher Minimum Threshold (HT)*/
*local weights weights_hhinc_LT.dta              /* Pre-Tax Household Income w/ Lower Minimum Threshold (LT)*/
*local weights weights_hhinc_HT2.dta             /* Pre-Tax Household Income  w/ Higher Minimum Threshold (HT)*/
*local weights weights_hhinc_fixedfamilycomp.dta /* Pre-Tax Household Income with Fixed Family Composition */
*local weights weights_hhinc_mar.dta             /* Pre-Tax Household Income on Continuously Married Sample */


**********************************************************************
* Select parameter estimates for the desired sample
**********************************************************************


**********************************************************************
    /* Estimates for Male Earnings */

     local s2a = 0.17419460
     local psi = 0.96305550
     local s2n = 0.02464110
     local s2e = 0.18341280
     local theta1 = 0.23430970
     local theta2 = 0.12621550

     local pi1988 = 1.07923900
     local pi1989 = 1.03522300
     local pi1990 = 0.97629340
     local pi1991 = 0.96106840
     local pi1992 = 1.02662800
     local pi1993 = 1.03421000
     local pi1994 = 0.96569490
     local pi1995 = 0.99246660
     local pi1996 = 0.97984050
     local pi1997 = 0.96278580
     local pi1998 = 0.96843430
     local pi1999 = 0.95483310
     local pi2000 = 0.97848010
     local pi2001 = 0.96650790
     local pi2002 = 1.02843200
     local pi2003 = 1.01547500
     local pi2004 = 0.99094050
     local pi2005 = 0.98097180
     local pi2006 = 1.03790500
     local pi2007 = 0.98543160
     local pi2008 = 1.03352300
     local pi2009 = 1.07633500

     local b1_lam =  0.02256400
     local b2_lam = -0.00272920
     local b3_lam =  0.00015050
     local b4_lam = -0.00000293

**********************************************************************
    /* Estimates for Pre-Tax Household Income on Male-Headed Households Sample */

*     local s2a = 0.15663980
*     local psi = 0.97506910
*     local s2n = 0.01287370
*     local s2e = 0.13543800
*     local theta1 = 0.32733610
*     local theta2 = 0.23057480

*     local pi1988 = 1.07370100
*     local pi1989 = 1.07154600
*     local pi1990 = 0.95967760
*     local pi1991 = 0.96657580
*     local pi1992 = 1.00579800
*     local pi1993 = 0.98577020
*     local pi1994 = 0.93038870
*     local pi1995 = 0.95837990
*     local pi1996 = 0.96037730
*     local pi1997 = 1.00123400
*     local pi1998 = 1.03959200
*     local pi1999 = 1.02235000
*     local pi2000 = 1.00289600
*     local pi2001 = 0.96523820
*     local pi2002 = 1.01746200
*     local pi2003 = 0.95759390
*     local pi2004 = 1.03847200
*     local pi2005 = 1.09407500
*     local pi2006 = 1.18631000
*     local pi2007 = 1.16954900
*     local pi2008 = 1.05623300
*     local pi2009 = 1.09887600

*     local b1_lam =  0.02745340
*     local b2_lam = -0.00198080
*     local b3_lam =  0.00007250
*     local b4_lam = -0.00000124

**********************************************************************
    /* Estimates for Pre-Tax Household Income on All Households Sample */

*     local s2a = 0.17011480
*     local psi = 0.96865860
*     local s2n = 0.02094230
*     local s2e = 0.14929880
*     local theta1 = 0.29054380
*     local theta2 = 0.17624480

*     local pi1988 = 1.06422400
*     local pi1989 = 1.04934800
*     local pi1990 = 1.00146700
*     local pi1991 = 0.98529460
*     local pi1992 = 1.01408500
*     local pi1993 = 1.01302900
*     local pi1994 = 0.95726830
*     local pi1995 = 0.99973310
*     local pi1996 = 1.00392000
*     local pi1997 = 1.01256400
*     local pi1998 = 1.05842900
*     local pi1999 = 1.02257800
*     local pi2000 = 1.02168700
*     local pi2001 = 0.97601240
*     local pi2002 = 0.97694070
*     local pi2003 = 1.00444400
*     local pi2004 = 1.08718600
*     local pi2005 = 1.10097900
*     local pi2006 = 1.14574900
*     local pi2007 = 1.15115800
*     local pi2008 = 1.05217000
*     local pi2009 = 1.05546800

*     local b1_lam =  0.01319340
*     local b2_lam =  0.00018660
*     local b3_lam = -0.00005960
*     local b4_lam =  0.00000156

**********************************************************************
    /* Estimates for After-Tax Household Income on Male-Headed Households Sample */

*     local s2a = 0.13284310
*     local psi = 0.98309040
*     local s2n = 0.01029050
*     local s2e = 0.11227040
*     local theta1 = 0.32303810
*     local theta2 = 0.23161860

*     local pi1988 = 1.09095800
*     local pi1989 = 1.09105700
*     local pi1990 = 0.99151050
*     local pi1991 = 0.96764300
*     local pi1992 = 1.01906900
*     local pi1993 = 0.99889700
*     local pi1994 = 0.92094350
*     local pi1995 = 0.92730170
*     local pi1996 = 0.94089560
*     local pi1997 = 1.01399700
*     local pi1998 = 1.05027400
*     local pi1999 = 1.04303400
*     local pi2000 = 1.03197100
*     local pi2001 = 0.96530430
*     local pi2002 = 1.00587700
*     local pi2003 = 0.97122870
*     local pi2004 = 1.05597000
*     local pi2005 = 1.11726000
*     local pi2006 = 1.22755600
*     local pi2007 = 1.20338100
*     local pi2008 = 1.07004300
*     local pi2009 = 1.09093600

*     local b1_lam =  0.02686160
*     local b2_lam = -0.00278940
*     local b3_lam =  0.00014300
*     local b4_lam = -0.00000290

**********************************************************************
    /* Estimates for After-Tax Household Income on All Households Sample */

*     local s2a = 0.14453990
*     local psi = 0.97842710
*     local s2n = 0.01579600
*     local s2e = 0.12644850
*     local theta1 = 0.28801840
*     local theta2 = 0.18273980

*     local pi1988 = 1.08145500
*     local pi1989 = 1.06505200
*     local pi1990 = 1.02417700
*     local pi1991 = 0.99352370
*     local pi1992 = 1.03177900
*     local pi1993 = 1.03838500
*     local pi1994 = 0.94319890
*     local pi1995 = 0.98688370
*     local pi1996 = 0.99739440
*     local pi1997 = 1.01966100
*     local pi1998 = 1.07643100
*     local pi1999 = 1.03312000
*     local pi2000 = 1.03744600
*     local pi2001 = 0.97426530
*     local pi2002 = 0.98345190
*     local pi2003 = 1.02222300
*     local pi2004 = 1.10773400
*     local pi2005 = 1.13172600
*     local pi2006 = 1.19712800
*     local pi2007 = 1.19782600
*     local pi2008 = 1.08151200
*     local pi2009 = 1.07066900

*     local b1_lam =  0.01255500
*     local b2_lam = -0.00089970
*     local b3_lam =  0.00004050
*     local b4_lam = -0.00000093

**********************************************************************
    /* ... Adding Spousal Labor Earnings to Male Earnings */
    
*     local s2a = 0.14390500
*     local psi = 0.96384630
*     local s2n = 0.01486330
*     local s2e = 0.16754930
*     local theta1 = 0.33184460
*     local theta2 = 0.23583880
*     local pi1988 = 1.06687700
*     local pi1989 = 1.03474100
*     local pi1990 = 0.97997770
*     local pi1991 = 0.96623140
*     local pi1992 = 1.02495500
*     local pi1993 = 0.98158280
*     local pi1994 = 0.92001510
*     local pi1995 = 0.94035190
*     local pi1996 = 0.93425020
*     local pi1997 = 0.91599390
*     local pi1998 = 0.94056330
*     local pi1999 = 0.93664310
*     local pi2000 = 0.94449160
*     local pi2001 = 0.94087560
*     local pi2002 = 1.01373500
*     local pi2003 = 0.99606230
*     local pi2004 = 0.97680110
*     local pi2005 = 0.99078100
*     local pi2006 = 1.06027100
*     local pi2007 = 1.02288400
*     local pi2008 = 1.04368200
*     local pi2009 = 1.10640200
*     local b1_lam = 0.03827220
*     local b2_lam = -0.00390850
*     local b3_lam = 0.00018880
*     local b4_lam = -0.00000350

**********************************************************************
    /* ... Adding Transfer Income... */

*     local s2a = 0.15263070
*     local psi = 0.96128800
*     local s2n = 0.01469290
*     local s2e = 0.14668700
*     local theta1 = 0.31030790
*     local theta2 = 0.20979510
*     local pi1988 = 1.08718900
*     local pi1989 = 1.07647100
*     local pi1990 = 0.99253320
*     local pi1991 = 0.95930430
*     local pi1992 = 1.02035700
*     local pi1993 = 0.98232820
*     local pi1994 = 0.94626410
*     local pi1995 = 0.94728950
*     local pi1996 = 0.94727060
*     local pi1997 = 0.96180420
*     local pi1998 = 0.99571220
*     local pi1999 = 1.00233800
*     local pi2000 = 0.99230120
*     local pi2001 = 0.95542040
*     local pi2002 = 1.01190400
*     local pi2003 = 0.97178370
*     local pi2004 = 0.99230830
*     local pi2005 = 1.03361500
*     local pi2006 = 1.10368600
*     local pi2007 = 1.08160900
*     local pi2008 = 1.05340000
*     local pi2009 = 1.08081400
*     local b1_lam = 0.03095130
*     local b2_lam = -0.00286230
*     local b3_lam = 0.00013440
*     local b4_lam = -0.00000256

**********************************************************************
    /* ... Adding Investment Income */

*     local s2a = 0.16168940
*     local psi = 0.96886830
*     local s2n = 0.01391140
*     local s2e = 0.13931660
*     local theta1 = 0.31439880
*     local theta2 = 0.21673360
*     local pi1988 = 1.10724800
*     local pi1989 = 1.08465400
*     local pi1990 = 0.99697340
*     local pi1991 = 0.97522860
*     local pi1992 = 1.03028500
*     local pi1993 = 0.99830110
*     local pi1994 = 0.94232170
*     local pi1995 = 0.97072670
*     local pi1996 = 0.97654370
*     local pi1997 = 1.00185700
*     local pi1998 = 1.05590700
*     local pi1999 = 1.04678700
*     local pi2000 = 1.01987100
*     local pi2001 = 0.97354720
*     local pi2002 = 1.01520100
*     local pi2003 = 0.98253280
*     local pi2004 = 1.04194300
*     local pi2005 = 1.10024300
*     local pi2006 = 1.17865100
*     local pi2007 = 1.16874700
*     local pi2008 = 1.08438400
*     local pi2009 = 1.11563600
*     local b1_lam = 0.02329170
*     local b2_lam = -0.00156590
*     local b3_lam = 0.00005330
*     local b4_lam = -0.00000089

**********************************************************************
    /* Estimates for Male Earnings w/ Lower Minimum Threshold (LT) */

*     local s2a = 0.19083350
*     local psi = 0.96167400
*     local s2n = 0.02558920
*     local s2e = 0.22747030
*     local theta1 = 0.24423590
*     local theta2 = 0.13702050
*     local pi1988 = 1.08308800
*     local pi1989 = 1.03192200
*     local pi1990 = 0.97264560
*     local pi1991 = 0.98210740
*     local pi1992 = 1.07104100
*     local pi1993 = 1.08094400
*     local pi1994 = 1.02501400
*     local pi1995 = 1.01397400
*     local pi1996 = 1.02304600
*     local pi1997 = 0.97771270
*     local pi1998 = 0.97996480
*     local pi1999 = 0.94822690
*     local pi2000 = 0.97059660
*     local pi2001 = 1.00847700
*     local pi2002 = 1.03698500
*     local pi2003 = 1.04755600
*     local pi2004 = 1.04075200
*     local pi2005 = 0.99893510
*     local pi2006 = 1.03435700
*     local pi2007 = 1.04132400
*     local pi2008 = 1.05074000
*     local pi2009 = 1.10962200
*     local b1_lam = 0.02475210
*     local b2_lam = -0.00311370
*     local b3_lam = 0.00016970
*     local b4_lam = -0.00000315

**********************************************************************
    /* Estimates for Male Earnings w/ Higher Minimum Threshold (HT2) */  

*     local s2a = 0.15148540
*     local psi = 0.96532460
*     local s2n = 0.02408250
*     local s2e = 0.11706220
*     local theta1 = 0.22040560
*     local theta2 = 0.09986380
*     local pi1988 = 1.05216200
*     local pi1989 = 1.01441900
*     local pi1990 = 0.98006410
*     local pi1991 = 0.97388540
*     local pi1992 = 1.07878700
*     local pi1993 = 1.04929400
*     local pi1994 = 0.99974190
*     local pi1995 = 1.02161600
*     local pi1996 = 1.00858400
*     local pi1997 = 1.03015000
*     local pi1998 = 0.99266650
*     local pi1999 = 0.99222510
*     local pi2000 = 1.03678600
*     local pi2001 = 1.00238900
*     local pi2002 = 1.06624400
*     local pi2003 = 1.01512300
*     local pi2004 = 1.01153700
*     local pi2005 = 0.99428470
*     local pi2006 = 1.06882700
*     local pi2007 = 1.03790500
*     local pi2008 = 1.00895100
*     local pi2009 = 1.03366400
*     local b1_lam = 0.00782490
*     local b2_lam = -0.00010130
*     local b3_lam = -0.00002500
*     local b4_lam = 0.00000099

**********************************************************************
    /* Estimates for Pre-Tax Household Income on All Households Sample w/ Lower Threshold (LT) */   

*     local s2a = 0.18843240
*     local psi = 0.96799930
*     local s2n = 0.02058900
*     local s2e = 0.19015460
*     local theta1 = 0.29608520
*     local theta2 = 0.18441890
*     local pi1988 = 1.04345100
*     local pi1989 = 1.04281300
*     local pi1990 = 0.97955680
*     local pi1991 = 0.97335070
*     local pi1992 = 0.98475850
*     local pi1993 = 0.99007180
*     local pi1994 = 0.94898210
*     local pi1995 = 0.99545560
*     local pi1996 = 0.99621150
*     local pi1997 = 0.97325080
*     local pi1998 = 0.99708590
*     local pi1999 = 0.99731100
*     local pi2000 = 0.96459770
*     local pi2001 = 0.94830000
*     local pi2002 = 0.95592210
*     local pi2003 = 0.99253330
*     local pi2004 = 1.04199600
*     local pi2005 = 1.04063400
*     local pi2006 = 1.10317100
*     local pi2007 = 1.11398600
*     local pi2008 = 1.00823900
*     local pi2009 = 1.03401400
*     local b1_lam = 0.01538590
*     local b2_lam = -0.00031610
*     local b3_lam = -0.00002150
*     local b4_lam = 0.00000065

**********************************************************************
    /* Estimates for Pre-Tax Household Income on All Households Sample w/ Higher Threshold (HT2) */   

*     local s2a = 0.14770170
*     local psi = 0.97005070
*     local s2n = 0.02144720
*     local s2e = 0.11055640
*     local theta1 = 0.27368170
*     local theta2 = 0.15667440
*     local pi1988 = 1.05092000
*     local pi1989 = 1.03151100
*     local pi1990 = 0.96560700
*     local pi1991 = 0.99320630
*     local pi1992 = 1.00452300
*     local pi1993 = 1.00453800
*     local pi1994 = 0.93845330
*     local pi1995 = 0.99727520
*     local pi1996 = 0.99951150
*     local pi1997 = 1.04902400
*     local pi1998 = 1.04958400
*     local pi1999 = 1.03377200
*     local pi2000 = 1.04892900
*     local pi2001 = 0.95611780
*     local pi2002 = 0.99529310
*     local pi2003 = 1.00094500
*     local pi2004 = 1.07414000
*     local pi2005 = 1.10919600
*     local pi2006 = 1.17733500
*     local pi2007 = 1.18282100
*     local pi2008 = 1.05132100
*     local pi2009 = 1.04784200
*     local b1_lam = 0.00502690
*     local b2_lam = 0.00144270
*     local b3_lam = -0.00013900
*     local b4_lam = 0.00000332

**********************************************************************
    /* Estimates for Pre-Tax Household Income with Fixed Family Composition (fixedfamilycomp): */
    /* When couples form & split, treats observations as coming from diff. households. */  

*     local s2a = 0.16941460
*     local psi = 0.96791130
*     local s2n = 0.02109650
*     local s2e = 0.14892350
*     local theta1 = 0.29064140
*     local theta2 = 0.17504200
*     local pi1988 = 1.06028600
*     local pi1989 = 1.04533800
*     local pi1990 = 0.99658800
*     local pi1991 = 0.98315190
*     local pi1992 = 1.00318700
*     local pi1993 = 1.01207000
*     local pi1994 = 0.95642340
*     local pi1995 = 0.99936370
*     local pi1996 = 1.00015300
*     local pi1997 = 1.01271800
*     local pi1998 = 1.05981800
*     local pi1999 = 1.01568500
*     local pi2000 = 1.01038400
*     local pi2001 = 0.97375770
*     local pi2002 = 0.97104480
*     local pi2003 = 0.99034720
*     local pi2004 = 1.08570100
*     local pi2005 = 1.08004600
*     local pi2006 = 1.13341500
*     local pi2007 = 1.14557000
*     local pi2008 = 1.04056100
*     local pi2009 = 1.04316600
*     local b1_lam = 0.01491340
*     local b2_lam = -0.00013050
*     local b3_lam = -0.00003570
*     local b4_lam = 0.00000100

**********************************************************************
    /* Estimates for Pre-Tax Household Income on  Continuously Married Sample (hhinc_mar) */

*     local s2a = 0.19115210
*     local psi = 0.96567660
*     local s2n = 0.02229160
*     local s2e = 0.12368260
*     local theta1 = 0.28289740
*     local theta2 = 0.17375540
*     local pi1988 = 1.06772200
*     local pi1989 = 1.06795800
*     local pi1990 = 1.04303000
*     local pi1991 = 1.03254200
*     local pi1992 = 1.05400900
*     local pi1993 = 1.04322500
*     local pi1994 = 1.02247100
*     local pi1995 = 1.03646000
*     local pi1996 = 1.07683000
*     local pi1997 = 1.07216100
*     local pi1998 = 1.12810400
*     local pi1999 = 1.09439700
*     local pi2000 = 1.08811200
*     local pi2001 = 1.06400400
*     local pi2002 = 1.04466600
*     local pi2003 = 1.08272900
*     local pi2004 = 1.18378100
*     local pi2005 = 1.19430400
*     local pi2006 = 1.26011300
*     local pi2007 = 1.27004800
*     local pi2008 = 1.13079500
*     local pi2009 = 1.10080000
*     local b1_lam = 0.00157980
*     local b2_lam = 0.00170100
*     local b3_lam = -0.00014330
*     local b4_lam = 0.00000319

**********************************************************************
    /* Estimates for Male Earnings with  */
    /* DiNardo-Fortin-Lemieux Reweighting (DFL or _weighted).  */

*     local s2a = 0.17419460
*     local psi = 0.96305550
*     local s2n = 0.02464110
*     local s2e = 0.18341280
*     local theta1 = 0.23430970
*     local theta2 = 0.12621550
*     local pi1988 = 1.07923900
*     local pi1989 = 1.03522300
*     local pi1990 = 0.97629340
*     local pi1991 = 0.96106840
*     local pi1992 = 1.02662800
*     local pi1993 = 1.03421000
*     local pi1994 = 0.96569490
*     local pi1995 = 0.99246660
*     local pi1996 = 0.97984050
*     local pi1997 = 0.96278580
*     local pi1998 = 0.96843430
*     local pi1999 = 0.95483310
*     local pi2000 = 0.97848010
*     local pi2001 = 0.96650790
*     local pi2002 = 1.02843200
*     local pi2003 = 1.01547500
*     local pi2004 = 0.99094050
*     local pi2005 = 0.98097180
*     local pi2006 = 1.03790500
*     local pi2007 = 0.98543160
*     local pi2008 = 1.03352300
*     local pi2009 = 1.07633500
*     local b1_lam = 0.02256400
*     local b2_lam = -0.00272920
*     local b3_lam = 0.00015050
*     local b4_lam = -0.00000293

**********************************************************************
    /* Estimates for Household Income with */
    /* DiNardo-Fortin-Lemieux Reweighting (DFL or _weighted).  */   

*     local s2a = 0.17011480
*     local psi = 0.96865860
*     local s2n = 0.02094230
*     local s2e = 0.14929880
*     local theta1 = 0.29054380
*     local theta2 = 0.17624480
*     local pi1988 = 1.06422400
*     local pi1989 = 1.04934800
*     local pi1990 = 1.00146700
*     local pi1991 = 0.98529460
*     local pi1992 = 1.01408500
*     local pi1993 = 1.01302900
*     local pi1994 = 0.95726830
*     local pi1995 = 0.99973310
*     local pi1996 = 1.00392000
*     local pi1997 = 1.01256400
*     local pi1998 = 1.05842900
*     local pi1999 = 1.02257800
*     local pi2000 = 1.02168700
*     local pi2001 = 0.97601240
*     local pi2002 = 0.97694070
*     local pi2003 = 1.00444400
*     local pi2004 = 1.08718600
*     local pi2005 = 1.10097900
*     local pi2006 = 1.14574900
*     local pi2007 = 1.15115800
*     local pi2008 = 1.05217000
*     local pi2009 = 1.05546800
*     local b1_lam = 0.01319340
*     local b2_lam = 0.00018660
*     local b3_lam = -0.00005960
*     local b4_lam = 0.00000156

**********************************************************************

* Set pi1987

    local pi1987 = 1.0

* Set lambda

    local lam1987 =  1.0       
    local lam1988 = `lam1987' +  (1.0)*(`b1_lam') +  (1.0^2)*(`b2_lam') +  (1.0^3)*(`b3_lam') +  (1.0^4)*(`b4_lam')
    local lam1989 = `lam1987' +  (2.0)*(`b1_lam') +  (2.0^2)*(`b2_lam') +  (2.0^3)*(`b3_lam') +  (2.0^4)*(`b4_lam')
    local lam1990 = `lam1987' +  (3.0)*(`b1_lam') +  (3.0^2)*(`b2_lam') +  (3.0^3)*(`b3_lam') +  (3.0^4)*(`b4_lam')
    local lam1991 = `lam1987' +  (4.0)*(`b1_lam') +  (4.0^2)*(`b2_lam') +  (4.0^3)*(`b3_lam') +  (4.0^4)*(`b4_lam')
    local lam1992 = `lam1987' +  (5.0)*(`b1_lam') +  (5.0^2)*(`b2_lam') +  (5.0^3)*(`b3_lam') +  (5.0^4)*(`b4_lam')
    local lam1993 = `lam1987' +  (6.0)*(`b1_lam') +  (6.0^2)*(`b2_lam') +  (6.0^3)*(`b3_lam') +  (6.0^4)*(`b4_lam')
    local lam1994 = `lam1987' +  (7.0)*(`b1_lam') +  (7.0^2)*(`b2_lam') +  (7.0^3)*(`b3_lam') +  (7.0^4)*(`b4_lam')
    local lam1995 = `lam1987' +  (8.0)*(`b1_lam') +  (8.0^2)*(`b2_lam') +  (8.0^3)*(`b3_lam') +  (8.0^4)*(`b4_lam')
    local lam1996 = `lam1987' +  (9.0)*(`b1_lam') +  (9.0^2)*(`b2_lam') +  (9.0^3)*(`b3_lam') +  (9.0^4)*(`b4_lam')
    local lam1997 = `lam1987' + (10.0)*(`b1_lam') + (10.0^2)*(`b2_lam') + (10.0^3)*(`b3_lam') +  (10.0^4)*(`b4_lam')
    local lam1998 = `lam1987' + (11.0)*(`b1_lam') + (11.0^2)*(`b2_lam') + (11.0^3)*(`b3_lam') +  (11.0^4)*(`b4_lam')
    local lam1999 = `lam1987' + (12.0)*(`b1_lam') + (12.0^2)*(`b2_lam') + (12.0^3)*(`b3_lam') +  (12.0^4)*(`b4_lam')
    local lam2000 = `lam1987' + (13.0)*(`b1_lam') + (13.0^2)*(`b2_lam') + (13.0^3)*(`b3_lam') +  (13.0^4)*(`b4_lam')
    local lam2001 = `lam1987' + (14.0)*(`b1_lam') + (14.0^2)*(`b2_lam') + (14.0^3)*(`b3_lam') +  (14.0^4)*(`b4_lam')
    local lam2002 = `lam1987' + (15.0)*(`b1_lam') + (15.0^2)*(`b2_lam') + (15.0^3)*(`b3_lam') +  (15.0^4)*(`b4_lam')
    local lam2003 = `lam1987' + (16.0)*(`b1_lam') + (16.0^2)*(`b2_lam') + (16.0^3)*(`b3_lam') +  (16.0^4)*(`b4_lam')
    local lam2004 = `lam1987' + (17.0)*(`b1_lam') + (17.0^2)*(`b2_lam') + (17.0^3)*(`b3_lam') +  (17.0^4)*(`b4_lam')
    local lam2005 = `lam1987' + (18.0)*(`b1_lam') + (18.0^2)*(`b2_lam') + (18.0^3)*(`b3_lam') +  (18.0^4)*(`b4_lam')
    local lam2006 = `lam1987' + (19.0)*(`b1_lam') + (19.0^2)*(`b2_lam') + (19.0^3)*(`b3_lam') +  (19.0^4)*(`b4_lam')
    local lam2007 = `lam1987' + (20.0)*(`b1_lam') + (20.0^2)*(`b2_lam') + (20.0^3)*(`b3_lam') +  (20.0^4)*(`b4_lam')
    local lam2008 = `lam1987' + (21.0)*(`b1_lam') + (21.0^2)*(`b2_lam') + (21.0^3)*(`b3_lam') +  (21.0^4)*(`b4_lam')
    local lam2009 = `lam1987' + (22.0)*(`b1_lam') + (22.0^2)*(`b2_lam') + (22.0^3)*(`b3_lam') +  (22.0^4)*(`b4_lam')

    * NOTE: Create scalars such as pi1990 with the same value as local macro `pi1990'
    * to access below by references such as pi`h' (where `h' is a macro: an index from a loop).

    scalar pi1987 = `pi1987'
    scalar pi1988 = `pi1988'
    scalar pi1989 = `pi1989'
    scalar pi1990 = `pi1990'
    scalar pi1991 = `pi1991'
    scalar pi1992 = `pi1992'
    scalar pi1993 = `pi1993'
    scalar pi1994 = `pi1994'
    scalar pi1995 = `pi1995'
    scalar pi1996 = `pi1996'
    scalar pi1997 = `pi1997'
    scalar pi1998 = `pi1998'
    scalar pi1999 = `pi1999'
    scalar pi2000 = `pi2000'
    scalar pi2001 = `pi2001'
    scalar pi2002 = `pi2002'
    scalar pi2003 = `pi2003'
    scalar pi2004 = `pi2004'
    scalar pi2005 = `pi2005'
    scalar pi2006 = `pi2006'
    scalar pi2007 = `pi2007'
    scalar pi2008 = `pi2008'
    scalar pi2009 = `pi2009'

    scalar lam1987 = `lam1987'
    scalar lam1988 = `lam1988'
    scalar lam1989 = `lam1989'
    scalar lam1990 = `lam1990'
    scalar lam1991 = `lam1991'
    scalar lam1992 = `lam1992'
    scalar lam1993 = `lam1993'
    scalar lam1994 = `lam1994'
    scalar lam1995 = `lam1995'
    scalar lam1996 = `lam1996'
    scalar lam1997 = `lam1997'
    scalar lam1998 = `lam1998'
    scalar lam1999 = `lam1999'
    scalar lam2000 = `lam2000'
    scalar lam2001 = `lam2001'
    scalar lam2002 = `lam2002'
    scalar lam2003 = `lam2003'
    scalar lam2004 = `lam2004'
    scalar lam2005 = `lam2005'
    scalar lam2006 = `lam2006'
    scalar lam2007 = `lam2007'
    scalar lam2008 = `lam2008'
    scalar lam2009 = `lam2009'

    * Specify piXXXX for a few years before 1987.
    * Create the piXXXX both as local macro and as scalar.

    local pi1981 = 1.0
    local pi1982 = 1.0
    local pi1983 = 1.0
    local pi1984 = 1.0
    local pi1985 = 1.0
    local pi1986 = 1.0

    scalar pi1981 = `pi1981'
    scalar pi1982 = `pi1982'
    scalar pi1983 = `pi1983'
    scalar pi1984 = `pi1984'
    scalar pi1985 = `pi1985'
    scalar pi1986 = `pi1986'


*** Loop to assign values to scalar varp_`yr'_`age'

  forvalues cohort = 1952(1)2009 {

    forvalues age = 1(1)36 {

      local yr    = `cohort' + `age' - 1
      local yrm1  = `yr' - 1
      local yrm2  = `yr' - 2
      local agem1 = `age' - 1

      if `yr' <= 2009 {

        if `age' == 1 {
           scalar varp_`yr'_`age' = (`s2n')
        }

        if `age' >= 2 {
           scalar varp_`yr'_`age' = ((`psi')^2)*varp_`yrm1'_`agem1' + (`s2n')
        }

      }

    }

  }



***** Assign values to dependent variable:


    /* Initialize output variables */

    set obs 10000

    gen year = 0

    gen lead = 0

    gen PE = 0

    gen ycov = 0

    gen perm = 0

    gen tran = 0

    /* Initialize counter for output */

    local n = 1


***** Assign values to dependent variable:

    forvalues t = 1987(1)2009 {
      local tm1 = `t'-1
      local tm2 = `t'-2
      local maxK = 2009-`t'
      forvalues h = 1(1)36 {
        forvalues k = 0(1)`maxK' {
          local tpk = `t'+`k'

          /* Output result to observation n */

          qui replace ycov = (lam`t')*(lam`tpk')*(`s2a' + ((`psi')^(`k'))*varp_`t'_`h' ) + (`k'==0)*(`s2e')*( ((pi`t')^2) + (`h'>=2)*((pi`tm1')^2)*((`theta1')^2) + (`h'>=3)*((pi`tm2')^2)*((`theta2')^2) )  + (`k'==1)*(`s2e')*( ((pi`t')^2)*(`theta1') + (`h'>=2)*((pi`tm1')^2)*(`theta1')*(`theta2') ) + (`k'==2)*(`s2e')*( ((pi`t')^2)*(`theta2') )  if _n == `n'

          qui replace perm = (lam`t')*(lam`tpk')*(`s2a' + ((`psi')^(`k'))*varp_`t'_`h' )  if _n == `n'

          qui replace tran = (`k'==0)*(`s2e')*( ((pi`t')^2) + (`h'>=2)*((pi`tm1')^2)*((`theta1')^2) + (`h'>=3)*((pi`tm2')^2)*((`theta2')^2) )  + (`k'==1)*(`s2e')*( ((pi`t')^2)*(`theta1') + (`h'>=2)*((pi`tm1')^2)*(`theta1')*(`theta2') ) + (`k'==2)*(`s2e')*( ((pi`t')^2)*(`theta2') )  if _n == `n'

          qui replace year = `t' if _n == `n'
          qui replace lead = `k' if _n == `n'
          qui replace PE   = `h' if _n == `n'

          /* Increment counter for output */
          local n = `n' + 1

        }
      }
    }


    *foreach h of numlist 1 5 15 20 25 35 {
    *    list PE year ycov perm tran  if (lead==0 & PE==`h'), clean noobs
    *}

    *******************************************************************
    * Compute permanent-transitory variance decomposition for
    * all values of age (PE), weighting by the relative age weights for
    * each calendar year.  Make sure to read the appropriate weights
    * file (see below, merge statement).
    *******************************************************************

    keep if year!=0

    keep if lead==0

    * merge age dist'n weights

    sort year PE

    merge year PE using  `path'/`weights'


    keep if _merge==3
    drop _merge

    gen ycov_w = ycov*weight   /* multiply by weights to compute weighted means */
    gen perm_w = perm*weight   /* note: weights add to 1 across PE for each year */
    gen tran_w = tran*weight


    collapse (sum) ycov_w perm_w tran_w, by(year)   /* computes weighted average */


    disp "Persistent-Transitory Variance Decomposition: Total, Persistent, Transitory "    
    list, clean noobs




