* Set path to directory where covariance data is located.
* Then select the desired income measure and sample by commenting 
* out/uncommenting statement that reads the covariance data.
* (Make sure that corresponding .ado file has been saved in the 
* appropriate directory.)

clear
set mem 10m
set more off

log using Estimate_BaselineECM_poly4, text replace

local path /fa/home/m1ixv00/labinc/BPEA/covs_data


********************************************************************************
* Parameters
********************************************************************************

* Say, years OBSERVED: 1987-2009
local year1 = 1987
local year2 = 1988
local yearT = 2009

local cohort1 = 1952   /* first cohort */
local cohortT = 2009   /* last cohort */


****************************************************************************************************************
****************************************************************************************************************
*************************************** Read Covariance Data ***************************************************
****************************************************************************************************************
****************************************************************************************************************


* Labor Income
   use  yrvar hvar jvar covvar wgtvar  using `path'/CovsData_labinc_CAL.dta, clear

* Household Income (Before-Tax) on Male Earnings Sample
***use  yrvar hvar jvar covvar wgtvar  using `path'/CovsData_hhinc-labincsample_CAL.dta, clear

* Household Income (Before-Tax)
***use  yrvar hvar jvar covvar wgtvar  using `path'/CovsData_hhinc_CAL.dta, clear

* Household Income (After-Tax)
***use  yrvar hvar jvar covvar wgtvar  using `path'/CovsData_hhincat_CAL.dta, clear

*  Household Income (Before-Tax), Low Threshold (LT)
***use  yrvar hvar jvar covvar wgtvar  using `path'/CovsData_hhinc_LT_CAL.dta, clear

*  Household Income (Before-Tax), High Threshold (HT)
***use  yrvar hvar jvar covvar wgtvar  using `path'/CovsData_hhinc_HT2_CAL.dta, clear

*  Household Income (Before-Tax) on Male Earnings Sample, Low Threshold (LT)
***use  yrvar hvar jvar covvar wgtvar  using `path'/CovsData_hhinc-labincsample_LT_CAL.dta, clear

*  Household Income (Before-Tax) on Male Earnings Sample, High Threshold (HT)
***use  yrvar hvar jvar covvar wgtvar  using `path'/CovsData_hhinc-labincsample_HT2_CAL.dta, clear

* Household Income (Before-Tax), Continuously Married Sample
***use  yrvar hvar jvar covvar wgtvar  using `path'/CovsData_hhinc_mar_CAL.dta, clear

*** BUILD-UP TO BROADER INCOME MEASURES, ON LABINC SAMPLE

* Income1 on Male Earnings Sample
***use  yrvar hvar jvar covvar wgtvar  using `path'/CovsData_income1_labincsample_CAL.dta, clear

* Income2 on Male Earnings Sample
***use  yrvar hvar jvar covvar wgtvar  using `path'/CovsData_income2_labincsample_CAL.dta, clear

* Income3 on Male Earnings Sample
***use  yrvar hvar jvar covvar wgtvar  using `path'/CovsData_income3_labincsample_CAL.dta, clear



summ
more

* Arrange data

drop if (covvar==.)
***drop if (wgtvar==0)
***drop if (wgtvar==.)

* Drop if too few observations were used to compute sample covariance

***drop if (jvar>10)
***drop if (wgtvar<100)
more

* Create dummy variable Dj0, which equals 1 if jvar==0 and equals 0 otherwise

gen Dj0=0
replace Dj0=1 if (jvar==0)

********************************************************************************
* Pick observations used for estimation
********************************************************************************

gen cohort = yrvar - hvar + 1

keep if (cohort>=`cohort1' & cohort<=`cohortT')

keep if (yrvar>=`year1' & yrvar<=`yearT')

* Make sure that "future" years used to compute autocovariances do not fall 
* outside of [year1,yearT] range:

gen yearpj = (cohort-1) + hvar + jvar  /* identical to setting yearpj = year + jvar */

keep if (yearpj>=`year1' & yearpj<=`yearT')

summ

********************************************************************************
* Call nls 
********************************************************************************

   nl _BaselineECM_poly4 @ covvar hvar jvar Dj0 yrvar [aweight=wgtvar], parameters(s2a psi s2n s2e theta1 theta2 pi88 pi89 pi90 pi91 pi92 pi93 pi94 pi95 pi96 pi97 pi98 pi99 pi00 pi01 pi02 pi03 pi04 pi05 pi06 pi07 pi08 pi09 b1_lam b2_lam b3_lam b4_lam) initial(s2a 0.1 psi 0.9 s2n .001 s2e .1 theta1 0.0 theta2 0.0 pi88 1.0 pi89 1.0 pi90 1.0 pi91 1.0 pi92 1.0 pi93 1.0 pi94 1.0 pi95 1.0 pi96 1.0 pi97 1.0 pi98 1.0 pi99 1.0 pi00 1.0 pi01 1.0 pi02 1.0 pi03 1.0 pi04 1.0 pi05 1.0 pi06 1.0 pi07 1.0 pi08 1.0 pi09 1.0 b1_lam 0.0 b2_lam 0.0 b3_lam 0.0 b4_lam 0.0) robust


log close















