# delimit;
set more 1;
cap log close;
set logtype text;
clear;

local minN = 20;
local maxLag = 25;

*local var labinc;
local var hhinc;

global savedir  ../inputdata;
global savedirmoments ../inputdata;

*global covfile ../../../Data/covariance/CovsData_labinc_CAL;
global covfile ../../../Data/covariance/CovsData_hhinc_CAL;

global firstyear 1987; 


	*outsheet variances by age to compare with the summary data and estimates;
********use $covfile`var'.dta, clear;
	use $covfile.dta, clear;

	************************************************;
	* Convert our covariance data from leads to lags;
	gen yrpjvar = yrvar + jvar;
	gen year_new = yrpjvar;
	gen age_new  = hpjvar;
	gen lag_new = jvar;
	rename covvar cov;
	rename wgtvar nobs;
	rename year_new year;
	rename age_new age;
	rename lag_new lag;
	keep year age lag cov nobs;
	************************************************;

	keep if nobs>=`minN';
	keep if lag==0;
	keep if year>=$firstyear;

	collapse (mean) cov [aweight = nobs], by(age);
	outsheet using $savedirmoments/`var'/VariancesByExperience_`var'.txt, replace;
	outsheet cov using $savedir/`var'/AvVarByExper.txt, replace non;
	
	*outsheet autocovariance function averaged over experience;
********use $covfile`var'.dta, clear;
	use $covfile.dta, clear;

	************************************************;
	* Convert our covariance data from leads to lags;
	gen yrpjvar = yrvar + jvar;
	gen year_new = yrpjvar;
	gen age_new  = hpjvar;
	gen lag_new = jvar;
	rename covvar cov;
	rename wgtvar nobs;
	rename year_new year;
	rename age_new age;
	rename lag_new lag;
	keep year age lag cov nobs;
	************************************************;

	keep if nobs>=`minN';
	keep if lag<= `maxLag';
	keep if year>=$firstyear;
	preserve;
	collapse (mean) cov [aweight = nobs], by(lag);
	outsheet using $savedirmoments/`var'/AutocovarianceFn.txt, replace;
	restore;

	*save output in text files to be used in Fortran;
	sort age lag;
	outsheet cov using $savedir/`var'/cov.txt, non replace;
	outsheet age using $savedir/`var'/age.txt, non replace;
	outsheet lag using $savedir/`var'/lag.txt, non replace;
	outsheet nobs using $savedir/`var'/nobs.txt, non replace;
	outsheet year using $savedir/`var'/year.txt, non replace;


