clear all
set more off

local nbstraps = 200

local var labinc
*local var hhinc

global savedir  ../inputdata

 global covfile  covfile ../../../Data/covariance/bootstrap/CovsData_labinc_CAL_boot
*global covfile  covfile ../../../Data/covariance/bootstrap/CovsData_hhinc_CAL_boot

local minN = 10        /* minimum number of observations required to compute a moment */


* Do 'nbstraps' bootstraps

forvalues ibs = 1(1)`nbstraps' {

        use $covfile`ibs'.dta, clear

	************************************************
	* Convert our covariance data from leads to lags
	gen yrpjvar = yrvar + jvar
	gen year_new = yrpjvar
	gen age_new  = hpjvar
	gen lag_new = jvar
	rename covvar cov
	rename wgtvar nobs
	rename year_new year
	rename age_new age
	rename lag_new lag
	keep year age lag cov nobs
	************************************************

	* apply any selection rules
	keep if nobs>=`minN'

	*save output in text files to be used in Fortran
	sort age lag
	outsheet cov using  $savedir/`var'/bs`ibs'/cov.txt,  non replace
	outsheet age using  $savedir/`var'/bs`ibs'/age.txt,  non replace
	outsheet lag using  $savedir/`var'/bs`ibs'/lag.txt,  non replace
	outsheet nobs using $savedir/`var'/bs`ibs'/nobs.txt, non replace
	outsheet year using $savedir/`var'/bs`ibs'/year.txt, non replace

        gen nmoments = _N
        keep in 1                  /* keep only 1st observation */
	outsheet nmoments using   $savedir/`var'/bs`ibs'/nmoments.txt, non replace

}



