% Matlab program to collect information from bootstaps and compute SEs.

clear 

nbstraps = 200;
nyears = 23;    % 23 FOR TAX DATA (22 FOR PSID)

% Create strings to be used in forming string 'filename'

path = '/fa/home/m1ixv00/labinc/BPEA/GregModels/fortranoutput'

%%%subdir = '/labinc/'                    % Change to desired subdirectory!
%%%subdir = '/hhinc_labincsample/'
subdir = '/hhinc/'
%%%subdir = '/hhincat_labincsample/'
%%%subdir = '/hhincat/'



s1 = 'bs';

s_rho = '/rho.txt';
s_theta1 = '/theta1.txt';
s_theta2 = '/theta2.txt';
s_vfe = '/vfe.txt';
s_veta = '/veta.txt';
s_vepsyear = '/vepsyear.txt';
s_pi = '/pi.txt';
s_phi = '/phi.txt';
s_b0 = '/b0.txt';
s_b1 = '/b1.txt';
s_b2 = '/b2.txt';
s_b3 = '/b3.txt';
s_b4 = '/b4.txt';


% Initialize vectors and matrices

rho   = NaN*ones(nbstraps,1);
theta1 = NaN*ones(nbstraps,1);
theta2 = NaN*ones(nbstraps,1);
vfe = NaN*ones(nbstraps,nyears);
veta = NaN*ones(nbstraps,nyears);
vepsyear = NaN*ones(nbstraps,nyears);
pi = NaN*ones(nbstraps,nyears);
phi = NaN*ones(nbstraps,nyears);
b0   = NaN*ones(nbstraps,1);
b1   = NaN*ones(nbstraps,1);
b2   = NaN*ones(nbstraps,1);
b3   = NaN*ones(nbstraps,1);
b4   = NaN*ones(nbstraps,1);


% Read data loop

for ibs = 1:nbstraps

  s2 = num2str(ibs);           % convert index ibs to string

  filename = [path subdir s1 s2 s_rho];        % concatenate strings to form name of file
  rho(ibs) = importdata(filename);             % read data

  filename = [path subdir s1 s2 s_theta1];
  theta1(ibs) = importdata(filename);

  filename = [path subdir s1 s2 s_theta2];
  theta2(ibs) = importdata(filename);

  filename = [path subdir s1 s2 s_vfe];      
  vfe(ibs,:) = importdata(filename);

  filename = [path subdir s1 s2 s_veta];      
  veta(ibs,:) = importdata(filename);

  filename = [path subdir s1 s2 s_vepsyear];
  vepsyear(ibs,:) = importdata(filename);

  filename = [path subdir s1 s2 s_pi];
  pi(ibs,:) = importdata(filename);

  filename = [path subdir s1 s2 s_phi];
  phi(ibs,:) = importdata(filename);

  filename = [path subdir s1 s2 s_b0];
  b0(ibs) = importdata(filename);

  filename = [path subdir s1 s2 s_b1];
  b1(ibs) = importdata(filename);

  filename = [path subdir s1 s2 s_b2];
  b2(ibs) = importdata(filename);

  filename = [path subdir s1 s2 s_b3];
  b3(ibs) = importdata(filename);

  filename = [path subdir s1 s2 s_b4];
  b4(ibs) = importdata(filename);

end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Compute means and st devs and display results
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

format long

% Means

mean_rho = mean(rho)
mean_theta1 = mean(theta1)
mean_theta2 = mean(theta2)
mean_vfe = mean(vfe(:,:))'
mean_veta = mean(veta(:,:))'
mean_vepsyear = mean(vepsyear(:,:))'
mean_pi = mean(abs(pi(:,:)))'      % take absolute value b/c pi  can be >0 or <0, but gets squared in estimation program, so no difference.
mean_phi = mean(abs(phi(:,:)))'    % take absolute value b/c phi can be >0 or <0, but gets squared in estimation program, so no difference.
mean_b0 = mean(b0)
mean_b1 = mean(b1)
mean_b2 = mean(b2)
mean_b3 = mean(b3)
mean_b4 = mean(b4)

% Standard Deviations

sd_rho = std(rho)
sd_theta1 = std(theta1)
sd_theta2 = std(theta2)
sd_vfe = std(vfe(:,:))'
sd_veta = std(veta(:,:))'
sd_vepsyear = std(vepsyear(:,:))'
sd_pi = std(abs(pi(:,:)))'      % take absolute value b/c pi  can be >0 or <0, but gets squared in estimation program, so no difference.
sd_phi = std(abs(phi(:,:)))'    % take absolute value b/c phi can be >0 or <0, but gets squared in estimation program, so no difference.
sd_b0 = std(b0)
sd_b1 = std(b1)
sd_b2 = std(b2)
sd_b3 = std(b3)
sd_b4 = std(b4)








