MODULE Parameters
IMPLICIT NONE
SAVE

INTEGER, PARAMETER:: LONG = SELECTED_REAL_KIND (15,100) !15 instead of 8

!OPTIONS
integer, parameter  :: RunOnLinux       = 1
integer, parameter  :: Bootstrap        = 0
integer, parameter  :: RestrictRandWalk = 0
integer, parameter  :: IncludeMA2Trans  = 1 
integer, parameter  :: IncludeAR1Trans  = 0 

integer, parameter	:: IncludeFE		= 1
integer, parameter	:: AgeEffectsTrans	= 0	!<9 for order of polynomial, 9 for nonparametric. if year effects trans, then must= 9,0
integer, parameter	:: YearEffectsTrans	= 1
integer, parameter	:: YearEffectsPers	= 1
integer, parameter	:: DeBackerVersion	= 0	!models persistent time effects on the level, not the innovation
integer, parameter	:: YearEffectsFE	= 1
integer, parameter	:: FEPersEqual		= 0 !If includeFE=1 then this puts year effects in the FE equal to those of Persistent shocks (sacled). Cannot have YearEffectsFE=1 at same time

integer, parameter	:: IncludePH		= 0
integer, parameter	:: IncludePHcovFE	= 0
integer, parameter	:: IdentityWeight  = 0

!DIRECTORY TO SAVE OUTPUT
!character(len=*), parameter   :: savedir = "../fortranoutput/labinc/"
character(len=*), parameter   :: savedir = "../fortranoutput/hhinc/"

!DATA DIRECTORY
!character(len=*), parameter  :: datadir ="../inputdata/labinc/"
!character(len=*), parameter  :: bsdir = "../inputdata/labinc/"
character(len=*), parameter  :: datadir ="../inputdata/hhinc/"
character(len=*), parameter  :: bsdir = "../inputdata/hhinc/"


integer, parameter :: nlag = 25	!maximum number of covariance for any age/year, not including the variance

integer, parameter :: minage = 1				
integer, parameter :: maxage = 36   
integer, parameter :: nage = maxage-minage+1
integer, parameter :: minyear = 1987    
integer, parameter :: maxyear = 2009
integer, parameter :: nyear = maxyear-minyear+1

integer, parameter :: nmomentsALL = 7912   ! 7912 for data; 7636 for SIM   
integer, parameter :: nbstraps = 200

END MODULE Parameters

