SUBROUTINE OutputResults

USE Parameters
USE Globals
USE Procedures

IMPLICIT NONE

INTEGER	:: il
CHARACTER(len=23) ::	a

OPEN(3, FILE = savedir // 'rho.txt', STATUS = 'replace'); WRITE(3,*) rho; CLOSE(3)
OPEN(3, FILE = savedir // 'theta1.txt', STATUS = 'replace'); WRITE(3,*) theta1; CLOSE(3)
OPEN(3, FILE = savedir // 'theta2.txt', STATUS = 'replace'); WRITE(3,*) theta2; CLOSE(3)
OPEN(3, FILE = savedir // 'omega.txt', STATUS = 'replace'); WRITE(3,*) omega; CLOSE(3)
OPEN(3, FILE = savedir // 'covph.txt', STATUS = 'replace'); WRITE(3,*) covph; CLOSE(3)
OPEN(3, FILE = savedir // 'vph.txt', STATUS = 'replace'); WRITE(3,*) vph; CLOSE(3)
OPEN(3, FILE = savedir // 'varalpha.txt', STATUS = 'replace'); WRITE(3,*) varalpha; CLOSE(3)
OPEN(3, FILE = savedir // 'vareta.txt', STATUS = 'replace'); WRITE(3,*) vareta; CLOSE(3)
OPEN(3, FILE = savedir // 'vareps_vec.txt', STATUS = 'replace'); CALL WriteMatrix(3,nage,1,vareps_vec)
OPEN(3, FILE = savedir // 'veta.txt', STATUS = 'replace'); CALL WriteMatrix(3,nyear,1,veta)
OPEN(3, FILE = savedir // 'vfe.txt', STATUS = 'replace'); CALL WriteMatrix(3,nyear,1,vfe)
OPEN(3, FILE = savedir // 'vepsage.txt', STATUS = 'replace'); CALL WriteMatrix(3,nage,1,vepsage)
OPEN(3, FILE = savedir // 'vepsyear.txt', STATUS = 'replace'); CALL WriteMatrix(3,nyear,1,vepsyear)
OPEN(3, FILE = savedir // 'veps.txt', STATUS = 'replace'); CALL WriteMatrix(3,nage,nyear,veps)
OPEN(3, FILE = savedir // 'Vy.txt', STATUS = 'replace'); CALL WriteMatrix(3,nage,nyear,Vy)
OPEN(3, FILE = savedir // 'Vz.txt', STATUS = 'replace'); CALL WriteMatrix(3,nage,nyear,Vz)
OPEN(3, FILE = savedir // 'Vu.txt', STATUS = 'replace'); CALL WriteMatrix(3,nage,nyear,Vu)
OPEN(3, FILE = savedir // 'dataVy.txt', STATUS = 'replace'); CALL WriteMatrix(3,nage,nyear,dataVy)
OPEN(3, FILE = savedir // 'dbscalepers.txt', STATUS = 'replace'); CALL WriteMatrix(3,nyear,1,dbscale)
OPEN(3, FILE = savedir // 'dbscalefe.txt', STATUS = 'replace'); CALL WriteMatrix(3,nyear,1,dbscale)
OPEN(3, FILE = savedir // 'b0.txt', STATUS = 'replace'); WRITE(3,*) b0; CLOSE(3)
OPEN(3, FILE = savedir // 'b1.txt', STATUS = 'replace'); WRITE(3,*) b1; CLOSE(3)
OPEN(3, FILE = savedir // 'b2.txt', STATUS = 'replace'); WRITE(3,*) b2; CLOSE(3)
OPEN(3, FILE = savedir // 'b3.txt', STATUS = 'replace'); WRITE(3,*) b3; CLOSE(3)
OPEN(3, FILE = savedir // 'b4.txt', STATUS = 'replace'); WRITE(3,*) b4; CLOSE(3)
OPEN(3, FILE = savedir // 'pi.txt', STATUS = 'replace'); CALL WriteMatrix(3,nyear,1,pi)
OPEN(3, FILE = savedir // 'phi.txt', STATUS = 'replace'); CALL WriteMatrix(3,nyear,1,phi)
IF(FEPersEqual==0) THEN
	dbscale = 1.0
	OPEN(3, FILE = savedir // 'dbscalefe.txt', STATUS = 'replace'); CALL WriteMatrix(3,nyear,1,dbscale)
END IF

DO il = 1,nlag
	IF(il<10) write (a,FMT='(I1)') il
	IF(il>=10) write (a,FMT='(I2)') il
	OPEN(3, FILE = savedir // 'COVy' // trim(a)  //'.txt', STATUS = 'replace')
	CALL WriteMatrix(3,nage,nyear,COVy(:,:,il))
	OPEN(3, FILE = savedir // 'dataCOVy' // trim(a)  //'.txt', STATUS = 'replace')
	CALL WriteMatrix(3,nage,nyear,dataCOVy(:,:,il))
END DO
END SUBROUTINE OutputResults
