! Modifying code to use with Tax data.
! _lampoly3 restricts vfe (i.e. 'lambda') to be cubic polynomial.
! _lampoly4 restricts vfe (i.e. 'lambda') to be quartic polynomial.
! Using MA2 transitory error.
! In this version, reparameterized poly4 to correspond to parameterization
! in our Stata programs.
!

SUBROUTINE ObjFunction (M,N,X,F,info)

USE Parameters
USE Globals
IMPLICIT NONE

!Local Variables
!-----------------------
INTEGER, INTENT(IN) :: M						!number of equations / moment conditions
INTEGER, INTENT(IN)	:: N,info						!number of parameters
REAL(8), DIMENSION(N), INTENT(IN) :: X		!parameter vector: (rho, lveta, lveps)
REAL(8), DIMENSION(M), INTENT(OUT) :: F		!moment conditions
INTEGER				:: ia, it, im,ip, id, io
REAL(8)			:: lweight
REAL(8)		    :: lrho,lveta(nyear),lvepsyear(nyear),lvfe(nyear),lvepsage(nage),lveps(nage,nyear),lvph,lcovph,ltheta1,ltheta2,lomega,ldbscale(nyear)

REAL(8)		    :: b0_vfe,b1_vfe,b2_vfe,b3_vfe,b4_vfe      ! IVS: Declare coeffs for vfe polynomial

REAL(8)		    :: lambda(nyear),lpi(nyear),lphi(nyear)

ldbscale = 1.0

! 1. Extract parameters, incorporating identifying assumptions

ip = 1

IF(RestrictRandWalk==0) THEN
	lrho = X(ip)
	ip = ip+1
ELSE
	lrho = 1.0
END IF	

IF(IncludeMA2Trans==1) THEN
	ltheta1 = X(ip)
	ip = ip+1
	ltheta2 = X(ip)
	ip = ip+1
ELSE
	ltheta1 = 0.0
	ltheta2 = 0.0
END IF	

IF(IncludeAR1Trans==1) THEN
	lomega = X(ip)
	ip = ip+1
ELSE
	lomega = 0.0
END IF	


IF(IncludeFE==1 .and. YearEffectsFE==0) THEN
	lvfe = X(ip)
	ip = ip+1
ELSE IF(IncludeFE==1 .and. YearEffectsFE==1) THEN
	!!!lvfe(1:1996-minyear+1) = X(ip:ip + 1996-minyear)
	!!!lvfe(1996-minyear+3) = X(ip + 1996-minyear+1)						!1998
	!!!lvfe(1996-minyear+5) = X(ip + 1996-minyear+2)						!2000
	!!!lvfe(1996-minyear+7) = X(ip + 1996-minyear+3)						!2002
	!!!lvfe(1996-minyear+9) = X(ip + 1996-minyear+4)						!2004
	!!!lvfe(1996-minyear+11) = X(ip + 1996-minyear+5)						!2006
	!!!lvfe(1996-minyear+2) = 0.5*(X(ip + 1996-minyear)	+ X(ip + 1996-minyear+1))	!1997
	!!!lvfe(1996-minyear+4) = 0.5*(X(ip + 1996-minyear+1)	+ X(ip + 1996-minyear+2))	!1999
	!!!lvfe(1996-minyear+6) = 0.5*(X(ip + 1996-minyear+2)	+ X(ip + 1996-minyear+3))	!2001
	!!!lvfe(1996-minyear+8) = 0.5*(X(ip + 1996-minyear+3)	+ X(ip + 1996-minyear+4))	!2003
	!!!lvfe(1996-minyear+10) = 0.5*(X(ip + 1996-minyear+4)	+ X(ip + 1996-minyear+5))	!2005

	!!!lvfe(1996-minyear+11:1996-minyear+13) = lvfe(1996-minyear+11)	!2007,2008
	!!!ip = ip+ 1996-minyear+6

	!!!lvfe(1:2009-minyear-1) = X(ip:ip + 2009-minyear-2)              ! IVS: 21 elements (corresponding to 1987-2007).
	!!!lvfe(2009-minyear:2009-minyear+1) = lvfe(2009-minyear-1)	! IVS: Set last two elements (2008-2009) to 2007 value.
	!!!ip = ip+ 2009-minyear-2+1                                       ! IVS:

	! Restricting lvfe to be quartic polynomial:

	b0_vfe    = X(ip)            ! IVS: This parameter is now sig_alpha (st dev of FE in first year, 1987)
	b1_vfe    = X(ip+1)          ! IVS: polynomial coefficients
	b2_vfe    = X(ip+2)          ! IVS:
	b3_vfe    = X(ip+3)          ! IVS:
	b4_vfe    = X(ip+4)          ! IVS:

        lambda(1) = 1.0

	DO it = 2,nyear

	    lambda(it) = 1.0 + b1_vfe*(real(it-1)) + b2_vfe*(real((it-1)**2)) + b3_vfe*(real((it-1)**3)) + b4_vfe*(real((it-1)**4))         ! IVS:

	END DO

	DO it = 1,nyear

	    lvfe(it) = b0_vfe*lambda(it)        ! IVS: i.e. sig_alpha*lambda(it); note that this will get squared below to form the actual lvfe

	END DO

	ip = ip+ 5                                      ! IVS: update index



	!OPEN(5, FILE = '/fa/home/m1ixv00/labinc/BPEA/GregModels/fortranoutput/Objfunction_vfe.txt', POSITION= 'APPEND', STATUS = 'UNKNOWN')
	!WRITE(5,*) lvfe
	!WRITE(5,*) 'b0_vfe= ', b0_vfe
	!WRITE(5,*) 'b1_vfe= ', b1_vfe
	!WRITE(5,*) 'b2_vfe= ', b2_vfe
	!WRITE(5,*) 'b3_vfe= ', b3_vfe
	!WRITE(5,*) '(real(it-1))= ', (real(it-1))
	!WRITE(5,*) '(real((it-1)**2))= ', (real((it-1)**2))
	!WRITE(5,*) '(real((it-1)**3))= ', (real((it-1)**3))
	!WRITE(5,*) 'it= ', it
	!WRITE(5,*) 'nyear= ', nyear
	!CLOSE(5)

 

ELSE IF(IncludeFE==0) THEN
	lvfe = 0.0
END IF

IF(YearEffectsPers==0)	THEN
	lveta = X(ip)
	ip = ip+1
	ldbscale = 1.0
ELSE IF(YearEffectsPers==1 .and. DeBackerVersion==0)	THEN
	!!!lveta(1:1996-minyear+1) = X(ip:ip + 1996-minyear)
	!!!lveta(1996-minyear+3) = X(ip + 1996-minyear+1)						!1998
	!!!lveta(1996-minyear+5) = X(ip + 1996-minyear+2)						!2000
	!!!lveta(1996-minyear+7) = X(ip + 1996-minyear+3)						!2002
	!!!lveta(1996-minyear+9) = X(ip + 1996-minyear+4)						!2004
	!!!lveta(1996-minyear+11) = X(ip + 1996-minyear+5)						!2006
	!!!lveta(1996-minyear+2) = 0.5*(X(ip + 1996-minyear)	+ X(ip + 1996-minyear+1))	!1997
	!!!lveta(1996-minyear+4) = 0.5*(X(ip + 1996-minyear+1)	+ X(ip + 1996-minyear+2))	!1999
	!!!lveta(1996-minyear+6) = 0.5*(X(ip + 1996-minyear+2)	+ X(ip + 1996-minyear+3))	!2001
	!!!lveta(1996-minyear+8) = 0.5*(X(ip + 1996-minyear+3)	+ X(ip + 1996-minyear+4))	!2003
	!!!lveta(1996-minyear+10) = 0.5*(X(ip + 1996-minyear+4)	+ X(ip + 1996-minyear+5))	!2005

	!!!lveta(1996-minyear+11:1996-minyear+13) = lveta(1996-minyear+11)	!2007,2008
	!!!ip = ip+ 1996-minyear+6

	!!!lveta(1:2009-minyear-1) = X(ip:ip + 2009-minyear-2)	                ! IVS: 21 elements (corresponding to 1987-2007).
	!!!lveta(2009-minyear:2009-minyear+1) = lveta(2009-minyear-1)	        ! IVS: Set last two elements (2008-2009) to 2007 value.
	!!!ip = ip+ 2009-minyear-2+1	                                        ! IVS:


	!!!!!!lveta(1:2009-minyear) = X(ip:ip + 2009-minyear-1)	                ! IVS: 22 elements (corresponding to 1987-2008).
	!!!!!!lveta(2009-minyear+1) = lveta(2009-minyear)	                        ! IVS: Set last element (2009) to 2008 value.
	!!!!!!ip = ip+ 2009-minyear-1+1	                                        ! IVS:




	lveta(1) = X(ip)	                                    ! IVS: The first element is the ST DEV of eta shock in 1st year (1987); when phi(1)==1.0.

	lphi(1) = 1.0
	lphi(2:2009-minyear) = X(ip+1:ip + 2009-minyear-1)
	lphi(2009-minyear+1) = lphi(2009-minyear)                   ! IVS: Set 2009 equal to 2008.

	DO it = 2,nyear

	    lveta(it) = lveta(1)*lphi(it)                           ! IVS: ST DEV of eta shock in year it (this is squared below)

	END DO

	ip = ip+ 2009-minyear-1+1	                            ! IVS:





	IF(FEPersEqual==1) lvfe = lveta*lvfe(1)/lveta(1)

ELSE IF(YearEffectsPers==1 .and. DeBackerVersion==1)	THEN
	lveta = X(ip)
	ldbscale(1) = 1
	!!!ldbscale(2:1996-minyear+1) = X(ip+1:ip + 1996-minyear)
	!!!ldbscale(1996-minyear+3) = X(ip + 1996-minyear+1)						!1998
	!!!ldbscale(1996-minyear+5) = X(ip + 1996-minyear+2)						!2000
	!!!ldbscale(1996-minyear+7) = X(ip + 1996-minyear+3)						!2002
	!!!ldbscale(1996-minyear+9) = X(ip + 1996-minyear+4)						!2004
	!!!ldbscale(1996-minyear+11) = X(ip + 1996-minyear+5)						!2006
	!!!ldbscale(1996-minyear+2) = 0.5*(X(ip + 1996-minyear)	+ X(ip + 1996-minyear+1))	!1997
	!!!ldbscale(1996-minyear+4) = 0.5*(X(ip + 1996-minyear+1)	+ X(ip + 1996-minyear+2))	!1999
	!!!ldbscale(1996-minyear+6) = 0.5*(X(ip + 1996-minyear+2)	+ X(ip + 1996-minyear+3))	!2001
	!!!ldbscale(1996-minyear+8) = 0.5*(X(ip + 1996-minyear+3)	+ X(ip + 1996-minyear+4))	!2003
	!!!ldbscale(1996-minyear+10) = 0.5*(X(ip + 1996-minyear+4)	+ X(ip + 1996-minyear+5))	!2005

	!!!ldbscale(1996-minyear+11:1996-minyear+13) = ldbscale(1996-minyear+11)	!2007,2008
	!!!ip = ip+ 1996-minyear+6

	ldbscale(2:2009-minyear-1) = X(ip+1:ip + 2009-minyear-2)                    ! IVS: 20 elements (1st is set to 1; last two are set to 2007 value).

	ldbscale(2009-minyear:2009-minyear+1) = ldbscale(2009-minyear-1)	    ! IVS: set last two (2008-2009) to 2007 value.

	ip = ip+ 2009-minyear-2+1	                                            ! IVS:	
END IF

IF(AgeEffectsTrans==0 .and. YearEffectsTrans==0) THEN
	lvepsyear = X(ip)
	lvepsage = 0.0
	ip = ip+1
ELSE IF(AgeEffectsTrans==9 .and. YearEffectsTrans==0) THEN
	lvepsyear = X(ip)
	lvepsage(1) = 0.0	!normalization: these can go neg
	lvepsage(2:nage) = X(ip+1:ip+nage-1)
	ip = ip + nage
ELSE IF(AgeEffectsTrans<9 .and. YearEffectsTrans==0) THEN
	lvepsyear = X(ip)
	DO ia = 1,nage
		lvepsage(ia) = 0.0
		DO io = 1,AgeEffectsTrans
			lvepsage(ia) = lvepsage(ia) + (ia**io)*X(ip+io)
		END DO
	END DO
	ip = ip + AgeEffectsTrans+1
ELSE IF(AgeEffectsTrans==0 .and. YearEffectsTrans==1) THEN
	lvepsage = 0.0
	!!!lvepsyear(1:1996-minyear+1) = X(ip:ip + 1996-minyear)
	!!!lvepsyear(1996-minyear+3) = X(ip + 1996-minyear+1)						!1998
	!!!lvepsyear(1996-minyear+5) = X(ip + 1996-minyear+2)						!2000
	!!!lvepsyear(1996-minyear+7) = X(ip + 1996-minyear+3)						!2002
	!!!lvepsyear(1996-minyear+9) = X(ip + 1996-minyear+4)						!2004
	!!!lvepsyear(1996-minyear+11) = X(ip + 1996-minyear+5)						!2006
	!!!lvepsyear(1996-minyear+13) = X(ip + 1996-minyear+6)						!2008
	
	!!!lvepsyear(1996-minyear+2) = 0.5*(X(ip + 1996-minyear)	+ X(ip + 1996-minyear+1))	!1997
	!!!lvepsyear(1996-minyear+4) = 0.5*(X(ip + 1996-minyear+1)	+ X(ip + 1996-minyear+2))	!1999
	!!!lvepsyear(1996-minyear+6) = 0.5*(X(ip + 1996-minyear+2)	+ X(ip + 1996-minyear+3))	!2001
	!!!lvepsyear(1996-minyear+8) = 0.5*(X(ip + 1996-minyear+3)	+ X(ip + 1996-minyear+4))	!2003	
	!!!lvepsyear(1996-minyear+10) = 0.5*(X(ip + 1996-minyear+4)	+ X(ip + 1996-minyear+5))	!2005	
	!!!lvepsyear(1996-minyear+12) = 0.5*(X(ip + 1996-minyear+5)	+ X(ip + 1996-minyear+6))	!2007	

	!!!ip = ip + 1996-minyear+7

	!!!!!!lvepsyear(1:2009-minyear+1) = X(ip:ip + 2009-minyear)             ! IVS: 23 elements (corresponding to all years, 1987-2009).
	!!!!!!ip = ip + 2009-minyear+1                                          ! IVS:



	lvepsyear(1) = X(ip)                                         ! IVS: First element is ST DEV of eps shock in 1st year (1987); when pi(1)=1.0.

	lpi(1) = 1.0
	lpi(2:2009-minyear+1) = X(ip+1:ip + 2009-minyear)             ! IVS:

	DO it = 2,nyear

	    lvepsyear(it) = lvepsyear(1)*lpi(it)                      ! IVS: ST DEV of eps shock in year it (this is squared below)

	END DO

	ip = ip + 2009-minyear+1                                     ! IVS:



ELSE IF(AgeEffectsTrans==9 .and. YearEffectsTrans==1) THEN
	lvepsage(1) = 0.0
	lvepsage(2:nage) = X(ip:ip+nage-2)
	ip = ip + nage-1
	!!!lvepsyear(1:1996-minyear+1) = X(ip:ip + 1996-minyear)
	!!!lvepsyear(1996-minyear+3) = X(ip + 1996-minyear+1)						!1998
	!!!lvepsyear(1996-minyear+5) = X(ip + 1996-minyear+2)						!2000
	!!!lvepsyear(1996-minyear+7) = X(ip + 1996-minyear+3)						!2002
	!!!lvepsyear(1996-minyear+9) = X(ip + 1996-minyear+4)						!2004
	!!!lvepsyear(1996-minyear+11) = X(ip + 1996-minyear+5)						!2006
	!!!lvepsyear(1996-minyear+13) = X(ip + 1996-minyear+6)						!2008

	!!!lvepsyear(1996-minyear+2) = 0.5*(X(ip + 1996-minyear)	+ X(ip + 1996-minyear+1))	!1997
	!!!lvepsyear(1996-minyear+4) = 0.5*(X(ip + 1996-minyear+1)	+ X(ip + 1996-minyear+2))	!1999
	!!!lvepsyear(1996-minyear+6) = 0.5*(X(ip + 1996-minyear+2)	+ X(ip + 1996-minyear+3))	!2001
	!!!lvepsyear(1996-minyear+8) = 0.5*(X(ip + 1996-minyear+3)	+ X(ip + 1996-minyear+4))	!2003	
	!!!lvepsyear(1996-minyear+10) = 0.5*(X(ip + 1996-minyear+4)	+ X(ip + 1996-minyear+5))	!2005	
	!!!lvepsyear(1996-minyear+12) = 0.5*(X(ip + 1996-minyear+5)	+ X(ip + 1996-minyear+6))	!2007	
	!!!ip = ip + 1996-minyear+7

	!!!!!!lvepsyear(1:2009-minyear+1) = X(ip:ip + 2009-minyear)               ! IVS: 23 elements (corresponding to all years, 1987-2009).
	!!!!!!ip = ip + 2009-minyear+1                                            ! IVS:


	lvepsyear(1) = X(ip)                                         ! IVS: First element is ST DEV of eps shock in 1st year (1987); when pi(1)=1.0.

	lpi(1) = 1.0
	lpi(2:2009-minyear+1) = X(ip+1:ip + 2009-minyear)             ! IVS:

	DO it = 2,nyear

	    lvepsyear(it) = lvepsyear(1)*lpi(it)                      ! IVS: ST DEV of eps shock in year it (this is squared below)

	END DO

	ip = ip + 2009-minyear+1                                     ! IVS:



END IF

IF(IncludePH==1) THEN
	lvph = X(ip)
	ip = ip+1
ELSE
	lvph = 0.0
END IF	

IF(IncludePHcovFE==1) THEN
	lcovph = X(ip)
	ip = ip+1
ELSE
	lcovph = 0.0
END IF	


lveta = lveta**2
lvfe = lvfe**2
lvph = lvph**2
DO ia = 1,nage
DO it = 1,nyear
	lveps(ia,it) =  lvepsage(ia) +lvepsyear(it)**2.0		!note no square on age so that effect of age can be negative.
END DO
END DO
ldbscale = ldbscale**2

!1a. Calculate variance of persistant componenet, z
!-------------------------------------------------

Vz(1,1) = lveta(1)

DO ia = 2, nage
    Vz(ia,1) = (lrho**2)*Vz(ia-1,1) + lveta(1)
END DO

DO it  = 2,nyear
    Vz(1,it) = lveta(it)
    DO ia = 2, nage
	    Vz(ia,it) = (lrho**2)*Vz(ia-1,it-1) + lveta(it)
    END DO	    
END DO

!1b. Calculate variance of transitory componenet, u
!-------------------------------------------------

! Fill first element of matrix

Vu(1,1) = lveps(1,1)

! Fill rest of 1st row (i.e. for age==1)

DO it  = 2,nyear
    Vu(1,it) = lveps(1,it)
END DO

! Fill 2nd element down 1st column

Vu(2,1) = (lomega**2)*Vu(1,1) + lveps(2,1) + (ltheta1**2)*lveps(1,1)

! Fill rest of first column

DO ia = 3, nage
    Vu(ia,1) = (lomega**2)*Vu(ia-1,1) + lveps(ia,1) + (ltheta1**2)*lveps(ia-1,1) + (ltheta2**2)*lveps(ia-2,1)
END DO

! Fill rest of 2nd row (i.e. for age==2)

DO it  = 2,nyear
    Vu(2,it) = (lomega**2)*Vu(1,it-1) + lveps(2,it) + (ltheta1**2)*lveps(1,it-1)
END DO

! Fill rest of 2nd column

DO ia = 3, nage
    Vu(ia,2) = (lomega**2)*Vu(ia-1,1) + lveps(ia,2) + (ltheta1**2)*lveps(ia-1,1) + (ltheta2**2)*lveps(ia-2,1)
END DO

! Fill rest of matrix

DO it  = 3,nyear
    DO ia = 3, nage
	    Vu(ia,it) = (lomega**2)*Vu(ia-1,it-1) + lveps(ia,it) + (ltheta1**2)*lveps(ia-1,it-1) + (ltheta2**2)*lveps(ia-2,it-2)
    END DO	    
END DO


!2. Calculate  variances
!-------------------------------------------------	
DO it  = 1,nyear
    DO ia = 1, nage
	    IF(DeBackerVersion==0) Vy(ia,it) = Vz(ia,it) + Vu(ia,it) + lvfe(it) + (ia**2)*lvph + 2*ia*sqrt(lvfe(it))*lcovph
	    IF(DeBackerVersion==1 .and. FEPersEqual==0) Vy(ia,it) = ldbscale(it)*Vz(ia,it) + Vu(ia,it) + lvfe(it) + (ia**2)*lvph + 2*ia*sqrt(lvfe(it))*lcovph
	    IF(DeBackerVersion==1 .and. FEPersEqual==1) Vy(ia,it) = ldbscale(it)*Vz(ia,it) + Vu(ia,it) + ldbscale(it)*lvfe(it) + (ia**2)*lvph + 2*ia*sqrt(lvfe(it))*lcovph
    END DO
END DO

!3. Calculate age/diff covariances
!--------------------------------------------------
!nb this is not efficient since i calculate it for lots of moments i dont use
DO it  = 1,nyear
    DO ia = 1, nage
	    DO id = 1,min(ia-1, it-1, nlag)

			IF(id==1 .and. ia==2) THEN

				IF(DeBackerVersion==0) THEN
					IF(it>1)  COVy(ia,it,id) = (lrho**id)*Vz(ia-id,it-id) + (lomega**id)*Vu(ia-id,it-id) + ltheta1*lveps(ia-1,it-1) + sqrt(lvfe(it)*lvfe(it-id)) + ia*(ia-id)*lvph + (ia-id)*sqrt(lvfe(it))*lcovph + ia*sqrt(lvfe(it-id))*lcovph
					IF(it==1) COVy(ia,it,id) = (lrho**id)*Vz(ia-id,it-id) + (lomega**id)*Vu(ia-id,it-id) + ltheta1*lveps(ia-1,1) + sqrt(lvfe(it)*lvfe(it-id)) + ia*(ia-id)*lvph + (ia-id)*sqrt(lvfe(it))*lcovph + ia*sqrt(lvfe(it-id))*lcovph
				ELSE IF(DeBackerVersion==1 .and. FEPersEqual==0) THEN
					IF(it>1) COVy(ia,it,id) = sqrt(ldbscale(it)*ldbscale(it-id))*(lrho**id)*Vz(ia-id,it-id) + (lomega**id)*Vu(ia-id,it-id) + ltheta1*lveps(ia-1,it-1) + sqrt(lvfe(it)*lvfe(it-id)) + ia*(ia-id)*lvph + (ia-id)*sqrt(lvfe(it))*lcovph + ia*sqrt(lvfe(it-id))*lcovph
					IF(it==1) COVy(ia,it,id) = sqrt(ldbscale(it)*ldbscale(it-id))*(lrho**id)*Vz(ia-id,it-id) + (lomega**id)*Vu(ia-id,it-id) + ltheta1*lveps(ia-1,1) + sqrt(lvfe(it)*lvfe(it-id)) + ia*(ia-id)*lvph + (ia-id)*sqrt(lvfe(it))*lcovph + ia*sqrt(lvfe(it-id))*lcovph			
				ELSE IF(DeBackerVersion==1 .and. FEPersEqual==1) THEN
					IF(it>1) COVy(ia,it,id) = sqrt(ldbscale(it)*ldbscale(it-id))*(lrho**id)*Vz(ia-id,it-id) + (lomega**id)*Vu(ia-id,it-id) + ltheta1*lveps(ia-1,it-1) + sqrt(ldbscale(it)*ldbscale(it-id))*sqrt(lvfe(it)*lvfe(it-id)) + ia*(ia-id)*lvph + (ia-id)*sqrt(lvfe(it))*lcovph + ia*sqrt(lvfe(it-id))*lcovph
					IF(it==1) COVy(ia,it,id) = sqrt(ldbscale(it)*ldbscale(it-id))*(lrho**id)*Vz(ia-id,it-id) + (lomega**id)*Vu(ia-id,it-id) + ltheta1*lveps(ia-1,1) + sqrt(ldbscale(it)*ldbscale(it-id))*sqrt(lvfe(it)*lvfe(it-id)) + ia*(ia-id)*lvph + (ia-id)*sqrt(lvfe(it))*lcovph + ia*sqrt(lvfe(it-id))*lcovph		
				END IF

			ELSE IF(id==1 .and. ia>2) THEN

				IF(DeBackerVersion==0) THEN
					IF(it>2)  COVy(ia,it,id) = (lrho**id)*Vz(ia-id,it-id) + (lomega**id)*Vu(ia-id,it-id) + ltheta1*lveps(ia-1,it-1) + ltheta1*ltheta2*lveps(ia-2,it-2) + sqrt(lvfe(it)*lvfe(it-id)) + ia*(ia-id)*lvph + (ia-id)*sqrt(lvfe(it))*lcovph + ia*sqrt(lvfe(it-id))*lcovph
					IF(it==2) COVy(ia,it,id) = (lrho**id)*Vz(ia-id,it-id) + (lomega**id)*Vu(ia-id,it-id) + ltheta1*lveps(ia-1,it-1) + ltheta1*ltheta2*lveps(ia-2,1) + sqrt(lvfe(it)*lvfe(it-id)) + ia*(ia-id)*lvph + (ia-id)*sqrt(lvfe(it))*lcovph + ia*sqrt(lvfe(it-id))*lcovph
					IF(it==1) COVy(ia,it,id) = (lrho**id)*Vz(ia-id,it-id) + (lomega**id)*Vu(ia-id,it-id) + ltheta1*lveps(ia-1,1) + ltheta1*ltheta2*lveps(ia-2,1) + sqrt(lvfe(it)*lvfe(it-id)) + ia*(ia-id)*lvph + (ia-id)*sqrt(lvfe(it))*lcovph + ia*sqrt(lvfe(it-id))*lcovph
				ELSE IF(DeBackerVersion==1 .and. FEPersEqual==0) THEN
					IF(it>2) COVy(ia,it,id) = sqrt(ldbscale(it)*ldbscale(it-id))*(lrho**id)*Vz(ia-id,it-id) + (lomega**id)*Vu(ia-id,it-id) + ltheta1*lveps(ia-1,it-1) + ltheta1*ltheta2*lveps(ia-2,it-2) + sqrt(lvfe(it)*lvfe(it-id)) + ia*(ia-id)*lvph + (ia-id)*sqrt(lvfe(it))*lcovph + ia*sqrt(lvfe(it-id))*lcovph
					IF(it==2) COVy(ia,it,id) = sqrt(ldbscale(it)*ldbscale(it-id))*(lrho**id)*Vz(ia-id,it-id) + (lomega**id)*Vu(ia-id,it-id) + ltheta1*lveps(ia-1,it-1) + ltheta1*ltheta2*lveps(ia-2,it-1) + sqrt(lvfe(it)*lvfe(it-id)) + ia*(ia-id)*lvph + (ia-id)*sqrt(lvfe(it))*lcovph + ia*sqrt(lvfe(it-id))*lcovph
					IF(it==1) COVy(ia,it,id) = sqrt(ldbscale(it)*ldbscale(it-id))*(lrho**id)*Vz(ia-id,it-id) + (lomega**id)*Vu(ia-id,it-id) + ltheta1*lveps(ia-1,1) + ltheta1*ltheta2*lveps(ia-2,1) + sqrt(lvfe(it)*lvfe(it-id)) + ia*(ia-id)*lvph + (ia-id)*sqrt(lvfe(it))*lcovph + ia*sqrt(lvfe(it-id))*lcovph
				ELSE IF(DeBackerVersion==1 .and. FEPersEqual==1) THEN
					IF(it>2) COVy(ia,it,id) = sqrt(ldbscale(it)*ldbscale(it-id))*(lrho**id)*Vz(ia-id,it-id) + (lomega**id)*Vu(ia-id,it-id) + ltheta1*lveps(ia-1,it-1) + ltheta1*ltheta2*lveps(ia-2,it-2) + sqrt(ldbscale(it)*ldbscale(it-id))*sqrt(lvfe(it)*lvfe(it-id)) + ia*(ia-id)*lvph + (ia-id)*sqrt(lvfe(it))*lcovph + ia*sqrt(lvfe(it-id))*lcovph
					IF(it==2) COVy(ia,it,id) = sqrt(ldbscale(it)*ldbscale(it-id))*(lrho**id)*Vz(ia-id,it-id) + (lomega**id)*Vu(ia-id,it-id) + ltheta1*lveps(ia-1,it-1) + ltheta1*ltheta2*lveps(ia-2,it-1) + sqrt(ldbscale(it)*ldbscale(it-id))*sqrt(lvfe(it)*lvfe(it-id)) + ia*(ia-id)*lvph + (ia-id)*sqrt(lvfe(it))*lcovph + ia*sqrt(lvfe(it-id))*lcovph
					IF(it==1) COVy(ia,it,id) = sqrt(ldbscale(it)*ldbscale(it-id))*(lrho**id)*Vz(ia-id,it-id) + (lomega**id)*Vu(ia-id,it-id) + ltheta1*lveps(ia-1,1) + ltheta1*ltheta2*lveps(ia-2,1) + sqrt(ldbscale(it)*ldbscale(it-id))*sqrt(lvfe(it)*lvfe(it-id)) + ia*(ia-id)*lvph + (ia-id)*sqrt(lvfe(it))*lcovph + ia*sqrt(lvfe(it-id))*lcovph		
				END IF

			ELSE IF(id==2 .and. ia>2) THEN

				IF(DeBackerVersion==0) THEN
					IF(it>2)  COVy(ia,it,id) = (lrho**id)*Vz(ia-id,it-id) + (lomega**id)*Vu(ia-id,it-id) + ltheta2*lveps(ia-2,it-2) + sqrt(lvfe(it)*lvfe(it-id)) + ia*(ia-id)*lvph + (ia-id)*sqrt(lvfe(it))*lcovph + ia*sqrt(lvfe(it-id))*lcovph
					IF(it==2) COVy(ia,it,id) = (lrho**id)*Vz(ia-id,it-id) + (lomega**id)*Vu(ia-id,it-id) + ltheta2*lveps(ia-2,1) + sqrt(lvfe(it)*lvfe(it-id)) + ia*(ia-id)*lvph + (ia-id)*sqrt(lvfe(it))*lcovph + ia*sqrt(lvfe(it-id))*lcovph
					IF(it==1) COVy(ia,it,id) = (lrho**id)*Vz(ia-id,it-id) + (lomega**id)*Vu(ia-id,it-id) + ltheta2*lveps(ia-2,1) + sqrt(lvfe(it)*lvfe(it-id)) + ia*(ia-id)*lvph + (ia-id)*sqrt(lvfe(it))*lcovph + ia*sqrt(lvfe(it-id))*lcovph
				ELSE IF(DeBackerVersion==1 .and. FEPersEqual==0) THEN
					IF(it>2) COVy(ia,it,id) = sqrt(ldbscale(it)*ldbscale(it-id))*(lrho**id)*Vz(ia-id,it-id) + (lomega**id)*Vu(ia-id,it-id) + ltheta2*lveps(ia-2,it-2) + sqrt(lvfe(it)*lvfe(it-id)) + ia*(ia-id)*lvph + (ia-id)*sqrt(lvfe(it))*lcovph + ia*sqrt(lvfe(it-id))*lcovph
					IF(it==2) COVy(ia,it,id) = sqrt(ldbscale(it)*ldbscale(it-id))*(lrho**id)*Vz(ia-id,it-id) + (lomega**id)*Vu(ia-id,it-id) + ltheta2*lveps(ia-2,it-1) + sqrt(lvfe(it)*lvfe(it-id)) + ia*(ia-id)*lvph + (ia-id)*sqrt(lvfe(it))*lcovph + ia*sqrt(lvfe(it-id))*lcovph
					IF(it==1) COVy(ia,it,id) = sqrt(ldbscale(it)*ldbscale(it-id))*(lrho**id)*Vz(ia-id,it-id) + (lomega**id)*Vu(ia-id,it-id) + ltheta2*lveps(ia-2,1) + sqrt(lvfe(it)*lvfe(it-id)) + ia*(ia-id)*lvph + (ia-id)*sqrt(lvfe(it))*lcovph + ia*sqrt(lvfe(it-id))*lcovph			
				ELSE IF(DeBackerVersion==1 .and. FEPersEqual==1) THEN
					IF(it>2) COVy(ia,it,id) = sqrt(ldbscale(it)*ldbscale(it-id))*(lrho**id)*Vz(ia-id,it-id) + (lomega**id)*Vu(ia-id,it-id) + ltheta2*lveps(ia-2,it-2) + sqrt(ldbscale(it)*ldbscale(it-id))*sqrt(lvfe(it)*lvfe(it-id)) + ia*(ia-id)*lvph + (ia-id)*sqrt(lvfe(it))*lcovph + ia*sqrt(lvfe(it-id))*lcovph
					IF(it==2) COVy(ia,it,id) = sqrt(ldbscale(it)*ldbscale(it-id))*(lrho**id)*Vz(ia-id,it-id) + (lomega**id)*Vu(ia-id,it-id) + ltheta2*lveps(ia-2,it-1) + sqrt(ldbscale(it)*ldbscale(it-id))*sqrt(lvfe(it)*lvfe(it-id)) + ia*(ia-id)*lvph + (ia-id)*sqrt(lvfe(it))*lcovph + ia*sqrt(lvfe(it-id))*lcovph	
					IF(it==1) COVy(ia,it,id) = sqrt(ldbscale(it)*ldbscale(it-id))*(lrho**id)*Vz(ia-id,it-id) + (lomega**id)*Vu(ia-id,it-id) + ltheta2*lveps(ia-2,1) + sqrt(ldbscale(it)*ldbscale(it-id))*sqrt(lvfe(it)*lvfe(it-id)) + ia*(ia-id)*lvph + (ia-id)*sqrt(lvfe(it))*lcovph + ia*sqrt(lvfe(it-id))*lcovph		
				END IF
				
			ELSE

				IF(DeBackerVersion==0) THEN
					COVy(ia,it,id) = (lrho**id)*Vz(ia-id,it-id) + (lomega**id)*Vu(ia-id,it-id) + sqrt(lvfe(it)*lvfe(it-id)) + ia*(ia-id)*lvph + (ia-id)*sqrt(lvfe(it))*lcovph + ia*sqrt(lvfe(it-id))*lcovph
				ELSE IF(DeBackerVersion==1 .and. FEPersEqual==0) THEN
					COVy(ia,it,id) = sqrt(ldbscale(it)*ldbscale(it-id))*(lrho**id)*Vz(ia-id,it-id) + (lomega**id)*Vu(ia-id,it-id) + sqrt(lvfe(it)*lvfe(it-id)) + ia*(ia-id)*lvph + (ia-id)*sqrt(lvfe(it))*lcovph + ia*sqrt(lvfe(it-id))*lcovph
				ELSE IF(DeBackerVersion==1 .and. FEPersEqual==1) THEN
					COVy(ia,it,id) = sqrt(ldbscale(it)*ldbscale(it-id))*(lrho**id)*Vz(ia-id,it-id) + (lomega**id)*Vu(ia-id,it-id) + sqrt(ldbscale(it)*ldbscale(it-id))*sqrt(lvfe(it)*lvfe(it-id)) + ia*(ia-id)*lvph + (ia-id)*sqrt(lvfe(it))*lcovph + ia*sqrt(lvfe(it-id))*lcovph
				END IF
			END IF

	    END DO
	END DO
END DO


!4. Fill in the theoretical/empirical moment differences corresponding to the data vector
!---------------------------------------------------- 
IF (Bootstrap==0) THEN
	!$OMP PARALLEL DO PRIVATE(lweight)
	DO im = 1, M
		lweight	= sqrt(real(nobs(im)))
		IF (IdentityWeight==1) lweight = 1.0

		IF (lag(im)==0) THEN
			F(im) = cov(im) - Vy(age(im),year(im))
			dataVy(age(im),year(im)) = cov(im) 
		ELSE
			F(im) = cov(im) - COVy(age(im),year(im),lag(im))
			dataCOVy(age(im),year(im),lag(im)) = cov(im) 
		END IF
		
		!multiply by weight
		F(im) = F(im)*lweight
		
	END DO
	!$OMP END PARALLEL DO

ELSE IF (Bootstrap ==1) THEN
	DO im = 1, M
		lweight	= sqrt(real(bsnobs(im,globibs)))
		IF (IdentityWeight==1) lweight = 1.0

		IF (bslag(im,globibs)==0) THEN
			F(im) = bscov(im,globibs) - Vy(bsage(im,globibs),bsyear(im,globibs))
		ELSE
			F(im) = bscov(im,globibs) - COVy(bsage(im,globibs),bsyear(im,globibs),bslag(im,globibs))
		END IF
	
		!multiply by weight
		F(im) = F(im)*lweight	
		
	END DO

END IF


!IF (Bootstrap==0) write(*,*) sum(F(1:M)*F(1:M))

END SUBROUTINE ObjFunction
