PROGRAM Main

USE Parameters
USE Globals

IMPLICIT NONE

INTEGER		:: ibs

IF (RunOnLinux==0) filesep = '\'
IF (RunOnLinux==1) filesep = '/'


!Load in Empirical Covariances
CALL GetData


IF (Bootstrap==0) THEN
	!Make guesses at solution
	CALL MakeGuess
    
    nmoments = nmomentsALL
	
	!Do Minimum Distance Estimation
	CALL Estimation

	!Save Results to File
	CALL OutputResults

ELSE IF (Bootstrap==1) THEN
	
	DO ibs = 1,nbstraps
		globibs = ibs
		CALL MakeGuess
		nmoments = bsnmoments(ibs)
		write(*,*) 'Doing estimation for bootstrap: ', ibs
		CALL Estimation
		CALL OutputBootstrapResults
	END DO
	
	

END IF
END PROGRAM Main