MODULE Globals
USE Parameters

IMPLICIT NONE

!GLOBALS FOR STORING EMPIRICAL MOMENTS AND DATA
integer	:: nmoments,globibs,npar

integer, dimension(nmomentsALL)	:: age,lag,year,nobs	! age for moment (convention is age, lag is number of periods backward, lag=0 for variance 
real(8), dimension(nmomentsALL)	:: cov	! empirical covariance

integer, dimension(nbstraps)	::bsnmoments
integer, dimension(25000,nbstraps) :: bsage, bslag,bsyear,bsnobs
real(8), dimension(25000,nbstraps) :: bscov	! empirical covariance
real(8), dimension(:,:), ALLOCATABLE	:: XfinalBS

!GLOBALS USED IN CONSTRUCTION OF THEORETICAL COVARIANCE MATRIX
real(8), dimension(nage,nyear)  		:: Vz, Vy,dataVy,Vu
real(8), dimension(nage,nyear,nlag) 	:: COVy,dataCOVy

!GLOBALS TO STORE PARAMETERS FOR OBJECTIVE FUNCTION
real(8)		            :: rho,vph,covph,theta1,theta2,omega,b0,b1,b2,b3,b4
real(8)		            :: rhoguess,vetaguess,vepsguess,vfeguess,vphguess,covphguess,thetaguess,omegaguess
real(8), dimension(nyear)    :: veta,vepsyear,vfe,dbscale, pi, phi
real(8), dimension(nage)		        :: vepsage
real(8), dimension(nage,nyear)		        :: veps
real(8), dimension(:), ALLOCATABLE      :: Xfinal
real(8), dimension(nmomentsALL)	        :: Ffinal

real(8)		:: vareps_vec(nage),varalpha,vareta

!OTHER
character(len=1)   filesep

END MODULE Globals
