! Modifying code to use with Tax data.
! _lampoly3 restricts vfe (i.e. 'lambda') to be cubic polynomial.
! _lampoly4 restricts vfe (i.e. 'lambda') to be quartic polynomial.
! Modify program to use MA2 transitory error.
! Reparameterizing to estimate phi parameters and pi parameters.
!

SUBROUTINE Estimation

USE Parameters
USE Globals

IMPLICIT NONE

EXTERNAL ObjFunction

!Local Variables
!----------------------------------
INTEGER									:: info,ip,ia,it,io
REAL(8), DIMENSION(:), ALLOCATABLE	    :: Xguess, Xsol
REAL(8), DIMENSION(nmoments)	        :: Fsol


REAL(8), DIMENSION(nyear)	        :: lambda


!!!REAL(8)		    :: b0_vfe,b1_vfe,b2_vfe,b3_vfe,b4_vfe      ! IVS: Declare coeffs for vfe polynomial
!!!REAL(8), DIMENSION(nyear)	        :: pi
!!! THESE WILL BE GLOBAL VARIABLES NOW; NO NEED TO DECLARE THEM HERE.



!Allocate variables
!------------------------------------
npar = 0
IF(RestrictRandWalk==0) 		npar = npar + 1

!!!IF(IncludeMA1Trans==1) 	npar = npar + 1
IF(IncludeMA2Trans==1) 	npar = npar + 2           ! IVS: I am turning this into an MA(2) error.

IF(IncludeAR1Trans==1) 	npar = npar + 1

IF(IncludeFE==1 .and. YearEffectsFE==0) npar = npar + 1

!!!IF(IncludeFE==1 .and. YearEffectsFE==1)	npar = npar + 1996-minyear+1 + 5   !based on minyear - 1996, 98,00,02,04,06
!!!IF(IncludeFE==1 .and. YearEffectsFE==1)	npar = npar + 2009-minyear+1 - 2   ! IVS: I set 2009=2008=2007; so 2008 & 2009 are not estimated (hence the -2).
!!!IF(IncludeFE==1 .and. YearEffectsFE==1)	npar = npar + 4                    ! IVS: Restricting vfe to cubic polynomial (4 coeffs.)
   IF(IncludeFE==1 .and. YearEffectsFE==1)	npar = npar + 5                    ! IVS: Restricting vfe to quartic polynomial (5 coeffs.)

!pers
IF(YearEffectsPers==0) npar = npar+1		!veta


!!!IF(YearEffectsPers==1) npar = npar + 1996-minyear+1 + 5	!based on minyear - 1996, 98,00,02,04,06
!!!IF(YearEffectsPers==1) npar = npar + 2009-minyear+1 - 2	! IVS: I set 2009=2008=2007; so 2008 & 2009 are not estimated (hence the -2).
   IF(YearEffectsPers==1) npar = npar + 2009-minyear+1 - 1	! IVS: I set 2009=2008; so 2009 is not estimated (hence the -1).

!trans
IF(AgeEffectsTrans==0 .and. YearEffectsTrans==0) THEN
	npar = npar+1
ELSE IF (AgeEffectsTrans==9 .and. YearEffectsTrans==0) THEN
	npar = npar+nage
ELSE IF (AgeEffectsTrans<9 .and. YearEffectsTrans==0) THEN
	npar = npar+(AgeEffectsTrans+1) !order of polynomial	
ELSE IF (AgeEffectsTrans==0 .and. YearEffectsTrans==1) THEN
	!based on minyear - 1996, 98,00,02,04,06,08
	!!!npar = npar + 1996-minyear+1 + 6
	   npar = npar + 2009-minyear+1	    ! IVS: Estimated for all years 1987-2009.
ELSE IF(AgeEffectsTrans==9 .and. YearEffectsTrans==1) THEN
	npar = npar + nage-1	!normalize age 1 to 0 (may be neg)
	!!!npar = npar + 1996-minyear+1 + 6
	   npar = npar + 2009-minyear+1	    ! IVS: Estimated for all years 1987-2009.
END IF

!profile het
IF(IncludePH==1) npar = npar+1
IF(IncludePHcovFE==1) npar = npar+1


IF (Bootstrap==0) ALLOCATE(Xguess(npar),Xsol(npar),Xfinal(npar))
IF (Bootstrap==1) THEN
	IF (.NOT. ALLOCATED(Xguess)) ALLOCATE(Xguess(npar))
	IF (.NOT. ALLOCATED(Xsol)) ALLOCATE(Xsol(npar))
	IF (.NOT. ALLOCATED(XfinalBS)) ALLOCATE(XfinalBS(npar,nbstraps))
END IF

!Construct guess
!-------------------
ip = 1

IF(RestrictRandWalk==0) THEN
	Xguess(ip) = rhoguess
	ip = ip+1
END IF	

IF(IncludeMA2Trans==1) THEN
	Xguess(ip) = thetaguess        ! IVS: MA1 (theta1)
	ip = ip+1
	Xguess(ip) = thetaguess        ! IVS: MA2 (theta2)
	ip = ip+1
END IF	

IF(IncludeAR1Trans==1) THEN
	Xguess(ip) = omegaguess
	ip = ip+1
END IF	


IF(IncludeFE==1 .and. YearEffectsFE==0) THEN
	Xguess(ip) = vfeguess
	ip = ip+1
ELSE IF(IncludeFE==1 .and. YearEffectsFE==1) THEN
	!!!Xguess(ip:ip+1996-minyear+5) = vfeguess
	!!!ip = ip+1996-minyear+6
	   !!!Xguess(ip:ip+2009-minyear-2) = vfeguess        ! IVS: Include only 21 elements (since last 2 years set equal to 21st element).
	   !!!ip = ip+2009-minyear-2+1                       ! IVS:

	   Xguess(ip)   = 0.10                               ! IVS: The first of these is now sig_alpha (st dev of FE in 1987).
	   Xguess(ip+1) = 0.01                               ! IVS: Restricting vfe to cubic polynomial (4 coeffs; no intercept; set initial guess).
	   Xguess(ip+2) = 0.0
	   Xguess(ip+3) = 0.0
	   Xguess(ip+4) = 0.0
	   ip = ip+ 5                                        ! IVS: update index
END IF

IF(YearEffectsPers==0)	THEN
	Xguess(ip) = vetaguess
	ip = ip+1
ELSE IF(YearEffectsPers==1 .and. DeBackerVersion==0)	THEN
	!!!Xguess(ip:ip+1996-minyear+5) = vetaguess
	!!!ip = ip+1996-minyear+6
	   !!!Xguess(ip:ip+2009-minyear-2) = vetaguess        ! IVS: Include only 21 elements (since last 2 years set equal to 21st element).
	   !!!ip = ip+2009-minyear-2+1                        ! IVS:
	   !!!!!!Xguess(ip:ip+2009-minyear-1) = vetaguess        ! IVS: Include only 22 elements (since last year set equal to 22nd element).
	   !!!!!!ip = ip+2009-minyear-1+1                        ! IVS:

	   Xguess(ip) = vetaguess                          ! IVS: First element is the St Dev of the eta shock in first year (1987); when phi=1.0.
	   Xguess(ip+1:ip+2009-minyear-1) = 1.0            ! IVS: The rest of the elements are now phi1988-phi2008 (phi2009=phi2008). So set initial guess to 1.0.
	   ip = ip+2009-minyear-1+1                        ! IVS:


ELSE IF(YearEffectsPers==1 .and. DeBackerVersion==1)	THEN
	Xguess(ip) = vetaguess
	!!!Xguess(ip+1:ip+1996-minyear+5) = 1.0
	!!!ip = ip+1996-minyear+6
	   Xguess(ip+1:ip+2009-minyear-2) = 1.0            ! IVS: 'dbscale' parameters. Include only 20 elements (1987 is 1.0; 2008-2009 are set to 2007 value).
	   ip = ip+2009-minyear-2+1                        ! IVS:
END IF

IF(AgeEffectsTrans==0 .and. YearEffectsTrans==0) THEN
	Xguess(ip) = vepsguess
	ip = ip+1
ELSE IF(AgeEffectsTrans==9 .and. YearEffectsTrans==0) THEN
	Xguess(ip) = vepsguess
	Xguess(ip+1:ip+nage-1) = 0.0
	ip = ip + nage
ELSE IF(AgeEffectsTrans<9 .and. YearEffectsTrans==0) THEN
	Xguess(ip) = vepsguess
	Xguess(ip+1:ip+AgeEffectsTrans) = 0.0
	ip = ip + AgeEffectsTrans+1
ELSE IF(AgeEffectsTrans==0 .and. YearEffectsTrans==1) THEN
	!!!Xguess(ip:ip+ 1996-minyear+1 + 6-1) = vepsguess
	!!!ip = ip + 1996-minyear+7
	Xguess(ip:ip+ 2009-minyear) = vepsguess       ! IVS: 23 elements (one for each year 1987-2009).
	ip = ip + 2009-minyear+1                      ! IVS:
ELSE IF(AgeEffectsTrans==9 .and. YearEffectsTrans==1) THEN
	Xguess(ip:ip+nage-2) = 0.0
	ip = ip + nage-1
	!!!Xguess(ip:ip+ 1996-minyear+1 + 6-1) = vepsguess
	!!!ip = ip + 1996-minyear+7
	Xguess(ip:ip+ 2009-minyear) = vepsguess       ! IVS:  23 elements (one for each year 1987-2009).
	ip = ip + 2009-minyear+1                      ! IVS:
END IF

IF(IncludePH==1) THEN
	Xguess(ip) = vphguess
	ip = ip+1
END IF	

IF(IncludePHcovFE==1) THEN
	Xguess(ip) = covphguess	!this is covariance between beta and normalized alpha 
	ip = ip+1
END IF	

CALL ObjFunction (nmoments,npar,Xguess,Fsol,info)
CALL lmdif1 ( ObjFunction, nmoments, npar, Xguess, Fsol, 1.0e-6_8, info )
write(*,*) 'info is ',info
Xsol = Xguess
IF (Bootstrap==0) Xfinal = Xsol
IF (Bootstrap==1) XfinalBS(:,globibs) = Xsol

!Extract solution
!--------------------
ip = 1

IF(RestrictRandWalk==0) THEN
	rho = Xsol(ip)
	ip = ip+1
ELSE
	rho = 1.0
END IF	

IF(IncludeMA2Trans==1) THEN
	theta1 = Xsol(ip)      	 ! IVS: Changing this to MA(2)
	ip = ip+1
	theta2 = Xsol(ip)      	 ! IVS: Changing this to MA(2)
	ip = ip+1
ELSE
	theta1 = 0.0
	theta2 = 0.0
END IF	

IF(IncludeAR1Trans==1) THEN
	omega = Xsol(ip)
	ip = ip+1
ELSE
	omega = 0.0
END IF	


IF(IncludeFE==1 .and. YearEffectsFE==0) THEN
	vfe = Xsol(ip)
	ip = ip+1
ELSE IF(IncludeFE==1 .and. YearEffectsFE==1) THEN
	!!!vfe(1:1996-minyear+1) = Xsol(ip:ip + 1996-minyear)
	!!!vfe(1996-minyear+3) = Xsol(ip + 1996-minyear+1)						!1998
	!!!vfe(1996-minyear+5) = Xsol(ip + 1996-minyear+2)						!2000
	!!!vfe(1996-minyear+7) = Xsol(ip + 1996-minyear+3)						!2002
	!!!vfe(1996-minyear+9) = Xsol(ip + 1996-minyear+4)						!2004
	!!!vfe(1996-minyear+11) = Xsol(ip + 1996-minyear+5)						!2006

	!!!vfe(1996-minyear+2) = 0.5*(Xsol(ip + 1996-minyear)	+ Xsol(ip + 1996-minyear+1))		!1997
	!!!vfe(1996-minyear+4) = 0.5*(Xsol(ip + 1996-minyear+1)	+ Xsol(ip + 1996-minyear+2))		!1999
	!!!vfe(1996-minyear+6) = 0.5*(Xsol(ip + 1996-minyear+2)	+ Xsol(ip + 1996-minyear+3))		!2001
	!!!vfe(1996-minyear+8) = 0.5*(Xsol(ip + 1996-minyear+3)	+ Xsol(ip + 1996-minyear+4))		!2003
	!!!vfe(1996-minyear+10) = 0.5*(Xsol(ip + 1996-minyear+4)	+ Xsol(ip + 1996-minyear+5))	!2005

	!!!vfe(1996-minyear+11:1996-minyear+13) = vfe(1996-minyear+11)	!2007,2008

	!!!ip = ip+ 1996-minyear+6

	!!!vfe(1:2009-minyear-1) = Xsol(ip:ip + 2009-minyear-2)             ! IVS: 21 elements (corresponding to 1987-2007)
	!!!vfe(2009-minyear:2009-minyear+1) = vfe(2009-minyear-1)           ! IVS: Set 2008-2009 equal to 2007.
	!!!ip = ip+ 2009-minyear-2+1                                        ! IVS: 


	! Restricting lvfe to be cubic polynomial:

	b0 = Xsol(ip)            ! IVS: b0 is now sig_alpha (sd of FE in 1st year, 1987)
	b1 = Xsol(ip+1)          ! IVS: polynomial coefficients (on lambda polynomial)
	b2 = Xsol(ip+2)          ! IVS:
	b3 = Xsol(ip+3)          ! IVS:
	b4 = Xsol(ip+4)          ! IVS:

        lambda(1) = 1.0
	DO it = 2,nyear
	    lambda(it) = 1.0 + b1*(real(it-1)) + b2*(real((it-1)**2)) + b3*(real((it-1)**3)) + b4*(real((it-1)**4))   ! IVS:
	END DO

	DO it = 1,nyear
	    vfe(it) = b0*lambda(it)   ! IVS: i.e. sig_alpha*lambda(it); this is the ST DEV of the FE; will get squared later in the program
	END DO

	ip = ip+ 5                                      ! IVS: update index



	!OPEN(5, FILE = '/fa/home/m1ixv00/labinc/BPEA/GregModels/fortranoutput/Estimation_vfe.txt', POSITION= 'APPEND', STATUS = 'UNKNOWN')
	!WRITE(5,*) vfe
	!WRITE(5,*) 'b0= ', b0
	!WRITE(5,*) 'b1= ', b1
	!WRITE(5,*) 'b2= ', b2
	!WRITE(5,*) 'b3= ', b3
	!WRITE(5,*) '(real(it-1))= ', (real(it-1))
	!WRITE(5,*) '(real((it-1)**2))= ', (real((it-1)**2))
	!WRITE(5,*) '(real((it-1)**3))= ', (real((it-1)**3))
	!WRITE(5,*) 'it= ', it
	!WRITE(5,*) 'nyear= ', nyear
	!CLOSE(5)

END IF


IF(YearEffectsPers==0)	THEN
	veta = Xsol(ip)
	ip = ip+1
	dbscale = 1.0
ELSE IF(YearEffectsPers==1 .and. DeBackerVersion==0)	THEN
	!!!veta(1:1996-minyear+1) = Xsol(ip:ip + 1996-minyear)
	!!!veta(1996-minyear+3) = Xsol(ip + 1996-minyear+1)						!1998
	!!!veta(1996-minyear+5) = Xsol(ip + 1996-minyear+2)						!2000
	!!!veta(1996-minyear+7) = Xsol(ip + 1996-minyear+3)						!2002
	!!!veta(1996-minyear+9) = Xsol(ip + 1996-minyear+4)						!2004
	!!!veta(1996-minyear+11) = Xsol(ip + 1996-minyear+5)						!2006

	!!!veta(1996-minyear+2) = 0.5*(Xsol(ip + 1996-minyear)	+ Xsol(ip + 1996-minyear+1))	!1997
	!!!veta(1996-minyear+4) = 0.5*(Xsol(ip + 1996-minyear+1)	+ Xsol(ip + 1996-minyear+2))	!1999
	!!!veta(1996-minyear+6) = 0.5*(Xsol(ip + 1996-minyear+2)	+ Xsol(ip + 1996-minyear+3))	!2001
	!!!veta(1996-minyear+8) = 0.5*(Xsol(ip + 1996-minyear+3)	+ Xsol(ip + 1996-minyear+4))	!2003
	!!!veta(1996-minyear+10) = 0.5*(Xsol(ip + 1996-minyear+4)	+ Xsol(ip + 1996-minyear+5))	!2005

	!!!veta(1996-minyear+11:1996-minyear+13) = veta(1996-minyear+11)	!2007,2008
	!!!ip = ip+ 1996-minyear+6
	
	!!!veta(1:2009-minyear-1) = Xsol(ip:ip + 2009-minyear-2)              ! IVS: 21 elements (corresponding to 1987-2007)
	!!!veta(2009-minyear:2009-minyear+1) = veta(2009-minyear-1)           ! IVS: Set 2008-2009 equal to 2007.
	!!!ip = ip+ 2009-minyear-2+1                                          ! IVS:

	!!!!!!veta(1:2009-minyear) = Xsol(ip:ip + 2009-minyear-1)              ! IVS: 22 elements (corresponding to 1987-2008)
	!!!!!!veta(2009-minyear+1) = veta(2009-minyear)                        ! IVS: Set 2009 equal to 2008.
	!!!!!!ip = ip+ 2009-minyear-1+1                                        ! IVS:




	veta(1) = Xsol(ip)                                         ! IVS: The first element is the ST DEV of eta shock in 1st year (1987); when phi(1)==1.0.

	phi(1) = 1.0
	phi(2:2009-minyear) = Xsol(ip+1:ip + 2009-minyear-1)
	phi(2009-minyear+1) = phi(2009-minyear)                    ! IVS: Set 2009 equal to 2008.


	DO it = 2,nyear

	    veta(it) = veta(1)*phi(it)                             ! IVS: ST DEV of eta shock in year it (this is squared below)

	END DO

	ip = ip+ 2009-minyear-1+1                                  ! IVS:






	IF(FEPersEqual==1) vfe = veta*vfe(1)/veta(1)
	dbscale = 1.0

ELSE IF(YearEffectsPers==1 .and. DeBackerVersion==1)	THEN
	veta = Xsol(ip)
	dbscale(1) = 1
	!!!dbscale(2:1996-minyear+1) = Xsol(ip+1:ip + 1996-minyear)
	!!!dbscale(1996-minyear+3) = Xsol(ip + 1996-minyear+1)						!1998
	!!!dbscale(1996-minyear+5) = Xsol(ip + 1996-minyear+2)						!2000
	!!!dbscale(1996-minyear+7) = Xsol(ip + 1996-minyear+3)						!2002
	!!!dbscale(1996-minyear+9) = Xsol(ip + 1996-minyear+4)						!2004
	!!!dbscale(1996-minyear+11) = Xsol(ip + 1996-minyear+5)						!2006
	
	!!!dbscale(1996-minyear+2) = 0.5*(Xsol(ip + 1996-minyear)	+ Xsol(ip + 1996-minyear+1))	!1997
	!!!dbscale(1996-minyear+4) = 0.5*(Xsol(ip + 1996-minyear+1)	+ Xsol(ip + 1996-minyear+2))	!1999
	!!!dbscale(1996-minyear+6) = 0.5*(Xsol(ip + 1996-minyear+2)	+ Xsol(ip + 1996-minyear+3))	!2001
	!!!dbscale(1996-minyear+8) = 0.5*(Xsol(ip + 1996-minyear+3)	+ Xsol(ip + 1996-minyear+4))	!2003
	!!!dbscale(1996-minyear+10) = 0.5*(Xsol(ip + 1996-minyear+4)	+ Xsol(ip + 1996-minyear+5))	!2005

	!!!dbscale(1996-minyear+11:1996-minyear+13) = dbscale(1996-minyear+11)	!2007,2008
	!!!ip = ip+ 1996-minyear+6

	dbscale(2:2009-minyear-1) = Xsol(ip+1:ip + 2009-minyear-2)      ! IVS: 'lambda' parameters. Include only 20 elements (1987 is 1.0; 2008-2009 are set to 2007 value).

	dbscale(2009-minyear:2009-minyear+1) = dbscale(2009-minyear-1)  ! IVS: Set 2008-2009 equal to 2007.

	ip = ip+ 2009-minyear-2+1                                       ! IVS:

END IF

IF(AgeEffectsTrans==0 .and. YearEffectsTrans==0) THEN
	vepsage = 0.0
	vepsyear = Xsol(ip)
	ip = ip+1
ELSE IF(AgeEffectsTrans==9 .and. YearEffectsTrans==0) THEN
	vepsyear = Xsol(ip)
	vepsage(1) = 0.0
	vepsage(2:nage) = Xsol(ip+1:ip+nage-1)
	ip = ip + nage
ELSE IF(AgeEffectsTrans<9 .and. YearEffectsTrans==0) THEN
	vepsyear = Xsol(ip)
	DO ia = 1,nage
		vepsage(ia) = 0.0
		DO io = 1,AgeEffectsTrans
			vepsage(ia) = vepsage(ia) + (ia**io)*Xsol(ip+io)
		END DO
	END DO
	ip = ip + AgeEffectsTrans+1
ELSE IF(AgeEffectsTrans==0 .and. YearEffectsTrans==1) THEN
	vepsage = 0.0
	!!!vepsyear(1:1996-minyear+1) = Xsol(ip:ip + 1996-minyear)
	!!!vepsyear(1996-minyear+3) = Xsol(ip + 1996-minyear+1)						!1998
	!!!vepsyear(1996-minyear+5) = Xsol(ip + 1996-minyear+2)						!2000
	!!!vepsyear(1996-minyear+7) = Xsol(ip + 1996-minyear+3)						!2002
	!!!vepsyear(1996-minyear+9) = Xsol(ip + 1996-minyear+4)						!2004
	!!!vepsyear(1996-minyear+11) = Xsol(ip + 1996-minyear+5)					!2006
	!!!vepsyear(1996-minyear+13) = Xsol(ip + 1996-minyear+6)					!2008

	!!!vepsyear(1996-minyear+2) = 0.5*(Xsol(ip + 1996-minyear)	+ Xsol(ip + 1996-minyear+1))	!1997
	!!!vepsyear(1996-minyear+4) = 0.5*(Xsol(ip + 1996-minyear+1)	+ Xsol(ip + 1996-minyear+2))	!1999
	!!!vepsyear(1996-minyear+6) = 0.5*(Xsol(ip + 1996-minyear+2)	+ Xsol(ip + 1996-minyear+3))	!2001
	!!!vepsyear(1996-minyear+8) = 0.5*(Xsol(ip + 1996-minyear+3)	+ Xsol(ip + 1996-minyear+4))	!2003
	!!!vepsyear(1996-minyear+10) = 0.5*(Xsol(ip + 1996-minyear+4)	+ Xsol(ip + 1996-minyear+5))	!2005
	!!!vepsyear(1996-minyear+12) = 0.5*(Xsol(ip + 1996-minyear+5)	+ Xsol(ip + 1996-minyear+6))	!2007

	!!!ip = ip + 1996-minyear+7

	!!!!!!vepsyear(1:2009-minyear+1) = Xsol(ip:ip + 2009-minyear)              ! IVS: 23 elements (corresponding to 1987-2009).
	!!!!!!ip = ip + 2009-minyear+1                                             ! IVS:


	vepsyear(1) = Xsol(ip)                    ! IVS: The first element is the ST DEV of eps shock in 1st year (1987); when pi(1)==1.0.

	pi(1) = 1.0
	pi(2:2009-minyear+1) = Xsol(ip+1:ip + 2009-minyear)

	DO it = 2,nyear

	    vepsyear(it) = vepsyear(1)*pi(it)                                ! IVS: ST DEV of eps shock in year it (this is squared below)

	END DO

	ip = ip + 2009-minyear+1                                             ! IVS:






ELSE IF(AgeEffectsTrans==9 .and. YearEffectsTrans==1) THEN
	vepsage(1) = 0.0
	vepsage(2:nage) = Xsol(ip:ip+nage-2)
	ip = ip + nage-1
	!!!vepsyear(1:1996-minyear+1) = Xsol(ip:ip + 1996-minyear)
	!!!vepsyear(1996-minyear+3) = Xsol(ip + 1996-minyear+1)						!1998
	!!!vepsyear(1996-minyear+5) = Xsol(ip + 1996-minyear+2)						!2000
	!!!vepsyear(1996-minyear+7) = Xsol(ip + 1996-minyear+3)						!2002
	!!!vepsyear(1996-minyear+9) = Xsol(ip + 1996-minyear+4)						!2004
	!!!vepsyear(1996-minyear+11) = Xsol(ip + 1996-minyear+5)					!2006
	!!!vepsyear(1996-minyear+13) = Xsol(ip + 1996-minyear+6)					!2008

	!!!vepsyear(1996-minyear+2) = 0.5*(Xsol(ip + 1996-minyear)	+ Xsol(ip + 1996-minyear+1))	!1997
	!!!vepsyear(1996-minyear+4) = 0.5*(Xsol(ip + 1996-minyear+1)	+ Xsol(ip + 1996-minyear+2))	!1999
	!!!vepsyear(1996-minyear+6) = 0.5*(Xsol(ip + 1996-minyear+2)	+ Xsol(ip + 1996-minyear+3))	!2001
	!!!vepsyear(1996-minyear+8) = 0.5*(Xsol(ip + 1996-minyear+3)	+ Xsol(ip + 1996-minyear+4))	!2003
	!!!vepsyear(1996-minyear+10) = 0.5*(Xsol(ip + 1996-minyear+4)	+ Xsol(ip + 1996-minyear+5))	!2005
	!!!vepsyear(1996-minyear+12) = 0.5*(Xsol(ip + 1996-minyear+5)	+ Xsol(ip + 1996-minyear+6))	!2007

	!!!ip = ip + 1996-minyear+7

	vepsyear(1:2009-minyear+1) = Xsol(ip:ip + 2009-minyear)       ! IVS: 23 elements (corresponding to 1987-2009).

	ip = ip + 2009-minyear+1                                      ! IVS:

END IF

IF(IncludePH==1) THEN
	vph = Xsol(ip)
	ip = ip+1
ELSE
	vph = 0.0
END IF	

IF(IncludePHcovFE==1) THEN
	covph = Xsol(ip)
	ip = ip+1
ELSE
	covph = 0.0
END IF

vph = vph**2

veta = veta**2
vfe = vfe**2
vepsyear = vepsyear**2
DO ia = 1,nage
DO it = 1,nyear
	veps(ia,it) =  vepsage(ia) + vepsyear(it)		!note no square on age so that effect of age can be negative.
END DO
END DO
dbscale = dbscale**2

!get vectors and averages for use in model
varalpha = sum(vfe)/real(nyear)
vareta = sum(veta)/real(nyear)
vareps_vec = sum(vepsyear)/real(nyear) +vepsage

!IF(Bootstrap==0) THEN
!	write(*,*) "av veta", sum(veta)/real(nyears)
!	write(*,*) "av veps", sum(veps)/real(nyears)
!	write(*,*) "vz0", vz0
!    if (IncludeMA1 == 1) write(*,*) "theta", theta
 !   if (RestrictRandWalk == 0) write(*,*) "rho", rho
!END IF
!write(*,*) "minimized distance:	", Fsol

IF (Bootstrap==0)CALL ObjFunction (nmoments,npar,Xfinal,Ffinal,1)

!get average covariance function
!avcovfn(1) = sum(Vy(:,:)) / real(nage*nyears)
!do id = 1,nlag
!    avcovfn(id+1) = sum(COVy(1+id:nage,1+id:nyears,id)) / real((nage-id)*(nyears-id))
!end do

END SUBROUTINE Estimation

