clear

local maxPE = 35
local maxLEADS = 22

********************************************************************************************
* using empirical variances and covariances from tax data
********************************************************************************************

 use /fa/home/m1ixv00/labinc/BPEA/covs_data/CovsData_labinc_CAL.dta

********************************************************************************************
********************************************************************************************
********************************************************************************************

gen cohort = yrvar - hvar + 1

keep if (hvar>=1 & hvar<=35)           /* some datasets include hvar=36, some don't; this discrepancy creates problems */
keep if (cohort>=1953 & cohort<=2009)  /* also make sure cohorts are the same across all datasets (to do that, exclude 1952) */

summ

********************************************************************************************
********************************************************************************************
* Create PE and year dummies, regress, and graph.
********************************************************************************************
********************************************************************************************

* Create PE dummies

forvalues h = 1(1)35 {
    gen DUM_PE_`h' = 0
    replace DUM_PE_`h' = 1 if (hvar==`h')
}


* Create year dummies

forvalues y = 1987(1)2009 {
    gen DUM_`y' = 0
    replace DUM_`y' = 1 if (yrvar==`y')
}


* Create lead dummies

forvalues k = 0(1)22 {
    gen DUM_lead_`k' = 0
    replace DUM_lead_`k' = 1 if (jvar==`k')
}


* Regress

reg  covvar  DUM_lead_1-DUM_lead_22  DUM_PE_1-DUM_PE_35   DUM_1987-DUM_2008, nocons      

/* Note: DUM_2009 is the ommitted category */
/* Note: DUM_lead_0 is the ommitted category */





* Store estimated coeffs

*scalar coeff_PE_1 = _b[_cons]
*forvalues h = 2(1)35 {
*    scalar coeff_PE_`h' = _b[_cons] + _b[DUM_PE_`h']
*}


scalar cov_hat_0 = _b[DUM_PE_21]       /* Note: PE_21 corresponds to age 45. */

forvalues k = 1(1)22 {
    scalar cov_hat_`k' = cov_hat_0 + _b[DUM_lead_`k']
}


scalar list


***list, clean noobs







