/*OPTIONS NOCENTER LS=155 PS=60 COMPRESS=YES NOFMTERR;*/
/***********************************************************************/
/*  Program: panel_BPEA_1987_2009.sas										   */
/*  Last updated: August 30, 2012                                         */
/*  Purpose:  Subset data from the 1987-96 Family Panel and 1997-09 Insoles               */
/*    Notes:  This program reads in data from the 1987-96 family       */
/*            Panel and 1997-2009 insole subsets, and runs the tax     */
/*			  calculator to calculate first and last dollar marginal   */
/*			  tax rates on retirement contributions 				   */
/*  PrevPgm:  panel_1987_2009full.sas                                                    */
/***********************************************************************/

option obs = max;
LIBNAME     lab    "D:\Panel8706\LaborInc";
LIBNAME     bpea    "D:\Panel8706\LaborInc\BPEA";


proc sql ;
	create table lab.bpea_sample_87to09 as
	select issnp, year, taxyr, p_ssa_dod, s_ssa_dod, dobyr, sdobyr, age, agep, cahe, cafhe, hmie, retx, state, solenetincc, bil, adjtotinc, iraexc, empcont, tirad, ptpen, ssinc, ucagix, alimony, intst, dbe, cgagix, cgd40, suppgl, othinc, sitr, alimony, bil, sche, fil, ucagix, ssagix,
		sbc, in_insole, rentinc, estu, esttrust, sche, totincx, texint, ptpexc, ssexc, grearn, grearnp, grearns, was, solegrreceiptc, cgtot, part, scorp, fil, mars, pgender, sgender, wgt, cwhs1, cwhs2, cwhs3, grearnm, hhinc, hhincat, seernm, issnm, agem, year, seern, income1, income2, income3, income4, wasp, wass, empcontp, empconts, ages, issns 
	from lab.panel79_09full 
	where (issnp^=.) and (year<= 2009) and(year>=1987);
run ;



PROC EXPORT DATA= lab.bpea_sample_87to09 
            OUTFILE= "D:\Panel8706\LaborInc\BPEA\bpea_sample_87to09.dta" 
            DBMS=STATA REPLACE;
RUN;