/*OPTIONS NOCENTER LS=155 PS=60 COMPRESS=YES NOFMTERR;*/
/***********************************************************************/
/*  Program: panel1987_2009full.sas										   */
/*  Last updated: August 30, 2010                                         */
/*  Purpose:  Subset data from the 1987-96 Family Panel and 1997-09 Insoles               */
/*    Notes:  This program reads in data from the 1987-96 family       */
/*            Panel and 1997-2008 insole subsets, and runs the tax     */
/*			  calculator to calculate first and last dollar marginal   */
/*			  tax rates on retirement contributions 				   */
/*  PrevPgm:  none                                                     */
/***********************************************************************/

option obs = max;
LIBNAME     lab    "G:\REV_EST\DeBacker\Panel8706\LaborInc";
LIBNAME     self    "G:\REV_EST\DeBacker\Panel8706\SelfEmpIncome";
LIBNAME     gee   "D:\DM1";



/* Append cross-sections together */
DATA panel79_09full (COMPRESS=YES);
    SET 
		lab.INSOLE97_09full lab.INSOLE87_96 lab.INSOLE79_86 ;

		/* make sure years all all consistent */
		if year < 1000 then year = year + 1900 ;
		if taxyr < 1000 then taxyr = taxyr + 1900 ;
		if fileyr < 1000 then fileyr = fileyr + 1900 ;
		year = taxyr ; /* note that year and taxyr are the taxyr from the INSOLE files, 
						whereas fileyr is the year that the INSOLE file is from (eg the 1990 INSOLE, which may have returns for other 
						tax year- though I'm not sure why) */
		if year = . then year = fileyr ;
		if taxyr = . then taxyr = fileyr ;
		if year = . then year = taxyr ;

		/* Cut to returns from 1979-2009 */
		if year >= 1979;
		if year <= 2009 ;

		/* Recode missing ages to zero */
		if age = . then age = 0;
		if agesp = . then agesp = 0;

		/* Recode missing depreciation information to zero */
		if E54010 = . then E54010 = 0;
		if E54015 = . then E54015 = 0;
		if E54100 = . then E54100 = 0;
		if E57800 = . then E57800 = 0;
		if E57900 = . then E57900 = 0;
		if E58020 = . then E58020 = 0;
		if E58040 = . then E58040 = 0;
		if E58100 = . then E58100 = 0;
		if E58120 = . then E58120 = 0;
		if E58140 = . then E58140 = 0;
		if E58060 = . then E58060 = 0;
		if E58080 = . then E58080 = 0;
		if E58200 = . then E58200 = 0;
		if E58250 = . then E58250 = 0;
		if E58300 = . then E58300 = 0;

		/* Recode employee contributions to missing if wage information is also missing */
		/* W-2 information is missing for some observations in INSOLES */
		if wasp = . then empcontp = . ;
		if wass = . then empconts = . ;
		if wasp = . and wass = . then empcont = . ;

		/* Create gross earnings variable by adding retirement contributions back into wages */
		grearn = was + empcont;
		grearnp = wasp + empcontp;
		grearns = wass + empconts;
		
		/* Assign individual ages to male and female */
		agem = .;
		if pgender = 1 then agem = age;
		if sgender = 1 then agem = agesp;
		agef = .;
		if pgender = 2 then agef = age;
		if sgender = 2 then agef = agesp;

		/* Assign individual wages to male and female */
		wasm = .;
		if pgender = 1 then wasm = wasp;
		if sgender = 1 then wasm = wass;
		wasf = .;
		if pgender = 2 then wasf = wasp;
		if sgender = 2 then wasf = wass;

		/* Assign individual gross earnings to male and female */
		grearnm = .;
		if pgender = 1 then grearnm = grearnp;
		if sgender = 1 then grearnm = grearns;
		grearnf = .;
		if pgender = 2 then grearnf = grearnp;
		if sgender = 2 then grearnf = grearns;

		* Assign individual self-employment income to male and female;
		seernm = .;
		if pgender = 1 then seernm = seernp;
		if sgender = 1 then seernm = seerns;
		seernf = .;
		if pgender = 2 then seernf = seernp;
		if sgender = 2 then seernf = seerns;

		* Assign individual SSN to male and female;
		issnm = .;
		if pgender = 1 then issnm = issnp;
		if sgender = 1 then issnm = issns;
		issnf = .;
		if pgender = 2 then issnf = issnp;
		if sgender = 2 then issnf = issns;

		* calculate gross household income - the sum of total income, tax exempt interest, 
		* ira pension and ss excluded from agi, and retirement cont;
		hhinc = totincx + texint + iraexc + ptpexc + ssexc + empcont ;

		* Calculate fica taxes;
		fica = 0;
		if year = 1987 then fica = .0715*min(grearnp,43800) + .0715*min(grearns,43800);
		if year = 1988 then fica = .0751*min(grearnp,45000) + .0751*min(grearns,45000);
		if year = 1989 then fica = .0751*min(grearnp,48000) + .0751*min(grearns,48000);
		if year = 1990 then fica = .0765*min(grearnp,51300) + .0765*min(grearns,51300);
		if year = 1991 then fica = .062*min(grearnp,53400) + .062*min(grearns,53400) + .0145*min(grearnp,125000) + .0145*min(grearns,125000);
		if year = 1992 then fica = .062*min(grearnp,55500) + .062*min(grearns,55500) + .0145*min(grearnp,130200) + .0145*min(grearns,130200);
		if year = 1993 then fica = .062*min(grearnp,57600) + .062*min(grearns,57600) + .0145*min(grearnp,135000) + .0145*min(grearns,135000);
		if year = 1994 then fica = .062*min(grearnp,60600) + .062*min(grearns,60600) + .0145*grearnp + .0145*grearns;
		if year = 1995 then fica = .062*min(grearnp,61200) + .062*min(grearns,61200) + .0145*grearnp + .0145*grearns;
		if year = 1996 then fica = .062*min(grearnp,62700) + .062*min(grearns,62700) + .0145*grearnp + .0145*grearns;
		if year = 1997 then fica = .062*min(grearnp,65400) + .062*min(grearns,65400) + .0145*grearnp + .0145*grearns;
		if year = 1998 then fica = .062*min(grearnp,68400) + .062*min(grearns,68400) + .0145*grearnp + .0145*grearns;
		if year = 1999 then fica = .062*min(grearnp,72600) + .062*min(grearns,72600) + .0145*grearnp + .0145*grearns;
		if year = 2000 then fica = .062*min(grearnp,76200) + .062*min(grearns,76200) + .0145*grearnp + .0145*grearns;
		if year = 2001 then fica = .062*min(grearnp,80400) + .062*min(grearns,80400) + .0145*grearnp + .0145*grearns;
		if year = 2002 then fica = .062*min(grearnp,84900) + .062*min(grearns,84900) + .0145*grearnp + .0145*grearns;
		if year = 2003 then fica = .062*min(grearnp,87000) + .062*min(grearns,87000) + .0145*grearnp + .0145*grearns;
		if year = 2004 then fica = .062*min(grearnp,87900) + .062*min(grearns,87900) + .0145*grearnp + .0145*grearns;
		if year = 2005 then fica = .062*min(grearnp,90000) + .062*min(grearns,90000) + .0145*grearnp + .0145*grearns;
		if year = 2006 then fica = .062*min(grearnp,94200) + .062*min(grearns,94200) + .0145*grearnp + .0145*grearns;
		if year = 2007 then fica = .062*min(grearnp,97500) + .062*min(grearns,97500) + .0145*grearnp + .0145*grearns;
		if year = 2008 then fica = .062*min(grearnp,102000) + .062*min(grearns,102000) + .0145*grearnp + .0145*grearns;
		if year = 2009 then fica = .062*min(grearnp,106800) + .062*min(grearns,106800) + .0145*grearnp + .0145*grearns;
		if grearnp = . then fica = .;
		if grearns = . then fica = .;

		/* make net short and long term capital gains name consitent over time */
		if netstcg = . then netstcg = nstgl ;
		if netltcg = . then netltcg = nltgl ;

		/* Create total capital gains variable */
		cgtot = CGAGIX + CGDIST + SUPPGL;

		/* create variable for schedule c attached */
		has_c = 0 ;
		if num_sch_c > 0 then has_c = 1 ;
		*if c_filer > 0 then has_c = 1 ;

		* calculate household income after taxes - the sum of hhinc less total taxes and fica, plus eitc and add'l ctc;
		hhincat = hhinc - tot_liab - fica + eicx + actcx;

		* Calculate other income as residual, since other income variable sometimes does not include all amounts claimed on that line;
		othinc_original = othinc;
		interest = int ;
		if interest = . then interest = intst ;
		drop int ;
		othinc = totincx - was - interest - dbe - sitr - alimony - bil - cgagix - cgd40 - suppgl - tirad - ptpen - sche - fil - ucagix - ssagix; 


		* caluculate intermediate income measures *;
		* income1 = labor income of all household members;
		income1 = was + empcont;

		* income2 = income1 + transfers and retirement (alimony, unemployment compensation, social security, pension, tax refunds );
		income2 = income1 + alimony + ucagix + ssinc + ptpen + ptpexc + tirad + iraexc + sitr;

		* income3 = income2 + investment income (interest, dividendends, capital gains, and other income);
		income3 = income2 + interest + texint + dbe + cgagix + cgd40 + suppgl + othinc;

		* income4 = income3 + business income (schedule c, farm, and schedule E income) = household income;
		income4 = income3 + bil + fil + sche;

		/* calculate "Adjusted Total Income" */
		ADJTOTINC = totincx + texint + iraexc + ptpexc + ssexc;
		if taxyr = 1987 & ADJTOTINC = . then ADJTOTINC = totincx + texint + ptpexc + ssexc ;
		if taxyr = 1987 & ADJTOTINC = 0 then ADJTOTINC = totincx + texint + ptpexc + ssexc ;

		/* fix SBC - should be 0 after 1985 */
		if taxyr >= 1985 then sbc = 0 ;
		
	
		/* Impute assets using depreciation information */
		* current year expensed items;
		currexpensedcost = E54015;

		* cost of depreciated listed items from current and prior years;
		listeddepcost = E58060 - E54010;
		
		* cost of current year MACRS depreciable items;
		currmacrscost = E57800 + E58020;

		* share of current year MACRS that was deducted (if nothing deducted in current year, set at 20%);
		delta = max((E57900 + E58040)/(E57800 + E58020 + 1), .20);
		
		* imputed cost of previous years' MACRS depreciated items (assume sect168-f-1 and other dep grossed up by same amount);
		prevmacrscost = (E58100 + E58120 + E58140)/delta;

		* cost of current year amotized items;
		curramortcost = E58200;

		* share of current year amortized costs being deducted (if nothing amortized in current year, set at 20%);
		alpha = max((E58300 - E58250)/(E58200+1), .20);

		* imputed cost of previous years' amortized items;
		prevamortcost = E58250/alpha;

		* impute assets using above variables;
		assets = currexpensedcost + listeddepcost + currmacrscost + prevmacrscost + curramortcost + prevamortcost;

	
		/* Generate indicator for CWHS returns under various definitions */
		CWHS1 = (mod(issnp, 10000) in (2520,2545));
		CWHS2 = (mod(issnp, 10000) in (2505,2520,2545,2570,2595));
		CWHS3 = (mod(issnp, 10000) in (2505,2520,2545,2570,2595,7505,7520,7545,7570,7595));


	

		* mask SSNs;
		/*
		issnm = mod(issnm + 482896371, 1000000000);
		issnf = mod(issnf + 243895632, 1000000000);
		issnp = mod(issnp + 134074583, 1000000000);
		issns = mod(issns + 584790427, 1000000000);
	*/

RUN;



/* Output dataset of SSN's with demographic characteristics */
/* PRIMARY FILERS */
DATA INSOLE79_09DEMOGP (COMPRESS=YES);
    SET panel79_09full ;

	IF PGENDER NE .;
	IF PGENDER NE 0.;
	IF DOBYR NE .;
	IF DOBYR NE 0;

	/* Copy primary information over to secondary */
	sgender = pgender;
	sdobyr = dobyr;
	issns = issnp;

	KEEP ISSNP ISSNS PGENDER DOBYR SGENDER SDOBYR;
RUN;

/* SECONDARY FILERS */
DATA INSOLE79_09DEMOGS (COMPRESS=YES);
    SET panel79_09full ;

	IF SGENDER NE .;
	IF SGENDER NE 0;
	IF SDOBYR NE .;
	IF SDOBYR NE 0;

	/* Copy secondary information over to primary */
	pgender = sgender;
	dobyr = sdobyr;
	issnp = issns;

	KEEP ISSNP ISSNS PGENDER DOBYR SGENDER SDOBYR;
RUN;

/* MERGE PRIMARY AND SECONDARY TOGETHER */
DATA INSOLE79_09DEMOG ;
	set INSOLE79_09DEMOGP INSOLE79_09DEMOGS;

RUN;

/* Drop duplicate observations */
proc sort data=INSOLE79_09DEMOG ;
	by issnp ;
run ;

data INSOLE79_09DEMOG ;
	set INSOLE79_09DEMOG ;

	issnp_above = lag1(issnp) ;
run  ;

data INSOLE79_09DEMOG ;
	set INSOLE79_09DEMOG;
	if issnp = issnp_above then duplicate = 1 ;
		else duplicate = 0 ;

	if duplicate = 0 ;
	

	/* Rename gender and dob variables as alternates */
	PGENDERALT = PGENDER;
	DOBYRALT = DOBYR;
	SGENDERALT = SGENDER;
	SDOBYRALT = SDOBYR;
	ISSNPALT = ISSNP;
	ISSNSALT = ISSNS;

	DROP DUPLICATE ISSNP_ABOVE PGENDER DOBYR SGENDER SDOBYR;

run ;

/* Create two separate files (one for primary, one for secondary) and sort */
data INSOLE79_09DEMOGPRIMARY ;
	SET INSOLE79_09DEMOG;

	if issnp ne .;
	if issnp ne 0;

	KEEP ISSNP ISSNPALT PGENDERALT DOBYRALT;
RUN;

PROC SORT DATA=INSOLE79_09DEMOGPRIMARY;
	BY ISSNP;
RUN;

data INSOLE79_09DEMOGSECONDARY ;
	SET INSOLE79_09DEMOG;

	if issns ne .;
	if issns ne 0;

	KEEP ISSNS ISSNSALT SGENDERALT SDOBYRALT;
RUN;

PROC SORT DATA=INSOLE79_09DEMOGSECONDARY;
	BY ISSNS;
RUN;


/* Means of demographics without carried over information */
PROC MEANS DATA=panel79_09full ;
	VAR ISSNP ISSNS PGENDER DOBYR SGENDER SDOBYR;
RUN;

/* Merge gender and dob variables into main dataset when missing */

/* Sort main dataset by issnp */
PROC SORT DATA=panel79_09full ;
	BY ISSNP;
RUN;

/* Merge in alternate demographic information for primary filers */
DATA panel79_09full ;
  MERGE panel79_09full (IN = master) INSOLE79_09DEMOGPRIMARY; 
  BY ISSNP; 

  if master = 1;
RUN; 

/* Sort main dataset by issns */
PROC SORT DATA=panel79_09full;
	BY ISSNS;
RUN;

/* Merge in alternate demographic information for secondary filers */
DATA panel79_09full ;
  MERGE panel79_09full (in = master) INSOLE79_09DEMOGSECONDARY; 
  BY ISSNS; 

  if master = 1;
RUN; 


/* Copy over gender and dob if missing */
DATA panel79_09full  (COMPRESS=YES);
	set panel79_09full ;
	
	if PGENDER = . OR PGENDER = 0 THEN PGENDER = PGENDERALT;
	if DOBYR = . OR DOBYR = 0 THEN DOBYR = DOBYRALT;

	if issns ne 0 then do;
		if SGENDER = . OR SGENDER = 0 THEN SGENDER = SGENDERALT;
		if SDOBYR = . OR SDOBYR = 0 THEN SDOBYR = SDOBYRALT;
		if (SGENDER = . OR SGENDER = 0) and PGENDER = 1 THEN SGENDER = 2;
		if (SGENDER = . OR SGENDER = 0) and PGENDER = 2 THEN SGENDER = 1;
	end;

	/* Reset gender and dob vars to missing if no secondary filer */
	if issns = 0 then SDOBYR = . ;
	if issns = 0 then SGENDER = . ;

	DROP ISSNPALT PGENDERALT DOBYRALT ISSNSALT SGENDERALT SDOBYRALT;
RUN;



proc datasets library=work;
   delete INSOLE79_09DEMOGSECONDARY INSOLE79_09DEMOG INSOLE79_09DEMOGS INSOLE79_09DEMOGP INSOLE79_09DEMOGSECONDARY INSOLE79_09DEMOGPRIMARY ;
run;



data gee.new_ssa_dm1 ;
	set gee.ssa_dm1 ;
	if ssa_dob = "." then ssa_dob ="0" ;
	if ssa_dod = "." then ssa_dod ="0" ;
	if unmasked_tin = "." then unmasked_tin ="0" ;
	new_unmasked_tin=input(unmasked_tin, 9.);
	new_ssa_dob=input(ssa_dob, 8.);
	new_ssa_dod=input(ssa_dod, 8.);
run ;

/* create primary filer demographic info from DM1 file */
proc sql ;
	create table gee.primary_dm1 as
	select new_unmasked_tin, gnd_ind as p_gnd_ind, new_ssa_dob as p_ssa_dob, new_ssa_dod as p_ssa_dod
	from gee.new_ssa_dm1 	
	quit ;
run ;


/* create secondary filer demographic info from DM1 file */
proc sql ;
	create table gee.secondary_dm1 as
	select new_unmasked_tin, gnd_ind as s_gnd_ind, new_ssa_dob as s_ssa_dob, new_ssa_dod as s_ssa_dod
	from gee.new_ssa_dm1 	
	quit ;
run ;

proc datasets library=gee;
   delete new_ssa_dm1;
run;

/* merge in primary demographic info from DM1 file */
proc sql ;
	create table panel79_09full2 as
	select a.*, b.p_gnd_ind, b.p_ssa_dob, b.p_ssa_dod
	from panel79_09full as a
		left join gee.primary_dm1 as b
	on (a.issnp=b.new_unmasked_tin) ;
	quit ;
run ;

proc datasets library=gee;
   delete primary_dm1;
run;

proc datasets library=work;
   delete panel79_09full ;
run;

/* merge in secondary filer demographic info from DM1 file */
proc sql ;
	create table panel79_09full3 as
	select a.*, b.s_gnd_ind, b.s_ssa_dob, b.s_ssa_dod
	from panel79_09full2 as a
		left join gee.secondary_dm1 as b
	on (a.issns=b.new_unmasked_tin) ;
	quit ;
run ;

proc datasets library=gee;
   delete secondary_dm1;
run;

proc datasets library=work;
   delete panel79_09full2 ;
run;

/* Copy over gender and dob if missing */
DATA panel79_09full3  (COMPRESS=YES);
	set panel79_09full3 ;
	
	if p_gnd_ind = "M" then p_ssa_gender = 1 ;
	if p_gnd_ind = "F" then p_ssa_gender = 2 ;

	if s_gnd_ind = "M" then s_ssa_gender = 1 ;
	if s_gnd_ind = "F" then s_ssa_gender = 2 ;

	p_ssa_dobyr = floor(p_new_ssa_dob/10000) ;
	s_ssa_dobyr = floor(s_new_ssa_dob/10000) ;	

	if PGENDER = . OR PGENDER = 0 THEN PGENDER = p_ssa_gender ;
	if DOBYR = . OR DOBYR = 0 THEN DOBYR = p_ssa_dobyr;

	if issns ne 0 then do;
		if SGENDER = . OR SGENDER = 0 THEN SGENDER = s_ssa_gender ;
		if SDOBYR = . OR SDOBYR = 0 THEN SDOBYR = s_ssa_dobyr ;
		if (SGENDER = . OR SGENDER = 0) and PGENDER = 1 THEN SGENDER = 2;
		if (SGENDER = . OR SGENDER = 0) and PGENDER = 2 THEN SGENDER = 1;
	end;

	/* Reset gender and dob vars to missing if no secondary filer */
	if issns = 0 then SDOBYR = . ;
	if issns = 0 then SGENDER = . ;
	if issns = . then SDOBYR = . ;
	if issns = . then SGENDER = . ;

	DROP p_gnd_ind p_ssa_gender s_gnd_ind s_ssa_gender p_ssa_dobyr s_ssa_dobyr p_new_ssa_dob s_new_ssa_dob ;
RUN;


proc sort data = panel79_09full3 ;
	by year ;
run ;

proc means data= panel79_09full3 ;
	var issnp ;
	class year ;
run ;


DATA lab.panel79_09cwhs (COMPRESS=YES);
    SET panel79_09full3 ;
	if CWHS3 = 1 ;
run ;

proc means data= panel79_09full3 ;
	var year fileyr taxyr ;
run ;

data lab.panel79_09full ;
	set panel79_09full3 ;
run ;



/* drop duplicates and those missing ssn for primary filer */
proc sql ;
	create table self.bus_sample_87to09_full_start as
	select issnp, year, taxyr, p_ssa_dod, s_ssa_dod, dobyr, sdobyr, age, agep, cahe, cafhe, hmie, retx, state, solenetincc, bil, adjtotinc,
		sbc, in_insole, rentinc, estu, esttrust, sche, totincx, texint, ptpexc, ssexc, grearn, was, solegrreceiptc, cgtot, part, scorp, fil, mars, pgender, sgender, wgt, cwhs1, cwhs2, cwhs3, assets, scorppas, scorpact, partpas, partact    
	from panel79_09full3 
	where (issnp^=.) and (year<= 2009) and(year>=1987);
run ;

option obs = max;
LIBNAME     lab    "G:\REV_EST\DeBacker\Panel8706\LaborInc";
LIBNAME     self    "G:\REV_EST\DeBacker\Panel8706\SelfEmpIncome";
LIBNAME     gee   "D:\DM1";
/* drop duplicates and those missing ssn for primary filer */
proc sql ;
	create table self.bus_sample_87to09_cwhs_start as
	select issnp, year, taxyr, p_ssa_dod, s_ssa_dod, dobyr, sdobyr, age, agep, cahe, cafhe, hmie, retx, state, solenetincc, bil, adjtotinc,
		sbc, totincx, in_insole, rentinc, estu, esttrust, sche, texint, ptpexc, ssexc, grearn, was, solegrreceiptc, cgtot, part, scorp, fil, mars, pgender, sgender, wgt, cwhs1, assets, scorppas, scorpact, partpas, partact    
	from lab.panel79_09cwhs 
	where (issnp^=.) and (year<= 2009) and(year>=1987);
run ;

PROC EXPORT DATA= SELF.Bus_sample_87to09_cwhs_start 
            OUTFILE= "G:\REV_EST\DeBacker\Panel8706\SelfEmpIncome\Data\Panel\bus_sa
mple_87to09_cwhs_start.dta" 
            DBMS=STATA REPLACE;
RUN;

option obs = max;
LIBNAME     lab    "G:\REV_EST\DeBacker\Panel8706\LaborInc";
LIBNAME     self    "G:\REV_EST\DeBacker\Panel8706\SelfEmpIncome";
LIBNAME     gee   "D:\DM1";

proc sql ;
	create table self.bus_sample_87to09_full_start as
	select issnp, year, taxyr, p_ssa_dod, s_ssa_dod, dobyr, sdobyr, age, agep, cahe, cafhe, hmie, retx, state, solenetincc, bil, adjtotinc,
		sbc, in_insole, rentinc, estu, esttrust, sche, totincx, texint, ptpexc, ssexc, grearn, was, solegrreceiptc, cgtot, part, scorp, fil, mars, pgender, sgender, wgt, cwhs1, cwhs2, cwhs3, assets, scorppas, scorpact, partpas, partact    
	from lab.panel79_09full 
	where (issnp^=.) and (year<= 2009) and(year>=1987);
run ;

PROC EXPORT DATA= SELF.bus_sample_87to09_full_start 
            OUTFILE= "G:\REV_EST\DeBacker\Panel8706\SelfEmpIncome\Data\CrossSections\bus_sa
mple_87to09_full_start.dta" 
            DBMS=STATA REPLACE;
RUN;


PROC EXPORT DATA= SELF.Bus_sample_87to09_cwhs_start 
            OUTFILE= "G:\REV_EST\DeBacker\Panel8706\SelfEmpIncome\Data\Panel\bus_sa
mple_87to09_cwhs_start.dta" 
            DBMS=STATA REPLACE;
RUN;


proc sql ;
	create table check_ages as
	select issnp, issns, dobyr, sdobyr, pgender, age, agep, ages, sgender, wgt, cwhs1, cwhs2, cwhs3, p_ssa_dod, s_ssa_dod, year, taxyr, fileyr
	from panel79_09full3 ;
run ;


PROC EXPORT DATA= check_ages
            OUTFILE= "G:\REV_EST\DeBacker\Panel8706\LaborInc\check_ages_79to09_full.dta" 
            DBMS=STATA REPLACE;
RUN;

proc datasets library=work;
   delete panel79_09full3 ;
run;




proc sort data = lab.panel79_09full ;
 by year ;
run ;
proc means data = lab.panel79_09full ;
	by year ;
	var assets currexpensedcost listeddepcost currmacrscost prevmacrscost curramortcost prevamortcost ;
run ;


