***********************************************************
* Labor Income Dynamics project
* 
***********************************************************
* This program reads in the FinalSampleResids_*.dta  datasets 
*
* It then outputs files that contain year specific age distributions
*
*************************************************************

set more off
set memory 700M
#delimit ;

local datapath "G:\%Office of Tax Analysis\_Individual Staff\Ramnath\Tax Research\BPEA\LaborInc\BPEA\data" ;
local logpath "G:\%Office of Tax Analysis\_Individual Staff\Ramnath\Tax Research\BPEA\LaborInc\BPEA\log_files" ;
local graphpath "G:\%Office of Tax Analysis\_Individual Staff\Ramnath\Tax Research\BPEA\LaborInc\BPEA\graphs" ;
local outputpath "G:\%Office of Tax Analysis\_Individual Staff\Ramnath\Tax Research\BPEA\LaborInc\BPEA\output" ;

log using "`logpath'\createweights.log", replace;


local files "labinc hhinc hhincat hhinc-labincsample hhincat-labincsample income1-labincsample income2-labincsample income3-labincsample labinc_LT labinc_HT2 hhinc_LT hhinc_HT2 hhinc-labincsample_LT hhinc-labincsample_HT2 hhinc_mar hhinc_fixedfamilycomp";

foreach x of local files {;

use "`datapath'\FinalSampleResids_`x'.dta", clear;

keep year PE;

* create weight dummies by PE;
forvalues i = 1(1)36 {;
	gen weight`i'=(PE==`i');
};

drop PE;
collapse (mean) weight*, by(year);

reshape long weight, i(year) j(PE);

save "`outputpath'\weights_`x'.dta", replace;

};

