***********************************************************
* Labor Income Dynamics project
* 
***********************************************************
* This program reads in labinc_data.dta, hhinc-labincsample.dta, 
* hhinc.dta, and hhincat.dta, which contain records 
* from the 1987-96 family panel and the 1997-2009 insoles.  
*
* It then calculates descriptive statics for age from these data
*
*************************************************************
#delimit;

clear;
program drop _all;
clear matrix;
set matsize 1000;
set memory 4000m;
set more off;
cap log close;


local datapath "G:\%Office of Tax Analysis\_Individual Staff\Ramnath\Tax Research\BPEA\LaborInc\BPEA\data" ;
local logpath "G:\%Office of Tax Analysis\_Individual Staff\Ramnath\Tax Research\BPEA\LaborInc\BPEA\log_files" ;
local graphpath "G:\%Office of Tax Analysis\_Individual Staff\Ramnath\Tax Research\BPEA\LaborInc\BPEA\graphs" ;
local outputpath "G:\%Office of Tax Analysis\_Individual Staff\Ramnath\Tax Research\BPEA\LaborInc\BPEA\output" ;


log using "`logpath'\ages_tables.log", replace;

cd "G:\%Office of Tax Analysis\_Individual Staff\Ramnath\Tax Research\BPEA\LaborInc\BPEA\tempfiles";

*** Open and collapse data files ***;
use "`datapath'\labinc_data.dta", clear;
compress;
collapse (mean) mean_age=age (sd) sd_age=age (count) num_obs=age, by(year) ;
format * %23.5f ;
outsheet using "`outputpath'\labinc_age_yr.txt", replace ;


use "`datapath'\hhinc_labincsample_data.dta", clear;
compress;
collapse (mean) mean_age=age (sd) sd_age=age (count) num_obs=age, by(year) ;
format * %23.5f ;
outsheet using "`outputpath'\hhinc_labincsample_age_yr.txt", replace ;

use "`datapath'\hhinc_data.dta", clear;
compress;
collapse (mean) mean_age=age (sd) sd_age=age (count) num_obs=age, by(year) ;
format * %23.5f ;
outsheet using "`outputpath'\hhinc_age_yr.txt", replace ;

use "`datapath'\hhincat_data.dta", clear;
compress;
collapse (mean) mean_age=age (sd) sd_age=age (count) num_obs=age, by(year) ;
format * %23.5f ;
outsheet using "`outputpath'\hhincat_age_yr.txt", replace ;

use "`datapath'\hhincat_labincsample_data.dta", clear;
compress;
collapse (mean) mean_age=age (sd) sd_age=age (count) num_obs=age, by(year) ;
format * %23.5f ;
outsheet using "`outputpath'\hhincat_labincsample_age_yr.txt", replace ;

use "`datapath'\income1_labincsample_data.dta", clear;
compress;
collapse (mean) mean_age=age (sd) sd_age=age (count) num_obs=age, by(year) ;
format * %23.5f ;
outsheet using "`outputpath'\income1_labincsample_age_yr.txt", replace ;

use "`datapath'\income2_labincsample_data.dta", clear;
compress;
collapse (mean) mean_age=age (sd) sd_age=age (count) num_obs=age, by(year) ;
format * %23.5f ;
outsheet using "`outputpath'\income2_labincsample_age_yr.txt", replace ;

use "`datapath'\income3_labincsample_data.dta", clear;
compress;
collapse (mean) mean_age=age (sd) sd_age=age (count) num_obs=age, by(year) ;
format * %23.5f ;
outsheet using "`outputpath'\income3_labincsample_age_yr.txt", replace ;

*** Open and collapse data files ***;
use "`datapath'\labinc_LT_data.dta", clear;
compress;
collapse (mean) mean_age=age (sd) sd_age=age (count) num_obs=age, by(year) ;
format * %23.5f ;
outsheet using "`outputpath'\labinc_LT_age_yr.txt", replace ;


use "`datapath'\hhinc_labincsample_LT_data.dta", clear;
compress;
collapse (mean) mean_age=age (sd) sd_age=age (count) num_obs=age, by(year) ;
format * %23.5f ;
outsheet using "`outputpath'\hhinc_labincsample_LT_age_yr.txt", replace ;

use "`datapath'\hhinc_LT_data.dta", clear;
compress;
collapse (mean) mean_age=age (sd) sd_age=age (count) num_obs=age, by(year) ;
format * %23.5f ;
outsheet using "`outputpath'\hhinc_LT_age_yr.txt", replace ;

*** Open and collapse data files ***;
use "`datapath'\labinc_HT2_data.dta", clear;
compress;
collapse (mean) mean_age=age (sd) sd_age=age (count) num_obs=age, by(year) ;
format * %23.5f ;
outsheet using "`outputpath'\labinc_HT2_age_yr.txt", replace ;


use "`datapath'\hhinc_labincsample_HT2_data.dta", clear;
compress;
collapse (mean) mean_age=age (sd) sd_age=age (count) num_obs=age, by(year) ;
format * %23.5f ;
outsheet using "`outputpath'\hhinc_labincsample_HT2_age_yr.txt", replace ;

use "`datapath'\hhinc_HT2_data.dta", clear;
compress;
collapse (mean) mean_age=age (sd) sd_age=age (count) num_obs=age, by(year) ;
format * %23.5f ;
outsheet using "`outputpath'\hhinc_HT2_age_yr.txt", replace ;

use "`datapath'\hhinc_mar_data.dta", clear;
compress;
collapse (mean) mean_age=age (sd) sd_age=age (count) num_obs=age, by(year) ;
format * %23.5f ;
outsheet using "`outputpath'\hhinc_mar_age_yr.txt", replace ;

use "`datapath'\hhinc_fixedfamilycomp_data.dta", clear;
compress;
collapse (mean) mean_age=age (sd) sd_age=age (count) num_obs=age, by(year) ;
format * %23.5f ;
outsheet using "`outputpath'\hhinc_fixedfamilycomp_age_yr.txt", replace ;

capture log close ;

