/*OPTIONS NOCENTER LS=155 PS=60 COMPRESS=YES NOFMTERR;*/
/***********************************************************************/
/*  Program:  INSOLE97_09full2.SAS                                   */
/*     Date:  2010 August 30                                            */
/*  Purpose:  Subset data from the 1997-09 INSOLES                     */
/*    Notes:  This program reads in data merged data from 1997-2009 insoles    */
/*            created in INSOLE97_09savings1, and merges in            */
/*			  w-2 information										   */
/*  PrevPgm:  INSOLE97_09full1.SAS                                  */
/***********************************************************************/

LIBNAME     SUBSUB  "G:\REV_EST\DeBacker\Panel8706\LaborInc";
LIBNAME     SUBSUB2  "G:\REV_EST\DeBacker\Panel8706";
LIBNAME	    w2		"G:\REV_EST\DeBacker\Panel8706\w2";


/* Merge in wage and salary information */

/* Create empssnyr variable in master dataset for primary filer */
DATA INSOLE97_09 (COMPRESS=YES);
	SET SUBSUB.INSOLE97_09;

	empssnyr = issnp*100 + mod(YR,100);
RUN;

/* Drop extra variables from w2 file */
DATA INSOLE97_09_w2 (COMPRESS=YES);
	SET w2.CWHS_97to09_w2(KEEP=
	empssnyr wasindiv);
RUN;

/* Sort datasets */
PROC SORT DATA=INSOLE97_09;
	BY empssnyr;
RUN;
PROC SORT DATA=INSOLE97_09_w2;
	BY empssnyr;
RUN;

/* Merge in primary wage and salaries*/
DATA INSOLE97_09 (COMPRESS=YES);
	MERGE INSOLE97_09 (IN=master) INSOLE97_09_w2;
		BY empssnyr;
	IF master;
	if wasindiv = . then wasindiv = 0;
	wasp = wasindiv;
	DROP wasindiv empssnyr;
RUN;


/* Create empssnyr variable in master dataset for secondary filer */
DATA INSOLE97_09 (COMPRESS=YES);
	SET INSOLE97_09;

	empssnyr = issns*100 + mod(YR,100);
RUN;

/* Sort dataset */
PROC SORT DATA=INSOLE97_09;
	BY empssnyr;
RUN;

/* Merge in secondary wage and salaries*/
DATA INSOLE97_09 (COMPRESS=YES);
	MERGE INSOLE97_09 (IN=master) INSOLE97_09_w2;
		BY empssnyr;
	IF master;
	if wasindiv = . then wasindiv = 0;
	wass = wasindiv;
	DROP wasindiv;
RUN;



/* Merge in savings information */

/* Create empssnyr variable in master dataset for primary filer */
DATA INSOLE97_09 (COMPRESS=YES);
	SET INSOLE97_09;

	empssnyr = issnp*100 + mod(YR,100);
RUN;

/* Drop extra variables from savings file */
DATA INSOLE97_09_w2savings (COMPRESS=YES);
	SET w2.CWHS_97to09_w2savings(KEEP=
	empssnyr cont401k cont403b contsep cont457b cont501c contsimple numretplans numdcplans empatdcemp);
	
	/* Drop records for SSN = 0, so that nothing is imputed for single filers */
	if empssnyr > 106;
RUN;

/* Sort datasets */
PROC SORT DATA=INSOLE97_09;
	BY empssnyr;
RUN;
PROC SORT DATA=INSOLE97_09_w2savings;
	BY empssnyr;
RUN;

/* Merge in primary savings*/
DATA INSOLE97_09 (COMPRESS=YES);
	MERGE INSOLE97_09 (IN=master) INSOLE97_09_w2savings;
		BY empssnyr;
	IF master;

	/* Assign dc variables to primary filer when w2 present */
	/* Note - these variables will be missing if no w2 was present for that worker */
	cont401kp = cont401k;
	cont403bp = cont403b;
	contsepp = contsep;
	cont457bp = cont457b;
	cont501cp = cont501c;
	contsimplep = contsimple;
	retplansp = numretplans;
	dcplansp = numdcplans;
	empatdcempp = empatdcemp;

	DROP 	cont401k cont403b contsep cont457b cont501c contsimple numretplans numdcplans empatdcemp empssnyr;
RUN;

/* Create empssnyr variable in master dataset for secondary filer */
DATA INSOLE97_09 (COMPRESS=YES);
	SET INSOLE97_09;

	empssnyr = issns*100 + mod(YR,100);
RUN;

/* Sort dataset */
PROC SORT DATA=INSOLE97_09;
	BY empssnyr;
RUN;

/* Merge in secondary savings*/
DATA INSOLE97_09 (COMPRESS=YES);
	MERGE INSOLE97_09 (IN=master) INSOLE97_09_w2savings;
		BY empssnyr;
	IF master;

	/* Assign dc variables to primary filer when w2 present */
	/* Note - these variables will be missing if no w2 was present for that worker */

	cont401ks = cont401k;
	cont403bs = cont403b;
	contseps = contsep;
	cont457bs = cont457b;
	cont501cs = cont501c;
	contsimples = contsimple;

	retplanss = numretplans;
	dcplanss = numdcplans;
	empatdcemps = empatdcemp;

	DROP 	cont401k cont403b contsep cont457b cont501c contsimple numretplans numdcplans empatdcemp empssnyr;
RUN;


/* Merge in IRA and roth IRA information from form 5498 files*/
/* Create ssnrecidyr variable in master dataset for primary filer */
DATA INSOLE97_09 (COMPRESS=YES);
	SET INSOLE97_09;

	/* Create variables to match on */
	ssn = issnp;
	recidyr = retid*100 + mod(fileyr,100);
RUN;

/* Drop extra variables from 5498 file */
DATA form5498_1997_2009E (COMPRESS=YES);
	SET subsub2.form5498_1997_2009E(KEEP=
	empssnyr rec_id yr payee_tin rothcont iracont sim_cont sepcont);

	/* Rename iracont variable because name conflicts with variable already in panel */
	iracontraw = iracont;
	drop iracont;

	/* Create variable to match on */
	ssn = payee_tin;
	recidyr = rec_id*100 + mod(yr,100);
	drop payee_tin rec_id yr;

	/* Drop records for SSN = 0, so that nothing is imputed for single filers */
	if empssnyr > 106;
	drop empssnyr;
RUN;

/* Sort datasets */
PROC SORT DATA=INSOLE97_09 ;
	BY ssn recidyr;
RUN;
PROC SORT DATA=form5498_1997_2009E ;
	BY ssn recidyr;
RUN;

/* Merge in primary 5498 information*/
DATA INSOLE97_09 (COMPRESS=YES);
	MERGE INSOLE97_09 (IN=master) form5498_1997_2009E;
		BY ssn recidyr;
	IF master;

	/* Assign dc variables to primary filer when 5498 is present */
	/* Note - these variables will be missing if no 5498 was present for that worker */
	iracontp = iracontraw;
	rothcontp = rothcont;
	contSEsepp = sepcont;
	contSEsimplep = sim_cont;

	DROP iracontraw rothcont sepcont sim_cont;
RUN;

/* Create ssnrecidyr variable in master dataset for secondary filer */
DATA INSOLE97_09 (COMPRESS=YES);
	SET INSOLE97_09;

	/* Create variable to match on */
	ssn = issns;
	recidyr = retid*100 + mod(fileyr,100);
RUN;

/* Sort dataset */
PROC SORT DATA=INSOLE97_09;
	BY ssn recidyr;
RUN;

/* Merge in secondary savings*/
DATA INSOLE97_09 (COMPRESS=YES);
	MERGE INSOLE97_09 (IN=master) form5498_1997_2009E;
		BY ssn recidyr;
	IF master;

	/* Assign dc variables to primary filer when 5498 is present */
	/* Note - these variables will be missing if no 5498 was present for that worker */
	iraconts = iracontraw;
	rothconts = rothcont;
	contSEseps = sepcont;
	contSEsimples = sim_cont;

	DROP 	iracontraw rothcont sepcont sim_cont;
RUN;

proc sort data=INSOLE97_09;
	by yr;
run;

PROC MEANS DATA=INSOLE97_09;
	by yr;
RUN;

/* Clean up savings data*/
DATA INSOLE97_09 (COMPRESS=YES);
	SET INSOLE97_09;

	/* PAYROLL DEDUCTION RETIREMENT CONTRIBUTIONS */

	/* 1997 
		457b plans limited to 7500
		Simple plans limited to 6000
		Total contributions limited to 9500
	*/

	if yr = 1997 then do;

	if cont401kp + cont403bp + contsepp + cont457bp + cont501cp + contsimplep > 0 then do;
		* Create contribution limit variable;
		limitp = 9500 
			- 2000*(cont457bp > 0)*(cont401kp + cont403bp + contsepp + cont501cp + contsimplep = 0)
			- 3500*(contsimplep > 0)*(cont401kp + cont403bp + contsepp + cont501cp + cont457bp = 0);
		* Cap 457b contributions at 7500 *;
		cont457bp = min(cont457bp, 7500);		
		* Cap Simple contributions at 6000 *;
		contsimplep = min(contsimplep, 6000);
		* Rescale contributions so that total contributions does not exceed 9500 *;
		if cont401kp + cont403bp + contsepp + cont457bp + cont501cp + contsimplep > 9500 then do;
			conttotp_original = cont401kp + cont403bp + contsepp + cont457bp + cont501cp + contsimplep;
			cont401kp = cont401kp*9500/conttotp_original;
			cont403bp = cont403bp*9500/conttotp_original;
			contsepp = contsepp*9500/conttotp_original;
			cont457bp = cont457bp*9500/conttotp_original;
			cont501cp = cont501cp*9500/conttotp_original;
			contsimplep = contsimplep*9500/conttotp_original;
		end;
	end;

	if cont401ks + cont403bs + contseps + cont457bs + cont501cs + contsimples > 0 then do;

		* Create contribution limit variable;
		limits = 9500 
			- 2000*(cont457bs > 0)*(cont401ks + cont403bs + contseps + cont501cs + contsimples = 0)
			- 3500*(contsimples > 0)*(cont401ks + cont403bs + contseps + cont501cs + cont457bs = 0);
		* Cap 457b contributions at 7500 *;
		cont457bs = min(cont457bs, 7500);
		* Cap Simple contributions at 6000 *;
		contsimples = min(contsimples, 6000);
		* Rescale contributions so that total contributions does not exceed 10000 *;
		if cont401ks + cont403bs + contseps + cont457bs + cont501cs + contsimples > 9500 then do;
			conttots_original = cont401ks + cont403bs + contseps + cont457bs + cont501cs + contsimples;
			cont401ks = cont401ks*9500/conttots_original;
			cont403bs = cont403bs*9500/conttots_original;
			contseps = contseps*9500/conttots_original;
			cont457bs = cont457bs*9500/conttots_original;
			cont501cs = cont501cs*9500/conttots_original;
			contsimples = contsimples*9500/conttots_original;
		end;
	end;
	
	end;

	/* 1998 
		457b plans limited to 8000
		Simple plans limited to 6000
		Total contributions limited to 10000
	*/

	if yr = 1998 then do;

	if cont401kp + cont403bp + contsepp + cont457bp + cont501cp + contsimplep > 0 then do;
		* Create contribution limit variable;
		limitp = 10000 
			- 2000*(cont457bp > 0)*(cont401kp + cont403bp + contsepp + cont501cp + contsimplep = 0)
			- 4000*(contsimplep > 0)*(cont401kp + cont403bp + contsepp + cont501cp + cont457bp = 0);
		* Cap 457b contributions at 8000 *;
		cont457bp = min(cont457bp, 8000);		
		* Cap Simple contributions at 6000 *;
		contsimplep = min(contsimplep, 6000);
		* Rescale contributions so that total contributions does not exceed 10000 *;
		if cont401kp + cont403bp + contsepp + cont457bp + cont501cp + contsimplep > 10000 then do;
			conttotp_original = cont401kp + cont403bp + contsepp + cont457bp + cont501cp + contsimplep;
			cont401kp = cont401kp*10000/conttotp_original;
			cont403bp = cont403bp*10000/conttotp_original;
			contsepp = contsepp*10000/conttotp_original;
			cont457bp = cont457bp*10000/conttotp_original;
			cont501cp = cont501cp*10000/conttotp_original;
			contsimplep = contsimplep*10000/conttotp_original;
		end;
	end;

	if cont401ks + cont403bs + contseps + cont457bs + cont501cs + contsimples > 0 then do;

		* Create contribution limit variable;
		limits = 10000 
			- 2000*(cont457bs > 0)*(cont401ks + cont403bs + contseps + cont501cs + contsimples = 0)
			- 4000*(contsimples > 0)*(cont401ks + cont403bs + contseps + cont501cs + cont457bs = 0);
		* Cap 457b contributions at 8000 *;
		cont457bs = min(cont457bs, 8000);
		* Cap Simple contributions at 6000 *;
		contsimples = min(contsimples, 6000);
		* Rescale contributions so that total contributions does not exceed 10000 *;
		if cont401ks + cont403bs + contseps + cont457bs + cont501cs + contsimples > 10000 then do;
			conttots_original = cont401ks + cont403bs + contseps + cont457bs + cont501cs + contsimples;
			cont401ks = cont401ks*10000/conttots_original;
			cont403bs = cont403bs*10000/conttots_original;
			contseps = contseps*10000/conttots_original;
			cont457bs = cont457bs*10000/conttots_original;
			cont501cs = cont501cs*10000/conttots_original;
			contsimples = contsimples*10000/conttots_original;
		end;
	end;
	
	end;



	/* 1999 
		457b plans limited to 8000
		Simple plans limited to 6000
		Total contributions limited to 10000
	*/

	if yr = 1999 then do;

	if cont401kp + cont403bp + contsepp + cont457bp + cont501cp + contsimplep > 0 then do;
		* Create contribution limit variable;
		limitp = 10000 
			- 2000*(cont457bp > 0)*(cont401kp + cont403bp + contsepp + cont501cp + contsimplep = 0)
			- 4000*(contsimplep > 0)*(cont401kp + cont403bp + contsepp + cont501cp + cont457bp = 0);
		* Cap 457b contributions at 8000 *;
		cont457bp = min(cont457bp, 8000);		
		* Cap Simple contributions at 6000 *;
		contsimplep = min(contsimplep, 6000);
		* Rescale contributions so that total contributions does not exceed 10000 *;
		if cont401kp + cont403bp + contsepp + cont457bp + cont501cp + contsimplep > 10000 then do;
			conttotp_original = cont401kp + cont403bp + contsepp + cont457bp + cont501cp + contsimplep;
			cont401kp = cont401kp*10000/conttotp_original;
			cont403bp = cont403bp*10000/conttotp_original;
			contsepp = contsepp*10000/conttotp_original;
			cont457bp = cont457bp*10000/conttotp_original;
			cont501cp = cont501cp*10000/conttotp_original;
			contsimplep = contsimplep*10000/conttotp_original;
		end;
	end;

	if cont401ks + cont403bs + contseps + cont457bs + cont501cs + contsimples > 0 then do;

		* Create contribution limit variable;
		limits = 10000 
			- 2000*(cont457bs > 0)*(cont401ks + cont403bs + contseps + cont501cs + contsimples = 0)
			- 4000*(contsimples > 0)*(cont401ks + cont403bs + contseps + cont501cs + cont457bs = 0);
		* Cap 457b contributions at 8000 *;
		cont457bs = min(cont457bs, 8000);
		* Cap Simple contributions at 6000 *;
		contsimples = min(contsimples, 6000);
		* Rescale contributions so that total contributions does not exceed 10000 *;
		if cont401ks + cont403bs + contseps + cont457bs + cont501cs + contsimples > 10000 then do;
			conttots_original = cont401ks + cont403bs + contseps + cont457bs + cont501cs + contsimples;
			cont401ks = cont401ks*10000/conttots_original;
			cont403bs = cont403bs*10000/conttots_original;
			contseps = contseps*10000/conttots_original;
			cont457bs = cont457bs*10000/conttots_original;
			cont501cs = cont501cs*10000/conttots_original;
			contsimples = contsimples*10000/conttots_original;
		end;
	end;
	
	end;

	/* 2000 
		457b plans limited to 8000
		Simple contributions limited to 6000
		Total contributions limited to 10500
	*/

	if yr = 2000 then do;

	if cont401kp + cont403bp + contsepp + cont457bp + cont501cp + contsimplep > 0 then do;
		* Create contribution limit variable;
		limitp = 10500 
			- 2500*(cont457bp > 0)*(cont401kp + cont403bp + contsepp + cont501cp + contsimplep = 0)
			- 4500*(contsimplep > 0)*(cont401kp + cont403bp + contsepp + cont501cp + cont457bp = 0);
		* Cap 457b contributions at 8000 *;
		cont457bp = min(cont457bp, 8000);	
		* Cap Simple contributions at 6000 *;
		contsimplep = min(contsimplep, 6000);
		* Rescale contributions so that total contributions does not exceed 10000 *;
		if  cont401kp + cont403bp + contsepp + cont457bp + cont501cp + contsimplep > 10500 then do;
			conttotp_original = cont401kp + cont403bp + contsepp + cont457bp + cont501cp + contsimplep;
			cont401kp = cont401kp*10500/conttotp_original;
			cont403bp = cont403bp*10500/conttotp_original;
			contsepp = contsepp*10500/conttotp_original;
			cont457bp = cont457bp*10500/conttotp_original;
			cont501cp = cont501cp*10500/conttotp_original;
			contsimplep = contsimplep*10500/conttotp_original;
		end;
	end;

	if cont401ks + cont403bs + contseps + cont457bs + cont501cs + contsimples > 0 then do;

		* Create contribution limit variable;
		limits = 10500 
			- 2500*(cont457bs > 0)*(cont401ks + cont403bs + contseps + cont501cs + contsimples = 0)
			- 4500*(contsimples > 0)*(cont401ks + cont403bs + contseps + cont501cs + cont457bs = 0);
		* Cap 457b contributions at 8000 *;
		cont457bs = min(cont457bs, 8000);	
		* Cap Simple contributions at 6000 *;
		contsimples = min(contsimples, 6000);
		* Rescale contributions so that total contributions does not exceed 10500 *;
		if  cont401ks + cont403bs + contseps + cont457bs + cont501cs + contsimples > 10500 then do;
			conttots_original = cont401ks + cont403bs + contseps + cont457bs + cont501cs + contsimples;
			cont401ks = cont401ks*10500/conttots_original;
			cont403bs = cont403bs*10500/conttots_original;
			contseps = contseps*10500/conttots_original;
			cont457bs = cont457bs*10500/conttots_original;
			cont501cs = cont501cs*10500/conttots_original;
			contsimples = contsimples*10500/conttots_original;
		end;

	end;

	end;

	/* 2001 
		457b plans limited to 8500
		Simple plans limited to 6500
		Total contributions limited to 10500
	*/

	if yr = 2001 then do;

	if cont401kp + cont403bp + contsepp + cont457bp + cont501cp + contsimplep > 0 then do;
		* Create contribution limit variable;
		limitp = 10500 
			- 2000*(cont457bp > 0)*(cont401kp + cont403bp + contsepp + cont501cp + contsimplep = 0)
			- 4000*(contsimplep > 0)*(cont401kp + cont403bp + contsepp + cont501cp + cont457bp = 0);
		* Cap 457b contributions at 8500 *;	
		cont457bp = min(cont457bp, 8500);
		* Cap Simple contributions at 6500 *;
		contsimplep = min(contsimplep, 6500);
		* Rescale contributions so that total contributions does not exceed 10500 *;
		if cont401kp + cont403bp + contsepp + cont457bp + cont501cp + contsimplep > 10500 then do;
			conttotp_original = cont401kp + cont403bp + contsepp + cont457bp + cont501cp + contsimplep;
			cont401kp = cont401kp*10500/conttotp_original;
			cont403bp = cont403bp*10500/conttotp_original;
			contsepp = contsepp*10500/conttotp_original;
			cont457bp = cont457bp*10500/conttotp_original;
			cont501cp = cont501cp*10500/conttotp_original;
			contsimplep = contsimplep*10500/conttotp_original;
		end;
	end;

	if cont401ks + cont403bs + contseps + cont457bs + cont501cs + contsimples > 0 then do;
		* Create contribution limit variable;
		limits = 10500 
			- 2000*(cont457bs > 0)*(cont401ks + cont403bs + contseps + cont501cs + contsimples = 0)
			- 4000*(contsimples > 0)*(cont401ks + cont403bs + contseps + cont501cs + cont457bs = 0);
		* Cap 457b contributions at 8500 *;	
		cont457bs = min(cont457bs, 8500);
		* Cap Simple contributions at 6500 *;
		contsimples = min(contsimples, 6500);
		* Rescale contributions so that total contributions does not exceed 10500 *;
		if cont401ks + cont403bs + contseps + cont457bs + cont501cs + contsimples > 10500 then do;
			conttots_original = cont401ks + cont403bs + contseps + cont457bs + cont501cs + contsimples;
			cont401ks = cont401ks*10500/conttots_original;
			cont403bs = cont403bs*10500/conttots_original;
			contseps = contseps*10500/conttots_original;
			cont457bs = cont457bs*10500/conttots_original;
			cont501cs = cont501cs*10500/conttots_original;
			contsimples = contsimples*10500/conttots_original;
		end;
	end;

	end;

	/* 2002 
		7000 if only SIMPLE plan
		7500 if over age 50 with only SIMPLE Plan
		Total contributions limited to 11000 generally
		12000 if over age 50 with other plans
	*/

	if yr = 2002 then do;
	
	if cont401kp + cont403bp + contsepp + cont457bp + cont501cp + contsimplep > 0 then do;
		* Create contribution limit variable;
		limitp = 11000 + 1000*(agep >= 50);
		if (contsimplep > 0) and (cont401kp + cont403bp + cont457bp + contsepp + cont501cp = 0) then
			limitp = 7000;
		if (contsimplep > 0) and (cont401kp + cont403bp + cont457bp + contsepp + cont501cp = 0) and (agep >= 50) then
			limitp = 7500;
		* Cap Simple contributions at 7000 or 7500;
		contsimplep = min(contsimplep, 7000 + 500*(agep >= 50));
		* Rescale contributions so that total contributions does not exceed 10500 *;
		if cont401kp + cont403bp + contsepp + cont457bp + cont501cp + contsimplep > limitp then do;
			conttotp_original = cont401kp + cont403bp + contsepp + cont457bp + cont501cp + contsimplep;
			cont401kp = cont401kp*limitp/conttotp_original;
			cont403bp = cont403bp*limitp/conttotp_original;
			contsepp = contsepp*limitp/conttotp_original;
			cont457bp = cont457bp*limitp/conttotp_original;
			cont501cp = cont501cp*limitp/conttotp_original;
			contsimplep = contsimplep*limitp/conttotp_original;
		end;
	end;

	if cont401ks + cont403bs + contseps + cont457bs + cont501cs + contsimples > 0 then do;
		* Create contribution limit variable;
		limits = 11000 + 1000*(ages >= 50);
		if (contsimples > 0) and (cont401ks + cont403bs + cont457bs + contseps + cont501cs = 0) then
			limits = 7000;
		if (contsimples > 0) and (cont401ks + cont403bs + cont457bs + contseps + cont501cs = 0) and (ages >= 50) then
			limits = 7500;
		* Cap Simple contributions at 7000 or 7500*;
		contsimples = min(contsimples, 7000 + 500*(ages >= 50));
		* Rescale contributions so that total contributions does not exceed 10500 *;
		if cont401ks + cont403bs + contseps + cont457bs + cont501cs + contsimples > limits then do;
			conttots_original = cont401ks + cont403bs + contseps + cont457bs + cont501cs + contsimples;
			cont401ks = cont401ks*limits/conttots_original;
			cont403bs = cont403bs*limits/conttots_original;
			contseps = contseps*limits/conttots_original;
			cont457bs = cont457bs*limits/conttots_original;
			cont501cs = cont501cs*limits/conttots_original;
			contsimples = contsimples*limits/conttots_original;
		end;
	end;

	end;

	/* 2003 
		8000 if only SIMPLE Plan
		9000 if over age 50 with only SIMPLE Plan
		Total contributions limited to 12000 generally
		14000 if over age 50 with other plans
	*/

	if yr = 2003 then do;

	if cont401kp + cont403bp + contsepp + cont457bp + cont501cp + contsimplep > 0 then do;
		* Create contribution limit variable;
		limitp = 12000 + 2000*(agep >= 50);
		if (contsimplep > 0) and (cont401kp + cont403bp + cont457bp + contsepp + cont501cp = 0) then
			limitp = 8000;
		if (contsimplep > 0) and (cont401kp + cont403bp + cont457bp + contsepp + cont501cp = 0) and (agep >= 50) then
			limitp = 9000;
		* Cap Simple contributions at 8000 or 9000;
		contsimplep = min(contsimplep, 8000 + 1000*(agep >= 50));
		* Rescale contributions so that total contributions does not exceed 10500 *;
		if cont401kp + cont403bp + contsepp + cont457bp + cont501cp + contsimplep > limitp then do;
			conttotp_original = cont401kp + cont403bp + contsepp + cont457bp + cont501cp + contsimplep;
			cont401kp = cont401kp*limitp/conttotp_original;
			cont403bp = cont403bp*limitp/conttotp_original;
			contsepp = contsepp*limitp/conttotp_original;
			cont457bp = cont457bp*limitp/conttotp_original;
			cont501cp = cont501cp*limitp/conttotp_original;
			contsimplep = contsimplep*limitp/conttotp_original;
		end;
	end;

	if cont401ks + cont403bs + contseps + cont457bs + cont501cs + contsimples > 0 then do;
		* Create contribution limit variable;
		limits = 12000 + 2000*(ages >= 50);
		if (contsimples > 0) and (cont401ks + cont403bs + cont457bs + contseps + cont501cs = 0) then
			limits = 8000;
		if (contsimples > 0) and (cont401ks + cont403bs + cont457bs + contseps + cont501cs = 0) and (ages >= 50) then
			limits = 9000;
		* Cap Simple contributions at 8000 or 9000;
		contsimples = min(contsimples, 8000 + 1000*(ages >= 50));
		* Rescale contributions so that total contributions does not exceed 10500 *;
		if cont401ks + cont403bs + contseps + cont457bs + cont501cs + contsimples > limits then do;
			conttots_original = cont401ks + cont403bs + contseps + cont457bs + cont501cs + contsimples;
			cont401ks = cont401ks*limits/conttots_original;
			cont403bs = cont403bs*limits/conttots_original;
			contseps = contseps*limits/conttots_original;
			cont457bs = cont457bs*limits/conttots_original;
			cont501cs = cont501cs*limits/conttots_original;
			contsimples = contsimples*limits/conttots_original;
		end;
	end;

	end;

	/* 2004 
		9000 if only SIMPLE Plan
		10500 if over age 50 with only SIMPLE Plan
		Total contributions limited to 13000 generally
		16000 if over age 50 with other plans
	*/

	if yr = 2004 then do;

	if cont401kp + cont403bp + contsepp + cont457bp + cont501cp + contsimplep > 0 then do;
		* Create contribution limit variable;
		limitp = 13000 + 3000*(agep >= 50);
		if (contsimplep > 0) and (cont401kp + cont403bp + cont457bp + contsepp + cont501cp = 0) then
			limitp = 9000;
		if (contsimplep > 0) and (cont401kp + cont403bp + cont457bp + contsepp + cont501cp = 0) and (agep >= 50) then
			limitp = 10500;
		* Cap Simple contributions at 9000 or 10500*;
		contsimplep = min(contsimplep, 9000 + 1500*(agep >= 50));
		* Rescale contributions so that total contributions does not exceed 10500 *;
		if cont401kp + cont403bp + contsepp + cont457bp + cont501cp + contsimplep > limitp then do;
			conttotp_original = cont401kp + cont403bp + contsepp + cont457bp + cont501cp + contsimplep;
			cont401kp = cont401kp*limitp/conttotp_original;
			cont403bp = cont403bp*limitp/conttotp_original;
			contsepp = contsepp*limitp/conttotp_original;
			cont457bp = cont457bp*limitp/conttotp_original;
			cont501cp = cont501cp*limitp/conttotp_original;
			contsimplep = contsimplep*limitp/conttotp_original;
		end;
	end;

	if cont401ks + cont403bs + contseps + cont457bs + cont501cs + contsimples > 0 then do;
		* Create contribution limit variable;
		limits = 13000 + 3000*(ages >= 50);
		if (contsimples > 0) and (cont401ks + cont403bs + cont457bs + contseps + cont501cs = 0) then
			limits = 9000;
		if (contsimples > 0) and (cont401ks + cont403bs + cont457bs + contseps + cont501cs = 0) and (ages >= 50) then
			limits = 10500;
		* Cap Simple contributions at 9000 or 10500*;
		contsimples = min(contsimples, 9000 + 1500*(ages >= 50));
		* Rescale contributions so that total contributions does not exceed 10500 *;
		if cont401ks + cont403bs + contseps + cont457bs + cont501cs + contsimples > limits then do;
			conttots_original = cont401ks + cont403bs + contseps + cont457bs + cont501cs + contsimples;
			cont401ks = cont401ks*limits/conttots_original;
			cont403bs = cont403bs*limits/conttots_original;
			contseps = contseps*limits/conttots_original;
			cont457bs = cont457bs*limits/conttots_original;
			cont501cs = cont501cs*limits/conttots_original;
			contsimples = contsimples*limits/conttots_original;
		end;
	end;

	end;

	/* 2005 
		10000 if only SIMPLE Plan
		12000 if over age 50 with only SIMPLE Plan
		Total contributions limited to 14000 generally
		18000 if over age 50 with other plans
	*/

	if yr = 2005 then do;

	if cont401kp + cont403bp + contsepp + cont457bp + cont501cp + contsimplep > 0 then do;
		* Create contribution limit variable;
		limitp = 14000 + 4000*(agep >= 50);
		if (contsimplep > 0) and (cont401kp + cont403bp + cont457bp + contsepp + cont501cp = 0) then
			limitp = 10000;
		if (contsimplep > 0) and (cont401kp + cont403bp + cont457bp + contsepp + cont501cp = 0) and (agep >= 50) then
			limitp = 12000;		
		* Cap Simple contributions at 10000 or 12000*;
		contsimplep = min(contsimplep, 10000 + 2000*(agep >= 50));
		* Rescale contributions so that total contributions does not exceed 10500 *;
		if cont401kp + cont403bp + contsepp + cont457bp + cont501cp + contsimplep > limitp then do;
			conttotp_original = cont401kp + cont403bp + contsepp + cont457bp + cont501cp + contsimplep;
			cont401kp = cont401kp*limitp/conttotp_original;
			cont403bp = cont403bp*limitp/conttotp_original;
			contsepp = contsepp*limitp/conttotp_original;
			cont457bp = cont457bp*limitp/conttotp_original;
			cont501cp = cont501cp*limitp/conttotp_original;
			contsimplep = contsimplep*limitp/conttotp_original;
		end;
	end;

	if cont401ks + cont403bs + contseps + cont457bs + cont501cs + contsimples > 0 then do;
		* Create contribution limit variable;
		limits = 14000 + 4000*(ages >= 50);
		if (contsimples > 0) and (cont401ks + cont403bs + cont457bs + contseps + cont501cs = 0) then
			limits = 10000;
		if (contsimples > 0) and (cont401ks + cont403bs + cont457bs + contseps + cont501cs = 0) and (ages >= 50) then
			limits = 12000;		
		* Cap Simple contributions at 10000 or 12000*;
		contsimples = min(contsimples, 10000 + 2000*(ages >= 50));
		* Rescale contributions so that total contributions does not exceed 10500 *;
		if cont401ks + cont403bs + contseps + cont457bs + cont501cs + contsimples > limits then do;
			conttots_original = cont401ks + cont403bs + contseps + cont457bs + cont501cs + contsimples;
			cont401ks = cont401ks*limits/conttots_original;
			cont403bs = cont403bs*limits/conttots_original;
			contseps = contseps*limits/conttots_original;
			cont457bs = cont457bs*limits/conttots_original;
			cont501cs = cont501cs*limits/conttots_original;
			contsimples = contsimples*limits/conttots_original;
		end;
	end;

	end;


	/* 2006 

		501c contributions limited to 7000 
		10000 if only SIMPLE Plan
		12500 if over age 50 with only SIMPLE Plan
		Total contributions limited to 15000 generally
		20000 if over age 50 with other plans
	*/

	if yr = 2006 then do;

	if cont401kp + cont403bp + contsepp + cont457bp + cont501cp + contsimplep > 0 then do;
		* Create contribution limit variable;
		limitp = 15000 + 5000*(agep >= 50);
		if (contsimplep > 0) and (cont401kp + cont403bp + cont457bp + contsepp + cont501cp = 0) then
			limitp = 10000;
		if (contsimplep > 0) and (cont401kp + cont403bp + cont457bp + contsepp + cont501cp = 0) and (agep >= 50) then
			limitp = 12500;		
		if (cont501cp > 0) and (cont401kp + cont403bp + cont457bp + contsepp + contsimplep = 0) and (agep >= 50) then
			limitp = 7000;		
		* Cap Simple contributions at 10000 or 12000*;
		contsimplep = min(contsimplep, 10000 + 2000*(agep >= 50));
		* Cap 501c contributions at 7000 *;	
		cont501cp = min(cont501cp, 7000);
		* Rescale contributions so that total contributions does not exceed 10500 *;
		if cont401kp + cont403bp + contsepp + cont457bp + cont501cp + contsimplep > limitp then do;
			conttotp_original = cont401kp + cont403bp + contsepp + cont457bp + cont501cp + contsimplep;
			cont401kp = cont401kp*limitp/conttotp_original;
			cont403bp = cont403bp*limitp/conttotp_original;
			contsepp = contsepp*limitp/conttotp_original;
			cont457bp = cont457bp*limitp/conttotp_original;
			cont501cp = cont501cp*limitp/conttotp_original;
			contsimplep = contsimplep*limitp/conttotp_original;
		end;
	end;

	if cont401ks + cont403bs + contseps + cont457bs + cont501cs + contsimples > 0 then do;
		* Create contribution limit variable;
		limits = 15000 + 5000*(ages >= 50);
		if (contsimples > 0) and (cont401ks + cont403bs + cont457bs + contseps + cont501cs = 0) then
			limits = 10000;
		if (contsimples > 0) and (cont401ks + cont403bs + cont457bs + contseps + cont501cs = 0) and (ages >= 50) then
			limits = 12500;		
		if (cont501cs > 0) and (cont401ks + cont403bs + cont457bs + contseps + contsimples = 0) and (ages >= 50) then
			limits = 7000;		
		* Cap Simple contributions at 10000 or 12000*;
		contsimples = min(contsimples, 10000 + 2000*(ages >= 50));
		* Cap 501c contributions at 7000 *;	
		cont501cs = min(cont501cs, 7000);
		* Rescale contributions so that total contributions does not exceed 10500 *;
		if cont401ks + cont403bs + contseps + cont457bs + cont501cs + contsimples > limits then do;
			conttots_original = cont401ks + cont403bs + contseps + cont457bs + cont501cs + contsimples;
			cont401ks = cont401ks*limits/conttots_original;
			cont403bs = cont403bs*limits/conttots_original;
			contseps = contseps*limits/conttots_original;
			cont457bs = cont457bs*limits/conttots_original;
			cont501cs = cont501cs*limits/conttots_original;
			contsimples = contsimples*limits/conttots_original;
		end;
	end;

	end;


		/* 2007 

		501c contributions limited to 7000 
		10000 if only SIMPLE Plan
		12500 if over age 50 with only SIMPLE Plan
		Total contributions limited to 15000 generally
		20000 if over age 50 with other plans

		UPDATED:
		501c contributions limited to *7000* 
		10500 if only SIMPLE Plan
		13000 if over age 50 with only SIMPLE Plan
		Total contributions limited to 15500 generally
		*20000* if over age 50 with other plans
	*/

	if yr = 2007 then do;

	if cont401kp + cont403bp + contsepp + cont457bp + cont501cp + contsimplep > 0 then do;
		* Create contribution limit variable;
		limitp = 15000 + 5000*(agep >= 50);
		if (contsimplep > 0) and (cont401kp + cont403bp + cont457bp + contsepp + cont501cp = 0) then
			limitp = 10500;
		if (contsimplep > 0) and (cont401kp + cont403bp + cont457bp + contsepp + cont501cp = 0) and (agep >= 50) then
			limitp = 13000;		
		if (cont501cp > 0) and (cont401kp + cont403bp + cont457bp + contsepp + contsimplep = 0) and (agep >= 50) then
			limitp = 7000;		
		* Cap Simple contributions at 10000 or 12000*;
		contsimplep = min(contsimplep, 10000 + 2000*(agep >= 50));
		* Cap 501c contributions at 7000 *;	
		cont501cp = min(cont501cp, 7000);
		* Rescale contributions so that total contributions does not exceed 10500 *;
		if cont401kp + cont403bp + contsepp + cont457bp + cont501cp + contsimplep > limitp then do;
			conttotp_original = cont401kp + cont403bp + contsepp + cont457bp + cont501cp + contsimplep;
			cont401kp = cont401kp*limitp/conttotp_original;
			cont403bp = cont403bp*limitp/conttotp_original;
			contsepp = contsepp*limitp/conttotp_original;
			cont457bp = cont457bp*limitp/conttotp_original;
			cont501cp = cont501cp*limitp/conttotp_original;
			contsimplep = contsimplep*limitp/conttotp_original;
		end;
	end;

	if cont401ks + cont403bs + contseps + cont457bs + cont501cs + contsimples > 0 then do;
		* Create contribution limit variable;
		limits = 15000 + 5000*(ages >= 50);
		if (contsimples > 0) and (cont401ks + cont403bs + cont457bs + contseps + cont501cs = 0) then
			limits = 10000;
		if (contsimples > 0) and (cont401ks + cont403bs + cont457bs + contseps + cont501cs = 0) and (ages >= 50) then
			limits = 12500;		
		if (cont501cs > 0) and (cont401ks + cont403bs + cont457bs + contseps + contsimples = 0) and (ages >= 50) then
			limits = 7000;		
		* Cap Simple contributions at 10500 or 12500*;
		contsimples = min(contsimples, 10500 + 2000*(ages >= 50));
		* Cap 501c contributions at 7000 *;	
		cont501cs = min(cont501cs, 7000);
		* Rescale contributions so that total contributions does not exceed 10500 *;
		if cont401ks + cont403bs + contseps + cont457bs + cont501cs + contsimples > limits then do;
			conttots_original = cont401ks + cont403bs + contseps + cont457bs + cont501cs + contsimples;
			cont401ks = cont401ks*limits/conttots_original;
			cont403bs = cont403bs*limits/conttots_original;
			contseps = contseps*limits/conttots_original;
			cont457bs = cont457bs*limits/conttots_original;
			cont501cs = cont501cs*limits/conttots_original;
			contsimples = contsimples*limits/conttots_original;
		end;
	end;

	end;



	/* 2008 

		501c contributions limited to 7000 
		10000 if only SIMPLE Plan
		12500 if over age 50 with only SIMPLE Plan
		Total contributions limited to 15000 generally
		20000 if over age 50 with other plans

		UPDATED:
		501c contributions limited to 8000 
		10500 if only SIMPLE Plan
		13000 if over age 50 with only SIMPLE Plan
		Total contributions limited to 15500 generally
		*20500* if over age 50 with other plans
	*/

	if yr = 2008 then do;

	if cont401kp + cont403bp + contsepp + cont457bp + cont501cp + contsimplep > 0 then do;
		* Create contribution limit variable;
		limitp = 15500 + 5000*(agep >= 50);
		if (contsimplep > 0) and (cont401kp + cont403bp + cont457bp + contsepp + cont501cp = 0) then
			limitp = 10500;
		if (contsimplep > 0) and (cont401kp + cont403bp + cont457bp + contsepp + cont501cp = 0) and (agep >= 50) then
			limitp = 13000;		
		if (cont501cp > 0) and (cont401kp + cont403bp + cont457bp + contsepp + contsimplep = 0) and (agep >= 50) then
			limitp = 8000;		
		* Cap Simple contributions at 10500 or 13000*;
		contsimplep = min(contsimplep, 10500 + 2500*(agep >= 50));
		* Cap 501c contributions at 8000 *;	
		cont501cp = min(cont501cp, 8000);
		* Rescale contributions so that total contributions does not exceed 10500 *;
		if cont401kp + cont403bp + contsepp + cont457bp + cont501cp + contsimplep > limitp then do;
			conttotp_original = cont401kp + cont403bp + contsepp + cont457bp + cont501cp + contsimplep;
			cont401kp = cont401kp*limitp/conttotp_original;
			cont403bp = cont403bp*limitp/conttotp_original;
			contsepp = contsepp*limitp/conttotp_original;
			cont457bp = cont457bp*limitp/conttotp_original;
			cont501cp = cont501cp*limitp/conttotp_original;
			contsimplep = contsimplep*limitp/conttotp_original;
		end;
	end;

	if cont401ks + cont403bs + contseps + cont457bs + cont501cs + contsimples > 0 then do;
		* Create contribution limit variable;
		limits = 15500 + 5000*(ages >= 50);
		if (contsimples > 0) and (cont401ks + cont403bs + cont457bs + contseps + cont501cs = 0) then
			limits = 10500;
		if (contsimples > 0) and (cont401ks + cont403bs + cont457bs + contseps + cont501cs = 0) and (ages >= 50) then
			limits = 13000;		
		if (cont501cs > 0) and (cont401ks + cont403bs + cont457bs + contseps + contsimples = 0) and (ages >= 50) then
			limits = 8000;		
		* Cap Simple contributions at 10000 or 12000*;
		contsimples = min(contsimples, 10500 + 2500*(ages >= 50));
		* Cap 501c contributions at 8000 *;	
		cont501cs = min(cont501cs, 8000);
		* Rescale contributions so that total contributions does not exceed 10500 *;
		if cont401ks + cont403bs + contseps + cont457bs + cont501cs + contsimples > limits then do;
			conttots_original = cont401ks + cont403bs + contseps + cont457bs + cont501cs + contsimples;
			cont401ks = cont401ks*limits/conttots_original;
			cont403bs = cont403bs*limits/conttots_original;
			contseps = contseps*limits/conttots_original;
			cont457bs = cont457bs*limits/conttots_original;
			cont501cs = cont501cs*limits/conttots_original;
			contsimples = contsimples*limits/conttots_original;
		end;
	end;

	end;


	/* 2009 
		501c contributions limited to 8000 
		11500 if only SIMPLE Plan
		14000 if over age 50 with only SIMPLE Plan
		Total contributions limited to 16500 generally
		*22000* if over age 50 with other plans
	*/

	if yr = 2009 then do;

	if cont401kp + cont403bp + contsepp + cont457bp + cont501cp + contsimplep > 0 then do;
		* Create contribution limit variable;
		limitp = 16500 + 5500*(agep >= 50);
		if (contsimplep > 0) and (cont401kp + cont403bp + cont457bp + contsepp + cont501cp = 0) then
			limitp = 11500;
		if (contsimplep > 0) and (cont401kp + cont403bp + cont457bp + contsepp + cont501cp = 0) and (agep >= 50) then
			limitp = 14000;		
		if (cont501cp > 0) and (cont401kp + cont403bp + cont457bp + contsepp + contsimplep = 0) and (agep >= 50) then
			limitp = 8000;		
		* Cap Simple contributions at 10500 or 13000*;
		contsimplep = min(contsimplep, 11500 + 2500*(agep >= 50));
		* Cap 501c contributions at 8000 *;	
		cont501cp = min(cont501cp, 8000);
		* Rescale contributions so that total contributions does not exceed 11500 *;
		if cont401kp + cont403bp + contsepp + cont457bp + cont501cp + contsimplep > limitp then do;
			conttotp_original = cont401kp + cont403bp + contsepp + cont457bp + cont501cp + contsimplep;
			cont401kp = cont401kp*limitp/conttotp_original;
			cont403bp = cont403bp*limitp/conttotp_original;
			contsepp = contsepp*limitp/conttotp_original;
			cont457bp = cont457bp*limitp/conttotp_original;
			cont501cp = cont501cp*limitp/conttotp_original;
			contsimplep = contsimplep*limitp/conttotp_original;
		end;
	end;

	if cont401ks + cont403bs + contseps + cont457bs + cont501cs + contsimples > 0 then do;
		* Create contribution limit variable;
		limits = 16500 + 5500*(ages >= 50);
		if (contsimples > 0) and (cont401ks + cont403bs + cont457bs + contseps + cont501cs = 0) then
			limits = 11500;
		if (contsimples > 0) and (cont401ks + cont403bs + cont457bs + contseps + cont501cs = 0) and (ages >= 50) then
			limits = 14000;		
		if (cont501cs > 0) and (cont401ks + cont403bs + cont457bs + contseps + contsimples = 0) and (ages >= 50) then
			limits = 8000;		
		* Cap Simple contributions at 10000 or 12000*;
		contsimples = min(contsimples, 11500 + 2500*(ages >= 50));
		* Cap 501c contributions at 8000 *;	
		cont501cs = min(cont501cs, 8000);
		* Rescale contributions so that total contributions does not exceed 11500 *;
		if cont401ks + cont403bs + contseps + cont457bs + cont501cs + contsimples > limits then do;
			conttots_original = cont401ks + cont403bs + contseps + cont457bs + cont501cs + contsimples;
			cont401ks = cont401ks*limits/conttots_original;
			cont403bs = cont403bs*limits/conttots_original;
			contseps = contseps*limits/conttots_original;
			cont457bs = cont457bs*limits/conttots_original;
			cont501cs = cont501cs*limits/conttots_original;
			contsimples = contsimples*limits/conttots_original;
		end;
	end;

	end;


	*** total contributions variables;
	* by type;


	* Assign primary amount, then add secondary amount if married and secondary earned wages;
	* This has the effect of having these variables be missing if w2s were missing for either spouse;

	cont401k = cont401kp;
	if wasp = 0 then cont401k = 0;
	if mars = 2 and wass > 0 then cont401k = cont401k + cont401ks;

	cont403b = cont403bp;
	if wasp = 0 then cont403b = 0;
	if mars = 2 and wass > 0 then cont403b = cont403b + cont403bs;

	contsep = contsepp;
	if wasp = 0 then contsep = 0;
	if mars = 2 and wass > 0 then contsep = contsep + contseps;

	cont457b = cont457bp;
	if wasp = 0 then cont457b = 0;
	if mars = 2 and wass > 0 then cont457b = cont457b + cont457bs;

	cont501c = cont501cp;
	if wasp = 0 then cont501c = 0;
	if mars = 2 and wass > 0 then cont501c = cont501c + cont501cs;

	contsimple = contsimplep;
	if wasp = 0 then contsimple = 0;
	if mars = 2 and wass > 0 then contsimple = contsimple + contsimples;


	* overall;
	conttot = cont401k + cont403b + contsep + cont457b + cont501c + contsimple;
	conttotp = cont401kp + cont403bp + contsepp + cont457bp + cont501cp + contsimplep;
	conttots = cont401ks + cont403bs + contseps + cont457bs + cont501cs + contsimples;



	/* TOTAL CONTRIBUTIONS (INCLUDING DC PLANS AND IRAS) */
	allconttot = iracont + conttot;



	/* IRA CONTRIBUTION LIMITS */
	
	iralimitp = 0;
	iralimits = 0;

	*** Set retplans = 0 if wages and salaries == 0 or if missing ***;
	if wasp = 0 then retplansp = 0;
	if mars = 2 and wass = 0 then retplanss = 0;
	if retplansp = . then retplansp = 0;
	if retplanss = . then retplanss = 0;

	if yr = 1997 then do;
		if (mars = 2 and retplansp = 0 and retplanss = 0) or (mars ne 2 and retplansp = 0) then do;
			line7a = 2000;
			if mars = 2 then line7b = 2000;
			line8 = was + max(seern,0) - secaded - sepsimple;
			iralimitp = min(line7a, line8);
			if mars = 2 then iralimits = min(line7b, line8);
			end;
		else do;
			if mars = 1 | mars = 4 then line2a = 35000;
			if mars = 5 then line2a = 50000;
			if mars = 2 then do;
				line2a = 50000;
				line2b = 50000;
			end;
			if mars = 3 then line2a = 10000;
			line3 = totinc;
			line4 = ttadj - iracont - studloan;
			line5a = line3 - line4;
			if mars = 2 then line5b = line3 - line4;
			if line5a > line2a then do;
				iralimitp = 0;
			end;
			else do;
				line7a = max(min(.2*(line2a - line5a),2000),200);
				line8 = was + max(seern,0) - secaded - sepsimple;
				iralimitp = min(line7a, line8);
			end;
			if mars = 2 and line5b > line2b then do;
				iralimits = 0;
			end;
			if mars = 2 and line5b <= line2b then do;
				line7b = max(min(.2*(line2b - line5b),2000),200);
				line8 = was + max(seern,0) - secaded - sepsimple;
				iralimits = min(line7b, line8);
			end;
			
		end;
	
	end;




	if yr = 1998 then do;
		if (mars = 2 and retplansp = 0 and retplanss = 0) or (mars ne 2 and retplansp = 0) then do;
			line7a = 2000;
			if mars = 2 then line7b = 2000;
			line8 = was + max(seern,0) - secaded - sepsimple;
			iralimitp = min(line7a, line8);
			if mars = 2 then iralimits = min(line7b, line8);
			end;
		else do;
			if mars = 1 | mars = 4 then line2a = 40000;
			if mars = 5 then line2a = 60000;
			if mars = 2 and retplansp > 0 and retplanss > 0 then do;
				line2a = 60000;
				line2b = 60000;
			end;
			if mars = 2 and retplansp = 0 and retplanss > 0 then do;
				line2a = 160000;
				line2b = 60000;
			end;
			if mars = 2 and retplansp > 0 and retplanss = 0 then do;
				line2a = 60000;
				line2b = 160000;
			end;
			if mars = 3 then line2a = 10000;
			line3 = totinc;
			line4 = ttadj - iracont - studloan;
			line5a = line3 - line4;
			if mars = 2 then line5b = line3 - line4;
			if line5a > line2a then do;
				iralimitp = 0;
			end;
			else do;
				line7a = max(min(.2*(line2a - line5a),2000),200);
				line8 = was + max(seern,0) - secaded - sepsimple;
				iralimitp = min(line7a, line8);
			end;
			if mars = 2 and line5b > line2b then do;
				iralimits = 0;
			end;
			if mars = 2 and line5b <= line2b then do;
				line7b = max(min(.2*(line2b - line5b),2000),200);
				line8 = was + max(seern,0) - secaded - sepsimple;
				iralimits = min(line7b, line8);
			end;
			
		end;
	
	end;









	if yr = 1999 then do;
		if (mars = 2 and retplansp = 0 and retplanss = 0) or (mars ne 2 and retplansp = 0) then do;
			line7a = 2000;
			if mars = 2 then line7b = 2000;
			line8 = was + max(seern,0) - secaded - sepsimple;
			iralimitp = min(line7a, line8);
			if mars = 2 then iralimits = min(line7b, line8);
			end;
		else do;
			if mars = 1 | mars = 4 then line2a = 41000;
			if mars = 5 then line2a = 61000;
			if mars = 2 and retplansp > 0 and retplanss > 0 then do;
				line2a = 61000;
				line2b = 61000;
			end;
			if mars = 2 and retplansp = 0 and retplanss > 0 then do;
				line2a = 160000;
				line2b = 61000;
			end;
			if mars = 2 and retplansp > 0 and retplanss = 0 then do;
				line2a = 61000;
				line2b = 160000;
			end;
			if mars = 3 then line2a = 10000;
			line3 = totinc;
			line4 = ttadj - iracont - studloan;
			line5a = line3 - line4;
			if mars = 2 then line5b = line3 - line4;
			if line5a > line2a then do;
				iralimitp = 0;
			end;
			else do;
				line7a = max(min(.2*(line2a - line5a),2000),200);
				line8 = was + max(seern,0) - secaded - sepsimple;
				iralimitp = min(line7a, line8);
			end;
			if mars = 2 and line5b > line2b then do;
				iralimits = 0;
			end;
			if mars = 2 and line5b <= line2b then do;
				line7b = max(min(.2*(line2b - line5b),2000),200);
				line8 = was + max(seern,0) - secaded - sepsimple;
				iralimits = min(line7b, line8);
			end;
			
		end;
	
	end;

	if yr = 2000 then do;
		if (mars = 2 and retplansp = 0 and retplanss = 0) or (mars ne 2 and retplansp = 0) then do;
			line7a = 2000;
			if mars = 2 then line7b = 2000;
			line8 = was + max(seern,0) - secaded - sepsimple;
			iralimitp = max(min(line7a, line8),0);
			if mars = 2 then iralimits = min(line7b, line8);
		end;
		else do;
			if mars = 1 | mars = 4 then line2a = 42000;
			if mars = 5 then line2a = 62000;
			if mars = 2 and retplansp > 0 and retplanss > 0 then do;
				line2a = 62000;
				line2b = 62000;
			end;
			if mars = 2 and retplansp = 0 and retplanss > 0 then do;
				line2a = 160000;
				line2b = 62000;
			end;
			if mars = 2 and retplansp > 0 and retplanss = 0 then do;
				line2a = 62000;
				line2b = 160000;
			end;
			if mars = 3 then line2a = 10000;
			line3 = totinc;
			line4 = ttadj - iracont - studloan;
			line5a = line3 - line4;
			if mars = 2 then line5b = line3 - line4;
			if line5a > line2a then do;
				iralimitp = 0;
			end;
			else do;
				line7a = max(min(.2*(line2a - line5a),2000),200);
				line8 = was + max(seern,0) - secaded - sepsimple;
				iralimitp = min(line7a, line8);
			end;
			if mars = 2 and line5b > line2b then do;
				iralimits = 0;
			end;
			if mars = 2 and line5b <= line2b then do;
				line7b = max(min(.2*(line2b - line5b),2000),200);
				line8 = was + max(seern,0) - secaded - sepsimple;
				iralimits = min(line7b, line8);
			end;
			
		end;
	
	end;	

	if yr = 2001 then do;
		if (mars = 2 and retplansp = 0 and retplanss = 0) or (mars ne 2 and retplansp = 0) then do;
			line7a = 2000;
			if mars = 2 then line7b = 2000;
			line8 = was + max(seern,0) - secaded - sepsimple;
			iralimitp = min(line7a, line8);
			if mars = 2 then iralimits = min(line7b, line8);
		end;
		else do;
			if mars = 1 | mars = 4 then line2a = 43000;
			if mars = 5 then line2a = 63000;
			if mars = 2 and retplansp > 0 and retplanss > 0 then do;
				line2a = 63000;
				line2b = 63000;
			end;
			if mars = 2 and retplansp = 0 and retplanss > 0 then do;
				line2a = 160000;
				line2b = 63000;
			end;
			if mars = 2 and retplansp > 0 and retplanss = 0 then do;
				line2a = 63000;
				line2b = 160000;
			end;
			if mars = 3 then line2a = 10000;
			line3 = totinc;
			line4 = ttadj - iracont - studloan;
			line5a = line3 - line4;
			if mars = 2 then line5b = line3 - line4;
			if line5a > line2a then do;
				iralimitp = 0;
			end;
			else do;
				line7a = max(min(.2*(line2a - line5a),2000),200);
				line8 = was + max(seern,0) - secaded - sepsimple;
				iralimitp = min(line7a, line8);
			end;
			if mars = 2 and line5b > line2b then do;
				iralimits = 0;
			end;
			if mars = 2 and line5b <= line2b then do;
				line7b = max(min(.2*(line2b - line5b),2000),200);
				line8 = was + max(seern,0) - secaded - sepsimple;
				iralimits = min(line7b, line8);
			end;
			
		end;
	
	end;	

	if yr = 2002 then do;
		if (mars = 2 and retplansp = 0 and retplanss = 0) or (mars ne 2 and retplansp = 0) then do;
			line7a = 3000 + 500*(agep >= 50);
			if mars = 2 then line7b = 3000 + 500*(ages >= 50);
			line8 = was + max(seern,0) - secaded - sepsimple;
			iralimitp = min(line7a, line8);
			if mars = 2 then iralimits = min(line7b, line8);
		end;
		else do;
			if mars = 1 | mars = 4 then line2a = 44000;
			if mars = 5 then line2a = 64000;
			if mars = 2 and retplansp > 0 and retplanss > 0 then do;
				line2a = 64000;
				line2b = 64000;
			end;
			if mars = 2 and retplansp = 0 and retplanss > 0 then do;
				line2a = 160000;
				line2b = 64000;
			end;
			if mars = 2 and retplansp > 0 and retplanss = 0 then do;
				line2a = 64000;
				line2b = 160000;
			end;
			if mars = 3 then line2a = 10000;
			line3 = totinc;
			line4 = ttadj - iracont - studloan - tuitfees;
			line5a = line3 - line4;
			if mars = 2 then line5b = line3 - line4;
			if line5a > line2a then do;
				iralimitp = 0;
			end;
			else do;
				line7a = max(min((.3+.05*(agep>=50))*(line2a - line5a),3000+500*(agep>=50)),200);
				line8 = was + max(seern,0) - secaded - sepsimple;
				iralimitp = min(line7a, line8);
			end;
			if mars = 2 and line5b > line2b then do;
				iralimits = 0;
			end;
			if mars = 2 and line5b <= line2b then do;
				line7b = max(min((.3+.05*(ages>=50))*(line2b - line5b),3000+500*(ages>=50)),200);
				line8 = was + max(seern,0) - secaded - sepsimple;
				iralimits = min(line7b, line8);
			end;
			
		end;
	
	end;	


if yr = 2003 then do;
		if (mars = 2 and retplansp = 0 and retplanss = 0) or (mars ne 2 and retplansp = 0) then do;
			line7a = 3000 + 500*(agep >= 50);
			if mars = 2 then line7b = 3000 + 500*(ages >= 50);
			line8 = was + max(seern,0) - secaded - sepsimple;
			iralimitp = min(line7a, line8);
			if mars = 2 then iralimits = min(line7b, line8);
		end;
		else do;
			if mars = 1 | mars = 4 then line2a = 50000;
			if mars = 5 then line2a = 70000;
			if mars = 2 and retplansp > 0 and retplanss > 0 then do;
				line2a = 70000;
				line2b = 70000;
			end;
			if mars = 2 and retplansp = 0 and retplanss > 0 then do;
				line2a = 160000;
				line2b = 70000;
			end;
			if mars = 2 and retplansp > 0 and retplanss = 0 then do;
				line2a = 70000;
				line2b = 160000;
			end;
			if mars = 3 then line2a = 10000;
			line3 = totinc;
			line4 = ttadj - iracont - studloan - tuitfees;
			line5a = line3 - line4;
			if mars = 2 then line5b = line3 - line4;
			if line5a > line2a then do;
				iralimitp = 0;
			end;
			else do;
				line7a = max(min((.3+.05*(agep>=50))*(line2a - line5a),3000+500*(agep>=50)),200);
				line8 = was + max(seern,0) - secaded - sepsimple;
				iralimitp = min(line7a, line8);
			end;
			if mars = 2 and line5b > line2b then do;
				iralimits = 0;
			end;
			if mars = 2 and line5b <= line2b then do;
				line7b = max(min((.3+.05*(ages>=50))*(line2b - line5b),3000+500*(ages>=50)),200);
				line8 = was + max(seern,0) - secaded - sepsimple;
				iralimits = min(line7b, line8);
			end;
			
		end;
	
	end;	


if yr = 2004 then do;
		if (mars = 2 and retplansp = 0 and retplanss = 0) or (mars ne 2 and retplansp = 0) then do;
			line7a = 3000 + 500*(agep >= 50);
			if mars = 2 then line7b = 3000 + 500*(ages >= 50);
			line8 = was + max(seern,0) - secaded - sepsimple;
			iralimitp = min(line7a, line8);
			if mars = 2 then iralimits = min(line7b, line8);
		end;
		else do;
			if mars = 1 | mars = 4 then line2a = 55000;
			if mars = 5 then line2a = 75000;
			if mars = 2 and retplansp > 0 and retplanss > 0 then do;
				line2a = 75000;
				line2b = 75000;
			end;
			if mars = 2 and retplansp = 0 and retplanss > 0 then do;
				line2a = 160000;
				line2b = 75000;
			end;
			if mars = 2 and retplansp > 0 and retplanss = 0 then do;
				line2a = 75000;
				line2b = 160000;
			end;
			if mars = 3 then line2a = 10000;
			line3 = totinc;
			line4 = ttadj - iracont - studloan - tuitfees;
			line5a = line3 - line4;
			if mars = 2 then line5b = line3 - line4;
			if line5a > line2a then do;
				iralimitp = 0;
			end;
			else do;
				line7a = max(min((.3+.05*(agep>=50))*(line2a - line5a),3000+500*(agep>=50)),200);
				line8 = was + max(seern,0) - secaded - sepsimple;
				iralimitp = min(line7a, line8);
			end;
			if mars = 2 and line5b > line2b then do;
				iralimits = 0;
			end;
			if mars = 2 and line5b <= line2b then do;
				line7b = max(min((.3+.05*(ages>=50))*(line2b - line5b),3000+500*(ages>=50)),200);
				line8 = was + max(seern,0) - secaded - sepsimple;
				iralimits = min(line7b, line8);
			end;
			
		end;
	
	end;	



if yr = 2005 then do;
		if (mars = 2 and retplansp = 0 and retplanss = 0) or (mars ne 2 and retplansp = 0) then do;
			line7a = 4000 + 500*(agep >= 50);
			if mars = 2 then line7b = 4000 + 500*(ages >= 50);
			line8 = was + max(seern,0) - secaded - sepsimple;
			iralimitp = min(line7a, line8);
			if mars = 2 then iralimits = min(line7b, line8);
		end;
		else do;
			if mars = 1 | mars = 4 then line2a = 60000;
			if mars = 5 then line2a = 80000;
			if mars = 2 and retplansp > 0 and retplanss > 0 then do;
				line2a = 80000;
				line2b = 80000;
			end;
			if mars = 2 and retplansp = 0 and retplanss > 0 then do;
				line2a = 160000;
				line2b = 80000;
			end;
			if mars = 2 and retplansp > 0 and retplanss = 0 then do;
				line2a = 80000;
				line2b = 160000;
			end;
			if mars = 3 then line2a = 10000;
			line3 = totinc;
			line4 = ttadj - iracont - studloan - tuitfees - domprod;
			line5a = line3 - line4;
			if mars = 2 then line5b = line3 - line4;
			if line5a > line2a then do;
				iralimitp = 0;
			end;
			else do;
				line7a = max(min((.4+.05*(agep>=50))*(line2a - line5a),4000+500*(agep>=50)),200);
				line8 = was + max(seern,0) - secaded - sepsimple;
				iralimitp = min(line7a, line8);
			end;
			if mars = 2 and line5b > line2b then do;
				iralimits = 0;
			end;
			if mars = 2 and line5b <= line2b then do;
				line7b = max(min((.4+.05*(agep>=50))*(line2b - line5b),4000+500*(ages>=50)),200);
				line8 = was + max(seern,0) - secaded - sepsimple;
				iralimits = min(line7b, line8);
			end;
			
		end;
	
	end;	


if yr = 2006 then do;
		if (mars = 2 and retplansp = 0 and retplanss = 0) or (mars ne 2 and retplansp = 0) then do;
			line7a = 4000 + 1000*(agep >= 50);
			if mars = 2 then line7b = 4000 + 1000*(ages >= 50);
			line8 = was + max(seern,0) - secaded - sepsimple;
			iralimitp = min(line7a, line8);
			if mars = 2 then iralimits = min(line7b, line8);
		end;
		else do;
			if mars = 1 | mars = 4 then line2a = 60000;
			if mars = 5 then line2a = 85000;
			if mars = 2 and retplansp > 0 and retplanss > 0 then do;
				line2a = 85000;
				line2b = 85000;
			end;
			if mars = 2 and retplansp = 0 and retplanss > 0 then do;
				line2a = 160000;
				line2b = 85000;
			end;
			if mars = 2 and retplansp > 0 and retplanss = 0 then do;
				line2a = 85000;
				line2b = 160000;
			end;
			if mars = 3 then line2a = 10000;
			line3 = totinc;
			line4 = ttadj - iracont - studloan - tuitfees - domprod;
			line5a = line3 - line4;
			if mars = 2 then line5b = line3 - line4;
			if line5a > line2a then do;
				iralimitp = 0;
			end;
			else do;
				line7a = max(min((.4+.10*(agep>=50))*(line2a - line5a),4000+1000*(agep>=50)),200);
				line8 = was + max(seern,0) - secaded - sepsimple;
				iralimitp = min(line7a, line8);
			end;
			if mars = 2 and line5b > line2b then do;
				iralimits = 0;
			end;
			if mars = 2 and line5b <= line2b then do;
				line7b = max(min((.4+.10*(agep>=50))*(line2b - line5b),4000+1000*(ages>=50)),200);
				line8 = was + max(seern,0) - secaded - sepsimple;
				iralimits = min(line7b, line8);
			end;
			
		end;
	
	end;	


	if yr = 2007 then do;
		if (mars = 2 and retplansp = 0 and retplanss = 0) or (mars ne 2 and retplansp = 0) then do;
			line7a = 4000 + 1000*(agep >= 50);
			if mars = 2 then line7b = 4000 + 1000*(ages >= 50);
			line8 = was + max(seern,0) - secaded - sepsimple;
			iralimitp = min(line7a, line8);
			if mars = 2 then iralimits = min(line7b, line8);
		end;
		else do;
			if mars = 1 | mars = 4 then line2a = 60000;
			if mars = 5 then line2a = 85000;
			if mars = 2 and retplansp > 0 and retplanss > 0 then do;
				line2a = 85000;
				line2b = 85000;
			end;
			if mars = 2 and retplansp = 0 and retplanss > 0 then do;
				line2a = 160000;
				line2b = 85000;
			end;
			if mars = 2 and retplansp > 0 and retplanss = 0 then do;
				line2a = 85000;
				line2b = 160000;
			end;
			if mars = 3 then line2a = 10000;
			line3 = totinc;
			line4 = ttadj - iracont - studloan - tuitfees - domprod;
			line5a = line3 - line4;
			if mars = 2 then line5b = line3 - line4;
			if line5a > line2a then do;
				iralimitp = 0;
			end;
			else do;
				line7a = max(min((.4+.10*(agep>=50))*(line2a - line5a),4000+1000*(agep>=50)),200);
				line8 = was + max(seern,0) - secaded - sepsimple;
				iralimitp = min(line7a, line8);
			end;
			if mars = 2 and line5b > line2b then do;
				iralimits = 0;
			end;
			if mars = 2 and line5b <= line2b then do;
				line7b = max(min((.4+.10*(agep>=50))*(line2b - line5b),4000+1000*(ages>=50)),200);
				line8 = was + max(seern,0) - secaded - sepsimple;
				iralimits = min(line7b, line8);
			end;
			
		end;
	
	end;




if yr = 2008 then do;
		if (mars = 2 and retplansp = 0 and retplanss = 0) or (mars ne 2 and retplansp = 0) then do;
			line7a = 5000 + 1000*(agep >= 50);
			if mars = 2 then line7b = 5000 + 1000*(ages >= 50);
			line8 = was + max(seern,0) - secaded - sepsimple;
			iralimitp = min(line7a, line8);
			if mars = 2 then iralimits = min(line7b, line8);
		end;
		else do;
			if mars = 1 | mars = 4 then line2a = 60000;
			if mars = 5 then line2a = 85000;
			if mars = 2 and retplansp > 0 and retplanss > 0 then do;
				line2a = 85000;
				line2b = 85000;
			end;
			if mars = 2 and retplansp = 0 and retplanss > 0 then do;
				line2a = 160000;
				line2b = 85000;
			end;
			if mars = 2 and retplansp > 0 and retplanss = 0 then do;
				line2a = 85000;
				line2b = 160000;
			end;
			if mars = 3 then line2a = 10000;
			line3 = totinc;
			line4 = ttadj - iracont - studloan - tuitfees - domprod;
			line5a = line3 - line4;
			if mars = 2 then line5b = line3 - line4;
			if line5a > line2a then do;
				iralimitp = 0;
			end;
			else do;
				line7a = max(min((.4+.10*(agep>=50))*(line2a - line5a),5000+1000*(agep>=50)),200);
				line8 = was + max(seern,0) - secaded - sepsimple;
				iralimitp = min(line7a, line8);
			end;
			if mars = 2 and line5b > line2b then do;
				iralimits = 0;
			end;
			if mars = 2 and line5b <= line2b then do;
				line7b = max(min((.4+.10*(agep>=50))*(line2b - line5b),5000+1000*(ages>=50)),200);
				line8 = was + max(seern,0) - secaded - sepsimple;
				iralimits = min(line7b, line8);
			end;
			
		end;
	
	end;


	if yr = 2009 then do;
		if (mars = 2 and retplansp = 0 and retplanss = 0) or (mars ne 2 and retplansp = 0) then do;
			line7a = 5000 + 1000*(agep >= 50);
			if mars = 2 then line7b = 5000 + 1000*(ages >= 50);
			line8 = was + max(seern,0) - secaded - sepsimple;
			iralimitp = min(line7a, line8);
			if mars = 2 then iralimits = min(line7b, line8);
		end;
		else do;
			if mars = 1 | mars = 4 then line2a = 60000;
			if mars = 5 then line2a = 85000;
			if mars = 2 and retplansp > 0 and retplanss > 0 then do;
				line2a = 85000;
				line2b = 85000;
			end;
			if mars = 2 and retplansp = 0 and retplanss > 0 then do;
				line2a = 160000;
				line2b = 85000;
			end;
			if mars = 2 and retplansp > 0 and retplanss = 0 then do;
				line2a = 85000;
				line2b = 160000;
			end;
			if mars = 3 then line2a = 10000;
			line3 = totinc;
			line4 = ttadj - iracont - studloan - tuitfees - domprod;
			line5a = line3 - line4;
			if mars = 2 then line5b = line3 - line4;
			if line5a > line2a then do;
				iralimitp = 0;
			end;
			else do;
				line7a = max(min((.4+.10*(agep>=50))*(line2a - line5a),5000+1000*(agep>=50)),200);
				line8 = was + max(seern,0) - secaded - sepsimple;
				iralimitp = min(line7a, line8);
			end;
			if mars = 2 and line5b > line2b then do;
				iralimits = 0;
			end;
			if mars = 2 and line5b <= line2b then do;
				line7b = max(min((.4+.10*(agep>=50))*(line2b - line5b),5000+1000*(ages>=50)),200);
				line8 = was + max(seern,0) - secaded - sepsimple;
				iralimits = min(line7b, line8);
			end;
			
		end;
	
	end;


	/* Constrain iralimit to be non-negative and non-missing */
	if iralimitp = . then iralimitp = 0 ;
	iralimitp = max(iralimitp,0);
	if iralimits = . then iralimits = 0 ;
	iralimits = max(iralimits,0);

	/* If iralimit is not a multiple of 10, increase to next highest multiple */
	if mod(iralimitp,10) ne 0 then iralimitp = ceil(iralimitp/10) * 10;
	if mod(iralimits,10) ne 0 then iralimits = ceil(iralimits/10) * 10;



	/* Clean individual IRA data to be consistent with amounts on 1040 */
	if iracontp = . then iracontp = 0;
	if iraconts = . then iraconts = 0;

	iracontp_original = iracontp;
	iraconts_original = iraconts;

	/* If not filing jointly, set iracontp to the amount on the tax form */
	if mars ne 2 then iracontp = iracont;

	/* If married filing jointly, use algorithm to clean contributions */
	if mars = 2 then do;

		/* If sum of individual contributions is greater than total, cut both contributions 
			down to imputed limits */

		if iracontp + iraconts > iracont then do;
			iracontp = min(iracontp, iralimitp);
			iraconts = min(iraconts, iralimits);
		end;

		/* If sum of individual contributions is greater than total, cut both contributions
		proportionally until equal with total */

		if iracontp + iraconts > iracont then do;
			iracontp = iracontp*iracont/(iracontp + iraconts);
			iraconts = iracont - iracontp;
		end;

		/* If sum of individual contributions is zero, but actual contributions are positive, 
		assume that person with higher limit contributed up to the limit, and balance was contributed by other person*/
		if iracontp = 0 and iraconts = 0 and iracont > 0 and (iralimitp > 0 or iralimits > 0) and iralimitp ge iralimits then do;
			iracontp = min(iracont, iralimitp);
			iraconts = min(iracont - iracontp, iralimits);

		end;
		if iracontp = 0 and iraconts = 0 and iracont > 0 and (iralimitp > 0 or iralimits > 0) and iralimitp < iralimits then do;
			iraconts = min(iracont, iralimits);
			iracontp = min(iracont - iraconts, iralimits);

		end;

			
		/* If both limits were zero, divide in half */
		if iracontp = 0 and iraconts = 0 and iracont > 0 and iralimitp = 0 and iralimits = 0 then do;
				iracontp=0.5*iracont ;
				iraconts=0.5*iracont ;
		end;

		/* At this point, individual contributions are either equal to total or less than total, and 
		all observations for which iracont > 0  have either iracontp > 0 or iraconts > 0 */

		/*If sum of individual contributions are less than total contributions, scale up individual amounts
		to equal total */
		if iracontp + iraconts < iracont then do;
			iracontp = iracontp*iracont/(iracontp + iraconts);
			iraconts = iracont - iracontp;
		end;

		/* Round the result */
		iracontp = round(iracontp);
		iraconts = round(iraconts);

		/* If one spouse is above limit and other is below, reallocate contributions to spouse that is below */
		if iracontp > iralimitp and iraconts < iralimits then do;
			excessp = iracontp - iralimitp;
			shortfalls = iralimits - iraconts;
			iracontp = iracontp - min(excessp, shortfalls);
			iraconts = iraconts + min(excessp, shortfalls);
		end;

		if iracontp < iralimitp and iraconts > iralimits then do;
			excesss = iraconts - iralimits;
			shortfallp = iralimitp - iracontp;
			iracontp = iracontp + min(excesss, shortfallp);
			iraconts = iraconts - min(excesss, shortfallp);
		end;

	end;


	/* Allocate self-employed SEP and simple contributions on 1040 to primary and secondary
	   This is done only using information on self-employment income, because a similar allocation
	   must be done in the family panel (which we don't have 5498 information for)*/
	sepsimplep = 0;
	sepsimples = 0;

	if sepsimple > 0 then do;
		/* If not filing jointly, allocate to primary */
		if mars ne 2 then sepsimplep = sepsimple;

		/* If filing jointly and only one person is self-employed, allocate to that person */
		if mars = 2 and seernp ne 0 and seerns = 0 then sepsimplep = sepsimple;
		if mars = 2 and seerns ne 0 and seernp = 0 then sepsimples = sepsimple;

		/* If filing jointly and both report self-employment income, allocate according to shares */
		if mars = 2 and seernp ne 0 and seerns ne 0 then do;
			sepsimplep = sepsimple*max(0,seernp)/(max(0,seernp) + max(0,seerns));
			sepsimples = sepsimple*max(0,seerns)/(max(0,seernp) + max(0,seerns));
		end;

		/* If filing jointly and neither report self-employment income, split in half */
		if mars = 2 and seernp = 0 and seerns = 0 then do;
			sepsimplep = .5*sepsimple;
			sepsimples = .5*sepsimple;
		end;

	end;

	/* Round the result */
	sepsimplep = round(sepsimplep);
	sepsimples = round(sepsimples);

	sepsimpledif = sepsimple - sepsimplep - sepsimples;

	/* Program Roth contribution limits */
	rothlimitp = 0;
	rothlimits = 0;
	limit1 = 0;
	limit2 = 0;


	* need to ensures contsep and contsimple variables are not missing;
	if contsepp = . then contsepp = 0;
	if contseps = . then contseps = 0;
	if contsimplep = . then contsimplep = 0;
	if contsimples = . then contsimples = 0;

	/* Roth limits */
	maxlimitp = 2000 + 1000*(yr ge 2002) + 1000*(yr ge 2005) + 500*(agep ge 50 and yr ge 2002) + 500*(agep ge 50 and yr ge 2006);
	maxlimits = 2000 + 1000*(yr ge 2002) + 1000*(yr ge 2005) + 500*(ages ge 50 and yr ge 2002) + 500*(ages ge 50 and yr ge 2006);

	if iracontp = 0 then rothlimitp = maxlimitp;
	if iraconts = 0 then rothlimits = maxlimits;

	if iracontp > 0 then do;
		limit1 = maxlimitp - iracontp - sepsimplep - contsepp - contsimplep;
		limit2 = maxlimitp - maxlimitp*(agix + iracont + studloan + tuitfees
					- 150000*(mars = 2) - 95000*(mars = 1 or mars > 3)) / (10000 + 5000*(mars = 2 or mars = 3));
	
		rothlimitp = max(min(limit1, limit2),0);
	end;
	if iraconts > 0 then do;
		limit1 = maxlimits - iraconts - sepsimples - contseps - contsimples;
		limit2 = maxlimits - maxlimits*(agix + iracont + studloan + tuitfees
			- 150000*(mars = 2) - 95000*(mars = 1 or mars > 3)) / (10000 + 5000*(mars = 2 or mars = 3));
	
		rothlimits = max(min(limit1, limit2),0);
	end;

	/* If rothlimit is not a multiple of 10, increase to next highest multiple */
	if mod(rothlimitp,10) ne 0 then rothlimitp = ceil(rothlimitp/10) * 10;
	if mod(rothlimits,10) ne 0 then rothlimits = ceil(rothlimits/10) * 10;


	/* Clean Roth contribution data */
	if rothcontp = . then rothcontp = 0;
	if rothconts = . then rothconts = 0;

	rothcontp = min(rothcontp, rothlimitp);
	rothconts = min(rothconts, rothlimits);
	rothcont = rothcontp + rothconts;

RUN;

proc sort;
	by yr;
run;

proc means;
	by yr;
run;

/* Set missing contribution amounts to zero since W-2's present for all obs, and 
drop unneeded variables used to calculated ira limits */

DATA SUBSUB.INSOLE97_09 (COMPRESS=YES);
	SET INSOLE97_09;

	if cont401kp = . then cont401kp = 0;
	if cont403bp = . then cont403bp = 0;   
	if contsepp = . then contsepp = 0;
	if cont457bp = . then cont457bp = 0;
	if cont501cp  = . then cont501cp = 0;
	if contsimplep = . then contsimplep = 0; 
	if contSEsepp = . then contSEsepp = 0;
	if contSEsimplep = . then contSEsimplep = 0;
	if retplansp = . then retplansp = 0;
	if dcplansp  = . then dcplansp = 0;
	if empatdcempp  = . then empatdcempp = 0;
	if conttotp   = . then conttotp = 0;

	if cont401ks  = . then cont401ks = 0;
	if cont403bs  = . then cont403bs = 0; 
	if contseps   = . then contseps = 0;	
	if cont457bs = . then cont457bs = 0;
	if cont501cs   = . then cont501cs = 0;   
	if contsimples = . then contsimples = 0;
	if contSEseps = . then contSEseps = 0;
	if contSEsimples = . then contSEsimples = 0;  
	if retplanss    = . then retplanss = 0; 
	if dcplanss  = . then dcplanss = 0;
	if empatdcemps  = . then empatdcemps = 0;  
	if conttots  = . then conttots = 0;

	drop conttotp_original conttots_original line7a  line7b   line8 line2a    line2b   line3    line4  line5a   line5b;


	/* Rename contribution variables to more intuitive names */
	empcontp = conttotp;
	empconts = conttots;
	empcont = conttotp + conttots;
	SEcont = sepsimple;
	SEcontp = sepsimplep;
	SEconts = sepsimples;
	allcontp = empcontp + iracontp + SEcontp;
	allconts = empconts + iraconts + SEconts;
	allcont = empcont + iracont + SEcont;

	drop sepsimple sepsimplep sepsimples conttotp conttots conttot;




RUN;

proc sort data=SUBSUB.INSOLE97_09;
	by yr;
run;

PROC MEANS DATA=SUBSUB.INSOLE97_09;
	by yr;
RUN;

/* Summarize dataset */
PROC MEANS DATA=SUBSUB.INSOLE97_09;

RUN;

PROC SORT;
	BY fileyr;
RUN;

PROC MEANS;
	VAR limitp cont457bp cont401kp cont403bp contsepp cont501cp contsimplep;
	BY fileyr;
RUN;


