/*OPTIONS NOCENTER LS=155 PS=60 COMPRESS=YES NOFMTERR;*/
/***********************************************************************/
/*  Program:  INSOLE97_09full1.SAS                                   */
/*     Date:  2006 April 28                                            */
/*  Purpose:  Subset data from the 1997-09 INSOLES                     */
/*    Notes:  This program reads in data from the 1997-2009 insoles    */
/*            and merges in demographic information                     */
/*  PrevPgm:  none                                                     */
/***********************************************************************/
LIBNAME     SUBG    "G:\EM&CA\DATA\Individual";
LIBNAME     SUB2    "G:\REV_EST\DeBacker\Panel8706";
LIBNAME     SUBSUB  "G:\REV_EST\DeBacker\Panel8706\LaborInc";

    
/* 1997 INSOLE */


/* Read DM1 data, a dataset with date of birth and gender information, and create variables for merging
	into insole */
DATA INSOLE97DM1 (index=(retid));
    SET SUB2.DM1X97(KEEP=
	S001
	DM1_MATCH 
	DM1P_DOB DM1S_DOB
	DM1P_GENDER DM1S_GENDER

	RENAME=(
	DM1P_DOB = PDOB
	DM1S_DOB = SDOB

	)
	);

	RETID = S001;

	PGENDER = .;
	IF DM1P_GENDER = 'F' THEN PGENDER = 2;
	IF DM1P_GENDER = 'M' THEN PGENDER = 1;
	SGENDER = .;
	IF DM1S_GENDER = 'F' THEN SGENDER = 2;
	IF DM1S_GENDER = 'M' THEN SGENDER = 1;


	DOBYR = FLOOR(PDOB/10000);
	SDOBYR = FLOOR(SDOB/10000);

	KEEP DM1_MATCH RETID PGENDER SGENDER DOBYR SDOBYR;
RUN;

/* Read in insole data */
PROC CONTENTS DATA=SUBG.INSOLE97;
RUN;

DATA SUBSUB.INSOLE97SUBSET (COMPRESS=YES);
    SET SUBG.INSOLE97(KEEP=
	
	S001 MARS FLPDYR REJECT
	STATE XOCAH  XOCAWH
	S002 S003	S006
	MARS
	XTOT	STATE	DSI	
	AGEP	AGES		
	PBI 	SBI
	DOBYR
	CWHSI
	E00100
	E00200	E02650	E03280	E03270	E04470
	E04800	E17500	E17000	E18300	E18400
	E18500	E18800	E18900	E19200	E03260
	E09400	E02000	E19300	E19530 	E19700
	E19800	E20100	E20400	E20550	E20800
	E20900	E21000	E21020	E21050	E21060
	E21040	E21100	E29375	E29400	E29450
	E33420	E62100	E63000	E10300	E02400
	E02500	E01100	E25960	E25980	E25920
	E25940	E26160	E26170	E26180	E26190
	N6
	EICYB1 	EICYB2 	E29100
	E29120	E29070	E00900	E29020	E29050
	E29000	E02100	E22250	E23250	E01000
	E01200	E00600	E00300	E00400	E01700
	E26500	E00700	E00800	E01400
	E02300	E02600	E02900	E19570
	E20500	E32700	E07100	E07180
	E07200	E68000	E04600	E04100	E04200
	E04450	
	E03600
	E04500 E04800 E05100 E05800 E05700 E08795
	E09600 E01800 E01500 E01300 
	E11000 E07400 E61850
	E20200
	E53220 E07300 E53240 E08000
	E09200 E08795
	E05200
	E62600 E62700 E62800 
	E25870 
	
	E60300 E60290 E60340 E60500 
	E60550 E60680 E60720 E60840 
	E61450 E60100 E62000 E60860 
	 E60600 E60405 
	E60440 E60420 E60410 E60480 
	E61400 E60660 
	E03150  E03300 E03400 

	/* Sole prop variables */
	INDYC INDYC1 INDYC2 INDYC3 DOMC SEXPRC SXPRC1 SXPRC2 SXPRC3	
	E90020 E91020 E92020 E93020
	E90440 E91440 E92440 E93440
	E90350 E91350 E92350 E93350
	E90370 E90100

	E90470 E90200 E90290 E90190 E90445 E90570 E90550 

	/* Capital gain variables */
	E22320 LTSOCA
	E21775 E22365

	/* Depreciation Variables */
	E54010 E54015 E54100 E57800 E57900 E58020 E58040 E58100 E58120 E58140 E58060 E58200 E58250 E58300

	E03500

	/****** Convert names to Family panel names ***/
	RENAME=(
	S001	= 	RETIDCHAR
	s002	=	issnp
	s003	=	issns
	DOBYR	=	PDOB
	MARS	=	MARSCHAR
	CWHSI	=	CWHSICHAR
	FLPDYR	=	TAXYRCHAR
	REJECT	=	REJECT
	STATE	=	STATECHAR
	XTOT	=	IEXEMH 
	DSI		=	IFDEPT 
	S006	=	WGT
	AGEP	=	I65INDP 
	AGES	=	I65INDS 
	XOCAH	=	CAHECHAR
	XOCAWH	=	CAFHECHAR

	E00100	=	AGIX 
	E00200	=	WAS 
	E02650	=	TOTINCX 
	E03280	=	EXMOVE_AJ  
	E03270	=	HEALSE
	E04470	=	TIDX 
	E17500	=	TTMED 
	E17000	=	DEDMED 
	E18300	=	TTSLTX 
	E18400	=	SLITX 
	E18500	=	RETX 
	E18800	=	PPTX
	E18900	=	OTSLTX
	E19200	=	TTI_DED
	E03260	=	SECADED 
	E09400	=	SECATX
	E19300	=	HMIE 
	E19530 	=	POINTS
	E19700	=	TTCON 
	E19800	=	TCASH 
	E20100	=	TNCASH 
	E20400	=	T2MISC 
	E20550	=	EBE 
	E20800	=	DEDMIS 
	E20900	=	FDGAMB 
	E21000	=	FDOTHD 
	E21020	=	FDMISC 
	E21050	=	TOTMIS 
	E21060	=	GR_TID 
	E21040	=	DISIDX 
	E21100	=	SAVBOND
	E29375	=	WAS_OAS 
	E29400	=	WASP_OAS 
	E29450	=	WASS_OAS
	E33420	=	EMPLCC 
	E62100	=	AMTIX 
	E63000	=	TAMTX 
	E10300	=	TOT_LIAB
	E02500	=	SSAGIX 
	E01100	=	CGD40
	E25960	=	APARTL 
	E25980	=	APARTG
	E25920	=	PPARTL
	E25940	=	PPARTG
	E26160	=	PSBCL
	E26170	=	PSBCG
	E26180	=	ASBCL
	E26190	=	ASBCG
	N6		=	DEPNE 
	E29100	=	SENONFP 
	E29120	=	SENONFS 
	E29070	=	SENONF 
	E00900	=	BIL 
	E29020	=	SEFARMP 
	E29050	=	SEFARMS 
	E29000	=	SEFARM 
	E02100	=	FIL
	E22250	=	NSTGL 
	E23250	=	NLTGL 
	E01000	=	CGAGIX 
	E01200	=	SUPPGL 
	E00600	=	DBE 
	E00300	=	INTST 
	E00400	=	TEXINT
	E01700	=	PTPEN
	E02000	=	SCHE 
	E26500	=	ESTU 
	E00700	=	SITR 
	E00800	=	ALIMONY 
	E01400	=	TIRAD 
	E02300	=	UCAGIX 
	E02400	=	SSINC
	E02600	=	OTHINC
	E02900	=	TTADJ 
	E19570	=	IIE
	E20500	=	TTCASU 
	E32700	=	CCECYR 
	E07100	=	TTCRX 
	E07180	=	CCCX 
	E07200	=	ELDCRX
	E68000	=	Z17
	E04600	=	EXEMX 
	E04100	=	BSD 
	E04200	=	SDADD 
	E04450	=	SDX 
	/*E03220 	= 	EDUCEXP
	E03230	=	TUITFEES*/
	E03600	=	MSA
	E61850 	= 	TTPREF
	E62600  =  	AMTEXEMPTX
	E62700	=	AMTIAEX
	E62800	=	AMTIAEEXCGX
	E03150  =   IRACONT
	E03300  = 	SEPSIMPLE
	E03400	=	EARLYWD
	E01300	=	GRIRAD
	E01500 	=	GRPEN
	E11000	=	EICX

	E90020 	=  SOLEGRRECEIPTC
	E91020 	=  SOLEGRRECEIPT1
	E92020	=  SOLEGRRECEIPT2
	E93020   =  SOLEGRRECEIPT3	

	E90440 	=  SOLENETINCC
	E91440 	=  SOLENETINC1
	E92440	=  SOLENETINC2
	E93440   =  SOLENETINC3

	E90370	=	SOLEWAGESC
	E90100	=	SOLEEXPC

	E90470  =   SOLELABORCOGSC
	E90200  =   SOLEEMPBENC
	E90290  =   SOLEPENPROFITC
	E90190  =   SOLEDEPRC
	E90445  =   SOLEDEPR8829C
	E90570  =   SOLEDEPRCOGSC
	E90550  =   SOLEPAYROLLCOGSC



	E03500 = ALIP
	) 

	);

	/* Keep non-rejected returns */
	if REJECT=0;

	/* Convert possibly char variables to numbers */
	RETID = RETIDCHAR*1;
	CWHSI = CWHSICHAR*1;
	TAXYR = TAXYRCHAR*1;
	MARS = MARSCHAR*1;
	ISTATE = STATECHAR*1;
	CAHE = CAHECHAR*1;
	CAFHE = CAFHECHAR*1;
	DROP RETIDCHAR CWHSICHAR TAXYRCHAR MARSCHAR STATECHAR CAHECHAR CAFHECHAR;

	/* Create variables not in 1997 Insole */
	EDUCEXP = 0;
	TUITFEES = 0;
	E18425 = 0;
	E18450 = 0;
	E60630 = 0;
	E60430 = 0;
	N24 = 0;
	E00650 = 0;
	E05750 = 0;
	CDOB1 = 0;
	CDOB2 = 0;
	DOMPROD = 0;
	STUDLOAN = 0;
	SAVCRED = 0;
	ACTCX = 0;

	fileyr = 1997;

	/* Create ID for matching with marginal tax rates */
	id = issnp;

	/* Generate indicator for being sampled with probability 1 */
	HIINC = (WGT = 1);

	/* Calculate passive and active net partnership, SBC, and Scorp income */
	PARTPAS = PPARTG - PPARTL ; *E25940 - E25920;
	PARTACT = APARTG - APARTL ; *E25980 - E25960;
	PART = PARTPAS + PARTACT;
	SBC = 0;
	SCORPPAS = PSBCG - PSBCL ; *E26170 - E26160;
	SCORPACT = ASBCG - ASBCL ; *E26190 - E26180;
	SCORP = SCORPPAS + SCORPACT;
	

	/* Subtract off nondeductible meals and entertainment to make 
	   consistent with pre-TRA86 law (when total was deductible) */

    NDMEALENTC = E90350;
	NDMEALENT1 = E91350;
	NDMEALENT2 = E92350;
	NDMEALENT3 = E93350;

	SOLENETINCC = SOLENETINCC - NDMEALENTC;
	SOLENETINC1 = SOLENETINC1 - NDMEALENT1;
	SOLENETINC2 = SOLENETINC2 - NDMEALENT2;
	SOLENETINC3 = SOLENETINC3 - NDMEALENT3;

	DROP E90350 E91350 E92350 E93350;

	/* Sole prop gain (plus gains from other forms) */
	SOLEGAINPLUS = E22320;
	DROP E22320;
	IF LTSOCA = 0 THEN SOLEGAIN = SOLEGAINPLUS;

	/* Partnership and scorp gain */
	PARTSCORPGAIN = E21775 + E22365;
	DROP E21775 E22365;

	/* Calculate adjusted total income */
	ptpexc = max(grpen - ptpen, 0);
	iraexc = max(grirad - tirad, 0);
	ssexc = max(ssinc - ssagix, 0);

	ADJTOTINC = totincx + texint + iraexc + ptpexc + ssexc;



	/* Merge in DOB and gender information */
	set INSOLE97DM1 key = RETID /unique ;

	RUN;


/* 1998 INSOLE */

/* Read DM1 data, a dataset with date of birth and gender information, and create variables for merging
	into insole */
DATA INSOLE98DM1 (index=(retid));
    SET SUB2.DM1X98(KEEP=
	S001
	DM1_MATCH 
	DM1P_DOB DM1S_DOB
	DM1P_GENDER DM1S_GENDER

	RENAME=(
	DM1P_DOB = PDOB
	DM1S_DOB = SDOB

	)
	);

	RETID = S001;

	PGENDER = .;
	IF DM1P_GENDER = 'F' THEN PGENDER = 2;
	IF DM1P_GENDER = 'M' THEN PGENDER = 1;
	SGENDER = .;
	IF DM1S_GENDER = 'F' THEN SGENDER = 2;
	IF DM1S_GENDER = 'M' THEN SGENDER = 1;


	DOBYR = FLOOR(PDOB/10000);
	SDOBYR = FLOOR(SDOB/10000);

	KEEP DM1_MATCH RETID PGENDER SGENDER DOBYR SDOBYR;
RUN;


/* Read in insole data */
PROC CONTENTS DATA=SUBG.INSOLE98;
RUN;

DATA SUBSUB.INSOLE98SUBSET (COMPRESS=YES);
    SET SUBG.INSOLE98(KEEP=
	
	S001 MARS FLPDYR REJECT
	STATE XOCAH  XOCAWH
	S002 S003	S006
	MARS
	XTOT	STATE	DSI	
	AGEP	AGES	
	PBI 	SBI
	DOBYR
	CWHSI
	E00100
	E00200	E02650	E03280	E03270	E04470
	E04800	E17500	E17000	E18300	E18400
	E18500	E18800	E18900	E19200	E03260
	E09400	E02000	E19300	E19530 	E19700
	E19800	E20100	E20400	E20550	E20800
	E20900	E21000	E21020	E21050	E21060
	E21040	E21100	E29375	E29400	E29450
	E33420	E62100	E63000	E10300	E02400
	E02500	E01100	E25960	E25980	E25920
	E25940	E26160	E26170	E26180	E26190
	N6
	EICYB1 	EICYB2 	E29100
	E29120	E29070	E00900	E29020	E29050
	E29000	E02100	E22250	E23250	E01000
	E01200	E00600	E00300	E00400	E01700
	E26500	E00700	E00800	E01400
	E02300	E02600	E02900	E19570
	E20500	E32700	E07100	E07180
	E07200	E68000	E04600	E04100	E04200
	E04450	
	E03600
	E04500 E04800 E05100 E05800 E05700 E08795
	E09600 E01800 E01500 E01300 
	E11000 E07400 E61850
	E20200
	E53220 E07300 E53240 E08000
	E09200 E08795
	E05200
	E62600 E62700 E62800 
	E25870 
	
	E60300 E60290 E60340 E60500 
	E60550 E60680 E60720 E60840 
	E61450 E60100 E62000 E60860 
	 E60600 E60405 
	E60440 E60420 E60410 E60480 
	E61400 E60660 

	E60630 
	E60430 
	N24 
	E03150  E03300 E03400	
	E03210 
	E11070


	/* Sole prop variables */
	INDYC INDYC1 INDYC2 INDYC3 DOMC SEXPRC SXPRC1 SXPRC2 SXPRC3	
	E90020 E91020 E92020 E93020
	E90440 E91440 E92440 E93440
	E90350 E91350 E92350 E93350
	E90370 E90100

	E90470 E90200 E90290 E90190 E90445 E90570 E90550 

	/* Capital gain variables */
	E22320 E40240 E40220 
	E21775 E22365 

	/* Depreciation Variables */
	E54010 E54015 E54100 E57800 E57900 E58020 E58040 E58100 E58120 E58140 E58060 E58200 E58250 E58300

	E03500 

	/****** Convert names to Family panel names ***/
	RENAME=(
	S001	= 	RETIDCHAR
	s002	=	issnp
	s003	=	issns
	DOBYR	=	PDOB
	MARS	=	MARSCHAR
	CWHSI	=	CWHSICHAR
	FLPDYR	=	TAXYRCHAR
	REJECT	=	REJECT
	STATE	=	STATECHAR
	XTOT	=	IEXEMH 
	DSI		=	IFDEPT 
	S006	=	WGT
	AGEP	=	I65INDP 
	AGES	=	I65INDS 
	XOCAH	=	CAHECHAR
	XOCAWH	=	CAFHECHAR

	E00100	=	AGIX 
	E00200	=	WAS 
	E02650	=	TOTINCX 
	E03280	=	EXMOVE_AJ  
	E03270	=	HEALSE
	E04470	=	TIDX 
	E17500	=	TTMED 
	E17000	=	DEDMED 
	E18300	=	TTSLTX 
	E18400	=	SLITX 
	E18500	=	RETX 
	E18800	=	PPTX
	E18900	=	OTSLTX
	E19200	=	TTI_DED
	E03260	=	SECADED 
	E09400	=	SECATX
	E19300	=	HMIE 
	E19530 	=	POINTS
	E19700	=	TTCON 
	E19800	=	TCASH 
	E20100	=	TNCASH 
	E20400	=	T2MISC 
	E20550	=	EBE 
	E20800	=	DEDMIS 
	E20900	=	FDGAMB 
	E21000	=	FDOTHD 
	E21020	=	FDMISC 
	E21050	=	TOTMIS 
	E21060	=	GR_TID 
	E21040	=	DISIDX 
	E21100	=	SAVBOND
	E29375	=	WAS_OAS 
	E29400	=	WASP_OAS 
	E29450	=	WASS_OAS
	E33420	=	EMPLCC 
	E62100	=	AMTIX 
	E63000	=	TAMTX 
	E10300	=	TOT_LIAB
	E02500	=	SSAGIX 
	E01100	=	CGD40
	E25960	=	APARTL 
	E25980	=	APARTG
	E25920	=	PPARTL
	E25940	=	PPARTG
	E26160	=	PSBCL
	E26170	=	PSBCG
	E26180	=	ASBCL
	E26190	=	ASBCG
	N6		=	DEPNE 
	E29100	=	SENONFP 
	E29120	=	SENONFS 
	E29070	=	SENONF 
	E00900	=	BIL 
	E29020	=	SEFARMP 
	E29050	=	SEFARMS 
	E29000	=	SEFARM 
	E02100	=	FIL
	E22250	=	NSTGL 
	E23250	=	NLTGL 
	E01000	=	CGAGIX 
	E01200	=	SUPPGL 
	E00600	=	DBE 
	E00300	=	INTST 
	E00400	=	TEXINT
	E01700	=	PTPEN
	E02000	=	SCHE 
	E26500	=	ESTU 
	E00700	=	SITR 
	E00800	=	ALIMONY 
	E01400	=	TIRAD 
	E02300	=	UCAGIX 
	E02400	=	SSINC
	E02600	=	OTHINC
	E02900	=	TTADJ 
	E19570	=	IIE
	E20500	=	TTCASU 
	E32700	=	CCECYR 
	E07100	=	TTCRX 
	E07180	=	CCCX 
	E07200	=	ELDCRX
	E68000	=	Z17
	E04600	=	EXEMX 
	E04100	=	BSD 
	E04200	=	SDADD 
	E04450	=	SDX 
	/*E03220 	= 	EDUCEXP
	E03230	=	TUITFEES*/
	E03600	=	MSA
	E61850 	= 	TTPREF
	E62600  =  	AMTEXEMPTX
	E62700	=	AMTIAEX
	E62800	=	AMTIAEEXCGX
	E03150  =   IRACONT
	E03300  = 	SEPSIMPLE
	E03400 	=	EARLYWD
	E03210  =   STUDLOAN
	E01300	=	GRIRAD
	E01500 	=	GRPEN
	E11000	=	EICX
	E11070	=	ACTCX

	E90020 	=  SOLEGRRECEIPTC
	E91020 	=  SOLEGRRECEIPT1
	E92020	=  SOLEGRRECEIPT2
	E93020   =  SOLEGRRECEIPT3	

	E90440 	=  SOLENETINCC
	E91440 	=  SOLENETINC1
	E92440	=  SOLENETINC2
	E93440   =  SOLENETINC3

	E90370	=	SOLEWAGESC
	E90100	=	SOLEEXPC

	E90470  =   SOLELABORCOGSC
	E90200  =   SOLEEMPBENC
	E90290  =   SOLEPENPROFITC
	E90190  =   SOLEDEPRC
	E90445  =   SOLEDEPR8829C
	E90570  =   SOLEDEPRCOGSC
	E90550  =   SOLEPAYROLLCOGSC


	E03500 = ALIP
	) 

	);

	/* Keep non-rejected returns */
	if REJECT=0;

	/* Generate indicator for being sampled with probability 1 */
	HIINC = (WGT = 1);


	/* Convert possibly char variables to numbers */
	RETID = RETIDCHAR*1;
	CWHSI = CWHSICHAR*1;
	TAXYR = TAXYRCHAR*1;
	MARS = MARSCHAR*1;
	ISTATE = STATECHAR*1;
	CAHE = CAHECHAR*1;
	CAFHE = CAFHECHAR*1;
	DROP RETIDCHAR CWHSICHAR TAXYRCHAR MARSCHAR STATECHAR CAHECHAR CAFHECHAR;

	/* Calculate passive and active net partnership, SBC, and Scorp income */
	PARTPAS = PPARTG - PPARTL ; *E25940 - E25920;
	PARTACT = APARTG - APARTL ; *E25980 - E25960;
	PART = PARTPAS + PARTACT;
	SBC = 0;
	SCORPPAS = PSBCG - PSBCL ; *E26170 - E26160;
	SCORPACT = ASBCG - ASBCL ; *E26190 - E26180;
	SCORP = SCORPPAS + SCORPACT;

	/* Subtract off nondeductible meals and entertainment to make 
	   consistent with pre-TRA86 law (when total was deductible) */

    NDMEALENTC = E90350;
	NDMEALENT1 = E91350;
	NDMEALENT2 = E92350;
	NDMEALENT3 = E93350;

	SOLENETINCC = SOLENETINCC - NDMEALENTC;
	SOLENETINC1 = SOLENETINC1 - NDMEALENT1;
	SOLENETINC2 = SOLENETINC2 - NDMEALENT2;
	SOLENETINC3 = SOLENETINC3 - NDMEALENT3;

	DROP E90350 E91350 E92350 E93350;

	/* Sole prop gain (plus gains from other forms) */
	SOLEGAINPLUS = E22320;
	DROP E22320;

	SOLEGAIN = MAX(E40240, 0);
	DROP E40240;

	SOLEGAINALT = E40220;
	DROP E40220; 

	/* Partnership and scorp gain */
	PARTSCORPGAIN = E21775 + E22365;
	DROP E21775 E22365;

	/* Calculate adjusted total income */
	ptpexc = max(grpen - ptpen, 0);
	iraexc = max(grirad - tirad,0);
	ssexc = max(ssinc - ssagix,0);

	ADJTOTINC = totincx + texint + iraexc + ptpexc + ssexc;



	/* Create variables not in 1998 Insole */
	EDUCEXP = 0;
	TUITFEES = 0;
	E18425 = 0;
	E18450 = 0;
	/*E60630 = 0;
	E60430 = 0;
	N24 = 0;*/
	E00650 = 0;
	E05750 = 0;
	CDOB1 = 0;
	CDOB2 = 0;
	DOMPROD = 0;
	SAVCRED = 0;

	fileyr = 1998;
	

	/* Create ID for matching with marginal tax rates */
	id = issnp;

	/* Merge in DOB and gender information */
	set INSOLE98DM1 key = RETID /unique ;

	RUN;


/* 1999 INSOLE */
/* Read DM1 data, a dataset with date of birth and gender information, and create variables for merging
	into insole */
DATA INSOLE99DM1 (index=(retid));
    SET SUB2.DM1X99(KEEP=
	S001
	DM1_MATCH 
	DM1P_DOB DM1S_DOB
	DM1P_GENDER DM1S_GENDER

	RENAME=(
	DM1P_DOB = PDOB
	DM1S_DOB = SDOB

	)
	);

	RETID = S001;

	PGENDER = .;
	IF DM1P_GENDER = 'F' THEN PGENDER = 2;
	IF DM1P_GENDER = 'M' THEN PGENDER = 1;
	SGENDER = .;
	IF DM1S_GENDER = 'F' THEN SGENDER = 2;
	IF DM1S_GENDER = 'M' THEN SGENDER = 1;


	DOBYR = FLOOR(PDOB/10000);
	SDOBYR = FLOOR(SDOB/10000);

	KEEP DM1_MATCH RETID PGENDER SGENDER DOBYR SDOBYR;
RUN;


/* Read in insole data */
  PROC CONTENTS DATA=SUBG.INSOLE99;
    TITLE "Contents of Insole";
  RUN;




/* Pull subset of data */

DATA SUBSUB.INSOLE99SUBSET (COMPRESS=YES);
    SET SUBG.INSOLE99(KEEP=
	
	S001 MARS FLPDYR REJECT
	STATE XOCAH  XOCAWH
	S002 S003	S006
	MARS
	XTOT	STATE	DSI	
	AGEP	AGES	
	PBI 	SBI
	DOBYR
	CWHSI
	E00100
	E00200	E02650	E03280	E03270	E04470
	E04800	E17500	E17000	E18300	E18400
	E18500	E18800	E18900	E19200	E03260
	E09400	E02000	E19300	E19530 	E19700
	E19800	E20100	E20400	E20550	E20800
	E20900	E21000	E21020	E21050	E21060
	E21040	E21100	E29375	E29400	E29450
	E33420	E62100	E63000	E10300	E02400
	E02500	E01100	E25960	E25980	E25920
	E25940	E26160	E26170	E26180	E26190
	N6
	EICYB1 	EICYB2 	E29100
	E29120	E29070	E00900	E29020	E29050
	E29000	E02100	E22250	E23250	E01000
	E01200	E00600	E00300	E00400	E01700
	E26500	E00700	E00800	E01400
	E02300	E02600	E02900	E19570
	E20500	E32700	E07100	E07180
	E07200	E68000	E04600	E04100	E04200
	E04450	
	E03600
	E04500 E04800 E05100 E05800 E05700 E08795
	E09600 E01800 E01500 E01300 
	E11000 E07400 E61850
	E20200
	E53220 E07300 E53240 E08000
	E09200 E08795
	E05200
	E62600 E62700 E62800 
	E25870 
	
	E60300 E60290 E60340 E60500 
	E60550 E60680 E60720 E60840 
	E61450 E60100 E62000 E60860 
	 E60600 E60405 
	E60440 E60420 E60410 E60480 
	E61400 E60660 

	E60630 
	E60430 
	N24 
	E03150  E03300 E03400
	E03210  
	E11070

	/* Sole prop variables */
	INDYC INDYC1 INDYC2 INDYC3 DOMC SEXPRC SXPRC1 SXPRC2 SXPRC3	
	E90020 E91020 E92020 E93020
	E90440 E91440 E92440 E93440
	E90350 E91350 E92350 E93350
	E90370 E90100

	E90470 E90200 E90290 E90190 E90445 E90570 E90550 

	/* Capital gain variables */
	E22320 E40240 E40220  
	E21775 E22365 

	/* Depreciation Variables */
	E54010 E54015 E54100 E57800 E57900 E58020 E58040 E58100 E58120 E58140 E58060 E58200 E58250 E58300
	 
	E03500

	/****** Convert names to Family panel names ***/
	RENAME=(
	S001	= 	RETIDCHAR
	s002	=	issnp
	s003	=	issns
	DOBYR	=	PDOB
	MARS	=	MARSCHAR
	CWHSI	=	CWHSICHAR
	FLPDYR	=	TAXYRCHAR
	REJECT	=	REJECT
	STATE	=	STATECHAR
	XTOT	=	IEXEMH 
	DSI		=	IFDEPT 
	S006	=	WGT
	AGEP	=	I65INDP 
	AGES	=	I65INDS 
	XOCAH	=	CAHECHAR
	XOCAWH	=	CAFHECHAR

	E00100	=	AGIX 
	E00200	=	WAS 
	E02650	=	TOTINCX 
	E03280	=	EXMOVE_AJ  
	E03270	=	HEALSE
	E04470	=	TIDX 
	E17500	=	TTMED 
	E17000	=	DEDMED 
	E18300	=	TTSLTX 
	E18400	=	SLITX 
	E18500	=	RETX 
	E18800	=	PPTX
	E18900	=	OTSLTX
	E19200	=	TTI_DED
	E03260	=	SECADED 
	E09400	=	SECATX
	E19300	=	HMIE 
	E19530 	=	POINTS
	E19700	=	TTCON 
	E19800	=	TCASH 
	E20100	=	TNCASH 
	E20400	=	T2MISC 
	E20550	=	EBE 
	E20800	=	DEDMIS 
	E20900	=	FDGAMB 
	E21000	=	FDOTHD 
	E21020	=	FDMISC 
	E21050	=	TOTMIS 
	E21060	=	GR_TID 
	E21040	=	DISIDX 
	E21100	=	SAVBOND
	E29375	=	WAS_OAS 
	E29400	=	WASP_OAS 
	E29450	=	WASS_OAS
	E33420	=	EMPLCC 
	E62100	=	AMTIX 
	E63000	=	TAMTX 
	E10300	=	TOT_LIAB
	E02500	=	SSAGIX 
	E01100	=	CGD40
	E25960	=	APARTL 
	E25980	=	APARTG
	E25920	=	PPARTL
	E25940	=	PPARTG
	E26160	=	PSBCL
	E26170	=	PSBCG
	E26180	=	ASBCL
	E26190	=	ASBCG
	N6		=	DEPNE 
	E29100	=	SENONFP 
	E29120	=	SENONFS 
	E29070	=	SENONF 
	E00900	=	BIL 
	E29020	=	SEFARMP 
	E29050	=	SEFARMS 
	E29000	=	SEFARM 
	E02100	=	FIL
	E22250	=	NSTGL 
	E23250	=	NLTGL 
	E01000	=	CGAGIX 
	E01200	=	SUPPGL 
	E00600	=	DBE 
	E00300	=	INTST 
	E00400	=	TEXINT
	E01700	=	PTPEN
	E02000	=	SCHE 
	E26500	=	ESTU 
	E00700	=	SITR 
	E00800	=	ALIMONY 
	E01400	=	TIRAD 
	E02300	=	UCAGIX 
	E02400	=	SSINC
	E02600	=	OTHINC
	E02900	=	TTADJ 
	E19570	=	IIE
	E20500	=	TTCASU 
	E32700	=	CCECYR 
	E07100	=	TTCRX 
	E07180	=	CCCX 
	E07200	=	ELDCRX
	E68000	=	Z17
	E04600	=	EXEMX 
	E04100	=	BSD 
	E04200	=	SDADD 
	E04450	=	SDX 
	/*E03220 	= 	EDUCEXP
	E03230	=	TUITFEES*/
	E03600	=	MSA
	E61850 	= 	TTPREF
	E62600  =  	AMTEXEMPTX
	E62700	=	AMTIAEX
	E62800	=	AMTIAEEXCGX
	E03150  =   IRACONT
	E03300  = 	SEPSIMPLE
	E03400	=	EARLYWD
	E03210  =   STUDLOAN	
	E01300	=	GRIRAD
	E01500 	=	GRPEN
	E11000	=	EICX
	E11070	=	ACTCX

	E90020 	=  SOLEGRRECEIPTC
	E91020 	=  SOLEGRRECEIPT1
	E92020	=  SOLEGRRECEIPT2
	E93020   =  SOLEGRRECEIPT3	

	E90440 	=  SOLENETINCC
	E91440 	=  SOLENETINC1
	E92440	=  SOLENETINC2
	E93440   =  SOLENETINC3

	E90370	=	SOLEWAGESC
	E90100	=	SOLEEXPC

	E90470  =   SOLELABORCOGSC
	E90200  =   SOLEEMPBENC
	E90290  =   SOLEPENPROFITC
	E90190  =   SOLEDEPRC
	E90445  =   SOLEDEPR8829C
	E90570  =   SOLEDEPRCOGSC
	E90550  =   SOLEPAYROLLCOGSC

	E03500 = ALIP
	) 

	);

	/* Keep non-rejected returns */
	if REJECT=0;

	/* Generate indicator for being sampled with probability 1 */
	HIINC = (WGT = 1);

	/* Convert possibly char variables to numbers */
	RETID = RETIDCHAR*1;
	CWHSI = CWHSICHAR*1;
	TAXYR = TAXYRCHAR*1;
	MARS = MARSCHAR*1;
	ISTATE = STATECHAR*1;
	CAHE = CAHECHAR*1;
	CAFHE = CAFHECHAR*1;
	DROP RETIDCHAR CWHSICHAR TAXYRCHAR MARSCHAR STATECHAR CAHECHAR CAFHECHAR;

	/* Create variables not in 1999 Insole */
	EDUCEXP = 0;
	TUITFEES = 0;
	CDOB1 = 0;
	CDOB2 = 0;	
	E00650 = 0;
	E05750 = 0;	
	E18425 = 0;
	E18450 = 0;	
	DOMPROD = 0;
	SAVCRED = 0;

	fileyr = 1999;

	/* Create ID for matching with marginal tax rates */
	id = issnp;

	/* Calculate passive and active net partnership, SBC, and Scorp income */
	PARTPAS = PPARTG - PPARTL ; *E25940 - E25920;
	PARTACT = APARTG - APARTL ; *E25980 - E25960;
	PART = PARTPAS + PARTACT;
	SBC = 0;
	SCORPPAS = PSBCG - PSBCL ; *E26170 - E26160;
	SCORPACT = ASBCG - ASBCL ; *E26190 - E26180;
	SCORP = SCORPPAS + SCORPACT;

	/* Subtract off nondeductible meals and entertainment to make 
	   consistent with pre-TRA86 law (when total was deductible) */

    NDMEALENTC = E90350;
	NDMEALENT1 = E91350;
	NDMEALENT2 = E92350;
	NDMEALENT3 = E93350;

	SOLENETINCC = SOLENETINCC - NDMEALENTC;
	SOLENETINC1 = SOLENETINC1 - NDMEALENT1;
	SOLENETINC2 = SOLENETINC2 - NDMEALENT2;
	SOLENETINC3 = SOLENETINC3 - NDMEALENT3;

	DROP E90350 E91350 E92350 E93350;


	/* Sole prop gain (plus gains from other forms) */
	SOLEGAINPLUS = E22320;
	DROP E22320;

	SOLEGAIN = MAX(E40240, 0);
	DROP E40240;

	SOLEGAINALT = E40220;
	DROP E40220; 

	/* Partnership and scorp gain */
	PARTSCORPGAIN = E21775 + E22365;
	DROP E21775 E22365;

	/* Calculate adjusted total income */
	ptpexc = max(grpen - ptpen, 0);
	iraexc = max(grirad - tirad, 0);
	ssexc = max(ssinc - ssagix, 0);

	ADJTOTINC = totincx + texint + iraexc + ptpexc + ssexc;


	/* Merge in DOB and gender information */
	set INSOLE99DM1 key = RETID /unique ;

RUN;      



/* 2000 INSOLE */
/* Read DM1 data, a dataset with date of birth and gender information, and create variables for merging
	into insole */
DATA INSOLE00DM1 (index=(retid));
    SET SUB2.DM1X00(KEEP=
	S001
	DM1_MATCH 
	DM1P_DOB DM1S_DOB
	DM1P_GENDER DM1S_GENDER

	RENAME=(
	DM1P_DOB = PDOB
	DM1S_DOB = SDOB

	)
	);

	RETID = S001;

	PGENDER = .;
	IF DM1P_GENDER = 'F' THEN PGENDER = 2;
	IF DM1P_GENDER = 'M' THEN PGENDER = 1;
	SGENDER = .;
	IF DM1S_GENDER = 'F' THEN SGENDER = 2;
	IF DM1S_GENDER = 'M' THEN SGENDER = 1;


	DOBYR = FLOOR(PDOB/10000);
	SDOBYR = FLOOR(SDOB/10000);

	KEEP DM1_MATCH RETID PGENDER SGENDER DOBYR SDOBYR;
RUN;

/* Read in insole data */
  PROC CONTENTS DATA=SUBG.INSOLE00;
    TITLE "Contents of Insole";
  RUN;

/* Pull subset of data */

DATA SUBSUB.INSOLE00SUBSET (COMPRESS=YES);
    SET SUBG.INSOLE00(KEEP=
	
	S001 MARS FLPDYR REJECT
	STATE XOCAH  XOCAWH
	S002 S003	S006
	XTOT	STATE	DSI	
	AGEP	AGES	
	PBI 	SBI
	DOBYR
	CWHSI
	E00100
	E00200	E02650	E03280	E03270	E04470
	E04800	E17500	E17000	E18300	E18400
	E18500	E18800	E18900	E19200	E03260
	E09400	E02000	E19300	E19530 	E19700
	E19800	E20100	E20400	E20550	E20800
	E20900	E21000	E21020	E21050	E21060
	E21040	E21100	E29375	E29400	E29450
	E33420	E62100	E63000	E10300	E02400
	E02500	E01100	E25960	E25980	E25920
	E25940	E26160	E26170	E26180	E26190
	N6
	EICYB1 	EICYB2 	E29100
	E29120	E29070	E00900	E29020	E29050
	E29000	E02100	E22250	E23250	E01000
	E01200	E00600	E00300	E00400	E01700
	E26500	E00700	E00800	E01400
	E02300	E02600	E02900	E19570
	E20500	E32700	E07100	E07180
	E07200	E68000	E04600	E04100	E04200
	E04450	
	E03600
	E04500 E04800 E05100 E05800 E05700 E08795
	E09600 E01800 E01500 E01300 
	E11000 E07400 E61850
	E20200
	E53220 E07300 E53240 E08000
	E09200 E08795
	E05200
	E62600 E62700 E62800 
	E25870 
	
	E60300 E60290 E60340 E60500 
	E60550 E60680 E60720 E60840 
	E61450 E60100 E62000 E60860 
	 E60600 E60405 
	E60440 E60420 E60410 E60480 
	E61400 E60660 

	E60630 
	E60430 
	N24 
	CDOB1 	CDOB2
	E05750
	E03150  E03300 E03400
	E03210  
	E11070	 

	/* Sole prop variables */
	INDYC INDYC1 INDYC2 INDYC3 DOMC SEXPRC SXPRC1 SXPRC2 SXPRC3	
	E90020 E91020 E92020 E93020
	E90440 E91440 E92440 E93440
	E90350 E91350 E92350 E93350
	E90370 E90100

	E90470 E90200 E90290 E90190 E90445 E90570 E90550 

	/* Capital gain variables */
	E22320 E40240 E40220  
	E21775 E22365 

	/* Depreciation Variables */
	E54010 E54015 E54100 E57800 E57900 E58020 E58040 E58100 E58120 E58140 E58060 E58200 E58250 E58300
	 

	E03500

	/****** Convert names to Family panel names ***/
	RENAME=(
	S001	= 	RETIDCHAR
	s002	=	issnp
	s003	=	issns
	DOBYR	=	PDOB
	MARS	=	MARSCHAR
	CWHSI	=	CWHSICHAR
	FLPDYR	=	TAXYRCHAR
	REJECT	=	REJECT
	STATE	=	STATECHAR
	XTOT	=	IEXEMH 
	DSI		=	IFDEPT 
	S006	=	WGT
	AGEP	=	I65INDP 
	AGES	=	I65INDS 
	XOCAH	=	CAHECHAR
	XOCAWH	=	CAFHECHAR

	E00100	=	AGIX 
	E00200	=	WAS 
	E02650	=	TOTINCX 
	E03280	=	EXMOVE_AJ  
	E03270	=	HEALSE
	E04470	=	TIDX 
	E17500	=	TTMED 
	E17000	=	DEDMED 
	E18300	=	TTSLTX 
	E18400	=	SLITX 
	E18500	=	RETX 
	E18800	=	PPTX
	E18900	=	OTSLTX
	E19200	=	TTI_DED
	E03260	=	SECADED 
	E09400	=	SECATX
	E19300	=	HMIE 
	E19530 	=	POINTS
	E19700	=	TTCON 
	E19800	=	TCASH 
	E20100	=	TNCASH 
	E20400	=	T2MISC 
	E20550	=	EBE 
	E20800	=	DEDMIS 
	E20900	=	FDGAMB 
	E21000	=	FDOTHD 
	E21020	=	FDMISC 
	E21050	=	TOTMIS 
	E21060	=	GR_TID 
	E21040	=	DISIDX 
	E21100	=	SAVBOND
	E29375	=	WAS_OAS 
	E29400	=	WASP_OAS 
	E29450	=	WASS_OAS
	E33420	=	EMPLCC 
	E62100	=	AMTIX 
	E63000	=	TAMTX 
	E10300	=	TOT_LIAB
	E02500	=	SSAGIX 
	E01100	=	CGD40
	E25960	=	APARTL 
	E25980	=	APARTG
	E25920	=	PPARTL
	E25940	=	PPARTG
	E26160	=	PSBCL
	E26170	=	PSBCG
	E26180	=	ASBCL
	E26190	=	ASBCG
	N6		=	DEPNE 
	E29100	=	SENONFP 
	E29120	=	SENONFS 
	E29070	=	SENONF 
	E00900	=	BIL 
	E29020	=	SEFARMP 
	E29050	=	SEFARMS 
	E29000	=	SEFARM 
	E02100	=	FIL
	E22250	=	NSTGL 
	E23250	=	NLTGL 
	E01000	=	CGAGIX 
	E01200	=	SUPPGL 
	E00600	=	DBE 
	E00300	=	INTST 
	E00400	=	TEXINT
	E01700	=	PTPEN
	E02000	=	SCHE 
	E26500	=	ESTU 
	E00700	=	SITR 
	E00800	=	ALIMONY 
	E01400	=	TIRAD 
	E02300	=	UCAGIX 
	E02400	=	SSINC
	E02600	=	OTHINC
	E02900	=	TTADJ 
	E19570	=	IIE
	E20500	=	TTCASU 
	E32700	=	CCECYR 
	E07100	=	TTCRX 
	E07180	=	CCCX 
	E07200	=	ELDCRX
	E68000	=	Z17
	E04600	=	EXEMX 
	E04100	=	BSD 
	E04200	=	SDADD 
	E04450	=	SDX 
	/*E03220 	= 	EDUCEXP
	E03230	=	TUITFEES*/
	E03600	=	MSA
	E61850 	= 	TTPREF
	E62600  =  	AMTEXEMPTX
	E62700	=	AMTIAEX
	E62800	=	AMTIAEEXCGX
	E03150  =   IRACONT
	E03300  = 	SEPSIMPLE
	E03400	=	EARLYWD
	E03210  =   STUDLOAN	
	E01300	=	GRIRAD
	E01500 	=	GRPEN
	E11000	=	EICX
	E11070	=	ACTCX

	E90020 	=  SOLEGRRECEIPTC
	E91020 	=  SOLEGRRECEIPT1
	E92020	=  SOLEGRRECEIPT2
	E93020   =  SOLEGRRECEIPT3	

	E90440 	=  SOLENETINCC
	E91440 	=  SOLENETINC1
	E92440	=  SOLENETINC2
	E93440   =  SOLENETINC3	

	E90370	=	SOLEWAGESC
	E90100	=	SOLEEXPC

	E90470  =   SOLELABORCOGSC
	E90200  =   SOLEEMPBENC
	E90290  =   SOLEPENPROFITC
	E90190  =   SOLEDEPRC
	E90445  =   SOLEDEPR8829C
	E90570  =   SOLEDEPRCOGSC
	E90550  =   SOLEPAYROLLCOGSC

	E03500 = ALIP
	) 

	);

	/* Keep non-rejected returns */
	if REJECT=0;

	/* Generate indicator for being sampled with probability 1 */
	HIINC = (WGT = 1);

	/* Convert possibly char variables to numbers */
	RETID = RETIDCHAR*1;
	CWHSI = CWHSICHAR*1;
	TAXYR = TAXYRCHAR*1;
	MARS = MARSCHAR*1;
	ISTATE = STATECHAR*1;
	CAHE = CAHECHAR*1;
	CAFHE = CAFHECHAR*1;
	DROP RETIDCHAR CWHSICHAR TAXYRCHAR MARSCHAR STATECHAR CAHECHAR CAFHECHAR;

	/* Fix dependent exemptions variable */
	if DEPNE = . then DEPNE = 0;
	
	/* Fix child tax credit qualifying children variable */
	if N24 = . then N24 = 0;

	/* Create variables not in 2000 Insole */
	EDUCEXP = 0;
	TUITFEES = 0;
	E00650 = 0;
	E18425 = 0;
	E18450 = 0;	
	DOMPROD = 0;
	SAVCRED = 0;

	fileyr = 2000;

	/* Calculate passive and active net partnership, SBC, and Scorp income */
	PARTPAS = PPARTG - PPARTL ; *E25940 - E25920;
	PARTACT = APARTG - APARTL ; *E25980 - E25960;
	PART = PARTPAS + PARTACT;
	SBC = 0;
	SCORPPAS = PSBCG - PSBCL ; *E26170 - E26160;
	SCORPACT = ASBCG - ASBCL ; *E26190 - E26180;
	SCORP = SCORPPAS + SCORPACT;

	/* Subtract off nondeductible meals and entertainment to make 
	   consistent with pre-TRA86 law (when total was deductible) */

    NDMEALENTC = E90350;
	NDMEALENT1 = E91350;
	NDMEALENT2 = E92350;
	NDMEALENT3 = E93350;

	SOLENETINCC = SOLENETINCC - NDMEALENTC;
	SOLENETINC1 = SOLENETINC1 - NDMEALENT1;
	SOLENETINC2 = SOLENETINC2 - NDMEALENT2;
	SOLENETINC3 = SOLENETINC3 - NDMEALENT3;

	DROP E90350 E91350 E92350 E93350;

	/* Sole prop gain (plus gains from other forms) */
	SOLEGAINPLUS = E22320;
	DROP E22320;

	SOLEGAIN = MAX(E40240, 0);
	DROP E40240;

	SOLEGAINALT = E40220;
	DROP E40220; 

	/* Partnership and scorp gain */
	PARTSCORPGAIN = E21775 + E22365;
	DROP E21775 E22365;

	/* Calculate adjusted total income */
	ptpexc = max(grpen - ptpen, 0);
	iraexc = max(grirad - tirad, 0);
	ssexc = max(ssinc - ssagix, 0);

	ADJTOTINC = totincx + texint + iraexc + ptpexc + ssexc;


	/* Create ID for matching with marginal tax rates */
	id = issnp;

	/* Merge in DOB and gender information */
	set INSOLE00DM1 key = RETID /unique ;

RUN;      



/* 2001 INSOLE */
/* Read DM1 data, a dataset with date of birth and gender information, and create variables for merging
	into insole */
DATA INSOLE01DM1 (index=(retid));
    SET SUB2.DM1X01(KEEP=
	RECID
	DM1_MATCH 
	DM1P_DOB DM1S_DOB
	DM1P_GENDER DM1S_GENDER

	RENAME=(
	DM1P_DOB = PDOB
	DM1S_DOB = SDOB

	)
	);

	RETID = RECID;

	PGENDER = .;
	IF DM1P_GENDER = 'F' THEN PGENDER = 2;
	IF DM1P_GENDER = 'M' THEN PGENDER = 1;
	SGENDER = .;
	IF DM1S_GENDER = 'F' THEN SGENDER = 2;
	IF DM1S_GENDER = 'M' THEN SGENDER = 1;

	DOBYR = FLOOR(PDOB/10000);
	SDOBYR = FLOOR(SDOB/10000);

	KEEP DM1_MATCH RETID PGENDER SGENDER DOBYR SDOBYR;
RUN;


/* Read in insole data */

  PROC CONTENTS DATA=SUBG.INSOLE01;
    TITLE "Contents of Insole";
  RUN;

/* Pull subset of data */

DATA SUBSUB.INSOLE01SUBSET (COMPRESS=YES);
    SET SUBG.INSOLE01(KEEP=
	
	RECID MARS FLPDYR REJECT
	STATE XOCAH  XOCAWH
	S002 S003	S006
	MARS
	XTOT	STATE	DSI	
	AGEP	AGES	
	PBI 	SBI
	DOBYR
	CWHSI
	E00100
	E00200	E02650	E03280	E03270	E04470
	E04800	E17500	E17000	E18300	E18400
	E18500	E18800	E18900	E19200	E03260
	E09400	E02000	E19300	E19530 	E19700
	E19800	E20100	E20400	E20550	E20800
	E20900	E21000	E21020	E21050	E21060
	E21040	E21100	E29375	E29400	E29450
	E33420	E62100	E63000	E10300	E02400
	E02500	E01100	E25960	E25980	E25920
	E25940	E26160	E26170	E26180	E26190
	N6
	EICYB1 	EICYB2 	E29100
	E29120	E29070	E00900	E29020	E29050
	E29000	E02100	E22250	E23250	E01000
	E01200	E00600	E00300	E00400	E01700
	E26500	E00700	E00800	E01400
	E02300	E02600	E02900	E19570
	E20500	E32700	E07100	E07180
	E07200	E68000	E04600	E04100	E04200
	E04450	
	E03600
	E04500 E04800 E05100 E05800 E05700 E08795
	E09600 E01800 E01500 E01300 
	E11000 E07400 E61850
	E20200
	E53220 E07300 E53240 E08000
	E09200 E08795
	E05200
	E62600 E62700 E62800 
	E25870 
	
	E60300 E60290 E60340 E60500 
	E60550 E60680 E60720 E60840 
	E61450 E60100 E62000 E60860 
	 E60600 E60405 
	E60440 E60420 E60410 E60480 
	E61400 E60660 

	E60630 
	E60430 
	N24 
	CDOB1 	CDOB2
	E05750
	E03150  E03300 E03400
	E03210  
	E11070	 

	/* Sole prop variables */
	INDYC INDYC1 INDYC2 INDYC3 NAIC NAIC1 NAIC2 NAIC3 DOMC SEXPRC SXPRC1 SXPRC2 SXPRC3	
	E90020 E91020 E92020 E93020
	E90440 E91440 E92440 E93440
	E90350 E91350 E92350 E93350
	E90370 E90100

	E90470 E90200 E90290 E90190 E90445 E90570 E90550 

	/* Capital gain variables */
	E22320 E40240 E40220  
	E21775 E22365 


	/* Depreciation Variables */
	E54010 E54015 E54100 E57800 E57900 E58020 E58040 E58100 E58120 E58140 E58060 E58200 E58250 E58300


	E03500

	/****** Convert names to Family panel names ***/
	RENAME=(
	RECID	= 	RETIDCHAR
	s002	=	issnp
	s003	=	issns
	MARS	=	MARSCHAR
	CWHSI	=	CWHSICHAR
	FLPDYR	=	TAXYRCHAR
	REJECT	=	REJECT
	STATE	=	STATECHAR
	XTOT	=	IEXEMH 
	DSI		=	IFDEPT 
	S006	=	WGT
	AGEP	=	I65INDP 
	AGES	=	I65INDS 
	XOCAH	=	CAHECHAR
	XOCAWH	=	CAFHECHAR

	E00100	=	AGIX 
	E00200	=	WAS 
	E02650	=	TOTINCX 
	E03280	=	EXMOVE_AJ  
	E03270	=	HEALSE
	E04470	=	TIDX 
	E17500	=	TTMED 
	E17000	=	DEDMED 
	E18300	=	TTSLTX 
	E18400	=	SLITX 
	E18500	=	RETX 
	E18800	=	PPTX
	E18900	=	OTSLTX
	E19200	=	TTI_DED
	E03260	=	SECADED 
	E09400	=	SECATX
	E19300	=	HMIE 
	E19530 	=	POINTS
	E19700	=	TTCON 
	E19800	=	TCASH 
	E20100	=	TNCASH 
	E20400	=	T2MISC 
	E20550	=	EBE 
	E20800	=	DEDMIS 
	E20900	=	FDGAMB 
	E21000	=	FDOTHD 
	E21020	=	FDMISC 
	E21050	=	TOTMIS 
	E21060	=	GR_TID 
	E21040	=	DISIDX 
	E21100	=	SAVBOND
	E29375	=	WAS_OAS 
	E29400	=	WASP_OAS 
	E29450	=	WASS_OAS
	E33420	=	EMPLCC 
	E62100	=	AMTIX 
	E63000	=	TAMTX 
	E10300	=	TOT_LIAB
	E02500	=	SSAGIX 
	E01100	=	CGD40
	E25960	=	APARTL 
	E25980	=	APARTG
	E25920	=	PPARTL
	E25940	=	PPARTG
	E26160	=	PSBCL
	E26170	=	PSBCG
	E26180	=	ASBCL
	E26190	=	ASBCG
	N6		=	DEPNE 
	E29100	=	SENONFP 
	E29120	=	SENONFS 
	E29070	=	SENONF 
	E00900	=	BIL 
	E29020	=	SEFARMP 
	E29050	=	SEFARMS 
	E29000	=	SEFARM 
	E02100	=	FIL
	E22250	=	NSTGL 
	E23250	=	NLTGL 
	E01000	=	CGAGIX 
	E01200	=	SUPPGL 
	E00600	=	DBE 
	E00300	=	INTST 
	E00400	=	TEXINT
	E01700	=	PTPEN
	E02000	=	SCHE 
	E26500	=	ESTU 
	E00700	=	SITR 
	E00800	=	ALIMONY 
	E01400	=	TIRAD 
	E02300	=	UCAGIX 
	E02400	=	SSINC
	E02600	=	OTHINC
	E02900	=	TTADJ 
	E19570	=	IIE
	E20500	=	TTCASU 
	E32700	=	CCECYR 
	E07100	=	TTCRX 
	E07180	=	CCCX 
	E07200	=	ELDCRX
	E68000	=	Z17
	E04600	=	EXEMX 
	E04100	=	BSD 
	E04200	=	SDADD 
	E04450	=	SDX 
	/*E03220 	= 	EDUCEXP
	E03230	=	TUITFEES*/
	E03600	=	MSA
	E61850 	= 	TTPREF
	E62600  =  	AMTEXEMPTX
	E62700	=	AMTIAEX
	E62800	=	AMTIAEEXCGX
	E03150  =   IRACONT
	E03300  = 	SEPSIMPLE
	E03400	=	EARLYWD
	E03210  =   STUDLOAN
	E01300	=	GRIRAD
	E01500 	=	GRPEN
	E11000	=	EICX
	E11070	=	ACTCX

	E90020 	=  SOLEGRRECEIPTC
	E91020 	=  SOLEGRRECEIPT1
	E92020	=  SOLEGRRECEIPT2
	E93020   =  SOLEGRRECEIPT3	

	E90440 	=  SOLENETINCC
	E91440 	=  SOLENETINC1
	E92440	=  SOLENETINC2
	E93440   =  SOLENETINC3

	E90370	=	SOLEWAGESC
	E90100	=	SOLEEXPC

	E90470  =   SOLELABORCOGSC
	E90200  =   SOLEEMPBENC
	E90290  =   SOLEPENPROFITC
	E90190  =   SOLEDEPRC
	E90445  =   SOLEDEPR8829C
	E90570  =   SOLEDEPRCOGSC
	E90550  =   SOLEPAYROLLCOGSC

	E03500 = ALIP
	) 

	);

	/* Keep non-rejected returns */
	if REJECT=0;

	/* Convert possibly char variables to numbers */
	RETID = RETIDCHAR*1;
	CWHSI = CWHSICHAR*1;
	TAXYR = TAXYRCHAR*1;
	MARS = MARSCHAR*1;
	ISTATE = STATECHAR*1;
	CAHE = CAHECHAR*1;
	CAFHE = CAFHECHAR*1;
	DROP RETIDCHAR CWHSICHAR TAXYRCHAR MARSCHAR STATECHAR CAHECHAR CAFHECHAR;

	/* Create variables not in 2001 Insole */
	EDUCEXP = 0;
	TUITFEES = 0;
	E00650 = 0;
	E18425 = 0;
	E18450 = 0;	
	DOMPROD = 0;
	SAVCRED = 0;

	fileyr = 2001;

	/* Create ID for matching with marginal tax rates */
	id = issnp;

	/* Generate indicator for being sampled with probability 1 */
	HIINC = (WGT = 1);

	/* Calculate passive and active net partnership, SBC, and Scorp income */
	PARTPAS = PPARTG - PPARTL ; *E25940 - E25920;
	PARTACT = APARTG - APARTL ; *E25980 - E25960;
	PART = PARTPAS + PARTACT;
	SBC = 0;
	SCORPPAS = PSBCG - PSBCL ; *E26170 - E26160;
	SCORPACT = ASBCG - ASBCL ; *E26190 - E26180;
	SCORP = SCORPPAS + SCORPACT;

	/* Subtract off nondeductible meals and entertainment to make 
	   consistent with pre-TRA86 law (when total was deductible) */

    NDMEALENTC = E90350;
	NDMEALENT1 = E91350;
	NDMEALENT2 = E92350;
	NDMEALENT3 = E93350;

	SOLENETINCC = SOLENETINCC - NDMEALENTC;
	SOLENETINC1 = SOLENETINC1 - NDMEALENT1;
	SOLENETINC2 = SOLENETINC2 - NDMEALENT2;
	SOLENETINC3 = SOLENETINC3 - NDMEALENT3;

	DROP E90350 E91350 E92350 E93350;

	/* Sole prop gain (plus gains from other forms) */
	SOLEGAINPLUS = E22320;
	DROP E22320;

	SOLEGAIN = MAX(E40240, 0);
	DROP E40240;

	SOLEGAINALT = E40220;
	DROP E40220; 

	/* Partnership and scorp gain */
	PARTSCORPGAIN = E21775 + E22365;
	DROP E21775 E22365;

	/* Calculate adjusted total income */
	ptpexc = max(grpen - ptpen, 0);
	iraexc = max(grirad - tirad, 0);
	ssexc = max(ssinc - ssagix, 0);

	ADJTOTINC = totincx + texint + iraexc + ptpexc + ssexc;

	/* Merge in DOB and gender information */
	set INSOLE01DM1 key = RETID /unique ;

RUN;    



/* 2002 INSOLE */

  PROC CONTENTS DATA=SUBG.INSOLE02;
    TITLE "Contents of Insole";
  RUN;

/* Pull subset of data */

DATA SUBSUB.INSOLE02SUBSET (COMPRESS=YES);
    SET SUBG.INSOLE02(KEEP=
	
	RECID MARS FLPDYR REJECT
	STATE XOCAH  XOCAWH
	S002 S003	S006
	MARS
	XTOT	STATE	DSI	
	AGEP	AGES	
	PBI 	SBI
	DOBYR
	CWHSI
	E00100
	E00200	E02650	E03280	E03270	E04470
	E04800	E17500	E17000	E18300	E18400
	E18500	E18800	E18900	E19200	E03260
	E09400	E02000	E19300	E19530 	E19700
	E19800	E20100	E20400	E20550	E20800
	E20900	E21000	E21020	E21050	E21060
	E21040	E21100	E29375	E29400	E29450
	E33420	E62100	E63000	E10300	E02400
	E02500	E01100	E25960	E25980	E25920
	E25940	E26160	E26170	E26180	E26190
	N6
	EICYB1 	EICYB2 	E29100
	E29120	E29070	E00900	E29020	E29050
	E29000	E02100	E22250	E23250	E01000
	E01200	E00600	E00300	E00400	E01700
	E26500	E00700	E00800	E01400
	E02300	E02600	E02900	E19570
	E20500	E32700	E07100	E07180
	E07200	E68000	E04600	E04100	E04200
	E04450	
	E03600
	E04500 E04800 E05100 E05800 E05700 E08795
	E09600 E01800 E01500 E01300 
	E11000 E07400 E61850
	E20200
	E53220 E07300 E53240 E08000
	E09200 E08795
	E05200
	E62600 E62700 E62800 
	E25870 
	
	E60300 E60290 E60340 E60500 
	E60550 E60680 E60720 E60840 
	E61450 E60100 E62000 E60860 
	 E60600 E60405 
	E60440 E60420 E60410 E60480 
	E61400 E60660 

	E60630 
	E60430 
	N24 
	CDOB1 	CDOB2
	E05750	E03220 E03230

	E03150  E03300 E03400
	E03210  

	E07240
	E11070	 

	/* Demographic vars */
	DOBYR SDOBYR

	/* Sole prop variables */
	NAIC NAIC1 NAIC2 NAIC3 DOMC SEXPRC SXPRC1 SXPRC2 SXPRC3	
	E90020 E91020 E92020 E93020
	E90440 E91440 E92440 E93440
	E90350 E91350 E92350 E93350
	E90370 E90100

	E90470 E90200 E90290 E90190 E90445 E90570 E90550 

	/* Capital gain variables */
	E22320 E40240 E40220  
	E21775 E22365 

	/* Depreciation Variables */
	E54010 E54015 E54100 E57800 E57900 E58020 E58040 E58100 E58120 E58140 E58060 E58200 E58250 E58300


	E03500


	/****** Convert names to Family panel names ***/
	RENAME=(
	RECID	= 	RETIDCHAR
	s002	=	issnp
	s003	=	issns
	MARS	=	MARSCHAR
	CWHSI	=	CWHSICHAR
	FLPDYR	=	TAXYRCHAR
	REJECT	=	REJECT
	STATE	=	STATECHAR
	XTOT	=	IEXEMH 
	DSI		=	IFDEPT 
	S006	=	WGT
	AGEP	=	I65INDP 
	AGES	=	I65INDS 
	XOCAH	=	CAHECHAR
	XOCAWH	=	CAFHECHAR

	E00100	=	AGIX 
	E00200	=	WAS 
	E02650	=	TOTINCX 
	E03280	=	EXMOVE_AJ  
	E03270	=	HEALSE
	E04470	=	TIDX 
	E17500	=	TTMED 
	E17000	=	DEDMED 
	E18300	=	TTSLTX 
	E18400	=	SLITX 
	E18500	=	RETX 
	E18800	=	PPTX
	E18900	=	OTSLTX
	E19200	=	TTI_DED
	E03260	=	SECADED 
	E09400	=	SECATX
	E19300	=	HMIE 
	E19530 	=	POINTS
	E19700	=	TTCON 
	E19800	=	TCASH 
	E20100	=	TNCASH 
	E20400	=	T2MISC 
	E20550	=	EBE 
	E20800	=	DEDMIS 
	E20900	=	FDGAMB 
	E21000	=	FDOTHD 
	E21020	=	FDMISC 
	E21050	=	TOTMIS 
	E21060	=	GR_TID 
	E21040	=	DISIDX 
	E21100	=	SAVBOND
	E29375	=	WAS_OAS 
	E29400	=	WASP_OAS 
	E29450	=	WASS_OAS
	E33420	=	EMPLCC 
	E62100	=	AMTIX 
	E63000	=	TAMTX 
	E10300	=	TOT_LIAB
	E02500	=	SSAGIX 
	E01100	=	CGD40
	E25960	=	APARTL 
	E25980	=	APARTG
	E25920	=	PPARTL
	E25940	=	PPARTG
	E26160	=	PSBCL
	E26170	=	PSBCG
	E26180	=	ASBCL
	E26190	=	ASBCG
	N6		=	DEPNE 
	E29100	=	SENONFP 
	E29120	=	SENONFS 
	E29070	=	SENONF 
	E00900	=	BIL 
	E29020	=	SEFARMP 
	E29050	=	SEFARMS 
	E29000	=	SEFARM 
	E02100	=	FIL
	E22250	=	NSTGL 
	E23250	=	NLTGL 
	E01000	=	CGAGIX 
	E01200	=	SUPPGL 
	E00600	=	DBE 
	E00300	=	INTST 
	E00400	=	TEXINT
	E01700	=	PTPEN
	E02000	=	SCHE 
	E26500	=	ESTU 
	E00700	=	SITR 
	E00800	=	ALIMONY 
	E01400	=	TIRAD 
	E02300	=	UCAGIX 
	E02400	=	SSINC
	E02600	=	OTHINC
	E02900	=	TTADJ 
	E19570	=	IIE
	E20500	=	TTCASU 
	E32700	=	CCECYR 
	E07100	=	TTCRX 
	E07180	=	CCCX 
	E07200	=	ELDCRX
	E68000	=	Z17
	E04600	=	EXEMX 
	E04100	=	BSD 
	E04200	=	SDADD 
	E04450	=	SDX 
	E03220 	= 	EDUCEXP
	E03230	=	TUITFEES
	E03600	=	MSA
	E61850 	= 	TTPREF
	E62600  =  	AMTEXEMPTX
	E62700	=	AMTIAEX
	E62800	=	AMTIAEEXCGX
	E03150  =   IRACONT
	E03300  = 	SEPSIMPLE
	E03400	=	EARLYWD
	E03210  =   STUDLOAN
	E07240	=	SAVCRED
	E01300	=	GRIRAD
	E01500 	=	GRPEN
	E11000	=	EICX
	E11070	=	ACTCX
	
	E90020 	=  SOLEGRRECEIPTC
	E91020 	=  SOLEGRRECEIPT1
	E92020	=  SOLEGRRECEIPT2
	E93020   =  SOLEGRRECEIPT3	

	E90440 	=  SOLENETINCC
	E91440 	=  SOLENETINC1
	E92440	=  SOLENETINC2
	E93440   =  SOLENETINC3

	E90370	=	SOLEWAGESC
	E90100	=	SOLEEXPC

	E90470  =   SOLELABORCOGSC
	E90200  =   SOLEEMPBENC
	E90290  =   SOLEPENPROFITC
	E90190  =   SOLEDEPRC
	E90445  =   SOLEDEPR8829C
	E90570  =   SOLEDEPRCOGSC
	E90550  =   SOLEPAYROLLCOGSC


	E03500 = ALIP
	) 

	);

	/* Keep non-rejected returns */
	if REJECT=0;

	/* Generate indicator for being sampled with probability 1 */
	HIINC = (WGT = 1);

	/* Convert possibly char variables to numbers */
	RETID = RETIDCHAR*1;
	CWHSI = CWHSICHAR*1;
	TAXYR = TAXYRCHAR*1;
	MARS = MARSCHAR*1;
	ISTATE = STATECHAR*1;
	CAHE = CAHECHAR*1;
	CAFHE = CAFHECHAR*1;
	DROP RETIDCHAR CWHSICHAR TAXYRCHAR MARSCHAR STATECHAR CAHECHAR CAFHECHAR;

	/* Create variables not in 2002 Insole */
	E00650 = 0;
	E18425 = 0;
	E18450 = 0;	
	DOMPROD = 0;
	fileyr = 2002;

	/* Create ID for matching with marginal tax rates */
	id = issnp;

	/* Calculate passive and active net partnership, SBC, and Scorp income */
	PARTPAS = PPARTG - PPARTL ; *E25940 - E25920;
	PARTACT = APARTG - APARTL ; *E25980 - E25960;
	PART = PARTPAS + PARTACT;
	SBC = 0;
	SCORPPAS = PSBCG - PSBCL ; *E26170 - E26160;
	SCORPACT = ASBCG - ASBCL ; *E26190 - E26180;
	SCORP = SCORPPAS + SCORPACT;

	/* Subtract off nondeductible meals and entertainment to make 
	   consistent with pre-TRA86 law (when total was deductible) */

    NDMEALENTC = E90350;
	NDMEALENT1 = E91350;
	NDMEALENT2 = E92350;
	NDMEALENT3 = E93350;

	SOLENETINCC = SOLENETINCC - NDMEALENTC;
	SOLENETINC1 = SOLENETINC1 - NDMEALENT1;
	SOLENETINC2 = SOLENETINC2 - NDMEALENT2;
	SOLENETINC3 = SOLENETINC3 - NDMEALENT3;

	DROP E90350 E91350 E92350 E93350;

	/* Sole prop gain (plus gains from other forms) */
	SOLEGAINPLUS = E22320;
	DROP E22320;

	SOLEGAIN = MAX(E40240, 0);
	DROP E40240;

	SOLEGAINALT = E40220;
	DROP E40220; 

	/* Partnership and scorp gain */
	PARTSCORPGAIN = E21775 + E22365;
	DROP E21775 E22365;

	/* Calculate adjusted total income */
	ptpexc = max(grpen - ptpen, 0);
	iraexc = max(grirad - tirad, 0);
	ssexc = max(ssinc - ssagix, 0);

	ADJTOTINC = totincx + texint + iraexc + ptpexc + ssexc;



RUN;    
 

/* 2003 INSOLE */

  PROC CONTENTS DATA=SUBG.INSOLE03;
    TITLE "Contents of Insole";
  RUN;

/* Pull subset of data */

DATA SUBSUB.INSOLE03SUBSET (COMPRESS=YES);
    SET SUBG.INSOLE03(KEEP=
	
	REC_ID MARS FLPDYR REJECT
	STATE XOCAH  XOCAWH
	S002 S003	S006
	MARS
	XTOT	STATE	DSI	
	AGEP	AGES	
	PBI 	SBI

	DOBYR
	CWHSI
	E00100
	E00200	E02650	E03280	E03270	E04470
	E04800	E17500	E17000	E18300	E18400
	E18500	E18800	E18900	E19200	E03260
	E09400	E02000	E19300	E19530 	E19700
	E19800	E20100	E20400	E20550	E20800
	E20900	E21000	E21020	E21050	E21060
	E21040	E21100	E29375	E29400	E29450
	E33420	E62100	E63000	E10300	E02400
	E02500	E01100	E25960	E25980	E25920
	E25940	E26160	E26170	E26180	E26190
	N6
	EICYB1 	EICYB2 	E29100
	E29120	E29070	E00900	E29020	E29050
	E29000	E02100	E22250	E23250	E01000
	E01200	E00600	E00300	E00400	E01700
	E26500	E00700	E00800	E01400
	E02300	E02600	E02900	E19570
	E20500	E32700	E07100	E07180
	E07200	E68000	E04600	E04100	E04200
	E04450	
	E03600
	E04500 E04800 E05100 E05800 E05700 E08795
	E09600 E01800 E01500 E01300 
	E11000 E07400 E61850
	E20200
	E53220 E07300 E53240 E08000
	E09200 E08795
	E05200
	E62600 E62700 E62800 
	E25870 
	
	E60300 E60290 E60340 E60500 
	E60550 E60680 E60720 E60840 
	E61450 E60100 E62000 E60860 
	 E60600 E60405 
	E60440 E60420 E60410 E60480 
	E61400 E60660 

	E60630 
	E60430 
	N24 
	CDOB1 	CDOB2
	E05750	E03220 E03230
	E00650
	E03150  E03300 E03400
	E03210  
	E07240
	E11070	 

	/* Demographic vars */
	DOBYR SDOBYR

	/* Sole prop variables */
	NAIC NAIC1 NAIC2 NAIC3 DOMC SEXPRC SXPRC1 SXPRC2 SXPRC3	
	E90020 E91020 E92020 E93020
	E90440 E91440 E92440 E93440
	E90350 E91350 E92350 E93350
	E90370 E90100

	E90470 E90200 E90290 E90190 E90445 E90570 E90550 E90165


	/* Capital gain variables */
	E22320 E40240 E40220  


	/* Depreciation Variables */
	E54010 E54015 E54100 E57800 E57900 E58020 E58040 E58100 E58120 E58140 E58060 E58200 E58250 E58300


	E03500

	/****** Convert names to Family panel names ***/
	RENAME=(
	REC_ID	= 	RETIDCHAR
	s002	=	issnp
	s003	=	issns
	MARS	=	MARSCHAR
	CWHSI	=	CWHSICHAR
	FLPDYR	=	TAXYRCHAR
	REJECT	=	REJECT
	STATE	=	STATECHAR
	XTOT	=	IEXEMH 
	DSI		=	IFDEPT 
	S006	=	WGT
	AGEP	=	I65INDP 
	AGES	=	I65INDS 
	XOCAH	=	CAHECHAR
	XOCAWH	=	CAFHECHAR

	E00100	=	AGIX 
	E00200	=	WAS 
	E02650	=	TOTINCX 
	E03280	=	EXMOVE_AJ  
	E03270	=	HEALSE
	E04470	=	TIDX 
	E17500	=	TTMED 
	E17000	=	DEDMED 
	E18300	=	TTSLTX 
	E18400	=	SLITX 
	E18500	=	RETX 
	E18800	=	PPTX
	E18900	=	OTSLTX
	E19200	=	TTI_DED
	E03260	=	SECADED 
	E09400	=	SECATX
	E19300	=	HMIE 
	E19530 	=	POINTS
	E19700	=	TTCON 
	E19800	=	TCASH 
	E20100	=	TNCASH 
	E20400	=	T2MISC 
	E20550	=	EBE 
	E20800	=	DEDMIS 
	E20900	=	FDGAMB 
	E21000	=	FDOTHD 
	E21020	=	FDMISC 
	E21050	=	TOTMIS 
	E21060	=	GR_TID 
	E21040	=	DISIDX 
	E21100	=	SAVBOND
	E29375	=	WAS_OAS 
	E29400	=	WASP_OAS 
	E29450	=	WASS_OAS
	E33420	=	EMPLCC 
	E62100	=	AMTIX 
	E63000	=	TAMTX 
	E10300	=	TOT_LIAB
	E02500	=	SSAGIX 
	E01100	=	CGD40
	E25960	=	APARTL 
	E25980	=	APARTG
	E25920	=	PPARTL
	E25940	=	PPARTG
	E26160	=	PSBCL
	E26170	=	PSBCG
	E26180	=	ASBCL
	E26190	=	ASBCG
	N6		=	DEPNE 
	E29100	=	SENONFP 
	E29120	=	SENONFS 
	E29070	=	SENONF 
	E00900	=	BIL 
	E29020	=	SEFARMP 
	E29050	=	SEFARMS 
	E29000	=	SEFARM 
	E02100	=	FIL
	E22250	=	NSTGL 
	E23250	=	NLTGL 
	E01000	=	CGAGIX 
	E01200	=	SUPPGL 
	E00600	=	DBE 
	E00300	=	INTST 
	E00400	=	TEXINT
	E01700	=	PTPEN
	E02000	=	SCHE 
	E26500	=	ESTU 
	E00700	=	SITR 
	E00800	=	ALIMONY 
	E01400	=	TIRAD 
	E02300	=	UCAGIX 
	E02400	=	SSINC
	E02600	=	OTHINC
	E02900	=	TTADJ 
	E19570	=	IIE
	E20500	=	TTCASU 
	E32700	=	CCECYR 
	E07100	=	TTCRX 
	E07180	=	CCCX 
	E07200	=	ELDCRX
	E68000	=	Z17
	E04600	=	EXEMX 
	E04100	=	BSD 
	E04200	=	SDADD 
	E04450	=	SDX 
	E03220 	= 	EDUCEXP
	E03230	=	TUITFEES
	E03600	=	MSA
	E61850 	= 	TTPREF
	E62600  =  	AMTEXEMPTX
	E62700	=	AMTIAEX
	E62800	=	AMTIAEEXCGX
	E03150  =   IRACONT
	E03300  = 	SEPSIMPLE
	E03400	=	EARLYWD
	E03210  =   STUDLOAN
	E07240	=	SAVCRED
	E01300	=	GRIRAD
	E01500 	=	GRPEN
	E11000	=	EICX
	E11070	=	ACTCX

	E90020 	=  SOLEGRRECEIPTC
	E91020 	=  SOLEGRRECEIPT1
	E92020	=  SOLEGRRECEIPT2
	E93020   =  SOLEGRRECEIPT3	

	E90440 	=  SOLENETINCC
	E91440 	=  SOLENETINC1
	E92440	=  SOLENETINC2
	E93440   =  SOLENETINC3

	E90370	=	SOLEWAGESC
	E90100	=	SOLEEXPC

	E90470  =   SOLELABORCOGSC
	E90200  =   SOLEEMPBENC
	E90290  =   SOLEPENPROFITC
	E90190  =   SOLEDEPRC
	E90445  =   SOLEDEPR8829C
	E90570  =   SOLEDEPRCOGSC
	E90550  =   SOLEPAYROLLCOGSC
	E90165  =   SOLECONTRLABORC

	E03500 = ALIP
	) 

	);

	/* Keep non-rejected returns */
	if REJECT=0;

	/* Generate indicator for being sampled with probability 1 */
	HIINC = (WGT = 1);

	/* Convert possibly char variables to numbers */
	RETID = RETIDCHAR*1;
	CWHSI = CWHSICHAR*1;
	TAXYR = TAXYRCHAR*1;
	MARS = MARSCHAR*1;
	ISTATE = STATECHAR*1;
	CAHE = CAHECHAR*1;
	CAFHE = CAFHECHAR*1;
	DROP RETIDCHAR CWHSICHAR TAXYRCHAR MARSCHAR STATECHAR CAHECHAR CAFHECHAR;

	/* Create variables not in 2003 Insole */
	E18425 = 0;
	E18450 = 0;	
	DOMPROD = 0;
	fileyr = 2003;

	/* Create ID for matching with marginal tax rates */
	id = issnp;

	/* Calculate passive and active net partnership, SBC, and Scorp income */
	PARTPAS = PPARTG - PPARTL ; *E25940 - E25920;
	PARTACT = APARTG - APARTL ; *E25980 - E25960;
	PART = PARTPAS + PARTACT;
	SBC = 0;
	SCORPPAS = PSBCG - PSBCL ; *E26170 - E26160;
	SCORPACT = ASBCG - ASBCL ; *E26190 - E26180;
	SCORP = SCORPPAS + SCORPACT;

	/* Subtract off nondeductible meals and entertainment to make 
	   consistent with pre-TRA86 law (when total was deductible) */

    NDMEALENTC = E90350;
	NDMEALENT1 = E91350;
	NDMEALENT2 = E92350;
	NDMEALENT3 = E93350;

	SOLENETINCC = SOLENETINCC - NDMEALENTC;
	SOLENETINC1 = SOLENETINC1 - NDMEALENT1;
	SOLENETINC2 = SOLENETINC2 - NDMEALENT2;
	SOLENETINC3 = SOLENETINC3 - NDMEALENT3;

	DROP E90350 E91350 E92350 E93350;

	/* Sole prop gain (plus gains from other forms) */
	SOLEGAINPLUS = E22320;
	DROP E22320;

	SOLEGAIN = MAX(E40240, 0);
	DROP E40240;

	SOLEGAINALT = E40220;
	DROP E40220; 

	/* Partnership and scorp gain */
	PARTSCORPGAIN = E21775 + E22365;
	DROP E21775 E22365;

	/* Calculate adjusted total income */
	ptpexc = max(grpen - ptpen, 0);
	iraexc = max(grirad - tirad, 0);
	ssexc = max(ssinc - ssagix, 0);

	ADJTOTINC = totincx + texint + iraexc + ptpexc + ssexc;


RUN;    




/* 2004 INSOLE */

  PROC CONTENTS DATA=SUBG.INSOLE04;
    TITLE "Contents of Insole";
  RUN;

/* Pull subset of data */

DATA SUBSUB.INSOLE04SUBSET (COMPRESS=YES);
    SET SUBG.INSOLE04(KEEP=
	
	REC_ID MARS FLPDYR REJECT
	STATE XOCAH  XOCAWH
	S002 S003	S006
	MARS
	XTOT	STATE	DSI	
	AGEP	AGES	
	PBI 	SBI

	CWHSI
	E00100
	E00200	E02650	E03280	E03270	E04470
	E04800	E17500	E17000	E18300	E18400
	E18500	E18800	E18900	E19200	E03260
	E09400	E02000	E19300	E19530 	E19700
	E19800	E20100	E20400	E20550	E20800
	E20900	E21000	E21020	E21050	E21060
	E21040	E21100	E29375	E29400	E29450
	E33420	E62100	E63000	E10300	E02400
	E02500	E01100	E25960	E25980	E25920
	E25940	E26160	E26170	E26180	E26190
	N6
	EICYB1 	EICYB2 	E29100
	E29120	E29070	E00900	E29020	E29050
	E29000	E02100	E22250	E23250	E01000
	E01200	E00600	E00300	E00400	E01700
	E26500	E00700	E00800	E01400
	E02300	E02600	E02900	E19570
	E20500	E32700	E07100	E07180
	E07200	E68000	E04600	E04100	E04200
	E04450	
	E03600
	E04500 E04800 E05100 E05800 E05700 E08795
	E09600 E01800 E01500 E01300 
	E11000 E07400 E61850
	E20200
	E53220 E07300 E53240 E08000
	E09200 E08795
	E05200
	E62600 E62700 E62800 
	E25870 
	
	E60300 E60290 E60340 E60500 
	E60550 E60680 E60720 E60840 
	E61450 E60100 E62000 E60860 
	 E60600 E60405 
	E60440 E60420 E60410 E60480 
	E61400 E60660 

	E60630 
	E60430 
	N24 
	CDOB1 	CDOB2
	E05750	E03220 E03230
	E00650 
	E18425 E18450 	
	E03150  E03300 E03400
	E03210  
	E07240
	E11070	 

	/* Demographic vars */
	DOBYR SDOBYR GENDERP GENDERS

	/* Sole prop variables */
	NAIC NAIC1 NAIC2 NAIC3 DOMC SEXPRC SXPRC1 SXPRC2 SXPRC3	
	E90020 E91020 E92020 E93020
	E90440 E91440 E92440 E93440
	E90350 E91350 E92350 E93350
	E90370 E90100

	E90470 E90200 E90290 E90190 E90445 E90570 E90550 E90165


	/* Capital gain variables */
	E22320 E40240 E40220  
	E21775 E22365 



	/* Depreciation Variables */
	E54010 E54015 E54100 E57800 E57900 E58020 E58040 E58100 E58120 E58140 E58060 E58200 E58250 E58300



	E03500

	/****** Convert names to Family panel names ***/
	RENAME=(
	REC_ID	= 	RETIDCHAR
	s002	=	issnp
	s003	=	issns
	MARS	=	MARSCHAR
	CWHSI	=	CWHSICHAR
	FLPDYR	=	TAXYRCHAR
	REJECT	=	REJECT
	STATE	=	STATECHAR
	XTOT	=	IEXEMH 
	DSI		=	IFDEPT 
	S006	=	WGT
	AGEP	=	I65INDP 
	AGES	=	I65INDS 
	XOCAH	=	CAHECHAR
	XOCAWH	=	CAFHECHAR

	E00100	=	AGIX 
	E00200	=	WAS 
	E02650	=	TOTINCX 
	E03280	=	EXMOVE_AJ  
	E03270	=	HEALSE
	E04470	=	TIDX 
	E17500	=	TTMED 
	E17000	=	DEDMED 
	E18300	=	TTSLTX 
	E18400	=	SLITX 
	E18500	=	RETX 
	E18800	=	PPTX
	E18900	=	OTSLTX
	E19200	=	TTI_DED
	E03260	=	SECADED 
	E09400	=	SECATX
	E19300	=	HMIE 
	E19530 	=	POINTS
	E19700	=	TTCON 
	E19800	=	TCASH 
	E20100	=	TNCASH 
	E20400	=	T2MISC 
	E20550	=	EBE 
	E20800	=	DEDMIS 
	E20900	=	FDGAMB 
	E21000	=	FDOTHD 
	E21020	=	FDMISC 
	E21050	=	TOTMIS 
	E21060	=	GR_TID 
	E21040	=	DISIDX 
	E21100	=	SAVBOND
	E29375	=	WAS_OAS 
	E29400	=	WASP_OAS 
	E29450	=	WASS_OAS
	E33420	=	EMPLCC 
	E62100	=	AMTIX 
	E63000	=	TAMTX 
	E10300	=	TOT_LIAB
	E02500	=	SSAGIX 
	E01100	=	CGD40
	E25960	=	APARTL 
	E25980	=	APARTG
	E25920	=	PPARTL
	E25940	=	PPARTG
	E26160	=	PSBCL
	E26170	=	PSBCG
	E26180	=	ASBCL
	E26190	=	ASBCG
	N6		=	DEPNE 
	E29100	=	SENONFP 
	E29120	=	SENONFS 
	E29070	=	SENONF 
	E00900	=	BIL 
	E29020	=	SEFARMP 
	E29050	=	SEFARMS 
	E29000	=	SEFARM 
	E02100	=	FIL
	E22250	=	NSTGL 
	E23250	=	NLTGL 
	E01000	=	CGAGIX 
	E01200	=	SUPPGL 
	E00600	=	DBE 
	E00300	=	INTST 
	E00400	=	TEXINT
	E01700	=	PTPEN
	E02000	=	SCHE 
	E26500	=	ESTU 
	E00700	=	SITR 
	E00800	=	ALIMONY 
	E01400	=	TIRAD 
	E02300	=	UCAGIX 
	E02400	=	SSINC
	E02600	=	OTHINC
	E02900	=	TTADJ 
	E19570	=	IIE
	E20500	=	TTCASU 
	E32700	=	CCECYR 
	E07100	=	TTCRX 
	E07180	=	CCCX 
	E07200	=	ELDCRX
	E68000	=	Z17
	E04600	=	EXEMX 
	E04100	=	BSD 
	E04200	=	SDADD 
	E04450	=	SDX 
	E03220 	= 	EDUCEXP
	E03230	=	TUITFEES
	E03600	=	MSA
	E61850 	= 	TTPREF
	E62600  =  	AMTEXEMPTX
	E62700	=	AMTIAEX
	E62800	=	AMTIAEEXCGX
	E03150  =   IRACONT
	E03300  = 	SEPSIMPLE
	E03400	=	EARLYWD
	E03210  =   STUDLOAN
	E07240	=	SAVCRED
	E01300	=	GRIRAD
	E01500 	=	GRPEN
	E11000	=	EICX
	E11070	=	ACTCX

	E90020 	=  SOLEGRRECEIPTC
	E91020 	=  SOLEGRRECEIPT1
	E92020	=  SOLEGRRECEIPT2
	E93020   =  SOLEGRRECEIPT3	

	E90440 	=  SOLENETINCC
	E91440 	=  SOLENETINC1
	E92440	=  SOLENETINC2
	E93440   =  SOLENETINC3

	E90370	=	SOLEWAGESC
	E90100	=	SOLEEXPC

	E90470  =   SOLELABORCOGSC
	E90200  =   SOLEEMPBENC
	E90290  =   SOLEPENPROFITC
	E90190  =   SOLEDEPRC
	E90445  =   SOLEDEPR8829C
	E90570  =   SOLEDEPRCOGSC
	E90550  =   SOLEPAYROLLCOGSC
	E90165  =   SOLECONTRLABORC

	E03500 = ALIP	
	));

	/* Keep non-rejected returns */
	if REJECT=0;

	/* Generate indicator for being sampled with probability 1 */
	HIINC = (WGT = 1);

	/* Convert possibly char variables to numbers */
	RETID = RETIDCHAR*1;
	CWHSI = CWHSICHAR*1;
	TAXYR = TAXYRCHAR*1;
	MARS = MARSCHAR*1;
	ISTATE = STATECHAR*1;
	CAHE = CAHECHAR*1;
	CAFHE = CAFHECHAR*1;
	DROP RETIDCHAR CWHSICHAR TAXYRCHAR MARSCHAR STATECHAR CAHECHAR CAFHECHAR;

	/* Create variables not in 2004 Insole */
	DOMPROD = 0;
	fileyr = 2004;

	/* Make gender variables consistent with other years */
	PGENDER = .;
	IF GENDERP = 'F' THEN PGENDER = 2;
	IF GENDERP = 'M' THEN PGENDER = 1;
	SGENDER = .;
	IF GENDERS = 'F' THEN SGENDER = 2;
	IF GENDERS = 'M' THEN SGENDER = 1;

	DROP GENDERP GENDERS;

	/* Create ID for matching with marginal tax rates */
	id = issnp;

	/* Calculate passive and active net partnership, SBC, and Scorp income */
	PARTPAS = PPARTG - PPARTL ; *E25940 - E25920;
	PARTACT = APARTG - APARTL ; *E25980 - E25960;
	PART = PARTPAS + PARTACT;
	SBC = 0;
	SCORPPAS = PSBCG - PSBCL ; *E26170 - E26160;
	SCORPACT = ASBCG - ASBCL ; *E26190 - E26180;
	SCORP = SCORPPAS + SCORPACT;

	/* Subtract off nondeductible meals and entertainment to make 
	   consistent with pre-TRA86 law (when total was deductible) */

    NDMEALENTC = E90350;
	NDMEALENT1 = E91350;
	NDMEALENT2 = E92350;
	NDMEALENT3 = E93350;

	SOLENETINCC = SOLENETINCC - NDMEALENTC;
	SOLENETINC1 = SOLENETINC1 - NDMEALENT1;
	SOLENETINC2 = SOLENETINC2 - NDMEALENT2;
	SOLENETINC3 = SOLENETINC3 - NDMEALENT3;

	DROP E90350 E91350 E92350 E93350;


	/* Sole prop gain (plus gains from other forms) */
	SOLEGAINPLUS = E22320;
	DROP E22320;

	SOLEGAIN = MAX(E40240, 0);
	DROP E40240;

	SOLEGAINALT = E40220;
	DROP E40220; 

	/* Partnership and scorp gain */
	PARTSCORPGAIN = E21775 + E22365;
	DROP E21775 E22365;

	/* Make gender variables consistent with other years */
	PGENDER = .;
	IF GENDERP = 'F' THEN PGENDER = 2;
	IF GENDERP = 'M' THEN PGENDER = 1;
	SGENDER = .;
	IF GENDERS = 'F' THEN SGENDER = 2;
	IF GENDERS = 'M' THEN SGENDER = 1;

	DROP GENDERP GENDERS;

	/* Calculate adjusted total income */
	ptpexc = max(grpen - ptpen, 0);
	iraexc = max(grirad - tirad, 0);
	ssexc = max(ssinc - ssagix, 0);

	ADJTOTINC = totincx + texint + iraexc + ptpexc + ssexc;


RUN;    


/* 2005 INSOLE */

  PROC CONTENTS DATA=SUBG.INSOLE05;
    TITLE "Contents of Insole";
  RUN;

/* Pull subset of data */

DATA SUBSUB.INSOLE05SUBSET (COMPRESS=YES);
    SET SUBG.INSOLE05(KEEP=
	
	REC_ID MARS FLPDYR REJECT
	STATE XOCAH  XOCAWH
	S002 S003	S006
	MARS
	XTOT	STATE	DSI	
	AGEP	AGES	
	PBI 	SBI

	DOBYR
	CWHSI
	E00100
	E00200	E02650	E03280	E03270	E04470
	E04800	E17500	E17000	E18300	E18400
	E18500	E18800	E18900	E19200	E03260
	E09400	E02000	E19300	E19530 	E19700
	E19800	E20100	E20400	E20550	E20800
	E20900	E21000	E21020	E21050	E21060
	E21040	E21100	E29375	E29400	E29450
	E33420	E62100	E63000	E10300	E02400
	E02500	E01100	E25960	E25980	E25920
	E25940	E26160	E26170	E26180	E26190
	N6
	EICYB1 	EICYB2 	E29100
	E29120	E29070	E00900	E29020	E29050
	E29000	E02100	E22250	E23250	E01000
	E01200	E00600	E00300	E00400	E01700
	E26500	E00700	E00800	E01400
	E02300	E02600	E02900	E19570
	E20500	E32700	E07100	E07180
	E07200	E68000	E04600	E04100	E04200
	E04450	
	E03600
	E04500 E04800 E05100 E05800 E05700 E08795
	E09600 E01800 E01500 E01300 
	E11000 E07400 E61850
	E20200
	E53220 E07300 E53240 E08000
	E09200 E08795
	E05200
	E62600 E62700 E62800 
	E25870 
	
	E60300 E60290 E60340 E60500 
	E60550 E60680 E60720 E60840 
	E61450 E60100 E62000 E60860 
	 E60600 E60405 
	E60440 E60420 E60410 E60480 
	E61400 E60660 

	E60630 
	E60430 
	N24 
	CDOB1 	CDOB2
	E05750	E03220 E03230
	E00650 
	E18425 E18450 	
	E03150  E03300 E03400
	E03210  E03240 
	E07240
	E11070	 

	/* Demographic vars */
	DOBYR SDOBYR GENDERP GENDERS

	/* Sole prop variables */
	NAIC NAIC1 NAIC2 NAIC3 DOMC SEXPRC SXPRC1 SXPRC2 SXPRC3	
	E90020 E91020 E92020 E93020
	E90440 E91440 E92440 E93440
	E90355 E91355 E92355 E93355
	E90370 E90100

	E90470 E90200 E90290 E90190 E90445 E90570 E90550 E90165



	/* Capital gain variables */
	E22320 E40240 E40220  
	E21775 E22365 


	/* Depreciation Variables */
	E54010 E54015 E54100 E57800 E57900 E58020 E58040 E58100 E58120 E58140 E58060 E58200 E58250 E58300


	E03500

	/****** Convert names to Family panel names ***/
	RENAME=(
	REC_ID	= 	RETIDCHAR
	s002	=	issnp
	s003	=	issns
	MARS	=	MARSCHAR
	CWHSI	=	CWHSICHAR
	FLPDYR	=	TAXYRCHAR
	REJECT	=	REJECT
	STATE	=	STATECHAR
	XTOT	=	IEXEMH 
	DSI		=	IFDEPT 
	S006	=	WGT
	AGEP	=	I65INDP 
	AGES	=	I65INDS 
	XOCAH	=	CAHECHAR
	XOCAWH	=	CAFHECHAR

	E00100	=	AGIX 
	E00200	=	WAS 
	E02650	=	TOTINCX 
	E03280	=	EXMOVE_AJ  
	E03270	=	HEALSE
	E04470	=	TIDX 
	E17500	=	TTMED 
	E17000	=	DEDMED 
	E18300	=	TTSLTX 
	E18400	=	SLITX 
	E18500	=	RETX 
	E18800	=	PPTX
	E18900	=	OTSLTX
	E19200	=	TTI_DED
	E03260	=	SECADED 
	E09400	=	SECATX
	E19300	=	HMIE 
	E19530 	=	POINTS
	E19700	=	TTCON 
	E19800	=	TCASH 
	E20100	=	TNCASH 
	E20400	=	T2MISC 
	E20550	=	EBE 
	E20800	=	DEDMIS 
	E20900	=	FDGAMB 
	E21000	=	FDOTHD 
	E21020	=	FDMISC 
	E21050	=	TOTMIS 
	E21060	=	GR_TID 
	E21040	=	DISIDX 
	E21100	=	SAVBOND
	E29375	=	WAS_OAS 
	E29400	=	WASP_OAS 
	E29450	=	WASS_OAS
	E33420	=	EMPLCC 
	E62100	=	AMTIX 
	E63000	=	TAMTX 
	E10300	=	TOT_LIAB
	E02500	=	SSAGIX 
	E01100	=	CGD40
	E25960	=	APARTL 
	E25980	=	APARTG
	E25920	=	PPARTL
	E25940	=	PPARTG
	E26160	=	PSBCL
	E26170	=	PSBCG
	E26180	=	ASBCL
	E26190	=	ASBCG
	N6		=	DEPNE 
	E29100	=	SENONFP 
	E29120	=	SENONFS 
	E29070	=	SENONF 
	E00900	=	BIL 
	E29020	=	SEFARMP 
	E29050	=	SEFARMS 
	E29000	=	SEFARM 
	E02100	=	FIL
	E22250	=	NSTGL 
	E23250	=	NLTGL 
	E01000	=	CGAGIX 
	E01200	=	SUPPGL 
	E00600	=	DBE 
	E00300	=	INTST 
	E00400	=	TEXINT
	E01700	=	PTPEN
	E02000	=	SCHE 
	E26500	=	ESTU 
	E00700	=	SITR 
	E00800	=	ALIMONY 
	E01400	=	TIRAD 
	E02300	=	UCAGIX 
	E02400	=	SSINC
	E02600	=	OTHINC
	E02900	=	TTADJ 
	E19570	=	IIE
	E20500	=	TTCASU 
	E32700	=	CCECYR 
	E07100	=	TTCRX 
	E07180	=	CCCX 
	E07200	=	ELDCRX
	E68000	=	Z17
	E04600	=	EXEMX 
	E04100	=	BSD 
	E04200	=	SDADD 
	E04450	=	SDX 
	E03220 	= 	EDUCEXP
	E03230	=	TUITFEES
	E03600	=	MSA
	E61850 	= 	TTPREF
	E62600  =  	AMTEXEMPTX
	E62700	=	AMTIAEX
	E62800	=	AMTIAEEXCGX
	E03150  =   IRACONT
	E03300  = 	SEPSIMPLE
	E03400	=	EARLYWD
	E03210  =   STUDLOAN
	E03240  =   DOMPROD
	E07240	=	SAVCRED	
	E01300	=	GRIRAD
	E01500 	=	GRPEN
	E11000	=	EICX
	E11070	=	ACTCX

	E90020 	=  SOLEGRRECEIPTC
	E91020 	=  SOLEGRRECEIPT1
	E92020	=  SOLEGRRECEIPT2
	E93020   =  SOLEGRRECEIPT3	

	E90440 	=  SOLENETINCC
	E91440 	=  SOLENETINC1
	E92440	=  SOLENETINC2
	E93440   =  SOLENETINC3

	E90370	=	SOLEWAGESC
	E90100	=	SOLEEXPC

	E90470  =   SOLELABORCOGSC
	E90200  =   SOLEEMPBENC
	E90290  =   SOLEPENPROFITC
	E90190  =   SOLEDEPRC
	E90445  =   SOLEDEPR8829C
	E90570  =   SOLEDEPRCOGSC
	E90550  =   SOLEPAYROLLCOGSC
	E90165  =   SOLECONTRLABORC


	E03500 = ALIP
	) 

	);

	/* Keep non-rejected returns */
	if REJECT=0;

	/* Generate indicator for being sampled with probability 1 */
	HIINC = (WGT = 1);

	/* Convert possibly char variables to numbers */
	RETID = RETIDCHAR*1;
	CWHSI = CWHSICHAR*1;
	TAXYR = TAXYRCHAR*1;
	MARS = MARSCHAR*1;
	ISTATE = STATECHAR*1;
	CAHE = CAHECHAR*1;
	CAFHE = CAFHECHAR*1;
	DROP RETIDCHAR CWHSICHAR TAXYRCHAR MARSCHAR STATECHAR CAHECHAR CAFHECHAR;

	/* Make gender variables consistent with other years */
	PGENDER = .;
	IF GENDERP = 'F' THEN PGENDER = 2;
	IF GENDERP = 'M' THEN PGENDER = 1;
	SGENDER = .;
	IF GENDERS = 'F' THEN SGENDER = 2;
	IF GENDERS = 'M' THEN SGENDER = 1;

	DROP GENDERP GENDERS;

	/* Create variables not in 2005 Insole */
	fileyr = 2005;

	/* Create ID for matching with marginal tax rates */
	id = issnp;

/* Calculate passive and active net partnership, SBC, and Scorp income */
	PARTPAS = PPARTG - PPARTL ; *E25940 - E25920;
	PARTACT = APARTG - APARTL ; *E25980 - E25960;
	PART = PARTPAS + PARTACT;
	SBC = 0;
	SCORPPAS = PSBCG - PSBCL ; *E26170 - E26160;
	SCORPACT = ASBCG - ASBCL ; *E26190 - E26180;
	SCORP = SCORPPAS + SCORPACT;

	/* Subtract off nondeductible meals and entertainment to make 
	   consistent with pre-TRA86 law (when total was deductible) */

    NDMEALENTC = .5*E90355;
	NDMEALENT1 = .5*E91355;
	NDMEALENT2 = .5*E92355;
	NDMEALENT3 = .5*E93355;

	SOLENETINCC = SOLENETINCC - NDMEALENTC;
	SOLENETINC1 = SOLENETINC1 - NDMEALENT1;
	SOLENETINC2 = SOLENETINC2 - NDMEALENT2;
	SOLENETINC3 = SOLENETINC3 - NDMEALENT3;

	DROP E90355 E91355 E92355 E93355;

	/* Sole prop gain (plus gains from other forms) */
	SOLEGAINPLUS = E22320;
	DROP E22320;

	SOLEGAIN = MAX(E40240, 0);
	DROP E40240;

	SOLEGAINALT = E40220;
	DROP E40220; 

	/* Partnership and scorp gain */
	PARTSCORPGAIN = E21775 + E22365;
	DROP E21775 E22365;

	/* Make gender variables consistent with other years */
	PGENDER = .;
	IF GENDERP = 'F' THEN PGENDER = 2;
	IF GENDERP = 'M' THEN PGENDER = 1;
	SGENDER = .;
	IF GENDERS = 'F' THEN SGENDER = 2;
	IF GENDERS = 'M' THEN SGENDER = 1;

	DROP GENDERP GENDERS;

	/* Calculate adjusted total income */
	ptpexc = max(grpen - ptpen, 0);
	iraexc = max(grirad - tirad, 0);
	ssexc = max(ssinc - ssagix, 0);

	ADJTOTINC = totincx + texint + iraexc + ptpexc + ssexc;


RUN;    



/* 2006 INSOLE */

  PROC CONTENTS DATA=SUBG.INSOLE06;
    TITLE "Contents of Insole";
  RUN;


/* Pull subset of data */

DATA SUBSUB.INSOLE06SUBSET (COMPRESS=YES);
    SET SUBG.INSOLE06(KEEP=
	
	REC_ID MARS FLPDYR REJECT
	STATE XOCAH  XOCAWH
	S002 S003	S006
	MARS
	XTOT	STATE	DSI	
	AGEP	AGES	
	PBI 	SBI

	DOBYR
	CWHSI
	E00100
	E00200	E02650	E03280	E03270	E04470
	E04800	E17500	E17000	E18300	E18400
	E18500	E18800	E18900	E19200	E03260
	E09400	E02000	E19300	E19530 	E19700
	E19800	E20100	E20400	E20550	E20800
	E20900	E21000	E21020	E21050	E21060
	E21040	E21100	E29375	E29400	E29450
	E33420	E62100	E63000	E10300	E02400
	E02500	E01100	E25960	E25980	E25920
	E25940	E26160	E26170	E26180	E26190
	N6
	EICYB1 	EICYB2 	E29100
	E29120	E29070	E00900	E29020	E29050
	E29000	E02100	E22250	E23250	E01000
	E01200	E00600	E00300	E00400	E01700
	E26500	E00700	E00800	E01400
	E02300	E02600	E02900	E19570
	E20500	E32700	E07100	E07180
	E07200	E68000	E04600	E04100	E04200
	E04450	
	E03600
	E04500 E04800 E05100 E05800 E05700 E08795
	E09600 E01800 E01500 E01300 
	E11000 E07400 E61850
	E20200
	E53220 E07300 E53240 E08000
	E09200 E08795
	E05200
	E62600 E62700 E62800 
	E25870 
	
	E60300 E60290 E60340 E60500 
	E60550 E60680 E60720 E60840 
	E61450 E60100 E62000 E60860 
	 E60600 E60405 
	E60440 E60420 E60410 E60480 
	E61400 E60660 

	E60630 
	E60430 
	N24 
	CDOB1 	CDOB2
	E05750	E03220 E03230
	E00650 
	E18425 E18450 	
	E03150  E03300 E03400
	E03210  E03240 
	E07240
	E11070	 

	/* Demographic vars */
	DOBYR SDOBYR GENDERP GENDERS

	/* Sole prop variables */
	NAIC NAIC1 NAIC2 NAIC3 DOMC SEXPRC SXPRC1 SXPRC2 SXPRC3	
	E90020 E91020 E92020 E93020
	E90440 E91440 E92440 E93440
	E90355 E91355 E92355 E93355
	E90370 E90100

	E90470 E90200 E90290 E90190 E90445 E90570 E90550 E90165

	/* Capital gain variables */
	E22320 E40240 E40220  
	E21775 E22365 



	/* Depreciation Variables */
	E54010 E54015 E54100 E57800 E57900 E58020 E58040 E58100 E58120 E58140 E58060 E58200 E58250 E58300



	E03500

	/****** Convert names to Family panel names ***/
	RENAME=(
	REC_ID	= 	RETIDCHAR
	s002	=	issnp
	s003	=	issns
	MARS	=	MARSCHAR
	CWHSI	=	CWHSICHAR
	FLPDYR	=	TAXYRCHAR
	REJECT	=	REJECT
	STATE	=	STATECHAR
	XTOT	=	IEXEMH 
	DSI		=	IFDEPT 
	S006	=	WGT
	AGEP	=	I65INDP 
	AGES	=	I65INDS 
	XOCAH	=	CAHECHAR
	XOCAWH	=	CAFHECHAR

	E00100	=	AGIX 
	E00200	=	WAS 
	E02650	=	TOTINCX 
	E03280	=	EXMOVE_AJ  
	E03270	=	HEALSE
	E04470	=	TIDX 
	E17500	=	TTMED 
	E17000	=	DEDMED 
	E18300	=	TTSLTX 
	E18400	=	SLITX 
	E18500	=	RETX 
	E18800	=	PPTX
	E18900	=	OTSLTX
	E19200	=	TTI_DED
	E03260	=	SECADED 
	E09400	=	SECATX
	E19300	=	HMIE 
	E19530 	=	POINTS
	E19700	=	TTCON 
	E19800	=	TCASH 
	E20100	=	TNCASH 
	E20400	=	T2MISC 
	E20550	=	EBE 
	E20800	=	DEDMIS 
	E20900	=	FDGAMB 
	E21000	=	FDOTHD 
	E21020	=	FDMISC 
	E21050	=	TOTMIS 
	E21060	=	GR_TID 
	E21040	=	DISIDX 
	E21100	=	SAVBOND
	E29375	=	WAS_OAS 
	E29400	=	WASP_OAS 
	E29450	=	WASS_OAS
	E33420	=	EMPLCC 
	E62100	=	AMTIX 
	E63000	=	TAMTX 
	E10300	=	TOT_LIAB
	E02500	=	SSAGIX 
	E01100	=	CGD40
	E25960	=	APARTL 
	E25980	=	APARTG
	E25920	=	PPARTL
	E25940	=	PPARTG
	E26160	=	PSBCL
	E26170	=	PSBCG
	E26180	=	ASBCL
	E26190	=	ASBCG
	N6		=	DEPNE 
	E29100	=	SENONFP 
	E29120	=	SENONFS 
	E29070	=	SENONF 
	E00900	=	BIL 
	E29020	=	SEFARMP 
	E29050	=	SEFARMS 
	E29000	=	SEFARM 
	E02100	=	FIL
	E22250	=	NSTGL 
	E23250	=	NLTGL 
	E01000	=	CGAGIX 
	E01200	=	SUPPGL 
	E00600	=	DBE 
	E00300	=	INTST 
	E00400	=	TEXINT
	E01700	=	PTPEN
	E02000	=	SCHE 
	E26500	=	ESTU 
	E00700	=	SITR 
	E00800	=	ALIMONY 
	E01400	=	TIRAD 
	E02300	=	UCAGIX 
	E02400	=	SSINC
	E02600	=	OTHINC
	E02900	=	TTADJ 
	E19570	=	IIE
	E20500	=	TTCASU 
	E32700	=	CCECYR 
	E07100	=	TTCRX 
	E07180	=	CCCX 
	E07200	=	ELDCRX
	E68000	=	Z17
	E04600	=	EXEMX 
	E04100	=	BSD 
	E04200	=	SDADD 
	E04450	=	SDX 
	E03220 	= 	EDUCEXP
	E03230	=	TUITFEES
	E03600	=	MSA
	E61850 	= 	TTPREF
	E62600  =  	AMTEXEMPTX
	E62700	=	AMTIAEX
	E62800	=	AMTIAEEXCGX	
	E03150  =   IRACONT
	E03300  = 	SEPSIMPLE
	E03400	=	EARLYWD
	E03210  =   STUDLOAN
	E03240  =   DOMPROD
	E07240	=	SAVCRED	
	E01300	=	GRIRAD
	E01500 	=	GRPEN
	E11000	=	EICX
	E11070	=	ACTCX

	E90020 	=  SOLEGRRECEIPTC
	E91020 	=  SOLEGRRECEIPT1
	E92020	=  SOLEGRRECEIPT2
	E93020   =  SOLEGRRECEIPT3	

	E90440 	=  SOLENETINCC
	E91440 	=  SOLENETINC1
	E92440	=  SOLENETINC2
	E93440   =  SOLENETINC3

	E90370	=	SOLEWAGESC
	E90100	=	SOLEEXPC

	E90470  =   SOLELABORCOGSC
	E90200  =   SOLEEMPBENC
	E90290  =   SOLEPENPROFITC
	E90190  =   SOLEDEPRC
	E90445  =   SOLEDEPR8829C
	E90570  =   SOLEDEPRCOGSC
	E90550  =   SOLEPAYROLLCOGSC
	E90165  =   SOLECONTRLABORC


	E03500 = ALIP
	) 

	);

	/* Keep non-rejected returns */
	if REJECT=0;

	/* Generate indicator for being sampled with probability 1 */
	HIINC = (WGT = 1);

	/* Convert possibly char variables to numbers */
	RETID = RETIDCHAR*1;
	CWHSI = CWHSICHAR*1;
	TAXYR = TAXYRCHAR*1;
	MARS = MARSCHAR*1;
	ISTATE = STATECHAR*1;
	CAHE = CAHECHAR*1;
	CAFHE = CAFHECHAR*1;
	DROP RETIDCHAR CWHSICHAR TAXYRCHAR MARSCHAR STATECHAR CAHECHAR CAFHECHAR;

	/* Create variables not in 2006 Insole */
	fileyr = 2006;

	/* Calculate passive and active net partnership, SBC, and Scorp income */
	PARTPAS = PPARTG - PPARTL ; *E25940 - E25920;
	PARTACT = APARTG - APARTL ; *E25980 - E25960;
	PART = PARTPAS + PARTACT;
	SBC = 0;
	SCORPPAS = PSBCG - PSBCL ; *E26170 - E26160;
	SCORPACT = ASBCG - ASBCL ; *E26190 - E26180;
	SCORP = SCORPPAS + SCORPACT;

	/* Subtract off nondeductible meals and entertainment to make 
	   consistent with pre-TRA86 law (when total was deductible) */

    NDMEALENTC = .5*E90355;
	NDMEALENT1 = .5*E91355;
	NDMEALENT2 = .5*E92355;
	NDMEALENT3 = .5*E93355;

	SOLENETINCC = SOLENETINCC - NDMEALENTC;
	SOLENETINC1 = SOLENETINC1 - NDMEALENT1;
	SOLENETINC2 = SOLENETINC2 - NDMEALENT2;
	SOLENETINC3 = SOLENETINC3 - NDMEALENT3;

	DROP E90355 E91355 E92355 E93355;

	/* Sole prop gain (plus gains from other forms) */
	SOLEGAINPLUS = E22320;
	DROP E22320;

	SOLEGAIN = MAX(E40240, 0);
	DROP E40240;

	SOLEGAINALT = E40220;
	DROP E40220; 

	/* Partnership and scorp gain */
	PARTSCORPGAIN = E21775 + E22365;
	DROP E21775 E22365;

	/* Make gender variables consistent with other years */
	PGENDER = .;
	IF GENDERP = 'F' THEN PGENDER = 2;
	IF GENDERP = 'M' THEN PGENDER = 1;
	SGENDER = .;
	IF GENDERS = 'F' THEN SGENDER = 2;
	IF GENDERS = 'M' THEN SGENDER = 1;

	DROP GENDERP GENDERS;

	/* Calculate adjusted total income */
	ptpexc = max(grpen - ptpen, 0);
	iraexc = max(grirad - tirad, 0);
	ssexc = max(ssinc - ssagix, 0);

	ADJTOTINC = totincx + texint + iraexc + ptpexc + ssexc;


	/* Make gender variables consistent with other years */
	PGENDER = .;
	IF GENDERP = 'F' THEN PGENDER = 2;
	IF GENDERP = 'M' THEN PGENDER = 1;
	SGENDER = .;
	IF GENDERS = 'F' THEN SGENDER = 2;
	IF GENDERS = 'M' THEN SGENDER = 1;

	DROP GENDERP GENDERS;


	/* Create ID for matching with marginal tax rates */
	id = issnp;

RUN;    



/* 2007 INSOLE */

  PROC CONTENTS DATA=SUBG.INSOLE07;
    TITLE "Contents of Insole";
  RUN;


/* Pull subset of data */

DATA SUBSUB.INSOLE07SUBSET (COMPRESS=YES);
    SET SUBG.INSOLE07(KEEP=
	
	REC_ID MARS FLPDYR REJECT
	STATE XOCAH  XOCAWH
	S002 S003	S006
	MARS
	XTOT	STATE	DSI	
	AGEP	AGES	
	PBI 	SBI

	DOBYR
	CWHSI
	E00100
	E00200	E02650	E03280	E03270	E04470
	E04800	E17500	E17000	E18300	E18400
	E18500	E18800	E18900	E19200	E03260
	E09400	E02000	E19300	E19530 	E19700
	E19800	E20100	E20400	E20550	E20800
	E20900	E21000	E21020	E21050	E21060
	E21040	E21100	E29375	E29400	E29450
	E33420	E62100	E63000	E10300	E02400
	E02500	E01100	E25960	E25980	E25920
	E25940	E26160	E26170	E26180	E26190
	N6
	EICYB1 	EICYB2 	E29100
	E29120	E29070	E00900	E29020	E29050
	E29000	E02100	E22250	E23250	E01000
	E01200	E00600	E00300	E00400	E01700
	E26500	E00700	E00800	E01400
	E02300	E02600	E02900	E19570
	E20500	E32700	E07100	E07180
	E07200	E68000	E04600	E04100	E04200
	E04450	
	E03600
	E04500 E04800 E05100 E05800 E05700 E08795
	E09600 E01800 E01500 E01300 
	E11000 E07400 E61850
	E20200
	E53220 E07300 E53240 E08000
	E09200 E08795
	E05200
	E62600 E62700 E62800 
	E25870 
	
	E60300 E60290 E60340 E60500 
	E60550 E60680 E60720 E60840 
	E61450 E60100 E62000 E60860 
	 E60600 E60405 
	E60440 E60420 E60410 E60480 
	E61400 E60660 

	E60630 
	E60430 
	N24 
	CDOB1 	CDOB2
	E05750	E03220 E03230
	E00650 
	E18425 E18450 	
	E03150  E03300 E03400
	E03210  E03240 
	E07240
	E11070	 

	/* Demographic vars */
	DOBYR SDOBYR GENDERP GENDERS

	/* Sole prop variables */
	NAIC NAIC1 NAIC2 NAIC3 DOMC SEXPRC SXPRC1 SXPRC2 SXPRC3	
	E90020 E91020 E92020 E93020
	E90440 E91440 E92440 E93440
	E90355 E91355 E92355 E93355
	E90370 E90100

	E90470 E90200 E90290 E90190 E90445 E90570 E90550 E90165

	/* Capital gain variables */
	E22320 E40240 E40220  
	E21775 E22365 


	/* Depreciation Variables */
	E54010 E54015 E54100 E57800 E57900 E58020 E58040 E58100 E58120 E58140 E58060 E58200 E58250 E58300



	E03500 

	/****** Convert names to Family panel names ***/
	RENAME=(
	REC_ID	= 	RETIDCHAR
	s002	=	issnp
	s003	=	issns
	MARS	=	MARSCHAR
	CWHSI	=	CWHSICHAR
	FLPDYR	=	TAXYRCHAR
	REJECT	=	REJECT
	STATE	=	STATECHAR
	XTOT	=	IEXEMH 
	DSI		=	IFDEPT 
	S006	=	WGT
	AGEP	=	I65INDP 
	AGES	=	I65INDS 
	XOCAH	=	CAHECHAR
	XOCAWH	=	CAFHECHAR

	E00100	=	AGIX 
	E00200	=	WAS 
	E02650	=	TOTINCX 
	E03280	=	EXMOVE_AJ  
	E03270	=	HEALSE
	E04470	=	TIDX 
	E17500	=	TTMED 
	E17000	=	DEDMED 
	E18300	=	TTSLTX 
	E18400	=	SLITX 
	E18500	=	RETX 
	E18800	=	PPTX
	E18900	=	OTSLTX
	E19200	=	TTI_DED
	E03260	=	SECADED 
	E09400	=	SECATX
	E19300	=	HMIE 
	E19530 	=	POINTS
	E19700	=	TTCON 
	E19800	=	TCASH 
	E20100	=	TNCASH 
	E20400	=	T2MISC 
	E20550	=	EBE 
	E20800	=	DEDMIS 
	E20900	=	FDGAMB 
	E21000	=	FDOTHD 
	E21020	=	FDMISC 
	E21050	=	TOTMIS 
	E21060	=	GR_TID 
	E21040	=	DISIDX 
	E21100	=	SAVBOND
	E29375	=	WAS_OAS 
	E29400	=	WASP_OAS 
	E29450	=	WASS_OAS
	E33420	=	EMPLCC 
	E62100	=	AMTIX 
	E63000	=	TAMTX 
	E10300	=	TOT_LIAB
	E02500	=	SSAGIX 
	E01100	=	CGD40
	E25960	=	APARTL 
	E25980	=	APARTG
	E25920	=	PPARTL
	E25940	=	PPARTG
	E26160	=	PSBCL
	E26170	=	PSBCG
	E26180	=	ASBCL
	E26190	=	ASBCG
	N6		=	DEPNE 
	E29100	=	SENONFP 
	E29120	=	SENONFS 
	E29070	=	SENONF 
	E00900	=	BIL 
	E29020	=	SEFARMP 
	E29050	=	SEFARMS 
	E29000	=	SEFARM 
	E02100	=	FIL
	E22250	=	NSTGL 
	E23250	=	NLTGL 
	E01000	=	CGAGIX 
	E01200	=	SUPPGL 
	E00600	=	DBE 
	E00300	=	INTST 
	E00400	=	TEXINT
	E01700	=	PTPEN
	E02000	=	SCHE 
	E26500	=	ESTU 
	E00700	=	SITR 
	E00800	=	ALIMONY 
	E01400	=	TIRAD 
	E02300	=	UCAGIX 
	E02400	=	SSINC
	E02600	=	OTHINC
	E02900	=	TTADJ 
	E19570	=	IIE
	E20500	=	TTCASU 
	E32700	=	CCECYR 
	E07100	=	TTCRX 
	E07180	=	CCCX 
	E07200	=	ELDCRX
	E68000	=	Z17
	E04600	=	EXEMX 
	E04100	=	BSD 
	E04200	=	SDADD 
	E04450	=	SDX 
	E03220 	= 	EDUCEXP
	E03230	=	TUITFEES
	E03600	=	MSA
	E61850 	= 	TTPREF
	E62600  =  	AMTEXEMPTX
	E62700	=	AMTIAEX
	E62800	=	AMTIAEEXCGX	
	E03150  =   IRACONT
	E03300  = 	SEPSIMPLE
	E03400	=	EARLYWD
	E03210  =   STUDLOAN
	E03240  =   DOMPROD
	E07240	=	SAVCRED	
	E01300	=	GRIRAD
	E01500 	=	GRPEN
	E11000	=	EICX
	E11070	=	ACTCX

	E90020 	=  SOLEGRRECEIPTC
	E91020 	=  SOLEGRRECEIPT1
	E92020	=  SOLEGRRECEIPT2
	E93020   =  SOLEGRRECEIPT3	

	E90440 	=  SOLENETINCC
	E91440 	=  SOLENETINC1
	E92440	=  SOLENETINC2
	E93440   =  SOLENETINC3

	E90370	=	SOLEWAGESC
	E90100	=	SOLEEXPC

	E90470  =   SOLELABORCOGSC
	E90200  =   SOLEEMPBENC
	E90290  =   SOLEPENPROFITC
	E90190  =   SOLEDEPRC
	E90445  =   SOLEDEPR8829C
	E90570  =   SOLEDEPRCOGSC
	E90550  =   SOLEPAYROLLCOGSC
	E90165  =   SOLECONTRLABORC


	E03500 = ALIP
	) 

	);

	/* Keep non-rejected returns */
	if REJECT=0;

	/* Generate indicator for being sampled with probability 1 */
	HIINC = (WGT = 1);

	/* Convert possibly char variables to numbers */
	RETID = RETIDCHAR*1;
	CWHSI = CWHSICHAR*1;
	TAXYR = TAXYRCHAR*1;
	MARS = MARSCHAR*1;
	ISTATE = STATECHAR*1;
	CAHE = CAHECHAR*1;
	CAFHE = CAFHECHAR*1;
	DROP RETIDCHAR CWHSICHAR TAXYRCHAR MARSCHAR STATECHAR CAHECHAR CAFHECHAR;

	/* Create variables not in 2007 Insole */
	fileyr = 2007;

	/* Make gender variables consistent with other years */
	PGENDER = .;
	IF GENDERP = 'F' THEN PGENDER = 2;
	IF GENDERP = 'M' THEN PGENDER = 1;
	SGENDER = .;
	IF GENDERS = 'F' THEN SGENDER = 2;
	IF GENDERS = 'M' THEN SGENDER = 1;

	DROP GENDERP GENDERS;


	/* Create ID for matching with marginal tax rates */
	id = issnp;

/* Calculate passive and active net partnership, SBC, and Scorp income */
	PARTPAS = PPARTG - PPARTL ; *E25940 - E25920;
	PARTACT = APARTG - APARTL ; *E25980 - E25960;
	PART = PARTPAS + PARTACT;
	SBC = 0;
	SCORPPAS = PSBCG - PSBCL ; *E26170 - E26160;
	SCORPACT = ASBCG - ASBCL ; *E26190 - E26180;
	SCORP = SCORPPAS + SCORPACT;

	/* Subtract off nondeductible meals and entertainment to make 
	   consistent with pre-TRA86 law (when total was deductible) */

    NDMEALENTC = .5*E90355;
	NDMEALENT1 = .5*E91355;
	NDMEALENT2 = .5*E92355;
	NDMEALENT3 = .5*E93355;

	SOLENETINCC = SOLENETINCC - NDMEALENTC;
	SOLENETINC1 = SOLENETINC1 - NDMEALENT1;
	SOLENETINC2 = SOLENETINC2 - NDMEALENT2;
	SOLENETINC3 = SOLENETINC3 - NDMEALENT3;

	DROP E90355 E91355 E92355 E93355;

	/* Sole prop gain (plus gains from other forms) */
	SOLEGAINPLUS = E22320;
	DROP E22320;

	SOLEGAIN = MAX(E40240, 0);
	DROP E40240;

	SOLEGAINALT = E40220;
	DROP E40220; 

	/* Partnership and scorp gain */
	PARTSCORPGAIN = E21775 + E22365;
	DROP E21775 E22365;

	/* Make gender variables consistent with other years */
	PGENDER = .;
	IF GENDERP = 'F' THEN PGENDER = 2;
	IF GENDERP = 'M' THEN PGENDER = 1;
	SGENDER = .;
	IF GENDERS = 'F' THEN SGENDER = 2;
	IF GENDERS = 'M' THEN SGENDER = 1;

	DROP GENDERP GENDERS;

	/* Calculate adjusted total income */
	ptpexc = max(grpen - ptpen, 0);
	iraexc = max(grirad - tirad, 0);
	ssexc = max(ssinc - ssagix, 0);

	ADJTOTINC = totincx + texint + iraexc + ptpexc + ssexc;


RUN;    


/* 2008 INSOLE */

  PROC CONTENTS DATA=SUBG.INSOLE08;
    TITLE "Contents of Insole";
  RUN;


/* Pull subset of data */

DATA SUBSUB.INSOLE08SUBSET (COMPRESS=YES);
    SET SUBG.INSOLE08(KEEP=
	
	REC_ID MARS FLPDYR REJECT
	STATE XOCAH  XOCAWH
	S002 S003	S006
	MARS
	XTOT	STATE	DSI	
	AGEP	AGES	
	PBI 	SBI

	DOBYR
	CWHSI
	E00100
	E00200	E02650	E03280	E03270	E04470
	E04800	E17500	E17000	E18300	E18400
	E18500	E18800	E18900	E19200	E03260
	E09400	E02000	E19300	E19530 	E19700
	E19800	E20100	E20400	E20550	E20800
	E20900	E21000	E21020	E21050	E21060
	E21040	E21100	E29375	E29400	E29450
	E33420	E62100	E63000	E10300	E02400
	E02500	E01100	E25960	E25980	E25920
	E25940	E26160	E26170	E26180	E26190
	N6
	EICYB1 	EICYB2 	E29100
	E29120	E29070	E00900	E29020	E29050
	E29000	E02100	E22250	E23250	E01000
	E01200	E00600	E00300	E00400	E01700
	E26500	E00700	E00800	E01400
	E02300	E02600	E02900	E19570
	E20500	E32700	E07100	E07180
	E07200	E68000	E04600	E04100	E04200
	E04450	
	E03600
	E04500 E04800 E05100 E05800 E05700 E08795
	E09600 E01800 E01500 E01300 
	E11000 E07400 E61850
	E20200
	E53220 E07300 E53240 E08000
	E09200 E08795
	E05200
	E62600 E62700 E62800 
	E25870 
	
	E60300 E60290 E60340 E60500 
	E60550 E60680 E60720 E60840 
	E61450 E60100 E62000 E60860 
	 E60600 E60405 
	E60440 E60420 E60410 E60480 
	E61400 E60660 

	E60630 
	E60430 
	N24 
	CDOB1 	CDOB2
	E05750	E03220 E03230
	E00650 
	E18425 E18450 	
	E03150  E03300 E03400
	E03210  E03240 
	E07240
	E11070	 

	/* Demographic vars */
	DOBYR SDOBYR GENDERP GENDERS

	/* Sole prop variables */
	NAIC NAIC1 NAIC2 NAIC3 DOMC SEXPRC SXPRC1 SXPRC2 SXPRC3	
	E90020 E91020 E92020 E93020
	E90440 E91440 E92440 E93440
	E90355 E91355 E92355 E93355
	E90370 E90100

	E90470 E90200 E90290 E90190 E90445 E90570 E90550 E90165

	/* Capital gain variables */
	E22320 E40240 E40220  
	E21775 E22365 


	/* Depreciation Variables */
	E54010 E54015 E54100 E57800 E57900 E58020 E58040 E58100 E58120 E58140 E58060 E58200 E58250 E58300




	E03500

	/****** Convert names to Family panel names ***/
	RENAME=(
	REC_ID	= 	RETIDCHAR
	s002	=	issnp
	s003	=	issns
	MARS	=	MARSCHAR
	CWHSI	=	CWHSICHAR
	FLPDYR	=	TAXYRCHAR
	REJECT	=	REJECT
	STATE	=	STATECHAR
	XTOT	=	IEXEMH 
	DSI		=	IFDEPT 
	S006	=	WGT
	AGEP	=	I65INDP 
	AGES	=	I65INDS 
	XOCAH	=	CAHECHAR
	XOCAWH	=	CAFHECHAR

	E00100	=	AGIX 
	E00200	=	WAS 
	E02650	=	TOTINCX 
	E03280	=	EXMOVE_AJ  
	E03270	=	HEALSE
	E04470	=	TIDX 
	E17500	=	TTMED 
	E17000	=	DEDMED 
	E18300	=	TTSLTX 
	E18400	=	SLITX 
	E18500	=	RETX 
	E18800	=	PPTX
	E18900	=	OTSLTX
	E19200	=	TTI_DED
	E03260	=	SECADED 
	E09400	=	SECATX
	E19300	=	HMIE 
	E19530 	=	POINTS
	E19700	=	TTCON 
	E19800	=	TCASH 
	E20100	=	TNCASH 
	E20400	=	T2MISC 
	E20550	=	EBE 
	E20800	=	DEDMIS 
	E20900	=	FDGAMB 
	E21000	=	FDOTHD 
	E21020	=	FDMISC 
	E21050	=	TOTMIS 
	E21060	=	GR_TID 
	E21040	=	DISIDX 
	E21100	=	SAVBOND
	E29375	=	WAS_OAS 
	E29400	=	WASP_OAS 
	E29450	=	WASS_OAS
	E33420	=	EMPLCC 
	E62100	=	AMTIX 
	E63000	=	TAMTX 
	E10300	=	TOT_LIAB
	E02500	=	SSAGIX 
	E01100	=	CGD40
	E25960	=	APARTL 
	E25980	=	APARTG
	E25920	=	PPARTL
	E25940	=	PPARTG
	E26160	=	PSBCL
	E26170	=	PSBCG
	E26180	=	ASBCL
	E26190	=	ASBCG
	N6		=	DEPNE 
	E29100	=	SENONFP 
	E29120	=	SENONFS 
	E29070	=	SENONF 
	E00900	=	BIL 
	E29020	=	SEFARMP 
	E29050	=	SEFARMS 
	E29000	=	SEFARM 
	E02100	=	FIL
	E22250	=	NSTGL 
	E23250	=	NLTGL 
	E01000	=	CGAGIX 
	E01200	=	SUPPGL 
	E00600	=	DBE 
	E00300	=	INTST 
	E00400	=	TEXINT
	E01700	=	PTPEN
	E02000	=	SCHE 
	E26500	=	ESTU 
	E00700	=	SITR 
	E00800	=	ALIMONY 
	E01400	=	TIRAD 
	E02300	=	UCAGIX 
	E02400	=	SSINC
	E02600	=	OTHINC
	E02900	=	TTADJ 
	E19570	=	IIE
	E20500	=	TTCASU 
	E32700	=	CCECYR 
	E07100	=	TTCRX 
	E07180	=	CCCX 
	E07200	=	ELDCRX
	E68000	=	Z17
	E04600	=	EXEMX 
	E04100	=	BSD 
	E04200	=	SDADD 
	E04450	=	SDX 
	E03220 	= 	EDUCEXP
	E03230	=	TUITFEES
	E03600	=	MSA
	E61850 	= 	TTPREF
	E62600  =  	AMTEXEMPTX
	E62700	=	AMTIAEX
	E62800	=	AMTIAEEXCGX	
	E03150  =   IRACONT
	E03300  = 	SEPSIMPLE
	E03400	=	EARLYWD
	E03210  =   STUDLOAN
	E03240  =   DOMPROD
	E07240	=	SAVCRED	
	E01300	=	GRIRAD
	E01500 	=	GRPEN
	E11000	=	EICX
	E11070	=	ACTCX

	E90020 	=  SOLEGRRECEIPTC
	E91020 	=  SOLEGRRECEIPT1
	E92020	=  SOLEGRRECEIPT2
	E93020   =  SOLEGRRECEIPT3	

	E90440 	=  SOLENETINCC
	E91440 	=  SOLENETINC1
	E92440	=  SOLENETINC2
	E93440   =  SOLENETINC3

	E90370	=	SOLEWAGESC
	E90100	=	SOLEEXPC

	E90470  =   SOLELABORCOGSC
	E90200  =   SOLEEMPBENC
	E90290  =   SOLEPENPROFITC
	E90190  =   SOLEDEPRC
	E90445  =   SOLEDEPR8829C
	E90570  =   SOLEDEPRCOGSC
	E90550  =   SOLEPAYROLLCOGSC
	E90165  =   SOLECONTRLABORC


	E03500 = ALIP
	) 

	);

	/* Keep non-rejected returns */
	if REJECT=0;


	/* Generate indicator for being sampled with probability 1 */
	HIINC = (WGT = 1);

	/* Convert possibly char variables to numbers */
	RETID = RETIDCHAR*1;
	CWHSI = CWHSICHAR*1;
	TAXYR = TAXYRCHAR*1;
	MARS = MARSCHAR*1;
	ISTATE = STATECHAR*1;
	CAHE = CAHECHAR*1;
	CAFHE = CAFHECHAR*1;
	DROP RETIDCHAR CWHSICHAR TAXYRCHAR MARSCHAR STATECHAR CAHECHAR CAFHECHAR;

	/* Create variables not in 2008 Insole */
	fileyr = 2008;

	/* Make gender variables consistent with other years */
	PGENDER = .;
	IF GENDERP = 'F' THEN PGENDER = 2;
	IF GENDERP = 'M' THEN PGENDER = 1;
	SGENDER = .;
	IF GENDERS = 'F' THEN SGENDER = 2;
	IF GENDERS = 'M' THEN SGENDER = 1;

	DROP GENDERP GENDERS;


	/* Create ID for matching with marginal tax rates */
	id = issnp;

	/* Calculate passive and active net partnership, SBC, and Scorp income */
	PARTPAS = PPARTG - PPARTL ; *E25940 - E25920;
	PARTACT = APARTG - APARTL ; *E25980 - E25960;
	PART = PARTPAS + PARTACT;
	SBC = 0;
	SCORPPAS = PSBCG - PSBCL ; *E26170 - E26160;
	SCORPACT = ASBCG - ASBCL ; *E26190 - E26180;
	SCORP = SCORPPAS + SCORPACT;

	/* Subtract off nondeductible meals and entertainment to make 
	   consistent with pre-TRA86 law (when total was deductible) */

    NDMEALENTC = .5*E90355;
	NDMEALENT1 = .5*E91355;
	NDMEALENT2 = .5*E92355;
	NDMEALENT3 = .5*E93355;

	SOLENETINCC = SOLENETINCC - NDMEALENTC;
	SOLENETINC1 = SOLENETINC1 - NDMEALENT1;
	SOLENETINC2 = SOLENETINC2 - NDMEALENT2;
	SOLENETINC3 = SOLENETINC3 - NDMEALENT3;

	DROP E90355 E91355 E92355 E93355;

	/* Sole prop gain (plus gains from other forms) */
	SOLEGAINPLUS = E22320;
	DROP E22320;

	SOLEGAIN = MAX(E40240, 0);
	DROP E40240;

	SOLEGAINALT = E40220;
	DROP E40220; 

	/* Partnership and scorp gain */
	PARTSCORPGAIN = E21775 + E22365;
	DROP E21775 E22365;

	/* Make gender variables consistent with other years */
	PGENDER = .;
	IF GENDERP = 'F' THEN PGENDER = 2;
	IF GENDERP = 'M' THEN PGENDER = 1;
	SGENDER = .;
	IF GENDERS = 'F' THEN SGENDER = 2;
	IF GENDERS = 'M' THEN SGENDER = 1;

	DROP GENDERP GENDERS;

	/* Calculate adjusted total income */
	ptpexc = max(grpen - ptpen, 0);
	iraexc = max(grirad - tirad, 0);
	ssexc = max(ssinc - ssagix, 0);

	ADJTOTINC = totincx + texint + iraexc + ptpexc + ssexc;


RUN;    




/* 2009 INSOLE */

  PROC CONTENTS DATA=SUBG.INSOLE09;
    TITLE "Contents of Insole";
  RUN;


/* Pull subset of data */

DATA SUBSUB.INSOLE09SUBSET (COMPRESS=YES);
    SET SUBG.INSOLE09(KEEP=
	
	REC_ID MARS FLPDYR REJECT
	STATE XOCAH  XOCAWH
	S002 S003	S006
	MARS
	XTOT	STATE	DSI	
	AGEP	AGES	
	PBI 	SBI

	DOBYR
	CWHSI
	E00100
	E00200	E02650	E03280	E03270	E04470
	E04800	E17500	E17000	E18300	E18400
	E18500	E18800	E18900	E19200	E03260
	E09400	E02000	E19300	E19530 	E19700
	E19800	E20100	E20400	E20550	E20800
	E20900	E21000	E21020	E21050	E21060
	E21040	E21100	E29375	E29400	E29450
	E33420	E62100	E63000	E10300	E02400
	E02500	E01100	E25960	E25980	E25920
	E25940	E26160	E26170	E26180	E26190
	N6
	EICYB1 	EICYB2 	E29100
	E29120	E29070	E00900	E29020	E29050
	E29000	E02100	E22250	E23250	E01000
	E01200	E00600	E00300	E00400	E01700
	E26500	E00700	E00800	E01400
	E02300	E02600	E02900	E19570
	E20500	E32700	E07100	E07180
	E07200	E68000	E04600	E04100	E04200
	E04450	
	E03600
	E04500 E04800 E05100 E05800 E05700 E08795
	E09600 E01800 E01500 E01300 
	E11000 E07400 E61850
	E20200
	E53220 E07300 E53240 E08000
	E09200 E08795
	E05200
	E62600 E62700 E62800 
	E25870 
	
	E60300 E60290 E60340 E60500 
	E60550 E60680 E60720 E60840 
	E61450 E60100 E62000 E60860 
	 E60600 E60405 
	E60440 E60420 E60410 E60480 
	E61400 E60660 

	E60630 
	E60430 
	N24 
	CDOB1 	CDOB2
	E05750	E03220 E03230
	E00650 
	E18425 E18450 	
	E03150  E03300 E03400
	E03210  E03240 
	E07240
	E11070	 

	/* Demographic vars */
	DOBYR SDOBYR GENDERP GENDERS

	/* Sole prop variables */
	NAIC NAIC1 NAIC2 NAIC3 DOMC SEXPRC SXPRC1 SXPRC2 SXPRC3	
	E90020 E91020 E92020 E93020
	E90440 E91440 E92440 E93440
	E90355 E91355 E92355 E93355
	E90370 E90100

	E90470 E90200 E90290 E90190 E90570 E90550 E90165


	/* Capital gain variables */
	E22320 E40240 E40220  
	E21775 E22365 


	/* Depreciation Variables */
	E54010 E54015 E54100 E57800 E57900 E58020 E58040 E58100 E58120 E58140 E58060 E58200 E58250 E58300



	E03500

	/****** Convert names to Family panel names ***/
	RENAME=(
	REC_ID	= 	RETIDCHAR
	s002	=	issnp
	s003	=	issns
	MARS	=	MARSCHAR
	CWHSI	=	CWHSICHAR
	FLPDYR	=	TAXYRCHAR
	REJECT	=	REJECT
	STATE	=	STATECHAR
	XTOT	=	IEXEMH 
	DSI		=	IFDEPT 
	S006	=	WGT
	AGEP	=	I65INDP 
	AGES	=	I65INDS 
	XOCAH	=	CAHECHAR
	XOCAWH	=	CAFHECHAR

	E00100	=	AGIX 
	E00200	=	WAS 
	E02650	=	TOTINCX 
	E03280	=	EXMOVE_AJ  
	E03270	=	HEALSE
	E04470	=	TIDX 
	E17500	=	TTMED 
	E17000	=	DEDMED 
	E18300	=	TTSLTX 
	E18400	=	SLITX 
	E18500	=	RETX 
	E18800	=	PPTX
	E18900	=	OTSLTX
	E19200	=	TTI_DED
	E03260	=	SECADED 
	E09400	=	SECATX
	E19300	=	HMIE 
	E19530 	=	POINTS
	E19700	=	TTCON 
	E19800	=	TCASH 
	E20100	=	TNCASH 
	E20400	=	T2MISC 
	E20550	=	EBE 
	E20800	=	DEDMIS 
	E20900	=	FDGAMB 
	E21000	=	FDOTHD 
	E21020	=	FDMISC 
	E21050	=	TOTMIS 
	E21060	=	GR_TID 
	E21040	=	DISIDX 
	E21100	=	SAVBOND
	E29375	=	WAS_OAS 
	E29400	=	WASP_OAS 
	E29450	=	WASS_OAS
	E33420	=	EMPLCC 
	E62100	=	AMTIX 
	E63000	=	TAMTX 
	E10300	=	TOT_LIAB
	E02500	=	SSAGIX 
	E01100	=	CGD40
	E25960	=	APARTL 
	E25980	=	APARTG
	E25920	=	PPARTL
	E25940	=	PPARTG
	E26160	=	PSBCL
	E26170	=	PSBCG
	E26180	=	ASBCL
	E26190	=	ASBCG
	N6		=	DEPNE 
	E29100	=	SENONFP 
	E29120	=	SENONFS 
	E29070	=	SENONF 
	E00900	=	BIL 
	E29020	=	SEFARMP 
	E29050	=	SEFARMS 
	E29000	=	SEFARM 
	E02100	=	FIL
	E22250	=	NSTGL 
	E23250	=	NLTGL 
	E01000	=	CGAGIX 
	E01200	=	SUPPGL 
	E00600	=	DBE 
	E00300	=	INTST 
	E00400	=	TEXINT
	E01700	=	PTPEN
	E02000	=	SCHE 
	E26500	=	ESTU 
	E00700	=	SITR 
	E00800	=	ALIMONY 
	E01400	=	TIRAD 
	E02300	=	UCAGIX 
	E02400	=	SSINC
	E02600	=	OTHINC
	E02900	=	TTADJ 
	E19570	=	IIE
	E20500	=	TTCASU 
	E32700	=	CCECYR 
	E07100	=	TTCRX 
	E07180	=	CCCX 
	E07200	=	ELDCRX
	E68000	=	Z17
	E04600	=	EXEMX 
	E04100	=	BSD 
	E04200	=	SDADD 
	E04450	=	SDX 
	E03220 	= 	EDUCEXP
	E03230	=	TUITFEES
	E03600	=	MSA
	E61850 	= 	TTPREF
	E62600  =  	AMTEXEMPTX
	E62700	=	AMTIAEX
	E62800	=	AMTIAEEXCGX	
	E03150  =   IRACONT
	E03300  = 	SEPSIMPLE
	E03400	=	EARLYWD
	E03210  =   STUDLOAN
	E03240  =   DOMPROD
	E07240	=	SAVCRED	
	E01300	=	GRIRAD
	E01500 	=	GRPEN
	E11000	=	EICX
	E11070	=	ACTCX

	E90020 	=  SOLEGRRECEIPTC
	E91020 	=  SOLEGRRECEIPT1
	E92020	=  SOLEGRRECEIPT2
	E93020   =  SOLEGRRECEIPT3	

	E90440 	=  SOLENETINCC
	E91440 	=  SOLENETINC1
	E92440	=  SOLENETINC2
	E93440   =  SOLENETINC3

	E90370	=	SOLEWAGESC
	E90100	=	SOLEEXPC

	E90470  =   SOLELABORCOGSC
	E90200  =   SOLEEMPBENC
	E90290  =   SOLEPENPROFITC
	E90190  =   SOLEDEPRC
	E90570  =   SOLEDEPRCOGSC
	E90550  =   SOLEPAYROLLCOGSC
	E90165  =   SOLECONTRLABORC

	E03500 = ALIP
	) 

	);

	/* Keep non-rejected returns */
	if REJECT=0;


	/* Generate indicator for being sampled with probability 1 */
	HIINC = (WGT = 1);

	/* Convert possibly char variables to numbers */
	RETID = RETIDCHAR*1;
	CWHSI = CWHSICHAR*1;
	TAXYR = TAXYRCHAR*1;
	MARS = MARSCHAR*1;
	ISTATE = STATECHAR*1;
	CAHE = CAHECHAR*1;
	CAFHE = CAFHECHAR*1;
	DROP RETIDCHAR CWHSICHAR TAXYRCHAR MARSCHAR STATECHAR CAHECHAR CAFHECHAR;

	/* Create variables not in 2009 Insole */
	fileyr = 2009;

	/* Make gender variables consistent with other years */
	PGENDER = .;
	IF GENDERP = 'F' THEN PGENDER = 2;
	IF GENDERP = 'M' THEN PGENDER = 1;
	SGENDER = .;
	IF GENDERS = 'F' THEN SGENDER = 2;
	IF GENDERS = 'M' THEN SGENDER = 1;

	DROP GENDERP GENDERS;


	/* Create ID for matching with marginal tax rates */
	id = issnp;

	/* Calculate passive and active net partnership, SBC, and Scorp income */
	PARTPAS = PPARTG - PPARTL ; *E25940 - E25920;
	PARTACT = APARTG - APARTL ; *E25980 - E25960;
	PART = PARTPAS + PARTACT;
	SBC = 0;
	SCORPPAS = PSBCG - PSBCL ; *E26170 - E26160;
	SCORPACT = ASBCG - ASBCL ; *E26190 - E26180;
	SCORP = SCORPPAS + SCORPACT;

	/* Subtract off nondeductible meals and entertainment to make 
	   consistent with pre-TRA86 law (when total was deductible) */

    NDMEALENTC = .5*E90355;
	NDMEALENT1 = .5*E91355;
	NDMEALENT2 = .5*E92355;
	NDMEALENT3 = .5*E93355;

	SOLENETINCC = SOLENETINCC - NDMEALENTC;
	SOLENETINC1 = SOLENETINC1 - NDMEALENT1;
	SOLENETINC2 = SOLENETINC2 - NDMEALENT2;
	SOLENETINC3 = SOLENETINC3 - NDMEALENT3;

	DROP E90355 E91355 E92355 E93355;

	/* Sole prop gain (plus gains from other forms) */
	SOLEGAINPLUS = E22320;
	DROP E22320;

	SOLEGAIN = MAX(E40240, 0);
	DROP E40240;

	SOLEGAINALT = E40220;
	DROP E40220; 

	/* Partnership and scorp gain */
	PARTSCORPGAIN = E21775 + E22365;
	DROP E21775 E22365;

	/* Make gender variables consistent with other years */
	PGENDER = .;
	IF GENDERP = 'F' THEN PGENDER = 2;
	IF GENDERP = 'M' THEN PGENDER = 1;
	SGENDER = .;
	IF GENDERS = 'F' THEN SGENDER = 2;
	IF GENDERS = 'M' THEN SGENDER = 1;

	DROP GENDERP GENDERS;

	/* Calculate adjusted total income */
	ptpexc = max(grpen - ptpen, 0);
	iraexc = max(grirad - tirad, 0);
	ssexc = max(ssinc - ssagix, 0);

	ADJTOTINC = totincx + texint + iraexc + ptpexc + ssexc;


RUN;    






/* Append all of the yearly files together */

DATA INSOLE97_09 (COMPRESS=YES);
    SET 
		SUBSUB.INSOLE97SUBSET
		SUBSUB.INSOLE98SUBSET
		SUBSUB.INSOLE99SUBSET
		SUBSUB.INSOLE00SUBSET
		SUBSUB.INSOLE01SUBSET
		SUBSUB.INSOLE02SUBSET
		SUBSUB.INSOLE03SUBSET
		SUBSUB.INSOLE04SUBSET
		SUBSUB.INSOLE05SUBSET
		SUBSUB.INSOLE06SUBSET
		SUBSUB.INSOLE07SUBSET
		SUBSUB.INSOLE08SUBSET
		SUBSUB.INSOLE09SUBSET;



RUN;


/* Output dataset of SSN's with demographic characteristics */

/* PRIMARY FILERS */

DATA INSOLE97_09DEMOGP (COMPRESS=YES);
    SET INSOLE97_09;

	IF PGENDER NE .;
	IF PGENDER NE 0.;
	IF DOBYR NE .;
	IF DOBYR NE 0;

	/* Copy primary information over to secondary */
	sgender = pgender;
	sdobyr = dobyr;
	issns = issnp;

	KEEP ISSNP ISSNS PGENDER DOBYR SGENDER SDOBYR;
RUN;

/* SECONDARY FILERS */
DATA INSOLE97_09DEMOGS (COMPRESS=YES);
    SET INSOLE97_09;

	IF SGENDER NE .;
	IF SGENDER NE 0;
	IF SDOBYR NE .;
	IF SDOBYR NE 0;

	/* Copy secondary information over to primary */
	pgender = sgender;
	dobyr = sdobyr;
	issnp = issns;

	KEEP ISSNP ISSNS PGENDER DOBYR SGENDER SDOBYR;
RUN;

/* MERGE PRIMARY AND SECONDARY TOGETHER */
DATA INSOLE97_09DEMOG ;
	set INSOLE97_09DEMOGP INSOLE97_09DEMOGS;

RUN;

/* Drop duplicate observations */
proc sort data=INSOLE97_09DEMOG ;
	by issnp ;
run ;

data INSOLE97_09DEMOG ;
	set INSOLE97_09DEMOG ;

	issnp_above = lag1(issnp) ;
run  ;

data INSOLE97_09DEMOG ;
	set INSOLE97_09DEMOG;
	if issnp = issnp_above then duplicate = 1 ;
		else duplicate = 0 ;

	if duplicate = 0 ;
	

	/* Rename gender and dob variables as alternates */
	PGENDERALT = PGENDER;
	DOBYRALT = DOBYR;
	SGENDERALT = SGENDER;
	SDOBYRALT = SDOBYR;
	ISSNPALT = ISSNP;
	ISSNSALT = ISSNS;

	DROP DUPLICATE ISSNP_ABOVE PGENDER DOBYR SGENDER SDOBYR;

run ;

/* Create two separate files (one for primary, one for secondary) and sort */
data INSOLE97_09DEMOGPRIMARY ;
	SET INSOLE97_09DEMOG;

	if issnp ne .;
	if issnp ne 0;

	KEEP ISSNP ISSNPALT PGENDERALT DOBYRALT;
RUN;

PROC SORT DATA=INSOLE97_09DEMOGPRIMARY;
	BY ISSNP;
RUN;

data INSOLE97_09DEMOGSECONDARY ;
	SET INSOLE97_09DEMOG;

	if issns ne .;
	if issns ne 0;

	KEEP ISSNS ISSNSALT SGENDERALT SDOBYRALT;
RUN;

PROC SORT DATA=INSOLE97_09DEMOGSECONDARY;
	BY ISSNS;
RUN;


/* Means of demographics without carried over information */
PROC MEANS DATA=INSOLE97_09;
	VAR ISSNP ISSNS PGENDER DOBYR SGENDER SDOBYR;
RUN;

/* Merge gender and dob variables into main dataset when missing */

/* Sort main dataset by issnp */
PROC SORT DATA=INSOLE97_09;
	BY ISSNP;
RUN;

/* Merge in alternate demographic information for primary filers */
DATA INSOLE97_09;
  MERGE INSOLE97_09 (IN = master) INSOLE97_09DEMOGPRIMARY; 
  BY ISSNP; 

  if master = 1;
RUN; 

/* Sort main dataset by issns */
PROC SORT DATA=INSOLE97_09;
	BY ISSNS;
RUN;

/* Merge in alternate demographic information for secondary filers */
DATA INSOLE97_09;
  MERGE INSOLE97_09 (in = master) INSOLE97_09DEMOGSECONDARY; 
  BY ISSNS; 

  if master = 1;
RUN; 


/* Copy over gender and dob if missing */
DATA INSOLE97_09 (COMPRESS=YES);
	set INSOLE97_09;
	
	if PGENDER = . OR PGENDER = 0 THEN PGENDER = PGENDERALT;
	if DOBYR = . OR DOBYR = 0 THEN DOBYR = DOBYRALT;

	if issns ne 0 then do;
		if SGENDER = . OR SGENDER = 0 THEN SGENDER = SGENDERALT;
		if SDOBYR = . OR SDOBYR = 0 THEN SDOBYR = SDOBYRALT;
		if (SGENDER = . OR SGENDER = 0) and PGENDER = 1 THEN SGENDER = 2;
		if (SGENDER = . OR SGENDER = 0) and PGENDER = 2 THEN SGENDER = 1;
	end;

	/* Reset gender and dob vars to missing if no secondary filer */
	if issns = 0 then SDOBYR = . ;
	if issns = 0 then SGENDER = . ;

	DROP ISSNPALT PGENDERALT DOBYRALT ISSNSALT SGENDERALT SDOBYRALT;
RUN;


/* Create age, self-employment, and other variables for calculation of IRA and 401k limits*/
DATA SUBSUB.INSOLE97_09 (COMPRESS=YES);
	set INSOLE97_09;

	* Make year variables consistently four digits;
	if taxyr < 100 then taxyr = taxyr + 1900;

	if dobyr < 100 then dobyr = dobyr + 1900;
	if sdobyr < 100 then sdobyr = sdobyr + 1900;
	
	/* Add year variable */
	year = taxyr;

	* Create age variables for primary and secondary filers;
	agep = taxyr - dobyr;
	ages = taxyr - sdobyr;

	/* Self employment and business income */
	SEERN	=	SEFARM + SENONF;
	SEERNP 	= 	SEFARMP + SENONFP;
	SEERNS	= 	SEFARMS + SENONFS;
	
	/* Total income */
	totinc = totincx;



RUN;




