/*OPTIONS NOCENTER LS=155 PS=60 COMPRESS=YES NOFMTERR;*/
/***********************************************************************/
/*  Subset data from the 1987-2006 Insoles                */
/***********************************************************************/
LIBNAME     SUB    "G:\EM&CA\DATA\Individual";
LIBNAME     SUB2    "G:\REV_EST\DeBacker\Panel8706";
LIBNAME     SUBSUB    "G:\REV_EST\DeBacker\Panel8706\LaborInc";

PROC MEANS DATA=SUBSUB.INSOLE87_96;
	VAR  issnp in_fp in_insole was taxyr ;
RUN;

/* 1987 INSOLE */

/* Read DM1 data, a dataset with date of birth and gender information, and create variables for merging
	into insole */
DATA INSOLE87DM1 (index=(retid));
    SET SUB2.DM1X87(KEEP=
	RETID
	DM1_MATCH 
	DM1P_DOB DM1S_DOB
	DM1P_GENDER DM1S_GENDER

	RENAME=(
	DM1P_DOB = PDOB
	DM1S_DOB = SDOB

	)
	);

	RETID = RETID;

	PGENDER = .;
	IF DM1P_GENDER = 'F' THEN PGENDER = 2;
	IF DM1P_GENDER = 'M' THEN PGENDER = 1;
	SGENDER = .;
	IF DM1S_GENDER = 'F' THEN SGENDER = 2;
	IF DM1S_GENDER = 'M' THEN SGENDER = 1;


	DOBYR = FLOOR(PDOB/10000);
	SDOBYR = FLOOR(SDOB/10000);

	KEEP DM1_MATCH RETID PGENDER SGENDER DOBYR SDOBYR;
RUN;


/* Read in insole data */


PROC CONTENTS DATA=SUB.INSOLE87;
RUN;



DATA SUBSUB.INSOLE87SUBSET (COMPRESS=YES);
    SET SUB.INSOLE87(KEEP=
	
	RETID MARS FLPDYR REJECT
	STATE 
	XOCAH  XOCAWH XOODEP XOPAR
	S002 S003
	N12 AGEP SAGE

	E1700 E1850 E1930 E1690

	PBI SBI

	S006 

	/* Form 1040 income variables */
	E10 E20 E30 E40
	E60 E90 E100 E120 E200 E210	

	/* Partnership and scorp variales */
	E2592 E2594 E2596 E2598 E2616 E2617 E2618 E2619 E2650

	/* Sole prop variables */
	INDYC DOMC SEXPRC
	E9002 E9102 E9202 E9302
	E9044 E9144 E9244 E9344
	E9007 E9107 E9207 E9307
	E9042 E9142 E9242 E9342
	E9057 E9157 E9257 E9357
	E9034 E9134 E9234 E9334
	E9037 E9010

	E9040 E9047 E9032 E9029 E9010 E9019 E9055

	/* Depreciation variables */
	E5400 E5410 E5740 E5750 E5800 E5780 E5790 E5805 E5820 E5830 E5660 
	

	/* Capital gain variables */
	E2290 E2206 E2208 E2235 E2237

	/* Adjusted total income variables */
	E265 E40 E150 E170 E240 E250 E110

	E260 E1850 N6 E2325 E2225 XTOT E940 E350 E1860 E3270 E1930 E1970 e330


	
	/****** Convert names to Family panel names ***/
	RENAME=(

	RETID	= 	RETIDCHAR
	MARS	=	MARSCHAR
	FLPDYR	=	TAXYRCHAR
	REJECT	=	REJECT
	STATE	=	STATECHAR
	XOCAH	=	CAHECHAR
	XOCAWH	=	CAFHECHAR
	XOODEP 	=	OTHDEPECHAR
	XOPAR	=	PARECHAR
	PBI		=	PBICHAR	
	SBI		=	SBICHAR
	N12     =   num_sch_c

	S002	=	issnp
	S003	=	issns

	E1850  = 	PROPTAX 
 	E1930  = 	MORTINT 
	E1700  =	MEDDED 
	E1690 	=	TOTDED 

	E10 	= 	AGIX
	E20		=	WAS 
	E30 	= 	INT
	E60 	= 	DIV
	E90 	= 	BIL
	E100 	= 	CGAGIX 
	E120 	= 	SUPPGL 
	E200 	=  SCHE
	E210 	=  FIL

	E2650	=	ESTTRUST

	E9002 	=  SOLEGRRECEIPTC
	E9102 	=  SOLEGRRECEIPT1
	E9202	=  SOLEGRRECEIPT2
	E9302   =  SOLEGRRECEIPT3	

	E9044 	=  SOLENETINCC
	E9144 	=  SOLENETINC1
	E9244	=  SOLENETINC2
	E9344   =  SOLENETINC3

	E2290	=  SOLEGAIN

	E9040	=	SOLEWAGESC
	E9010	=	SOLEEXPC

	E9037   =   SOLEWAGESC_GROSS 
	E9047   =   SOLELABORCOGSC
	E9032   =   SOLEEMPBENC
	E9029   =   SOLEPENPROFITC 
	E9019   =   SOLEDEPRC
	E9055   =   SOLEPAYROLLCOGSC

	S006	=	WGT

	E110 	=	CGDIST
	E265 	= 	TOTINCX
	E40 	= 	TEXINT
	E150 	=	GRPEN
	E170	=	PTPEN
	E240	=	SSINC
	E250	=	SSAGIX

	E260 = othinc
	N6 = deps
	E2325 = netltcg
	E2225 = netstcg
	XTOT = iexemh
	E940 = secatx
	E350 = alip
	E1860 = salestax
	E3270 = childcare
	E1970 = charity
	e330 = keogh

	sage = ages 

	E5400	=	E54010
	E5410	=	E54100
	E5740	=	E58100
	E5780	=	E57800
	E5790	=	E57900
	E5805	=	E58250
	E5820	=	E58200	
	E5830	=	E58300
	E5660	=	E58060
	E5750 	=	E58120
	E5800	=	E58140

	) 

	);
	
	/* Keep non-rejected returns */
	if REJECT=0;

	/* Generate indicator for being sampled with probability 1 */
	HIINC = (WGT = 1);

	/* Convert possibly char variables to numbers */
	RETID = RETIDCHAR*1;
	TAXYR = TAXYRCHAR*1;
	MARS = MARSCHAR*1;
	STATE = STATECHAR*1;
	CAHE = CAHECHAR*1;
	CAFHE = CAFHECHAR*1;
	OTHDEPE = OTHDEPECHAR*1;
	PARE = PARECHAR*1;
	PBI = PBICHAR*1;
	SBI = SBICHAR*1;
	
	DROP RETIDCHAR TAXYRCHAR MARSCHAR STATECHAR CAHECHAR CAFHECHAR OTHDEPECHAR PARECHAR PBICHAR SBICHAR;


	/* Calculate passive and active net partnership, SBC, and Scorp income */
	PARTPAS = E2594 - E2592;
	PARTACT = E2598 - E2596;
	PART = PARTPAS + PARTACT;
	SBC = 0;
	SCORPPAS = E2617 - E2616;
	SCORPACT = E2619 - E2618;
	SCORP = SCORPPAS + SCORPACT;
	DROP E2592 E2594 E2596 E2598 E2616 E2617 E2618 E2619;

	/* Add back windfall profits tax (not applicable some years) */
	WPTC = E9042 - E9007;
	WPT1 = E9142 - E9107;
	WPT2 = E9242 - E9207;
	WPT3 = E9342 - E9307;

	SOLENETINCC = SOLENETINCC + WPTC;
	SOLENETINC1 = SOLENETINC1 + WPT1;
	SOLENETINC2 = SOLENETINC2 + WPT2;
	SOLENETINC3 = SOLENETINC3 + WPT3;

	DROP E9007 E9107 E9207 E9307
		 E9042 E9142 E9242 E9342;

	/* Subtract off nondeductible meals and entertainment to make 
	   consistent with pre-TRA86 law (when total was deductible) */

    NDMEALENTC = E9057 - E9034;
	NDMEALENT1 = E9157 - E9134;
	NDMEALENT2 = E9257 - E9234;
	NDMEALENT3 = E9357 - E9334;

	SOLENETINCC = SOLENETINCC - NDMEALENTC;
	SOLENETINC1 = SOLENETINC1 - NDMEALENT1;
	SOLENETINC2 = SOLENETINC2 - NDMEALENT2;
	SOLENETINC3 = SOLENETINC3 - NDMEALENT3;

	DROP E9057 E9157 E9257 E9357
		 E9034 E9134 E9234 E9334;

	/* Partnership and scorp gain */
	PARTSCORPGAIN = (E2206 - E2208) + (E2235 - E2237);
	DROP E2206 E2208 E2235 E2237;

	/* Calculate adjusted total income */
	ptpexc = max(grpen - ptpen, 0);
	ssexc = max(ssinc - ssagix,0);

	ADJTOTINC = totincx + texint + ptpexc + ssexc;

	/* Merge in DOB and gender information */
	set INSOLE87DM1 key = RETID /unique ;

	/* variable for "Tentative 179 dedcution is not in 1987 */
	E54015 = 0 ;

	/* Variable denoting file's year */
	fileyr = 1987;

RUN;      



/* 1988 INSOLE */

/* Read DM1 data, a dataset with date of birth and gender information, and create variables for merging
	into insole */
DATA INSOLE88DM1 (index=(retid));
    SET SUB2.DM1X88(KEEP=
	RETID
	DM1_MATCH 
	DM1P_DOB DM1S_DOB
	DM1P_GENDER DM1S_GENDER

	RENAME=(
	DM1P_DOB = PDOB
	DM1S_DOB = SDOB

	)
	);

	RETID = RETID;

	PGENDER = .;
	IF DM1P_GENDER = 'F' THEN PGENDER = 2;
	IF DM1P_GENDER = 'M' THEN PGENDER = 1;
	SGENDER = .;
	IF DM1S_GENDER = 'F' THEN SGENDER = 2;
	IF DM1S_GENDER = 'M' THEN SGENDER = 1;


	DOBYR = FLOOR(PDOB/10000);
	SDOBYR = FLOOR(SDOB/10000);

	KEEP DM1_MATCH RETID PGENDER SGENDER DOBYR SDOBYR;
RUN;


/* Read in insole data */
PROC CONTENTS DATA=SUB.INSOLE88;
RUN;

DATA SUBSUB.INSOLE88SUBSET (COMPRESS=YES);
    SET SUB.INSOLE88(KEEP=
	
	RETID MARS FLPDYR REJECT
	STATE XOCAH  XOCAWH XOODEP XOPAR
	S002 S003
	N12 AGEP SAGE

	E1700 E1850 E1930 E1690

	PBI SBI

	S006 

	/* Form 1040 income variables */
	E10 E20 E30 E40
	E60 E90 E100 E120 E200 E210

	/* Partnership and scorp variales */
	E2592 E2594 E2596 E2598 E2616 E2617 E2618 E2619 E2650

	/* Sole prop variables */
	INDYC DOMC SEXPRC
	E9002 E9102 E9202 E9302
	E9044 E9144 E9244 E9344
	E9015 E9115 E9215 E9315
	E9034 E9134 E9234 E9334
	E9037 E9010

	E9040 E9047 E9032 E9029 E9010 E9019 E9055

/* Depreciation variables */
	E5400 E5410 E5740 E5750	E5800 E5780 E5790 E5805 E5820 E5830 E5660 


	/* Capital gain variables */
	E2290 E2206 E2208 E2235 E2237

	/* Adjusted total income variables */
	E265 E40 E130 E140 E150 E170 E240 E250 E110

	E260 E1850 N6 E2325 E2225 XTOT E940 E350 E3270 E1930 E1970 e330


	/****** Convert names to Family panel names ***/
	RENAME=(

	RETID	= 	RETIDCHAR
	MARS	=	MARSCHAR
	FLPDYR	=	TAXYRCHAR
	REJECT	=	REJECT
	STATE	=	STATECHAR
	XOCAH	=	CAHECHAR
	XOCAWH	=	CAFHECHAR
	XOODEP 	=	OTHDEPECHAR
	XOPAR	=	PARECHAR
	PBI		=	PBICHAR	
	SBI		=	SBICHAR
	N12     =   num_sch_c

	S002	=	issnp
	S003	=	issns

	E1850  = 	PROPTAX 
 	E1930  = 	MORTINT 
	E1700  =	MEDDED 
	E1690 	=	TOTDED 

	E10 	= 	AGIX
	E20		=	WAS 
	E30 	= 	INT
	E60 	= 	DIV
	E90 	= 	BIL
	E100 	= 	CGAGIX 
	E120 	= 	SUPPGL 
	E200 	=  SCHE
	E210 	=  FIL

	E2650	=	ESTTRUST

	E9002 	=  SOLEGRRECEIPTC
	E9102 	=  SOLEGRRECEIPT1
	E9202	=  SOLEGRRECEIPT2
	E9302   =  SOLEGRRECEIPT3	

	E9044 	=  SOLENETINCC
	E9144 	=  SOLENETINC1
	E9244	=  SOLENETINC2
	E9344   =  SOLENETINC3

	E2290	=  SOLEGAIN	

	E9037   =   SOLEWAGESC_GROSS 
	E9047   =   SOLELABORCOGSC
	E9032   =   SOLEEMPBENC
	E9029   =   SOLEPENPROFITC 
	E9019   =   SOLEDEPRC
	E9055   =   SOLEPAYROLLCOGSC

	E9040	=	SOLEWAGESC
	E9010	=	SOLEEXPC

	E110 	=	CGDIST
	E265 	= 	TOTINCX
	E40 	= 	TEXINT
	E150 	=	GRPEN
	E170	=	PTPEN
	E130	=	GRIRAD
	E140	=	TIRAD
	E240	=	SSINC
	E250	=	SSAGIX

	E260 = othinc
	N6 = deps
	E2325 = netltcg
	E2225 = netstcg
	XTOT = iexemh
	E940 = secatx
	E350 = alip
	E3270 = childcare
	E1970 = charity
	e330 = keogh

	S006	=	WGT

	SAGE = ages 

	E5400	=	E54010
	E5410	=	E54100
	E5740	=	E58100
	E5780	=	E57800
	E5790	=	E57900
	E5805	=	E58250
	E5820	=	E58200	
	E5830	=	E58300
	E5660	=	E58060
	
	E5750	=	E58120
	E5800	=	E58140

	) 

	);
	
	/* Keep non-rejected returns */
	if REJECT=0;

	/* Generate indicator for being sampled with probability 1 */
	HIINC = (WGT = 1);

	/* Convert possibly char variables to numbers */
	RETID = RETIDCHAR*1;
	TAXYR = TAXYRCHAR*1;
	MARS = MARSCHAR*1;
	STATE = STATECHAR*1;
	CAHE = CAHECHAR*1;
	CAFHE = CAFHECHAR*1;
	OTHDEPE = OTHDEPECHAR*1;
	PARE = PARECHAR*1;
	PBI = PBICHAR*1;
	SBI = SBICHAR*1;

	DROP RETIDCHAR TAXYRCHAR MARSCHAR STATECHAR CAHECHAR CAFHECHAR OTHDEPECHAR PARECHAR PBICHAR SBICHAR;

	/* Calculate passive and active net partnership, SBC, and Scorp income */
	PARTPAS = E2594 - E2592;
	PARTACT = E2598 - E2596;
	PART = PARTPAS + PARTACT;
	SBC = 0;
	SCORPPAS = E2617 - E2616;
	SCORPACT = E2619 - E2618;
	SCORP = SCORPPAS + SCORPACT;
	DROP E2592 E2594 E2596 E2598 E2616 E2617 E2618 E2619;

	/* Subtract off nondeductible meals and entertainment to make 
	   consistent with pre-TRA86 law (when total was deductible) */

    NDMEALENTC = E9015 - E9034;
	NDMEALENT1 = E9115 - E9134;
	NDMEALENT2 = E9215 - E9234;
	NDMEALENT3 = E9315 - E9334;

	SOLENETINCC = SOLENETINCC - NDMEALENTC;
	SOLENETINC1 = SOLENETINC1 - NDMEALENT1;
	SOLENETINC2 = SOLENETINC2 - NDMEALENT2;
	SOLENETINC3 = SOLENETINC3 - NDMEALENT3;

	DROP E9015 E9115 E9215 E9315
		 E9034 E9134 E9234 E9334;

	/* Partnership and scorp gain */
	PARTSCORPGAIN = (E2206 - E2208) + (E2235 - E2237);
	DROP E2206 E2208 E2235 E2237;

	/* Calculate adjusted total income */
	ptpexc = max(grpen - ptpen, 0);
	iraexc = max(grirad - tirad,0);
	ssexc = max(ssinc - ssagix,0);

	ADJTOTINC = totincx + texint + iraexc + ptpexc + ssexc;

	/* Merge in DOB and gender information */
	set INSOLE88DM1 key = RETID /unique ;

	/* variable for "Tentative 179 dedcution is not in 1988 */
	E54015 = 0 ;

	/* Variable denoting file's year */
	fileyr = 1988;

RUN;      



/* 1989 INSOLE */

/* Read DM1 data, a dataset with date of birth and gender information, and create variables for merging
	into insole */
DATA INSOLE89DM1 (index=(retid));
    SET SUB2.DM1X89(KEEP=
	RETID
	DM1_MATCH 
	DM1P_DOB DM1S_DOB
	DM1P_GENDER DM1S_GENDER

	RENAME=(
	DM1P_DOB = PDOB
	DM1S_DOB = SDOB

	)
	);

	RETID = RETID;

	PGENDER = .;
	IF DM1P_GENDER = 'F' THEN PGENDER = 2;
	IF DM1P_GENDER = 'M' THEN PGENDER = 1;
	SGENDER = .;
	IF DM1S_GENDER = 'F' THEN SGENDER = 2;
	IF DM1S_GENDER = 'M' THEN SGENDER = 1;


	DOBYR = FLOOR(PDOB/10000);
	SDOBYR = FLOOR(SDOB/10000);

	KEEP DM1_MATCH RETID PGENDER SGENDER DOBYR SDOBYR;
RUN;


/* Read in insole data */
PROC CONTENTS DATA=SUB.INSOLE89;
RUN;

DATA SUBSUB.INSOLE89SUBSET (COMPRESS=YES);
    SET SUB.INSOLE89(KEEP=
	
	RETID MARS FLPDYR REJECT
	STATE XOCAH  XOCAWH XOODEP XOPAR
	N12 AGEP SAGE

	S002 S003

	E1700 E1850 E1930 E1690

	PBI SBI 
	S006 

	/* Form 1040 income variables */
	E10 E20 E30 E40
	E60 E90 E100 E120 E200 E210

	/* Partnership and scorp variales */
	E2592 E2594 E2596 E2598 E2616 E2617 E2618 E2619 E2650

	/* Sole prop variables */
	INDYC DOMC SEXPRC
	E9002 E9102 E9202 E9302
	E9044 E9144 E9244 E9344
	E9015 E9115 E9215 E9315
	E9034 E9134 E9234 E9334
	E9037 E9010

	E9040 E9047 E9032 E9029 E9010 E9019 E9055

	/* Depreciation variables */
	E5400 E5402 E5410 E5740 E5750 E5800 E5780 E5790 E5805 E5820 E5830 E5660 


	/* Capital gain variables */
	E2290 E2206 E2208 E2235 E2237

	/* Adjusted total income variables */
	E265 E40 E130 E140 E150 E170 E240 E250 E110


	E260 E1850 N6 E2325 E2225 XTOT E940 E350 E3270 E1930 E1970 e330



	/****** Convert names to Family panel names ***/
	RENAME=(

	RETID	= 	RETIDCHAR
	MARS	=	MARSCHAR
	FLPDYR	=	TAXYRCHAR
	REJECT	=	REJECT
	STATE	=	STATECHAR
	XOCAH	=	CAHECHAR
	XOCAWH	=	CAFHECHAR
	XOODEP 	=	OTHDEPECHAR
	XOPAR	=	PARECHAR
	PBI		=	PBICHAR	
	SBI		=	SBICHAR
	N12     =   num_sch_c

	S002	=	issnp
	S003	=	issns

	E1850  = 	PROPTAX 
 	E1930  = 	MORTINT 
	E1700  =	MEDDED 
	E1690 	=	TOTDED 

	E10 	= 	AGIX
	E20		=	WAS 
	E30 	= 	INT
	E60 	= 	DIV
	E90 	= 	BIL
	E100 	= 	CGAGIX 
	E120 	= 	SUPPGL 
	E200 	=  SCHE
	E210 	=  FIL

	E2650 	=	ESTTRUST

	E9002 	=  SOLEGRRECEIPTC
	E9102 	=  SOLEGRRECEIPT1
	E9202	=  SOLEGRRECEIPT2
	E9302   =  SOLEGRRECEIPT3	

	E9044 	=  SOLENETINCC
	E9144 	=  SOLENETINC1
	E9244	=  SOLENETINC2
	E9344   =  SOLENETINC3

	E2290	=  SOLEGAIN	

	E9037   =   SOLEWAGESC_GROSS 
	E9047   =   SOLELABORCOGSC
	E9032   =   SOLEEMPBENC
	E9029   =   SOLEPENPROFITC 
	E9019   =   SOLEDEPRC
	E9055   =   SOLEPAYROLLCOGSC

	E9040	=	SOLEWAGESC
	E9010	=	SOLEEXPC

	E110 	=	CGDIST
	E265 	= 	TOTINCX
	E40 	= 	TEXINT
	E150 	=	GRPEN
	E170	=	PTPEN
	E130	=	GRIRAD
	E140	=	TIRAD
	E240	=	SSINC
	E250	=	SSAGIX

	E260 = othinc
	N6 = deps
	E2325 = netltcg
	E2225 = netstcg
	XTOT = iexemh
	E940 = secatx
	E350 = alip
	E3270 = childcare
	E1970 = charity
	e330 = keogh

	S006	=	WGT

	SAGE = ages 

	E5400	=	E54010
	E5402   =   E54015
	E5410	=	E54100
	E5740	=	E58100
	E5780	=	E57800
	E5790	=	E57900
	E5805	=	E58250
	E5820	=	E58200	
	E5830	=	E58300
	E5660	=	E58060
	
	E5750	=	E58120
	E5800	=	E58140

	) 

	);
	
	/* Keep non-rejected returns */
	if REJECT=0;

	/* Generate indicator for being sampled with probability 1 */
	HIINC = (WGT = 1);

	/* Convert possibly char variables to numbers */
	RETID = RETIDCHAR*1;
	TAXYR = TAXYRCHAR*1;
	MARS = MARSCHAR*1;
	STATE = STATECHAR*1;
	CAHE = CAHECHAR*1;
	CAFHE = CAFHECHAR*1;
	OTHDEPE = OTHDEPECHAR*1;
	PARE = PARECHAR*1;
	PBI = PBICHAR*1;
	SBI = SBICHAR*1;
	
	DROP RETIDCHAR TAXYRCHAR MARSCHAR STATECHAR CAHECHAR CAFHECHAR OTHDEPECHAR PARECHAR PBICHAR SBICHAR;

	/* Calculate passive and active net partnership, SBC, and Scorp income */
	PARTPAS = E2594 - E2592;
	PARTACT = E2598 - E2596;
	PART = PARTPAS + PARTACT;
	SBC = 0;
	SCORPPAS = E2617 - E2616;
	SCORPACT = E2619 - E2618;
	SCORP = SCORPPAS + SCORPACT;
	DROP E2592 E2594 E2596 E2598 E2616 E2617 E2618 E2619;


	/* Subtract off nondeductible meals and entertainment to make 
	   consistent with pre-TRA86 law (when total was deductible) */

    NDMEALENTC = E9015 - E9034;
	NDMEALENT1 = E9115 - E9134;
	NDMEALENT2 = E9215 - E9234;
	NDMEALENT3 = E9315 - E9334;

	SOLENETINCC = SOLENETINCC - NDMEALENTC;
	SOLENETINC1 = SOLENETINC1 - NDMEALENT1;
	SOLENETINC2 = SOLENETINC2 - NDMEALENT2;
	SOLENETINC3 = SOLENETINC3 - NDMEALENT3;

	DROP E9015 E9115 E9215 E9315
		 E9034 E9134 E9234 E9334;

	/* Partnership and scorp gain */
	PARTSCORPGAIN = (E2206 - E2208) + (E2235 - E2237);
	DROP E2206 E2208 E2235 E2237;

	/* Calculate adjusted total income */
	ptpexc = max(grpen - ptpen, 0);
	iraexc = max(grirad - tirad,0);
	ssexc = max(ssinc - ssagix,0);

	ADJTOTINC = totincx + texint + iraexc + ptpexc + ssexc;


	/* Merge in DOB and gender information */
	set INSOLE89DM1 key = RETID /unique ;

	/* Variable denoting file's year */
	fileyr = 1989;

RUN;      



/* 1990 INSOLE */

PROC CONTENTS DATA=SUB2.DM1X90;
RUN;

/* Read DM1 data, a dataset with date of birth and gender information, and create variables for merging
	into insole */
DATA INSOLE90DM1 (index=(rec_id));
    SET SUB2.DM1X90(KEEP=
	REC_ID
	DM1_MATCH 
	DM1P_DOB DM1S_DOB
	DM1P_GENDER DM1S_GENDER

	RENAME=(
	DM1P_DOB = PDOB
	DM1S_DOB = SDOB

	)
	);


	PGENDER = .;
	IF DM1P_GENDER = 'F' THEN PGENDER = 2;
	IF DM1P_GENDER = 'M' THEN PGENDER = 1;
	SGENDER = .;
	IF DM1S_GENDER = 'F' THEN SGENDER = 2;
	IF DM1S_GENDER = 'M' THEN SGENDER = 1;


	DOBYR = FLOOR(PDOB/10000);
	SDOBYR = FLOOR(SDOB/10000);

	KEEP DM1_MATCH REC_ID PGENDER SGENDER DOBYR SDOBYR;
RUN;


/* Read in insole data */
PROC CONTENTS DATA=SUB.INSOLE90;
RUN;

DATA SUBSUB.INSOLE90SUBSET (COMPRESS=YES);
    SET SUB.INSOLE90(KEEP=
	
	REC_ID RETID MARS FLPDYR REJECT
	STATE XOCAH  XOCAWH XOODEP XOPAR
	S002 S003
	N12 AGEP AGES

	E18500 E19300 E17000 E04470 

	PBI SBI

	S006 

	/* Form 1040 income variables */
	E00100 E00200 E00300 E00400
	E00600 E00900 E01000 E01100 E01200 E02000 E02100

	/* Partnership and scorp variales */
	E25920 E25940 E25960 E25980 E26160 E26170 E26180 E26190 E26500

	/* Sole prop variables */
	INDYC INDYC1 INDYC2 INDYC3 DOMC SEXPRC
	E90020 E91020 E92020 E93020
	E90440 E91440 E92440 E93440
	E90350 E91350 E92350 E93350
	E90370 E90100

	E90470 E90200 E90290 E90190 E90550 

	/* Depreciation Variables */
	E54020 E54100 E57800 E57900 E58020 E58040 E58100 E58120 	E58140 E58060 E58200 E58250 E58300


	/* Capital gain variables */
	E22380 E21700 E21750 E22350 E22360

	/* Adjusted total income variables */
	E02650 E00400 E01500 E01700 E01300 E01400 E02400 E02500

	E02600 AGEP AGES N6 E23250 E22250 XTOT E09400 E03500 E32700 E19300 E19700 E03300


	/****** Convert names to Family panel names ***/
	RENAME=(

	RETID	= 	RETIDCHAR
	MARS	=	MARSCHAR
	FLPDYR	=	TAXYRCHAR
	REJECT	=	REJECT
	STATE	=	STATECHAR
	XOCAH	=	CAHECHAR
	XOCAWH	=	CAFHECHAR
	XOODEP 	=	OTHDEPECHAR
	XOPAR	=	PARECHAR
	PBI		=	PBICHAR	
	SBI		=	SBICHAR
	N12     =   num_sch_c

	S002	=	issnp
	S003	=	issns

	E18500  = 	PROPTAX 
 	E19300  = 	MORTINT 
	E17000  =	MEDDED 
	E04470 	=	TOTDED 

	E00100 	= 	AGIX
	E00200	=	WAS 
	E00300 	= 	INT
	E00600 	= 	DIV
	E00900 	= 	BIL
	E01000 	= 	CGAGIX 
	E01100	=	CGDIST
	E01200 	= 	SUPPGL 
	E02000 	=  SCHE
	E02100 	=  FIL

	E26500 	=	ESTTRUST

	E90020 	=  SOLEGRRECEIPTC
	E91020 	=  SOLEGRRECEIPT1
	E92020	=  SOLEGRRECEIPT2
	E93020   =  SOLEGRRECEIPT3	

	E90440 	=  SOLENETINCC
	E91440 	=  SOLENETINC1
	E92440	=  SOLENETINC2
	E93440   =  SOLENETINC3

	E22380	=  SOLEGAIN

	E90370	=	SOLEWAGESC
	E90100	=	SOLEEXPC

	E90470  =   SOLELABORCOGSC
	E90200  =   SOLEEMPBENC
	E90290  =   SOLEPENPROFITC
	E90190  =   SOLEDEPRC
	E90550  =   SOLEPAYROLLCOGSC

	E02650 	=	TOTINCX
	E00400	=	TEXINT
	E01500	=	GRPEN
	E01700	=	PTPEN
	E01300	=	GRIRAD
	E01400	=	TIRAD
	E02400	=	SSINC
	E02500	=	SSAGIX

	E02600 = othinc
	N6 = deps
	E23250 = netltcg
	E22250 = netstcg
	XTOT = iexemh
	E09400 = secatx
	E03500 = alip
	E32700 = childcare
	E19700 = charity
	E03300 = keogh

	/* Use tentative deduction for sum of expensed and listed 	property, because sum is not available */
	E54020	=	E54015

	S006	=	WGT
	) 

	);
	
	/* Keep non-rejected returns */
	if REJECT=0;

	/* Generate indicator for being sampled with probability 1 */
	HIINC = (WGT = 1);

	/* Convert possibly char variables to numbers */
	RETID = RETIDCHAR*1;
	TAXYR = TAXYRCHAR*1;
	MARS = MARSCHAR*1;
	STATE = STATECHAR*1;
	CAHE = CAHECHAR*1;
	CAFHE = CAFHECHAR*1;
	OTHDEPE = OTHDEPECHAR*1;
	PARE = PARECHAR*1;
	PBI = PBICHAR*1;
	SBI = SBICHAR*1;
	
	DROP RETIDCHAR TAXYRCHAR MARSCHAR STATECHAR CAHECHAR CAFHECHAR OTHDEPECHAR PARECHAR PBICHAR SBICHAR;

	/* Calculate passive and active net partnership, SBC, and Scorp income */
	PARTPAS = E25940 - E25920;
	PARTACT = E25980 - E25960;
	PART = PARTPAS + PARTACT;
	SBC = 0;
	SCORPPAS = E26170 - E26160;
	SCORPACT = E26190 - E26180;
	SCORP = SCORPPAS + SCORPACT;
	DROP E25920 E25940 E25960 E25980 E26160 E26170 E26180 E26190;


	/* Subtract off nondeductible meals and entertainment to make 
	   consistent with pre-TRA86 law (when total was deductible) */

    NDMEALENTC = E90350;
	NDMEALENT1 = E91350;
	NDMEALENT2 = E92350;
	NDMEALENT3 = E93350;

	SOLENETINCC = SOLENETINCC - NDMEALENTC;
	SOLENETINC1 = SOLENETINC1 - NDMEALENT1;
	SOLENETINC2 = SOLENETINC2 - NDMEALENT2;
	SOLENETINC3 = SOLENETINC3 - NDMEALENT3;

	DROP E90350 E91350 E92350 E93350;

	/* Partnership and scorp gain */
	PARTSCORPGAIN = (E21700 - E21750) + (E22350 - E22360);
	DROP E21700 E21750 E22350 E22360;

	/* Calculate adjusted total income */
	ptpexc = max(grpen - ptpen, 0);
	iraexc = max(grirad - tirad, 0);
	ssexc = max(ssinc - ssagix, 0);

	ADJTOTINC = totincx + texint + iraexc + ptpexc + ssexc;

	/* Merge in DOB and gender information */
	set INSOLE90DM1 key = REC_ID /unique ;

	/* variable for "Listed Property, Elected Cost" is not in 1990 or 1991 */
	E54010 = 0 ;

	/* Variable denoting file's year */
	fileyr = 1990;

RUN;      





/* 1991 INSOLE */

/* Read DM1 data, a dataset with date of birth and gender information, and create variables for merging
	into insole */
DATA INSOLE91DM1 (index=(rec_id));
    SET SUB2.DM1X91(KEEP=
	REC_ID
	DM1_MATCH 
	DM1P_DOB DM1S_DOB
	DM1P_GENDER DM1S_GENDER

	RENAME=(
	DM1P_DOB = PDOB
	DM1S_DOB = SDOB

	)
	);



	PGENDER = .;
	IF DM1P_GENDER = 'F' THEN PGENDER = 2;
	IF DM1P_GENDER = 'M' THEN PGENDER = 1;
	SGENDER = .;
	IF DM1S_GENDER = 'F' THEN SGENDER = 2;
	IF DM1S_GENDER = 'M' THEN SGENDER = 1;


	DOBYR = FLOOR(PDOB/10000);
	SDOBYR = FLOOR(SDOB/10000);

	KEEP DM1_MATCH REC_ID PGENDER SGENDER DOBYR SDOBYR;
RUN;


/* Read in insole data */

PROC CONTENTS DATA=SUB.INSOLE91;
RUN;

DATA SUBSUB.INSOLE91SUBSET (COMPRESS=YES);
    SET SUB.INSOLE91(KEEP=
	
	REC_ID RETID MARS FLPDYR REJECT
	STATE XOCAH  XOCAWH XOODEP XOPAR
	S002 S003
	N12 AGEP AGES

	E18500 E19300 E17000 E04470 

	PBI SBI

	S006 

	/* Form 1040 income variables */
	E00100 E00200 E00300 E00400
	E00600 E00900 E01000 E01100 E01200 E02000 E02100

	/* Partnership and scorp variales */
	E25920 E25940 E25960 E25980 E26160 E26170 E26180 E26190 E26500

	/* Sole prop variables */
	INDYC INDYC1 INDYC2 INDYC3 DOMC SEXPRC SXPRC1 SXPRC2 SXPRC3	
	E90020 E91020 E92020 E93020
	E90440 E91440 E92440 E93440
	E90350 E91350 E92350 E93350
	E90370 E90100

	E90470 E90200 E90290 E90190 E90550 

	/* Depreciation Variables */
	E54020 E54100 E57800 E57900 E58020 E58040 E58100 E58120 E58140 E58060 E58200 E58250 E58300


	/* Capital gain variables */
	E22380 E21700 E21750 E22350 E22360

	/* Adjusted total income variables */
	E02650 E00400 E01500 E01700 E01300 E01400 E02400 E02500

	E02600  AGEP AGES N6 E23250 E22250 XTOT E09400 E03500 E32700 E19300 E19700 E03300


	/****** Convert names to Family panel names ***/
	RENAME=(

	RETID	= 	RETIDCHAR
	MARS	=	MARSCHAR
	FLPDYR	=	TAXYRCHAR
	REJECT	=	REJECT
	STATE	=	STATECHAR
	XOCAH	=	CAHECHAR
	XOCAWH	=	CAFHECHAR
	XOODEP 	=	OTHDEPECHAR
	XOPAR	=	PARECHAR
	PBI		=	PBICHAR	
	SBI		=	SBICHAR
	N12     =   num_sch_c

	S002	=	issnp
	S003	=	issns

	E18500  = 	PROPTAX 
 	E19300  = 	MORTINT 
	E17000  =	MEDDED 
	E04470 	=	TOTDED 

	E00100 	= 	AGIX
	E00200	=	WAS 
	E00300 	= 	INT
	E00600 	= 	DIV
	E00900 	= 	BIL
	E01000 	= 	CGAGIX 
	E01100	=	CGDIST
	E01200 	= 	SUPPGL 
	E02000 	=  SCHE
	E02100 	=  FIL

	E26500 	=	ESTTRUST

	E90020 	=  SOLEGRRECEIPTC
	E91020 	=  SOLEGRRECEIPT1
	E92020	=  SOLEGRRECEIPT2
	E93020   =  SOLEGRRECEIPT3	

	E90440 	=  SOLENETINCC
	E91440 	=  SOLENETINC1
	E92440	=  SOLENETINC2
	E93440   =  SOLENETINC3

	E22380	=  SOLEGAIN

	E90470  =   SOLELABORCOGSC
	E90200  =   SOLEEMPBENC
	E90290  =   SOLEPENPROFITC
	E90190  =   SOLEDEPRC
	E90550  =   SOLEPAYROLLCOGSC

	E90370	=	SOLEWAGESC
	E90100	=	SOLEEXPC

	E02650 	=	TOTINCX
	E00400	=	TEXINT
	E01500	=	GRPEN
	E01700	=	PTPEN
	E01300	=	GRIRAD
	E01400	=	TIRAD
	E02400	=	SSINC
	E02500	=	SSAGIX

	E02600 = othinc
	N6 = deps
	E23250 = netltcg
	E22250 = netstcg
	XTOT = iexemh
	E09400 = secatx
	E03500 = alip
	E32700 = childcare
	E19700 = charity
	E03300 = keogh

	/* Use tentative deduction for sum of expensed and listed property, because sum is not available */
	E54020	=	E54015

	S006	=	WGT

	) 

	);
	
	/* Keep non-rejected returns */
	if REJECT=0;

	/* Generate indicator for being sampled with probability 1 */
	HIINC = (WGT = 1);

	/* Convert possibly char variables to numbers */
	RETID = RETIDCHAR*1;
	TAXYR = TAXYRCHAR*1;
	MARS = MARSCHAR*1;
	STATE = STATECHAR*1;
	CAHE = CAHECHAR*1;
	CAFHE = CAFHECHAR*1;
	OTHDEPE = OTHDEPECHAR*1;
	PARE = PARECHAR*1;
	PBI = PBICHAR*1;
	SBI = SBICHAR*1;
	
	DROP RETIDCHAR TAXYRCHAR MARSCHAR STATECHAR CAHECHAR CAFHECHAR OTHDEPECHAR PARECHAR PBICHAR SBICHAR;

	/* Calculate passive and active net partnership, SBC, and Scorp income */
	PARTPAS = E25940 - E25920;
	PARTACT = E25980 - E25960;
	PART = PARTPAS + PARTACT;
	SBC = 0;
	SCORPPAS = E26170 - E26160;
	SCORPACT = E26190 - E26180;
	SCORP = SCORPPAS + SCORPACT;
	DROP E25920 E25940 E25960 E25980 E26160 E26170 E26180 E26190;


	/* Subtract off nondeductible meals and entertainment to make 
	   consistent with pre-TRA86 law (when total was deductible) */

    NDMEALENTC = E90350;
	NDMEALENT1 = E91350;
	NDMEALENT2 = E92350;
	NDMEALENT3 = E93350;

	SOLENETINCC = SOLENETINCC - NDMEALENTC;
	SOLENETINC1 = SOLENETINC1 - NDMEALENT1;
	SOLENETINC2 = SOLENETINC2 - NDMEALENT2;
	SOLENETINC3 = SOLENETINC3 - NDMEALENT3;

	DROP E90350 E91350 E92350 E93350;

	/* Partnership and scorp gain */
	PARTSCORPGAIN = (E21700 - E21750) + (E22350 - E22360);
	DROP E21700 E21750 E22350 E22360;

	/* Calculate adjusted total income */
	ptpexc = max(grpen - ptpen, 0);
	iraexc = max(grirad - tirad, 0);
	ssexc = max(ssinc - ssagix, 0);

	ADJTOTINC = totincx + texint + iraexc + ptpexc + ssexc;

	/* Merge in DOB and gender information */
	set INSOLE91DM1 key = REC_ID /unique ;

	/* variable for "Listed Property, Elected Cost" is not in 1990 or 1991 */
	E54010 = 0 ;

	/* Variable denoting file's year */
	fileyr = 1991;

RUN;      



/* 1992 INSOLE */


/* Read DM1 data, a dataset with date of birth and gender information, and create variables for merging
	into insole */
DATA INSOLE92DM1 (index=(rec_id));
    SET SUB2.DM1X92(KEEP=
	REC_ID
	DM1_MATCH 
	DM1P_DOB DM1S_DOB
	DM1P_GENDER DM1S_GENDER

	RENAME=(
	DM1P_DOB = PDOB
	DM1S_DOB = SDOB

	)
	);


	PGENDER = .;
	IF DM1P_GENDER = 'F' THEN PGENDER = 2;
	IF DM1P_GENDER = 'M' THEN PGENDER = 1;
	SGENDER = .;
	IF DM1S_GENDER = 'F' THEN SGENDER = 2;
	IF DM1S_GENDER = 'M' THEN SGENDER = 1;


	DOBYR = FLOOR(PDOB/10000);
	SDOBYR = FLOOR(SDOB/10000);

	KEEP DM1_MATCH REC_ID PGENDER SGENDER DOBYR SDOBYR;
RUN;


/* Read in insole data */
PROC CONTENTS DATA=SUB.INSOLE92;
RUN;

DATA SUBSUB.INSOLE92SUBSET (COMPRESS=YES);
    SET SUB.INSOLE92(KEEP=
	
	REC_ID RETID MARS FLPDYR REJECT
	STATE XOCAH  XOCAWH XOODEP XOPAR
	S002 S003
	N12 AGEP AGES

	E18500 E19300 E17000 E04470 

	PBI SBI

	CWHSI

	S006 

	/* Form 1040 income variables */
	E00100 E00200 E00300 E00400
	E00600 E00900 E01000 E01100 E01200 E02000 E02100

	/* Partnership and scorp variales */
	E25920 E25940 E25960 E25980 E26160 E26170 E26180 E26190 E26500

	/* Sole prop variables */
	INDYC INDYC1 INDYC2 INDYC3 DOMC SEXPRC SXPRC1 SXPRC2 SXPRC3	
	E90020 E91020 E92020 E93020
	E90440 E91440 E92440 E93440
	E90350 E91350 E92350 E93350
	E90370 E90100

	E90470 E90200 E90290 E90190 E90550 

	/* Depreciation Variables */
	E54010 E54015 E54100 E57800 E57900 E58020 E58040 E58100 E58120 E58140 E58060 E58200 E58250 E58300


	/* Capital gain variables */
	E22380 E21700 E21750 E22350 E22360

	/* Adjusted total income variables */
	E02650 E00400 E01500 E01700 E01300 E01400 E02400 E02500

	E02600  AGEP AGES N6 E23250 E22250 XTOT E09400 E03500 E32700 E19300 E19700 E03300

	/****** Convert names to Family panel names ***/
	RENAME=(

	RETID	= 	RETIDCHAR
	MARS	=	MARSCHAR
	FLPDYR	=	TAXYRCHAR
	REJECT	=	REJECT
	STATE	=	STATECHAR
	XOCAH	=	CAHECHAR
	XOCAWH	=	CAFHECHAR
	XOODEP 	=	OTHDEPECHAR
	XOPAR	=	PARECHAR
	PBI		=	PBICHAR	
	SBI		=	SBICHAR
	N12     =   num_sch_c

	S002	=	issnp
	S003	=	issns
	CWHSI	=	CWHSICHAR

	E18500  = 	PROPTAX 
 	E19300  = 	MORTINT 
	E17000  =	MEDDED 
	E04470 	=	TOTDED 

	E00100 	= 	AGIX
	E00200	=	WAS 
	E00300 	= 	INT
	E00600 	= 	DIV
	E00900 	= 	BIL
	E01000 	= 	CGAGIX 
	E01100	=	CGDIST
	E01200 	= 	SUPPGL 
	E02000 	=  SCHE
	E02100 	=  FIL

	E26500 	=	ESTTRUST

	E90020 	=  SOLEGRRECEIPTC
	E91020 	=  SOLEGRRECEIPT1
	E92020	=  SOLEGRRECEIPT2
	E93020   =  SOLEGRRECEIPT3	

	E90440 	=  SOLENETINCC
	E91440 	=  SOLENETINC1
	E92440	=  SOLENETINC2
	E93440   =  SOLENETINC3

	E22380	=  SOLEGAIN

	E90470  =   SOLELABORCOGSC
	E90200  =   SOLEEMPBENC
	E90290  =   SOLEPENPROFITC
	E90190  =   SOLEDEPRC
	E90550  =   SOLEPAYROLLCOGSC

	E90370	=	SOLEWAGESC
	E90100	=	SOLEEXPC

	E02650 	=	TOTINCX
	E00400	=	TEXINT
	E01500	=	GRPEN
	E01700	=	PTPEN
	E01300	=	GRIRAD
	E01400	=	TIRAD
	E02400	=	SSINC
	E02500	=	SSAGIX

	S006	=	WGT

	E02600 = othinc
	N6 = deps
	E23250 = netltcg
	E22250 = netstcg
	XTOT = iexemh
	E09400 = secatx
	E03500 = alip
	E32700 = childcare
	E19700 = charity
	E03300 = keogh
	) 

	);
	
	/* Keep non-rejected returns */
	if REJECT=0;

	/* Generate indicator for being sampled with probability 1 */
	HIINC = (WGT = 1);

	/* Convert possibly char variables to numbers */
	RETID = RETIDCHAR*1;
	CWHSI = CWHSICHAR*1;
	TAXYR = TAXYRCHAR*1;
	MARS = MARSCHAR*1;
	STATE = STATECHAR*1;
	CAHE = CAHECHAR*1;
	CAFHE = CAFHECHAR*1;
	OTHDEPE = OTHDEPECHAR*1;
	PARE = PARECHAR*1;
	PBI = PBICHAR*1;
	SBI = SBICHAR*1;
	
	DROP RETIDCHAR CWHSICHAR TAXYRCHAR MARSCHAR STATECHAR CAHECHAR CAFHECHAR OTHDEPECHAR PARECHAR PBICHAR SBICHAR;

	/* Calculate passive and active net partnership, SBC, and Scorp income */
	PARTPAS = E25940 - E25920;
	PARTACT = E25980 - E25960;
	PART = PARTPAS + PARTACT;
	SBC = 0;
	SCORPPAS = E26170 - E26160;
	SCORPACT = E26190 - E26180;
	SCORP = SCORPPAS + SCORPACT;
	DROP E25920 E25940 E25960 E25980 E26160 E26170 E26180 E26190;

	/* Subtract off nondeductible meals and entertainment to make 
	   consistent with pre-TRA86 law (when total was deductible) */

    NDMEALENTC = E90350;
	NDMEALENT1 = E91350;
	NDMEALENT2 = E92350;
	NDMEALENT3 = E93350;

	SOLENETINCC = SOLENETINCC - NDMEALENTC;
	SOLENETINC1 = SOLENETINC1 - NDMEALENT1;
	SOLENETINC2 = SOLENETINC2 - NDMEALENT2;
	SOLENETINC3 = SOLENETINC3 - NDMEALENT3;

	DROP E90350 E91350 E92350 E93350;

	/* Partnership and scorp gain */
	PARTSCORPGAIN = (E21700 - E21750) + (E22350 - E22360);
	DROP E21700 E21750 E22350 E22360;

	/* Calculate adjusted total income */
	ptpexc = max(grpen - ptpen, 0);
	iraexc = max(grirad - tirad, 0);
	ssexc = max(ssinc - ssagix, 0);

	ADJTOTINC = totincx + texint + iraexc + ptpexc + ssexc;

	/* Merge in DOB and gender information */
	set INSOLE92DM1 key = REC_ID /unique ;

	/* Variable denoting file's year */
	fileyr = 1992;

RUN;      



/* 1993 INSOLE */


/* Read DM1 data, a dataset with date of birth and gender information, and create variables for merging
	into insole */
DATA INSOLE93DM1 (index=(recid));
    SET SUB2.DM1X93(KEEP=
	RECIDNO
	DM1_MATCH 
	DM1P_DOB DM1S_DOB
	DM1P_GENDER DM1S_GENDER

	RENAME=(
	DM1P_DOB = PDOB
	DM1S_DOB = SDOB

	)
	);

	RECID = RECIDNO;

	PGENDER = .;
	IF DM1P_GENDER = 'F' THEN PGENDER = 2;
	IF DM1P_GENDER = 'M' THEN PGENDER = 1;
	SGENDER = .;
	IF DM1S_GENDER = 'F' THEN SGENDER = 2;
	IF DM1S_GENDER = 'M' THEN SGENDER = 1;


	DOBYR = FLOOR(PDOB/10000);
	SDOBYR = FLOOR(SDOB/10000);

	KEEP DM1_MATCH RECID PGENDER SGENDER DOBYR SDOBYR;
RUN;


/* Read in insole data */
PROC CONTENTS DATA=SUB.INSOLE93;
RUN;

DATA SUBSUB.INSOLE93SUBSET (COMPRESS=YES);
    SET SUB.INSOLE93(KEEP=
	
	RECID RETID MARS FLPDYR REJECT
	STATE XOCAH  XOCAWH XOODEP XOPAR
	S002 S003
	N12 AGEP AGES

	E18500 E19300 E17000 E04470 
	PBI SBI

	CWHSI

	S006  

	/* Form 1040 income variables */
	E00100 E00200 E00300 E00400
	E00600 E00900 E01000 E01100 E01200 E02000 E02100

	/* Partnership and scorp variales */
	E25920 E25940 E25960 E25980 E26160 E26170 E26180 E26190 E26500

	/* Sole prop variables */
	INDYC INDYC1 INDYC2 INDYC3 DOMC SEXPRC SXPRC1 SXPRC2 SXPRC3	
	E90020 E91020 E92020 E93020
	E90440 E91440 E92440 E93440
	E90350 E91350 E92350 E93350
	E90370 E90100

	E90470 E90200 E90290 E90190 E90550 

	/* Depreciation Variables */
	E54010 E54015 E54100 E57800 E57900 E58020 E58040 E58100 E58120 E58140 E58060 E58200 E58250 E58300 


	/* Capital gain variables */
	E22310 E22315 
	E21700 E21750 E22350 E22360

	/* Adjusted total income variables */
	E02650 E00400 E01500 E01700 E01300 E01400 E02400 E02500

	E02600  AGEP AGES N6 E23250 E22250 XTOT E09400 E03500 E32700 E19300 E19700 E03300

	/****** Convert names to Family panel names ***/
	RENAME=(

	RECID	=	RECIDCHAR
	RETID	= 	RETIDCHAR
	MARS	=	MARSCHAR
	FLPDYR	=	TAXYRCHAR
	REJECT	=	REJECT
	STATE	=	STATECHAR
	XOCAH	=	CAHECHAR
	XOCAWH	=	CAFHECHAR
	XOODEP 	=	OTHDEPECHAR
	XOPAR	=	PARECHAR
	PBI		=	PBICHAR	
	SBI		=	SBICHAR
	N12     =   num_sch_c

	S002	=	issnp
	S003	=	issns
	CWHSI	=	CWHSICHAR

	E18500  = 	PROPTAX 
 	E19300  = 	MORTINT 
	E17000  =	MEDDED 
	E04470 	=	TOTDED 

	E00100 	= 	AGIX
	E00200	=	WAS 
	E00300 	= 	INT
	E00600 	= 	DIV
	E00900 	= 	BIL
	E01000 	= 	CGAGIX 
	E01100	=	CGDIST
	E01200 	= 	SUPPGL 
	E02000 	=  SCHE
	E02100 	=  FIL

	E26500 	=	ESTTRUST

	E90020 	=  SOLEGRRECEIPTC
	E91020 	=  SOLEGRRECEIPT1
	E92020	=  SOLEGRRECEIPT2
	E93020   =  SOLEGRRECEIPT3	

	E90440 	=  SOLENETINCC
	E91440 	=  SOLENETINC1
	E92440	=  SOLENETINC2
	E93440   =  SOLENETINC3

	E90370	=	SOLEWAGESC
	E90100	=	SOLEEXPC

	E90470  =   SOLELABORCOGSC
	E90200  =   SOLEEMPBENC
	E90290  =   SOLEPENPROFITC
	E90190  =   SOLEDEPRC
	E90550  =   SOLEPAYROLLCOGSC

	E02650 	=	TOTINCX
	E00400	=	TEXINT
	E01500	=	GRPEN
	E01700	=	PTPEN
	E01300	=	GRIRAD
	E01400	=	TIRAD
	E02400	=	SSINC
	E02500	=	SSAGIX

	S006	=	WGT

	E02600 = othinc
	N6 = deps
	E23250 = netltcg
	E22250 = netstcg
	XTOT = iexemh
	E09400 = secatx
	E03500 = alip
	E32700 = childcare
	E19700 = charity
	E03300 = keogh

	) 

	);
	
	/* Keep non-rejected returns */
	if REJECT=0;

	/* Generate indicator for being sampled with probability 1 */
	HIINC = (WGT = 1);

	/* Convert possibly char variables to numbers */
	RECID = RECIDCHAR*1;
	RETID = RETIDCHAR*1;
	CWHSI = CWHSICHAR*1;
	TAXYR = TAXYRCHAR*1;
	MARS = MARSCHAR*1;
	STATE = STATECHAR*1;
	CAHE = CAHECHAR*1;
	CAFHE = CAFHECHAR*1;
	OTHDEPE = OTHDEPECHAR*1;
	PARE = PARECHAR*1;
	PBI = PBICHAR*1;
	SBI = SBICHAR*1;
	
	DROP RETIDCHAR CWHSICHAR TAXYRCHAR MARSCHAR STATECHAR CAHECHAR CAFHECHAR OTHDEPECHAR PARECHAR PBICHAR SBICHAR;

	/* Calculate passive and active net partnership, SBC, and Scorp income */
	PARTPAS = E25940 - E25920;
	PARTACT = E25980 - E25960;
	PART = PARTPAS + PARTACT;
	SBC = 0;
	SCORPPAS = E26170 - E26160;
	SCORPACT = E26190 - E26180;
	SCORP = SCORPPAS + SCORPACT;
	DROP E25920 E25940 E25960 E25980 E26160 E26170 E26180 E26190;

	/* Subtract off nondeductible meals and entertainment to make 
	   consistent with pre-TRA86 law (when total was deductible) */

    NDMEALENTC = E90350;
	NDMEALENT1 = E91350;
	NDMEALENT2 = E92350;
	NDMEALENT3 = E93350;

	SOLENETINCC = SOLENETINCC - NDMEALENTC;
	SOLENETINC1 = SOLENETINC1 - NDMEALENT1;
	SOLENETINC2 = SOLENETINC2 - NDMEALENT2;
	SOLENETINC3 = SOLENETINC3 - NDMEALENT3;

	DROP E90350 E91350 E92350 E93350;	

	/* Sole prop gain (plus gains from other forms) */
	SOLEGAINPLUS = E22310 - E22315;
	DROP E22310 E22315;

	/* Partnership and scorp gain */
	PARTSCORPGAIN = (E21700 - E21750) + (E22350 - E22360);
	DROP E21700 E21750 E22350 E22360;

	/* Calculate adjusted total income */
	ptpexc = max(grpen - ptpen, 0);
	iraexc = max(grirad - tirad, 0);
	ssexc = max(ssinc - ssagix, 0);

	ADJTOTINC = totincx + texint + iraexc + ptpexc + ssexc;

	/* Merge in DOB and gender information */
	set INSOLE93DM1 key = RECID /unique ;


	/* Variable denoting file's year */
	fileyr = 1993;

RUN;      



/* 1994 INSOLE */


/* Read DM1 data, a dataset with date of birth and gender information, and create variables for merging
	into insole */
DATA INSOLE94DM1 (index=(rec_id));
    SET SUB2.DM1X94(KEEP=
	REC_ID
	DM1_MATCH 
	DM1P_DOB DM1S_DOB
	DM1P_GENDER DM1S_GENDER

	RENAME=(
	DM1P_DOB = PDOB
	DM1S_DOB = SDOB

	)
	);


	PGENDER = .;
	IF DM1P_GENDER = 'F' THEN PGENDER = 2;
	IF DM1P_GENDER = 'M' THEN PGENDER = 1;
	SGENDER = .;
	IF DM1S_GENDER = 'F' THEN SGENDER = 2;
	IF DM1S_GENDER = 'M' THEN SGENDER = 1;


	DOBYR = FLOOR(PDOB/10000);
	SDOBYR = FLOOR(SDOB/10000);

	KEEP DM1_MATCH REC_ID PGENDER SGENDER DOBYR SDOBYR;
RUN;


/* Read in insole data */
PROC CONTENTS DATA=SUB.INSOLE94;
RUN;

DATA SUBSUB.INSOLE94SUBSET (COMPRESS=YES);
    SET SUB.INSOLE94(KEEP=
	
	REC_ID RETID MARS FLPDYR REJECT
	STATE XOCAH  XOCAWH XOODEP XOPAR
	S002 S003
	N12 AGEP AGES

	E18500 E19300 E17000 E04470 
	PBI SBI

	CWHSI

	S006 

	/* Form 1040 income variables */
	E00100 E00200 E00300 E00400
	E00600 E00900 E01000 E01100 E01200 E02000 E02100

	/* Partnership and scorp variales */
	E25920 E25940 E25960 E25980 E26160 E26170 E26180 E26190 E26500

	/* Sole prop variables */
	INDYC INDYC1 INDYC2 INDYC3 DOMC SEXPRC SXPRC1 SXPRC2 SXPRC3	
	E90020 E91020 E92020 E93020
	E90440 E91440 E92440 E93440
	E90350 E91350 E92350 E93350
	E90370 E90100

	E90470 E90200 E90290 E90190 E90550 

/* Depreciation Variables */
	E54010 E54015 E54100 E57800 E57900 E58020 E58040 E58100 E58120 E58140 E58060 E58200 E58250 E58300


	/* Capital gain variables */
	E22310 E22315 
	E21700 E21750 E22350 E22360

	/* Adjusted total income variables */
	E02650 E00400 E01500 E01700 E01300 E01400 E02400 E02500

	E02600  AGEP AGES N6 E23250 E22250 XTOT E09400 E03500 E32700 E19300 E19700 E03300

	/****** Convert names to Family panel names ***/
	RENAME=(

	RETID	= 	RETIDCHAR
	MARS	=	MARSCHAR
	FLPDYR	=	TAXYRCHAR
	REJECT	=	REJECT
	STATE	=	STATECHAR
	XOCAH	=	CAHECHAR
	XOCAWH	=	CAFHECHAR
	XOODEP 	=	OTHDEPECHAR
	XOPAR	=	PARECHAR
	PBI		=	PBICHAR	
	SBI		=	SBICHAR
	N12     =   num_sch_c

	S002	=	issnp
	S003	=	issns
	CWHSI	=	CWHSICHAR

	E18500  = 	PROPTAX 
 	E19300  = 	MORTINT 
	E17000  =	MEDDED 
	E04470 	=	TOTDED 

	E00100 	= 	AGIX
	E00200	=	WAS 
	E00300 	= 	INT
	E00600 	= 	DIV
	E00900 	= 	BIL
	E01000 	= 	CGAGIX 
	E01100	=	CGDIST
	E01200 	= 	SUPPGL 
	E02000 	=  SCHE
	E02100 	=  FIL

	E26500 	=	ESTTRUST

	E90020 	=  SOLEGRRECEIPTC
	E91020 	=  SOLEGRRECEIPT1
	E92020	=  SOLEGRRECEIPT2
	E93020   =  SOLEGRRECEIPT3	

	E90440 	=  SOLENETINCC
	E91440 	=  SOLENETINC1
	E92440	=  SOLENETINC2
	E93440   =  SOLENETINC3

	E90370	=	SOLEWAGESC
	E90100	=	SOLEEXPC

	E90470  =   SOLELABORCOGSC
	E90200  =   SOLEEMPBENC
	E90290  =   SOLEPENPROFITC
	E90190  =   SOLEDEPRC
	E90550  =   SOLEPAYROLLCOGSC

	E02650 	=	TOTINCX
	E00400	=	TEXINT
	E01500	=	GRPEN
	E01700	=	PTPEN
	E01300	=	GRIRAD
	E01400	=	TIRAD
	E02400	=	SSINC
	E02500	=	SSAGIX

	S006	=	WGT

	E02600 = othinc
	N6 = deps
	E23250 = netltcg
	E22250 = netstcg
	XTOT = iexemh
	E09400 = secatx
	E03500 = alip
	E32700 = childcare
	E19700 = charity
	E03300 = keogh

	) 

	);
	
	/* Keep non-rejected returns */
	if REJECT=0;

	/* Generate indicator for being sampled with probability 1 */
	HIINC = (WGT = 1);

	/* Convert possibly char variables to numbers */
	RETID = RETIDCHAR*1;
	CWHSI = CWHSICHAR*1;
	TAXYR = TAXYRCHAR*1;
	MARS = MARSCHAR*1;
	STATE = STATECHAR*1;
	CAHE = CAHECHAR*1;
	CAFHE = CAFHECHAR*1;
	OTHDEPE = OTHDEPECHAR*1;
	PARE = PARECHAR*1;
	PBI = PBICHAR*1;
	SBI = SBICHAR*1;
	
	DROP RETIDCHAR CWHSICHAR TAXYRCHAR MARSCHAR STATECHAR CAHECHAR CAFHECHAR OTHDEPECHAR PARECHAR PBICHAR SBICHAR;

	/* Calculate passive and active net partnership, SBC, and Scorp income */
	PARTPAS = E25940 - E25920;
	PARTACT = E25980 - E25960;
	PART = PARTPAS + PARTACT;
	SBC = 0;
	SCORPPAS = E26170 - E26160;
	SCORPACT = E26190 - E26180;
	SCORP = SCORPPAS + SCORPACT;
	DROP E25920 E25940 E25960 E25980 E26160 E26170 E26180 E26190;

	/* Subtract off nondeductible meals and entertainment to make 
	   consistent with pre-TRA86 law (when total was deductible) */

    NDMEALENTC = E90350;
	NDMEALENT1 = E91350;
	NDMEALENT2 = E92350;
	NDMEALENT3 = E93350;

	SOLENETINCC = SOLENETINCC - NDMEALENTC;
	SOLENETINC1 = SOLENETINC1 - NDMEALENT1;
	SOLENETINC2 = SOLENETINC2 - NDMEALENT2;
	SOLENETINC3 = SOLENETINC3 - NDMEALENT3;

	DROP E90350 E91350 E92350 E93350;

	/* Sole prop gain (plus gains from other forms) */
	SOLEGAINPLUS = E22310 - E22315;
	DROP E22310 E22315;

	/* Partnership and scorp gain */
	PARTSCORPGAIN = (E21700 - E21750) + (E22350 - E22360);
	DROP E21700 E21750 E22350 E22360;

	/* Calculate adjusted total income */
	ptpexc = max(grpen - ptpen, 0);
	iraexc = max(grirad - tirad, 0);
	ssexc = max(ssinc - ssagix, 0);

	ADJTOTINC = totincx + texint + iraexc + ptpexc + ssexc;

	/* Merge in DOB and gender information */
	set INSOLE94DM1 key = REC_ID /unique ;

	/* Variable denoting file's year */
	fileyr = 1994;

RUN;      




/* 1995 INSOLE */


/* Read DM1 data, a dataset with date of birth and gender information, and create variables for merging
	into insole */
DATA INSOLE95DM1 (index=(rec_id));
    SET SUB2.DM1X95(KEEP=
	REC_ID
	DM1_MATCH 
	DM1P_DOB DM1S_DOB
	DM1P_GENDER DM1S_GENDER

	RENAME=(
	DM1P_DOB = PDOB
	DM1S_DOB = SDOB

	)
	);


	PGENDER = .;
	IF DM1P_GENDER = 'F' THEN PGENDER = 2;
	IF DM1P_GENDER = 'M' THEN PGENDER = 1;
	SGENDER = .;
	IF DM1S_GENDER = 'F' THEN SGENDER = 2;
	IF DM1S_GENDER = 'M' THEN SGENDER = 1;


	DOBYR = FLOOR(PDOB/10000);
	SDOBYR = FLOOR(SDOB/10000);

	KEEP DM1_MATCH REC_ID PGENDER SGENDER DOBYR SDOBYR;
RUN;


/* Read in insole data */
PROC CONTENTS DATA=SUB.INSOLE95;
RUN;

DATA SUBSUB.INSOLE95SUBSET (COMPRESS=YES);
    SET SUB.INSOLE95(KEEP=
	
	REC_ID RETID MARS FLPDYR REJECT
	STATE XOCAH  XOCAWH XOODEP XOPAR
	S002 S003
	N12 AGEP AGES

	E18500 E19300 E17000 E04470 
	PBI SBI

	CWHSI

	S006 

	/* Form 1040 income variables */
	E00100 E00200 E00300 E00400
	E00600 E00900 E01000 E01100 E01200 E02000 E02100

	/* Partnership and scorp variales */
	E25920 E25940 E25960 E25980 E26160 E26170 E26180 E26190 E26500

	/* Sole prop variables */
	INDYC INDYC1 INDYC2 INDYC3 DOMC SEXPRC SXPRC1 SXPRC2 SXPRC3	
	E90020 E91020 E92020 E93020
	E90440 E91440 E92440 E93440
	E90350 E91350 E92350 E93350
	E90370 E90100

	E90470 E90200 E90290 E90190 E90550 E90570 E90445 

	/* Depreciation Variables */
	E54010 E54015 E54100 E57800 E57900 E58020 E58040 E58100 E58120 E58140 E58060 E58200 E58250 E58300


	/* Capital gain variables */
	E22310 E22315 LTSOCA
	E21700 E21750 E22350 E22360

	/* Adjusted total income variables */
	E02650 E00400 E01500 E01700 E01300 E01400 E02400 E02500

	E02600  AGEP AGES N6 E23250 E22250 XTOT E09400 E03500 E32700 E19300 E19700 E03300

	/****** Convert names to Family panel names ***/
	RENAME=(

	RETID	= 	RETIDCHAR
	MARS	=	MARSCHAR
	FLPDYR	=	TAXYRCHAR
	REJECT	=	REJECT
	STATE	=	STATECHAR
	XOCAH	=	CAHECHAR
	XOCAWH	=	CAFHECHAR
	XOODEP 	=	OTHDEPECHAR
	XOPAR	=	PARECHAR
	PBI		=	PBICHAR	
	SBI		=	SBICHAR
	N12     =   num_sch_c

	S002	=	issnp
	S003	=	issns
	CWHSI	=	CWHSICHAR

	E18500  = 	PROPTAX 
 	E19300  = 	MORTINT 
	E17000  =	MEDDED 
	E04470 	=	TOTDED 

	E00100 	= 	AGIX
	E00200	=	WAS 
	E00300 	= 	INT
	E00600 	= 	DIV
	E00900 	= 	BIL
	E01000 	= 	CGAGIX 
	E01100	=	CGDIST
	E01200 	= 	SUPPGL 
	E02000 	=  SCHE
	E02100 	=  FIL

	E26500 	=	ESTTRUST

	E90020 	=  SOLEGRRECEIPTC
	E91020 	=  SOLEGRRECEIPT1
	E92020	=  SOLEGRRECEIPT2
	E93020   =  SOLEGRRECEIPT3	

	E90440 	=  SOLENETINCC
	E91440 	=  SOLENETINC1
	E92440	=  SOLENETINC2
	E93440   =  SOLENETINC3

	E90370	=	SOLEWAGESC
	E90100	=	SOLEEXPC

	E90470  =   SOLELABORCOGSC
	E90200  =   SOLEEMPBENC
	E90290  =   SOLEPENPROFITC
	E90190  =   SOLEDEPRC
	E90550  =   SOLEPAYROLLCOGSC
	E90445  =   SOLEDEPR8829C
	E90570  =   SOLEDEPRCOGSC

	E02650 	=	TOTINCX
	E00400	=	TEXINT
	E01500	=	GRPEN
	E01700	=	PTPEN
	E01300	=	GRIRAD
	E01400	=	TIRAD
	E02400	=	SSINC
	E02500	=	SSAGIX

	S006	=	WGT

	E02600 = othinc
	N6 = deps
	E23250 = netltcg
	E22250 = netstcg
	XTOT = iexemh
	E09400 = secatx
	E03500 = alip
	E32700 = childcare
	E19700 = charity
	E03300 = keogh
	) 

	);
	
	/* Keep non-rejected returns */
	if REJECT=0;

	/* Generate indicator for being sampled with probability 1 */
	HIINC = (WGT = 1);

	/* Convert possibly char variables to numbers */
	RETID = RETIDCHAR*1;
	CWHSI = CWHSICHAR*1;
	TAXYR = TAXYRCHAR*1;
	MARS = MARSCHAR*1;
	STATE = STATECHAR*1;
	CAHE = CAHECHAR*1;
	CAFHE = CAFHECHAR*1;
	OTHDEPE = OTHDEPECHAR*1;
	PARE = PARECHAR*1;
	PBI = PBICHAR*1;
	SBI = SBICHAR*1;
	
	DROP RETIDCHAR CWHSICHAR TAXYRCHAR MARSCHAR STATECHAR CAHECHAR CAFHECHAR OTHDEPECHAR PARECHAR PBICHAR SBICHAR;

	/* Calculate passive and active net partnership, SBC, and Scorp income */
	PARTPAS = E25940 - E25920;
	PARTACT = E25980 - E25960;
	PART = PARTPAS + PARTACT;
	SBC = 0;
	SCORPPAS = E26170 - E26160;
	SCORPACT = E26190 - E26180;
	SCORP = SCORPPAS + SCORPACT;
	DROP E25920 E25940 E25960 E25980 E26160 E26170 E26180 E26190;

	/* Subtract off nondeductible meals and entertainment to make 
	   consistent with pre-TRA86 law (when total was deductible) */

    NDMEALENTC = E90350;
	NDMEALENT1 = E91350;
	NDMEALENT2 = E92350;
	NDMEALENT3 = E93350;

	SOLENETINCC = SOLENETINCC - NDMEALENTC;
	SOLENETINC1 = SOLENETINC1 - NDMEALENT1;
	SOLENETINC2 = SOLENETINC2 - NDMEALENT2;
	SOLENETINC3 = SOLENETINC3 - NDMEALENT3;

	DROP E90350 E91350 E92350 E93350;

	/* Sole prop gain (plus gains from other forms) */
	SOLEGAINPLUS = E22310 - E22315;
	DROP E22310 E22315;
	IF LTSOCA = 0 THEN SOLEGAIN = SOLEGAINPLUS;

	/* Partnership and scorp gain */
	PARTSCORPGAIN = (E21700 - E21750) + (E22350 - E22360);
	DROP E21700 E21750 E22350 E22360;

	/* Calculate adjusted total income */
	ptpexc = max(grpen - ptpen, 0);
	iraexc = max(grirad - tirad, 0);
	ssexc = max(ssinc - ssagix, 0);

	ADJTOTINC = totincx + texint + iraexc + ptpexc + ssexc;

	/* Merge in DOB and gender information */
	set INSOLE95DM1 key = REC_ID /unique ;

	/* Variable denoting file's year */
	fileyr = 1995;

RUN;      


/* 1996 INSOLE */


/* Read DM1 data, a dataset with date of birth and gender information, and create variables for merging
	into insole */
DATA INSOLE96DM1 (index=(rec_id));
    SET SUB2.DM1X96(KEEP=
	REC_ID
	DM1_MATCH 
	DM1P_DOB DM1S_DOB
	DM1P_GENDER DM1S_GENDER

	RENAME=(
	DM1P_DOB = PDOB
	DM1S_DOB = SDOB

	)
	);


	PGENDER = .;
	IF DM1P_GENDER = 'F' THEN PGENDER = 2;
	IF DM1P_GENDER = 'M' THEN PGENDER = 1;
	SGENDER = .;
	IF DM1S_GENDER = 'F' THEN SGENDER = 2;
	IF DM1S_GENDER = 'M' THEN SGENDER = 1;


	DOBYR = FLOOR(PDOB/10000);
	SDOBYR = FLOOR(SDOB/10000);

	KEEP DM1_MATCH REC_ID PGENDER SGENDER DOBYR SDOBYR;
RUN;


/* Read in insole data */
PROC CONTENTS DATA=SUB.INSOLE96;
RUN;


DATA SUBSUB.INSOLE96SUBSET (COMPRESS=YES);
    SET SUB.INSOLE96(KEEP=
	
	REC_ID RETID MARS FLPDYR REJECT
	STATE XOCAH  XOCAWH XOODEP XOPAR
	S002 S003
	N12 AGEP AGES

	E18500 E19300 E17000 E04470 
	PBI SBI

	CWHSI

	S006 

	/* Form 1040 income variables */
	E00100 E00200 E00300 E00400
	E00600 E00900 E01000 E01100 E01200 E02000 E02100

	/* Partnership and scorp variales */
	E25920 E25940 E25960 E25980 E26160 E26170 E26180 E26190 E26500

	/* Sole prop variables */
	INDYC INDYC1 INDYC2 INDYC3 DOMC SEXPRC SXPRC1 SXPRC2 SXPRC3	
	E90020 E91020 E92020 E93020
	E90440 E91440 E92440 E93440
	E90350 E91350 E92350 E93350
	E90370 E90100

	E90470 E90200 E90290 E90190 E90550 E90570 E90445 

	/* Depreciation Variables */
	E54010 E54015 E54100 E57800 E57900 E58020 E58040 E58100 	E58120 E58140 E58060 E58200 E58250 E58300


	/* Capital gain variables */
	E22310 E22315 LTSOCA
	E21700 E21750 E22350 E22360

	/* Adjusted total income variables */
	E02650 E00400 E01500 E01700 E01300 E01400 E02400 E02500

	E02600  AGEP AGES N6 E23250 E22250 XTOT E09400 E03500 E32700 E19300 E19700 E03300

	/****** Convert names to Family panel names ***/
	RENAME=(

	RETID	= 	RETIDCHAR
	MARS	=	MARSCHAR
	FLPDYR	=	TAXYRCHAR
	REJECT	=	REJECT
	STATE	=	STATECHAR
	XOCAH	=	CAHECHAR
	XOCAWH	=	CAFHECHAR
	XOODEP 	=	OTHDEPECHAR
	XOPAR	=	PARECHAR
	PBI		=	PBICHAR	
	SBI		=	SBICHAR
	N12     =   num_sch_c

	S002	=	issnp
	S003	=	issns
	CWHSI	=	CWHSICHAR

	E18500  = 	PROPTAX 
 	E19300  = 	MORTINT 
	E17000  =	MEDDED 
	E04470 	=	TOTDED 

	E00100 	= 	AGIX
	E00200	=	WAS 
	E00300 	= 	INT
	E00600 	= 	DIV
	E00900 	= 	BIL
	E01000 	= 	CGAGIX 
	E01100	=	CGDIST
	E01200 	= 	SUPPGL 
	E02000 	=  SCHE
	E02100 	=  FIL

	E26500 	=	ESTTRUST

	E90020 	=  SOLEGRRECEIPTC
	E91020 	=  SOLEGRRECEIPT1
	E92020	=  SOLEGRRECEIPT2
	E93020   =  SOLEGRRECEIPT3	

	E90440 	=  SOLENETINCC
	E91440 	=  SOLENETINC1
	E92440	=  SOLENETINC2
	E93440   =  SOLENETINC3

	E90370	=	SOLEWAGESC
	E90100	=	SOLEEXPC

	E90470  =   SOLELABORCOGSC
	E90200  =   SOLEEMPBENC
	E90290  =   SOLEPENPROFITC
	E90190  =   SOLEDEPRC
	E90550  =   SOLEPAYROLLCOGSC
	E90445  =   SOLEDEPR8829C
	E90570  =   SOLEDEPRCOGSC

	E02650 	=	TOTINCX
	E00400	=	TEXINT
	E01500	=	GRPEN
	E01700	=	PTPEN
	E01300	=	GRIRAD
	E01400	=	TIRAD
	E02400	=	SSINC
	E02500	=	SSAGIX

	S006	=	WGT

	E02600 = othinc
	N6 = deps
	E23250 = netltcg
	E22250 = netstcg
	XTOT = iexemh
	E09400 = secatx
	E03500 = alip
	E32700 = childcare
	E19700 = charity
	E03300 = keogh
	) 

	);
	
	/* Keep non-rejected returns */
	if REJECT=0;

	/* Generate indicator for being sampled with probability 1 */
	HIINC = (WGT = 1);

	/* Convert possibly char variables to numbers */
	RETID = RETIDCHAR*1;
	CWHSI = CWHSICHAR*1;
	TAXYR = TAXYRCHAR*1;
	MARS = MARSCHAR*1;
	STATE = STATECHAR*1;
	CAHE = CAHECHAR*1;
	CAFHE = CAFHECHAR*1;
	OTHDEPE = OTHDEPECHAR*1;
	PARE = PARECHAR*1;
	PBI = PBICHAR*1;
	SBI = SBICHAR*1;
	
	DROP RETIDCHAR CWHSICHAR TAXYRCHAR MARSCHAR STATECHAR CAHECHAR CAFHECHAR OTHDEPECHAR PARECHAR PBICHAR SBICHAR;

	/* Calculate passive and active net partnership, SBC, and Scorp income */
	PARTPAS = E25940 - E25920;
	PARTACT = E25980 - E25960;
	PART = PARTPAS + PARTACT;
	SBC = 0;
	SCORPPAS = E26170 - E26160;
	SCORPACT = E26190 - E26180;
	SCORP = SCORPPAS + SCORPACT;
	DROP E25920 E25940 E25960 E25980 E26160 E26170 E26180 E26190;

	/* Subtract off nondeductible meals and entertainment to make 
	   consistent with pre-TRA86 law (when total was deductible) */

    NDMEALENTC = E90350;
	NDMEALENT1 = E91350;
	NDMEALENT2 = E92350;
	NDMEALENT3 = E93350;

	SOLENETINCC = SOLENETINCC - NDMEALENTC;
	SOLENETINC1 = SOLENETINC1 - NDMEALENT1;
	SOLENETINC2 = SOLENETINC2 - NDMEALENT2;
	SOLENETINC3 = SOLENETINC3 - NDMEALENT3;

	DROP E90350 E91350 E92350 E93350;

	/* Sole prop gain (plus gains from other forms) */
	SOLEGAINPLUS = E22310 - E22315;
	DROP E22310 E22315;
	IF LTSOCA = 0 THEN SOLEGAIN = SOLEGAINPLUS;

	/* Partnership and scorp gain */
	PARTSCORPGAIN = (E21700 - E21750) + (E22350 - E22360);
	DROP E21700 E21750 E22350 E22360;

	/* Calculate adjusted total income */
	ptpexc = max(grpen - ptpen, 0);
	iraexc = max(grirad - tirad, 0);
	ssexc = max(ssinc - ssagix, 0);

	ADJTOTINC = totincx + texint + iraexc + ptpexc + ssexc;

	/* Merge in DOB and gender information */
	set INSOLE96DM1 key = REC_ID /unique ;

	/* Variable denoting file's year */
	fileyr = 1996;

RUN;      




/* Append all of the yearly files together */

DATA SUBSUB.INSOLE87_96 (COMPRESS=YES);
    SET 	SUBSUB.INSOLE87SUBSET 
		SUBSUB.INSOLE88SUBSET
		SUBSUB.INSOLE89SUBSET
		SUBSUB.INSOLE90SUBSET
		SUBSUB.INSOLE91SUBSET
		SUBSUB.INSOLE92SUBSET
		SUBSUB.INSOLE93SUBSET
		SUBSUB.INSOLE94SUBSET
		SUBSUB.INSOLE95SUBSET
		SUBSUB.INSOLE96SUBSET;

	blnde = pbi + sbi ;
	agenum = AGEP+ AGES ;
	agede = agenum ;
	year = taxyr ;
	retx = proptax ;
	intpaid = mortint ;
	if taxyr < 100 then taxyr = taxyr + 1900 ;
	in_insole = 1 ;
RUN;



LIBNAME     SUB    "G:\EM&CA\DATA\Individual";
LIBNAME     SUB2    "G:\REV_EST\DeBacker\Panel8706";
LIBNAME     SUBSUB    "G:\REV_EST\DeBacker\Panel8706\LaborInc";


proc sort data = SUBSUB.INSOLE87_96 ;
	by fileyr ;
run ;
proc means data = SUBSUB.INSOLE87_96 nolabels ;
	by fileyr ;
var issnp E54010
E54015
	E54100
		E58100
		E57800
		E57900
		E58250
	E58200	
	E58300
		E58060
	E58120
	E58140 ;
run ;


/*********** MERGE WITH Family Panel for additional VARIABLES ***********/
/*********** MERGE WITH Family Panel for additional VARIABLES ***********/
PROC SORT DATA=SUBSUB.FP1987_96full ;
	BY issnp taxyr ;
RUN;

PROC SORT DATA=SUBSUB.INSOLE87_96 ;
	BY issnp taxyr ;
RUN;

DATA SUBSUB.INSOLE87_96;
  MERGE SUBSUB.FP1987_96full SUBSUB.INSOLE87_96 ; /* NOTE that merge uses variable values from second dataset in the case of them having the same name */
  BY issnp taxyr; 
RUN; 



PROC MEANS DATA=SUBSUB.INSOLE87_96;
	VAR solenetincc scorp part in_fp in_insole ;
RUN;

PROC SORT DATA=SUBSUB.INSOLE87_96 ;
	BY fileyr ;
RUN;

PROC MEANS DATA=SUBSUB.INSOLE87_96;
	VAR issnp ;
	class fileyr ;
RUN;

