/*OPTIONS NOCENTER LS=155 PS=60 COMPRESS=YES NOFMTERR;*/
/***********************************************************************/
/*  Subset data from the 1979-1986 Insoles to be merged with data      */
/*  from the family panel and 1997-06 insoles for use in labor income  */
/*  project.                                                           */
/***********************************************************************/
LIBNAME     SUB    "G:\EM&CA\DATA\Individual";
LIBNAME     SUB2    "G:\REV_EST\DeBacker\Panel8706";
LIBNAME     SUBSUB  "G:\REV_EST\DeBacker\Panel8706\LaborInc";



/* 1979 INSOLE */
PROC CONTENTS DATA=SUB.INSOLE79;
RUN;

DATA SUBSUB.INSOLE79SUBSET (COMPRESS=YES);
    SET SUB.INSOLE79(KEEP=
	
	RETID MARS FLPDYR REJECT
	STATE 
	N9  N10 N11 N12 N13
	PSSN SSSN
	N7
	S006 

	E130 E132 E136 E135 E138 E142 E146

	/* Form 1040 income */
	E73 E50	E51 E52 E56 E57 E58 E60	E61 	

	/* Schedule E income */
	E204 E205 E210 E211
	E209

E111 E114 E83 E55 E63 E62 E59 E54 E53
E155 E152 E200 E103 E75 E74
E101 E202 E203 E67 E68
E64

E64 N6 N8 N4 E70 E133 E142



	/****** Convert names to Family panel names ***/
	RENAME=(

	RETID	= 	RETIDCHAR
	MARS	=	MARSCHAR
	FLPDYR	=	TAXYRCHAR
	REJECT	=	REJECT
	STATE	=	STATECHAR
	N9		=	CAHECHAR
	N10		=	CAFHECHAR
	N13 	=	OTHDEPECHAR
		
	PSSN	=	issnp
	SSSN	=	issns

	E130   =	MEDDED
	E132   = 	PROPTAX 
 	E136   = 	MORTINT 
 

	E73 	= 	AGIX
	E50		=	WAS 
	E51 	= 	INT
	E52 	= 	DIV
	E56 	= 	BIL
	E57 	= 	CGAGIX 
	E58 	= 	SUPPGL 
	E60	    = 	SCHE
	E61 	=  FIL

	E209	=	ESTTRUST


	N7 = PBI

	S006	=	WGT

	E111 = tot_liab
	E114 = eicx
	E83 = wincredc
	E55 = alimony
	E63 = ucagix
	E62 = uncomp
	e64 = othinc
	E59 = ptpen
	E54 = sitr	
	E53 = divagix
	E155 = nltgl
	E152 = nstgl
	E200 = grpen
	E103 = secatx
	E75 = totincx
	E74 = tot_ded
	E101 = tot_credit
	E202 = net_rent_e
	E203 = net_royal_e
	E67 = ira
	E68 = keogh

	N6 = agenum
	N8 = deps
	N4 = iexemh
	E70 = alip
	E133 = salestax
	E142 = charity


	) 

	);
	
	/* Keep non-rejected returns */
	if REJECT=0;


	/* Generate indicator for being sampled with probability 1 */
	HIINC = (WGT = 1);

	/* Convert possibly char variables to numbers */
	RETID = RETIDCHAR*1;
	TAXYR = TAXYRCHAR*1;
	MARS = MARSCHAR*1;
	STATE = STATECHAR*1;
	CAHE = CAHECHAR*1;
	CAFHE = CAFHECHAR*1;
	OTHDEPE = OTHDEPECHAR*1;
	PARE = N11+N12;
	DROP N11 N12;

	DROP RETIDCHAR TAXYRCHAR MARSCHAR STATECHAR CAHECHAR CAFHECHAR OTHDEPECHAR;

	/* total deductions variable */
	TOTDED = MEDDED + E135 + E138 + charity + E146;
	DROP E135 E138 charity E146;

	/* Secondary blindness not available */
	SBI = (PBI = 2);
	PBI = (PBI > 0);
	/* Tax exempt interest not applicable */
	TEXINT = 0;

	/* Calculate net partnership, SBC, and Scorp income */
	PART = E204 - E205;
	SBC = E210 - E211;
	SCORP = 0;
	DROP E204 E205 E210 E211;

	/* Calculate adjusted total income */
	CGD40 = 0;

	/* Variable denoting file's year */
	fileyr = 1979;

	childcare = 0 ;

RUN;      



/* 1980 INSOLE */
PROC CONTENTS DATA=SUB.INSOLE80;
RUN;

DATA SUBSUB.INSOLE80SUBSET (COMPRESS=YES);
    SET SUB.INSOLE80(KEEP=
	
	RETURN_ID MARS FLPDYR REJECT
	STATE 
	XOCAH  XOCAWH XOODEP XOPAR
	N7

	WEIGHTD	
	PSSN_HI PSSN_LO SSSN_HI SSSN_LO
	E130 E132 E136 E135 E138 E142 E146

	/* Form 1040 income variables */
	E73 E50	E51 E52 E56 E57 E58 E59 E60 E61 

	/* Schedule E variables */
	E202 E203 E206 E209 E212

	/* Partnership and Scorp income */
	E204 E205 E210 E211

	E111 E114 E680 E83 E63 E62 E55 
	E53 E155 E152 E201 E103 E75 E74 E101
	E67 E68 E60_ e64

	E64 E132 N6 N8 N4 E70 E133 E142



	/****** Convert names to Family panel names ***/
	RENAME=(

	RETURN_ID	= 	RETIDCHAR
	MARS	=	MARSCHAR
	FLPDYR	=	TAXYRCHAR
	REJECT	=	REJECT
	STATE	=	STATECHAR
	XOCAH	=	CAHECHAR
	XOCAWH	=	CAFHECHAR
	XOODEP 	=	OTHDEPECHAR
	XOPAR	=	PARECHAR

	E130   =	MEDDED 
	E132   = 	PROPTAX 
 	E136   = 	MORTINT 


	E73 	= 	AGIX
	E50	=	WAS 
	E51 	= 	INT
	E52 	= 	DIV
	E57 	= 	BIL
	E58 	= 	CGAGIX 
	E59 	= 	SUPPGL 
	E60_ 	=  SCHE /* note that this was corrected from Brad's original code - he had "E60" not "E60_" */
	E61 	=  FIL

	E209 	=	ESTTRUST

	N7 = PBI

	WEIGHTD	=	WGT

	E111 = tot_liab
	E114 = eicx
	E680 = solenetincc
	E83 = wincredc
	E56 = alimony
	E63 = ucagix
	E62 = uncomp
	e64 = othinc
	E60 = ptpen
	E55 = sitr
	E53 = divagix
	E155 = nltgl
	E152 = nstgl
	E201 = grpen
	E103 = secatx
	E75 = totincx
	E74 = tot_ded
	E101 = tot_credit
	E202 = net_rent_e
	E203 = net_royal_e
	E67 = ira
	E68 = keogh

	N6 = agenum
	N8 = deps
	N4 = iexemh
	E70 = alip
	E133 = salestax
 	E142 = charity

	) 

	);
	
	/* Keep non-rejected returns */
	if REJECT=0;

	/* Social security number is in two parts */
	issnp = PSSN_HI*10000+PSSN_LO;
	issns = SSSN_HI*10000+SSSN_LO;
	drop PSSN_HI PSSN_LO SSSN_HI SSSN_LO;


	/* Generate indicator for being sampled with probability 1 */
	HIINC = (WGT = 1);

	/* Convert possibly char variables to numbers */
	RETID = RETIDCHAR*1;
	TAXYR = TAXYRCHAR*1;
	MARS = MARSCHAR*1;
	STATE = STATECHAR*1;
	CAHE = CAHECHAR*1;
	CAFHE = CAFHECHAR*1;
	OTHDEPE = OTHDEPECHAR*1;
	PARE = PARECHAR*1;

	DROP RETIDCHAR TAXYRCHAR MARSCHAR STATECHAR CAHECHAR CAFHECHAR OTHDEPECHAR PARECHAR;

	/* total deductions variable */
	TOTDED = MEDDED + E135 + E138 + charity + E146;
	DROP E135 E138 charity E146;

	/* Secondary blindness not available */
	SBI = (PBI = 2);
	PBI = (PBI > 0);
	/* Tax exempt interest not applicable */
	TEXINT = 0;

	/* Calculate net partnership, SBC, and Scorp income */
	PART = E204 - E205;
	SBC = E210 - E211;
	SCORP = 0;
	DROP E204 E205 E210 E211;

	/* Total schedule E not available */
	SCHE = net_rent_e + net_royal_e + E206 + ESTTRUST + E212;
	DROP E206 E212;

	/* Calculate adjusted total income */
	CGD40 = 0;

	/* Variable denoting file's year */
	fileyr = 1980;

	childcare = 0 ;

RUN;  



/* 1981 INSOLE */
PROC CONTENTS DATA=SUB.INSOLE81;
RUN;

DATA SUBSUB.INSOLE81SUBSET (COMPRESS=YES);
    SET SUB.INSOLE81(KEEP=
	
	S001 MARS FLPDYR 
	STATE 
	XOCAH  XOCAWH XOODEP XOPAR
		N5

	S002 S003
	E133 E135 E139 E147

	S006

	/* Form 1040 variables */
	E76 	E50		E51 	E52 	E57 	E58 	E59 	E62 	E63 	

	/* Partnership and scorp variales */
	E203 E204 E208 E209 E206 E207 

	/* Sole prop variables */
	INDYC DOMSEQ SEXPRC
	E511 E1511 E2511 E2611
	E544 E1544 E2544 E2644
	E513 E1513 E2513 E2613
	E541 E1541 E2541 E2641
	E542 E1542 E2542 E2642
	E539 E543

	/* Capital gain variables */
	E308

	E114 E117 E544 E513 E542 E541 E56 e65 e66 e61 e55
	e51 e52 e53 e58 e304 e305 e301 e302 e60 e107 e76 e77 e105
	e200 e201 e69 e70 e64

	E66 E135 N4 N6 XTOT E72 E136 E210 E144


	/****** Convert names to Family panel names ***/
	RENAME=(

	S001	= 	RETIDCHAR
	MARS	=	MARSCHAR
	FLPDYR	=	TAXYRCHAR
	STATE	=	STATECHAR
	XOCAH	=	CAHECHAR
	XOCAWH	=	CAFHECHAR
	XOODEP 	=	OTHDEPECHAR
	XOPAR	=	PARECHAR

	S002	=	issnp
	S003	=	issns

	E133   =	MEDDED 
	E135   = 	PROPTAX 
 	E139   = 	MORTINT 
	E147	=	TOTDED
	

	E76 	= 	AGIX
	E50		=	WAS 
	E51 	= 	INT
	E52 	= 	DIV
	E57 	= 	BIL
	E58 	= 	CGAGIX 
	E59 	= 	SUPPGL 
	E62 	=  SCHE
	E63 	=  FIL

	DOMSEQ	=	DOMC

	E511 	=  SOLEGRRECEIPTC
	E1511 	=  SOLEGRRECEIPT1
	E2511	=  SOLEGRRECEIPT2
	E2611   =  SOLEGRRECEIPT3	

	E544 	=  SOLENETINCC
	E1544 	=  SOLENETINC1
	E2544	=  SOLENETINC2
	E2644   =  SOLENETINC3	

	E539	=	SOLEWAGESC
	E543	=	SOLEEXPC

	E308 	=	SOLEGAIN

	N5 = PBI

	S006	=	WGT


	E114 = tot_liab
	E117 = eicx
	E56 = alimony
	e65 = ucagix
	e66 = othinc
	e64 = uncomp
	e61 = ptpen
	e55 = sitr
	e53 = divagix
	e304= cg_lt_loss
	e305= cg_lt_gain 
	e301= cg_st_loss
	e302 =cg_st_gain
	e60 = grpen
	e107 = secatx
	e77 = tot_ded
	e105 = tot_credit
	e200 = net_rent_e
	e201 = net_royal_e
	e69 = ira
	e70 = keogh
	
	N4 = agenum
	N6 = deps
	XTOT = iexemh
	E72 = alip
	E136 = salestax
	E210 = childcare
	E144 = charity

		) 

	);
	
	/* Keep non-rejected returns */
	REJECT = 0;
	if REJECT=0;


	/* Generate indicator for being sampled with probability 1 */
	HIINC = (WGT = 1);

	/* Convert possibly char variables to numbers */
	RETID = RETIDCHAR*1;
	TAXYR = TAXYRCHAR*1;
	MARS = MARSCHAR*1;
	STATE = STATECHAR*1;
	CAHE = CAHECHAR*1;
	CAFHE = CAFHECHAR*1;
	OTHDEPE = OTHDEPECHAR*1;
	PARE = PARECHAR*1;

	DROP RETIDCHAR TAXYRCHAR MARSCHAR STATECHAR CAHECHAR CAFHECHAR OTHDEPECHAR PARECHAR;

	/* Secondary blindness not available */
	SBI = (PBI = 2);
	PBI = (PBI > 0);
	/* Tax exempt interest not applicable */
	TEXINT = 0;

	/* Calculate net partnership, SBC, and Scorp income */
	PART = E203 - E204;
	SBC = E208 - E209;
	SCORP = 0;
	ESTTRUST = E206 - E207;
	DROP E203 E204 E208 E209 E206 E207;



	/* Add back windfall profit tax and WIN credit (not available some years)*/

	WPTC = E542 - E513;
	WPT1 = E1542 - E1513;
	WPT2 = E2542 - E2513;
	WPT3 = E2642 - E2613;

	WINCREDC = E541;
	WINCRED1 = E1541;
	WINCRED2 = E2541;
	WINCRED3 = E2641;

	SOLENETINCC = SOLENETINCC + WPTC - WINCREDC;
	SOLENETINC1 = SOLENETINC1 + WPT1 - WINCRED1;
	SOLENETINC2 = SOLENETINC2 + WPT2 - WINCRED2;
	SOLENETINC3 = SOLENETINC3 + WPT3 - WINCRED3;

	/* make net capital gains variables */
	nltgl = cg_lt_gain - cg_lt_loss ;
	nstgl = cg_st_gain - cg_st_loss ; 


	DROP 
		E513 E1513 E2513 E2613
		E541 E1541 E2541 E2641
		E542 E1542 E2542 E2642;

	/* Variable denoting file's year */
	fileyr = 1981;

		/* Calculate adjusted total income */
	CGD40 = 0;

RUN;  



/* 1982 INSOLE */
PROC CONTENTS DATA=SUB.INSOLE82;
RUN;

DATA SUBSUB.INSOLE82SUBSET (COMPRESS=YES);
    SET SUB.INSOLE82(KEEP=
	
	S001 MARS FLPDYR REJECT
	STATE 
	XOCAH  XOCAWH XOODEP XOPAR
	N5

	S002 S003

	E1700	E1850  	E1930  E1690	

	S006

	/* Form 1040 Variables */
	E10 E20	E30 E40 E90 E100 E120 E200 	E210 

	/* Partnership and scorp variables */
	E2590 E2600 E2660 E2670 E2650

	/* Sole prop variables */
	INDYC DOMC SEXPRC
	E6002 E6102 E6202 E6302
	E6044 E6144 E6244 E6344
	E6007 E6107 E6207 E6307
	E6042 E6142 E6242 E6342
	E6037 E6010

	/* Capital gain variables */
	E2290 

	e1030 e1550 e80 e230 e220 e140
	e70 e50 e60 e110 e2320 e2220 e130 e940
	e1290 e810 e2570 e2580 e2650 e320 e330 e240 e160

	E240 E1850 N4 N6 XTOT E350 E1860 E1870 E3270 E1970


	/****** Convert names to Family panel names ***/
	RENAME=(

	S001	= 	RETIDCHAR
	MARS	=	MARSCHAR
	FLPDYR	=	TAXYRCHAR
	STATE	=	STATECHAR
	XOCAH	=	CAHECHAR
	XOCAWH	=	CAFHECHAR
	XOODEP 	=	OTHDEPECHAR
	XOPAR	=	PARECHAR

	S002	=	issnp
	S003	=	issns

	E1700   =	MEDDED 
	E1850   = 	PROPTAX 
 	E1930   = 	MORTINT 
	E1690	=	TOTDED
	N5 = PBI

	E10 	= 	AGIX
	E20		=	WAS 
	E30 	= 	INT
	E40 	= 	DIV
	E90 	= 	BIL
	E100 	= 	CGAGIX 
	E120 	= 	SUPPGL 
	E200 	=  SCHE
	E210 	=  FIL	

	E2650 	= ESTTRUST

	E6002 	=  SOLEGRRECEIPTC
	E6102 	=  SOLEGRRECEIPT1
	E6202	=  SOLEGRRECEIPT2
	E6302   =  SOLEGRRECEIPT3	

	E6044 	=  SOLENETINCC
	E6144 	=  SOLENETINC1
	E6244	=  SOLENETINC2
	E6344   =  SOLENETINC3	

	E2290	=  SOLEGAIN

	E6037	=	SOLEWAGESC
	E6010	=	SOLEEXPC



	S006	=	WGT


	e1030 = tot_liab
	e1550 = eicx
	e80 = alimony
	e230 = ucagix
	e220 = uncomp
	e140 = ptpen
	e70 = sitr
	e50 = excldivint
	e60 = divagix
	e110 = cgd40
	e2320 = nltgl
	e2220 = nstgl
	e130 = grpen
	e940 = secatx
	e1290 = tot_ded
	e810 = tot_credit
	e2570 = net_rent_e
	e2580 = net_royal_e
	e320 = ira
	e330 = keogh


	e240 = othinc

	N4 = agenum
	N6 = deps
	XTOT = iexemh
	E350 = alip
	E3270 = childcare
	E1970 = charity


	) 

	);
	
	/* Keep non-rejected returns */
	if REJECT=0;

	/* Generate indicator for being sampled with probability 1 */
	HIINC = (WGT = 1);

	/* Convert possibly char variables to numbers */
	RETID = RETIDCHAR*1;
	TAXYR = TAXYRCHAR*1;
	MARS = MARSCHAR*1;
	STATE = STATECHAR*1;
	CAHE = CAHECHAR*1;
	CAFHE = CAFHECHAR*1;
	OTHDEPE = OTHDEPECHAR*1;
	PARE = PARECHAR*1;

	DROP RETIDCHAR TAXYRCHAR MARSCHAR STATECHAR CAHECHAR CAFHECHAR OTHDEPECHAR PARECHAR;

	/* Secondary blindness not available */
	SBI = (PBI = 2);
	PBI = (PBI > 0);
	/* Tax exempt interest not applicable */
	TEXINT = 0;

	/* Calculate net partnership, SBC, and Scorp income */
	PART = E2590 - E2600;
	SBC = E2660 - E2670;
	SCORP = 0;
	DROP E2590 E2600 E2660 E2670;

	/* calculate sales taxes paid */
	salestax = E1860+E1870 ;
	drop E1860 E1870 ;

	/* Add back windfall profits tax (not applicable some years) */
	WPTC = E6042 - E6007;
	WPT1 = E6142 - E6107;
	WPT2 = E6242 - E6207;
	WPT3 = E6342 - E6307;

	SOLENETINCC = SOLENETINCC + WPTC;
	SOLENETINC1 = SOLENETINC1 + WPT1;
	SOLENETINC2 = SOLENETINC2 + WPT2;
	SOLENETINC3 = SOLENETINC3 + WPT3;

	DROP E6007 E6107 E6207 E6307
		 E6042 E6142 E6242 E6342;

	/* Variable denoting file's year */
	fileyr = 1982;


RUN;  



/* 1983 INSOLE */
PROC CONTENTS DATA=SUB.INSOLE83;
RUN;

DATA SUBSUB.INSOLE83SUBSET (COMPRESS=YES);
    SET SUB.INSOLE83(KEEP=
	
	S001 MARS FLPDYR REJECT
	STATE 
	XOCAH  XOCAWH XOODEP XOPAR
	N5

	S002 S003
	E1700	E1850  	E1930  E1690	

	S006

	/* Form 1040 income variables */
	E10 E20	E30 E40 E90 E100 E120 E200 	E210 

	/* Partnership and scorp variales */
	E2590 E2600 E2660 E2670 E2650

	/* Sole prop variables */
	INDYC DOMC SEXPRC
	E6002 
	E6044 
	E6007 
	E6042 
	E6037 E6010


	/* Capital gain variables */
	E2290 e1030 e1550 e80 e230 e220 e140 e70
	e50 e60 e110 e2320 e2220 e130 e940 e1290 e810 e2570
	e2580 e320 e325 e325 e330 e100 

	e240 e160
	
	E240 E1850 N4 N6 XTOT E350 E1860 E1870 E3270 E1970


	/****** Convert names to Family panel names ***/
	RENAME=(

	S001	= 	RETIDCHAR
	MARS	=	MARSCHAR
	FLPDYR	=	TAXYRCHAR
	STATE	=	STATECHAR
	XOCAH	=	CAHECHAR
	XOCAWH	=	CAFHECHAR
	XOODEP 	=	OTHDEPECHAR
	XOPAR	=	PARECHAR

	S002	=	issnp
	S003	=	issns

	E1700   =	MEDDED 
	E1850   = 	PROPTAX 
 	E1930   = 	MORTINT 
	E1690	=	TOTDED
	N5 = PBI	

	E10 	= 	AGIX
	E20		=	WAS 
	E30 	= 	INT
	E40 	= 	DIV
	E90 	= 	BIL
	E100 	= 	CGAGIX 
	E120 	= 	SUPPGL 
	E200 	=  SCHE
	E210 	=  FIL

	E2650 	=	ESTTRUST

	E6002 	=  SOLEGRRECEIPTC	

	E6044 	=  SOLENETINCC

	E2290	=  SOLEGAIN

	E6037	=	SOLEWAGESC
	E6010	=	SOLEEXPC


	S006	=	WGT


	e1030 = tot_liab
	e1550 = eicx
	e80 = alimony
	e230 = ucagix
	e220 = uncomp
 	e140 = ptpen
	e70 = sitr
	e50 = excldivint
	e60 = divagix
	e110 = cgd40
	e2320 = nltgl
	e2220 = nstgl
	e130 = grpen
	e940 = secatx
	e1290 = tot_ded
	e810 = tot_credit
	e2570 = net_rent_e
	e2580 = net_royal_e
	e330 = keogh
	N4 = agenum
	N6 = deps
	XTOT = iexemh
	E350 = alip
	E3270 = childcare
	E1970 = charity

	e240 = othinc
	) 

	);
	
	/* Keep non-rejected returns */
	if REJECT=0;

	/* Generate indicator for being sampled with probability 1 */
	HIINC = (WGT = 1);

	/* Convert possibly char variables to numbers */
	RETID = RETIDCHAR*1;
	TAXYR = TAXYRCHAR*1;
	MARS = MARSCHAR*1;
	STATE = STATECHAR*1;
	CAHE = CAHECHAR*1;
	CAFHE = CAFHECHAR*1;
	OTHDEPE = OTHDEPECHAR*1;
	PARE = PARECHAR*1;

	DROP RETIDCHAR TAXYRCHAR MARSCHAR STATECHAR CAHECHAR CAFHECHAR OTHDEPECHAR PARECHAR;

	/* Secondary blindness not available */
	SBI = (PBI = 2);
	PBI = (PBI > 0);
	/* Tax exempt interest not applicable */
	TEXINT = 0;

	/* Calculate net partnership, SBC, and Scorp income */
	PART = E2590 - E2600;
	SBC = E2660 - E2670;
	SCORP = 0;
	DROP E2590 E2600 E2660 E2670;

	/* Add back windfall profits tax (not applicable some years) */
	WPTC = E6042 - E6007;

	SOLENETINCC = SOLENETINCC + WPTC;

	/* add together IRA contributions for current and next year */
	ira = e320 + e325 ;

	/* calculate sales taxes paid */
	salestax = E1860+E1870 ;
	drop E1860 E1870 ;

	DROP E6007 
		 E6042 ;

	/* Variable denoting file's year */
	fileyr = 1983;

RUN;  



/* 1984 INSOLE */
PROC CONTENTS DATA=SUB.INSOLE84;
RUN;

PROC MEANS DATA=SUB.INSOLE84;
VAR E6032 E6033 E6034 E6035 E6036;
RUN; 

DATA SUBSUB.INSOLE84SUBSET (COMPRESS=YES);
    SET SUB.INSOLE84(KEEP=
	
	S001 MARS FLPDYR REJECT
	STATE 
	XOCAH  XOCAWH XOODEP XOPAR
	
	S002 S003

	E1700	E1850  	E1930  E1690	

	N5

	S006

	/* Form 1040 income variables */
	E10 E20	E30 E40 E90 E100 E120 E200 	E210 

	/* Partnership and scorp variales */
	E2590 E2600 E2660 E2670 E2650

	/* Sole prop variables */
	INDYC DOMC SEXPRC
	E6002 E6102 E6202 E6302
	E6044 E6144 E6244 E6344
	E6007 E6107 E6207 E6307
	E6042 E6142 E6242 E6342
	E6037 E6010

	/* Capital gain variables */
	E2290 e1030 e1550 e80 e230 e220 e240
	e140 e70 e50 e60 e110 e250 e2320 e2220 e130 e940
	e1290 e810 e2570 e2580 e320 e325 e330 e100

	e260 e160
	
	E260 E1850 N4 N6 XTOT E350 E1860 E1870 E3270 E1970


	/****** Convert names to Family panel names ***/
	RENAME=(

	S001	= 	RETIDCHAR
	MARS	=	MARSCHAR
	FLPDYR	=	TAXYRCHAR
	STATE	=	STATECHAR
	XOCAH	=	CAHECHAR
	XOCAWH	=	CAFHECHAR
	XOODEP 	=	OTHDEPECHAR
	XOPAR	=	PARECHAR

	S002	=	issnp
	S003	=	issns

	E1700   =	MEDDED 
	E1850   = 	PROPTAX 
 	E1930   = 	MORTINT 
	E1690	=	TOTDED

	N5 = PBI

	S006	=	WGT

	E10 	= 	AGIX
	E20		=	WAS 
	E30 	= 	INT
	E40 	= 	DIV
	E90 	= 	BIL
	E100 	= 	CGAGIX 
	E120 	= 	SUPPGL 
	E200 	=  SCHE
	E210 	=  FIL

	E2650	=	ESTTRUST

	E6002 	=  SOLEGRRECEIPTC
	E6102 	=  SOLEGRRECEIPT1
	E6202	=  SOLEGRRECEIPT2
	E6302   =  SOLEGRRECEIPT3	

	E6044 	=  SOLENETINCC
	E6144 	=  SOLENETINC1
	E6244	=  SOLENETINC2
	E6344   =  SOLENETINC3	

	E2290	=  SOLEGAIN

	E6037	=	SOLEWAGESC
	E6010	=	SOLEEXPC


	e1030 = tot_liab
	e1550 = eicx
	e80 = alimony
	e230 = ucagix
	e220 = uncomp
	e240 = ssinc
	e140 = ptpen
	e70 = sitr
	e50 = excldivint
	e60 = divagix
	e110 = cgd40
	e250 = ssagix
	e2320 = nltgl
	e2220 = nstgl
	e130 = grpen
	e940 = secatx
	e1290 = tot_ded
	e810 = tot_credit
	e2570 = net_rent_e
	e2580 = net_royal_e
	e330 = keogh
	e260 = othinc

	N4 = agenum
	N6 = deps
	XTOT = iexemh
	E350 = alip
	E3270 = childcare
	E1970 = charity

	) 

	);
	
	/* Keep non-rejected returns */
	if REJECT=0;

	/* Generate indicator for being sampled with probability 1 */
	HIINC = (WGT = 1);

	/* Convert possibly char variables to numbers */
	RETID = RETIDCHAR*1;
	TAXYR = TAXYRCHAR*1;
	MARS = MARSCHAR*1;
	STATE = STATECHAR*1;
	CAHE = CAHECHAR*1;
	CAFHE = CAFHECHAR*1;
	OTHDEPE = OTHDEPECHAR*1;
	PARE = PARECHAR*1;

	DROP RETIDCHAR TAXYRCHAR MARSCHAR STATECHAR CAHECHAR CAFHECHAR OTHDEPECHAR PARECHAR;

	/* Secondary blindness not available */
	SBI = (PBI = 2);
	PBI = (PBI > 0);

	/* Tax exempt interest not applicable */
	TEXINT = 0;

	/* Calculate net partnership, SBC, and Scorp income */
	PART = E2590 - E2600;
	SBC = E2660 - E2670;
	SCORP = 0;
	DROP E2590 E2600 E2660 E2670;

/* Add back windfall profits tax (not applicable some years) */
	WPTC = E6042 - E6007;
	WPT1 = E6142 - E6107;
	WPT2 = E6242 - E6207;
	WPT3 = E6342 - E6307;

	SOLENETINCC = SOLENETINCC + WPTC;
	SOLENETINC1 = SOLENETINC1 + WPT1;
	SOLENETINC2 = SOLENETINC2 + WPT2;
	SOLENETINC3 = SOLENETINC3 + WPT3;


	/* add together IRA contributions for current and next year */
	ira = e320 + e325 ;

	/* calculate sales taxes paid */
	salestax = E1860+E1870 ;
	drop E1860 E1870 ;

	DROP E6007 E6107 E6207 E6307
		 E6042 E6142 E6242 E6342;

	/* Variable denoting file's year */
	fileyr = 1984;

RUN;  




/* 1985 INSOLE */

/* Read DM1 data, a dataset with date of birth and gender information, and create variables for merging
	into insole */
DATA INSOLE85DM1 (index=(retid));
    SET SUB2.DM1X85(KEEP=
	RETID
	DM1_MATCH 
	DM1P_DOB DM1S_DOB
	DM1P_GENDER DM1S_GENDER

	RENAME=(
	DM1P_DOB = PDOB
	DM1S_DOB = SDOB

	)
	);

	RETID = RETID;

	PGENDER = .;
	IF DM1P_GENDER = 'F' THEN PGENDER = 2;
	IF DM1P_GENDER = 'M' THEN PGENDER = 1;
	SGENDER = .;
	IF DM1S_GENDER = 'F' THEN SGENDER = 2;
	IF DM1S_GENDER = 'M' THEN SGENDER = 1;

	DOBYR = FLOOR(PDOB/10000);
	SDOBYR = FLOOR(SDOB/10000);


	KEEP DM1_MATCH RETID PGENDER SGENDER DOBYR SDOBYR;
RUN;


/* Read in insole data */
PROC CONTENTS DATA=SUB.INSOLE85;
RUN;


DATA SUBSUB.INSOLE85SUBSET (COMPRESS=YES);
    SET SUB.INSOLE85(KEEP=
	
	RETID MARS FLPDYR REJECT
	STATE 
	XOCAH  XOCAWH XOODEP XOPAR
	
	S002 S003

	E1700	E1850  	E1930  E1690	

	N5

	S006

	/* Form 1040 income variables */
	E10 E20	E30 E40 E90 E100 E120 E200 	E210 

	/* Partnership and scorp variales */
	E2590 E2600 E2605 E2607 E2650

	/* Sole prop variables */
	INDYC DOMC SEXPRC
	E6002 
	E6044 
	E6007 
	E6042
	E6037 E6010

	/* Capital gain variables */
	E2290 e1030 e1550 e80 e230 e220 e240 e140
	e70 e50 e60 e110 e250 e2320 e2220 e130 e940 e1290
	e810 e2570 e2580 e320 e325 e330 e100

	e160 e260

	E260 E1850 N4 N6 XTOT E350 E1860 E1870 E3270 E1970


	/****** Convert names to Family panel names ***/
	RENAME=(

	RETID	= 	RETIDCHAR
	MARS	=	MARSCHAR
	FLPDYR	=	TAXYRCHAR
	STATE	=	STATECHAR
	XOCAH	=	CAHECHAR
	XOCAWH	=	CAFHECHAR
	XOODEP 	=	OTHDEPECHAR
	XOPAR	=	PARECHAR

	S002	=	issnp
	S003	=	issns

	E1700   =	MEDDED 
	E1850   = 	PROPTAX 
 	E1930   = 	MORTINT 
	E1690	=	TOTDED
	
	N5 = PBI

	S006	=	WGT

	E10 	= 	AGIX
	E20		=	WAS 
	E30 	= 	INT
	E40 	= 	DIV
	E90 	= 	BIL
	E100 	= 	CGAGIX 
	E120 	= 	SUPPGL 
	E200 	=  SCHE
	E210 	=  FIL

	E2650	=	ESTTRUST

	E6002 	=  SOLEGRRECEIPTC

	E6044 	=  SOLENETINCC

	E6037	=	SOLEWAGESC
	E6010	=	SOLEEXPC

	E2290	=  SOLEGAIN

	e1030 = tot_liab
	e1550 = eicx
	e80 = alimony
	e230 = ucagix
	e220 = uncomp
	e240 = ssinc
	e140 = ptpen
	e70 = sitr
	e50 = excldivint
	e60 = divagix
	e110 = cgd40
	e250 = ssagix
	e2320 = nltgl
	e2220 = nstgl
	e130 = grpen
	e940 = secatx
	e1290 = tot_ded
	e810 = tot_credit
	e2570 = net_rent_e
	e2580 = net_royal_e
	e330 = keogh
	e260 = othinc

	N4 = agenum
	N6 = deps
	XTOT = iexemh
	E350 = alip
	E3270 = childcare
	E1970 = charity

	) 

	);
	


	/* Keep non-rejected returns */
	if REJECT=0;

	/* Generate indicator for being sampled with probability 1 */
	HIINC = (WGT = 1);

	/* Convert possibly char variables to numbers */
	RETID = RETIDCHAR*1;
	TAXYR = TAXYRCHAR*1;
	MARS = MARSCHAR*1;
	STATE = STATECHAR*1;
	CAHE = CAHECHAR*1;
	CAFHE = CAFHECHAR*1;
	OTHDEPE = OTHDEPECHAR*1;
	PARE = PARECHAR*1;

	DROP RETIDCHAR TAXYRCHAR MARSCHAR STATECHAR CAHECHAR CAFHECHAR OTHDEPECHAR PARECHAR;

	/* Secondary blindness not available */
	SBI = (PBI = 2);
	PBI = (PBI > 0);

	/* Tax exempt interest not applicable */
	TEXINT = 0;

	/* Calculate net partnership, SBC, and Scorp income */
	PART = E2590 - E2600;
	SBC = 0;
	SCORP = E2605 - E2607;
	DROP E2590 E2600 E2605 E2607;

	/* Add back windfall profits tax (not applicable some years) */
	WPTC = E6042 - E6007;

	SOLENETINCC = SOLENETINCC + WPTC;

	/* add together IRA contributions for current and next year */
	ira = e320 + e325 ;

	/* calculate sales taxes paid */
	salestax = E1860+E1870 ;
	drop E1860 E1870 ;

	DROP E6007 
		 E6042 ;

	/* Variable denoting file's year */
	fileyr = 1985;

	/* Merge in DOB and gender information */
	set INSOLE85DM1 key = RETID /unique ;

RUN;  







/* 1986 INSOLE */

/* Read DM1 data, a dataset with date of birth and gender information, and create variables for merging
	into insole */
DATA INSOLE86DM1 (index=(retid));
    SET SUB2.DM1X86(KEEP=
	RETID
	DM1_MATCH 
	DM1P_DOB DM1S_DOB
	DM1P_GENDER DM1S_GENDER

	RENAME=(
	DM1P_DOB = PDOB
	DM1S_DOB = SDOB

	)
	);

	RETID = RETID;

	PGENDER = .;
	IF DM1P_GENDER = 'F' THEN PGENDER = 2;
	IF DM1P_GENDER = 'M' THEN PGENDER = 1;
	SGENDER = .;
	IF DM1S_GENDER = 'F' THEN SGENDER = 2;
	IF DM1S_GENDER = 'M' THEN SGENDER = 1;

	DOBYR = FLOOR(PDOB/10000);
	SDOBYR = FLOOR(SDOB/10000);

	KEEP DM1_MATCH RETID PGENDER SGENDER DOBYR SDOBYR;
RUN;


/* Read in insole data */
PROC CONTENTS DATA=SUB.INSOLE86;
RUN;

DATA SUBSUB.INSOLE86SUBSET (COMPRESS=YES);
    SET SUB.INSOLE86(KEEP=
	
	RETID MARS FLPDYR REJECT
	STATE 
	XOCAH  XOCAWH XOODEP XOPAR
	
	S002 S003

	E1700	E1850  	E1930  E1690	
	N5

	S006

	/* Form 1040 income variables */
	E10 E20	E30 E40 E90 E100 E120 E200 	E210 

	/* Partnership and scorp variales */
	E2590 E2600 E2605 E2607 E2650

	/* Sole prop variables */
	INDYC DOMC SEXPRC
	E9002 E9102 E9202 E9302
	E9044 E9144 E9244 E9344
	E9007 E9107 E9207 E9307
	E9042 E9142 E9242 E9342
	E9037 E9010


	/* Capital gain variables */
	E2290 E2206 E2208 E2235 E2237


	e1030 e1550 e80 e230 e220 e240
	e140 e150 e70 e50 e60 e110 e250 e2325 e2225
	e130 e940 e10 e480 e810 e2570 e2580 e2650 e320 e325
	e330 

	e150 e260

	E260 E1850 N4 N6 XTOT E350 E1860 E1870 E3270 E1970


	/****** Convert names to Family panel names ***/
	RENAME=(

	RETID	= 	RETIDCHAR
	MARS	=	MARSCHAR
	FLPDYR	=	TAXYRCHAR
	STATE	=	STATECHAR
	XOCAH	=	CAHECHAR
	XOCAWH	=	CAFHECHAR
	XOODEP 	=	OTHDEPECHAR
	XOPAR	=	PARECHAR

	S002	=	issnp
	S003	=	issns

	E1700   =	MEDDED 
	E1850   = 	PROPTAX 
 	E1930   = 	MORTINT 
	E1690	=	TOTDED
	

	E10 	= 	AGIX
	E20		=	WAS 
	E30 	= 	INT
	E40 	= 	DIV
	E90 	= 	BIL
	E100 	= 	CGAGIX 
	E120 	= 	SUPPGL 
	E200 	=  SCHE
	E210 	=  FIL

	E2650	=	ESTTRUST

	E9002 	=  SOLEGRRECEIPTC
	E9102 	=  SOLEGRRECEIPT1
	E9202	=  SOLEGRRECEIPT2
	E9302   =  SOLEGRRECEIPT3	

	E9044 	=  SOLENETINCC
	E9144 	=  SOLENETINC1
	E9244	=  SOLENETINC2
	E9344   =  SOLENETINC3

	E2290	=  SOLEGAIN

	E9037	=	SOLEWAGESC
	E9010	=	SOLEEXPC

	N5 = PBI

	S006	=	WGT

	e1030 = tot_liab
	e1550 = eicx
	e80 = alimony
	e230 = ucagix
	e220 = uncomp
	e240 = ssinc
	e70 = sitr
	e50 = excldivint
	e60 = divagix
	e110 = cgd40
	e250 = ssagix
	e2325 = nltgl
	e2225 = nstgl
	e130 = grpen
	e940 = secatx
	e480 = totincx
	e810 = tot_credit
	e2570 = net_rent_e
	e2580 = net_royal_e
	e330 = keogh
	e260 = othinc
	
	N4 = agenum
	N6 = deps
	XTOT = iexemh
	E350 = alip
	E3270 = childcare
	E1970 = charity
	) 

	);
	
	/* Keep non-rejected returns */
	if REJECT=0;

	/* Generate indicator for being sampled with probability 1 */
	HIINC = (WGT = 1);

	/* Convert possibly char variables to numbers */
	RETID = RETIDCHAR*1;
	TAXYR = TAXYRCHAR*1;
	MARS = MARSCHAR*1;
	STATE = STATECHAR*1;
	CAHE = CAHECHAR*1;
	CAFHE = CAFHECHAR*1;
	OTHDEPE = OTHDEPECHAR*1;
	PARE = PARECHAR*1;

	DROP RETIDCHAR TAXYRCHAR MARSCHAR STATECHAR CAHECHAR CAFHECHAR OTHDEPECHAR PARECHAR;

	/* Secondary blindness not available */
	SBI = (PBI = 2);
	PBI = (PBI > 0);

	/* Tax exempt interest not applicable */
	TEXINT = 0;

	/* Dominant schedule C indicator is missing */
	IF SOLEGRRECEIPT1 NE 0 THEN DOMC = 1;
	IF SOLEGRRECEIPT2 NE 0 AND SOLEGRRECEIPT2 > SOLEGRRECEIPT1 THEN DOMC = 2;
	IF SOLEGRRECEIPT3 NE 0 AND SOLEGRRECEIPT3 > SOLEGRRECEIPT1 AND SOLEGRRECEIPT3 > SOLEGRRECEIPT2 THEN DOMC = 3;

	/* Calculate net partnership, SBC, and Scorp income */
	PART = E2590 - E2600;
	SBC = 0;
	SCORP = E2605 - E2607;
	DROP E2590 E2600 E2605 E2607;	

	/* Add back windfall profits tax (not applicable some years) */
	WPTC = E9042 - E9007;
	WPT1 = E9142 - E9107;
	WPT2 = E9242 - E9207;
	WPT3 = E9342 - E9307;

	SOLENETINCC = SOLENETINCC + WPTC;
	SOLENETINC1 = SOLENETINC1 + WPT1;
	SOLENETINC2 = SOLENETINC2 + WPT2;
	SOLENETINC3 = SOLENETINC3 + WPT3;

	DROP E9007 E9107 E9207 E9307
		 E9042 E9142 E9242 E9342;

	/* Partnership and scorp gain */
	PARTSCORPGAIN = (E2206 - E2208) + (E2235 - E2237);
	DROP E2206 E2208 E2235 E2237;


	/* add together IRA contributions for current and next year */
	ira = e320 + e325 ;

	/* put fully and partly includeable pensions in agi together */
	ptpen = e140 + e150 ;

	/* calculate sales taxes paid */
	salestax = E1860+E1870 ;
	drop E1860 E1870 ;

	/* Merge in DOB and gender information */
	set INSOLE86DM1 key = RETID /unique ;


	/* Variable denoting file's year */
	fileyr = 1986;

RUN;  






PROC MEANS;
RUN;

/* Merge all of the yearly files together */

DATA INSOLE79_86 (COMPRESS=YES);
    SET SUBSUB.INSOLE79SUBSET
		SUBSUB.INSOLE80SUBSET
		SUBSUB.INSOLE81SUBSET
		SUBSUB.INSOLE82SUBSET
		SUBSUB.INSOLE83SUBSET
		SUBSUB.INSOLE84SUBSET
		SUBSUB.INSOLE85SUBSET
		SUBSUB.INSOLE86SUBSET ;

RUN;




/* Output dataset of SSN's with demographic characteristics */

/* PRIMARY FILERS */

DATA INSOLE79_86DEMOGP (COMPRESS=YES);
    SET INSOLE79_86;

	IF PGENDER NE .;
	IF PGENDER NE 0.;
	IF DOBYR NE .;
	IF DOBYR NE 0;

	/* Copy primary information over to secondary */
	sgender = pgender;
	sdobyr = dobyr;
	issns = issnp;

	KEEP ISSNP ISSNS PGENDER DOBYR SGENDER SDOBYR;
RUN;

/* SECONDARY FILERS */
DATA INSOLE79_86DEMOGS (COMPRESS=YES);
    SET INSOLE79_86;

	IF SGENDER NE .;
	IF SGENDER NE 0;
	IF SDOBYR NE .;
	IF SDOBYR NE 0;

	/* Copy secondary information over to primary */
	pgender = sgender;
	dobyr = sdobyr;
	issnp = issns;

	KEEP ISSNP ISSNS PGENDER DOBYR SGENDER SDOBYR;
RUN;

/* MERGE PRIMARY AND SECONDARY TOGETHER */
DATA INSOLE79_86DEMOG ;
	set INSOLE79_86DEMOGP INSOLE79_86DEMOGS;

RUN;

/* Drop duplicate observations */
proc sort data=INSOLE79_86DEMOG ;
	by issnp ;
run ;

data INSOLE79_86DEMOG ;
	set INSOLE79_86DEMOG ;

	issnp_above = lag1(issnp) ;
run  ;

data INSOLE79_86DEMOG ;
	set INSOLE79_86DEMOG;
	if issnp = issnp_above then duplicate = 1 ;
		else duplicate = 0 ;

	if duplicate = 0 ;
	

	/* Rename gender and dob variables as alternates */
	PGENDERALT = PGENDER;
	DOBYRALT = DOBYR;
	SGENDERALT = SGENDER;
	SDOBYRALT = SDOBYR;
	ISSNPALT = ISSNP;
	ISSNSALT = ISSNS;

	DROP DUPLICATE ISSNP_ABOVE PGENDER DOBYR SGENDER SDOBYR;

run ;

/* Create two separate files (one for primary, one for secondary) and sort */
data INSOLE79_86DEMOGPRIMARY ;
	SET INSOLE79_86DEMOG;

	if issnp ne .;
	if issnp ne 0;

	KEEP ISSNP ISSNPALT PGENDERALT DOBYRALT;
RUN;

PROC SORT DATA=INSOLE79_86DEMOGPRIMARY;
	BY ISSNP;
RUN;

data INSOLE79_86DEMOGSECONDARY ;
	SET INSOLE79_86DEMOG;

	if issns ne .;
	if issns ne 0;

	KEEP ISSNS ISSNSALT SGENDERALT SDOBYRALT;
RUN;

PROC SORT DATA=INSOLE79_86DEMOGSECONDARY;
	BY ISSNS;
RUN;


/* Means of demographics without carried over information */
PROC MEANS DATA=INSOLE79_86;
	VAR ISSNP ISSNS PGENDER DOBYR SGENDER SDOBYR;
RUN;

/* Merge gender and dob variables into main dataset when missing */

/* Sort main dataset by issnp */
PROC SORT DATA=INSOLE79_86;
	BY ISSNP;
RUN;

/* Merge in alternate demographic information for primary filers */
DATA INSOLE79_86;
  MERGE INSOLE79_86 (IN = master) INSOLE79_86DEMOGPRIMARY; 
  BY ISSNP; 

  if master = 1;
RUN; 

/* Sort main dataset by issns */
PROC SORT DATA=INSOLE79_86;
	BY ISSNS;
RUN;

/* Merge in alternate demographic information for secondary filers */
DATA INSOLE79_86;
  MERGE INSOLE79_86 (in = master) INSOLE79_86DEMOGSECONDARY; 
  BY ISSNS; 

  if master = 1;
RUN; 


/* Copy over gender and dob if missing */
DATA INSOLE79_86 (COMPRESS=YES);
	set INSOLE79_86;
	
	if PGENDER = . OR PGENDER = 0 THEN PGENDER = PGENDERALT;
	if DOBYR = . OR DOBYR = 0 THEN DOBYR = DOBYRALT;

	if issns ne 0 then do;
		if SGENDER = . OR SGENDER = 0 THEN SGENDER = SGENDERALT;
		if SDOBYR = . OR SDOBYR = 0 THEN SDOBYR = SDOBYRALT;
		if (SGENDER = . OR SGENDER = 0) and PGENDER = 1 THEN SGENDER = 2;
		if (SGENDER = . OR SGENDER = 0) and PGENDER = 2 THEN SGENDER = 1;
	end;

	/* Reset gender and dob vars to missing if no secondary filer */
	if issns = 0 then SDOBYR = . ;
	if issns = 0 then SGENDER = . ;

	DROP ISSNPALT PGENDERALT DOBYRALT ISSNSALT SGENDERALT SDOBYRALT;
RUN;



/* Means of demographics after carried over information */
PROC MEANS DATA=INSOLE79_86;
	VAR ISSNP ISSNS PGENDER DOBYR SGENDER SDOBYR ISSNP ISSNS;
RUN;




DATA INSOLE79_86TEMP;
	SET INSOLE79_86;

		issnsyn = (issns > 0);

		keep issnp issns issnsyn pgender sgender dobyr sdobyr;
RUN;

PROC FREQ DATA=INSOLE79_86TEMP;
	TABLES ISSNSYN;
RUN;
	
PROC MEANS DATA=INSOLE79_86TEMP;
	VAR PGENDER DOBYR SGENDER SDOBYR ISSNS;
RUN;


/* Create needed variables and cut to CWHS subset */

DATA SUBSUB.INSOLE79_86 (COMPRESS=YES);
    SET INSOLE79_86;
		
		/* Create variable for sole prop with highest net income */
		DOMCNETINC = DOMC;
		IF SOLENETINC1 NE 0 THEN DOMCNETINC = 1;
		IF SOLENETINC2 NE 0 AND SOLENETINC2 > SOLENETINC1 THEN DOMCNETINC = 2;
		IF SOLENETINC3 NE 0 AND SOLENETINC3 > SOLENETINC1 AND SOLENETINC3 > SOLENETINC2 THEN DOMCNETINC = 3;
		IF SOLENETINC1 EQ . THEN DOMCNETINC = .;

		/* Create variables for presence of scorp and partnership income and estate and trust income*/
		partscorpyn = (part + sbc + scorp ne 0);
		esttrustyn = esttrust ne 0;

		/* generate some variables to make those in later years */
		ptpexc = max(grpen-ptpen,0) ;
		iraexc = 0 ;
		ssexc = max(ssinc-ssagix,0) ;
		cgdist = cgd40 ;
		dbe = div ;
		intst = int ;
		rentinc = net_rent_e + net_royal_e ;
		ltcg_schD = cgagix ;

		/* Calculate adjusted total income */
		ADJTOTINC = WAS + INT + DIV + sitr + alimony + BIL + CGAGIX + CGDIST + SUPPGL + grpen + ptpen + SCHE + 
				FIL + uncomp + ssinc +  othinc ;

		/* number blindness exemptions */
		blnde = pbi + sbi ;

		/* rename mort intererst paid */
		intpaid = mortint ;
		hmie = mortint ;

		/* alternate name for real-estate property tax */
		retx = proptax ;

	   if taxyr < 100 then taxyr = taxyr + 1900 ;	
	   year = taxyr ;
RUN;



