capture log close
prog drop _all
set more off
set trace off
pause on
#delimit ;
clear;

global date 120923;
global model "3H2B_selection2AW_separateEPOP";
global dir "D:\RA\Moffitt\Nicole_LS\091712";
capture log using $dir\Lu\women_${model}_${date}.log, replace;
use $dir\Data\dataforlaborsupply_noexclus.dta;

recode edu (5=4);

gen Nid=fdivval+fintval;
gen Nid2007dols=Nid/0.830679413 if year==1999;
replace Nid2007dols=Nid/0.851366007 if year==2000;
replace Nid2007dols=Nid/0.654281083 if year==1989;
replace Nid2007dols=Nid/0.684177101 if year==1990;
replace Nid2007dols=Nid if year==2007;
replace Nid2007dols=Nid/1.032644859 if year==2008;

gen Nidfam=Nid+earnfam;
gen Nidfam2007dols=Nidfam/0.830679413 if year==1999;
replace Nidfam2007dols=Nidfam/0.851366007 if year==2000;
replace Nidfam2007dols=Nidfam/0.654281083 if year==1989;
replace Nidfam2007dols=Nidfam/0.684177101 if year==1990;
replace Nidfam2007dols=Nidfam if year==2007;
replace Nidfam2007dols=Nidfam/1.032644859 if year==2008;

replace Nid2007dols=0 if Nid2007dols<0;
replace Nidfam2007dols=0 if Nidfam2007dols<0;

/*
replace Nid2007dols=Nid2007dols/52+10;
replace Nidfam2007dols=Nidfam2007dols/52+10;
*/

replace Nid2007dols=Nid2007dols/1000;
replace Nidfam2007dols=Nidfam2007dols/1000;

gen Nid0=1 if Nid2007dols==0;
replace Nid0=0 if Nid2007dols!=0;

gen Nidfam0=1 if Nidfam2007dols==0;
replace Nidfam0=0 if Nidfam2007dols!=0;
/*
gen lnNid=log(Nid2007dols) if Nid2007dols!=0;
replace lnNid=0 if Nid2007dols==0;

gen lnNidfam=log(Nidfam2007dols) if Nidfam2007dols!=0;
replace lnNidfam=0 if Nidfam2007dols==0;
*/
gen kids=1 if kidsunder6!=0 |kids6to18!=0;
gen singleparent=1 if kids==1 & married==0;
replace singleparent=0 if singleparent==.;

gen wagesample=1 if ern_srce==1 & ljcw!=6 & ljcw!=5 & h_type!=9 & frmotr!=1 & seotr!=1 & i_ernval!=1 & i_wsval!=1 /*& hrswk>=35 & hrswk<. & wkswork>=40 & wkswork<=.*/;
replace wagesample=0 if ern_srce!=1 | ljcw==6 | ljcw==5 | h_type==9 | frmotr==1 | seotr==1 | i_ernval==1 | i_wsval==1 /*| hrswk<35 | wkswork<40*/;

/*===============================================================*/
/**************First, run it exactly like Lu did*****************/
/*==============================================================*/
keep if sex==2; /*Keep only Women*/
drop if age==5; /*Eliminate 65+*/
drop if a_lfsr==0; /*Eliminate members of armed force*/
drop if a_fnlwgt==0;

gen lnwagewk=log(wagewk2007dols) if wagesample==1; /*Apply the exclusions*/
gen lnwagehr=log(wagehr2007dols) if wagesample==1;

/*Create crossed age-education dummies*/
qui gen age16to24lessHS=age16to24*lessHS;
qui gen age16to24HS=age16to24*HS;
qui gen age16to24SC=age16to24*SC;
qui gen age16to24Col=age16to24*Col;
qui gen age25to39lessHS=age25to39*lessHS;
qui gen age25to39HS=age25to39*HS;
qui gen age25to39SC=age25to39*SC;
qui gen age25to39Col=age25to39*Col;
qui gen age40to54lessHS=age40to54*lessHS;
qui gen age40to54HS=age40to54*HS;
qui gen age40to54SC=age40to54*SC;
qui gen age40to54Col=age40to54*Col;
qui gen age55to64lessHS=age55to64*lessHS;
qui gen age55to64HS=age55to64*HS;
qui gen age55to64SC=age55to64*SC;
qui gen age55to64Col=age55to64*Col;

foreach xx of varlist age16to24lessHS-age55to64Col{;
              qui gen `xx'white=`xx'*white;
              qui gen `xx'black=`xx'*black;
		  qui gen `xx'other=`xx'*other;
              };

/*Trim the wages to exclude outliers - 5% on each side*/
egen lnwagewk_95pct=pctile(lnwagewk) if year==1990, p(95);
egen lnwagewk_5pct=pctile(lnwagewk) if year==1990, p(5);
gen lnwagewk_trim=lnwagewk
	if year==1990 & lnwagewk <=lnwagewk_95pct 
	& lnwagewk>=lnwagewk_5pct;
replace wagesample=0 if year==1990 & lnwagewk>lnwagewk_95pct | year==1990 & lnwagewk<lnwagewk_5pct;
drop lnwagewk_95pct lnwagewk_5pct;

/*Trim the wages to exclude outliers - 5% on each side*/
egen lnwagewk_95pct=pctile(lnwagewk) if year==2000, p(95);
egen lnwagewk_5pct=pctile(lnwagewk) if year==2000, p(5);
replace lnwagewk_trim=lnwagewk
	if year==2000 & lnwagewk <=lnwagewk_95pct 
	& lnwagewk>=lnwagewk_5pct;
replace wagesample=0 if year==2000 & lnwagewk>lnwagewk_95pct | year==2000 & lnwagewk<lnwagewk_5pct;
drop lnwagewk_95pct lnwagewk_5pct;

/*Trim outliers - 5% each side*/
egen lnwagewk_95pct=pctile(lnwagewk) if year==2008, p(95);
egen lnwagewk_5pct=pctile(lnwagewk) if year==2008, p(5);
replace lnwagewk_trim=lnwagewk
	if year==2008 & lnwagewk <=lnwagewk_95pct 
	& lnwagewk>=lnwagewk_5pct;
replace wagesample=0 if year==2008 & lnwagewk>lnwagewk_95pct | year==2008 & lnwagewk<lnwagewk_5pct;
drop lnwagewk_95pct lnwagewk_5pct;

egen lnwagehr_95pct=pctile(lnwagehr) if year==1990, p(95);
egen lnwagehr_5pct=pctile(lnwagehr) if year==1990, p(5);
gen lnwagehr_trim=lnwagehr
	if year==1990 & lnwagehr <=lnwagehr_95pct 
	& lnwagehr>=lnwagehr_5pct;
drop lnwagehr_95pct lnwagehr_5pct;

/*Trim outliers - 5% each side*/
egen lnwagehr_95pct=pctile(lnwagehr) if year==2000, p(95);
egen lnwagehr_5pct=pctile(lnwagehr) if year==2000, p(5);
replace lnwagehr_trim=lnwagehr
	if year==2000 & lnwagehr <=lnwagehr_95pct 
	& lnwagehr>=lnwagehr_5pct;
drop lnwagehr_95pct lnwagehr_5pct;

/*Trim outliers - 5% each side*/
egen lnwagehr_95pct=pctile(lnwagehr) if year==2008, p(95);
egen lnwagehr_5pct=pctile(lnwagehr) if year==2008, p(5);
replace lnwagehr_trim=lnwagehr
	if year==2008 & lnwagehr <=lnwagehr_95pct 
	& lnwagehr>=lnwagehr_5pct;
drop lnwagehr_95pct lnwagehr_5pct;


/*First stage EPOP - Nid*/
reg wagesample Nid2007dols kidsunder6 kids6to18 married divwidsep headhh singleparent /*lnNid_sqr*/ age16to24lessHSwhite-age55to64Colblack [pweight=marsupwt]
	if year==1990;
eststo firstNid90;
predict WSNid89_select;
replace WSNid89_select=1 if year==1989;
reg wagesample Nid2007dols kidsunder6 kids6to18 married divwidsep headhh singleparent /*lnNid_sqr*/ age16to24lessHSwhite-age55to64Colblack[pweight=marsupwt]
	if year==2000;
eststo firstNid00;
predict WSNid99_select;
replace WSNid99_select=1 if year==1999;
reg wagesample Nid2007dols kidsunder6 kids6to18 married divwidsep headhh singleparent /*lnNid_sqr*/ age16to24lessHSwhite-age55to64Colblack[pweight=marsupwt]
	if year==2008;
eststo firstNid08;
predict WSNid07_select;
replace WSNid07_select=1 if year==2007;

/*First stage EPOP - Nidfam*/
reg wagesample Nidfam2007dols kidsunder6 kids6to18 married divwidsep headhh singleparent /*lnNid_sqr*/ age16to24lessHSwhite-age55to64Colblack[pweight=marsupwt]
	if year==1990;
eststo firstNidfam90;
predict WSNidfam89_select;
replace WSNidfam89_select=1 if year==1989;
reg wagesample Nidfam2007dols kidsunder6 kids6to18 married divwidsep headhh singleparent /*lnNid_sqr*/ age16to24lessHSwhite-age55to64Colblack[pweight=marsupwt]
	if year==2000;
eststo firstNidfam00;
predict WSNidfam99_select;
replace WSNidfam99_select=1 if year==1999;
reg wagesample Nidfam2007dols kidsunder6 kids6to18 married divwidsep headhh singleparent /*lnNid_sqr*/ age16to24lessHSwhite-age55to64Colblack[pweight=marsupwt]
	if year==2008;
eststo firstNidfam08;
predict WSNidfam07_select;
replace WSNidfam07_select=1 if year==2007;

/*weekly wage regression for 1989 - Nid*/
reg lnwagewk_trim WSNid89_select age16to24lessHSwhite-age55to64Colblack married divwidsep headhh singleparent [pweight=marsupwt]
	       if year==1990;
eststo wagewkM89_Nid; /*Store the estimates*/
predict lnwagewkPredict89_Nid if year==1989; /*Find the fitted values for use in the EPOP regression*/
gen lnwagewkPredict_Nid=lnwagewkPredict89_Nid if year==1989;

/*weekly wage regression for 1989 - Nidfam*/
reg lnwagewk_trim WSNidfam89_select age16to24lessHSwhite-age55to64Colblack  married divwidsep headhh singleparent [pweight=marsupwt]
	       if year==1990;
eststo wagewkM89_Nidfam; /*Store the estimates*/
predict lnwagewkPredict89_Nidfam if year==1989; /*Find the fitted values for use in the EPOP regression*/
gen lnwagewkPredict_Nidfam=lnwagewkPredict89_Nidfam if year==1989;

/*weekly wage regression for 1999 - Nid*/
reg lnwagewk_trim WSNid99_select age16to24lessHSwhite-age55to64Colblack  married divwidsep headhh singleparent [pweight=marsupwt]
	       if year==2000;
eststo wagewkM99_Nid; /*Store the estimates*/
predict lnwagewkPredict99_Nid if year==1999; /*Find the fitted values for use in the EPOP regression*/
replace lnwagewkPredict_Nid=lnwagewkPredict99_Nid if year==1999;

/*weekly wage regression for 1999 - Nidfam*/
reg lnwagewk_trim WSNidfam99_select age16to24lessHSwhite-age55to64Colblack married divwidsep headhh singleparent [pweight=marsupwt]
	       if year==2000;
eststo wagewkM99_Nidfam; /*Store the estimates*/
predict lnwagewkPredict99_Nidfam if year==1999; /*Find the fitted values for use in the EPOP regression*/
replace lnwagewkPredict_Nidfam=lnwagewkPredict99_Nidfam if year==1999;

/*weekly wage regression for 2007 - Nid*/
reg lnwagewk_trim WSNid07_select age16to24lessHSwhite-age55to64Colblack married divwidsep headhh singleparent [pweight=marsupwt]
	     if year==2008;
eststo wagewkM07_Nid;
predict lnwagewkPredict07_Nid if year==2007;
replace lnwagewkPredict_Nid=lnwagewkPredict07_Nid if year==2007;

/*weekly wage regression for 2007 - Nidfam*/
reg lnwagewk_trim WSNidfam07_select age16to24lessHSwhite-age55to64Colblack married divwidsep headhh singleparent [pweight=marsupwt]
	     if year==2008;
eststo wagewkM07_Nidfam;
predict lnwagewkPredict07_Nidfam if year==2007;
replace lnwagewkPredict_Nidfam=lnwagewkPredict07_Nidfam if year==2007;

/*hourly wage regression for 1989 - Nid*/
reg lnwagehr_trim WSNid89_select age16to24lessHSwhite-age55to64Colblack  married divwidsep headhh singleparent  [pweight=marsupwt]
	       if year==1990;
eststo wagehrM89_Nid; /*Store the estimates*/
predict lnwagehrPredict89_Nid if year==1989; /*Find the fitted values for use in the EPOP regression*/
gen lnwagehrPredict_Nid=lnwagehrPredict89_Nid if year==1989;

/*hourly wage regression for 1989 - Nidfam*/
reg lnwagehr_trim WSNidfam89_select age16to24lessHSwhite-age55to64Colblack married divwidsep headhh singleparent [pweight=marsupwt]
	       if year==1990;
eststo wagehrM89_Nidfam; /*Store the estimates*/
predict lnwagehrPredict89_Nidfam if year==1989; /*Find the fitted values for use in the EPOP regression*/
gen lnwagehrPredict_Nidfam=lnwagehrPredict89_Nidfam if year==1989;

/*hourly wage regression for 1999 - Nid*/
reg lnwagehr_trim WSNid99_select age16to24lessHSwhite-age55to64Colblack married divwidsep headhh singleparent [pweight=marsupwt]
	       if year==2000;
eststo wagehrM99_Nid; /*Store the estimates*/
predict lnwagehrPredict99_Nid if year==1999; /*Find the fitted values for use in the EPOP regression*/
replace lnwagehrPredict_Nid=lnwagehrPredict99_Nid if year==1999;

/*hourly wage regression for 1999 - Nid*/
reg lnwagehr_trim WSNidfam99_select age16to24lessHSwhite-age55to64Colblack  married divwidsep headhh singleparent [pweight=marsupwt]
	       if year==2000;
eststo wagehrM99_Nidfam; /*Store the estimates*/
predict lnwagehrPredict99_Nidfam if year==1999; /*Find the fitted values for use in the EPOP regression*/
replace lnwagehrPredict_Nidfam=lnwagehrPredict99_Nidfam if year==1999;

/*hourly wage regression for 2007 - Nid*/
reg lnwagehr_trim WSNid07_select age16to24lessHSwhite-age55to64Colblack married divwidsep headhh singleparent [pweight=marsupwt]
	     if year==2008;
eststo wagehrM07_Nid;
predict lnwagehrPredict07_Nid if year==2007;
replace lnwagehrPredict_Nid=lnwagehrPredict07_Nid if year==2007;

/*hourly wage regression for 2007 - Nidfam*/
reg lnwagehr_trim WSNidfam07_select age16to24lessHSwhite-age55to64Colblack married divwidsep headhh singleparent [pweight=marsupwt]
	     if year==2008;
eststo wagehrM07_Nidfam;
predict lnwagehrPredict07_Nidfam if year==2007;
replace lnwagehrPredict_Nidfam=lnwagehrPredict07_Nidfam if year==2007;

/******1989-1999******/
/*EPOP regression using weekly wages - Nid*/
reg employed lnwagewkPredict_Nid Nid2007dols kidsunder6 kids6to18 married divwidsep headhh singleparent /*lnNid_sqr*/ age16to24lessHSwhite-age55to64Colblack [pweight=a_fnlwgt]
	if year==1989 | year==1999 ;
eststo Mwk_Nid_89to99;
predict empPredictMwk_Nid_89to99 if year==1989 | year==1999 ;

/*EPOP regression using weekly wages - Nidfam*/
reg employed lnwagewkPredict_Nidfam Nidfam2007dols kidsunder6 kids6to18 married divwidsep headhh singleparent /*lnNidfam_sqr*/ age16to24lessHSwhite-age55to64Colblack [pweight=a_fnlwgt]
	if year==1989 | year==1999 ;
eststo Mwk_Nidfam_89to99;
predict empPredictMwk_Nidfam_89to99 if year==1989 | year==1999 ;

/*EPOP regression using hourly wages - Nid*/
reg employed lnwagehrPredict_Nid Nid2007dols kidsunder6 kids6to18 married divwidsep headhh singleparent /*lnNid_sqr*/ age16to24lessHSwhite-age55to64Colblack [pweight=a_fnlwgt]
	if year==1989 | year==1999 ;
eststo Mhr_Nid_89to99;
predict empPredictMhr_Nid_89to99 if year==1989 | year==1999 ;

/*EPOP regression using hourly wages - Nidfam*/
reg employed lnwagehrPredict_Nidfam Nidfam2007dols kidsunder6 kids6to18 married divwidsep headhh singleparent /*lnNidfam_sqr*/ age16to24lessHSwhite-age55to64Colblack [pweight=a_fnlwgt]
	if year==1989 | year==1999 ;
eststo Mhr_Nidfam_89to99;
predict empPredictMhr_Nidfam_89to99 if year==1989 | year==1999 ;

/***********1999-2007*************/
/*EPOP regression using weekly wages - Nid*/
reg employed lnwagewkPredict_Nid Nid2007dols kidsunder6 kids6to18 married divwidsep headhh singleparent /*lnNid_sqr*/ age16to24lessHSwhite-age55to64Colblack [pweight=a_fnlwgt]
	if year==1999 | year==2007;
eststo Mwk_Nid_99to07;
predict empPredictMwk_Nid_99to07 if year==1999 | year==2007;

/*EPOP regression using weekly wages - Nidfam*/
reg employed lnwagewkPredict_Nidfam Nidfam2007dols kidsunder6 kids6to18 married divwidsep headhh singleparent /*lnNidfam_sqr*/ age16to24lessHSwhite-age55to64Colblack [pweight=a_fnlwgt]
	if year==1999 | year==2007;
eststo Mwk_Nidfam_99to07;
predict empPredictMwk_Nidfam_99to07 if year==1999 | year==2007;

/*EPOP regression using hourly wages - Nid*/
reg employed lnwagehrPredict_Nid Nid2007dols kidsunder6 kids6to18 married divwidsep headhh singleparent /*lnNid_sqr*/ age16to24lessHSwhite-age55to64Colblack [pweight=a_fnlwgt]
	if year==1999 | year==2007;
eststo Mhr_Nid_99to07;
predict empPredictMhr_Nid_99to07 if year==1999 | year==2007;

/*EPOP regression using hourly wages - Nidfam*/
reg employed lnwagehrPredict_Nidfam Nidfam2007dols kidsunder6 kids6to18 married divwidsep headhh singleparent /*lnNidfam_sqr*/ age16to24lessHSwhite-age55to64Colblack [pweight=a_fnlwgt]
	if year==1999 | year==2007;
eststo Mhr_Nidfam_99to07;
predict empPredictMhr_Nidfam_99to07 if year==1999 | year==2007;



/*Export the first-stage regression results*/
esttab firstNid90 firstNid00 firstNid08
using "$dir\Lu\WomenfirstNid3H2March.tex",  b(%9.4f) se nostar wide replace
title("First stage regression results for Women using Nid and marsupwt")
mtitles("1989" "1999" "2007");

esttab firstNidfam90 firstNidfam00 firstNidfam08
using "$dir\Lu\WomenfirstNidfam3H2March.tex",  b(%9.4f) se nostar wide replace
title("First stage regression results for Women using Nidfam and marsupwt")
mtitles("1989" "1999" "2007");

/*Export the regression results*/
esttab wagewkM89_Nid wagewkM99_Nid wagewkM07_Nid
using "$dir\Lu\WomenWeeklyWagesNid89to07_selection.tex", b(%9.4f) se nostar wide replace
title("Weekly wage Regression Results for Women, with Nid in first-stage regression")
mtitles("Weekly wage, 1989" "Weekly wage, 1999" "Weekly wage, 2007");

esttab wagewkM89_Nidfam wagewkM99_Nidfam wagewkM07_Nidfam
using "$dir\Lu\WomenWeeklyWagesNidfam89to07_selection.tex", b(%9.4f) se nostar wide replace
title("Weekly wage Regression Results for Women, with Nidfam in first-stage regression")
mtitles("Weekly wage, 1989" "Weekly wage, 1999" "Weekly wage, 2007");


esttab wagehrM89_Nid wagehrM99_Nid wagehrM07_Nid 
using "$dir\Lu\WomenHourlyWagesNid89to07_selection.tex", b(%9.4f) se nostar wide replace
title("Hourly wage Regression Results for Women, with Nid in the first-stage regression")
mtitles("Hourly wage, 1989" "Hourly wage, 1999" "Hourly wage, 2007");

esttab wagehrM89_Nidfam wagehrM99_Nidfam wagehrM07_Nidfam 
using "$dir\Lu\WomenHourlyWagesNidfam89to07_selection.tex", b(%9.4f) se nostar wide replace
title("Hourly wage Regression Results for Women, with Nidfam in the first-stage regression")
mtitles("Hourly wage, 1989" "Hourly wage, 1999" "Hourly wage, 2007");

esttab Mwk_Nid_89to99 Mwk_Nidfam_89to99 Mhr_Nid_89to99 Mhr_Nidfam_89to99
using "$dir\Lu\WomenEPOP89to99.tex", b(%9.4f) se nostar wide replace
title("EPOP Regression Results for Women, with exclusions and weights")
mtitles("Weekly wage, Nid" "Weekly wage, Nidfam" "Hourly wage - Nid" "Hourly wage - Nidfam");

esttab Mwk_Nid_99to07 Mwk_Nidfam_99to07 Mhr_Nid_99to07 Mhr_Nidfam_99to07
using "$dir\Lu\WomenEPOP99to07.tex", b(%9.4f) se nostar wide replace
title("EPOP Regression Results for Women, with exclusions and weights, year 1999 to 2007")
mtitles("Weekly wage, Nid" "Weekly wage, Nidfam" "Hourly wage - Nid" "Hourly wage - Nidfam");

foreach var of varlist employed empPredictMwk_Nid_89to99-empPredictMhr_Nidfam_99to07
						Nid2007dols Nidfam2007dols
						lnwagewkPredict_Nid-lnwagehrPredict_Nidfam{;
qui gen `var'1989=`var' if year==1989;
qui gen `var'1999=`var' if year==1999;
qui gen `var'2007=`var' if year==2007;
};


preserve;
keep if year==1989 | year==1999 | year==2007;
collapse (mean) employed2007 employed1999 employed1989 empPredictMwk_Nid_89to991989-empPredictMhr_Nidfam_99to072007 [pweight=a_fnlwgt];

qui gen difemp99to89=employed1999-employed1989;
qui gen difMwk_Nid99to89=empPredictMwk_Nid_89to991999-empPredictMwk_Nid_89to991989;
qui gen difMwk_Nidfam99to89=empPredictMwk_Nidfam_89to991999-empPredictMwk_Nidfam_89to991989;
qui gen difMhr_Nid99to89=empPredictMhr_Nid_89to991999-empPredictMhr_Nid_89to991989;
qui gen difMhr_Nidfam99to89=empPredictMhr_Nidfam_89to991999-empPredictMhr_Nidfam_89to991989;

qui gen difemp07to99=employed2007-employed1999;
qui gen difMwk_Nid07to99=empPredictMwk_Nid_99to072007-empPredictMwk_Nid_99to071999;
qui gen difMwk_Nidfam07to99=empPredictMwk_Nidfam_99to072007-empPredictMwk_Nidfam_99to071999;
qui gen difMhr_Nid07to99=empPredictMhr_Nid_99to072007-empPredictMhr_Nid_99to071999;
qui gen difMhr_Nidfam07to99=empPredictMhr_Nidfam_99to072007-empPredictMhr_Nidfam_99to071999;

keep difemp99to89-difMhr_Nidfam07to99;
outsheet using "$dir\Lu\WomenEPOP89to07.xls", replace;

restore; preserve;
keep if year==1989 | year==1999 | year==2007;
collapse (mean) empPredictMwk_Nid_89to991989-empPredictMhr_Nidfam_99to072007 [pweight=a_fnlwgt], by(sex edu age);

qui gen difMwk_Nid99to89=empPredictMwk_Nid_89to991999-empPredictMwk_Nid_89to991989;
qui gen difMwk_Nidfam99to89=empPredictMwk_Nidfam_89to991999-empPredictMwk_Nidfam_89to991989;
qui gen difMhr_Nid99to89=empPredictMhr_Nid_89to991999-empPredictMhr_Nid_89to991989;
qui gen difMhr_Nidfam99to89=empPredictMhr_Nidfam_89to991999-empPredictMhr_Nidfam_89to991989;

qui gen difMwk_Nid07to99=empPredictMwk_Nid_99to072007-empPredictMwk_Nid_99to071999;
qui gen difMwk_Nidfam07to99=empPredictMwk_Nidfam_99to072007-empPredictMwk_Nidfam_99to071999;
qui gen difMhr_Nid07to99=empPredictMhr_Nid_99to072007-empPredictMhr_Nid_99to071999;
qui gen difMhr_Nidfam07to99=empPredictMhr_Nidfam_99to072007-empPredictMhr_Nidfam_99to071999;

sort sex edu age;
keep sex edu age difMwk_Nid99to89-difMhr_Nidfam07to99;
outsheet using "$dir\Lu\Table1EPOPWomen89to07.xls", replace;

restore; preserve;
keep if year==1989 | year==1999 | year==2007;
collapse (mean) empPredictMwk_Nid_89to991989-empPredictMhr_Nidfam_99to072007 [pweight=a_fnlwgt],  by(age edu sex race);

qui gen difMwk_Nid99to89=empPredictMwk_Nid_89to991999-empPredictMwk_Nid_89to991989;
qui gen difMwk_Nidfam99to89=empPredictMwk_Nidfam_89to991999-empPredictMwk_Nidfam_89to991989;
qui gen difMhr_Nid99to89=empPredictMhr_Nid_89to991999-empPredictMhr_Nid_89to991989;
qui gen difMhr_Nidfam99to89=empPredictMhr_Nidfam_89to991999-empPredictMhr_Nidfam_89to991989;

qui gen difMwk_Nid07to99=empPredictMwk_Nid_99to072007-empPredictMwk_Nid_99to071999;
qui gen difMwk_Nidfam07to99=empPredictMwk_Nidfam_99to072007-empPredictMwk_Nidfam_99to071999;
qui gen difMhr_Nid07to99=empPredictMhr_Nid_99to072007-empPredictMhr_Nid_99to071999;
qui gen difMhr_Nidfam07to99=empPredictMhr_Nidfam_99to072007-empPredictMhr_Nidfam_99to071999;

sort race sex edu age;
keep race sex edu age difMwk_Nid99to89-difMhr_Nidfam07to99;

outsheet using "$dir\Lu\Table2EPOPWomen89to07.xls", replace;
restore; preserve;

/*Change in N and Wage*/
qui gen lnwagewk_trim1989=lnwagewk_trim if year==1990;
qui gen lnwagewk_trim1999=lnwagewk_trim if year==2000;
qui gen lnwagewk_trim2007=lnwagewk_trim if year==2008;
qui gen lnwagehr_trim1989=lnwagehr_trim if year==1990;
qui gen lnwagehr_trim1999=lnwagehr_trim if year==2000;
qui gen lnwagehr_trim2007=lnwagehr_trim if year==2008;
collapse (mean) Nid2007dols1989-Nidfam2007dols2007 lnwagewk_trim1989-lnwagehr_trim2007 
				lnwagewkPredict_Nid1989-lnwagehrPredict_Nidfam2007 [pweight=a_fnlwgt];
qui gen difNid_99to89=Nid2007dols1999-Nid2007dols1989;
qui gen difNid_07to99=Nid2007dols2007-Nid2007dols1999;
qui gen difNidfam_99to89=Nidfam2007dols1999-Nidfam2007dols1989;
qui gen difNidfam_07to99=Nidfam2007dols2007-Nidfam2007dols1999;

qui gen diflnwagewk_trim99to89=lnwagewk_trim1999-lnwagewk_trim1989;
qui gen diflnwagewk_trim07to99=lnwagewk_trim2007-lnwagewk_trim1999;
qui gen diflnwagehr_trim99to89=lnwagehr_trim1999-lnwagehr_trim1989;
qui gen diflnwagehr_trim07to99=lnwagehr_trim2007-lnwagehr_trim1999;

qui gen diflnwagewkPredict99to89_Nid=lnwagewkPredict_Nid1999-lnwagewkPredict_Nid1989;
qui gen diflnwagewkPredict07to99_Nid=lnwagewkPredict_Nid2007-lnwagewkPredict_Nid1999;
qui gen diflnwagewkPredict99to89_Nidfam=lnwagewkPredict_Nidfam1999-lnwagewkPredict_Nidfam1989;
qui gen diflnwagewkPredict07to99_Nidfam=lnwagewkPredict_Nidfam2007-lnwagewkPredict_Nidfam1999;
qui gen diflnwagehrPredict99to89_Nid=lnwagehrPredict_Nid1999-lnwagehrPredict_Nid1989;
qui gen diflnwagehrPredict07to99_Nid=lnwagehrPredict_Nid2007-lnwagehrPredict_Nid1999;
qui gen diflnwagehrPredict99to89_Nidfam=lnwagehrPredict_Nidfam1999-lnwagehrPredict_Nidfam1989;
qui gen diflnwagehrPredict07to99_Nidfam=lnwagehrPredict_Nidfam2007-lnwagehrPredict_Nidfam1999;

keep difNid_99to89-difNidfam_07to99 diflnwagewk_trim99to89-diflnwagehr_trim07to99 diflnwagewkPredict99to89_Nid-diflnwagehrPredict07to99_Nidfam;
outsheet using"$dir\Lu\TableNWageChangeWomen.xls", replace;

log close;

/*
/*Decomposition*/
restore; preserve;
keep if year==1989 | year==1999 | year==2007;
collapse (mean) lnwagewkPredict lnNid Nid0 lnNidfam Nidfam0 kidsunder6 kids6to18 married divwidsep headhh singleparent age16to24lessHSwhite-age55to64Colblack, by(year);
outsheet using "C:\Users\Nicole\Desktop\Labor Supply RA\CPS extracts\MarchCPS\Regressions\Results\NoWgtMeansWomen3H2_89to07.xls", replace;

restore; preserve;
keep if year==1989 | year==1999 | year==2007;
collapse (mean) lnwagewkPredict lnNid Nid0 lnNidfam Nidfam0 kidsunder6 kids6to18 married divwidsep headhh singleparent age16to24lessHSwhite-age55to64Colblack [pweight=a_fnlwgt], by(year);
outsheet using "C:\Users\Nicole\Desktop\Labor Supply RA\CPS extracts\MarchCPS\Regressions\Results\WgtMeansWomen3H2_89to07.xls", replace;

restore; preserve;
keep if _n==1;
keep wkNid1-wkNid57 wkNidfam1-wkNidfam57;
outsheet using "C:\Users\Nicole\Desktop\Labor Supply RA\CPS extracts\MarchCPS\Regressions\Results\betasWomen3H2_89to07.xls", replace;
