capture log close
prog drop _all
set more off
set trace off
pause on
#delimit ;
clear;

global date 120923;
global model "3H2B_BKselection_fixweight";
global dir "D:\RA\Moffitt\Nicole_LS\091712";
capture log using $dir\Lu\women_${model}_${date}.log, replace;
use $dir\Data\dataforlaborsupply_noexclus.dta;

recode edu (5=4);

gen Nid=fdivval+fintval;
gen Nid2007dols=Nid/0.830679413 if year==1999;
replace Nid2007dols=Nid/0.851366007 if year==2000;
replace Nid2007dols=Nid/0.654281083 if year==1989;
replace Nid2007dols=Nid/0.684177101 if year==1990;
replace Nid2007dols=Nid if year==2007;
replace Nid2007dols=Nid/1.032644859 if year==2008;

gen Nidfam=Nid+earnfam;
gen Nidfam2007dols=Nidfam/0.830679413 if year==1999;
replace Nidfam2007dols=Nidfam/0.851366007 if year==2000;
replace Nidfam2007dols=Nidfam/0.654281083 if year==1989;
replace Nidfam2007dols=Nidfam/0.684177101 if year==1990;
replace Nidfam2007dols=Nidfam if year==2007;
replace Nidfam2007dols=Nidfam/1.032644859 if year==2008;

replace Nid2007dols=0 if Nid2007dols<0;
replace Nidfam2007dols=0 if Nidfam2007dols<0;

/*
replace Nid2007dols=Nid2007dols/52+10;
replace Nidfam2007dols=Nidfam2007dols/52+10;
*/

replace Nid2007dols=Nid2007dols/1000;
replace Nidfam2007dols=Nidfam2007dols/1000;
/*
gen Nid0=1 if Nid2007dols==0;
replace Nid0=0 if Nid2007dols!=0;

gen Nidfam0=1 if Nidfam2007dols==0;
replace Nidfam0=0 if Nidfam2007dols!=0;

gen lnNid=log(Nid2007dols) if Nid2007dols!=0;
replace lnNid=0 if Nid2007dols==0;

gen lnNidfam=log(Nidfam2007dols) if Nidfam2007dols!=0;
replace lnNidfam=0 if Nidfam2007dols==0;
*/
gen kids=1 if kidsunder6!=0 |kids6to18!=0;
gen singleparent=1 if kids==1 & married==0;
replace singleparent=0 if singleparent==.;

gen wagesample=1 if ern_srce==1 & ljcw!=6 & ljcw!=5 & h_type!=9 & frmotr!=1 & seotr!=1 & i_ernval!=1 & i_wsval!=1 /*& hrswk>=35 & hrswk<. & wkswork>=40 & wkswork<=.*/;
replace wagesample=0 if ern_srce!=1 | ljcw==6 | ljcw==5 | h_type==9 | frmotr==1 | seotr==1 | i_ernval==1 | i_wsval==1 /*| hrswk<35 | wkswork<40*/;

keep if sex==2; /*Keep only women*/
drop if age==5; /*Eliminate 65+*/
drop if a_lfsr==0; /*Eliminate members of armed force*/
drop if a_fnlwgt==0;

gen lnwagewk=log(wagewk2007dols) if wagesample==1; /*Apply the exclusions*/
gen lnwagehr=log(wagehr2007dols) if wagesample==1;

qui gen age16to24lessHS=age16to24*lessHS;
qui gen age16to24HS=age16to24*HS;
qui gen age16to24SC=age16to24*SC;
qui gen age16to24Col=age16to24*Col;
qui gen age25to39lessHS=age25to39*lessHS;
qui gen age25to39HS=age25to39*HS;
qui gen age25to39SC=age25to39*SC;
qui gen age25to39Col=age25to39*Col;
qui gen age40to54lessHS=age40to54*lessHS;
qui gen age40to54HS=age40to54*HS;
qui gen age40to54SC=age40to54*SC;
qui gen age40to54Col=age40to54*Col;
qui gen age55to64lessHS=age55to64*lessHS;
qui gen age55to64HS=age55to64*HS;
qui gen age55to64SC=age55to64*SC;
qui gen age55to64Col=age55to64*Col;

foreach xx of varlist age16to24lessHS-age55to64Col{;
              qui gen `xx'white=`xx'*white;
              qui gen `xx'black=`xx'*black;
		  qui gen `xx'other=`xx'*other;
              };

			  
gen wkgroup=cond(wkswork>=40,4,cond(wkswork>=20,3,cond(wkswork>=1,2,1,1)));
total wkgroup [pw=marsupwt], over (year wkgroup);
mat total=r(table);
gen wkgroup_total=total[1,1] if year==1989 & wkgroup==1;
replace wkgroup_total=total[1,2] if year==1989 & wkgroup==2;
replace wkgroup_total=total[1,3] if year==1989 & wkgroup==3;
replace wkgroup_total=total[1,4] if year==1989 & wkgroup==4;
replace wkgroup_total=total[1,5] if year==1990 & wkgroup==1;
replace wkgroup_total=total[1,6] if year==1990 & wkgroup==2;
replace wkgroup_total=total[1,7] if year==1990 & wkgroup==3;
replace wkgroup_total=total[1,8] if year==1990 & wkgroup==4;
replace wkgroup_total=total[1,9] if year==1999 & wkgroup==1;
replace wkgroup_total=total[1,10] if year==1999 & wkgroup==2;
replace wkgroup_total=total[1,11] if year==1999 & wkgroup==3;
replace wkgroup_total=total[1,12] if year==1999 & wkgroup==4;
replace wkgroup_total=total[1,13] if year==2000 & wkgroup==1;
replace wkgroup_total=total[1,14] if year==2000 & wkgroup==2;
replace wkgroup_total=total[1,15] if year==2000 & wkgroup==3;
replace wkgroup_total=total[1,16] if year==2000 & wkgroup==4;
replace wkgroup_total=total[1,17] if year==2007 & wkgroup==1;
replace wkgroup_total=total[1,18] if year==2007 & wkgroup==2;
replace wkgroup_total=total[1,19] if year==2007 & wkgroup==3;
replace wkgroup_total=total[1,20] if year==2007 & wkgroup==4;
replace wkgroup_total=total[1,21] if year==2008 & wkgroup==1;
replace wkgroup_total=total[1,22] if year==2008 & wkgroup==2;
replace wkgroup_total=total[1,23] if year==2008 & wkgroup==3;
replace wkgroup_total=total[1,24] if year==2008 & wkgroup==4;

mat drop total;

total wkgroup if wkgroup!=1 [pw=marsupwt], over (year);
mat total=r(table);
gen wagesample_total=total[1,1] if year==1989 & wkgroup!=1;
replace wagesample_total=total[1,2] if year==1990 & wkgroup!=1;
replace wagesample_total=total[1,3] if year==1999 & wkgroup!=1;
replace wagesample_total=total[1,4] if year==2000 & wkgroup!=1;
replace wagesample_total=total[1,5] if year==2007 & wkgroup!=1;
replace wagesample_total=total[1,6] if year==2008 & wkgroup!=1;

gen wkgroup_percent=wkgroup_total/wagesample_total;

mat drop total;
total wkgroup [pw=marsupwt], over(year);
mat total=r(table);
gen pop_total=total[1,1] if year==1989;
replace pop_total=total[1,2] if year==1990;
replace pop_total=total[1,3] if year==1999;
replace pop_total=total[1,4] if year==2000;
replace pop_total=total[1,5] if year==2007;
replace pop_total=total[1,6] if year==2008;
gen wkgroup_percent2=wkgroup_total/pop_total;

/**Tab the wage sample fractions**/
/*bysort year sex wkgroup: tab wkgroup_percent [aweight=marsupwt] if wkgroup!=1 &(year==1990 | year==2000| year==2008);

bysort sex wkgroup: egen wkgroup_total_EPOP=count(wkgroup &(year==1989 | year==1999| year==2007));
bysort sex: egen EPOP_total=count(wkgroup &(year==1989 | year==1999| year==2007));
gen wkgroup_percent_EPOP=wkgroup_total_EPOP/EPOP_total;
/**Tab the EPOP sample fractions**/
bysort sex wkgroup: tab wkgroup_percent_EPOP [aweight=marsupwt] if year==1989|year==1999|year==2007;
*/
bysort wkgroup: egen max_gp2=max(wkgroup_percent) if year==2000 & wkgroup==2 & lnwagewk!=.;
egen fix_weight_gp2=max(max_gp2);
bysort wkgroup: egen max_gp3=max(wkgroup_percent) if year==2000 & wkgroup==3 & lnwagewk!=.;
egen fix_weight_gp3=max(max_gp3);
bysort wkgroup: egen max_gp4=max(wkgroup_percent) if year==2000 & wkgroup==4 & lnwagewk!=.;
egen fix_weight_gp4=max(max_gp4);

/*Trim the wages to exclude outliers - 5% on each side*/
egen lnwagewk_95pct=pctile(lnwagewk) if year==1990, p(95);
egen lnwagewk_5pct=pctile(lnwagewk) if year==1990, p(5);
gen lnwagewk_trim=lnwagewk
	if year==1990 & lnwagewk <=lnwagewk_95pct 
	& lnwagewk>=lnwagewk_5pct;
replace wagesample=0 if year==1990 & lnwagewk>lnwagewk_95pct | year==1990 & lnwagewk<lnwagewk_5pct;
drop lnwagewk_95pct lnwagewk_5pct;

/*Trim the wages to exclude outliers - 5% on each side*/
egen lnwagewk_95pct=pctile(lnwagewk) if year==2000, p(95);
egen lnwagewk_5pct=pctile(lnwagewk) if year==2000, p(5);
replace lnwagewk_trim=lnwagewk
	if year==2000 & lnwagewk <=lnwagewk_95pct 
	& lnwagewk>=lnwagewk_5pct;
replace wagesample=0 if year==2000 & lnwagewk>lnwagewk_95pct | year==2000 & lnwagewk<lnwagewk_5pct;
drop lnwagewk_95pct lnwagewk_5pct;

/*Trim outliers - 5% each side*/
egen lnwagewk_95pct=pctile(lnwagewk) if year==2008, p(95);
egen lnwagewk_5pct=pctile(lnwagewk) if year==2008, p(5);
replace lnwagewk_trim=lnwagewk
	if year==2008 & lnwagewk <=lnwagewk_95pct 
	& lnwagewk>=lnwagewk_5pct;
replace wagesample=0 if year==2008 & lnwagewk>lnwagewk_95pct | year==2008 & lnwagewk<lnwagewk_5pct;
drop lnwagewk_95pct lnwagewk_5pct;

egen lnwagehr_95pct=pctile(lnwagehr) if year==1990, p(95);
egen lnwagehr_5pct=pctile(lnwagehr) if year==1990, p(5);
gen lnwagehr_trim=lnwagehr
	if year==1990 & lnwagehr <=lnwagehr_95pct 
	& lnwagehr>=lnwagehr_5pct;
drop lnwagehr_95pct lnwagehr_5pct;

/*Trim outliers - 5% each side*/
egen lnwagehr_95pct=pctile(lnwagehr) if year==2000, p(95);
egen lnwagehr_5pct=pctile(lnwagehr) if year==2000, p(5);
replace lnwagehr_trim=lnwagehr
	if year==2000 & lnwagehr <=lnwagehr_95pct 
	& lnwagehr>=lnwagehr_5pct;
drop lnwagehr_95pct lnwagehr_5pct;

/*Trim outliers - 5% each side*/
egen lnwagehr_95pct=pctile(lnwagehr) if year==2008, p(95);
egen lnwagehr_5pct=pctile(lnwagehr) if year==2008, p(5);
replace lnwagehr_trim=lnwagehr
	if year==2008 & lnwagehr <=lnwagehr_95pct 
	& lnwagehr>=lnwagehr_5pct;
drop lnwagehr_95pct lnwagehr_5pct;

/*************First Wage Regression*****************/
/****wk******/
/*weekly wage regression for week 1-19 group*/
reg lnwagewk_trim married divwidsep headhh singleparent age16to24lessHSwhite-age55to64Colblack [pweight=marsupwt]
	       if wkgroup==2 & year==1990;
eststo wagewk89_gp2;
/*For anyone with weeks worked=0, assign them the predicted wage
 for the 1-19 weeks worked wage regression*/
predict lnwagewkPredict89_gp1 if year==1989 & wkgroup==1; 
predict lnwagewkPredict89_gp2 if year==1989 & wkgroup!=1;
gen lnwagewkPredict=lnwagewkPredict89_gp1 if year==1989 & wkgroup==1;

reg lnwagewk_trim  married divwidsep headhh singleparent age16to24lessHSwhite-age55to64Colblack [pweight=marsupwt]
	       if wkgroup==2 & year==2000;
eststo wagewk99_gp2;
/*For anyone with weeks worked=0, assign them the predicted wage
 for the 1-19 weeks worked wage regression*/
predict lnwagewkPredict99_gp1 if year==1999 & wkgroup==1; 
predict lnwagewkPredict99_gp2 if year==1999 & wkgroup!=1;
replace lnwagewkPredict=lnwagewkPredict99_gp1 if year==1999 & wkgroup==1;

reg lnwagewk_trim  married divwidsep headhh singleparent age16to24lessHSwhite-age55to64Colblack [pweight=marsupwt]
	       if wkgroup==2 & year==2008;
eststo wagewk07_gp2;
/*For anyone with weeks worked=0, assign them the predicted wage
 for the 1-19 weeks worked wage regression*/
predict lnwagewkPredict07_gp1 if year==2007 & wkgroup==1; 
predict lnwagewkPredict07_gp2 if year==2007 & wkgroup!=1;
replace lnwagewkPredict=lnwagewkPredict07_gp1 if year==2007 & wkgroup==1;

/*weekly wage regression for week 20-39 group*/
reg lnwagewk_trim  married divwidsep headhh singleparent age16to24lessHSwhite-age55to64Colblack [pweight=marsupwt]
	       if wkgroup==3 & year==1990;
eststo wagewk89_gp3;
predict lnwagewkPredict89_gp3 if year==1989 & wkgroup!=1; 

reg lnwagewk_trim  married divwidsep headhh singleparent age16to24lessHSwhite-age55to64Colblack [pweight=marsupwt]
	       if wkgroup==3 & year==2000;
eststo wagewk99_gp3;
predict lnwagewkPredict99_gp3 if year==1999 & wkgroup!=1; 

reg lnwagewk_trim  married divwidsep headhh singleparent age16to24lessHSwhite-age55to64Colblack [pweight=marsupwt]
	       if wkgroup==3 & year==2008;
eststo wagewk07_gp3;
predict lnwagewkPredict07_gp3 if year==2007 & wkgroup!=1; 

/*weekly wage regression for week 40+ group*/
reg lnwagewk_trim  married divwidsep headhh singleparent age16to24lessHSwhite-age55to64Colblack [pweight=marsupwt]
	       if wkgroup==4 & year==1990;
eststo wagewk89_gp4;
predict lnwagewkPredict89_gp4 if year==1989 & wkgroup!=1; 

reg lnwagewk_trim  married divwidsep headhh singleparent age16to24lessHSwhite-age55to64Colblack [pweight=marsupwt]
	       if wkgroup==4 & year==2000;
eststo wagewk99_gp4;
predict lnwagewkPredict99_gp4 if year==1999 & wkgroup!=1; 

reg lnwagewk_trim  married divwidsep headhh singleparent age16to24lessHSwhite-age55to64Colblack [pweight=marsupwt]
	       if wkgroup==4 & year==2008;
eststo wagewk07_gp4;
predict lnwagewkPredict07_gp4 if year==2007 & wkgroup!=1; 

replace lnwagewkPredict=fix_weight_gp2*lnwagewkPredict07_gp2
						+fix_weight_gp3*lnwagewkPredict07_gp3
						+fix_weight_gp4*lnwagewkPredict07_gp4 if year==2007 & wkgroup!=1;

replace lnwagewkPredict=fix_weight_gp2*lnwagewkPredict99_gp2
						+fix_weight_gp3*lnwagewkPredict99_gp3
						+fix_weight_gp4*lnwagewkPredict99_gp4 if year==1999 & wkgroup!=1;
						
replace lnwagewkPredict=fix_weight_gp2*lnwagewkPredict89_gp2
						+fix_weight_gp3*lnwagewkPredict89_gp3
						+fix_weight_gp4*lnwagewkPredict89_gp4 if year==1989 & wkgroup!=1;
/****hr******/
/*hourly wage regression for week 1-19 group*/
reg lnwagehr_trim  married divwidsep headhh singleparent age16to24lessHSwhite-age55to64Colblack [pweight=marsupwt]
	       if wkgroup==2 & year==1990;
eststo wagehr89_gp2;
/*For anyone with weeks worked=0, assign them the predicted wage
 for the 1-19 weeks worked wage regression*/
predict lnwagehrPredict89_gp1 if year==1989 & wkgroup==1; 
predict lnwagehrPredict89_gp2 if year==1989 & wkgroup!=1;
gen lnwagehrPredict=lnwagehrPredict89_gp1 if year==1989 & wkgroup==1;

reg lnwagehr_trim  married divwidsep headhh singleparent age16to24lessHSwhite-age55to64Colblack [pweight=marsupwt]
	       if wkgroup==2 & year==2000;
eststo wagehr99_gp2;
/*For anyone with weeks worked=0, assign them the predicted wage
 for the 1-19 weeks worked wage regression*/
predict lnwagehrPredict99_gp1 if year==1999 & wkgroup==1; 
predict lnwagehrPredict99_gp2 if year==1999 & wkgroup!=1;
replace lnwagehrPredict=lnwagehrPredict99_gp1 if year==1999 & wkgroup==1;

reg lnwagehr_trim  married divwidsep headhh singleparent age16to24lessHSwhite-age55to64Colblack [pweight=marsupwt]
	       if wkgroup==2 & year==2008;
eststo wagehr07_gp2;
/*For anyone with weeks worked=0, assign them the predicted wage
 for the 1-19 weeks worked wage regression*/
predict lnwagehrPredict07_gp1 if year==2007 & wkgroup==1; 
predict lnwagehrPredict07_gp2 if year==2007 & wkgroup!=1;
replace lnwagehrPredict=lnwagehrPredict07_gp1 if year==2007 & wkgroup==1;


/*hourly wage regression for week 20-39 group*/
reg lnwagehr_trim  married divwidsep headhh singleparent age16to24lessHSwhite-age55to64Colblack [pweight=marsupwt]
	       if wkgroup==3 & year==1990;
eststo wagehr89_gp3;
predict lnwagehrPredict89_gp3 if year==1989 & wkgroup!=1; 

reg lnwagehr_trim  married divwidsep headhh singleparent age16to24lessHSwhite-age55to64Colblack [pweight=marsupwt]
	       if wkgroup==3 & year==2000;
eststo wagehr99_gp3;
predict lnwagehrPredict99_gp3 if year==1999 & wkgroup!=1; 

reg lnwagehr_trim  married divwidsep headhh singleparent age16to24lessHSwhite-age55to64Colblack [pweight=marsupwt]
	       if wkgroup==3 & year==2008;
eststo wagehr07_gp3;
predict lnwagehrPredict07_gp3 if year==2007 & wkgroup!=1; 

/*hourly wage regression for week 40+ group*/
reg lnwagehr_trim  married divwidsep headhh singleparent age16to24lessHSwhite-age55to64Colblack [pweight=marsupwt]
	       if wkgroup==4 & year==1990;
eststo wagehr89_gp4;
predict lnwagehrPredict89_gp4 if year==1989 & wkgroup!=1; 

reg lnwagehr_trim  married divwidsep headhh singleparent age16to24lessHSwhite-age55to64Colblack [pweight=marsupwt]
	       if wkgroup==4 & year==2000;
eststo wagehr99_gp4;
predict lnwagehrPredict99_gp4 if year==1999 & wkgroup!=1; 

reg lnwagehr_trim  married divwidsep headhh singleparent age16to24lessHSwhite-age55to64Colblack [pweight=marsupwt]
	       if wkgroup==4 & year==2008;
eststo wagehr07_gp4;
predict lnwagehrPredict07_gp4 if year==2007 & wkgroup!=1; 

replace lnwagehrPredict=fix_weight_gp2*lnwagehrPredict07_gp2
						+fix_weight_gp3*lnwagehrPredict07_gp3
						+fix_weight_gp4*lnwagehrPredict07_gp4 if year==2007 & wkgroup!=1;

replace lnwagehrPredict=fix_weight_gp2*lnwagehrPredict99_gp2
						+fix_weight_gp3*lnwagehrPredict99_gp3
						+fix_weight_gp4*lnwagehrPredict99_gp4 if year==1999 & wkgroup!=1;
						
replace lnwagehrPredict=fix_weight_gp2*lnwagehrPredict89_gp2
						+fix_weight_gp3*lnwagehrPredict89_gp3
						+fix_weight_gp4*lnwagehrPredict89_gp4 if year==1989 & wkgroup!=1;

/*****************EPOP Regression**********************/
/*EPOP regression using weekly wages - Nid*/
reg employed lnwagewkPredict Nid2007dols kidsunder6 kids6to18 married divwidsep headhh singleparent /*lnNid_sqr*/ age16to24lessHSwhite-age55to64Colblack [pweight=a_fnlwgt]
	if year==1989 | year==1999 | year==2007;
eststo Mwk_Nid;
predict empPredictMwk_Nid if year==1989 | year==1999 | year==2007;

/*EPOP regression using weekly wages - Nidfam*/
reg employed lnwagewkPredict Nidfam2007dols kidsunder6 kids6to18 married divwidsep headhh singleparent /*lnNidfam_sqr*/ age16to24lessHSwhite-age55to64Colblack [pweight=a_fnlwgt]
	if year==1989 | year==1999 | year==2007;
eststo Mwk_Nidfam;
predict empPredictMwk_Nidfam if year==1989 | year==1999 | year==2007;

/*EPOP regression using hourly wages - Nid*/
reg employed lnwagehrPredict Nid2007dols kidsunder6 kids6to18 married divwidsep headhh singleparent /*lnNid_sqr*/ age16to24lessHSwhite-age55to64Colblack [pweight=a_fnlwgt]
	if year==1989 | year==1999 | year==2007;
eststo Mhr_Nid;
predict empPredictMhr_Nid if year==1989 | year==1999 | year==2007;

/*EPOP regression using hourly wages - Nidfam*/
reg employed lnwagehrPredict Nidfam2007dols kidsunder6 kids6to18 married divwidsep headhh singleparent /*lnNidfam_sqr*/ age16to24lessHSwhite-age55to64Colblack [pweight=a_fnlwgt]
	if year==1989 | year==1999 | year==2007;
eststo Mhr_Nidfam;
predict empPredictMhr_Nidfam if year==1989 | year==1999 | year==2007;

/******************Export Results***********************/
/*Export the first-stage regression results*/
esttab wagewk89_gp2 wagewk99_gp2 wagewk07_gp2
using "$dir\Lu\WomenWeeklyWagesGroup2.tex",  b(%9.4f) se nostar wide replace
title("Weekly wage Regression Results for Women, group with worked week 1-19")
mtitles("1989" "1999" "2007");

esttab wagewk89_gp3 wagewk99_gp3 wagewk07_gp3
using "$dir\Lu\WomenWeeklyWagesGroup3.tex",  b(%9.4f) se nostar wide replace
title("Weekly wage Regression Results for Women, group with worked week 20-39")
mtitles("1989" "1999" "2007");

esttab wagewk89_gp4 wagewk99_gp4 wagewk07_gp4
using "$dir\Lu\WomenWeeklyWagesGroup4.tex",  b(%9.4f) se nostar wide replace
title("Weekly wage Regression Results for Women, group with worked week 40+")
mtitles("1989" "1999" "2007");

esttab wagehr89_gp2 wagehr99_gp2 wagehr07_gp2 
using "$dir\Lu\WomenHourlyWagesGroup2.tex", b(%9.4f) se nostar wide replace
title("Hourly wage Regression Results for Women, group with worked week 1-19")
mtitles("1989" "1999" "2007");

esttab wagehr89_gp3 wagehr99_gp3 wagehr07_gp3 
using "$dir\Lu\WomenHourlyWagesGroup3.tex", b(%9.4f) se nostar wide replace
title("Hourly wage Regression Results for Women, group with worked week 20-39")
mtitles("1989" "1999" "2007");

esttab wagehr89_gp4 wagehr99_gp4 wagehr07_gp4 
using "$dir\Lu\WomenHourlyWagesGroup4.tex", b(%9.4f) se nostar wide replace
title("Hourly wage Regression Results for Women, group with worked week 40+")
mtitles("1989" "1999" "2007");

esttab Mwk_Nid Mwk_Nidfam Mhr_Nid Mhr_Nidfam
using "$dir\Lu\WomenEPOP89to07.tex", b(%9.4f) se nostar wide replace
title("EPOP Regression Results for Women, without exclusions")
mtitles("Weekly wage, Nid" "Weekly wage, Nidfam" "Hourly wage - Nid" "Hourly wage - Nidfam");

foreach var of varlist employed empPredictMwk_Nid empPredictMhr_Nid 
					empPredictMwk_Nidfam empPredictMhr_Nidfam lnwagewkPredict{;
gen `var'1989=`var' if year==1989;
gen `var'1999=`var' if year==1999;
gen `var'2007=`var' if year==2007;
};


preserve;
keep if year==1989 | year==1999 | year==2007;
collapse (mean) employed2007 employed1999 employed1989  empPredictMwk_Nid1989-empPredictMhr_Nidfam2007 [pweight=a_fnlwgt];

gen difemp99to89=employed1999-employed1989;
gen difMwk_Nid99to89=empPredictMwk_Nid1999-empPredictMwk_Nid1989;
gen difMwk_Nidfam99to89=empPredictMwk_Nidfam1999-empPredictMwk_Nidfam1989;
gen difMhr_Nid99to89=empPredictMhr_Nid1999-empPredictMhr_Nid1989;
gen difMhr_Nidfam99to89=empPredictMhr_Nidfam1999-empPredictMhr_Nidfam1989;

gen difemp07to99=employed2007-employed1999;
gen difMwk_Nid07to99=empPredictMwk_Nid2007-empPredictMwk_Nid1999;
gen difMwk_Nidfam07to99=empPredictMwk_Nidfam2007-empPredictMwk_Nidfam1999;
gen difMhr_Nid07to99=empPredictMhr_Nid2007-empPredictMhr_Nid1999;
gen difMhr_Nidfam07to99=empPredictMhr_Nidfam2007-empPredictMhr_Nidfam1999;

keep difemp99to89-difMhr_Nidfam07to99;
outsheet using "$dir\Lu\WomenEPOP89to07.xls", replace;

restore; preserve;
keep if year==1989 | year==1999 | year==2007;
collapse (mean) empPredictMwk_Nid1989-empPredictMhr_Nidfam2007 [pweight=a_fnlwgt], by(sex edu age);

gen difMwk_Nid99to89=empPredictMwk_Nid1999-empPredictMwk_Nid1989;
gen difMwk_Nidfam99to89=empPredictMwk_Nidfam1999-empPredictMwk_Nidfam1989;
gen difMhr_Nid99to89=empPredictMhr_Nid1999-empPredictMhr_Nid1989;
gen difMhr_Nidfam99to89=empPredictMhr_Nidfam1999-empPredictMhr_Nidfam1989;

gen difMwk_Nid07to99=empPredictMwk_Nid2007-empPredictMwk_Nid1999;
gen difMwk_Nidfam07to99=empPredictMwk_Nidfam2007-empPredictMwk_Nidfam1999;
gen difMhr_Nid07to99=empPredictMhr_Nid2007-empPredictMhr_Nid1999;
gen difMhr_Nidfam07to99=empPredictMhr_Nidfam2007-empPredictMhr_Nidfam1999;

sort sex edu age;
keep sex edu age difMwk_Nid99to89-difMhr_Nidfam07to99;
outsheet using "$dir\Lu\Table1EPOPWomen89to07.xls", replace;

restore; preserve;
keep if year==1989 | year==1999 | year==2007;
collapse (mean) empPredictMwk_Nid1989-empPredictMhr_Nidfam2007  [pweight=a_fnlwgt],  by(age edu sex race);

gen difMwk_Nid99to89=empPredictMwk_Nid1999-empPredictMwk_Nid1989;
gen difMwk_Nidfam99to89=empPredictMwk_Nidfam1999-empPredictMwk_Nidfam1989;
gen difMhr_Nid99to89=empPredictMhr_Nid1999-empPredictMhr_Nid1989;
gen difMhr_Nidfam99to89=empPredictMhr_Nidfam1999-empPredictMhr_Nidfam1989;

gen difMwk_Nid07to99=empPredictMwk_Nid2007-empPredictMwk_Nid1999;
gen difMwk_Nidfam07to99=empPredictMwk_Nidfam2007-empPredictMwk_Nidfam1999;
gen difMhr_Nid07to99=empPredictMhr_Nid2007-empPredictMhr_Nid1999;
gen difMhr_Nidfam07to99=empPredictMhr_Nidfam2007-empPredictMhr_Nidfam1999;

sort race sex edu age;
keep race sex edu age difMwk_Nid99to89-difMhr_Nidfam07to99;
outsheet using "$dir\Lu\Table2EPOPWomen89to07.xls", replace;

restore; preserve;
keep if year==1989 | year==1999 | year==2007;
collapse (mean) lnwagewkPredict [pweight=a_fnlwgt], by (year);
outsheet using $dir\Lu\WgtWagePredictWomen_all.xls, replace;

restore; preserve;
keep if year==1989 | year==1999 | year==2007;
gen workers=cond(wkgroup>1,1,0,0);
collapse (mean) lnwagewkPredict1989-lnwagewkPredict2007 , by(workers);
outsheet using $dir\Lu\NowgtWagePredictWomen.xls, replace;

restore; preserve;
keep if year==1989 | year==1999 | year==2007;
gen workers=cond(wkgroup>1,1,0,0);
collapse (mean) lnwagewkPredict1989-lnwagewkPredict2007 [pweight=a_fnlwgt], by(workers);
outsheet using $dir\Lu\WgtWagePredictWomen.xls, replace;

restore; preserve;
collapse (mean) wkgroup_percent, by(year wkgroup);
outsheet using $dir\Lu\wkgp_pctWomen.xls, replace;

restore; preserve;
collapse (mean) wkgroup_percent2, by(year wkgroup);
outsheet using $dir\Lu\wkgp_pct2Women.xls, replace;

/*Decomposition*/
restore; preserve;
keep if year==1989 | year==1999 | year==2007;
collapse (mean) lnwagewkPredict Nid2007dols kidsunder6 kids6to18 married divwidsep headhh singleparent age16to24lessHSwhite-age55to64Colblack, by(year);
outsheet using "$dir\Lu\NoWgtMeansWomen_89to07.xls", replace;

restore; preserve;
keep if year==1989 | year==1999 | year==2007;
collapse (mean) lnwagewkPredict Nid2007dols kidsunder6 kids6to18 married divwidsep headhh singleparent age16to24lessHSwhite-age55to64Colblack [pweight=a_fnlwgt], by(year);
outsheet using "$dir\Lu\WgtMeansWomen_89to07.xls", replace;

restore; preserve;
esttab Mwk_Nid Mwk_Nidfam Mhr_Nid Mhr_Nidfam
using "$dir\Lu\WomenEPOP89to07_betas.csv", b(%9.4f) nostar wide replace;

log close;

