#delimit ;
clear;
set memory 1g;

use "C:\Users\Nicole\Desktop\Labor Supply RA\CPS extracts\MarchCPS\Regressions\Organize Data\dataforlaborsupply_noexclus.dta", clear;

recode edu (5=4);
drop if a_lfsr==0;
drop if age==5;
drop if a_fnlwgt==0;

foreach var of varlist  dis_yn hfoodsp hengast hflunch hlorent paw_yn uc_yn mcare mcaid ss_yn {;
recode `var' (2=0);
};

gen transfer=1 if hfoodsp==1 | hengast==1 | hflunch==1 | hlorent==1 | paw_yn==1 | uc_yn==1 | mcare==1 | mcaid==1 |  ss_yn==1;
replace transfer=0 if (transfer);

foreach var of varlist  dis_yn hfoodsp hengast hflunch hlorent paw_yn uc_yn mcare mcaid ss_yn {;
gen `var'1989=`var' if year==1989;
gen `var'1999=`var' if year==1999;
gen `var'2007=`var' if year==2007;
};

/*
preserve;
collapse (mean) dis_yn hfoodsp hengast hflunch hlorent paw_yn uc_yn mcare mcaid ss_yn dis_yn1989-ss_yn2007 [pweight=a_fnlwgt], by(age edu sex);
foreach var of varlist dis_yn hfoodsp hengast hflunch hlorent paw_yn uc_yn mcare mcaid ss_yn {;
gen dif_`var'89to99=`var'1999-`var'1989;
gen dif_`var'99to07=`var'2007-`var'1999;
};
drop dis_yn hfoodsp hengast hflunch hlorent paw_yn uc_yn mcare mcaid ss_yn  dis_yn1989-ss_yn2007;
sort sex edu age;
outsheet using "C:\Users\Nicole\Desktop\Labor Supply RA\CPS extracts\MarchCPS\Transfers\transferallyears.xls", replace;
restore;
*/


collapse (mean) dis_yn hfoodsp hengast hflunch hlorent paw_yn uc_yn mcare mcaid ss_yn  dis_yn1989-ss_yn2007 [pweight=a_fnlwgt], by(sex);
foreach var of varlist dis_yn hfoodsp hengast hflunch hlorent paw_yn uc_yn mcare mcaid ss_yn {;
gen dif_`var'89to99=`var'1999-`var'1989;
gen dif_`var'99to07=`var'2007-`var'1999;
};
drop dis_yn hfoodsp hengast hflunch hlorent paw_yn uc_yn mcare mcaid ss_yn dis_yn1989-ss_yn2007;
sort sex;
outsheet using "C:\Users\Nicole\Desktop\Labor Supply RA\CPS extracts\MarchCPS\Transfers\OverallTransferAllYears.xls", replace;
