capture log close
prog drop _all
set more off
set trace off
pause on
#delimit ;
clear;

global date 121008;
global model "3H2B_selection2AW";
global dir "D:\RA\Moffitt\Nicole_LS\091712";
capture log using $dir\Lu\men_${model}_${date}.log, replace;
use $dir\Data\dataforlaborsupply_noexclus.dta;

recode edu (5=4);

gen Nid=fdivval+fintval;
gen Nid2007dols=Nid/0.830679413 if year==1999;
replace Nid2007dols=Nid/0.851366007 if year==2000;
replace Nid2007dols=Nid/0.654281083 if year==1989;
replace Nid2007dols=Nid/0.684177101 if year==1990;
replace Nid2007dols=Nid if year==2007;
replace Nid2007dols=Nid/1.032644859 if year==2008;

gen Nidfam=Nid+earnfam;
gen Nidfam2007dols=Nidfam/0.830679413 if year==1999;
replace Nidfam2007dols=Nidfam/0.851366007 if year==2000;
replace Nidfam2007dols=Nidfam/0.654281083 if year==1989;
replace Nidfam2007dols=Nidfam/0.684177101 if year==1990;
replace Nidfam2007dols=Nidfam if year==2007;
replace Nidfam2007dols=Nidfam/1.032644859 if year==2008;

replace Nid2007dols=0 if Nid2007dols<0;
replace Nidfam2007dols=0 if Nidfam2007dols<0;

/*
replace Nid2007dols=Nid2007dols/52+10;
replace Nidfam2007dols=Nidfam2007dols/52+10;
*/

replace Nid2007dols=Nid2007dols/1000;
replace Nidfam2007dols=Nidfam2007dols/1000;

gen Nid0=1 if Nid2007dols==0;
replace Nid0=0 if Nid2007dols!=0;

gen Nidfam0=1 if Nidfam2007dols==0;
replace Nidfam0=0 if Nidfam2007dols!=0;
/*
gen lnNid=log(Nid2007dols) if Nid2007dols!=0;
replace lnNid=0 if Nid2007dols==0;

gen lnNidfam=log(Nidfam2007dols) if Nidfam2007dols!=0;
replace lnNidfam=0 if Nidfam2007dols==0;
*/
gen kids=1 if kidsunder6!=0 |kids6to18!=0;
gen singleparent=1 if kids==1 & married==0;
replace singleparent=0 if singleparent==.;

gen wagesample=1 if ern_srce==1 & ljcw!=6 & ljcw!=5 & h_type!=9 & frmotr!=1 & seotr!=1 & i_ernval!=1 & i_wsval!=1 /*& hrswk>=35 & hrswk<. & wkswork>=40 & wkswork<=.*/;
replace wagesample=0 if ern_srce!=1 | ljcw==6 | ljcw==5 | h_type==9 | frmotr==1 | seotr==1 | i_ernval==1 | i_wsval==1 /*| hrswk<35 | wkswork<40*/;

/*===============================================================*/
/**************First, run it exactly like Lu did*****************/
/*==============================================================*/
keep if sex==1; /*Keep only men*/
drop if age==5; /*Eliminate 65+*/
drop if a_lfsr==0; /*Eliminate members of armed force*/
drop if a_fnlwgt==0;

gen lnwagewk=log(wagewk2007dols) if wagesample==1; /*Apply the exclusions*/
gen lnwagehr=log(wagehr2007dols) if wagesample==1;

/*Create crossed age-education dummies*/
qui gen age16to24lessHS=age16to24*lessHS;
qui gen age16to24HS=age16to24*HS;
qui gen age16to24SC=age16to24*SC;
qui gen age16to24Col=age16to24*Col;
qui gen age25to39lessHS=age25to39*lessHS;
qui gen age25to39HS=age25to39*HS;
qui gen age25to39SC=age25to39*SC;
qui gen age25to39Col=age25to39*Col;
qui gen age40to54lessHS=age40to54*lessHS;
qui gen age40to54HS=age40to54*HS;
qui gen age40to54SC=age40to54*SC;
qui gen age40to54Col=age40to54*Col;
qui gen age55to64lessHS=age55to64*lessHS;
qui gen age55to64HS=age55to64*HS;
qui gen age55to64SC=age55to64*SC;
qui gen age55to64Col=age55to64*Col;

foreach xx of varlist age16to24lessHS-age55to64Col{;
              qui gen `xx'white=`xx'*white;
              qui gen `xx'black=`xx'*black;
		  qui gen `xx'other=`xx'*other;
              };

/*Trim the wages to exclude outliers - 5% on each side*/
egen lnwagewk_95pct=pctile(lnwagewk) if year==1990, p(95);
egen lnwagewk_5pct=pctile(lnwagewk) if year==1990, p(5);
gen lnwagewk_trim=lnwagewk
	if year==1990 & lnwagewk <=lnwagewk_95pct 
	& lnwagewk>=lnwagewk_5pct;
replace wagesample=0 if year==1990 & lnwagewk>lnwagewk_95pct | year==1990 & lnwagewk<lnwagewk_5pct;
drop lnwagewk_95pct lnwagewk_5pct;

/*Trim the wages to exclude outliers - 5% on each side*/
egen lnwagewk_95pct=pctile(lnwagewk) if year==2000, p(95);
egen lnwagewk_5pct=pctile(lnwagewk) if year==2000, p(5);
replace lnwagewk_trim=lnwagewk
	if year==2000 & lnwagewk <=lnwagewk_95pct 
	& lnwagewk>=lnwagewk_5pct;
replace wagesample=0 if year==2000 & lnwagewk>lnwagewk_95pct | year==2000 & lnwagewk<lnwagewk_5pct;
drop lnwagewk_95pct lnwagewk_5pct;

/*Trim outliers - 5% each side*/
egen lnwagewk_95pct=pctile(lnwagewk) if year==2008, p(95);
egen lnwagewk_5pct=pctile(lnwagewk) if year==2008, p(5);
replace lnwagewk_trim=lnwagewk
	if year==2008 & lnwagewk <=lnwagewk_95pct 
	& lnwagewk>=lnwagewk_5pct;
replace wagesample=0 if year==2008 & lnwagewk>lnwagewk_95pct | year==2008 & lnwagewk<lnwagewk_5pct;
drop lnwagewk_95pct lnwagewk_5pct;

egen lnwagehr_95pct=pctile(lnwagehr) if year==1990, p(95);
egen lnwagehr_5pct=pctile(lnwagehr) if year==1990, p(5);
gen lnwagehr_trim=lnwagehr
	if year==1990 & lnwagehr <=lnwagehr_95pct 
	& lnwagehr>=lnwagehr_5pct;
drop lnwagehr_95pct lnwagehr_5pct;

/*Trim outliers - 5% each side*/
egen lnwagehr_95pct=pctile(lnwagehr) if year==2000, p(95);
egen lnwagehr_5pct=pctile(lnwagehr) if year==2000, p(5);
replace lnwagehr_trim=lnwagehr
	if year==2000 & lnwagehr <=lnwagehr_95pct 
	& lnwagehr>=lnwagehr_5pct;
drop lnwagehr_95pct lnwagehr_5pct;

/*Trim outliers - 5% each side*/
egen lnwagehr_95pct=pctile(lnwagehr) if year==2008, p(95);
egen lnwagehr_5pct=pctile(lnwagehr) if year==2008, p(5);
replace lnwagehr_trim=lnwagehr
	if year==2008 & lnwagehr <=lnwagehr_95pct 
	& lnwagehr>=lnwagehr_5pct;
drop lnwagehr_95pct lnwagehr_5pct;

/*First stage EPOP - Nid*/
reg wagesample Nid2007dols kidsunder6 kids6to18 married divwidsep headhh singleparent /*lnNid_sqr*/ age16to24lessHSwhite-age55to64Colblack [pweight=marsupwt]
	if year==1990;
eststo firstNid90;
predict WSNid89_select;
*replace WSNid89_select=1-WSNid89_select;
replace WSNid89_select=1 if year==1989;
reg wagesample Nid2007dols kidsunder6 kids6to18 married divwidsep headhh singleparent /*lnNid_sqr*/ age16to24lessHSwhite-age55to64Colblack [pweight=marsupwt]
	if year==2000;
eststo firstNid00;
predict WSNid99_select;
*replace WSNid99_select=1-WSNid99_select;
replace WSNid99_select=1 if year==1999;
reg wagesample Nid2007dols kidsunder6 kids6to18 married divwidsep headhh singleparent /*lnNid_sqr*/ age16to24lessHSwhite-age55to64Colblack [pweight=marsupwt]
	if year==2008;
eststo firstNid08;
predict WSNid07_select;
*replace WSNid07_select=1-WSNid07_select;
replace WSNid07_select=1 if year==2007;

/*First stage EPOP - Nidfam*/
reg wagesample Nidfam2007dols kidsunder6 kids6to18 married  divwidsep headhh singleparent /*lnNid_sqr*/ age16to24lessHSwhite-age55to64Colblack [pweight=marsupwt]
	if year==1990;
eststo firstNidfam90;
predict WSNidfam89_select;
*replace WSNidfam89_select=1-WSNidfam89_select;
replace WSNidfam89_select=1 if year==1989;
reg wagesample Nidfam2007dols kidsunder6 kids6to18 married divwidsep headhh singleparent /*lnNid_sqr*/ age16to24lessHSwhite-age55to64Colblack [pweight=marsupwt]
	if year==2000;
eststo firstNidfam00;
predict WSNidfam99_select;
*replace WSNidfam99_select=1-WSNidfam99_select;
replace WSNidfam99_select=1 if year==1999;
reg wagesample Nidfam2007dols kidsunder6 kids6to18 married divwidsep headhh singleparent /*lnNid_sqr*/ age16to24lessHSwhite-age55to64Colblack [pweight=marsupwt]
	if year==2008;
eststo firstNidfam08;
predict WSNidfam07_select;
*replace WSNidfam07_select=1-WSNidfam07_select;
replace WSNidfam07_select=1 if year==2007;

/*weekly wage regression for 1989 - Nid*/
reg lnwagewk_trim married divwidsep headhh singleparent WSNid89_select age16to24lessHSwhite-age55to64Colblack [pweight=marsupwt]
	       if year==1990;
eststo wagewkM89_Nid; /*Store the estimates*/
predict lnwagewkPredict89_Nid if year==1989; /*Find the fitted values for use in the EPOP regression*/
gen lnwagewkPredict_Nid=lnwagewkPredict89_Nid if year==1989;

/*weekly wage regression for 1989 - Nidfam*/
reg lnwagewk_trim married divwidsep headhh singleparent WSNidfam89_select age16to24lessHSwhite-age55to64Colblack[pweight=marsupwt]
	       if year==1990;
eststo wagewkM89_Nidfam; /*Store the estimates*/
predict lnwagewkPredict89_Nidfam if year==1989; /*Find the fitted values for use in the EPOP regression*/
gen lnwagewkPredict_Nidfam=lnwagewkPredict89_Nidfam if year==1989;

/*weekly wage regression for 1999 - Nid*/
reg lnwagewk_trim married divwidsep headhh singleparent WSNid99_select  age16to24lessHSwhite-age55to64Colblack [pweight=marsupwt]
	       if year==2000;
eststo wagewkM99_Nid; /*Store the estimates*/
predict lnwagewkPredict99_Nid if year==1999; /*Find the fitted values for use in the EPOP regression*/
replace lnwagewkPredict_Nid=lnwagewkPredict99_Nid if year==1999;

/*weekly wage regression for 1999 - Nidfam*/
reg lnwagewk_trim married divwidsep headhh singleparent WSNidfam99_select age16to24lessHSwhite-age55to64Colblack [pweight=marsupwt]
	       if year==2000;
eststo wagewkM99_Nidfam; /*Store the estimates*/
predict lnwagewkPredict99_Nidfam if year==1999; /*Find the fitted values for use in the EPOP regression*/
replace lnwagewkPredict_Nidfam=lnwagewkPredict99_Nidfam if year==1999;

/*weekly wage regression for 2007 - Nid*/
reg lnwagewk_trim married divwidsep headhh singleparent WSNid07_select age16to24lessHSwhite-age55to64Colblack [pweight=marsupwt]
	     if year==2008;
eststo wagewkM07_Nid;
predict lnwagewkPredict07_Nid if year==2007;
replace lnwagewkPredict_Nid=lnwagewkPredict07_Nid if year==2007;

/*weekly wage regression for 2007 - Nidfam*/
reg lnwagewk_trim married divwidsep headhh singleparent WSNidfam07_select age16to24lessHSwhite-age55to64Colblack [pweight=marsupwt]
	     if year==2008;
eststo wagewkM07_Nidfam;
predict lnwagewkPredict07_Nidfam if year==2007;
replace lnwagewkPredict_Nidfam=lnwagewkPredict07_Nidfam if year==2007;

/*hourly wage regression for 1989 - Nid*/
reg lnwagehr_trim WSNid89_select age16to24lessHSwhite-age55to64Colblack  married divwidsep headhh singleparent  [pweight=marsupwt]
	       if year==1990;
eststo wagehrM89_Nid; /*Store the estimates*/
predict lnwagehrPredict89_Nid if year==1989; /*Find the fitted values for use in the EPOP regression*/
gen lnwagehrPredict_Nid=lnwagehrPredict89_Nid if year==1989;

/*hourly wage regression for 1989 - Nidfam*/
reg lnwagehr_trim WSNidfam89_select age16to24lessHSwhite-age55to64Colblack married divwidsep headhh singleparent [pweight=marsupwt]
	       if year==1990;
eststo wagehrM89_Nidfam; /*Store the estimates*/
predict lnwagehrPredict89_Nidfam if year==1989; /*Find the fitted values for use in the EPOP regression*/
gen lnwagehrPredict_Nidfam=lnwagehrPredict89_Nidfam if year==1989;

/*hourly wage regression for 1999 - Nid*/
reg lnwagehr_trim WSNid99_select age16to24lessHSwhite-age55to64Colblack married divwidsep headhh singleparent [pweight=marsupwt]
	       if year==2000;
eststo wagehrM99_Nid; /*Store the estimates*/
predict lnwagehrPredict99_Nid if year==1999; /*Find the fitted values for use in the EPOP regression*/
replace lnwagehrPredict_Nid=lnwagehrPredict99_Nid if year==1999;

/*hourly wage regression for 1999 - Nid*/
reg lnwagehr_trim WSNidfam99_select age16to24lessHSwhite-age55to64Colblack  married divwidsep headhh singleparent [pweight=marsupwt]
	       if year==2000;
eststo wagehrM99_Nidfam; /*Store the estimates*/
predict lnwagehrPredict99_Nidfam if year==1999; /*Find the fitted values for use in the EPOP regression*/
replace lnwagehrPredict_Nidfam=lnwagehrPredict99_Nidfam if year==1999;

/*hourly wage regression for 2007 - Nid*/
reg lnwagehr_trim WSNid07_select age16to24lessHSwhite-age55to64Colblack married divwidsep headhh singleparent [pweight=marsupwt]
	     if year==2008;
eststo wagehrM07_Nid;
predict lnwagehrPredict07_Nid if year==2007;
replace lnwagehrPredict_Nid=lnwagehrPredict07_Nid if year==2007;

/*hourly wage regression for 2007 - Nidfam*/
reg lnwagehr_trim WSNidfam07_select age16to24lessHSwhite-age55to64Colblack married divwidsep headhh singleparent [pweight=marsupwt]
	     if year==2008;
eststo wagehrM07_Nidfam;
predict lnwagehrPredict07_Nidfam if year==2007;
replace lnwagehrPredict_Nidfam=lnwagehrPredict07_Nidfam if year==2007;

/*EPOP regression using weekly wages - Nid*/
reg employed lnwagewkPredict_Nid Nid2007dols kidsunder6 kids6to18 married divwidsep headhh singleparent /*lnNid_sqr*/ age16to24lessHSwhite-age55to64Colblack [pweight=a_fnlwgt]
	if year==1989 | year==1999 | year==2007;
eststo Mwk_Nid;
matrix define wkNid=get(_b);
svmat wkNid;
predict empPredictMwk_Nid if year==1989 | year==1999 | year==2007 ;
/*
keep if year==1989 | year==1999 | year==2007 ;
collapse (count) employed,  by(sex year age edu);
sort year sex edu age;
outsheet using $dir/Lu/ObsWomen.xls,replace;
*/
/*EPOP regression using weekly wages - Nidfam*/
reg employed lnwagewkPredict_Nidfam Nidfam2007dols kidsunder6 kids6to18 married divwidsep headhh singleparent /*lnNidfam_sqr*/ age16to24lessHSwhite-age55to64Colblack [pweight=a_fnlwgt]
	if year==1989 | year==1999 | year==2007;
eststo Mwk_Nidfam;
matrix define wkNidfam=get(_b);
svmat wkNidfam;
predict empPredictMwk_Nidfam if year==1989 | year==1999 | year==2007;

/*EPOP regression using hourly wages - Nid*/
reg employed lnwagehrPredict_Nid Nid2007dols kidsunder6 kids6to18 married divwidsep headhh singleparent /*lnNid_sqr*/ age16to24lessHSwhite-age55to64Colblack [pweight=a_fnlwgt]
	if year==1989 | year==1999 | year==2007;
eststo Mhr_Nid;
predict empPredictMhr_Nid if year==1989 | year==1999 | year==2007;

/*EPOP regression using hourly wages - Nidfam*/
reg employed lnwagehrPredict_Nidfam Nidfam2007dols kidsunder6 kids6to18 married divwidsep headhh singleparent /*lnNidfam_sqr*/ age16to24lessHSwhite-age55to64Colblack [pweight=a_fnlwgt]
	if year==1989 | year==1999 | year==2007;
eststo Mhr_Nidfam;
predict empPredictMhr_Nidfam if year==1989 | year==1999 | year==2007;

/**********************************************/
/*Export the first-stage regression results*/
esttab firstNid90 firstNid00 firstNid08
using "$dir\Lu\MenfirstNid3H2March.tex",  b(%9.4f) se nostar wide replace
title("First stage regression results for Men using Nid and marsupwt")
mtitles("1989" "1999" "2007");

esttab firstNidfam90 firstNidfam00 firstNidfam08
using "$dir\Lu\MenfirstNidfam3H2March.tex",  b(%9.4f) se nostar wide replace
title("First stage regression results for Men using Nidfam and marsupwt")
mtitles("1989" "1999" "2007");

/*Export the regression results*/

label var WSNid89_select "Predicted Probability of Being in Wage Sample";
label var WSNid99_select "Predicted Probability of Being in Wage Sample";
label var WSNid07_select "Predicted Probability of Being in Wage Sample";
esttab wagewkM89_Nid wagewkM99_Nid wagewkM07_Nid
using "$dir\Lu\TableA_2a.csv", b(%9.4f) se nostar wide replace
label
title("Table A-2(a) Estimates of Log Weekly Wage Regressions for Men")
mtitles("1989" "1999" "2007");

esttab wagewkM89_Nid wagewkM99_Nid wagewkM07_Nid
using "$dir\Lu\MenWeeklyWagesNid89to07_selection.tex", b(%9.4f) se nostar wide replace
title("Weekly wage Regression Results for Men, with Nid in first-stage regression")
mtitles("Weekly wage, 1989" "Weekly wage, 1999" "Weekly wage, 2007");

esttab wagewkM89_Nidfam wagewkM99_Nidfam wagewkM07_Nidfam
using "$dir\Lu\MenWeeklyWagesNidfam89to07_selection.tex", b(%9.4f) se nostar wide replace
title("Weekly wage Regression Results for Men, with Nidfam in first-stage regression")
mtitles("Weekly wage, 1989" "Weekly wage, 1999" "Weekly wage, 2007");

esttab wagehrM89_Nid wagehrM99_Nid wagehrM07_Nid 
using "$dir\Lu\MenHourlyWagesNid89to07_selection.tex", b(%9.4f) se nostar wide replace
title("Hourly wage Regression Results for Men, with Nid in the first-stage regression")
mtitles("Hourly wage, 1989" "Hourly wage, 1999" "Hourly wage, 2007");

esttab wagehrM89_Nidfam wagehrM99_Nidfam wagehrM07_Nidfam 
using "$dir\Lu\MenHourlyWagesNidfam89to07_selection.tex", b(%9.4f) se nostar wide replace
title("Hourly wage Regression Results for Men, with Nidfam in the first-stage regression")
mtitles("Hourly wage, 1989" "Hourly wage, 1999" "Hourly wage, 2007");

esttab Mwk_Nid Mwk_Nidfam Mhr_Nid Mhr_Nidfam
using "$dir\Lu\MenEPOP89to07.tex", b(%9.4f) se nostar wide replace
title("EPOP Regression Results for Men, with exclusions and weights")
mtitles("Weekly wage, Nid" "Weekly wage, Nidfam" "Hourly wage - Nid" "Hourly wage - Nidfam");

foreach var of varlist employed empPredictMwk_Nid empPredictMhr_Nid 
					empPredictMwk_Nidfam empPredictMhr_Nidfam 
					{;
gen `var'1989=`var' if year==1989;
gen `var'1999=`var' if year==1999;
gen `var'2007=`var' if year==2007;
};

preserve;
keep if year==1989 | year==1999 | year==2007;
collapse (mean) employed2007 employed1999 employed1989  empPredictMwk_Nid1989-empPredictMhr_Nidfam2007 [pweight=a_fnlwgt];

gen difemp99to89=employed1999-employed1989;
gen difMwk_Nid99to89=empPredictMwk_Nid1999-empPredictMwk_Nid1989;
gen difMwk_Nidfam99to89=empPredictMwk_Nidfam1999-empPredictMwk_Nidfam1989;
gen difMhr_Nid99to89=empPredictMhr_Nid1999-empPredictMhr_Nid1989;
gen difMhr_Nidfam99to89=empPredictMhr_Nidfam1999-empPredictMhr_Nidfam1989;

gen difemp07to99=employed2007-employed1999;
gen difMwk_Nid07to99=empPredictMwk_Nid2007-empPredictMwk_Nid1999;
gen difMwk_Nidfam07to99=empPredictMwk_Nidfam2007-empPredictMwk_Nidfam1999;
gen difMhr_Nid07to99=empPredictMhr_Nid2007-empPredictMhr_Nid1999;
gen difMhr_Nidfam07to99=empPredictMhr_Nidfam2007-empPredictMhr_Nidfam1999;

keep difemp99to89-difMhr_Nidfam07to99;
outsheet using "$dir\Lu\MenEPOP89to07.xls", replace;

restore; preserve;
keep if year==1989 | year==1999 | year==2007;
collapse (mean) empPredictMwk_Nid1989-empPredictMhr_Nidfam2007 [pweight=a_fnlwgt], by(sex edu age);

gen difMwk_Nid99to89=empPredictMwk_Nid1999-empPredictMwk_Nid1989;
gen difMwk_Nidfam99to89=empPredictMwk_Nidfam1999-empPredictMwk_Nidfam1989;
gen difMhr_Nid99to89=empPredictMhr_Nid1999-empPredictMhr_Nid1989;
gen difMhr_Nidfam99to89=empPredictMhr_Nidfam1999-empPredictMhr_Nidfam1989;

gen difMwk_Nid07to99=empPredictMwk_Nid2007-empPredictMwk_Nid1999;
gen difMwk_Nidfam07to99=empPredictMwk_Nidfam2007-empPredictMwk_Nidfam1999;
gen difMhr_Nid07to99=empPredictMhr_Nid2007-empPredictMhr_Nid1999;
gen difMhr_Nidfam07to99=empPredictMhr_Nidfam2007-empPredictMhr_Nidfam1999;

sort sex edu age;
keep sex edu age difMwk_Nid99to89-difMhr_Nidfam07to99;
outsheet using "$dir\Lu\Table1EPOPMen89to07.xls", replace;

restore; preserve;
keep if year==1989 | year==1999 | year==2007;
collapse (mean) empPredictMwk_Nid1989-empPredictMhr_Nidfam2007 [pweight=a_fnlwgt],  by(age edu sex race);

gen difMwk_Nid99to89=empPredictMwk_Nid1999-empPredictMwk_Nid1989;
gen difMwk_Nidfam99to89=empPredictMwk_Nidfam1999-empPredictMwk_Nidfam1989;
gen difMhr_Nid99to89=empPredictMhr_Nid1999-empPredictMhr_Nid1989;
gen difMhr_Nidfam99to89=empPredictMhr_Nidfam1999-empPredictMhr_Nidfam1989;

gen difMwk_Nid07to99=empPredictMwk_Nid2007-empPredictMwk_Nid1999;
gen difMwk_Nidfam07to99=empPredictMwk_Nidfam2007-empPredictMwk_Nidfam1999;
gen difMhr_Nid07to99=empPredictMhr_Nid2007-empPredictMhr_Nid1999;
gen difMhr_Nidfam07to99=empPredictMhr_Nidfam2007-empPredictMhr_Nidfam1999;

sort race sex edu age;
keep race sex edu age difMwk_Nid99to89-difMhr_Nidfam07to99;

outsheet using "$dir\Lu\Table2EPOPMen89to07.xls", replace;

/*Decomposition*/
restore; preserve;
keep if year==1989 | year==1999 | year==2007;
collapse (mean) lnwagewkPredict_Nid lnwagewkPredict_Nidfam Nid2007dols Nidfam2007dols kidsunder6 kids6to18 married divwidsep headhh singleparent age16to24lessHSwhite-age55to64Colblack, by(year);
outsheet using "$dir\Lu\NoWgtMeansMen3H2_89to07_${married}.xls", replace;

restore; preserve;
keep if year==1989 | year==1999 | year==2007;
collapse (mean) lnwagewkPredict_Nid lnwagewkPredict_Nidfam Nid2007dols Nidfam2007dols kidsunder6 kids6to18 married divwidsep headhh singleparent age16to24lessHSwhite-age55to64Colblack [pweight=a_fnlwgt], by(year);
outsheet using "$dir\Lu\WgtMeansMen3H2_89to07.xls", replace;

restore; preserve;
esttab Mwk_Nid Mwk_Nidfam Mhr_Nid Mhr_Nidfam
using "$dir\Lu\MenEPOP89to07_betas.csv", b(%9.4f) nostar wide replace;

/*
/****************Bootstrap************************/
capture program drop boots;
program define boots, eclass;
use $dir\Lu\bootstrap_men.dta, clear;
preserve;
tempname b1 b2 b3 b4;
bsample if year==1990;
qui reg wagesample Nid2007dols kidsunder6 kids6to18 married divwidsep headhh singleparent /*lnNid_sqr*/ age16to24lessHSwhite-age55to64Colblack /*[pweight=marsupwt]*/;
restore; 
predict WSNid89_select;
replace WSNid89_select=1 if year==1989;
preserve;
bsample if year==1990;
qui reg wagesample Nidfam2007dols kidsunder6 kids6to18 married  divwidsep headhh singleparent /*lnNid_sqr*/ age16to24lessHSwhite-age55to64Colblack/*[pweight=marsupwt]*/;
restore;
predict WSNidfam89_select;
replace WSNidfam89_select=1 if year==1989;
preserve;

bsample if year==2000;
qui reg wagesample Nid2007dols kidsunder6 kids6to18 married divwidsep headhh singleparent /*lnNid_sqr*/ age16to24lessHSwhite-age55to64Colblack/*[pweight=marsupwt]*/;
restore;
predict WSNid99_select;
replace WSNid99_select=1 if year==1999;
preserve;
bsample if year==2000;
qui reg wagesample Nidfam2007dols kidsunder6 kids6to18 married  divwidsep headhh singleparent /*lnNid_sqr*/ age16to24lessHSwhite-age55to64Colblack/*[pweight=marsupwt]*/;
restore; 
predict WSNidfam99_select;
replace WSNidfam99_select=1 if year==1999;
preserve;

bsample if year==2008;
qui reg wagesample Nid2007dols kidsunder6 kids6to18 married  divwidsep headhh singleparent /*lnNid_sqr*/ age16to24lessHSwhite-age55to64Colblack/*[pweight=marsupwt]*/;
restore; 
predict WSNid07_select;
replace WSNid07_select=1 if year==2007;
preserve;
bsample if year==2008;
qui reg wagesample Nidfam2007dols kidsunder6 kids6to18 married  divwidsep headhh singleparent /*lnNid_sqr*/ age16to24lessHSwhite-age55to64Colblack/*[pweight=marsupwt]*/;
restore; 
predict WSNidfam07_select;
replace WSNidfam07_select=1 if year==2007;
preserve;

/*************************Wage Regression*******************/
bsample if year==1990;
qui reg lnwagewk_trim WSNid89_select age16to24lessHSwhite-age55to64Colblack married  divwidsep headhh singleparent /*[pweight=marsupwt]*/;
restore; 
predict lnwagewkPredict89_Nid if year==1989; 
gen lnwagewkPredict_Nid=lnwagewkPredict89_Nid if year==1989;
preserve;
bsample if year==1990;
qui reg lnwagewk_trim WSNidfam89_select age16to24lessHSwhite-age55to64Colblack  married  divwidsep headhh singleparent/*[pweight=marsupwt]*/;
restore; 
predict lnwagewkPredict89_Nidfam if year==1989; 
gen lnwagewkPredict_Nidfam=lnwagewkPredict89_Nidfam if year==1989;
preserve;

bsample if year==2000;
qui reg lnwagewk_trim WSNid99_select age16to24lessHSwhite-age55to64Colblack  married  divwidsep headhh singleparent /*[pweight=marsupwt]*/;
restore;
predict lnwagewkPredict99_Nid if year==1999; 
replace lnwagewkPredict_Nid=lnwagewkPredict99_Nid if year==1999;
preserve;
bsample if year==2000;
qui reg lnwagewk_trim WSNidfam99_select age16to24lessHSwhite-age55to64Colblack married  divwidsep headhh singleparent /*[pweight=marsupwt]*/;
restore;
predict lnwagewkPredict99_Nidfam if year==1999; 
replace lnwagewkPredict_Nidfam=lnwagewkPredict99_Nidfam if year==1999;
preserve;

bsample if year==2008;
qui reg lnwagewk_trim WSNid07_select age16to24lessHSwhite-age55to64Colblack married  divwidsep headhh singleparent /*[pweight=marsupwt]*/;
restore;
predict lnwagewkPredict07_Nid if year==2007;
replace lnwagewkPredict_Nid=lnwagewkPredict07_Nid if year==2007;
preserve;
bsample if year==2008;
qui reg lnwagewk_trim WSNidfam07_select age16to24lessHSwhite-age55to64Colblack married  divwidsep headhh singleparent /*[pweight=marsupwt]*/;
restore;
predict lnwagewkPredict07_Nidfam if year==2007;
replace lnwagewkPredict_Nidfam=lnwagewkPredict07_Nidfam if year==2007;
preserve;

bsample if year==1990;
qui reg lnwagehr_trim WSNid89_select age16to24lessHSwhite-age55to64Colblack  married  divwidsep headhh singleparent  /*[pweight=marsupwt]*/;
restore;
predict lnwagehrPredict89_Nid if year==1989; 
gen lnwagehrPredict_Nid=lnwagehrPredict89_Nid if year==1989;
preserve;
bsample if year==2008;
qui reg lnwagehr_trim WSNidfam89_select age16to24lessHSwhite-age55to64Colblack married  divwidsep headhh singleparent /*[pweight=marsupwt]*/;
restore;
predict lnwagehrPredict89_Nidfam if year==1989; 
gen lnwagehrPredict_Nidfam=lnwagehrPredict89_Nidfam if year==1989;
preserve;

bsample if year==2000;
qui reg lnwagehr_trim WSNid99_select age16to24lessHSwhite-age55to64Colblack married  divwidsep headhh singleparent /*[pweight=marsupwt]*/;
restore;
predict lnwagehrPredict99_Nid if year==1999; /*Find the fitted values for use in the EPOP regression*/
replace lnwagehrPredict_Nid=lnwagehrPredict99_Nid if year==1999;
preserve;
bsample if year==2000;
qui reg lnwagehr_trim WSNidfam99_select age16to24lessHSwhite-age55to64Colblack  married  divwidsep headhh singleparent /*[pweight=marsupwt]*/;
restore;
predict lnwagehrPredict99_Nidfam if year==1999; /*Find the fitted values for use in the EPOP regression*/
replace lnwagehrPredict_Nidfam=lnwagehrPredict99_Nidfam if year==1999;
preserve;

bsample if year==2008;
qui reg lnwagehr_trim WSNid07_select age16to24lessHSwhite-age55to64Colblack married  divwidsep headhh singleparent /*[pweight=marsupwt]*/;
restore;
predict lnwagehrPredict07_Nid if year==2007;
replace lnwagehrPredict_Nid=lnwagehrPredict07_Nid if year==2007;
preserve;
bsample if year==2008;
qui reg lnwagehr_trim WSNidfam07_select age16to24lessHSwhite-age55to64Colblack married  divwidsep headhh singleparent /*[pweight=marsupwt]*/;
restore;
predict lnwagehrPredict07_Nidfam if year==2007;
replace lnwagehrPredict_Nidfam=lnwagehrPredict07_Nidfam if year==2007;
preserve;

bsample if year==1989 | year==1999 | year==2007;
qui reg employed lnwagewkPredict_Nid Nid2007dols kidsunder6 kids6to18 married  divwidsep headhh singleparent age16to24lessHSwhite-age55to64Colblack;
matrix `b1'=e(b);
ereturn post `b1';
/*qui reg employed lnwagewkPredict_Nidfam Nidfam2007dols kidsunder6 kids6to18 married  divwidsep headhh singleparent /*lnNidfam_sqr*/ age16to24lessHSwhite-age55to64Colblack;
matrix `b2'=e(b);
ereturn post `b2';
qui reg employed lnwagehrPredict_Nid Nid2007dols kidsunder6 kids6to18 married  divwidsep headhh singleparent /*lnNid_sqr*/ age16to24lessHSwhite-age55to64Colblack ;
matrix `b3'=e(b);
ereturn post `b3';
qui reg employed lnwagehrPredict_Nidfam Nidfam2007dols kidsunder6 kids6to18 married  divwidsep headhh singleparent /*lnNidfam_sqr*/ age16to24lessHSwhite-age55to64Colblack ;
matrix `b4'=e(b);
ereturn post `b4';
restore;*/
end;

simulate, reps(400) seed(10101): boots;
sum;
sutex, nobs digits(4) minmax par;
*/
log close;
