#delimit ;
clear;
set memory 1g;

/*
fownu6 = own children in the family under 6
fownu18 = own never married children under 18
*/

/*The variables that I need
..sex - a_sex
..race - a_race
..age - a_age
..education - a_hga
..head of the household - there's a variable hhdrel that equals 1 if the person is the householder
	Does this mean the head of the household?
..number of children - hh5to18 (persons in hh ages 5 to 18) hunder18 (persons in hh under 18)
..number of members of the household - h_numper
..urban/rural - hmsa_r (=1 if lives in an MSA, =2 if NonMSA and =3 if not identifiable) migplac (something about last year's residence status - )
..marital status - a_maritl
..region (4 categories) - gediv (current residence, 9 categories) mig_reg (region of previous residence)
..Non-Labor income -- interest dividends - finc_div (yes or no) and fdivval (Dividend income) AND finc_int (yes or no) and fintval (Interest income)
		     -- rent: finc_rnt (yes or no) and frntval (value of income)
 	           -- earnings of others in the family - fearnval (total value of family earnings - a positive value if finc_ws==1 (some
				wages or salaries) finc_se (self-employed) or finc_fr (self-employed on farm))
					also finc_ws (yes or no) fwsval (family wages and salaries)
					also ftotval (total family income -- includes all nonlabor income)
wages
Note::: All of these variables relate to all workers (including the self-employed)
workyn=1 if the person worked at all last year
wtemp=1 if the person did any seasonal or part-time work
for people who worked (i.e. workyn=1), wkswork reports the number of weeks the person worked
for the people who worked (i.e. workyn=1), hrswk reports the number of hours the person usually worked each week
ljcw reports the class of worker for people with workyn==1
ern_yn=1 if the person had earnings last year
ern_val gives the value of the earnings
ern_srce=1 if the person gets earnings from wages and salary

the quick route -- wsal_yn=1 if the person had earnings from wages or salary
and wsal_val gives the amount of those earnings

 -- hourly wages and weekly earnings last year
	agi (adjusted gross income)
	a_clswkr (class of worker -- 5 & 6 are self-employed workers)
	current earnings -- a_herntf (hourly earnings) & a_werntf (weekly earnings) but
				  seems to be zero for most people?
	earner (yes or no) ern_val (value of earnings before deduction)
	pearnval (total value of earnings)
	wsal_val (total wage and salary earnings)
	a_hrspay (hourly earnings) but not in universe for most
	pehruslt (hours per week usually worked at all jobs)
	a_hrs1 (hours worked last week)
	hrswk (hours worked per week)
	wkswork (weeks worked last year)
*/


/*Notes on transfers
hfoodsp - did anyone in the house receive food stamps?
hfdval - what's the value of the food stamps received?
hengast - has this household received energy assistance?
hengval - value of the energy assistance
hflunch - how many kids in the house get free lunch (0=not applicable, 1=some, 2=non);
hpublic - is this a public housing project?
hlorent - rent subsidies received during the year
paw_yn - did you receive public assitance this year?
paw_val - what's the value of public assistance received
uc_yn - did the person receive unemployment compensation
uc_val - value of the unemployment compensation
mcare - was ... covered by medicare?
mcaid - was ... covered by medicaid?
ss_yn - did ... receive social security?
ss_val - value of social security income
*/

use a_enrlw pemlr a_hscol a_wkstat ph_seq a_lineno hhdfmx h_seq hhpos hnumfam fh_seq ffpos a_famnum a_famtyp ftype famrel fownu6 fownu18 gediv mig_div hea fspanish a_spouse fh_seq a_lineno a_reorgn a_ernlwt hrntval i_rntval ern_yn ern_srce ern_val phmemprs ern_otr frmotr frm_val seotr semp_val wageotr ws_val h_type ljcw wsal_val workyn wsal_yn
    a_fnlwgt a_lfsr a_sex a_race a_age a_hga hhdrel hh5to18 hunder18 h_numper a_maritl 
    hg_reg migsame mig_reg hmsa_r migplac 
    a_exprrp a_pfrel wemind
    fdivval fintval frntval fearnval pearnval
    workyn hrcheck ptyn ptweeks hrswk wkswork
    i_ernval i_wsval i_wkswk i_hrswk
    marsupwt a_fnlwgt
    dis_yn dsab_val hfoodsp hfdval hengast hengval hflunch hpublic hlorent paw_yn paw_val uc_yn uc_val mcaid mcare ss_yn ss_val
    using "C:\Users\Nicole\Desktop\Labor Supply RA\CPS extracts\MarchCPS\StataFiles\cpsmar99.dta";
gen year=1999;

append using "C:\Users\Nicole\Desktop\Labor Supply RA\CPS extracts\MarchCPS\StataFiles\cpsmar00.dta", 
  keep(a_enrlw pemlr a_hscol a_wkstat ph_seq a_lineno hhdfmx h_seq hhpos hnumfam fh_seq ffpos a_famnum a_famtyp ftype famrel fownu6 fownu18 gediv mig_div hea a_lineno a_spouse fh_seq fspanish a_reorgn a_ernlwt hrntval i_rntval ern_yn ern_srce ern_val phmemprs ern_otr frmotr frm_val seotr semp_val wageotr ws_val h_type ljcw wsal_val workyn wsal_yn
	 a_fnlwgt a_lfsr a_sex a_race a_age a_hga hhdrel hh5to18 hunder18 h_numper a_maritl 
       hg_reg migsame mig_reg hmsa_r migplac wemind
       a_exprrp a_pfrel
	 fdivval fintval frntval fearnval pearnval
       workyn hrcheck ptyn ptweeks hrswk wkswork
	 i_ernval i_wsval i_wkswk i_hrswk
       marsupwt a_fnlwgt
	 dis_yn dsab_val hfoodsp hfdval hengast hengval hflunch hpublic hlorent paw_yn paw_val uc_yn uc_val mcaid mcare ss_yn ss_val);
replace year=2000 if missing(year);


append using "C:\Users\Nicole\Desktop\Labor Supply RA\CPS extracts\MarchCPS\StataFiles\cpsmar07.dta", 
  keep(a_enrlw pemlr a_hscol a_wkstat ph_seq a_lineno hhdfmx h_seq hhpos hnumfam fh_seq ffpos a_famnum a_famtyp ftype famrel fownu6 fownu18 gediv mig_div hea a_lineno fh_seq a_spouse fspanish pehspnon a_ernlwt hrntval i_rntval ern_yn ern_srce ern_val phmemprs ern_otr frmotr frm_val seotr semp_val wageotr ws_val h_type ljcw wsal_val workyn wsal_yn
       a_fnlwgt a_lfsr a_sex prdtrace a_age a_hga hhdrel hh5to18 hunder18 h_numper a_maritl 
	 gereg migsame mig_reg gtmetsta mig_cbst 
	 a_exprrp a_pfrel wemind
       fdivval fintval frntval fearnval pearnval
       workyn hrcheck ptyn ptweeks hrswk wkswork
	 i_ernval i_wsval i_wkswk i_hrswk
	 marsupwt a_fnlwgt
	 dis_yn dsab_val hfoodsp hfdval hengast hengval hflunch hpublic hlorent paw_yn paw_val uc_yn uc_val mcaid mcare ss_yn ss_val);
replace year=2007 if missing(year);

append using "C:\Users\Nicole\Desktop\Labor Supply RA\CPS extracts\MarchCPS\StataFiles\cpsmar08.dta", 
   keep(a_enrlw pemlr a_hscol a_wkstat ph_seq a_lineno hhdfmx h_seq hhpos hnumfam fh_seq ffpos a_famnum a_famtyp ftype famrel fownu6 fownu18 gediv mig_div hea a_lineno fh_seq fspanish a_spouse pehspnon a_ernlwt hrntval i_rntval ern_yn ern_srce ern_val phmemprs ern_otr frmotr frm_val seotr semp_val wageotr ws_val h_type ljcw wsal_val workyn wsal_yn
        a_fnlwgt a_lfsr a_sex prdtrace a_age a_hga hhdrel hh5to18 hunder18 h_numper a_maritl 
        gereg migsame mig_reg wemind gtmetsta mig_cbst 
	  a_exprrp a_pfrel
        fdivval fintval frntval fearnval pearnval
        workyn hrcheck ptyn ptweeks hrswk wkswork
	  i_ernval i_wsval i_wkswk i_hrswk
	  marsupwt a_fnlwgt
	  dis_yn dsab_val hfoodsp hfdval hengast hengval hflunch hpublic hlorent paw_yn paw_val uc_yn uc_val mcaid mcare ss_yn ss_val);
replace year=2008 if missing(year);

append using "C:\Users\Nicole\Desktop\Labor Supply RA\CPS extracts\MarchCPS\StataFiles\cpsmar89.dta", 
   keep(hg_st60 grin_st a_enrlw a_majact a_hscol a_wkstat ph_seq a_lineno hhdfmx h_seq hhpos hnumfam fh_seq ffpos a_famnum a_famtyp ftype famrel fownu6 fownu18 fspanish a_ernlwt hrntval i_rntval ern_yn ern_srce ern_val phmemprs ern_otr frmotr frm_val seotr semp_val wageotr ws_val h_type ljcw wsal_val workyn wsal_yn
        a_fnlwgt a_lfsr a_sex a_race a_age a_hga schl1 hhdrel hh5to18 hunder18 h_numper a_maritl 
        hg_reg migsame grin_reg wemind hmsa_r grn_plac 
	  a_exprrp a_pfrel
        fdivval fintval frntval fearnval pearnval
        workyn hrcheck ptyn ptweeks hrswk wkswork
	  i_ernval i_wsval i_wkswk i_hrswk
	  marsupwt a_fnlwgt
	  dis_yn dsab_val hfoodsp hfdval hengast hengval hflunch hpublic hlorent paw_yn paw_val uc_yn uc_val mcaid mcare ss_yn ss_val);
replace year=1989 if missing(year);

append using "C:\Users\Nicole\Desktop\Labor Supply RA\CPS extracts\MarchCPS\StataFiles\cpsmar90.dta", 
   keep(hg_st60 grin_st a_enrlw a_majact a_hscol a_wkstat ph_seq a_lineno hhdfmx h_seq hhpos hnumfam fh_seq ffpos a_famnum a_famtyp ftype fownu6 fownu18 fspanish a_ernlwt hrntval i_rntval ern_yn ern_srce ern_val phmemprs ern_otr frmotr frm_val seotr semp_val wageotr ws_val h_type ljcw wsal_val workyn wsal_yn
        a_fnlwgt a_lfsr a_sex a_race a_age a_hga schl1 hhdrel hh5to18 hunder18 h_numper a_maritl 
        hg_reg migsame grin_reg wemind hmsa_r grn_plac 
	  a_exprrp a_pfrel
        fdivval fintval frntval fearnval pearnval
        workyn hrcheck ptyn ptweeks hrswk wkswork
	  i_ernval i_wsval i_wkswk i_hrswk
	  marsupwt a_fnlwgt
	  dis_yn dsab_val hfoodsp hfdval hengast hengval hflunch hpublic hlorent paw_yn paw_val uc_yn uc_val mcaid mcare ss_yn ss_val);
replace year=1990 if missing(year);

/***Crosswalk between grin_st and hg_st60**/
recode grin_st
		(23=1)/*Maine*/
	(33=1) /*New Hampshire*/
	(50=1) /*Vermont*/
	(25=1) /*Massachusetts*/
	(44=1) /*Rhode Island*/
	(9=1) /*Connecticut*/
	(36=2) /*New York*/
	(34=2) /*New Jersey*/
	(42=2) /*Pennsylvania*/
	(39=3) /*Ohio*/
	(18=3) /*Indiana*/
	(17=3) /*Illinois*/
	(26=3) /*Michigan*/
	(55=3) /*Wisconsin*/
	(27=4) /*Minnesota*/
	(19=4) /*Iowa*/
	(29=4) /*Missori*/
	(38=4) /*North Dakota*/
	(46=4) /*South Dakota*/
	(31=4) /*Nebraska*/
	(20=4) /*Kansas*/
	(10=5) /*Delaware*/
	(24=5) /*Maryland*/
	(11=5) /*DC*/
	(51=5) /*Virginia*/
	(54=5) /*West Virginia*/
	(37=5) /*North Carolina*/
	(45=5) /*South Carolina*/
	(13=5) /*Georgia*/
	(12=5) /*Florida*/
	(21=6) /*Kentucky*/
	(47=6) /*Tennesee*/
	(1=6) /*Alabama*/
	(28=6) /*Mississippi*/
	(5=7) /*Arkansas*/
	(22=7) /*Louisiana*/
	(40=7) /*Oklahoma*/
	(48=7) /*Texas*/
	(30=8) /*Montana*/
	(16=8) /*Idaho*/
	(56=8) /*Wyoming*/
	(8=8) /*Colorado*/
	(35=8) /*New Mexico*/
	(4=8) /*Arizona*/
	(49=8) /*Utah*/
	(32=8) /*Nevada*/
	(53=9) /*Washington*/
	(41=9) /*Oregon*/
	(6=9) /*California*/
	(2=9) /*Alaska*/
	(15=9) /*Hawaii*/
	(96=.);

recode hg_st60
	(11=1)/*Maine*/
	(12=1) /*New Hampshire*/
	(13=1) /*Vermont*/
	(14=1) /*Massachusetts*/
	(15=1) /*Rhode Island*/
	(16=1) /*Connecticut*/
	(21=2) /*New York*/
	(22=2) /*New Jersey*/
	(23=2) /*Pennsylvania*/
	(31=3) /*Ohio*/
	(32=3) /*Indiana*/
	(33=3) /*Illinois*/
	(34=3) /*Michigan*/
	(35=3) /*Wisconsin*/
	(41=4) /*Minnesota*/
	(42=4) /*Iowa*/
	(43=4) /*Missori*/
	(44=4) /*North Dakota*/
	(45=4) /*South Dakota*/
	(46=4) /*Nebraska*/
	(47=4) /*Kansas*/
	(51=5) /*Delaware*/
	(52=5) /*Maryland*/
	(53=5) /*DC*/
	(54=5) /*Virginia*/
	(55=5) /*West Virginia*/
	(56=5) /*North Carolina*/
	(57=5) /*South Carolina*/
	(58=5) /*Georgia*/
	(59=5) /*Florida*/
	(61=6) /*Kentucky*/
	(62=6) /*Tennesee*/
	(63=6) /*Alabama*/
	(64=6) /*Mississippi*/
	(71=7) /*Arkansas*/
	(72=7) /*Louisiana*/
	(73=7) /*Oklahoma*/
	(74=7) /*Texas*/
	(81=8) /*Montana*/
	(82=8) /*Idaho*/
	(83=8) /*Wyoming*/
	(84=8) /*Colorado*/
	(85=8) /*New Mexico*/
	(86=8) /*Arizona*/
	(87=8) /*Utah*/
	(88=8) /*Nevada*/
	(91=9) /*Washington*/
	(92=9) /*Oregon*/
	(93=9) /*California*/
	(94=9) /*Alaska*/
	(95=9); /*Hawaii*/


gen retired=1 if a_majact==7 | pemlr==5;
replace retired=0 if missing(retired);
gen unablewk=1 if a_majact==6 | pemlr==6;
replace unablewk=0 if missing(unablewk);
gen school=1 if a_enrlw==1;
replace school=0 if missing(school);


/*Create a unique person identifier to match up with the tax data*/
egen id=concat( ph_seq a_lineno);
destring id, replace;

gen hispanic=1 if pehspnon==1;
replace hispanic=1 if a_reorgn<8;
replace hispanic=0 if missing(hispanic);

/*Drop children and members of the armed forces*/
drop if a_lfsr==0;


/*Sex variable*/
rename a_sex sex;
label define sex
	1 "Male"
	2 "Female";
label values sex sex;

/*Head of household variable*/
gen headhh=1 if hhdrel==1 | hhdrel==2; /*People coded as the householder or the spouse of the householder
						     are categorized as the head of the household*/
label variable headhh "Head of household";
replace headhh=0 if missing(headhh) & !missing(hhdrel);
drop hhdrel;

/*Number of children variables*/
gen kidsunder6=fownu6 if hhdfmx==1 | hhdfmx==2 | hhdfmx==3 | hhdfmx==5 | hhdfmx==6 | hhdfmx==8 | hhdfmx==10 | hhdfmx==11 | hhdfmx==26 | hhdfmx==27 | hhdfmx==30 | hhdfmx==32 | hhdfmx==33 | hhdfmx==35 | hhdfmx==39 | hhdfmx==38 | hhdfmx==43 | hhdfmx==46 | hhdfmx==47;
replace kidsunder6=0 if missing(kidsunder6);
gen kids6to18=fownu18-fownu6 if hhdfmx==1 | hhdfmx==2 | hhdfmx==3 | hhdfmx==5 | hhdfmx==6 | hhdfmx==8 | hhdfmx==10 | hhdfmx==11 | hhdfmx==26 | hhdfmx==27 | hhdfmx==30 | hhdfmx==32 | hhdfmx==33 | hhdfmx==35 | hhdfmx==39 | hhdfmx==38 | hhdfmx==43 | hhdfmx==46 | hhdfmx==47;; 
replace kids6to18=0 if missing(kids6to18);

gen OLDkidsunder5=hunder18-hh5to18;
rename hh5to18 OLDkids5to18;

/*
replace kidsunder6=0 if famrel==3 | famrel==4 | famrel==5;
replace kids6to18=0 if famrel==3 | famrel==4 | famrel==5;	
replace kids6to18=0 if age<=18;
*/

/*Size of the household*/
rename h_numper hhsize;  label variable hhsize "Total number of people in household";

/*Marital status*/
gen married=1 if a_maritl==1 | a_maritl==2 | a_maritl==3;
	/*Categorized as married if 
		1 Married and civilian spouse present
		2 Married and AF spouse present
		3 Married and spouse absent*/
replace married=0 if missing(married) & !missing(a_maritl);
gen divwidsep=1 if a_maritl==4 | a_maritl==5 | a_maritl==6; 
label variable divwidsep "Divorced, widowed or separated";
replace divwidsep=0 if missing(divwidsep) & !missing(a_maritl);
gen single=1 if a_maritl==7;
replace single=0 if missing(single) & !missing(a_maritl);

/*Regional variables*/
gen northeast=1 if hg_reg==1 | gereg==1;
gen midwest=1 if hg_reg==2 | gereg==2;
gen south=1 if hg_reg==3 | gereg==3;
gen west=1 if hg_reg==4 | gereg==4;

foreach var of varlist northeast-west {; 
	replace `var'=0 if missing(`var') & !missing(hg_reg) | missing(`var') & !missing(gereg);
	label variable `var' "Current region";
 };

replace gediv=hg_st60 if year==1990 | year==1989;
drop hg_st60;

gen newengland=1 if gediv==1; label variable newengland "New England";
gen midatlantic=1 if gediv==2; label variable midatlantic "Mid Atlantic";
gen ENcentral=1 if gediv==3; label variable ENcentral "East North Central";
gen WNcentral=1 if gediv==4; label variable WNcentral "West North Central";
gen Satlantic=1 if gediv==5; label variable Satlantic "South Atlantic";
gen EScentral=1 if gediv==6; label variable EScentral "East South Central";
gen WScentral=1 if gediv==7; label variable WScentral "West South Central";
gen mountain=1 if gediv==8; label variable mountain "Mountain";
gen pacific=1 if gediv==9; label variable pacific "Pacific";

foreach var of varlist newengland-pacific {;
	replace `var'=0 if missing(`var') & !missing(gediv); };

replace mig_div=grin_st if year==1989 & migsame==2 | year==1990 & migsame==2;
replace mig_div=gediv if year==1989 & migsame!=2 | year==1990 & migsame!=2;

gen newenglandLY=1 if mig_div==1; label variable newenglandLY "New England last year";
gen midatlanticLY=1 if mig_div==2; label variable midatlanticLY "Mid Atlantic last year";
gen ENcentralLY=1 if mig_div==3; label variable ENcentralLY "East North Central last year";
gen WNcentralLY=1 if mig_div==4; label variable WNcentralLY "West North Central last year";
gen SatlanticLY=1 if mig_div==5; label variable SatlanticLY "South Atlantic last year";
gen EScentralLY=1 if mig_div==6; label variable EScentralLY "East South Central last year";
gen WScentralLY=1 if mig_div==7; label variable WScentralLY "West South Central last year";
gen mountainLY=1 if mig_div==8; label variable mountainLY "Mountain last year";
gen pacificLY=1 if mig_div==9; label variable pacificLY "Pacific last year";

foreach var of varlist newenglandLY-pacificLY {;
	replace `var'=0 if missing(`var') & !missing(mig_div); };

rename hea health;

/*Note: for people who did not move, mig_reg still reports the person's region last year.
Confirm with bro mig_reg hg_reg if mig_same==1*/
gen northeastLY=1 if mig_reg==1 | migsame==2 & grin_reg==1 | migsame==1 & hg_reg==1;
gen midwestLY=1 if mig_reg==2 | migsame==2 & grin_reg==2 | migsame==1 & hg_reg==2;
gen southLY=1 if mig_reg==3 | migsame==2 & grin_reg==3 | migsame==1 & hg_reg==3;
gen westLY=1 if mig_reg==4 | migsame==2 & grin_reg==4 | migsame==1 & hg_reg==4;
drop hg_reg gereg;



foreach var of varlist northeastLY-westLY {; 
	replace `var'=0 if missing(`var') & !missing(mig_reg); 
	label variable `var' "Region last year";
 };

drop mig_reg migsame;

/*Urban-rural variables*/
gen urban=1 if hmsa_r==1 | gtmetsta==1; 
replace urban=0 if missing(urban) & !missing(hmsa_r) | missing(urban) & !missing(gtmetsta);
label variable urban "Current urban status";

gen rural=1 if hmsa_r==2 | gtmetsta==2; 
replace rural=0 if missing(rural) & !missing(hmsa_r) | missing(rural) & !missing(gtmetsta);
label variable rural "Current rural status";

gen urbanLY=urban if migplac==0 | mig_cbst==0 | grn_plac==0; /*Non-movers*/
replace urbanLY=1 if migplac==1 | mig_cbst==1 | grn_plac==1; /*Moved and lived in urban area last year*/
replace urbanLY=0 if missing(urbanLY) & !missing(migplac) | missing(urbanLY) & !missing(mig_cbst) | missing(urbanLY) & !missing(grn_plac);
label variable urbanLY "Last year's urban status";

gen ruralLY=rural if migplac==0 | mig_cbst==0 | grn_plac==0; /*Non-movers*/
replace ruralLY=1 if migplac==2 | mig_cbst==2 | grn_plac==2; /*Moved and rural last year*/
replace ruralLY=0 if missing(ruralLY) & !missing(migplac) | missing(ruralLY) & !missing(mig_cbst) | missing(ruralLY) & !missing(grn_plac);
label variable ruralLY "Last year's rural status";
drop migplac mig_cbst gtmetsta hmsa_r;

/*Nonlabor income variables*/
gen Nidr=fdivval+frntval+fintval;
label variable Nidr "Non labor income - interest, dividends, and rent";
gen Nidr2007dols=Nidr/0.830679413 if year==1999; /*Use the PCE deflator data from FRED*/
replace Nidr2007dols=Nidr/0.654281083 if year==1989;
replace Nidr2007dols=Nidr if year==2007;

gen earnfam=fearnval-pearnval; label variable earnfam "Earnings of family members";

gen Nidrfam=Nidr+earnfam; label variable Nidrfam "Non-labor income - interest, dividends, rent and family earnings";
gen Nidrfam2007dols=Nidrfam/0.830679413 if year==1999;
replace Nidrfam2007dols=Nidrfam/0.654281083  if year==1989;
replace Nidrfam2007dols=Nidrfam if year==2007;

/*Wage variables*/
/*In estimating the wage equation, people are only included in the sample if
	- source of income from longest job last year was wages and salaries (ern_srce==1)
	- longest job last year was not self-employed (ljcw!=5 & ljcw!=6)
	- do not live in group quarters (h_type!=9)
	- did not receive other earnings in the form of farm self-employment (frmotr!=1)
	  or self employment, not incorporated (seotr!=1)*/
	

/*Note: This wage annual variable is equivalent to wsal_val
	  so this creates the dataset without exclusions*/
gen wageannual=ern_val+ws_val if ern_srce==1; 
replace wageannual=ws_val if ern_srce!=1;


/*
/*Creates the dataset with exclusions*/
gen wagesample=1 if ern_srce==1 & ljcw!=6 & ljcw!=5 & h_type!=9 & frmotr!=1 & seotr!=1 & i_ernval!=1 & i_wsval!=1;
replace wagesample=0 if ern_srce!=1 | ljcw==6 | ljcw==5 | h_type==9 | frmotr==1 | seotr==1 | i_ernval==1 | i_wsval==1;
gen wageannual=ern_val+ws_val if wagesample==1;
*/

gen wagewk=wageannual/wkswork; label variable wagewk "Weekly wage last year for workers who are not self-employed";
gen wagehr=wagewk/hrswk; label variable wagehr "Hourly wage last year for workers who are not self employed";

gen wagewk2007dols=wagewk/0.830679413 if year==2000; /*Use the PCE deflator for 1999 with base year 2007*/
replace wagewk2007dols=wagewk/0.654281083  if year==1990;
replace wagewk2007dols=wagewk if year==2008;


gen wagehr2007dols=wagehr/0.830679413 if year==2000; /*Use the PCE deflator for 1999 with base year 2007*/
replace wagehr2007dols=wagehr/0.654281083  if year==1990;
replace wagehr2007dols=wagehr if year==2008;

replace wagehr2007dols=wagehr/0.830679413 if year==1999;
replace wagehr2007dols=wagehr if year==2007;

/*Age variables*/
gen age=.;
replace age=0 if a_age<16;
replace age=1 if a_age>=16 & a_age<25;
replace age=2 if a_age>=25 & a_age<40;
replace age=3 if a_age>=40 & a_age<55;
replace age=4 if a_age>=55 & a_age<65;
replace age=5 if a_age>=65 & a_age<.;

/*Drop the oldest group*/

gen race=.;
replace race=1 if a_race==1 | prdtrace==1;
replace race=2 if a_race==2 | prdtrace==2;
replace race=3 if missing(race) & !missing(a_race) | missing(race) & !missing(prdtrace);

gen edu=.;
replace edu=1 if a_hga>0 & a_hga<39 & year>1990;
replace edu=2 if a_hga==39  & year>1990;
replace edu=3 if a_hga>39 & a_hga<43  & year>1990;
replace edu=4 if a_hga==43  & year>1990;
replace edu=5 if a_hga>43 & a_hga<.  & year>1990;

replace edu=1 if schl1<6;
replace edu=2 if schl1==6;
replace edu=3 if schl1==7;
replace edu=4 if schl1==8;
replace edu=5 if schl1>8 & !missing(schl1);


drop a_race a_hga prdtrace;
label drop _all;

label define health 
	1 "Excellent"
	2 "Very good"
	3 "Good"
	4 "Fair"
	5 "Poor";
label values health health;

gen healthexcellent=1 if health ==1;
gen healthvg=1 if health==2;
gen healthgood=1 if health==3;
gen healthfair=1 if health==4;
gen healthpoor=1 if health==5;

foreach var of varlist healthexcellent-healthpoor {;
	replace `var'=0 if missing(`var') & !missing(health); };

	
label define a_lfsr 
	0 "Children or Armed Forces"
	1 "Working"
	2 "With job,not at work"
	3 "Unemployed, looking for work"
	4 "Unemployed, on layoff"
	5 "NILF - working w/o pay less"
	6 "NILF - unavailable"
	7 "Other NILF";
label values a_lfsr a_lfsr;

label define race
	1 "White"
	2 "Black"
	3 "Other";
label values race race;

/*Dummies for each race*/
gen white=1 if race==1;
gen black=1 if race==2;
gen other=1 if race==3;
foreach var of varlist white-other {; replace `var'=0 if missing(`var') & !missing(race); };

label define edu
	1 "< high school"
	2 "high school"
	3 "some college"
	4 "college"
	5 "college +";
label values edu edu;

/*Create the dummy variables for each education level*/
gen lessHS=1 if edu==1;
gen HS=1 if edu==2;
gen SC=1 if edu==3;
gen Col=1 if edu==4 | edu==5;
foreach var of varlist lessHS-Col {; replace `var'=0 if missing(`var') & !missing(edu); };

label define age
	0 "<16"
	1 "16-24"
	2 "25-39"
	3 "40-54"
	4 "55-64"
	5 "65+";
label values age age;

gen age16to24=1 if age==1;
gen age25to39=1 if age==2;
gen age40to54=1 if age==3;
gen age55to64=1 if age==4;
gen age65plus=1 if age==5;
foreach var of varlist age16to24-age65plus {; replace `var'=0 if missing(`var') & !missing(age); };

label define sex
	1 "Male"
	2 "Female";
label values sex sex;

gen employed=1 if a_lfsr==1 | a_lfsr==2;
replace employed=0 if missing(employed) & !missing(a_lfsr);

gen unemployed=1 if a_lfsr==3 | a_lfsr==4;
replace unemployed=0 if missing(unemployed) & !missing(a_lfsr);

gen lfp=1 if employed==1 | unemployed==1;
replace lfp=0 if unemployed==0 & employed==0;
label variable lfp "Labor force participant";


/*Drop children and members of the armed forces*/
drop if age==0;
drop if a_lfsr==0;


save "C:\Users\Nicole\Desktop\Labor Supply RA\CPS extracts\MarchCPS\Regressions\Organize Data\dataforlaborsupply_noexclus.dta", replace;

