capture log close
prog drop _all
set more off
set trace off
pause on
#delimit ;
clear;

global date 120923;
global model "3H2B_NoSelect_AW";
global dir "D:\RA\Moffitt\Nicole_LS\091712";
capture log using $dir\Lu\men_${model}_${date}.log, replace;
use $dir\Data\dataforlaborsupply_noexclus.dta;

recode edu (5=4);

gen Nid=fdivval+fintval;
gen Nid2007dols=Nid/0.830679413 if year==1999;
replace Nid2007dols=Nid/0.654281083 if year==1989;
replace Nid2007dols=Nid if year==2007;

gen Nidfam=Nid+earnfam;
gen Nidfam2007dols=Nidfam/0.830679413 if year==1999;
replace Nidfam2007dols=Nidfam/0.654281083 if year==1989;
replace Nidfam2007dols=Nidfam if year==2007;

replace Nid2007dols=0 if Nid2007dols<0;
replace Nidfam2007dols=0 if Nidfam2007dols<0;

/*
replace Nid2007dols=Nid2007dols/52+10;
replace Nidfam2007dols=Nidfam2007dols/52+10;
*/

replace Nid2007dols=Nid2007dols/1000;
replace Nidfam2007dols=Nidfam2007dols/1000;
/*
gen Nid0=1 if Nid2007dols==0;
replace Nid0=0 if Nid2007dols!=0;

gen Nidfam0=1 if Nidfam2007dols==0;
replace Nidfam0=0 if Nidfam2007dols!=0;

gen lnNid=log(Nid2007dols) if Nid2007dols!=0;
replace lnNid=0 if Nid2007dols==0;

gen lnNidfam=log(Nidfam2007dols) if Nidfam2007dols!=0;
replace lnNidfam=0 if Nidfam2007dols==0;
*/
gen kids=1 if kidsunder6!=0 |kids6to18!=0;
gen singleparent=1 if kids==1 & married==0;
replace singleparent=0 if singleparent==.;

gen wagesample=1 if ern_srce==1 & ljcw!=6 & ljcw!=5 & h_type!=9 & frmotr!=1 & seotr!=1 & i_ernval!=1 & i_wsval!=1 /*& hrswk>=35 & hrswk<. & wkswork>=40 & wkswork<=.*/;
replace wagesample=0 if ern_srce!=1 | ljcw==6 | ljcw==5 | h_type==9 | frmotr==1 | seotr==1 | i_ernval==1 | i_wsval==1 /*| hrswk<35 | wkswork<40*/;

/*===============================================================*/
/**************First, run it exactly like Lu did*****************/
/*==============================================================*/
keep if sex==1; /*Keep only men*/
drop if age==5; /*Eliminate 65+*/
drop if a_lfsr==0; /*Eliminate members of armed force*/
drop if a_fnlwgt==0;

gen lnwagewk=log(wagewk2007dols) if wagesample==1; /*Apply the exclusions*/
gen lnwagehr=log(wagehr2007dols) if wagesample==1;

/*Create crossed age-education dummies*/
qui gen age16to24lessHS=age16to24*lessHS;
qui gen age16to24HS=age16to24*HS;
qui gen age16to24SC=age16to24*SC;
qui gen age16to24Col=age16to24*Col;
qui gen age25to39lessHS=age25to39*lessHS;
qui gen age25to39HS=age25to39*HS;
qui gen age25to39SC=age25to39*SC;
qui gen age25to39Col=age25to39*Col;
qui gen age40to54lessHS=age40to54*lessHS;
qui gen age40to54HS=age40to54*HS;
qui gen age40to54SC=age40to54*SC;
qui gen age40to54Col=age40to54*Col;
qui gen age55to64lessHS=age55to64*lessHS;
qui gen age55to64HS=age55to64*HS;
qui gen age55to64SC=age55to64*SC;
qui gen age55to64Col=age55to64*Col;

foreach xx of varlist age16to24lessHS-age55to64Col{;
              qui gen `xx'white=`xx'*white;
              qui gen `xx'black=`xx'*black;
		  qui gen `xx'other=`xx'*other;
              };



/*Trim the wages to exclude outliers - 5% on each side*/
egen lnwagewk_95pct=pctile(lnwagewk) if year==1990, p(95);
egen lnwagewk_5pct=pctile(lnwagewk) if year==1990, p(5);
gen lnwagewk_trim=lnwagewk
	if year==1990 & lnwagewk <=lnwagewk_95pct 
	& lnwagewk>=lnwagewk_5pct;

/*weekly wage regression for 1989*/
reg lnwagewk_trim age16to24lessHSwhite-age55to64Colblack [pweight=marsupwt]
	       if year==1990;
eststo wagewkM89; /*Store the estimates*/
predict lnwagewkPredict89 if year==1989; /*Find the fitted values for use in the EPOP regression*/
gen lnwagewkPredict=lnwagewkPredict89 if year==1989;
drop lnwagewk_95pct lnwagewk_5pct;

/*Trim the wages to exclude outliers - 5% on each side*/
egen lnwagewk_95pct=pctile(lnwagewk) if year==2000, p(95);
egen lnwagewk_5pct=pctile(lnwagewk) if year==2000, p(5);
replace lnwagewk_trim=lnwagewk
	if year==2000 & lnwagewk <=lnwagewk_95pct 
	& lnwagewk>=lnwagewk_5pct;

/*weekly wage regression for 1999*/
reg lnwagewk_trim age16to24lessHSwhite-age55to64Colblack [pweight=marsupwt]
	       if year==2000;
eststo wagewkM99; /*Store the estimates*/
predict lnwagewkPredict99 if year==1999; /*Find the fitted values for use in the EPOP regression*/
replace lnwagewkPredict=lnwagewkPredict99 if year==1999;
drop lnwagewk_95pct lnwagewk_5pct;

/*Trim outliers - 5% each side*/
egen lnwagewk_95pct=pctile(lnwagewk) if year==2008, p(95);
egen lnwagewk_5pct=pctile(lnwagewk) if year==2008, p(5);
replace lnwagewk_trim=lnwagewk
	if year==2008 & lnwagewk <=lnwagewk_95pct 
	& lnwagewk>=lnwagewk_5pct;

/*weekly wage regression for 2007*/
reg lnwagewk_trim age16to24lessHSwhite-age55to64Colblack [pweight=marsupwt]
	     if year==2008;
eststo wagewkM07;
predict lnwagewkPredict07 if year==2007;
replace lnwagewkPredict=lnwagewkPredict07 if year==2007;
drop lnwagewk_95pct lnwagewk_5pct;

preserve;
qui gen lnwagewk1989=lnwagewk if year==1990;
qui gen lnwagewk1999=lnwagewk if year==2000;
qui gen lnwagewk2007=lnwagewk if year==2008;

qui gen lnwagewk_trim1989=lnwagewk_trim if year==1990;
qui gen lnwagewk_trim1999=lnwagewk_trim if year==2000;
qui gen lnwagewk_trim2007=lnwagewk_trim if year==2008;
collapse (mean) lnwagewk1989-lnwagewk2007 lnwagewk_trim1989-lnwagewk_trim2007 lnwagewkPredict89-lnwagewkPredict07 [pweight=a_fnlwgt], by(edu age);

qui gen diflnwagewk99to89=lnwagewk1999-lnwagewk1989;
qui gen diflnwagewk07to99=lnwagewk2007-lnwagewk1999;

qui gen diflnwagewk_trim99to89=lnwagewk_trim1999-lnwagewk_trim1989;
qui gen diflnwagewk_trim07to99=lnwagewk_trim2007-lnwagewk_trim1999;

qui gen diflnwagewkPredict99to89=lnwagewkPredict99-lnwagewkPredict89;
qui gen diflnwagewkPredict07to99=lnwagewkPredict07-lnwagewkPredict99;

drop lnwagewk1989-lnwagewk2007 lnwagewk_trim1989-lnwagewk_trim2007 lnwagewkPredict89-lnwagewkPredict07;
outsheet using "$dir\Lu\TablewageMen89to07.xls", replace;

restore;

/*Trim outliers - 5% each side*/
egen lnwagehr_95pct=pctile(lnwagehr) if year==1990, p(95);
egen lnwagehr_5pct=pctile(lnwagehr) if year==1990, p(5);
gen lnwagehr_trim=lnwagehr
	if year==1990 & lnwagehr <=lnwagehr_95pct 
	& lnwagehr>=lnwagehr_5pct;

/*hourly wage regression for 1999*/
reg lnwagehr_trim age16to24lessHSwhite-age55to64Colblack [pweight=marsupwt]
	       if year==1990;
eststo wagehrM89; /*Store the estimates*/
predict lnwagehrPredict89 if year==1989; /*Find the fitted values for use in the EPOP regression*/
gen lnwagehrPredict=lnwagehrPredict89 if year==1989;
drop lnwagehr_trim lnwagehr_95pct lnwagehr_5pct;

/*Trim outliers - 5% each side*/
egen lnwagehr_95pct=pctile(lnwagehr) if year==2000, p(95);
egen lnwagehr_5pct=pctile(lnwagehr) if year==2000, p(5);
gen lnwagehr_trim=lnwagehr
	if year==2000 & lnwagehr <=lnwagehr_95pct 
	& lnwagehr>=lnwagehr_5pct;

/*hourly wage regression for 1999*/
reg lnwagehr_trim age16to24lessHSwhite-age55to64Colblack [pweight=marsupwt]
	       if year==2000;
eststo wagehrM99; /*Store the estimates*/
predict lnwagehrPredict99 if year==1999; /*Find the fitted values for use in the EPOP regression*/
replace lnwagehrPredict=lnwagehrPredict99 if year==1999;
drop lnwagehr_trim lnwagehr_95pct lnwagehr_5pct;


/*Trim outliers - 5% each side*/
egen lnwagehr_95pct=pctile(lnwagehr) if year==2008, p(95);
egen lnwagehr_5pct=pctile(lnwagehr) if year==2008, p(5);
gen lnwagehr_trim=lnwagehr
	if year==2008 & lnwagehr <=lnwagehr_95pct 
	& lnwagehr>=lnwagehr_5pct;

/*hourly wage regression for 2007*/
reg lnwagehr_trim age16to24lessHSwhite-age55to64Colblack [pweight=marsupwt]
	     if year==2008;
eststo wagehrM07;
predict lnwagehrPredict07 if year==2007;
replace lnwagehrPredict=lnwagehrPredict07 if year==2007;
drop lnwagehr_trim lnwagehr_95pct lnwagehr_5pct;

/*EPOP regression using weekly wages - Nid*/
reg employed lnwagewkPredict Nid2007dols kidsunder6 kids6to18 married divwidsep headhh singleparent /*lnNid_sqr*/ age16to24lessHSwhite-age55to64Colblack [pweight=a_fnlwgt]
	if year==1989 | year==1999 | year==2007;
eststo Mwk_Nid;
predict empPredictMwk_Nid if year==1989 | year==1999 | year==2007;

/*EPOP regression using weekly wages - Nidfam*/
reg employed lnwagewkPredict Nidfam2007dols kidsunder6 kids6to18 married divwidsep headhh singleparent /*lnNidfam_sqr*/ age16to24lessHSwhite-age55to64Colblack [pweight=a_fnlwgt]
	if year==1989 | year==1999 | year==2007;
eststo Mwk_Nidfam;
predict empPredictMwk_Nidfam if year==1989 | year==1999 | year==2007;


/*EPOP regression using hourly wages - Nid*/
reg employed lnwagehrPredict Nid2007dols kidsunder6 kids6to18 married divwidsep headhh singleparent /*lnNid_sqr*/ age16to24lessHSwhite-age55to64Colblack [pweight=a_fnlwgt]
	if year==1989 | year==1999 | year==2007;
eststo Mhr_Nid;
predict empPredictMhr_Nid if year==1989 | year==1999 | year==2007;

/*EPOP regression using hourly wages - Nidfam*/
reg employed lnwagehrPredict Nidfam2007dols kidsunder6 kids6to18 married divwidsep headhh singleparent /*lnNidfam_sqr*/ age16to24lessHSwhite-age55to64Colblack [pweight=a_fnlwgt]
	if year==1989 | year==1999 | year==2007;
eststo Mhr_Nidfam;
predict empPredictMhr_Nidfam if year==1989 | year==1999 | year==2007;

/*Export the regression results*/
esttab wagewkM89 wagewkM99 wagewkM07 
using "$dir\Lu\MenWeeklyWages89to07.tex", b(%9.4f) se nostar wide replace
title("Weekly wage Regression Results for Men, with exclusions and weights")
mtitles("Weekly wage, 1989" "Weekly wage, 1999" "Weekly wage, 2007");

esttab wagehrM89 wagehrM99 wagehrM07 
using "$dir\Lu\MenHourlyWages89to07.tex", b(%9.4f) se nostar wide replace
title("Hourly wage Regression Results for Men, with exclusions and weights")
mtitles("Hourly wage, 1989" "Hourly wage, 1999" "Hourly wage, 2007");

esttab Mwk_Nid Mwk_Nidfam Mhr_Nid Mhr_Nidfam
using "$dir\Lu\MenEPOP89to07.tex", b(%9.4f) se nostar wide replace
title("EPOP Regression Results for Men, with exclusions and weights")
mtitles("Weekly wage, Nid" "Weekly wage, Nidfam" "Hourly wage - Nid" "Hourly wage - Nidfam");

foreach var of varlist employed empPredictMwk_Nid empPredictMhr_Nid 
					empPredictMwk_Nidfam empPredictMhr_Nidfam 
					{;
gen `var'1989=`var' if year==1989;
gen `var'1999=`var' if year==1999;
gen `var'2007=`var' if year==2007;
};


preserve;
keep if year==1989 | year==1999 | year==2007;
collapse (mean) employed2007 employed1999 employed1989  empPredictMwk_Nid1989-empPredictMhr_Nidfam2007 [pweight=a_fnlwgt];

gen difemp99to89=employed1999-employed1989;
gen difMwk_Nid99to89=empPredictMwk_Nid1999-empPredictMwk_Nid1989;
gen difMwk_Nidfam99to89=empPredictMwk_Nidfam1999-empPredictMwk_Nidfam1989;
gen difMhr_Nid99to89=empPredictMhr_Nid1999-empPredictMhr_Nid1989;
gen difMhr_Nidfam99to89=empPredictMhr_Nidfam1999-empPredictMhr_Nidfam1989;

gen difemp07to99=employed2007-employed1999;
gen difMwk_Nid07to99=empPredictMwk_Nid2007-empPredictMwk_Nid1999;
gen difMwk_Nidfam07to99=empPredictMwk_Nidfam2007-empPredictMwk_Nidfam1999;
gen difMhr_Nid07to99=empPredictMhr_Nid2007-empPredictMhr_Nid1999;
gen difMhr_Nidfam07to99=empPredictMhr_Nidfam2007-empPredictMhr_Nidfam1999;

keep difemp99to89-difMhr_Nidfam07to99;
outsheet using "$dir\Lu\MenEPOP89to07.xls", replace;

restore; preserve;
keep if year==1989 | year==1999 | year==2007;
collapse (mean) empPredictMwk_Nid1989-empPredictMhr_Nidfam2007 [pweight=a_fnlwgt], by(sex edu age);

gen difMwk_Nid99to89=empPredictMwk_Nid1999-empPredictMwk_Nid1989;
gen difMwk_Nidfam99to89=empPredictMwk_Nidfam1999-empPredictMwk_Nidfam1989;
gen difMhr_Nid99to89=empPredictMhr_Nid1999-empPredictMhr_Nid1989;
gen difMhr_Nidfam99to89=empPredictMhr_Nidfam1999-empPredictMhr_Nidfam1989;

gen difMwk_Nid07to99=empPredictMwk_Nid2007-empPredictMwk_Nid1999;
gen difMwk_Nidfam07to99=empPredictMwk_Nidfam2007-empPredictMwk_Nidfam1999;
gen difMhr_Nid07to99=empPredictMhr_Nid2007-empPredictMhr_Nid1999;
gen difMhr_Nidfam07to99=empPredictMhr_Nidfam2007-empPredictMhr_Nidfam1999;

sort sex edu age;
keep sex edu age difMwk_Nid99to89-difMhr_Nidfam07to99;
outsheet using "$dir\Lu\Table1EPOPMen89to07.xls", replace;

restore; preserve;
keep if year==1989 | year==1999 | year==2007;
collapse (mean) empPredictMwk_Nid1989-empPredictMhr_Nidfam2007  [pweight=a_fnlwgt],  by(age edu sex race);

gen difMwk_Nid99to89=empPredictMwk_Nid1999-empPredictMwk_Nid1989;
gen difMwk_Nidfam99to89=empPredictMwk_Nidfam1999-empPredictMwk_Nidfam1989;
gen difMhr_Nid99to89=empPredictMhr_Nid1999-empPredictMhr_Nid1989;
gen difMhr_Nidfam99to89=empPredictMhr_Nidfam1999-empPredictMhr_Nidfam1989;

gen difMwk_Nid07to99=empPredictMwk_Nid2007-empPredictMwk_Nid1999;
gen difMwk_Nidfam07to99=empPredictMwk_Nidfam2007-empPredictMwk_Nidfam1999;
gen difMhr_Nid07to99=empPredictMhr_Nid2007-empPredictMhr_Nid1999;
gen difMhr_Nidfam07to99=empPredictMhr_Nidfam2007-empPredictMhr_Nidfam1999;

sort race sex edu age;
keep race sex edu age difMwk_Nid99to89-difMhr_Nidfam07to99;

outsheet using "$dir\Lu\Table2EPOPMen89to07.xls", replace;
restore; preserve;


/*
/*Decomposition*/
restore; preserve;
keep if year==1989 | year==1999 | year==2007;
collapse (mean) lnwagewkPredict lnNid Nid0 lnNidfam Nidfam0 kidsunder6 kids6to18 married divwidsep headhh singleparent age16to24lessHSwhite-age55to64Colblack, by(year);
outsheet using "C:\Users\Nicole\Desktop\Labor Supply RA\CPS extracts\MarchCPS\Regressions\Results\NoWgtMeansMen3H2_89to07.xls", replace;

restore; preserve;
keep if year==1989 | year==1999 | year==2007;
collapse (mean) lnwagewkPredict lnNid Nid0 lnNidfam Nidfam0 kidsunder6 kids6to18 married divwidsep headhh singleparent age16to24lessHSwhite-age55to64Colblack [pweight=a_fnlwgt], by(year);
outsheet using "C:\Users\Nicole\Desktop\Labor Supply RA\CPS extracts\MarchCPS\Regressions\Results\WgtMeansMen3H2_89to07.xls", replace;

restore; preserve;
keep if _n==1;
keep wkNid1-wkNid57 wkNidfam1-wkNidfam57;
outsheet using "C:\Users\Nicole\Desktop\Labor Supply RA\CPS extracts\MarchCPS\Regressions\Results\betasMen3H2_89to07.xls", replace;
*/
log close;
