***************************************************************************************
11/5/2010:  ADDED SURVEY YEAR 2010
			
12/21/2010:  RE-RAN 2010 WITH STATE, B/C 2009 STATE TAX DATA NOW AVAILABLE IN TAXSIM

10/19/2011:  ADDED 2011 SY DATA (NOTE STATE NOT AVAIL. IN TAXSIM FOR 2010 REF YEAR, SO 
			 HAVE FILL FOR STATE IN OUTPUT FILE

12/20/2012:  ADDED SURVEY YEAR 2012

***************************************************************************************;

filename out1988 'N:\Private\Poverty Trends\SAS\cps\output\taxsim1988.txt';
filename out1989 'N:\Private\Poverty Trends\SAS\cps\output\taxsim1989.txt';
filename out1990 'N:\Private\Poverty Trends\SAS\cps\output\taxsim1990.txt';
filename out1991 'N:\Private\Poverty Trends\SAS\cps\output\taxsim1991.txt';
filename out1992 'N:\Private\Poverty Trends\SAS\cps\output\taxsim1992.txt';
filename out1993 'N:\Private\Poverty Trends\SAS\cps\output\taxsim1993.txt';
filename out1994 'N:\Private\Poverty Trends\SAS\cps\output\taxsim1994.txt';
filename out1995 'N:\Private\Poverty Trends\SAS\cps\output\taxsim1995.txt';
filename out1996 'N:\Private\Poverty Trends\SAS\cps\output\taxsim1996.txt';
filename out1997 'N:\Private\Poverty Trends\SAS\cps\output\taxsim1997.txt';
filename out1998 'N:\Private\Poverty Trends\SAS\cps\output\taxsim1998.txt';
filename out1999 'N:\Private\Poverty Trends\SAS\cps\output\taxsim1999.txt';
filename out2000 'N:\Private\Poverty Trends\SAS\cps\output\taxsim2000.txt';
filename out2001 'N:\Private\Poverty Trends\SAS\cps\output\taxsim2001.txt';
filename out2002 'N:\Private\Poverty Trends\SAS\cps\output\taxsim2002.txt';
filename out2003 'N:\Private\Poverty Trends\SAS\cps\output\taxsim2003.txt';
filename out2004 'N:\Private\Poverty Trends\SAS\cps\output\taxsim2004.txt';
filename out2005 'N:\Private\Poverty Trends\SAS\cps\output\taxsim2005.txt';
filename out2006 'N:\Private\Poverty Trends\SAS\cps\output\taxsim2006.txt';
filename out2007 'N:\Private\Poverty Trends\SAS\cps\output\taxsim2007.txt';
filename out2008 'N:\Private\Poverty Trends\SAS\cps\output\taxsim2008.txt';
filename out2009 'N:\Private\Poverty Trends\SAS\cps\output\taxsim2009.txt';
filename out2010 'N:\Private\Poverty Trends\SAS\cps\output\taxsim2010.txt';
filename out2011 'N:\Private\Poverty Trends\SAS\cps\output\taxsim2011.txt';
filename out2012 'N:\Private\Poverty Trends\SAS\cps\output\taxsim2012.txt';


%macro read(surv_yr);

data taxsim&surv_yr;
set cpsdata.all&surv_yr;

/*NOTE: ASSUMING THAT ALL RELATED AND UNRELATED SUBFAMILIES FILE AS SEPARATE FILING UNITS */

/* This is the value for the gross income test for dependents.  It is the same
   as the personal exemption.  
   See data N:data\tax\tax_parameters_taxpolicycenter.org.xls
   The parameters are for the tax year--the year preceding the survey year.  For 
   example, $3700 is the personal examption for tax year 2011.  
*/
	
	IF &surv_yr=1988 THEN inc_test=1900; 
	ELSE IF &surv_yr=1989 THEN inc_test=1950; 
	ELSE IF &surv_yr=1990 THEN inc_test=2000;
	ELSE IF &surv_yr=1991 THEN inc_test=2050;
	ELSE IF &surv_yr=1992 THEN inc_test=2150;
	ELSE IF &surv_yr=1993 THEN inc_test=2300; 
	ELSE IF &surv_yr=1994 THEN inc_test=2350; 
	ELSE IF &surv_yr=1995 THEN inc_test=2450; 
	ELSE IF &surv_yr=1996 THEN inc_test=2500; 
	ELSE IF &surv_yr=1997 THEN inc_test=2550; 
	ELSE IF &surv_yr=1998 THEN inc_test=2650; 
	ELSE IF &surv_yr=1999 THEN inc_test=2700; 
	ELSE IF &surv_yr=2000 THEN inc_test=2750; 
	ELSE IF &surv_yr=2001 THEN inc_test=2800; 
	ELSE IF &surv_yr=2002 THEN inc_test=2900; 
	ELSE IF &surv_yr=2003 THEN inc_test=3000; 
	ELSE IF &surv_yr=2004 THEN inc_test=3050; 
	ELSE IF &surv_yr=2005 THEN inc_test=3100; 
	ELSE IF &surv_yr=2006 THEN inc_test=3200; 
	ELSE IF &surv_yr=2007 THEN inc_test=3300; 
	ELSE IF &surv_yr=2008 THEN inc_test=3400;
	ELSE IF &surv_yr=2009 THEN inc_test=3500; 
	ELSE IF &surv_yr=2010 THEN inc_test=3650; 
	ELSE IF &surv_yr=2011 THEN inc_test=3650; 
	ELSE IF &surv_yr=2012 THEN inc_test=3700; 
	ELSE IF &surv_yr=2013 THEN inc_test=3800; 

* Creat dependents var, including both children and non-working unmarried relatives;
IF (3 LE famrel2 LE 9) 
			/* don't work at all or work little because you go to school */
			AND (rsnnotw NE 0 OR (wkswrk LE 13 AND rsnnotl=3)) 
			AND marstat GE 4 
			AND ptotinc LT inc_test 
			THEN dep=1;

* allow married non-working children 19-23 to be dependents;
ELSE IF (3 LE famrel2 LE 9) AND 19 LE age LE 23 
			/* don't work at all or work little because you go to school */
			AND (rsnnotw NE 0 OR (wkswrk LE 13 AND rsnnotl=3)) THEN dep=1;

* allow all children under 19 to be dependents;
ELSE IF (3 LE famrel2 LE 9) AND age LE 18 THEN dep=1;
ELSE dep=0;

* calc num of kids for fed child tax credit;
IF (3 LE famrel2 LE 9) AND age LE 16 THEN kids3=1;
ELSE kids3=0;

* calc num of eitc kids;
IF (3 LE famrel2 LE 9) AND age LE 18 THEN kids2=1;
ELSE IF (3 LE famrel2 LE 9) AND 19 LE age LE 23 
			AND (rsnnotw IN(1,4) OR (wkswrk LE 13 AND rsnnotl IN(1,3))) THEN kids2=1;
ELSE kids2=0;

* calc num of taxpayers over 65;
IF age GT 65 AND dep=0 THEN gt65=1;
ELSE gt65=0;


/* NEW CODE, ADDED PART WITH FAMREL=2 */
IF (famrel2=2 OR famrel=2) THEN wife_inc=ptotearn;
ELSE wife_inc=0;
/* NEW CODE: EXCLUDE HEAD AND SPOUSES IN RELATED SUBFAMILIES FROM BEING DEPENDENTS OR KIDS
   FAMREL IN (1,2) IS ALL FAMILY HEADS AND SPOUSES REGARDLESS OF FAMILY TYPE */
IF famrel IN (1,2) THEN dep=0;
IF famrel IN (1,2) THEN kids3=0;
IF famrel IN (1,2) THEN kids2=0;

run;

proc sort data=taxsim&surv_yr;
by famid;
run;

proc means data=taxsim&surv_yr sum noprint;
by famid;
* restrict to husbands, wives, and their dependents;
where ftype NE 3 AND (famrel2 IN(1,2) OR dep=1);	
var dep kids2 kids3 wife_inc gt65 ssinc intinc divinc uiinc retinc alimony ptotearn;
output out=temp1 sum=totdep kid_eitc kid_fcc tfu_wifi tfu_gt65 tfu_ss tfu_int 
					 tfu_div tfu_ui tfu_ret tfu_alm tfu_earn;
run;


/* NEW CODE: ALLOW RELATED SUBFAMILIES TO BE SEPARATE FILERS */
proc means data=taxsim&surv_yr sum noprint;
by famid;
* restrict to husbands, wives, and their dependents;
where ftype=3 AND (famrel IN(1,2) OR dep=1);	
var dep kids2 kids3 wife_inc gt65 ssinc intinc divinc uiinc retinc alimony ptotearn;
output out=temp2 sum=totdep kid_eitc kid_fcc tfu_wifi tfu_gt65 tfu_ss tfu_int 
					 tfu_div tfu_ui tfu_ret tfu_alm tfu_earn;
run;


data cpsdata.taxsim&surv_yr;
merge taxsim&surv_yr(IN=in1) temp1(KEEP=famid totdep kid_eitc kid_fcc tfu_wifi tfu_gt65 tfu_ss tfu_int 
					            tfu_div tfu_ui tfu_ret tfu_alm tfu_earn)
							/* NEW CODE */
							 temp2(KEEP=famid totdep kid_eitc kid_fcc tfu_wifi tfu_gt65 tfu_ss tfu_int 
					            tfu_div tfu_ui tfu_ret tfu_alm tfu_earn);
by famid;
if in1;

* Restrict sample to heads of tax filing unit;
* Delete spouses;
IF famrel2=2 THEN DELETE;

/* NEW CODE: DELETE SPOUSES IN RELATED AND UNRELATED SUBFAMILIES */
IF famrel=2 THEN DELETE;


* Delete dependents;
IF dep=0;

     ARRAY tax_vars totdep kid_eitc kid_fcc tfu_wifi tfu_gt65 tfu_ss tfu_int 
					            tfu_div tfu_ui tfu_ret tfu_alm tfu_earn;
	 DO OVER tax_vars;
	 IF tax_vars=. THEN tax_vars=0;
	 END; 

*adjustments for taxsim;
tfu_wifi=MAX(tfu_wifi,0);
totdep=MIN(totdep,15);
kid_eitc=MIN(kid_eitc,15);
kid_fcc=MIN(kid_fcc,15);

/* NEW CODE: ADDED FAMREL=1 TO EACH OF THE BELOW*/
IF famrel2=1 OR famrel=1 THEN taxinc=tfu_earn-tfu_wifi;
ELSE taxinc=ptotearn;
taxinc=MAX(taxinc,0);

/* NEW CODE: RECODE THE INDEPENDENT CHILDREN (WHO ARE THEIR OWN TAX FILING UNIT) TO HAVE NO SPOUSAL INCOME, DEPENDENTS, ETC */
IF famrel2 NE 1 AND famrel NE 1 THEN tfu_wifi=0;
IF famrel2 NE 1 AND famrel NE 1 THEN totdep=0;
IF famrel2 NE 1 AND famrel NE 1 THEN kid_fcc=0;
IF famrel2 NE 1 AND famrel NE 1 THEN kid_eitc=0;

IF famrel2=1 OR famrel=1 THEN inc9=tfu_div;
ELSE inc9=divinc;
inc9=MAX(inc9,0);

IF famrel2=1 OR famrel=1 THEN inc10=tfu_int;
ELSE inc10=intinc;

IF famrel2=1 OR famrel=1 THEN inc11=tfu_ret;
ELSE inc11=retinc;

IF famrel2=1 OR famrel=1 THEN inc12=tfu_ss;
ELSE inc12=ssinc;

IF famrel2=1 OR famrel=1 THEN inc18=tfu_ui;
ELSE inc18=uiinc;

IF famrel2=1 OR famrel=1 THEN num_gt65=tfu_gt65;
ELSE num_gt65=gt65;

id=pseq*100+ppos;

IF marstat IN(1,2,3) THEN filestat=2;
   ELSE IF totdep GT 0 AND marstat GT 3 THEN filestat=3;
   ELSE filestat=1;

***********************************************************
Recode from CPS state id to the SOI state id used by taxsim
***********************************************************;
IF state2=11 THEN state=20;
IF state2=12 THEN state=30;
IF state2=13 THEN state=46;
IF state2=14 THEN state=22;
IF state2=15 THEN state=40;
IF state2=16 THEN state=7;
IF state2=21 THEN state=33;
IF state2=22 THEN state=31;
IF state2=23 THEN state=39;
IF state2=31 THEN state=36;
IF state2=32 THEN state=15;
IF state2=33 THEN state=14;
IF state2=34 THEN state=23;
IF state2=35 THEN state=50;
IF state2=41 THEN state=24;
IF state2=42 THEN state=16;
IF state2=43 THEN state=26;
IF state2=44 THEN state=35;
IF state2=45 THEN state=42;
IF state2=46 THEN state=28;
IF state2=47 THEN state=17;
IF state2=51 THEN state=8;
IF state2=52 THEN state=21;
IF state2=53 THEN state=9;
IF state2=54 THEN state=47;
IF state2=55 THEN state=49;
IF state2=56 THEN state=34;
IF state2=57 THEN state=41;
IF state2=58 THEN state=11;
IF state2=59 THEN state=10;
IF state2=61 THEN state=18;
IF state2=62 THEN state=43;
IF state2=63 THEN state=1;
IF state2=64 THEN state=25;
IF state2=71 THEN state=4;
IF state2=72 THEN state=19;
IF state2=73 THEN state=37;
IF state2=74 THEN state=44;
IF state2=81 THEN state=27;
IF state2=82 THEN state=13;
IF state2=83 THEN state=51;
IF state2=84 THEN state=6;
IF state2=85 THEN state=32;
IF state2=86 THEN state=3;
IF state2=87 THEN state=45;
IF state2=88 THEN state=29;
IF state2=91 THEN state=48;
IF state2=92 THEN state=38;
IF state2=93 THEN state=5;
IF state2=94 THEN state=2;
IF state2=95 THEN state=12;


fill=0;


KEEP id ref_year state filestat totdep num_gt65 taxinc tfu_wifi
   inc9 inc10 inc11 inc12 fill inc18 kid_fcc kid_eitc inc_test;

PROC MEANS;
RUN;

/*
DATA _NULL_;
   SET cpsdata.taxsim&surv_yr;
   FILE out&surv_yr lrecl=500;
   PUT id ref_year state filestat totdep num_gt65 taxinc tfu_wifi
   inc9 inc10 inc11 inc12 fill fill fill fill fill inc18 kid_fcc fill fill fill;
RUN;
*/

%mend read;

%read(1988);
%read(1989);
%read(1990);
%read(1991);
%read(1992);
%read(1993);
%read(1994);
%read(1995);
%read(1996);
%read(1997);
%read(1998);
%read(1999);
%read(2000);
%read(2001);
%read(2002);
%read(2003);
%read(2004);
%read(2005);
%read(2006);
%read(2007);
%read(2008);
%read(2009);
%read(2010);
%read(2011);
%read(2012);







****************************************************************
 FTP MAINDAT TO TAXSIM (http://www.nber.org/~taxsim/taxsim-ftp)
 NOTE SURE IF THIS WILL WORK 
****************************************************************;

%let DATAFILE = %SUBSTR(&SYSTIME,1,2)%SUBSTR(&SYSTIME,4,2);
%PUT 'Filename on taxsimftp server is:' &DATAFILE;

filename txpydata ftp "&DATAFILE"         host='taxsimftp.nber.org'
         user='taxsim' pass='02138' cd='tmp' /*debug*/;
filename results  ftp "&DATAFILE..taxsim" host='taxsimftp.nber.org'
         user='taxsim' pass='02138' cd='tmp' /*debug*/ lrecl=1024;
filename errors   ftp "&DATAFILE..msg" host='taxsimftp.nber.org'
         user='taxsim' pass='02138' cd='tmp' /*debug*/;


%macro create_dat(yr);

data;
set cpsdata.taxsim&yr;
file txpydata;
put id ref_year state filestat totdep num_gt65 taxinc tfu_wifi
   inc9 inc10 inc11 inc12 fill fill fill fill fill inc18 kid_fcc fill fill fill;
run;

/* Read results directly from taxsimftp server. */

DATA ts_all;
	INFILE results;
	INPUT id year ts_state ftl stl ts_fica;
RUN;

PROC MEANS DATA=ts_all;
RUN;

DATA taxsim.taxs&yr;
   SET ts_all;
RUN;
PROC SORT data=taxsim.taxs&yr;
BY id;
RUN;

%mend create_dat;

%create_dat(1988);
%create_dat(1989);
%create_dat(1990);
%create_dat(1991);
%create_dat(1992);
%create_dat(1993);
%create_dat(1994);
%create_dat(1995);
%create_dat(1996);
%create_dat(1997);
%create_dat(1998);
%create_dat(1999);
%create_dat(2000);
%create_dat(2001);
%create_dat(2002);
%create_dat(2003);
%create_dat(2004);
%create_dat(2005);
%create_dat(2006);
%create_dat(2007);
%create_dat(2008);
%create_dat(2009);
%create_dat(2010);
%create_dat(2011);
%create_dat(2012);
