*************************************************************************
5/18/2009: FIRST DRAFT
  "Everything but annuitized home eqity is adjusted: money income + noncash benefits + adjusted he"
  *inc7=(ftotval_final+fmvfs_final-fts_tottax+fcapgain_final-fcaploss_final
     +fhoussub_final*12+fmvrsl_final+femcontrb_final+fngmcare_final+fngmcaid_final+housret_adj)/scale
  *hinc7=(htotval+hmvfs-hts_tottax+hcapgain-hcaploss
     +hhoussub*12+hmvrsl+hemcontrb+hngmcare+hngmcaid+housret_adj)/hscale

6/4/2010: ADDED AGE_HD FOR USE IN MELLY DECOMPOSITIONS

11/4/10:  ADDED 2010 SY DATA, AND REMOVED CAP GAINS AND LOSSES FROM INCOME 
		  MEASURES

3/18/2011: RE-RAN AFTER ADDING TOT_TRANS TO POVERTY**** FILES.  CHANGED INC3
		   FROM AFTER-TAX USING CPS TAXES TO PRE-TAX, PRE-TRANSFER INCOME
*************************************************************************;

*************************************************************************
MACRO FOR CREATING 1960S AND 1970S DATA
*************************************************************************;

option obs=max;

%macro nasrates6479(yr);
PROC SORT DATA=cpsdata.poverty&yr;
BY famid;
RUN;
data nas_pov;
set cpsdata.poverty&yr;
by famid;

* ONE FAMILY HAS HDAGE=0 IN 1967 (FAMID=99529) AND ONE 
  HAS HDAGE=2 IN 1969 (FAMID=194268);
IF &yr IN(1967,1969) THEN DO;
   IF hdage=0 THEN hdage=63;
   IF hdage=2 THEN hdage=22;
END;
IF 1964 LE &yr LE 1972 THEN age_head=hdage;


IF 1964 LE &yr LE 1967 AND famrel IN(0,4) AND famtyp NE 2 THEN povhead=1;
   ELSE IF 1968 LE &yr LE 1975 AND FIRST.famid AND ftype NE 4 THEN povhead=1;
   ELSE IF &yr GE 1976 AND FIRST.famid AND fkind NE 2 THEN povhead=1;
ELSE povhead=0;
scale=(fpersons_final-tot_kids+.7*tot_kids)**.7;
hscale=(hpersons-hrelu18+.7*hrelu18)**.7;
*official;
inc1=ftotval_final/scale;
hinc1=htotval/hscale;
inc2=(ftotval_final-fts_tottax)/scale;
hinc2=(htotval-hts_tottax)/hscale;
/* earnings */
inc3=(ftotearn_final)/scale;
hinc3=(htotearn)/hscale;
/* AFTER-TAX EARNINGS */
inc4=(ftotearn_final-fts_tottax)/scale;
hinc4=(htotearn-hts_tottax)/hscale;

IF 0 LE age LE 17 THEN age1=1;
      ELSE age1=0;
   IF 18 LE age LE 64 THEN age2=1;
      ELSE age2=0;
   IF age GE 65 THEN age3=1;
   ELSE age3=0;

IF 1976 LE &yr LE 1987 THEN DO;
   IF race2=1 AND reorgn GE 30 THEN r1=1;
      ELSE r1=0;
     IF race2=2 AND reorgn GE 30 THEN r2=1;
	 ELSE r2=0;
     r3=1-r1-r2;
END;
IF 1971 LE &yr LE 1975 THEN DO;
   IF race2=1 AND reorgn NOT IN (8,9,10,11,12) THEN r1=1;
      ELSE r1=0;
     IF race2=2 AND reorgn NOT IN (8,9,10,11,12) THEN r2=1;
	 ELSE r2=0;
     r3=1-r1-r2;
END;
IF 1964 LE &yr LE 1967 THEN DO;
   IF race=1 THEN r1=1;
      ELSE r1=0;
     IF race=2 THEN r2=1;
	 ELSE r2=0;
     r3=1-r1-r2;
END;
IF r1=1 THEN race_head=1;
  ELSE IF r2=1 THEN race_head=2;
  ELSE race_head=3;

ARRAY fam(1:5);
  DO t=1 TO 5;
     IF dem_grp=t THEN fam(t)=1;
       ELSE fam(t)=0; 
  END; 
ARRAY ed(1:4);
  DO t=1 TO 4;
     IF ed_head=t THEN ed(t)=1;
       ELSE ed(t)=0; 
END; 

* hreg NOT AVAILABLE 68-75;
IF 1968 LE &yr LE 1975 THEN DO;
   IF 11 LE state2 LE 23 THEN hreg=1;
	  ELSE IF 31 LE state2 LE 49 THEN hreg=2;
	  ELSE IF 51 LE state2 LE 79 THEN hreg=3;
	  ELSE IF 81 LE state2 LE 99 THEN hreg=4;
END;

ARRAY region(1:4);
   DO t=1 to 4;
	IF hreg=t THEN region(t)=1;
	ELSE region(t)=0;
END;

IF 1964 LE &yr LE 1967 THEN ownhome=.;  
   ELSE IF htenure=1 THEN ownhome=1;
   ELSE IF htenure NE . THEN ownhome=0;

run;

PROC MEANS DATA=nas_pov MEDIAN; 
  VAR inc1 inc2 inc3 inc4 hinc1 hinc2 hinc3 hinc4;
  WEIGHT msupwgt;
  output out=median_temp MEDIAN=med_inc1 med_inc2 med_inc3 med_inc4 med_hinc1 med_hinc2 med_hinc3 med_hinc4;
RUN;

DATA nas_pov;
MERGE nas_pov(IN=in1) cexpov.prices1980(RENAME=(year=ref_year));
BY ref_year;
IF in1;

run;

data nas_pov;
   IF _N_=1 THEN SET median_temp(KEEP=med_inc1 med_inc2 med_inc3 med_inc4 med_hinc1 med_hinc2 med_hinc3 med_hinc4);
   SET nas_pov;

   IF 1964 LE &yr LE 1967 THEN unadj_wgt=wgt/100;
     ELSE unadj_wgt=msupwgt;

if inc1 ne .;
if hinc1 ne .;

IF msupwgt GT wgt/100 AND age ge 18 THEN pweight_under18=familydifference*wgt/100;
 ELSE IF msupwgt GT wgt/100 AND age LE 17 THEN pweight_under18=(1+familydifference)*wgt/100;
 ELSE IF age LE 17 THEN pweight_under18=wgt/100;
 ELSE pweight_under18=0;

IF age GE 65 THEN pweight_over64=wgt/100;
  ELSE pweight_over64=0;
IF 18 LE age LE 64 THEN pweight_18_64=wgt/100;
  ELSE pweight_18_64=0;

run;

data nas_pov&yr;
SET nas_pov(KEEP= age1-age3 r1-r3 region1-region4 inc1-inc4
				 fam1-fam5 hreg ref_year msupwgt ownhome ed1-ed4 emp_head age_head tot_kids tot_earnrs fpersons_final
				 dem_grp pweight_over64 pweight_18_64 pweight_under18 ed_head);
msupwgt4=MAX(0,msupwgt);

  * READ IN PRICE INDEX TO CONVERT TO 2005 $ USING ADJUSTED RS;
  %INCLUDE 'N:\Private\inc_cons_inequality\SAS\cps\cpi_u_rs_adj_05.txt';

   ARRAY inctemp(1:4) inc1-inc4;
   ARRAY r_inc(1:4);

   DO t=1 TO 4; 
    r_inc(t)=inctemp(t)*cpi_u_rs_adj_05;
   END;

   dem_group6=100*dem_grp+10*ed_head+r1; 

   * CREATE LOG CONS FOR DECOMPOSITON;
   IF r_inc2 GT 0 THEN ln_r_inc2=LOG(r_inc2);
   ELSE ln_r_inc2=0;
RUN;
***************************************************************************************
CONVERT DEM_GROUP6 INTO A CONTINUOUS VARIABLE FROM 1-30
***************************************************************************************;
PROC SORT DATA=nas_pov&yr;
   BY dem_group6;
RUN;
DATA temp;
  SET nas_pov&yr(KEEP=dem_group6);
  BY dem_group6;
  IF FIRST.dem_group6;

  RETAIN counter 0; 
  counter= counter+1;
RUN;

PROC FREQ;
  TABLE counter dem_group6;
RUN;
DATA nas_pov&yr; 
  MERGE nas_pov&yr(IN=in1) temp;
  BY dem_group6;
  IF in1;
RUN;

%mend;

%nasrates6479(1964);
%nasrates6479(1965);
%nasrates6479(1966);
%nasrates6479(1967);
%nasrates6479(1968);
%nasrates6479(1969);
%nasrates6479(1970);
%nasrates6479(1971);
%nasrates6479(1972);
%nasrates6479(1973);
%nasrates6479(1974);
%nasrates6479(1975);
%nasrates6479(1976);
%nasrates6479(1977);
%nasrates6479(1978);
%nasrates6479(1979);

DATA cpsdata.inequality_dat6479;
SET nas_pov1964 nas_pov1965 nas_pov1966 nas_pov1967 nas_pov1968 nas_pov1969 
    nas_pov1970 nas_pov1971 nas_pov1972 nas_pov1973 nas_pov1974 nas_pov1975
    nas_pov1976 nas_pov1977 nas_pov1978 nas_pov1979;
RUN;

PROC DATASETS;
   DELETE nas_pov1964 nas_pov1965 nas_pov1966 nas_pov1967 nas_pov1968 nas_pov1969 
    nas_pov1970 nas_pov1971 nas_pov1972 nas_pov1973 nas_pov1974 nas_pov1975
    nas_pov1976 nas_pov1977 nas_pov1978 nas_pov1979;
RUN;


*************************************************************************
MACRO FOR CREATING 1980S - PRESENT
*************************************************************************;
option obs=max mprint;

%macro nasrates8009(yr);

PROC SORT DATA=cpsdata.poverty&yr;
   BY famid;
RUN;
data temp;
set cpsdata.poverty&yr(KEEP=famid mainjob ftype hseq fkind wkswrk age msupwgt);

IF &yr LE 1995 AND mainjob GE 99999 THEN tc=1;
   ELSE IF 1996 LE &yr LE 2002 AND mainjob GE 150000 THEN tc=1;
   ELSE IF 2003 LE &yr LE 2011 AND mainjob GE 200000 THEN tc=1;
   ELSE tc=0;

emp=(wkswrk>0);
kid=(age LE 17);
elderly=(age GE 65);

KEEP famid tc ftype hseq fkind emp kid elderly msupwgt;
RUN;

PROC MEANS SUM NOPRINT DATA=temp;
   BY famid;
   VAR tc emp kid elderly msupwgt;
   OUTPUT OUT=tcdat SUM=tc_sum no_earnr no_kids no_o64 famwgt;
RUN;

data temp;
MERGE temp tcdat(KEEP=famid tc_sum no_earnr no_kids no_o64 famwgt);
BY famid;
IF FIRST.famid;
RUN;

DATA temp2;
SET temp(RENAME=(tc_sum=tc_sum2 no_earnr=no_earnr2 no_kids=no_kids2 no_o64=no_o642 famwgt=famwgt2));
* keep only primary families and related subfamilies;
IF (&yr GE 1988 AND ftype IN(1,3)) OR (&yr LE 1987 AND fkind IN(1,2));
KEEP hseq tc_sum2 no_earnr2 no_kids2 no_o642 famwgt2;
RUN;
PROC SORT DATA=temp2;
   BY hseq;
RUN;
PROC MEANS SUM NOPRINT DATA=temp2;
   BY hseq;
   VAR tc_sum2 no_earnr2 no_kids2 no_o642 famwgt2;
   OUTPUT OUT=tcdat2 SUM=;
RUN;

PROC SORT DATA=temp;
   BY hseq;
RUN;

DATA temp;
MERGE temp tcdat2(KEEP=hseq tc_sum2 no_earnr2 no_kids2 no_o642 famwgt2);
BY hseq;
IF &yr GE 1988 THEN DO;
   IF ftype IN(2,4,5) AND tc_sum GT 0 THEN tc_final=1;
     ELSE IF ftype IN(1,3) AND tc_sum2 GT 0 THEN tc_final=1;
     ELSE tc_final=0;
   IF ftype IN(2,4,5) THEN tot_earnrs=no_earnr;
     ELSE IF ftype IN(1,3) THEN tot_earnrs=no_earnr2;
   IF ftype IN(2,4,5) THEN tot_kids=no_kids;
     ELSE IF ftype IN(1,3) THEN tot_kids=no_kids2;    
   IF ftype IN(2,4,5) THEN persot64=no_o64;
     ELSE IF ftype IN(1,3) THEN persot64=no_o642;      
   IF ftype IN(2,4,5) THEN famwgt_final=famwgt;
     ELSE IF ftype IN(1,3) THEN famwgt_final=famwgt2;    
END;
IF &yr LE 1987 THEN DO;
   IF fkind IN(3,4,5) AND tc_sum GT 0 THEN tc_final=1;
     ELSE IF fkind IN(1,2) AND tc_sum2 GT 0 THEN tc_final=1;
     ELSE tc_final=0;
   IF fkind IN(3,4,5) THEN tot_earnrs=no_earnr;
     ELSE IF fkind IN(1,2) THEN tot_earnrs=no_earnr2;
   IF fkind IN(3,4,5) THEN tot_kids=no_kids;
     ELSE IF fkind IN(1,2) THEN tot_kids=no_kids2;
   IF fkind IN(3,4,5) THEN persot64=no_o64;
     ELSE IF fkind IN(1,2) THEN persot64=no_o642;
   IF fkind IN(3,4,5) THEN famwgt_final=famwgt;
     ELSE IF fkind IN(1,2) THEN famwgt_final=famwgt2;
END;

KEEP famid tc_final tot_earnrs tot_kids persot64 famwgt_final;
RUN;

PROC SORT DATA=temp;
   BY famid;
RUN;

data nas_pov1 nas_pov2;
set cpsdata.poverty&yr(KEEP=age ftype fkind hseq famid);

IF age GE 65;

IF (ftype IN(1,3) AND &yr GE 1988) 
   OR (fkind IN(1,2) AND &yr LE 1987) THEN OUTPUT nas_pov1;
IF (ftype IN(2,4,5) AND &yr GE 1988) 
   OR (fkind GE 3 AND &yr LE 1987) THEN OUTPUT nas_pov2;

KEEP hseq famid;
RUN;

PROC SORT DATA=nas_pov1;
   BY hseq;
RUN;
PROC SORT DATA=nas_pov2;
   BY famid;
RUN;

DATA nas_pov1;
   SET nas_pov1;
   BY hseq;
   IF first.hseq;
RUN;
DATA nas_pov2;
   SET nas_pov2;
   BY famid;
   IF first.famid;
RUN;

PROC SORT DATA=cpsdata.poverty&yr;
   BY hseq;
RUN;

DATA nas_pov;
   MERGE cpsdata.poverty&yr(IN=in1) nas_pov1(IN=in2);
   BY hseq;

RUN;

PROC SORT DATA=nas_pov;
   BY famid;
RUN;

DATA nas_pov;
   MERGE nas_pov(IN=in1) nas_pov2(IN=in3) temp;
   BY famid;
   IF in1;

IF &yr GE 1988 AND FIRST.famid AND ftype IN(1,2,4,5) THEN povhead=1;
   ELSE IF &yr LE 1987 AND FIRST.famid AND fkind IN(1,3,4,5) THEN povhead=1;
ELSE povhead=0;

RUN;


data nas_pov3 nas_pov4;
set nas_pov(KEEP=age ftype fkind hseq famid tot_kids marstat hgc hga wkswrk);

IF (ftype IN(1,3) AND &yr GE 1988) 
   OR (fkind IN(1,2) AND &yr LE 1987) THEN OUTPUT nas_pov3;
IF (ftype IN(2,4,5) AND &yr GE 1988) 
   OR (fkind GE 3 AND &yr LE 1987) THEN OUTPUT nas_pov4;

RUN;

PROC SORT DATA=nas_pov3;
   BY hseq;
RUN;
PROC SORT DATA=nas_pov4;
   BY famid;
RUN;

DATA nas_pov3;
   SET nas_pov3;
   BY hseq;
   IF first.hseq;

emp_hd_prime=(wkswrk>0);
age_hd_prime=age;
marstat_hd_prime=marstat;

IF &yr GE 1992 THEN DO;
  IF age LE 64 AND tot_kids GT 0 AND marstat IN (4,5,6,7) THEN dem_grp_prime=1;
   ELSE IF age LE 64 AND tot_kids GT 0 AND marstat IN (1,2,3) THEN dem_grp_prime=2;
   ELSE IF age LE 64 AND tot_kids=0 AND marstat IN (4,5,6,7) THEN dem_grp_prime=3;
   ELSE IF age LE 64 AND tot_kids=0 AND marstat IN (1,2,3) THEN dem_grp_prime=4;
   ELSE IF age GE 65 THEN dem_grp_prime=5;

   IF hga LT 39 THEN ed_hd_prime=1;
      ELSE IF hga=39 THEN ed_hd_prime=2;
      ELSE IF 40 LE hga LE 42 THEN ed_hd_prime=3;
      ELSE IF hga GE 43 THEN ed_hd_prime=4;
END;

IF 1988 LE &yr LE 1991 THEN DO;
  IF age LE 64 AND tot_kids GT 0 AND marstat IN (4,5,6,7) THEN dem_grp_prime=1;
   ELSE IF age LE 64 AND tot_kids GT 0 AND marstat IN (1,2,3) THEN dem_grp_prime=2;
   ELSE IF age LE 64 AND tot_kids=0 AND marstat IN (4,5,6,7) THEN dem_grp_prime=3;
   ELSE IF age LE 64 AND tot_kids=0 AND marstat IN (1,2,3) THEN dem_grp_prime=4;
   ELSE IF age GE 65 THEN dem_grp_prime=5;

  IF hga LE 11 OR (hga=12 AND hgc NE 1) THEN ed_hd_prime=1;
      ELSE IF hga=12 AND hgc=1 THEN ed_hd_prime=2;
      ELSE IF 13 LE hga LE 15 OR (hga=16 AND hgc NE 1) THEN ed_hd_prime=3;
      ELSE IF hga GT 16 OR (hga=16 AND hgc=1) THEN ed_hd_prime=4;
END;

IF &yr LE 1987 THEN DO;
  IF age LE 64 AND tot_kids GT 0 AND marstat IN (5,6,7,8) THEN dem_grp_prime=1;
   ELSE IF age LE 64 AND tot_kids GT 0 AND marstat IN (1,2,3,4) THEN dem_grp_prime=2;
   ELSE IF age LE 64 AND tot_kids=0 AND marstat IN (5,6,7,8) THEN dem_grp_prime=3;
   ELSE IF age LE 64 AND tot_kids=0 AND marstat IN (1,2,3,4) THEN dem_grp_prime=4;
   ELSE IF age GE 65 THEN dem_grp_prime=5;

   IF hga LE 12 OR (hga=13 AND hgc NE 1) THEN ed_hd_prime=1;
      ELSe IF hga=13 AND hgc=1 THEN ed_hd_prime=2;
      ELSE IF 14 LE hga LE 16 OR (hga=17 AND hgc NE 1) THEN ed_hd_prime=3;
      ELSE IF hga GT 17 OR (hga=17 AND hgc=1) THEN ed_hd_prime=4;
END;

RUN;

DATA nas_pov4;
   SET nas_pov4;
   BY famid;
   IF first.famid;

emp_hd_nprime=(wkswrk>0);
age_hd_nprime=age;
marstat_hd_nprime=marstat;

IF &yr GE 1992 THEN DO;
  IF age LE 64 AND tot_kids GT 0 AND marstat IN (4,5,6,7) THEN dem_grp_nprime=1;
   ELSE IF age LE 64 AND tot_kids GT 0 AND marstat IN (1,2,3) THEN dem_grp_nprime=2;
   ELSE IF age LE 64 AND tot_kids=0 AND marstat IN (4,5,6,7) THEN dem_grp_nprime=3;
   ELSE IF age LE 64 AND tot_kids=0 AND marstat IN (1,2,3) THEN dem_grp_nprime=4;
   ELSE IF age GE 65 THEN dem_grp_nprime=5;

   IF hga LT 39 THEN ed_hd_nprime=1;
      ELSE IF hga=39 THEN ed_hd_nprime=2;
      ELSE IF 40 LE hga LE 42 THEN ed_hd_nprime=3;
      ELSE IF hga GE 43 THEN ed_hd_nprime=4;
END;

IF 1988 LE &yr LE 1991 THEN DO;
  IF age LE 64 AND tot_kids GT 0 AND marstat IN (4,5,6,7) THEN dem_grp_nprime=1;
   ELSE IF age LE 64 AND tot_kids GT 0 AND marstat IN (1,2,3) THEN dem_grp_nprime=2;
   ELSE IF age LE 64 AND tot_kids=0 AND marstat IN (4,5,6,7) THEN dem_grp_nprime=3;
   ELSE IF age LE 64 AND tot_kids=0 AND marstat IN (1,2,3) THEN dem_grp_nprime=4;
   ELSE IF age GE 65 THEN dem_grp_nprime=5;

  IF hga LE 11 OR (hga=12 AND hgc NE 1) THEN ed_hd_nprime=1;
      ELSE IF hga=12 AND hgc=1 THEN ed_hd_nprime=2;
      ELSE IF 13 LE hga LE 15 OR (hga=16 AND hgc NE 1) THEN ed_hd_nprime=3;
      ELSE IF hga GT 16 OR (hga=16 AND hgc=1) THEN ed_hd_nprime=4;
END;

IF &yr LE 1987 THEN DO;
  IF age LE 64 AND tot_kids GT 0 AND marstat IN (5,6,7,8) THEN dem_grp_nprime=1;
   ELSE IF age LE 64 AND tot_kids GT 0 AND marstat IN (1,2,3,4) THEN dem_grp_nprime=2;
   ELSE IF age LE 64 AND tot_kids=0 AND marstat IN (5,6,7,8) THEN dem_grp_nprime=3;
   ELSE IF age LE 64 AND tot_kids=0 AND marstat IN (1,2,3,4) THEN dem_grp_nprime=4;
   ELSE IF age GE 65 THEN dem_grp_nprime=5;

   IF hga LE 12 OR (hga=13 AND hgc NE 1) THEN ed_hd_nprime=1;
      ELSe IF hga=13 AND hgc=1 THEN ed_hd_nprime=2;
      ELSE IF 14 LE hga LE 16 OR (hga=17 AND hgc NE 1) THEN ed_hd_nprime=3;
      ELSE IF hga GT 17 OR (hga=17 AND hgc=1) THEN ed_hd_nprime=4;
END;

RUN;

PROC SORT DATA=nas_pov;
   BY hseq;
RUN;

DATA nas_pov;
   MERGE nas_pov(IN=in1) nas_pov3(IN=in2 KEEP=hseq dem_grp_prime ed_hd_prime emp_hd_prime age_hd_prime marstat_hd_prime);
   BY hseq;
   IF in1;
RUN;

PROC SORT DATA=nas_pov;
   BY famid;
RUN;

DATA nas_pov;
   MERGE nas_pov(IN=in1) nas_pov4(IN=in3 KEEP=famid dem_grp_nprime ed_hd_nprime emp_hd_nprime age_hd_nprime marstat_hd_nprime) temp;
   BY famid;
   IF in1;

IF (ftype IN(1,3) AND &yr GE 1988) OR (fkind IN(1,2) AND &yr LE 1987) THEN DO;
	dem_grp=dem_grp_prime;
	ed_head=ed_hd_prime;
	emp_head=emp_hd_prime;
	age_head=age_hd_prime;
	marstat_head=marstat_hd_prime;
END;
IF (ftype IN(2,4,5) AND &yr GE 1988) OR (fkind GE 3 AND &yr LE 1987) THEN DO;
	dem_grp=dem_grp_nprime;
	ed_head=ed_hd_nprime;
	emp_head=emp_hd_nprime;
	age_head=age_hd_nprime;
	marstat_head=marstat_hd_nprime;
END;

DROP dem_grp_nprime ed_hd_nprime emp_hd_nprime age_hd_nprime dem_grp_prime ed_hd_prime emp_hd_prime age_hd_prime marstat_hd_prime marstat_hd_nprime;

IF 0 LE age LE 17 THEN age1=1;
      ELSE age1=0;
   IF 18 LE age LE 64 THEN age2=1;
      ELSE age2=0;
   IF age GE 65 THEN age3=1;
   ELSE age3=0;

IF year GE 2003 THEN DO;
   IF race2=1 AND reorgn=0 THEN r1=1;
      ELSE r1=0;
     IF race2=2 AND reorgn=0 THEN r2=1;
	 ELSE r2=0;
     r3=1-r1-r2;
END;

IF 1988 LE year LE 2002 THEN DO;
   IF race2=1 AND reorgn GE 8 THEN r1=1;
      ELSE r1=0;
     IF race2=2 AND reorgn GE 8 THEN r2=1;
	 ELSE r2=0;
     r3=1-r1-r2;
END;

IF 1976 LE year LE 1987 THEN DO;
   IF race2=1 AND reorgn GE 30 THEN r1=1;
      ELSE r1=0;
     IF race2=2 AND reorgn GE 30 THEN r2=1;
	 ELSE r2=0;
     r3=1-r1-r2;
END;

IF r1=1 THEN race_head=1;
  ELSE IF r2=1 THEN race_head=2;
  ELSE race_head=3;

ARRAY fam(1:5);
  DO t=1 TO 5;
     IF dem_grp=t THEN fam(t)=1;
       ELSE fam(t)=0; 
  END; 
ARRAY ed(1:4);
  DO t=1 TO 4;
     IF ed_head=t THEN ed(t)=1;
       ELSE ed(t)=0; 
END; 

ARRAY region(1:4);
   DO t=1 to 4;
	IF hreg=t THEN region(t)=1;
	ELSE region(t)=0;
END;

IF htenure=1 THEN ownhome=1;
   ELSE ownhome=0;

IF tc_final=1 THEN ftottax_final2=0.21*ftotval_final;
   ELSE ftottax_final2=ftottax_final;

scale=(fpersons_final-tot_kids+.7*tot_kids)**.7;
hscale=(hpersons-hrelu18+.7*hrelu18)**.7;
*official;
inc1=ftotval_final/scale;
hinc1=htotval/hscale;
*after-tax(TAXSIM);
inc2=(ftotval_final-fts_tottax)/scale;
hinc2=(htotval-hts_tottax)/hscale;
/* NOTE: INSERTED NEW INC3 & INC4, EARNINGS, 8/4/11 */
/* earnings */
inc3=(ftotearn_final)/scale;
hinc3=(htotearn)/hscale;
/* after-tax earnings */
inc4=(ftotearn_final-fts_tottax)/scale;
hinc4=(htotearn-hts_tottax)/hscale;


*NOTE: CHANGED INC3 TO PRE-TRANSFER INC, SEE POVERTY RESULTS: ALL_TABLES65.XLS OR EARLIER
 FOR RESULTS FOR AFTER-TAX MEASURE USING CPS TAXES;
*after-tax;
*inc3=(ftotval_final-ftottax_final2)/scale;
*hinc3=(htotval-htottax)/hscale;
*pre-tax, pre-transfer: offical-(soc security+wc+ui+vet+ssi+afdc/tanf);

inc5=(ftotval_final-ftot_trans_final)/scale;
hinc5=(htotval-htot_trans)/hscale;

*official+foodstamps+taxes;
inc6=(ftotval_final+fmvfs_final-fts_tottax)/scale;
hinc6=(htotval+hmvfs-hts_tottax)/hscale;
*official+foodstamps+taxes+other noncash;
inc7=(ftotval_final+fmvfs_final-fts_tottax+fhoussub_final*12+fmvrsl_final)/scale;
hinc7=(htotval+hmvfs-hts_tottax+hhoussub*12+hmvrsl)/hscale;
*official+foodstamps+taxes+(gains-loss)+other noncash+medical;
inc8=(ftotval_final+fmvfs_final-fts_tottax
	+fhoussub_final*12+fmvrsl_final+fngmcare_final+fngmcaid_final)/scale;
hinc8=(htotval+hmvfs-hts_tottax+hhoussub*12+hmvrsl+hngmcare+hngmcaid)/hscale;
*Everything but annuitized home eqity (inc6 plus employer contrib to health ins);
inc9=(ftotval_final+fmvfs_final-fts_tottax
     +fhoussub_final*12+fmvrsl_final+femcontrb_final+fngmcare_final+fngmcaid_final)/scale;
hinc9=(htotval+hmvfs-hts_tottax
     +hhoussub*12+hmvrsl+hemcontrb+hngmcare+hngmcaid)/hscale;
*Everything: money income + noncash benefits + annuitized home equity;
inc10=(ftotval_final+fmvfs_final-fts_tottax
     +fhoussub_final*12+fmvrsl_final+femcontrb_final+housret+fngmcare_final+fngmcaid_final)/scale;
hinc10=(htotval+hmvfs-hts_tottax
     +hhoussub*12+hmvrsl+hemcontrb+housret+hngmcare+hngmcaid)/hscale;
RUN;

PROC MEANS DATA=nas_pov MEDIAN; 
  VAR inc1-inc10 hinc1-hinc10;
  WEIGHT msupwgt;
  OUTPUT OUT=median_&yr MEDIAN=med_inc1-med_inc10 med_hinc1-med_hinc10;
RUN;

PROC SORT DATA=nas_pov;
   BY ref_year;
RUN;

DATA nas_pov;
MERGE nas_pov(IN=in1) cexpov.prices1980(RENAME=(year=ref_year));
BY ref_year;
IF in1;
RUN;

data nas_pov;
   IF _N_=1 THEN SET median_&yr(KEEP=med_inc1-med_inc10 med_hinc1-med_hinc10);
   SET nas_pov;

RUN;

data nas_pov&yr;
SET nas_pov(KEEP=age1-age3 r1-r3 region1-region4 inc1-inc10
				 fam1-fam5 year hreg ref_year msupwgt ownhome ed1-ed4 emp_head age_head tot_kids persot64 tot_earnrs fpersons_final
				 dem_grp ed_head marstat_head);

  * READ IN PRICE INDEX TO CONVERT TO 2005 $ USING ADJUSTED RS, CURRENTLY THRU 2009;
  %INCLUDE 'N:\Private\inc_cons_inequality\SAS\cps\cpi_u_rs_adj_05.txt';

   ARRAY inctemp(1:10) inc1-inc10;
   ARRAY r_inc(1:10);

   DO t=1 TO 10; 
    r_inc(t)=inctemp(t)*cpi_u_rs_adj_05;
   END;

   dem_group6=100*dem_grp+10*ed_head+r1; 

   * CREATE LOG CONS FOR DECOMPOSITON;
   IF r_inc2 GT 0 THEN ln_r_inc2=LOG(r_inc2);
   ELSE ln_r_inc2=0;
RUN;
***************************************************************************************
CONVERT DEM_GROUP6 INTO A CONTINUOUS VARIABLE FROM 1-30
***************************************************************************************;
PROC SORT DATA=nas_pov&yr;
   BY dem_group6;
RUN;
DATA temp;
  SET nas_pov&yr(KEEP=dem_group6);
  BY dem_group6;
  IF FIRST.dem_group6;

  RETAIN counter 0; 
  counter= counter+1;
RUN;

PROC FREQ;
  TABLE counter dem_group6;
RUN;
DATA nas_pov&yr; 
  MERGE nas_pov&yr(IN=in1) temp;
  BY dem_group6;
  IF in1;
RUN;

%mend;

%nasrates8009(1980);
%nasrates8009(1981);
%nasrates8009(1982);
%nasrates8009(1983);
%nasrates8009(1984);
%nasrates8009(1985);
%nasrates8009(1986);
%nasrates8009(1987);
%nasrates8009(1988);
%nasrates8009(1989);

DATA cpsdata.inequality_dat8089;
SET nas_pov1980 nas_pov1981 nas_pov1982 nas_pov1983 nas_pov1984 nas_pov1985
    nas_pov1986 nas_pov1987 nas_pov1988 nas_pov1989;
RUN;

PROC DATASETS;
   DELETE nas_pov1980 nas_pov1981 nas_pov1982 nas_pov1983 nas_pov1984 nas_pov1985
    	  nas_pov1986 nas_pov1987 nas_pov1988 nas_pov1989;
RUN;

%nasrates8009(1990);
%nasrates8009(1991);
%nasrates8009(1992);
%nasrates8009(1993);
%nasrates8009(1994);
%nasrates8009(1995);
%nasrates8009(1996);
%nasrates8009(1997);
%nasrates8009(1998);
%nasrates8009(1999);

DATA cpsdata.inequality_dat9099;
SET nas_pov1990 nas_pov1991 nas_pov1992 nas_pov1993 nas_pov1994 nas_pov1995
    nas_pov1996 nas_pov1997 nas_pov1998 nas_pov1999;
RUN;

PROC DATASETS;
   DELETE nas_pov1990 nas_pov1991 nas_pov1992 nas_pov1993 nas_pov1994 nas_pov1995
    	  nas_pov1996 nas_pov1997 nas_pov1998 nas_pov1999;
RUN;


%nasrates8009(2000);
%nasrates8009(2001);
%nasrates8009(2002);
%nasrates8009(2003);
%nasrates8009(2004);
%nasrates8009(2005);
%nasrates8009(2006);
%nasrates8009(2007);
%nasrates8009(2008);
%nasrates8009(2009);
%nasrates8009(2010);
%nasrates8009(2011);
%nasrates8009(2012);

DATA cpsdata.inequality_dat0012;
SET nas_pov2000 nas_pov2001 nas_pov2002 nas_pov2003 nas_pov2004 nas_pov2005
    nas_pov2006 nas_pov2007 nas_pov2008 nas_pov2009 nas_pov2010 nas_pov2011
	nas_pov2012;
RUN;

PROC DATASETS;
   DELETE nas_pov2000 nas_pov2001 nas_pov2002 nas_pov2003 nas_pov2004 nas_pov2005
    	  nas_pov2006 nas_pov2007 nas_pov2008 nas_pov2009 nas_pov2010 nas_pov2011
		  nas_pov2012;
RUN;

