clear



***get unemployment data****
**http://data.bls.gov/timeseries/LNU04000000?years_option=all_years&periods_option=specific_periods&periods=Annual+Data***


insheet using "Annual_urates.csv"

rename annual urate

sort year

gen urate_avg = (urate + urate[_n+1]) / 2

gen urate_prev = urate[_n-1]

****merge to output from Figures9_10_and_11_BPEA*****

merge 1:m year using "/home/cramer/CPS/Figures9_10_and_11_BPEA.dta"

gen log_urate_prev = log(urate_prev)
gen log_urate_avg = log(urate_avg)

gen full_time_steady = full_time * employed

foreach var of varlist olf-unemployed {
	gen log_`var' = log(`var')
}


gen log_full_time_steady = log(full_time_steady)


***drop years wih no data
drop if year == 1993 | year<1982

gen year_num = [_n]

tsset year_num

*******Short-term**********
newey log_unemployed urate_avg if dur==1, lag(3)
local un_short_full = string(round(e(urate_avg),.001))
estimates store reg1

newey log_olf urate_avg if dur==1, lag(3)
local olf_short_full = string(round(e(urate_avg),.001))
estimates store reg2

newey log_employed urate_avg if dur==1, lag(3)
local un_short_full = string(round(e(urate_avg),.001))
estimates store reg3

newey log_full_time_steady urate_avg if dur==1, lag(3)
local olf_short_full = string(round(e(urate_avg),.001))
estimates store reg4


*******Long_term**************
newey log_unemployed urate_avg if dur==2, lag(3)
local un_short_full = string(round(e(urate_avg),.001))
estimates store reg5

newey log_olf urate_avg if dur==2, lag(3)
local olf_short_full = string(round(e(urate_avg),.001))
estimates store reg6

newey log_employed urate_avg if dur==2, lag(3)
local un_short_full = string(round(e(urate_avg),.001))
estimates store reg7

newey log_full_time_steady urate_avg if dur==2, lag(3)
local olf_short_full = string(round(e(urate_avg),.001))
estimates store reg8



************************************
************IV**********************

******short-term********************
newey2 log_unemployed (urate_avg = urate_prev) if dur==1, lag(3)
local un_short_full = string(round(e(urate_avg),.001))
estimates store reg9

newey2 log_olf (urate_avg = urate_prev) if dur==1, lag(3)
local olf_short_full = string(round(e(urate_avg),.001))
estimates store reg10

newey2 log_employed (urate_avg = urate_prev) if dur==1, lag(3)
local un_short_full = string(round(e(urate_avg),.001))
estimates store reg11

newey2 log_full_time_steady (urate_avg = urate_prev) if dur==1, lag(3)
local olf_short_full = string(round(e(urate_avg),.001))
estimates store reg12

*****long-term*****************************

newey2 log_unemployed (urate_avg = urate_prev) if dur==2, lag(3)
local un_short_full = string(round(e(urate_avg),.001))
estimates store reg13

newey2 log_olf (urate_avg = urate_prev) if dur==2, lag(3)
local olf_short_full = string(round(e(urate_avg),.001))
estimates store reg14

newey2 log_employed (urate_avg = urate_prev) if dur==2, lag(3)
local un_short_full = string(round(e(urate_avg),.001))
estimates store reg15

newey2 log_full_time_steady (urate_avg = urate_prev) if dur==2, lag(3)
local olf_short_full = string(round(e(urate_avg),.001))
estimates store reg16


*************************************************
*********************Pre-2008********************

******short-term********************
newey log_unemployed urate_avg if dur==1 & year<=2007, lag(3)
local un_short_full = string(round(e(urate_avg),.001))
estimates store reg17

newey log_olf urate_avg if dur==1 & year<=2007, lag(3)
local olf_short_full = string(round(e(urate_avg),.001))
estimates store reg18

newey log_employed urate_avg if dur==1 & year<=2007, lag(3)
local un_short_full = string(round(e(urate_avg),.001))
estimates store reg19

newey log_full_time_steady urate_avg if dur==1 & year<=2007, lag(3)
local olf_short_full = string(round(e(urate_avg),.001))
estimates store reg20

*****long-term*****************************

newey log_unemployed urate_avg if dur==2 & year<=2007, lag(3)
local un_short_full = string(round(e(urate_avg),.001))
estimates store reg21

newey log_olf urate_avg if dur==2 & year<=2007, lag(3)
local olf_short_full = string(round(e(urate_avg),.001))
estimates store reg22

newey log_employed urate_avg if dur==2 & year<=2007, lag(3)
local un_short_full = string(round(e(urate_avg),.001))
estimates store reg23

newey log_full_time_steady urate_avg if dur==2 & year<=2007, lag(3)
local olf_short_full = string(round(e(urate_avg),.001))
estimates store reg24



*************Now make the table inputs**********************
******Output for table from left to right*****

esttab reg1 reg2 reg3  reg4 reg5  reg6 reg7  reg8 reg9 reg10 reg11 reg12 reg13 reg14 reg15 reg16 reg17 reg18 reg19 reg20  reg21 reg22 reg23 reg24  using "cyclicality_reg.csv", nocons replace cells(b(fmt(3)) se(par star fmt(3))) stats(N, fmt(0)) varwidth(50) legend label mlabels(,none) varlabels(_cons Intercept) style(fixed) stardetach order(urate_avg)postfoot("")
