clear

set more off

****data on BPEA website, also available from http://www.ropercenter.uconn.edu/CFIDE/cf/action/catalog/catalogResult.cfm?keyword=Work+trends+survey&cx=011845638060054519721%3Adjy0ofghpnc&country=All+Countries&sa.x=0&sa.y=0&sitesearch=****

* use "Table3and4"

****create variable for duration for those unemployed in Wave 1*****

tab JHU1_1
tab JHU1_1, nol

***tabulations*****

gen short_term = 1 if JHU1_1 > 0 & JHU1_1<=3 & !missing(JHU1_1 )

gen long_term = 1 if JHU1_1 > 0 & JHU1_1>3 & JHU1_1<=6 & !missing(JHU1_1 )


****Make comparable to CPS*****
tab QEMPSTAT_4
tab QEMPSTAT_4, nol

****Employed if working full-time or part-time, even when at grad school or self-employed****
***Unemployed if Unemployed and Lookign for Work****
****Not in the Labor force if unemployed and not looking for work, at school and not working, or volunteer****
gen lfs = 1 if QEMPSTAT_4 == 5 | QEMPSTAT_4 == 4 | QEMPSTAT_4 == 3 | QEMPSTAT_4 == 6 | QEMPSTAT_4==9
replace lfs=2 if QEMPSTAT_4 == 1 
replace lfs=3 if QEMPSTAT_4 == 2 | QEMPSTAT_4 == 10 | QEMPSTAT_4 == 7


label define lfs 1 "employed" 2 "unemployed" 3 "not in the labor force" 
label values lfs lfs


****create variable for previous duration for those employed in Wave 1 (sample are workers unemployed at some point in previous year****
gen short_bef_emp = 1 if JHE1_1<=3 & JHE1_1>=0 & !missing(JHE1_1)

gen long_bef_emp = 1 if  JHE1_1>3  & !missing(JHE1_1)

***Tabulations***
************Ongoing*****************
tab lfs [aweight= weight_1] if short_term ==1
tab lfs [aweight= weight_1] if long_term ==1

tab QEMPSTAT_4 [aweight= weight_1] if long_term==1 & QEMPSTAT_4 > 0
tab QEMPSTAT_4 [aweight= weight_1] if  short_term==1 & QEMPSTAT_4 > 0


**************Completed*******************************
tab lfs [aweight= weight_1] if short_bef ==1
tab lfs [aweight= weight_1] if long_bef ==1

tab QEMPSTAT_4 [aweight= weight_1] if long_bef==1 & QEMPSTAT_4 > 0
tab QEMPSTAT_4 [aweight= weight_1] if  short_bef==1 & QEMPSTAT_4 > 0








***tabulations****

tab lfs [aweight= weight_1] if (long_bef ==1 | long_term==1) & QEMPSTAT_4 > 0
tab lfs [aweight= weight_1] if (short_bef ==1 | short_term==1) & QEMPSTAT_4 > 0

tab QEMPSTAT_4 [aweight= weight_1] if (long_bef ==1 | long_term==1) & QEMPSTAT_4 > 0
tab QEMPSTAT_4 [aweight= weight_1] if (short_bef ==1 | short_term==1) & QEMPSTAT_4 > 0



****Restrict sample to only those who think that there is "a slim chance" or "no chance" that they could be recalled****

tab lfs [aweight= weight_1] if (long_bef ==1 | long_term==1 & (UH11_1==4 | UH11_1==3)) & QEMPSTAT_4 > 0
tab lfs [aweight= weight_1] if (short_bef ==1 | short_term==1 & (UH11_1==4 | UH11_1==3)) & QEMPSTAT_4 > 0

tab QEMPSTAT_4 [aweight= weight_1] if (long_bef ==1 | long_term==1 & (UH11_1==4 | UH11_1==3)) & QEMPSTAT_4 > 0
tab QEMPSTAT_4 [aweight= weight_1] if (short_bef ==1 | short_term==1  & (UH11_1==4 | UH11_1==3)) & QEMPSTAT_4 > 0


****************For tables*********************************************
tab lfs [aweight= weight_1] if (long_term==1 & (UH11_1==4 | UH11_1==3)) & QEMPSTAT_4 > 0
tab QEMPSTAT_4 [aweight= weight_1] if (long_term==1 & (UH11_1==4 | UH11_1==3)) & QEMPSTAT_4 > 0


tab QEMPSTAT_4 [aweight= weight_1] if (short_term==1 & (UH11_1==4 | UH11_1==3)) & QEMPSTAT_4 > 0
tab lfs [aweight= weight_1] if (short_term==1 & (UH11_1==4 | UH11_1==3)) & QEMPSTAT_4 > 0
tab QEMPSTAT_4 [aweight= weight_1] if (short_bef==1 & (UH11_1==4 | UH11_1==3)) & QEMPSTAT_4 > 0
tab lfs [aweight= weight_1] if (short_bef==1 & (UH11_1==4 | UH11_1==3)) & QEMPSTAT_4 > 0
tab QEMPSTAT_4 [aweight= weight_1] if (long_bef==1 & (UH11_1==4 | UH11_1==3)) & QEMPSTAT_4 > 0
tab lfs [aweight= weight_1] if (long_bef==1 & (UH11_1==4 | UH11_1==3)) & QEMPSTAT_4 > 0



