clear


 
set more off



cd /home/cramer/CPS

***download basic data from www.nber.org/data/cps_basic.html***

use jan13pub.dta

foreach x in feb13 mar13 apr13 may13 jun13 jul13 aug13 sep13 oct13 nov13 dec13 {

append using `x'pub.dta

}

*log using 2013_table_output.log, replace

keep if prtage>=16

gen unemp = 1 if prunedur>=0 & prunedur<14 & !missing(prunedur)
replace unemp = 2 if prunedur>=27 & !missing(prunedur)
replace unemp =3 if pemlr==1 | pemlr==2

label define unemp 1 "short-term" 2 "long-term" 3 "emp"
label values unemp unemp

drop if missing(unemp)

bysort unemp: tab pesex [aweight= pwsswgt]



recode prtage (16/34 = 1) (35/49 =2) (50/max =3), generate(age_group2)

label define age_group2 1 "16-34 years" 2 "35-49 years" 3 "50 plus"

label values age_group2 age_group2

drop if age_group2 < 1 | age_group2 > 3


bysort unemp: tab age_group2 [aweight= pwsswgt] 

bysort unemp: tab pemaritl [aweight= pwsswgt] 


gen hisp = (prdthsp>=0)



replace ptdtrace =300 if hisp==1


bysort unemp: tab ptdtrace [aweight= pwsswgt]

bysort unemp: tab peeduca [aweight= pwsswgt]



bysort unemp: tab prmjind1 [aweight= pwsswgt] if prmjind1>0

****All Other is Agriculture, Mining, Transportation, Information, Other services, Public Administration, Armed forces*****
di 1.86 + .85 + 4.51 + 1.76 + 4.93 + 2.03 + .32

di .99 + .38 + 4.77 + 2.09 + 4.52 + 2.58 + .58

di 1.48 + .74 + 5.14 + 2.06 + 4.96 + 4.66


bysort unemp: tab prmjocc1 [aweight= pwsswgt] if prmjocc1>0

***Blue collar is defined as Transportation and Material moving, Production Occupations, Construction and extraction, Armed Forces, and Farming, Fishing, and Forestry***
di 0.31 + 8.9 + 6.99 + 11.46 + 1.72

di 0.58 + 8.44 + 8.36 + 8.75 + 0.77


di 6.04 + 5.74 + 4.94 + 0.67


log close






