clear
use c:\data\Kcntrl\data\monthlyer.dta
*  These lines were used to create the data file monthlyer.dta
*local varlist argentina brazil chile chinaprmainland czechrepublic hungary iceland indonesia korearepublicof mexico peru philippines poland turkey ireland portugal

*foreach var in `varlist' {
*rename `var' `var'er_avg
*}

*reshape long @er_avg, i(year month yearmonth) j(country) string

*gen erindex = (er_avg/er_avg[44]) if country=="Argentina"
*replace erindex = (er_avg/er_avg[110]) if country=="Brazil"
*replace erindex = (er_avg/er_avg[176]) if country=="Chile"
*replace erindex = (er_avg/er_avg[242]) if country=="China"
*replace erindex = (er_avg/er_avg[308]) if country=="Czech Republic"
*replace erindex = (er_avg/er_avg[374]) if country=="Hungary"
*replace erindex = (er_avg/er_avg[440]) if country=="Iceland"
*replace erindex = (er_avg/er_avg[506]) if country=="Indonesia"
*replace erindex = (er_avg/er_avg[572]) if country=="Ireland"
*replace erindex = (er_avg/er_avg[638]) if country=="Korea"
*replace erindex = (er_avg/er_avg[704]) if country=="Mexico"
*replace erindex = (er_avg/er_avg[770]) if country=="Peru"
*replace erindex = (er_avg/er_avg[836]) if country=="Philippines"
*replace erindex = (er_avg/er_avg[902]) if country=="Poland"
*replace erindex = (er_avg/er_avg[968]) if country=="Portugal"
*replace erindex = (er_avg/er_avg[1034]) if country=="Turkey"

*gen derindex = (der_avg/der_avg[46]) if country=="Argentina"
*replace derindex = (der_avg/der_avg[112]) if country=="Brazil"
*replace derindex = (der_avg/der_avg[178]) if country=="Chile"
*replace derindex = (der_avg/der_avg[244]) if country=="China"
*replace derindex = (der_avg/der_avg[310]) if country=="Czech Republic"
*replace derindex = (der_avg/der_avg[376]) if country=="Hungary"
*replace derindex = (der_avg/der_avg[442]) if country=="Iceland"
*replace derindex = (der_avg/der_avg[508]) if country=="Indonesia"
*replace derindex = (der_avg/der_avg[574]) if country=="Ireland"
*replace derindex = (der_avg/der_avg[640]) if country=="Korea"
*replace derindex = (der_avg/der_avg[706]) if country=="Mexico"
*replace derindex = (der_avg/der_avg[772]) if country=="Peru"
*replace derindex = (der_avg/der_avg[838]) if country=="Philippines"
*replace derindex = (der_avg/der_avg[904]) if country=="Poland"
*replace derindex = (der_avg/der_avg[970]) if country=="Portugal"
*replace derindex = (der_avg/der_avg[1036]) if country=="Turkey"
* xlab(597 "BRA Oct 09" 598 "KOR, BRA Nov 09" 600 "PERU Jan 10" 601 "PERU Feb 10" 605 "KOR PERU June 10" 607 "QE2 Aug 10" 609 "BRA Oct 10" 610 "KOR Nov 10" 611 "KOR Dec 10" 612 "BRA KOR Jan 11" 615 "BRA Apr 11" 618 "KOR Jul 11" 621 "ARG Oct 11", axis(1) angle(270)) ///

twoway line erindex yearmonth if country=="Argentina" & counter>480 & year<2012 || ///
line erindex yearmonth if country=="Brazil" & counter>480 & year<2012, xaxis(2) || /// 
line erindex yearmonth if country=="Chile" & counter>480 & year<2012, xaxis(2) || ///
line erindex yearmonth if country=="Korea" & counter>480 & year<2012, xaxis(2) || ///
line erindex yearmonth if country=="Peru"  & counter>480 & year<2012, xaxis(2) ///
legend(label(1 "Argentina") label(2 "Brazil") label(3 "Chile") label(4 "Korea") label(5 "Peru")) ///
xline(597,lp(dash)) /// Brazil IOF 2%, Oct 2009
xline(598,lp(dash)) /// S. Korea and Brazil, Nov 2009
xline(600,lp(dash)) /// Peru, Jan 2010
xline(601,lp(dash)) /// Peru, Feb 2010
xline(605,lp(dash)) /// Peru, S. Korea, June 2010
xline(607,lp(solid)) /// QE2, Aug 2010
xline(609,lp(dash))  /// Brazil IOF 6%, Oct 2010
xline(610,lp(dash)) /// S. Korea, Nov 2010
xline(611,lp(dash)) /// S. Korea, Dec 2010
xline(612,lp(dash)) /// S. Korea and Brazil, Jan 2011
xline(615,lp(dash)) /// Brazil, Apr 2011
xline(618,lp(dash)) /// S. Korea, July 2011
xline(621,lp(dash)) /// Argentina, Oct 2011
xscale(range(594 623) axis(1)) ///
xscale(range(594 623) axis(2)) /// 
xlab(597 "B Oct" 598 "K,B Nov" 600 "P, Jan" 601 "P Feb" 605 "K,P Jun" 607 "QE2 Aug" 609 "B Oct" 610 "K Nov" 611 "K Dec" 612 "B,K Jan " 615 "B Apr" 618 "K Jul" 621 "A Oct", axis(1) angle(270)) ///
title("Figure 4: Inflow Controls and Exchange Rates Around QE2")  



