clear
use C:\data\Kcntrl\data\MasterCtQuinnEcon.dta
capture save c:\data\Kcntrl\data\KleinBPEAFig3.dta, replace
*
sort country year
*
keep if year > 1994 & year < 2011
*
gen mmadv = mmi if adv == 1
gen boadv = boi if adv == 1
gen fcadv = fci if adv == 1
gen eqadv = eqi if adv == 1
gen ciadv = cii if adv == 1
gen diadv = dii if adv == 1
*
gen mmeme = mmi if eme == 1 
gen boeme = boi if eme == 1 
gen fceme = fci if eme == 1 
gen eqeme = eqi if eme == 1 
gen cieme = cii if eme == 1 
gen dieme = dii if eme == 1 
*
gen mmboadv = mmadv if year < 1997
replace mmboadv = (mmadv + boadv)/2 if year > 1996 
gen fceqciadv = (fcadv + eqadv + ciadv)/3
*
gen mmboeme = mmeme if year < 1997
replace mmboeme = (mmeme + boeme)/2 if year > 1996 
gen fceqcieme = (fceme + eqeme + cieme)/3
*
label variable mmboadv "Debt Securities"
label variable fceqciadv "Portfolio Equity and Bank Credit"
label variable diadv "Direct Investment"
*
label variable mmboeme "Debt Securities"
label variable fceqcieme "Portfolio Equity and Bank Credit"
label variable dieme "Direct Investment"
*
collapse mmboadv mmboeme fceqciadv fceqcieme diadv dieme, by(year)
*
list year mmboadv fceqciadv diadv mmboeme fceqcieme dieme
graph twoway line mmboadv diadv fceqciadv year, title("Figure 3a: Inflow Controls, 23 Advanced Countries") t2("Average of Countries' Indicators, by Categories")
graph twoway line mmboeme dieme fceqcieme year, title("Figure 3b: Inflow Controls, 21 Emerging Market Countries") t2("Average of Countries' Indicators, by Categories")



