cd ${AUdir}/rawdata

use Combined_j110c.dta

//designates the person with the lowest person number in the household
// about 130 households don't have a person tagged as number 1
destring jhhpno, replace
bysort jhhrhid: egen lowestpersonnum = min(jhhpno)
keep if jhhpno == lowestpersonnum
gen fwgt = jhhwth

////////////////////////////////////////////////////////////////////////////////
// household derived gross wages and salaries
gen hh_earnings = jhiwsfei
gen hh_selfy = jhibifip - jhibifin

// Aus. Gov Parenting payment + allowances + other regular public payments
// + other domestic gov't benefits and Aus. gov NEI to classify + private 
// transfers + gov pensions
gen benefits = jhifpari + jhifalli + jhifrpi + jhifobi + jhifpti + jhifpeni

gen labinc = hh_earnings+benefits
gen labincplus = hh_earnings+hh_selfy+benefits
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// credit variables

gen hascc = (jhwccdti > 0)
gen ccdebt = jhwccdti
gen ccdebt_reg = ccdebt
replace ccdebt_reg = 0 if jcrpebm ~= 5

// direct question
gen htm1 = jfisave == 1 | jfisave == 2 

// making var names match SCF categories
gen call = 0
gen checking = jhwtbani
gen stocks = jhweqini
gen bonds = jhwcaini
gen nmmf = 0
gen deq = 0
gen houses = jhwhmvai
gen oresre = jhwopvai
gen nnresre = 0
gen cds = 0

// home equity loans
gen mrthel = 0
gen resdbt = jhwtpdi

gen vehic = jhwvechi
gen savbnd = 0
gen retqliq = jhwsupei
gen cashli = jhwinsui

// collectibles
gen othnfin = jhwcolli
// trust funds
gen othfin = jhwtrusi 

// othdbt is student and other loans
gen othdbt = jhwhecdi + jhwothdi

gen bus = jhwbusvi - jhwbusdi

gen networth = jhwnwip - jhwnwin
gen misc_illiq = othnfin
////////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////////
// demographics
gen age = jhgage1
gen children = (jtchad > 0)
gen working = (jesbrd == 1)
gen college = (jedhigh <= 3 & jedhigh ~= -10)
gen married = (jmrcms == 1)
gen govfrac = benefits/labinc
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
gen labincwork = .
replace labincwork = labinc if age<=59


*-----------------
*DEFINITIONS
*-----------------
gen cashfrac 	= 139/2500 // from US
gen liqpos      = (call + checking)*(1+cashfrac)
gen liqneg      = ccdebt
gen direct      = nmmf + stocks + bond
gen direct_eq   = deq
gen direct_bond = direct - deq
gen housepos    = houses + oresre + nnresre
gen houseneg    = mrthel + resdbt
gen nethouse    = housepos - houseneg
gen netcars     = vehic
gen sb          = savbnd
gen certdep     = cds
gen retacc      = retqliq
gen lifeins     = cashli
gen netbus      = bus

// baseline
gen brliqpos      = liqpos + direct
gen brliqneg      = ccdebt
gen netbrliq      = brliqpos - brliqneg
gen brilliqpos    = housepos + netcars + certdep + retacc + lifeins
gen brilliqneg    = houseneg
gen netbrilliq    = brilliqpos - brilliqneg
gen netbrilliqnc  = netbrilliq - netcars
gen networthnc  = netbrilliqnc + netbrliq

// adds cars as illiquid
gen netbrilliqcars = netbrilliqnc + netcars
gen networthcars = netbrilliqnc + netbrliq + netcars

// adds businesses as illiquid
gen netbrilliqbusnc = netbrilliqnc + netbus
gen networthbusnc  = netbrilliqbusnc + netbrliq

// adds other valuables as illiquid
gen netbrilliqncmisc = netbrilliqnc + misc_illiq
gen networthncmisc = networthnc + misc_illiq


// puts retirement accounts in liquid assets for retirees
gen netbrliq_retirees = netbrliq
replace netbrliq_retirees = netbrliq + retacc if age >= 60
gen netbrilliqnc_retirees = netbrilliqnc
replace netbrilliqnc_retirees = netbrilliqnc - retacc if age >= 60

// puts stocks into illiquid
gen netbrliqnstocks = netbrliq - direct
gen netbrilliqncstocks = netbrilliqnc + direct
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// creates 5 year age bins
gen agedum = 0
replace agedum = 1 if age >= 22 & age <= 24
replace agedum = 2 if age >= 25 & age <= 29
replace agedum = 3 if age >= 30 & age <= 34
replace agedum = 4 if age >= 35 & age <= 39
replace agedum = 5 if age >= 40 & age <= 44
replace agedum = 6 if age >= 45 & age <= 49
replace agedum = 7 if age >= 50 & age <= 54
replace agedum = 8 if age >= 55 & age <= 59
replace agedum = 9 if age >= 60 & age <= 64
replace agedum = 10 if age >= 65 & age <= 69
replace agedum = 11 if age >= 70 & age <= 74
replace agedum = 12 if age >= 75 & age <= 79

label define l_age 1 "22-24", add
label define l_age 2 "25-29", add 
label define l_age 3 "30-34", add
label define l_age 4 "35-39", add
label define l_age 5 "40-44", add
label define l_age 6 "45-49", add
label define l_age 7 "50-54", add
label define l_age 8 "55-59", add
label define l_age 9 "60-64", add
label define l_age 10 "65-69", add
label define l_age 11 "70-74", add
label define l_age 12 "75-79", add
label values agedum l_age

////////////////////////////////////////////////////////////////////////////////
cd ${AUdir}/cleandata
save HILDA_Wj_cleaned.dta, replace
