/* //////////////////////////////////////////////////////////////////////////////
Code written by Justin Weidner for The Wealthy Hand-to-Mouth
4/16/2014
Purpose of the code is to import the raw data files, and get the relevant 
wealth and income variables for calculation of HtM status
*/ //////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// 0. Housekeeping
clear*
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// 1. Global macros for file paths
// Change rawdir to the appropriate file path
global rawdir "/Users/jweidner/Desktop/to_Brookings"
global progdir "${rawdir}/prog"
global USdir "${rawdir}/SCF"
global UKdir "${rawdir}/WAS"
global CAdir "${rawdir}/SFS"
global EUdir "${rawdir}/HFCS"
global AUdir "${rawdir}/HILDA"
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// 2. Clean survey files

////////////////////////////////////////////////////////////////////////////////
// 2a. US

// Appends each year's extract and full data sets
cd ${USdir}/prog
do scf_mergeyear_mergevar.do

// Defines relevant variables for the HtM calculations
cd ${USdir}/prog
do scf_gendata.do

// does this for the panel data
cd ${USdir}/prog
do scf_panel_mergeyear_mergevar.do
cd ${USdir}/prog
do scf_panel_gendata.do
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// 2b. UK

// Defines relevant variables for the HtM calculations
cd ${UKdir}/prog
do was_W2_gendata.do
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// 2c. CA

// Defines relevant variables for the HtM calculations
cd ${CAdir}/prog
do sfs2005_gendata.do
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// 2d. AU

// Defines relevant variables for the HtM calculations
cd ${AUdir}/prog
do HILDA_Wj_gendata.do
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// 2e. EU
// Appends each year's extract and full data sets
cd ${EUdir}/prog
do hfcs_mergevar.do

// Defines relevant variables for the HtM calculations
cd ${EUdir}/prog
do hfcs_gendata.do
////////////////////////////////////////////////////////////////////////////////
