cd ${UKdir}/rawdata

////////////////////////////////////////////////////////////////////////////////
use was_wave_2_person_eul.dta
merge m:1 CASEW2 using was_wave_2_hhold_eul.dta
rename XS_calwgtW2 fwgt

////////////////////////////////////////////////////////////////////////////////
// stuff that we need to sum over the individuals in the HH
rename DVGrsPayW2 hh_earnings
rename DVNetPayW2 hh_earnings_net

replace hh_earnings = 0 if hh_earnings < 0
replace hh_earnings_net = 0 if hh_earnings_net < 0

replace hh_earnings = hh_earnings + SjGrsW2*(SjGrsW2>0)*12
replace hh_earnings_net = hh_earnings_net + SjNetW2*(SjNetW2>0)*12

replace GrsSEMJbW2 = 0 if GrsSEMJbW2 < 0
replace GrossPer = 0 if GrossPer == 97

gen hh_selfy = GrsSEMJbW2*(GrossPer/52)

// annual benefits (amt * period)
gen ben1 = BAmtW2
replace ben1 = 0 if BPdW2 >= 52 | BPdW2 <= 0 
replace ben1 = ben1 * 52/BPdW2 if BPdW2 > 10 | BPdW2 < 5
replace ben1 = ben1 * 12 if BPdW2 == 5
replace ben1 = ben1 * 6 if BPdW2 == 7
replace ben1 = ben1 * BPdW2 if BPdW2 >= 8 & BPdW2 <= 10

foreach k of numlist 2(1)18 {
gen ben`k' = BAmt`k'W2
replace ben`k' = 0 if BPd`k'W2 >= 52 | BPd`k'W2 <= 0 
replace ben`k' = ben`k'*52/BPd`k'W2 if BPd`k'W2 > 10 | BPd`k'W2 < 5
replace ben`k' = ben`k'*12 if BPd`k'W2 == 5
replace ben`k' = ben`k'*6 if BPd`k'W2 == 7
replace ben`k' = ben`k'*BPd`k'W2 if BPd`k'W2 >= 8 & BPd`k'W2 <= 10
}
gen benefits = ben1+ben2+ben3+ben4+ben5+ben6+ben7+ben8+ben9+ben10+ben11+ben12+ ///
ben13+ben14+ben15+ben16+ben17+ben18

gen labinc = hh_earnings+benefits
gen labincplus = hh_earnings+hh_selfy+benefits
gen netlabinc = hh_earnings_net + benefits

// sums over the HH
bysort CASEW2: egen hhlabinc = total(labinc)
bysort CASEW2: egen hhnetlabinc = total(netlabinc)
bysort CASEW2: egen hhearnings = total(hh_earnings)
bysort CASEW2: egen hhearnings_net = total(hh_earnings_net)
bysort CASEW2: egen hhselfy = total(hh_selfy)
bysort CASEW2: egen hhlabincplus = total(labincplus)
bysort CASEW2: egen hhbenefits = total(benefits)

drop labinc benefits labincplus hh_selfy hh_earnings hh_earnings_net netlabinc
rename hhlabinc labinc
rename hhlabincplus labincplus
rename hhbenefits benefits
rename hhearnings hh_earnings
rename hhearnings_net hh_earnings_net
rename hhselfy hh_selfy
rename hhnetlabinc netlabinc
////////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////////
// uses derived info for HH and personal answers from the head of household
// keeps head of household
keep if PersonW2 == 1

// mortgage debt for home improvement or consumption
gen mrthel1 = 0
replace mrthel1 = MValW2_i if MReas01W2 == 2 | MReas01W2 == 3 | MReas01W2 == 9
gen mrthel2 = 0
replace mrthel2 = MVal2W2_i if MReas11W2 == 2 | MReas11W2 == 3 | MReas11W2 == 9
gen mrthel3 = 0
replace mrthel3 = MVal3W2_i if MReas21W2 == 2 | MReas21W2 == 3 | MReas21W2 == 9
gen mrthel = mrthel1 + mrthel2 + mrthel3

// credit cards count credit card, store card, hire purchases, and mail orders
gen hascc = (HASCCW2 == 1 | HASCCW2 == 2 | HASSCW2 == 1 | HASSCW2 == 2 | HASHPW2 == 1 | HASMOW2 == 1)
gen ccdebt = TOTCCW2_sum + TOTHPW2_sum + TOTMOW2_sum + TOTSCW2_sum

// direct question
gen htm1 =  OSavA==3 | OSavA==4 | OSavA == 5

// making variables match categories put down for SCF
rename DVISAValW2_sum call
rename DVSAValW2_sum checking
gen nmmf = 0
gen stocks = DVFShUKVW2_sum + DVFShOSVW2_sum
gen bonds = DVFGltUKVW2_sum + DVFGltFOVW2_sum + DVFBondVW2_sum + DVFCollVW2_sum
rename DVFESharesW2_sum deq
rename DVHValueW2 houses
rename DVHseValW2 oresre
gen nnresre = DVOPrValW2 + DVLUKValW2
gen cds = 0

// less home equity loans
gen resdbt = TotMortW2 + DVHseDebtW2 + DVLUKDebtW2 + DVOPrDebtW2 - mrthel

rename DVTotVehValW2 vehic
rename DVFNSValW2_sum savbnd
rename TOTPENW2_sum retqliq
rename DVInsVW2_sum cashli

gen othnfin = DVGCollVW2 + HousGdsTW2_Sum
gen othfin = DVFInfValW2_sum + DVFInvOtVW2_sum

// othdbt is student, formal, and informal loans
rename TOTLOSW2_sum othdbt

rename BvalW2 bus

rename TotWlthW2 networth

gen misc_illiq = othnfin

////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// demographics
rename DVAge17W2 agedum
rename NumDepCh_HHW2 children
gen working = (DVILO3aW2 == 1)
gen college = (EdLevelW2 == 1)
// married is married or civil partner
gen married = (DVMrDFW2 == 1 | DVMrDFW2 == 8)
gen govfrac = benefits/labinc
////////////////////////////////////////////////////////////////////////////////

gen labincwork = .
replace labincwork = labinc if agedum<=12

*-----------------
*DEFINITIONS
*-----------------
gen cashfrac 	= 139/2500 // from US
gen liqpos      = (call + checking)*(1+cashfrac)
gen liqneg      = ccdebt
gen direct      = nmmf + stocks + bond
gen housepos    = houses + oresre + nnresre
gen houseneg    = resdbt + mrthel
gen nethouse    = housepos - houseneg
gen heloc_lim   = nethouse + mrthel
gen netcars     = vehic
gen sb          = savbnd
gen certdep     = 0
gen retacc      = retqliq
gen lifeins     = cashli
gen netbus      = bus

// baseline
gen brliqpos      = liqpos + direct
gen brliqneg      = ccdebt
gen netbrliq      = brliqpos - brliqneg
gen brilliqpos    = housepos + netcars + certdep + retacc + lifeins
gen brilliqneg    = houseneg
gen netbrilliq    = brilliqpos - brilliqneg
gen netbrilliqnc  = netbrilliq - netcars
gen networthnc  = netbrilliqnc + netbrliq

// adds cars as illiquid
gen netbrilliqcars = netbrilliqnc + netcars
gen networthcars = netbrilliqnc + netbrliq + netcars

// adds businesses as illiquid
gen netbrilliqbusnc = netbrilliqnc + netbus
gen networthbusnc  = netbrilliqbusnc + netbrliq

// adds other valuables as illiquid
gen netbrilliqncmisc = netbrilliqnc + misc_illiq
gen networthncmisc = networthnc + misc_illiq

// takes HELOCs out of illiquid debt and puts it in liquid debt
gen netbrliqheloc = netbrliq - mrthel
gen netbrilliqncheloc = netbrilliqnc + mrthel

// puts retirement accounts in liquid assets for retirees
gen netbrliq_retirees = netbrliq
replace netbrliq_retirees = netbrliq + retacc if agedum >= 13
gen netbrilliqnc_retirees = netbrilliqnc
replace netbrilliqnc_retirees = netbrilliqnc - retacc if agedum >= 13

// puts stocks into illiquid
gen netbrliqnstocks = netbrliq - direct
gen netbrilliqncstocks = netbrilliqnc + direct
////////////////////////////////////////////////////////////////////////////////

cd ${UKdir}/cleandata
save WAS_W2_cleaned.dta, replace
