cd ${CAdir}/rawdata

// imports data from flat file and labels everything appropriately
do ${CAdir}/prog/sub_importdata_2005.do

rename WEIGHT fwgt
////////////////////////////////////////////////////////////////////////////////

rename ATINC27 hh_earnings
rename GTR27 transfers

gen labinc = hh_earnings

// number of people in the HH in certain age groups
gen num17minus = (ECFSZ0004==1) | (ECFSZ0517==1)
gen num1824 = (ECFSZ1824==1)
gen num2564 = (ECFSZ2544==1) | (ECFSZ4564==1)
gen num65plus = (ECFSZ65PL==1)

// htm if spending is equal to or exceeds income
gen htm1= (ATTSPD==1 | ATTSPD==2 )

// making var names match SCF categories
// assets (see table 3-1) in SFS documentation
rename WASTDEPT checking
rename WASTMUIC nmmf
rename WASTSTCK stocks 
rename WASTBOND bonds
rename WBUSEQ bus
rename WAPRVAL houses
rename WASTREST oresre

gen vehic = WASTVHLE - WDSTVHLN
rename WARRSPL savbnd
rename WARRIF retqliq
rename WARPPT reteq
rename WAOTPEN cashli

rename WASTOINP othfin
rename WASTONOF othnfin
gen misc_illiq = othnfin

// debts
gen resdbt = WDPRMOR + WDSTOMOR
rename WDSTLOC heloc

// credit cards and installment debt
// 9 is not applicable
gen hascc = (ATTCRC == 1)
rename WDSTCRED ccdebt
gen ccdebt_reg = ccdebt
replace ccdebt_reg = 0 if ATTCRP ~= 1


// othdbt is student, vehicle, and other loans
gen othdbt = WDSLOAN + WDSTODBT

// networth
rename WNETWPT networth

////////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////////
// demographics
rename ECPAGE age
gen children = (ECFSZ0004 == 1) | (ECFSZ0517 == 1)
gen working = (NBEAR27 >= 1)
gen college = (DVPHLV2G == 4)
// married is married or civil partner
gen married = (DVFMCOMP == 2 | DVFMCOMP == 3)
gen govfrac = transfers/labinc
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
gen labincwork = .
replace labincwork = labinc if age<=59

*-----------------
*DEFINITIONS
*-----------------
gen cashfrac 	= 139/2500 // from US
gen liqpos      = checking*(1+cashfrac)
gen liqneg      = ccdebt
gen direct      = nmmf + stocks + bond
gen housepos    = houses + oresre
gen houseneg    = resdbt + heloc
gen nethouse    = housepos - houseneg
gen heloc_lim 	= nethouse + heloc
replace heloc_lim = 0 if heloc_lim < 0
gen netcars     = vehic
gen sb          = savbnd
gen certdep     = 0
gen retacc      = retqliq + reteq
gen lifeins     = cashli
gen netbus      = bus

// baseline
gen brliqpos      = liqpos + direct
gen brliqneg      = ccdebt
gen netbrliq      = brliqpos - brliqneg
gen brilliqpos    = housepos + netcars + certdep + retacc + lifeins
gen brilliqneg    = houseneg
gen netbrilliq    = brilliqpos - brilliqneg
gen netbrilliqnc  = netbrilliq - netcars
gen networthnc  = netbrilliqnc + netbrliq

// adds cars as illiquid
gen netbrilliqcars = netbrilliqnc + netcars
gen networthcars = netbrilliqnc + netbrliq + netcars

// adds businesses as illiquid
gen netbrilliqbusnc = netbrilliqnc + netbus
gen networthbusnc  = netbrilliqbusnc + netbrliq

// adds other valuables as illiquid
gen netbrilliqncmisc = netbrilliqnc + misc_illiq
gen networthncmisc = networthnc + misc_illiq

// takes HELOCs out of illiquid debt and puts it in liquid debt
gen netbrliqheloc = netbrliq - heloc
gen netbrilliqncheloc = netbrilliqnc + heloc

// puts retirement accounts in liquid assets for retirees
gen netbrliq_retirees = netbrliq
replace netbrliq_retirees = netbrliq + retacc if age >= 60
gen netbrilliqnc_retirees = netbrilliqnc
replace netbrilliqnc_retirees = netbrilliqnc - retacc if age >= 60

// puts stocks into illiquid
gen netbrliqnstocks = netbrliq - direct
gen netbrilliqncstocks = netbrilliqnc + direct
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// creates 5 year age bins
gen agedum = 0
replace agedum = 1 if age >= 22 & age <= 24
replace agedum = 2 if age >= 25 & age <= 29
replace agedum = 3 if age >= 30 & age <= 34
replace agedum = 4 if age >= 35 & age <= 39
replace agedum = 5 if age >= 40 & age <= 44
replace agedum = 6 if age >= 45 & age <= 49
replace agedum = 7 if age >= 50 & age <= 54
replace agedum = 8 if age >= 55 & age <= 59
replace agedum = 9 if age >= 60 & age <= 64
replace agedum = 10 if age >= 65 & age <= 69
replace agedum = 11 if age >= 70 & age <= 74
replace agedum = 12 if age >= 75 & age <= 79

label define l_age 1 "22-24", add
label define l_age 2 "25-29", add 
label define l_age 3 "30-34", add
label define l_age 4 "35-39", add
label define l_age 5 "40-44", add
label define l_age 6 "45-49", add
label define l_age 7 "50-54", add
label define l_age 8 "55-59", add
label define l_age 9 "60-64", add
label define l_age 10 "65-69", add
label define l_age 11 "70-74", add
label define l_age 12 "75-79", add
label values agedum l_age
////////////////////////////////////////////////////////////////////////////////

cd ${CAdir}/cleandata
save SFS2005_cleaned.dta, replace
