clear all
set mem 20g
set more off
use bigphrase23panel_replication.dta

tsset phrasenum congress
cd "Pics_Tables"
gen post1941=year>=1941
drop if year >2000

log using "panel_sumstatsTable5.log",replace
sum meanpol if L3cfreqXpctile2550meanpol!=.,d 
sum googlefreq cfreq economic_narrow economic_broad social post1941 if L3cfreqXpctile2550meanpol!=.
log close




/***********************************************************************
*****Put Google frequencies on the LHS of the regression*****
***********************************************************************/

eststo clear
xtreg googlefreq L*cfreq L*cfreqXpctile* _I*, fe  cluster(phrasenum)
eststo
lincom   L1cfreq + L2cfreq+ L3cfreq
estadd scalar congfreqlagsum =`r(estimate)'
estadd scalar congfreqlagsum_se =`r(se)'

lincom   L1cfreqXpctile2550meanpol + L2cfreqXpctile2550meanpol+ L3cfreqXpctile2550meanpol
estadd scalar congfreqlagsum2550_pctile =`r(estimate)'
estadd scalar congfreqlagsum2550_pctile_se =`r(se)'

lincom   L1cfreqXpctile5075meanpol + L2cfreqXpctile5075meanpol+ L3cfreqXpctile5075meanpol
estadd scalar congfreqlagsum5075_pctile =`r(estimate)'
estadd scalar congfreqlagsum5075_pctile_se =`r(se)'

lincom  L1cfreqXpctile75100meanpol + L2cfreqXpctile75100meanpol+ L3cfreqXpctile75100meanpol
estadd scalar congfreqlagsum75100_pctile =`r(estimate)'
estadd scalar congfreqlagsum75100_pctile_se =`r(se)'

		
xtreg googlefreq L*cfreq L*cfreqXpctile* L1googlefreq L2googlefreq L3googlefreq _I*, fe  cluster(phrasenum)
eststo
lincom L1cfreq + L2cfreq+ L3cfreq
estadd scalar congfreqlagsum =`r(estimate)'
estadd scalar congfreqlagsum_se =`r(se)'

lincom  L1cfreqXpctile2550meanpol + L2cfreqXpctile2550meanpol+ L3cfreqXpctile2550meanpol
estadd scalar congfreqlagsum2550_pctile =`r(estimate)'
estadd scalar congfreqlagsum2550_pctile_se =`r(se)'

lincom  L1cfreqXpctile5075meanpol + L2cfreqXpctile5075meanpol+ L3cfreqXpctile5075meanpol
estadd scalar congfreqlagsum5075_pctile =`r(estimate)'
estadd scalar congfreqlagsum5075_pctile_se =`r(se)'

lincom  L1cfreqXpctile75100meanpol + L2cfreqXpctile75100meanpol+ L3cfreqXpctile75100meanpol
estadd scalar congfreqlagsum75100_pctile =`r(estimate)'
estadd scalar congfreqlagsum75100_pctile_se =`r(se)'

xtreg googlefreq L*cfreq L*cfreqXpctile* L1googlefreq L2googlefreq L3googlefreq _I* if year<1941, fe cluster(phrasenum)
eststo
lincom   L1cfreq + L2cfreq+ L3cfreq
estadd scalar congfreqlagsum =`r(estimate)'
estadd scalar congfreqlagsum_se =`r(se)'

lincom  L1cfreqXpctile2550meanpol + L2cfreqXpctile2550meanpol+ L3cfreqXpctile2550meanpol
estadd scalar congfreqlagsum2550_pctile =`r(estimate)'
estadd scalar congfreqlagsum2550_pctile_se =`r(se)'

lincom  L1cfreqXpctile5075meanpol + L2cfreqXpctile5075meanpol+ L3cfreqXpctile5075meanpol
estadd scalar congfreqlagsum5075_pctile =`r(estimate)'
estadd scalar congfreqlagsum5075_pctile_se =`r(se)'

lincom  L1cfreqXpctile75100meanpol + L2cfreqXpctile75100meanpol+ L3cfreqXpctile75100meanpol
estadd scalar congfreqlagsum75100_pctile =`r(estimate)'
estadd scalar congfreqlagsum75100_pctile_se =`r(se)'

xtreg googlefreq L*cfreq L*cfreqXpctile* L1googlefreq L2googlefreq L3googlefreq _I* if year>=1941, fe cluster(phrasenum)
eststo
lincom  L1cfreq + L2cfreq+ L3cfreq
estadd scalar congfreqlagsum =`r(estimate)'
estadd scalar congfreqlagsum_se =`r(se)'

lincom   L1cfreqXpctile2550meanpol + L2cfreqXpctile2550meanpol+ L3cfreqXpctile2550meanpol
estadd scalar congfreqlagsum2550_pctile =`r(estimate)'
estadd scalar congfreqlagsum2550_pctile_se =`r(se)'

lincom  L1cfreqXpctile5075meanpol + L2cfreqXpctile5075meanpol+ L3cfreqXpctile5075meanpol
estadd scalar congfreqlagsum5075_pctile =`r(estimate)'
estadd scalar congfreqlagsum5075_pctile_se =`r(se)'

lincom L1cfreqXpctile75100meanpol + L2cfreqXpctile75100meanpol+ L3cfreqXpctile75100meanpol
estadd scalar congfreqlagsum75100_pctile =`r(estimate)'
estadd scalar congfreqlagsum75100_pctile_se =`r(se)'

xtreg googlefreq L*cfreq L*cfreqXpctile* L1googlefreq L2googlefreq L3googlefreq _I* if economic_narrow==1, fe cluster(phrasenum)
eststo
lincom   L1cfreq + L2cfreq+ L3cfreq
estadd scalar congfreqlagsum =`r(estimate)'
estadd scalar congfreqlagsum_se =`r(se)'

lincom  L1cfreqXpctile2550meanpol + L2cfreqXpctile2550meanpol+ L3cfreqXpctile2550meanpol
estadd scalar congfreqlagsum2550_pctile =`r(estimate)'
estadd scalar congfreqlagsum2550_pctile_se =`r(se)'

lincom L1cfreqXpctile5075meanpol + L2cfreqXpctile5075meanpol+ L3cfreqXpctile5075meanpol
estadd scalar congfreqlagsum5075_pctile =`r(estimate)'
estadd scalar congfreqlagsum5075_pctile_se =`r(se)'

lincom  L1cfreqXpctile75100meanpol + L2cfreqXpctile75100meanpol+ L3cfreqXpctile75100meanpol
estadd scalar congfreqlagsum75100_pctile =`r(estimate)'
estadd scalar congfreqlagsum75100_pctile_se =`r(se)'

xtreg googlefreq L*cfreq L*cfreqXpctile* L1googlefreq L2googlefreq L3googlefreq  _I* if economic_broad==1, fe cluster(phrasenum)
eststo
lincom  L1cfreq + L2cfreq+ L3cfreq
estadd scalar congfreqlagsum =`r(estimate)'
estadd scalar congfreqlagsum_se =`r(se)'

lincom   L1cfreqXpctile2550meanpol + L2cfreqXpctile2550meanpol+ L3cfreqXpctile2550meanpol
estadd scalar congfreqlagsum2550_pctile =`r(estimate)'
estadd scalar congfreqlagsum2550_pctile_se =`r(se)'

lincom   L1cfreqXpctile5075meanpol + L2cfreqXpctile5075meanpol+ L3cfreqXpctile5075meanpol
estadd scalar congfreqlagsum5075_pctile =`r(estimate)'
estadd scalar congfreqlagsum5075_pctile_se =`r(se)'

lincom  L1cfreqXpctile75100meanpol + L2cfreqXpctile75100meanpol+ L3cfreqXpctile75100meanpol
estadd scalar congfreqlagsum75100_pctile =`r(estimate)'
estadd scalar congfreqlagsum75100_pctile_se =`r(se)'

xtreg googlefreq L*cfreq L*cfreqXpctile* L1googlefreq L2googlefreq L3googlefreq  _I* if social==1, fe cluster(phrasenum)
eststo
lincom   L1cfreq + L2cfreq+ L3cfreq
estadd scalar congfreqlagsum =`r(estimate)'
estadd scalar congfreqlagsum_se =`r(se)'

lincom   L1cfreqXpctile2550meanpol + L2cfreqXpctile2550meanpol+ L3cfreqXpctile2550meanpol
estadd scalar congfreqlagsum2550_pctile =`r(estimate)'
estadd scalar congfreqlagsum2550_pctile_se =`r(se)'

lincom   L1cfreqXpctile5075meanpol + L2cfreqXpctile5075meanpol+ L3cfreqXpctile5075meanpol
estadd scalar congfreqlagsum5075_pctile =`r(estimate)'
estadd scalar congfreqlagsum5075_pctile_se =`r(se)'

lincom   L1cfreqXpctile75100meanpol + L2cfreqXpctile75100meanpol+ L3cfreqXpctile75100meanpol
estadd scalar congfreqlagsum75100_pctile =`r(estimate)'
estadd scalar congfreqlagsum75100_pctile_se =`r(se)' 


#delimit;
esttab using phrase23_googleregsdynamics3lag.csv, keep(L*) se label replace r2 
order(L*cfreq *pctile2550*  *pctile5075* *pctile75100*)
scalar(congfreqlagsum congfreqlagsum_se congfreqlagsum2550_pctile congfreqlagsum2550_pctile_se congfreqlagsum5075_pctile congfreqlagsum5075_pctile_se congfreqlagsum75100_pctile congfreqlagsum75100_pctile_se)
;
#delimit cr


type phrase23_googleregsdynamics3lag.csv
/***********************************************************************
*****Now put congress frequencies on the LHS of the regression*****
***********************************************************************/
eststo clear
xtreg cfreq L*googlefreq L*googlefreqXpctile*   _I*, fe cluster(phrasenum)
eststo
lincom  L1googlefreq + L2googlefreq+ L3googlefreq
estadd scalar googlelagsum =`r(estimate)'
estadd scalar googlelagsum_se =`r(se)'

lincom  L1googlefreqXpctile2550meanpol + L2googlefreqXpctile2550meanpol+ L3googlefreqXpctile2550meanpol
estadd scalar googlelagsum2550_pctile =`r(estimate)'
estadd scalar googlelagsum2550_pctile_se =`r(se)'

lincom  L1googlefreqXpctile5075meanpol + L2googlefreqXpctile5075meanpol+ L3googlefreqXpctile5075meanpol
estadd scalar googlelagsum5075_pctile =`r(estimate)'
estadd scalar googlelagsum5075_pctile_se =`r(se)'

lincom  L1googlefreqXpctile75100meanpol + L2googlefreqXpctile75100meanpol+ L3googlefreqXpctile75100meanpol
estadd scalar googlelagsum75100_pctile =`r(estimate)'
estadd scalar googlelagsum75100_pctile_se =`r(se)' 

xtreg cfreq L*googlefreq L*googlefreqXpctile* L1cfreq L2cfreq L3cfreq   _I*, fe cluster(phrasenum)
eststo
lincom  L1googlefreq + L2googlefreq+ L3googlefreq
estadd scalar googlelagsum =`r(estimate)'
estadd scalar googlelagsum_se =`r(se)'

lincom  L1googlefreqXpctile2550meanpol + L2googlefreqXpctile2550meanpol+ L3googlefreqXpctile2550meanpol
estadd scalar googlelagsum2550_pctile =`r(estimate)'
estadd scalar googlelagsum2550_pctile_se =`r(se)'

lincom   L1googlefreqXpctile5075meanpol + L2googlefreqXpctile5075meanpol+ L3googlefreqXpctile5075meanpol
estadd scalar googlelagsum5075_pctile =`r(estimate)'
estadd scalar googlelagsum5075_pctile_se =`r(se)'

lincom   L1googlefreqXpctile75100meanpol + L2googlefreqXpctile75100meanpol+ L3googlefreqXpctile75100meanpol
estadd scalar googlelagsum75100_pctile =`r(estimate)'
estadd scalar googlelagsum75100_pctile_se =`r(se)' 

xtreg cfreq L*googlefreq L*googlefreqXpctile* L1cfreq L2cfreq L3cfreq   _I* if year <1941, fe cluster(phrasenum)
eststo
lincom   L1googlefreq + L2googlefreq+ L3googlefreq
estadd scalar googlelagsum =`r(estimate)'
estadd scalar googlelagsum_se =`r(se)'

lincom   L1googlefreqXpctile2550meanpol + L2googlefreqXpctile2550meanpol+ L3googlefreqXpctile2550meanpol
estadd scalar googlelagsum2550_pctile =`r(estimate)'
estadd scalar googlelagsum2550_pctile_se =`r(se)'

lincom   L1googlefreqXpctile5075meanpol + L2googlefreqXpctile5075meanpol+ L3googlefreqXpctile5075meanpol
estadd scalar googlelagsum5075_pctile =`r(estimate)'
estadd scalar googlelagsum5075_pctile_se =`r(se)'

lincom L1googlefreqXpctile75100meanpol + L2googlefreqXpctile75100meanpol+ L3googlefreqXpctile75100meanpol
estadd scalar googlelagsum75100_pctile =`r(estimate)'
estadd scalar googlelagsum75100_pctile_se =`r(se)' 

xtreg cfreq L*googlefreq L*googlefreqXpctile* L1cfreq L2cfreq L3cfreq   _I* if year >=1941, fe cluster(phrasenum)
eststo
lincom  L1googlefreq + L2googlefreq+ L3googlefreq
estadd scalar googlelagsum =`r(estimate)'
estadd scalar googlelagsum_se =`r(se)'

lincom  L1googlefreqXpctile2550meanpol + L2googlefreqXpctile2550meanpol+ L3googlefreqXpctile2550meanpol
estadd scalar googlelagsum2550_pctile =`r(estimate)'
estadd scalar googlelagsum2550_pctile_se =`r(se)'

lincom  L1googlefreqXpctile5075meanpol + L2googlefreqXpctile5075meanpol+ L3googlefreqXpctile5075meanpol
estadd scalar googlelagsum5075_pctile =`r(estimate)'
estadd scalar googlelagsum5075_pctile_se =`r(se)'

lincom   L1googlefreqXpctile75100meanpol + L2googlefreqXpctile75100meanpol+ L3googlefreqXpctile75100meanpol
estadd scalar googlelagsum75100_pctile =`r(estimate)'
estadd scalar googlelagsum75100_pctile_se =`r(se)' 

xtreg cfreq L*googlefreq L*googlefreqXpctile* L1cfreq L2cfreq L3cfreq   _I* if economic_narrow==1, fe  cluster(phrasenum)
eststo
lincom L1googlefreq + L2googlefreq+ L3googlefreq
estadd scalar googlelagsum =`r(estimate)'
estadd scalar googlelagsum_se =`r(se)'

lincom   L1googlefreqXpctile2550meanpol + L2googlefreqXpctile2550meanpol+ L3googlefreqXpctile2550meanpol
estadd scalar googlelagsum2550_pctile =`r(estimate)'
estadd scalar googlelagsum2550_pctile_se =`r(se)'

lincom  L1googlefreqXpctile5075meanpol + L2googlefreqXpctile5075meanpol+ L3googlefreqXpctile5075meanpol
estadd scalar googlelagsum5075_pctile =`r(estimate)'
estadd scalar googlelagsum5075_pctile_se =`r(se)'

lincom   L1googlefreqXpctile75100meanpol + L2googlefreqXpctile75100meanpol+ L3googlefreqXpctile75100meanpol
estadd scalar googlelagsum75100_pctile =`r(estimate)'
estadd scalar googlelagsum75100_pctile_se =`r(se)' 

xtreg cfreq L*googlefreq L*googlefreqXpctile* L1cfreq L2cfreq L3cfreq   _I* if economic_broad==1, fe cluster(phrasenum)
eststo
lincom  L1googlefreq + L2googlefreq+ L3googlefreq
estadd scalar googlelagsum =`r(estimate)'
estadd scalar googlelagsum_se =`r(se)'

lincom   L1googlefreqXpctile2550meanpol + L2googlefreqXpctile2550meanpol+ L3googlefreqXpctile2550meanpol
estadd scalar googlelagsum2550_pctile =`r(estimate)'
estadd scalar googlelagsum2550_pctile_se =`r(se)'

lincom   L1googlefreqXpctile5075meanpol + L2googlefreqXpctile5075meanpol+ L3googlefreqXpctile5075meanpol
estadd scalar googlelagsum5075_pctile =`r(estimate)'
estadd scalar googlelagsum5075_pctile_se =`r(se)'

lincom   L1googlefreqXpctile75100meanpol + L2googlefreqXpctile75100meanpol+ L3googlefreqXpctile75100meanpol
estadd scalar googlelagsum75100_pctile =`r(estimate)'
estadd scalar googlelagsum75100_pctile_se =`r(se)' 

xtreg cfreq L*googlefreq L*googlefreqXpctile* L1cfreq L2cfreq L3cfreq   _I* if social==1, fe cluster(phrasenum)
eststo
lincom   L1googlefreq + L2googlefreq+ L3googlefreq
estadd scalar googlelagsum =`r(estimate)'
estadd scalar googlelagsum_se =`r(se)'

lincom   L1googlefreqXpctile2550meanpol + L2googlefreqXpctile2550meanpol+ L3googlefreqXpctile2550meanpol
estadd scalar googlelagsum2550_pctile =`r(estimate)'
estadd scalar googlelagsum2550_pctile_se =`r(se)'

lincom   L1googlefreqXpctile5075meanpol + L2googlefreqXpctile5075meanpol+ L3googlefreqXpctile5075meanpol
estadd scalar googlelagsum5075_pctile =`r(estimate)'
estadd scalar googlelagsum5075_pctile_se =`r(se)'

lincom   L1googlefreqXpctile75100meanpol + L2googlefreqXpctile75100meanpol+ L3googlefreqXpctile75100meanpol
estadd scalar googlelagsum75100_pctile =`r(estimate)'
estadd scalar googlelagsum75100_pctile_se =`r(se)' 

#delimit;
esttab using phrase23_congregsdynamics3lag.csv, keep(L*) se label replace r2 
order(L*googlefreq *pctile2550*  *pctile5075* *pctile75100*)
scalar(googlelagsum googlelagsum_se googlelagsum2550_pctile googlelagsum2550_pctile_se googlelagsum5075_pctile googlelagsum5075_pctile_se googlelagsum75100_pctile googlelagsum75100_pctile_se)
;
#delimit cr

type phrase23_congregsdynamics3lag.csv
