clear all
set mem 5g
set more off
use "pol23_time_series_replication.dta",clear
sort year
merge 1:1 congress using "rawdata\time_independent_vars_2013.dta",  gen(mergets)
tsset congress
drop mergets


gen decade = floor(year/10)*10
replace decade = . if year-decade>2

tsset congress
replace googlepol_all = googlepol_all*100000
replace googlepol = googlepol*100000
replace googleparti = googleparti*100000

label var googlepol_all "Political Polarization in non-American Google N-grams (X 100000)"
label var googlepol "Political Polarization in Google N-grams (X 100000)"
label var congpol "Political Polarization in Congress"
label var googleparti "Political Partisanship in Google N-grams (X 100000)"
label var congparti "Political Partisanship in Congress"

 replace realgdpgrowth = log(splicedseriesbasedondavis)- log(L2.splicedseriesbasedondavis)
*label var top1pctincsharePS "Top 1% Income Share"
label var politicalviolencepermillion "Domestic Political Violence/Million"
label var casualtiesperhundredthousand "Military Casualties/Thousand"
label var realgdpgrowth "Real GDP Growth"
label var dem_house "Number of Democratic Seats in House"

label var MLI "Legislative Production of Major Policy Changes"
label var LPI "Legislative Production of Statutes"

cd "Pics_Tables"

gen yearlabel=""
replace yearlabel="Reconstruction Ends (1877)" if year==1877
replace yearlabel="Progressive Constitution (1913)" if year==1913
replace yearlabel="New Deal (1933)" if year==1933
replace yearlabel="Voting Rights Act (1965)" if year==1965
replace yearlabel="Republican House (1995)" if year==1995


gen mprpol = (num100*abs(dwnom1100)+num200*abs(dwnom1200))
gen mprparti=num100*dwnom1100 + num200*dwnom1200
foreach v of varlist googlepol mprpol congpol congparti googleparti mprparti {
	sum `v'
	gen `v'_std= (`v'-`r(mean)')/`r(sd)' 
	sum `v'_std
	
}

label var googlepol_std "Political Polarization in Google N-grams (Stdized)"
label var congpol_std "Political Polarization in Congress (Stdized)"
label var googleparti_std "Political Partisanship in Google N-grams (Stdized)"
label var congparti_std "Political Partisanship in Congress (Stdized)"

label var mprpol_std "DW-1 Political Polarization (Stdized)"
label var mprparti_std "DW-1 Political Partisanship  (Stdized)"
#delimit ;
twoway (scatter googlepol_std year, xline(1877 1913 1933 1965 1995)
 text(3 1877 "Reconstruction Ends (1877)", place(e) )
 text(-3 1913 "Progressive Constitution (1913)", place(e) ) 
 text(2 1933 "New Deal (1933)", place(e) )
 text(-2 1965 "Voting Rights Act (1965)", place(e) )
 text(3 1995 "Republican House(1995)", place(e) ) 
 yscale(range (-3 3)) xscale(range (1870 2050)) legend(rows(2)) ) (line mprpol_std year, msymbol(o)) 
;

graph save googmprpol_year_nov_29_includingpost2001_2012.gph, replace;

twoway (scatter googleparti_std year, xline(1877 1914 1933 1965 1994)   
 text(3 1877 "Reconstruction Ends (1877)", place(e) )
 text(-3 1913 "Progressive Constitution (1913)", place(e) ) 
 text(2 1933 "New Deal (1933)", place(e) )
 text(-2 1965 "Voting Rights Act (1965)", place(e) )
 text(3 1995 "Republican House(1995)", place(e) ) 
 yscale(range (-3 3)) xscale(range (1870 2050)) legend(rows(2)) )
;
graph save googparti_year_nov_29_includingpost2001_2012.gph, replace;

twoway (scatter googleparti_std year, xline(1877 1914 1933 1965 1994)   
 text(3 1877 "Reconstruction Ends (1877)", place(e) )
 text(-3 1913 "Progressive Constitution (1913)", place(e) ) 
 text(2 1933 "New Deal (1933)", place(e) )
 text(-2 1965 "Voting Rights Act (1965)", place(e) )
 text(3 1995 "Republican House(1995)", place(e) ) 
 yscale(range (-3 3)) xscale(range (1870 2050)) legend(rows(2)) ) (line mprparti_std year, msymbol(o)) 
;
graph save googmprparti_year_nov_29_includingpost2001_2012.gph, replace;

twoway (scatter congpol_std year, xline(1877 1913 1933 1965 1995)
 text(3 1877 "Reconstruction Ends (1877)", place(e) )
 text(-3 1913 "Progressive Constitution (1913)", place(e) ) 
 text(2 1933 "New Deal (1933)", place(e) )
 text(-2 1965 "Voting Rights Act (1965)", place(e) )
 text(3 1995 "Republican House(1995)", place(e) ) 
 yscale(range (-3 3)) xscale(range (1870 2050)) legend(rows(2)) ) (line mprpol_std year, msymbol(o)) 
;
graph save congpol_year_nov_29_includingpost2001_2012.gph, replace;

twoway (scatter congparti_std year, xline(1877 1914 1933 1965 1994)   
 text(3 1877 "Reconstruction Ends (1877)", place(e) )
 text(-3 1913 "Progressive Constitution (1913)", place(e) ) 
 text(2 1933 "New Deal (1933)", place(e) )
 text(-2 1965 "Voting Rights Act (1965)", place(e) )
 text(3 1995 "Republican House(1995)", place(e) ) 
 yscale(range (-3 3)) xscale(range (1870 2050)) legend(rows(2)) )
;

graph save congparti_year_nov_29_includingpost2001_2012.gph, replace;

twoway (scatter congparti_std year, xline(1877 1914 1933 1965 1994)   
 text(3 1877 "Reconstruction Ends (1877)", place(e) )
 text(-3 1913 "Progressive Constitution (1913)", place(e) ) 
 text(2 1933 "New Deal (1933)", place(e) )
 text(-2 1965 "Voting Rights Act (1965)", place(e) )
 text(3 1995 "Republican House(1995)", place(e) ) 
 yscale(range (-3 3)) xscale(range (1870 2050)) legend(rows(2)) ) (line mprparti_std year, msymbol(o)) 
;
graph save congmprparti_year_nov_29_includingpost2001_2012.gph, replace;
#delimit cr
******************************now drop everything after 2000*****************************
*******************************************************************************************
drop if year >2000


#delimit ;
twoway (scatter googlepol_std year, xline(1877 1913 1933 1965 1995)
 text(3 1877 "Reconstruction Ends (1877)", place(e) )
 text(-3 1913 "Progressive Constitution (1913)", place(e) ) 
 text(2 1933 "New Deal (1933)", place(e) )
 text(-2 1965 "Voting Rights Act (1965)", place(e) )
 text(3 1995 "Republican House(1995)", place(e) ) 
 yscale(range (-3 3)) xscale(range (1870 2050)) legend(rows(2)) ) (line mprpol_std year, msymbol(o)) 
;

graph save googmprpol_year_nov_29_pre2001_2012.gph, replace;

twoway (scatter googleparti_std year, xline(1877 1914 1933 1965 1994)   
 text(3 1877 "Reconstruction Ends (1877)", place(e) )
 text(-3 1913 "Progressive Constitution (1913)", place(e) ) 
 text(2 1933 "New Deal (1933)", place(e) )
 text(-2 1965 "Voting Rights Act (1965)", place(e) )
 text(3 1995 "Republican House(1995)", place(e) ) 
 yscale(range (-3 3)) xscale(range (1870 2050)) legend(rows(2)) )
;
graph save googparti_year_nov_29_pre2001_2012.gph, replace;

twoway (scatter googleparti_std year, xline(1877 1914 1933 1965 1994)   
 text(3 1877 "Reconstruction Ends (1877)", place(e) )
 text(-3 1913 "Progressive Constitution (1913)", place(e) ) 
 text(2 1933 "New Deal (1933)", place(e) )
 text(-2 1965 "Voting Rights Act (1965)", place(e) )
 text(3 1995 "Republican House(1995)", place(e) ) 
 yscale(range (-3 3)) xscale(range (1870 2050)) legend(rows(2)) ) (line mprparti_std year, msymbol(o)) 
;
graph save googmprparti_year_nov_29_pre2001_2012.gph, replace;

twoway (scatter congpol_std year, xline(1877 1913 1933 1965 1995)
 text(3 1877 "Reconstruction Ends (1877)", place(e) )
 text(-3 1913 "Progressive Constitution (1913)", place(e) ) 
 text(2 1933 "New Deal (1933)", place(e) )
 text(-2 1965 "Voting Rights Act (1965)", place(e) )
 text(3 1995 "Republican House(1995)", place(e) ) 
 yscale(range (-3 3)) xscale(range (1870 2050)) legend(rows(2)) ) (line mprpol_std year, msymbol(o)) 
;
graph save congpol_year_nov_29_pre2001_2012.gph, replace;

twoway (scatter congparti_std year, xline(1877 1914 1933 1965 1994)   
 text(3 1877 "Reconstruction Ends (1877)", place(e) )
 text(-3 1913 "Progressive Constitution (1913)", place(e) ) 
 text(2 1933 "New Deal (1933)", place(e) )
 text(-2 1965 "Voting Rights Act (1965)", place(e) )
 text(3 1995 "Republican House(1995)", place(e) ) 
 yscale(range (-3 3)) xscale(range (1870 2050)) legend(rows(2)) )
;

graph save congparti_year_nov_29_pre2001_2012.gph, replace;

twoway (scatter congparti_std year, xline(1877 1914 1933 1965 1994)   
 text(3 1877 "Reconstruction Ends (1877)", place(e) )
 text(-3 1913 "Progressive Constitution (1913)", place(e) ) 
 text(2 1933 "New Deal (1933)", place(e) )
 text(-2 1965 "Voting Rights Act (1965)", place(e) )
 text(3 1995 "Republican House(1995)", place(e) ) 
 yscale(range (-3 3)) xscale(range (1870 2050)) legend(rows(2)) ) (line mprparti_std year, msymbol(o)) 
;
graph save congmprparti_year_nov_29_pre2001_2012.gph, replace;
#delimit cr
                      

twoway (scatter googlepol politicalviolencepermillion, mlabel(decade)) (lfit googlepol politicalviolencepermillion)
graph save "googpolviol_polarization_nov_29_pre2001_2012.gph", replace


twoway (scatter googleparti politicalviolencepermillion, mlabel(decade)) (lfit googleparti politicalviolencepermillion)
graph save googparti_polarization_nov_29_pre2001_2012.gph, replace


twoway (scatter googlepol casualtiesperhundredthousand, mlabel(decade) xscale(range(0 80))) (lfit googlepol casualtiesperhundredthousand)
graph save "googpolwar_polarization_nov_29_pre2001_2012.gph", replace


twoway (scatter googleparti casualtiesperhundredthousand, mlabel(decade) xscale(range(0 80))) (lfit googleparti casualtiesperhundredthousand)
graph save googpartiwar_polarization_nov_29_pre2001_2012.gph, replace


eststo clear
reg googlepol politicalviolencepermillion casualtiesperhundredthousand realgdpgrowth, robust
eststo
reg googlepol politicalviolencepermillion casualtiesperhundredthousand realgdpgrowth congpol, robust  
eststo
reg googlepol politicalviolencepermillion realgdpgrowth casualtiesperhundredthousand dem_house congpol mprpol_std, robust
eststo
reg googlepol politicalviolencepermillion realgdpgrowth casualtiesperhundredthousand dem_house congpol year, robust 
eststo
reg googleparti politicalviolencepermillion casualtiesperhundredthousand realgdpgrowth, robust
eststo
reg googleparti politicalviolencepermillion casualtiesperhundredthousand realgdpgrowth congparti, robust
eststo
reg googleparti politicalviolencepermillion realgdpgrowth casualtiesperhundredthousand dem_house congparti mprparti_std, robust
eststo
reg googleparti politicalviolencepermillion realgdpgrowth casualtiesperhundredthousand dem_house congparti year, robust 
eststo
esttab using "googlepol_violence_table_nov_29_pre2001_2012.csv", se replace label

type googlepol_violence_table_nov_29_pre2001_2012.csv


twoway (scatter MLI googlepol, mlabel(decade)) (lfit MLI  googlepol)
graph save "googlegeffmli_polarization_nov_29_pre2001_2012.gph", replace

twoway (scatter LPI googlepol, mlabel(decade)) (lfit LPI  googlepol)
graph save "googlegefflpi_polarization_nov_29_pre2001_2012.gph", replace


eststo clear
reg MLI googlepol_std, robust
eststo
reg MLI googlepol_std congpol_std mprpol_std, robust
eststo
reg MLI googlepol_std congpol_std mprpol_std politicalviolencepermillion realgdpgrowth casualtiesperhundredthousand dem_house, robust
eststo
reg LPI googlepol_std, robust
eststo
reg LPI googlepol_std congpol_std mprpol_std, robust
eststo
reg LPI googlepol_std congpol_std mprpol_std politicalviolencepermillion realgdpgrowth casualtiesperhundredthousand dem_house, robust
eststo
esttab using "googlelegeff_table_nov_29_pre2001_2012.csv", se replace label
