cd ..
clear all
set mem 1g
forval k=43(1)111 {
	tempfile temp`k'
}

forval k=43(1)111 {
insheet using "rawdata\Routput_replication\cong `k' _correlPredictions Tri .csv"
rename v1 name
rename v5 score
keep name allpredparty score 
sort name
g congress=`k'
tempfile temp`k'
save `temp`k'', replace
clear
}

use `temp43'
forval k=44(1)111 {
append using `temp`k''
}
*save "D:\Data\CongressionalRecord\factorloadings_classify\scoreallcongresses"

merge 1:1 name congress using "rawdata\actualallcongresses"

collapse (mean) score, by(actualparty congress)
g year=2011-(112-congress)*2
twoway (scatter score year if actualparty==1, sort mcolor(red) ) (scatter score year if actualparty==-1, sort mcolor(midblue) msymbol(Oh)), xscale(range(1870 2008)) xmtick(1870(10)2008) xline(1937) xlabel(2005 1913 1937) xline(2005 1937 1913) ytitle(Score) xtitle(Year) legend(lab(1 "Republicans") lab(2 "Democrats")) title(Average Partisanship by Congress) subtitle(for Republicans and Democrats)
graph save "Pics_Tables\dwnominatereplicationgraph.gph"
graph export "Pics_Tables\dwnominatereplicationgraph.png"
