	clear all
	set mem 10g
	set more off
	use phrase23_panel_replication.dta, clear

	
	drop if googlefreq==.
	tsset phraseno congress
	tsfill, full
	egen overallgfreq=mean(overallgooglefreq), by(phrase_name)
	drop overallgooglefreq
	replace freq=0 if freq==.



	gen absidcorr=abs(plscorrparty_trimmed)
	
	label var plscorrparty_trimmed "Phrase Partisanship"
	label var absidcorr "Phrase Polarization"

	
	/****link in topic phrases****/
			
	sort phrase_name
	merge m:1 phrase_name using "rawdata\topics_sept_27_2012.dta", gen(mergetopics)
	global vars "economic_broad economic_narrow social war"
	foreach j of global vars {
		replace `j'=0 if `j'==.

	}


	egen meanparti=mean(plscorrparty_trimmed), by(phrase_name)
	egen meanpol=mean(absidcorr), by(phrase_name)
	drop if meanpol==.
	tsset phraseno congress
			
	egen summedfreq=sum(freq), by(congress)
	gen relativefreq=freq/summedfreq
	g oldfreq=freq
	gen cfreq=relativefreq
	drop relativefreq sumfreq
			
	label var googlefreq "Google Freq. t"
	label var cfreq "Congress Freq. t"


			
egen phrasenum = group(phrase_name)			

xi i.year


/****generate polarization quartiles, omitting lowest one****/
sum meanpol,d
gen pctile2550meanpol=meanpol > `r(p25)' & meanpol < `r(p50)'
gen pctile5075meanpol=meanpol > `r(p50)' & meanpol < `r(p75)'
gen pctile75100meanpol= meanpol > `r(p75)' &meanpol!=.


gen googlefreqXpctile2550meanpol =pctile2550meanpol*googlefreq
label var googlefreqXpctile2550meanpol "Google Freq. t X 25-50pctile Pol"
gen googlefreqXpctile5075meanpol =pctile5075meanpol*googlefreq
label var googlefreqXpctile5075meanpol "Google Freq. t X 50-75pctile Pol"
gen googlefreqXpctile75100meanpol =pctile75100meanpol*googlefreq
label var googlefreqXpctile75100meanpol "Google Freq. t X 75-100pctile Pol"



gen cfreqXpctile2550meanpol =pctile2550meanpol*cfreq
label var cfreqXpctile2550meanpol "Congress Freq. t X 25-50pctile Pol"
gen cfreqXpctile5075meanpol =pctile5075meanpol*cfreq
label var cfreqXpctile5075meanpol "Congress Freq. t X 50-75pctile Pol"
gen cfreqXpctile75100meanpol =pctile75100meanpol*cfreq
label var cfreqXpctile75100meanpol "Congress Freq. t X 75-100pctile Pol"
/****generate lags***/
forvalues i =1/3{
			gen L`i'googlefreq = L`i'.googlefreq
			label var L`i'googlefreq "Google Freq. t-`i'"
			gen F`i'googlefreq = F`i'.googlefreq
			label var F`i'googlefreq "Google Freq. t+`i'"
			
			
			gen L`i'cfreq = L`i'.cfreq
			label var L`i'cfreq "Congress Freq. t-`i'"
			
			gen F`i'cfreq = F`i'.cfreq 
			label var F`i'cfreq "Congress Freq. t+`i'"
	
	
			gen L`i'googlefreqXpctile2550meanpol =L`i'.googlefreqXpctile2550meanpol
			label var L`i'googlefreqXpctile2550meanpol "Google Freq.X 25-50pctile Pol t-`i'"
			gen L`i'googlefreqXpctile5075meanpol =L`i'.googlefreqXpctile5075meanpol
			label var L`i'googlefreqXpctile5075meanpol "Google Freq.X 50-75pctile Pol t-`i'"
			gen L`i'googlefreqXpctile75100meanpol =L`i'.googlefreqXpctile75100meanpol
			label var L`i'googlefreqXpctile75100meanpol "Google Freq.X 75-100pctile Pol t-`i'"
			
			gen L`i'cfreqXpctile2550meanpol =L`i'.cfreqXpctile2550meanpol
			label var L`i'cfreqXpctile2550meanpol "Cong Freq.X 25-50pctile Pol t-`i'"
			gen L`i'cfreqXpctile5075meanpol =L`i'.cfreqXpctile5075meanpol
			label var L`i'cfreqXpctile5075meanpol "Cong Freq.X 50-75pctile Pol t-`i'"
			gen L`i'cfreqXpctile75100meanpol =L`i'.cfreqXpctile75100meanpol
			label var L`i'cfreqXpctile75100meanpol "Cong Freq.X 75-100pctile Pol t-`i'"
						
		
}






save bigphrase23panel_replication.dta, replace

